#include <gtk/gtk.h>
#include <stdio.h>

#include "raft_config.h"
#include "raft_cmd.h"
#include "raft_interface.h"

#include "gnome.h"


extern Raft_launcher *raft_launcher;
extern Raft_info raft_info;

void raft_interface_quit_all(void)
{
    gtk_main_quit();
}

/* go through the raft_launcher linked list of buttons created from config file
 * and display them all */

void raft_interface_toggle_launcher (GtkWidget *button, gpointer *data)
{    
    if (raft_info.expanded) {
	raft_interface_hide_launcher();
    } else {
	raft_interface_show_launcher();
    }
}

static gint raft_interface_button_press_event(GtkWidget *widget, GdkEventButton *event,
					      gpointer data)
{
    if ((event->type == GDK_BUTTON_PRESS) &&
	(event->button == 3))
	    raft_config_interface_show ();

    return FALSE;
}
			    

static void raft_interface_create_launcher()
{
    Raft_launcher *rl;
    GtkWidget *button;
    
    rl = raft_launcher;

    rl->xpm_file = gnome_file_from_datadir ("pixmaps/expand.xpm");
    rl->label_text = NULL;
    rl->tooltips_text = "Press left mouse button to expand, right to configure.";
    rl->command = NULL;
    
    button = raft_interface_button_new(rl);
    
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(raft_interface_toggle_launcher), NULL);

    gtk_signal_connect (GTK_OBJECT(button), "button_press_event",
			GTK_SIGNAL_FUNC (raft_interface_button_press_event), NULL);
     
    gtk_box_pack_start(GTK_BOX(raft_info.main_box), button, TRUE, TRUE, 1);
    gtk_widget_show(button);
    
    while (rl->next != NULL) {
	rl = rl->next;
    
	rl->button = raft_interface_button_new(rl);
	
	gtk_signal_connect(GTK_OBJECT(rl->button), "clicked",
			   GTK_SIGNAL_FUNC(raft_cmd_execute), rl->command);
	
	gtk_box_pack_start(GTK_BOX(raft_info.main_box), rl->button, TRUE, TRUE, 1);
    
	gtk_widget_show(rl->button);
    }
}

void raft_interface_hide_launcher(void)
{
    Raft_launcher *rl;

    if (raft_info.expanded == FALSE)
	    return;
    
    raft_info.expanded = FALSE;
    
    rl = raft_launcher;
    
    while (rl->next != NULL) {
	rl = rl->next;
	gtk_widget_hide(rl->button);
    }
}

void raft_interface_show_launcher(void)
{
    Raft_launcher *rl;
    
    rl = raft_launcher;

    if (raft_info.expanded == TRUE)
	    return;

    raft_info.expanded = TRUE;
    
    while (rl->next != NULL) {
	rl = rl->next;
	gtk_widget_show(rl->button);
    }
}


/* utility function */

GtkWidget *raft_interface_pixmap_new (GtkWidget *parent, gchar *xpm_filename)
{
    GtkWidget *pixmapwid;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    GtkStyle *style;

    style = gtk_widget_get_style(parent);
    
    /* now on to the xpm stuff.. load xpm */
    pixmap = gdk_pixmap_create_from_xpm (parent->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 xpm_filename);
    pixmapwid = gtk_pixmap_new (pixmap, mask);
    return(pixmapwid);
}       

/* this will be the function used to create all new buttons.  A NULL in any position
 * will cause it not to be created. */

GtkWidget *raft_interface_button_new(Raft_launcher *rl)
{
    rl->button = gtk_button_new();
    
    gtk_widget_set_name(rl->button, "Launcher button");
    
    /* create box for xpm and label */
    rl->box = gtk_vbox_new (FALSE, 1);
    gtk_container_border_width (GTK_CONTAINER (rl->box), 0);
    
    /* put in the pixmap */
    raft_interface_launcher_pixmap_new(rl);
    /* make the new label */
    raft_interface_launcher_label_new(rl);
    /* and the tooltip */
    raft_interface_launcher_tooltip_new(rl);
    
    gtk_container_add (GTK_CONTAINER (rl->button), rl->box);
    
    gtk_widget_show (rl->box);
        
    return(rl->button);
}

/* this checks if there's an old pixmap, destroys it if there is, and
 * installs a new one. */
void raft_interface_launcher_tooltip_new(Raft_launcher *rl)
{
    if (rl->tooltip) {
	gtk_tooltips_destroy(rl->tooltip);
	rl->tooltip = NULL;
    }
    
    if (rl->tooltips_text) {
	/* add tooltips */
	rl->tooltip = gtk_tooltips_new();
	gtk_tooltips_set_tips(rl->tooltip, rl->button, rl->tooltips_text);
    }
}

/* this checks if there's an old pixmap, destroys it if there is, and
 * installs a new one. */
void raft_interface_launcher_pixmap_new(Raft_launcher *rl)
{
    gchar buf[1024];
    gchar *file = NULL;
    
    if (rl->pixmap) {
	gtk_widget_destroy(rl->pixmap);
	rl->pixmap = NULL;
    }

    if (rl->xpm_file == NULL)
	    return;

    file = g_strdup (rl->xpm_file);

    if (gnome_file_exists (rl->xpm_file))
	    goto found_file;
    g_free(file);
    
    sprintf(buf, "pixmaps/%s", rl->xpm_file);
    file = gnome_file_from_datadir (buf);

    if (gnome_file_exists (file))
	    goto found_file;
    g_free(file);
    
    sprintf(buf, "pixmaps/%s", rl->xpm_file);
    file = gnome_file_from_home_dir (buf);
    if (gnome_file_exists (file))
	    goto found_file;
    g_free(file);
    
    /* file not found.. just silently return. */
    return;
    
found_file:
	
    rl->pixmap = raft_interface_pixmap_new (rl->box, file);
    gtk_box_pack_start (GTK_BOX (rl->box), rl->pixmap, FALSE, FALSE, 3);
    gtk_widget_show(rl->pixmap);
    g_free(file);
}

/* this checks if there's an old label, destroys it if there is, and
 * installs a new one. */
void raft_interface_launcher_label_new(Raft_launcher *rl)
{
    if (rl->label) {
	gtk_widget_destroy(rl->label);
	rl->label = NULL;
    }
    
    if (rl->label_text) {
	/* create label for button */
	rl->label = gtk_label_new (rl->label_text);
	gtk_box_pack_start (GTK_BOX (rl->box), rl->label, FALSE, FALSE, 3);
	gtk_widget_show(rl->label);
    }
}

void raft_interface_create_main_window (void)
{
    /* create a new window */
    raft_info.window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    
    gtk_widget_set_name (raft_info.window, "Launcher");
    gtk_window_set_title (GTK_WINDOW(raft_info.window), "raft");
    gtk_widget_set_uposition (raft_info.window, raft_info.x_position,
			      raft_info.y_position);
    
    gtk_signal_connect(GTK_OBJECT(raft_info.window), "destroy",
		       GTK_SIGNAL_FUNC(raft_interface_quit_all), NULL);

    /* set autoshrink */
    gtk_window_set_policy(GTK_WINDOW(raft_info.window), TRUE, TRUE, TRUE);
    
    /* create the main box that all items will go into */
    raft_info.main_box = gtk_vbox_new (FALSE, 0);
    gtk_container_border_width (GTK_CONTAINER (raft_info.main_box), 2);
    gtk_container_add (GTK_CONTAINER (raft_info.window), raft_info.main_box);
    gtk_widget_show (raft_info.main_box);
    
    /* pack all the buttons into the hbox */
    raft_interface_create_launcher();

    /* It starts expanded so.. */
    raft_info.expanded = TRUE;

    gtk_widget_show (raft_info.window);
}

