#include "obgtkPreview.h"

@implementation Gtk_Preview
- initWithPreviewInfo:(GtkPreviewType) type
{
  return [self castGtkPreview:GTK_PREVIEW(gtk_preview_new(type))];
}

- castGtkPreview:(GtkPreview *) castitem
{
  gtkpreview = castitem;
  return [super castGtkWidget:GTK_WIDGET(castitem)];
}

- size:(gint) width
      :(gint) height
{
  gtk_preview_size(gtkpreview, width, height);
  return self;
}

- put:(GdkWindow *)window
     :(GdkGC *) gc
     :(gint) srcx
     :(gint) srcy
     :(gint) destx
     :(gint) desty
     :(gint) width
     :(gint) height
{
  gtk_preview_put(gtkpreview, window, gc, srcx, srcy, destx, desty,
		  width, height);
  return self;
}

- put_row:(guchar *) src
	 :(guchar *) dest
	 :(gint) x
	 :(gint) y
	 :(gint) w
{
  gtk_preview_put_row(gtkpreview, src, dest, x, y, w);
  return self;
}

- draw_row:(guchar *) data
	  :(gint) x
	  :(gint) y
	  :(gint) w
{
  gtk_preview_draw_row(gtkpreview, data, x, y, w);
  return self;
}

- set_expand:(gint) expand
{
  gtk_preview_set_expand(gtkpreview, expand);
  return self;
}

- set_gamma:(double) gamma
{
  gtk_preview_set_gamma(gamma);
  return self;
}

- set_color_cube:(guint) nred_shades
		:(guint) ngreen_shades
		:(guint) nblue_shades
		:(guint) ngray_shades
{
  gtk_preview_set_color_cube(nred_shades, ngreen_shades,
			     nblue_shades, ngray_shades);
  return self;
}

- set_install_cmap:(gint) install_cmap
{
  gtk_preview_set_install_cmap(install_cmap);
  return self;
}

- set_reserved:(gint) nreserved
{
  gtk_preview_set_reserved(nreserved);
  return self;
}

- (GdkVisual *) get_visual
{
  return gtk_preview_get_visual();
}

- (GdkColormap *) get_cmap
{
  return gtk_preview_get_cmap();
}

- (GtkPreviewInfo *) get_info
{
  return gtk_preview_get_info();
}

- reset
{
  gtk_preview_reset();
  return self;
}

- uninit
{
  gtk_preview_uninit();
  return self;
}
@end
