#include <gnome.h>
#include "properties.h"
#include "procbar.h"
#include "procview.h"

static GtkWidget *win = NULL;

static gchar *cpu_texts [4] =  { N_("User"),  N_("Nice"),   N_("System"),  N_("Idle")};
static gchar *mem_texts [4] =  { N_("Other"), N_("Shared"), N_("Buffers"), N_("Free")};
static gchar *swap_texts [2] = { N_("Used"),  N_("Free") };

static void
properties_close (void)
{
	win = NULL;
}

void
gtop_properties (void)
{
	GtkWidget *vb, *vbox, *frame, *label, *hbox, *spin, *table;

	if (win) {
		gdk_window_raise (win->window);

		return;
	}
	
	win = gnome_property_box_new ();

	vb    = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vb), GNOME_PAD_SMALL);
	vbox  = gtk_vbox_new (FALSE, 0);

	frame = gtk_frame_new (_("Update times (ms)"));
	table = gtk_table_new (2, 2, FALSE);
	gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);
	gtk_container_border_width (GTK_CONTAINER (table), GNOME_PAD_SMALL);

	label = gtk_label_new (_("Processes list"));
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);

	spin = gtk_spin_button_new (NULL, 1, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), spin, 1, 2, 0, 1);

	label = gtk_label_new (_("Summary"));
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);

	spin = gtk_spin_button_new (NULL, 1, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), spin, 1, 2, 1, 2);

	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start_defaults (GTK_BOX (vb), frame);

	frame = gtk_frame_new ("");
	table = gtk_table_new (2, 4, FALSE);
	gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD << 2);

	label = gtk_check_button_new_with_label (_("Show graphical summary"));
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 2, 0, 1);

	label = gtk_check_button_new_with_label (_("Show cpu usage"));
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 1, 2);
	label = gtk_check_button_new_with_label (_("Show physical memory usage"));
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 2, 3);
	label = gtk_check_button_new_with_label (_("Show swap memory usage"));
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 3, 4);

	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start_defaults (GTK_BOX (vb), frame);

	frame = gtk_frame_new ("");
	table = gtk_table_new (2, 3, FALSE);
	gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD << 2);

	label = gtk_check_button_new_with_label (_("Show text summary"));
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 2, 0, 1);

	label = gtk_check_button_new_with_label (_("Show uptime"));
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 1, 2);
	label = gtk_check_button_new_with_label (_("Show processes counts"));
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 2, 3);

	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start_defaults (GTK_BOX (vb), frame);

	gnome_property_box_append_page (GNOME_PROPERTY_BOX (win), vb,
					gtk_label_new (_("Processes")));

	
	vb = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vb), GNOME_PAD_SMALL);
	
	frame = gtk_frame_new (_("Summary CPU"));
	gtk_container_add (GTK_CONTAINER (frame),
			   gnome_proc_bar_properties (GNOME_PROC_BAR (summary_cpu), _(cpu_texts)));
	gtk_box_pack_start (GTK_BOX (vb), frame, FALSE, TRUE, 0);

	frame = gtk_frame_new (_("Summary physical memory"));
	gtk_container_add (GTK_CONTAINER (frame),
			   gnome_proc_bar_properties (GNOME_PROC_BAR (summary_mem), _(mem_texts)));
	gtk_box_pack_start (GTK_BOX (vb), frame, FALSE, TRUE, 0);

	frame = gtk_frame_new (_("Summary swap memory"));
	gtk_container_add (GTK_CONTAINER (frame),
			   gnome_proc_bar_properties (GNOME_PROC_BAR (summary_swap), _(swap_texts)));
	gtk_box_pack_start (GTK_BOX (vb), frame, FALSE, TRUE, 0);

	gnome_property_box_append_page (GNOME_PROPERTY_BOX (win), vb,
					gtk_label_new (_("Summary colors")));

	gtk_signal_connect (GTK_OBJECT (win), "destroy",
			    GTK_SIGNAL_FUNC(properties_close), NULL);
	
	gtk_widget_show_all (win);
}
