/*****************             Electirc Eyes           ***********************/
/* This software is Copyright (C) 1998 but The Rasterman (Carsten Haitzler). */
/* This software falls under the GNU Public License. Please read the COPYING */
/* file for more information                                                 */
/*****************************************************************************/
#include "ee.h"

void init_list()
{
   image_list=NULL;
}

void add_category_to_file(char *file, char *category)
{
   struct _image *current_image;
   int i,num,j;
   GList *gl;

   num=g_list_length(image_list);
   for(i=0;i<num;i++)
     {
	gl=g_list_nth(image_list,i);
	current_image=(struct _image *)gl->data;
	if (!strcmp(file,current_image->file)) 
	  {
	     for(j=0;j<current_image->num_categories;j++)
	       {
		  if (!strcmp(category,current_image->categories[j]))
		    return;
		  current_image->num_categories++;
		  current_image->categories=realloc(current_image->categories,
						    current_image->num_categories*
						    sizeof(char *));
		  current_image->categories[current_image->num_categories-1]=
		    strdup(category);
	       }
	  }
     }
}

void del_category_from_file(char *file, char *category)
{
   struct _image *current_image;
   int i,num,j,k;
   GList *gl;

   num=g_list_length(image_list);
   for(i=0;i<num;i++)
     {
	gl=g_list_nth(image_list,i);
	current_image=(struct _image *)gl->data;
	if (!strcmp(file,current_image->file)) 
	  {
	     for(j=0;j<current_image->num_categories;j++)
	       {
		  if (!strcmp(category,current_image->categories[j]))
		    {
		       current_image->num_categories--;
		       for(k=j;k<current_image->num_categories;k++)
			 current_image->categories[k]=
			 current_image->categories[k+1];
		       current_image->categories=realloc(current_image->categories,
							 current_image->num_categories*
							 sizeof(char *));
		       return;
		    }
	       }
	  }
     }
}

int add_file_to_list(char *file)
{
   struct _image *new_image,*current_image;
   int i,num,ok=0;
   GList *gl;
   char **dir;
   char s[10240];
   
   if (isdir(file))
     {
	dir=ls(file,&num);
	if ((num>1)&&(dir))
	  {
	     for(i=0;i<num;i++)
	       {
		  if ((strcmp(dir[i],"."))&&(strcmp(dir[i],"..")))
		    {
		       snprintf(s,10240,"%s/%s",file,dir[i]);
		       ok|=add_file_to_list(s);
		    }
	       }
	     freestrlist(dir,num);
	  }
	return ok;
     }
   num=g_list_length(image_list);
   for(i=0;i<num;i++)
     {
	gl=g_list_nth(image_list,i);
	current_image=(struct _image *)gl->data;
	if (!strcmp(file,current_image->file)) return;
     }
   new_image=malloc(sizeof(struct _image));
   if (!new_image) return;
   
   new_image->file=strdup(file);
   new_image->num_categories=0;
   new_image->categories=NULL;
   new_image->thumb=NULL;
   image_list=g_list_append(image_list,new_image);
   sel_thumb(file);
   add_thumb(file);
   if (list) add_file_to_clist(file);
   return 1;
}

int del_file_from_list(char *file)
{
   struct _image *current_image;
   int i,num,j;
   GList *gl;

   del_thumb(file);
   if (list)
     del_file_from_clist(current.info->file);
   num=g_list_length(image_list);
   for(i=0;i<num;i++)
     {
	gl=g_list_nth(image_list,i);
	current_image=(struct _image *)gl->data;
	if (!strcmp(file,current_image->file)) 
	  {
	     image_list=g_list_remove_link(image_list,gl);
	     free(current_image->file);
	     if (current_image->thumb)
	       gtk_widget_destroy(current_image->thumb);
	     for(j=0;j<current_image->num_categories;j++)
	       free(current_image->categories[j]);
	     if (current_image->categories)
	       free(current_image->categories);
	     free(current_image);
	     g_list_free_1(gl);
	     return;
	  }
     }
}

struct _image *get_file_from_list(char *file)
{
   struct _image *current_image;
   int i,num,j;
   GList *gl;

   num=g_list_length(image_list);
   for(i=0;i<num;i++)
     {
	gl=g_list_nth(image_list,i);
	current_image=(struct _image *)gl->data;
	if (!strcmp(file,current_image->file)) 
	  return current_image;
     }
}

int get_file_number_from_list(char *file)
{
   struct _image *current_image;
   int i,num,j;
   GList *gl;

   num=g_list_length(image_list);
   for(i=0;i<num;i++)
     {
	gl=g_list_nth(image_list,i);
	current_image=(struct _image *)gl->data;
	if (!strcmp(file,current_image->file)) 
	  return i;
     }
}

struct _image *get_file_n_from_list(int n)
{
   GList *gl;
   int num;
   
   num=g_list_length(image_list);
   if ((n>num)||(n<0)) return NULL;
   gl=g_list_nth(image_list,n);
   return (struct _image *)gl->data;
}

int get_list_length()
{
   return (int)g_list_length(image_list);
}

void add_file_to_clist(char *file)
{
   char *s;
   
   s=fullfileof(file);
   gtk_clist_append(GTK_CLIST(list),&s);
   free(s);
}

void del_file_from_clist(char *file)
{
   struct _image *current_image;
   int i,num;
   GList *gl;

   num=g_list_length(image_list);
   for(i=0;i<num;i++)
     {
	gl=g_list_nth(image_list,i);
	current_image=(struct _image *)gl->data;
	if (!strcmp(file,current_image->file)) 
	  {
	     gtk_clist_remove(GTK_CLIST(list),i);
	     return;
	  }
     }
}

void sync_list_to_clist()
{
   struct _image *new_image,*current_image;
   int i,num;
   GList *gl;
   
   num=g_list_length(image_list);
   for(i=0;i<num;i++)
     {
	gl=g_list_nth(image_list,i);
	current_image=(struct _image *)gl->data;
	add_file_to_clist(current_image->file);
     }
}
