/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _STRUCTS_H_
#define _STRUCTS_H_

#include <gmp.h>

struct tree_struct;

/*dictionary function structure*/
typedef enum {BUILTIN_FUNC,USER_FUNC} func_type_t;
typedef struct {
	func_type_t type;
	char *id;
	int args;
	union {
		struct tree_struct *value;
		struct tree_struct *(*func)(struct tree_struct * *);
	} data;
} func_t;

/*evaluation tree structure*/
typedef enum {NUMBER_NODE,ACTION_NODE} node_type_t;
typedef enum {INTEGER_TYPE,FLOAT_TYPE,RATIONAL_TYPE} num_type_t;
typedef enum {PRIMITIVE_TYPE,FUNCTION_TYPE} op_type_t;
typedef struct tree_struct {
	node_type_t type;
	union {
		struct {
			num_type_t type;
			union {
				mpz_t ival;
				mpf_t fval;
				mpq_t rval;
			} data;
		} number;
		struct {
			op_type_t type;
			union {
				int primitive;
				struct {
					func_t * func;
					struct tree_struct * * args;
				} function;
			} data;
		} action;
	} data;
	struct tree_struct *left;
	struct tree_struct *right;
} tree_t;

#endif
