/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

%{
#include <gmp.h>
#include <glib.h>
#include <string.h>
#include "eval.h"
#include "dict.h"
#include "parse.h"
%}

%s NEGATIVE

%%

<NEGATIVE>-[0-9]*\.[0-9]+[e@]-?[0-9]+	|
<NEGATIVE>-[0-9]+[e@]-?[0-9]+		|
<NEGATIVE>-[0-9]*\.[0-9]+	{
			mpf_init_set_str(yylval.fval,yytext,10);
			return NEGFLOAT;
		}

[0-9]*\.[0-9]+[e@]-?[0-9]+	|
[0-9]+[e@]-?[0-9]+		|
[0-9]*\.[0-9]+	{
			mpf_init_set_str(yylval.fval,yytext,10);
			return FLOAT;
		}

<NEGATIVE>-[1-9][0-9]*#[0-9a-zA-Z]+#	{
			char *s;
			int base;

			s=g_malloc(strlen(yytext)-2); /*minus 3 and plus 1*/
			sscanf(yytext,"-%d#%[0-9a-zA-Z]s#",&base,s);
			mpz_init_set_str(yylval.ival,s,base);
			mpz_neg(yylval.ival,yylval.ival);
			return NEGNORMINT;
		}

[1-9][0-9]*#[0-9a-zA-Z]+#	{
			char *s;
			int base;

			s=g_malloc(strlen(yytext)-2); /*minus 3 and plus 1*/
			sscanf(yytext,"%d#%[0-9a-zA-Z]s#",&base,s);
			mpz_init_set_str(yylval.ival,s,base);
			return NORMINT;
		}

<NEGATIVE>-0x[0-9a-fA-F]+	|
<NEGATIVE>-0[0-7]+	|
<NEGATIVE>-[0-9]+		{
			mpz_init_set_str(yylval.ival,yytext,0);
			return NEGNORMINT;
		}

0x[0-9a-fA-F]+	|
0[0-7]+		|
[0-9]+		{
			mpz_init_set_str(yylval.ival,yytext,0);
			return NORMINT;
		}

~		return NEG;

infix		BEGIN INITIAL; return INFIX_EXPR;

postfix		BEGIN NEGATIVE; return POSTFIX_EXPR;

prefix		BEGIN NEGATIVE; return PREFIX_EXPR;

=		return EQUALS;

[a-zA-Z][a-zA-Z0-9]*	{
				/* we need to find out the number of arguments
				   for this function */
				func_t *n;

				n=d_lookup(yytext);
				if(!n) {
					yylval.id=(char *)
						g_malloc(strlen(yytext)+1);
					strcpy(yylval.id,yytext);
					return UNKNOWNID;
				}

				yylval.func=n;
				switch(n->args) {
					case 0: return FUNCID0;
					case 1: return FUNCID1;
					case 2: return FUNCID2;
					case 3: return FUNCID3;
					case 4: return FUNCID4;
					case 5: return FUNCID5;
					case 6: return FUNCID6;
					case 7: return FUNCID7;
					case 8: return FUNCID8;
				}
				/*too many args or corrupted entry, this
				  shouldn't happen, and this is not a way
				  to deal with it, but oh well, for now*/
				REJECT;
			}

[ \t\n\r]+	; /*ignore whitespace*/

.		{ return yytext[0]; }

%%
