/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _DICT_H_
#define _DICT_H_

/*declarations of structures*/
#include "structs.h"

#define DICT_LEN 256

typedef tree_t *(*dictfunc)(tree_t * *);

/*functions for manipulating a tree*/
func_t * d_makebifunc(char *id, dictfunc f, int args); /*create builtin*/
func_t * d_makeufunc(char *id, tree_t *value, int args); /*create user*/

int d_addfunc(func_t *func);

/*dictionary functions*/
func_t *d_lookup(char *id);
int d_delete(char *id);

/*memory free function*/
void freefunc(func_t *n);

/*replace old with stuff from new and free new*/
void replacefunc(func_t *old,func_t *new);

#endif
