#include "obgtk.h"

@implementation Gtk_Range
- castGtkRange:(GtkRange *) castitem
{
  gtkrange = castitem;
  return [super castGtkWidget:GTK_WIDGET(castitem)];
}

- (Gtk_Adjustment *) get_adjustment
{
  return [[Gtk_Adjustment alloc] castGtkAdjustment:GTK_ADJUSTMENT(gtk_range_get_adjustment(gtkrange))];
}

- set_update_policy:(GtkUpdateType) policy
{
  gtk_range_set_update_policy(gtkrange, policy);
  return self;
}

- set_adjustment:(Gtk_Adjustment *) adjustment
{
  gtk_range_set_adjustment(gtkrange, adjustment->gtkadjustment);
  return self;  
}

- draw_background
{
  gtk_range_draw_background(gtkrange);
  return self;
}

- draw_trough
{
  gtk_range_draw_trough(gtkrange);
  return self;
}

- draw_slider
{
  gtk_range_draw_slider(gtkrange);
  return self;
}

- draw_step_forward
{
  gtk_range_draw_step_forw(gtkrange);
  return self;
}

- draw_step_backward
{
  gtk_range_draw_step_back(gtkrange);
  return self;
}

- slider_update
{
  gtk_range_slider_update(gtkrange);
  return self;
}

- trough_click:(gint) x
	  locY:(gint) y
{
  gtk_range_trough_click(gtkrange, x, y);
  return self;
}

- (gfloat) calc_value:(gint) position
{
  return gtk_range_calc_value(gtkrange, position);
}
@end
