/*	Copyright (C) 1997 Marius Vollmer
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GUILE_GTK_H
#define GUILE_GTK_H

#include <libguile.h>
#include <gtk/gtk.h>

typedef struct _sgtk_enum_literal {
  char *name;
  int value;
} sgtk_enum_literal;

typedef struct _sgtk_enum_info {
  char *name;
  int n_literals;
  sgtk_enum_literal *literals;
} sgtk_enum_info;

typedef struct _sgtk_boxed_info {
  char *name;
  void *(*copy) (void *);
  void (*destroy) (void *);
  size_t size;
} sgtk_boxed_info;

extern sgtk_enum_info sgtk_enum_infos[];
extern sgtk_enum_info sgtk_flags_infos[];
extern sgtk_boxed_info sgtk_boxed_infos[];

SCM sgtk_wrap_gtkobj (GtkObject *obj);
int sgtk_is_a_gtkobj (guint type, SCM obj);
GtkObject *sgtk_get_gtkobj (SCM obj);

int sgtk_valid_enum (SCM obj, sgtk_enum_info*);
SCM sgtk_enum2scm (gint val, sgtk_enum_info*);
gint sgtk_scm2enum (SCM obj, sgtk_enum_info*);

int sgtk_valid_flags (SCM obj, sgtk_enum_info*);
SCM sgtk_flags2scm (gint val, sgtk_enum_info*);
gint sgtk_scm2flags (SCM obj, sgtk_enum_info*);

SCM sgtk_boxed2scm (gpointer ptr, sgtk_boxed_info*, int copyp);
void *sgtk_scm2boxed (SCM obj);
int sgtk_valid_boxed (SCM obj, sgtk_boxed_info*);

int sgtk_valid_float (SCM obj);
gfloat sgtk_scm2float (SCM obj);
SCM sgtk_float2scm (gfloat f);

SCM sgtk_protect_scm (SCM);
void sgtk_unprotect_scm (SCM);

void sgtk_callback_marshal (GtkObject *,
			    gpointer data,
			    gint n_args,
			    GtkArg *args);
void sgtk_callback_destroy (gpointer data);

SCM sgtk_arg2scm (GtkArg *a);
void sgtk_scm2arg (GtkArg *a, SCM obj);

SCM sgtk_color_conversion (SCM color);
SCM sgtk_font_conversion (SCM color);
SCM sgtk_string_conversion (SCM string);

void sgtk_init (int *argcp, char ***argvp);
void sgtk_init_argv (int argc, char **argv);
void scm_init_toolkits_gtkstubs_module ();

/* emergency fixes */
typedef int GtkWidgetFlags;
#define GTK_WIDGET_FLAGS GTK_OBJECT_FLAGS

#endif /* !GUILE_GTK_H */
