#include "obgtk.h"

#include <objc/objc-api.h>
#include <string.h>
#include <stdlib.h>

/* #define DEBUG 1 */

static void
obgtk_signal_relay(GtkObject *object,
		   gpointer data,
		   gint nparams,
		   GtkArg *args)
{
  id anobj, sigobj;
  char *selname;
  IMP callfunc;
  SEL callsel;
  g_return_if_fail(object != NULL);
  g_return_if_fail(data != NULL);

  sigobj = gtk_object_get_data(object, "objc_id");
  anobj = gtk_object_get_data(object, "obgtk_signal_object");

  if(!anobj)
    anobj = sigobj;

  if(!anobj)
    return;

  selname = malloc(strlen(data) + 10);
  sprintf(selname, "%s:", (char *)data);
  callsel = sel_get_uid(selname);
  if(!callsel) {
    free(selname);
    return;
  }
  callfunc = objc_msg_lookup(anobj, callsel);
#ifdef DEBUG
  printf("Call to method %s on %#x\n", data, anobj);
#endif
  if(callfunc)
    callfunc(anobj, callsel, sigobj);
#ifdef DEBUG
  else
    objc_error(anobj, 99, "Couldn't find method %s on object.", data);
#endif
  free(selname);
}

@implementation Gtk_Object
- init
{
  self = [super init];
  gtkobject = NULL;
  objc_error(self, 99, "Call to [Gtk_Object init] - probably not calling subclass initFooBlah\n");
  return self;
}

- castGtkObject:(GtkObject *)castitem
{
  self = [super init];
  gtkobject = castitem;
  gtk_object_ref(gtkobject);
  gtk_object_set_data(gtkobject, "objc_id", self);
  // We do nothing here, since we aren't allowing people to
  // instantiate a GtkObject per se, only a subclass
  return self;
}

- connect:(gchar *) signal_name
{
  gtk_object_remove_data(gtkobject, "obgtk_signal_object");
  gtk_signal_connect_interp(gtkobject, signal_name,
			    (GtkCallbackMarshal) obgtk_signal_relay,
			    signal_name, NULL, 1);
  return self;
}

- connectObj:(gchar *) signal_name
	    :(id) signalObject
{
  gtk_object_set_data(gtkobject, "obgtk_signal_object", signalObject);
  gtk_signal_connect_interp(gtkobject, signal_name,
			    (GtkCallbackMarshal) obgtk_signal_relay,
			    signal_name, NULL, 1);
  return self;
}

- signal_connect:(gchar *) signal_name
      signalFunc:(GtkSignalFunc) signalfunc
	funcData:(gpointer) funcdata
{
  gtk_signal_connect(gtkobject, signal_name, signalfunc, funcdata);
  return self;
}

- free
{
  gtk_object_remove_data(gtkobject, "objc_id");
  gtk_object_unref(gtkobject);
  gtk_object_destroy(gtkobject);
  return [super free];
}

- set_user_data:(gpointer) thedata
{
  gtk_object_set_user_data(gtkobject, thedata);
  return self;
}

- (gpointer)get_user_data
{
  return gtk_object_get_user_data(gtkobject);
}

- set_data:(const gchar *) key
	  :(gpointer) data
{
  gtk_object_set_data(gtkobject, key, data);
  return self;
}

- (gpointer)
  get_data:(const gchar *) key
{
  return gtk_object_get_data(gtkobject, key);
}
@end
