/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib-object.h>
#include <vala.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_vapi_gen_unref0(var) ((var == NULL) ? NULL : (var = (vala_vapi_gen_unref (var), NULL)))
typedef struct _ValaParamSpecVAPIGen ValaParamSpecVAPIGen;

struct _ValaVAPIGen {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GTypeClass parent_class;
	void (*finalize) (ValaVAPIGen *self);
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};

struct _ValaParamSpecVAPIGen {
	GParamSpec parent_instance;
};

static gint ValaVAPIGen_private_offset;
static gpointer vala_vapi_gen_parent_class = NULL;
static gchar** vala_vapi_gen_vapi_directories;
static gchar** vala_vapi_gen_gir_directories;
static gchar** vala_vapi_gen_metadata_directories;
static gboolean vala_vapi_gen_nostdpkg;
static gchar** vala_vapi_gen_packages;
static gchar* vala_vapi_gen_library;
static gchar* vala_vapi_gen_directory;
static gboolean vala_vapi_gen_disable_warnings;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_quiet_mode;
static gchar** vala_vapi_gen_sources;
static gchar* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static gboolean vala_vapi_gen_disable_warnings = FALSE;
static gchar** vala_vapi_gen_sources = NULL;
static gchar** vala_vapi_gen_vapi_directories = NULL;
static gchar** vala_vapi_gen_gir_directories = NULL;
static gchar** vala_vapi_gen_metadata_directories = NULL;
static gchar* vala_vapi_gen_library = NULL;
static gchar** vala_vapi_gen_packages = NULL;
static gboolean vala_vapi_gen_nostdpkg = FALSE;

 G_GNUC_INTERNAL gpointer vala_vapi_gen_ref (gpointer instance);
 G_GNUC_INTERNAL void vala_vapi_gen_unref (gpointer instance);
 G_GNUC_INTERNAL GParamSpec* vala_param_spec_vapi_gen (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
 G_GNUC_INTERNAL void vala_value_set_vapi_gen (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL void vala_value_take_vapi_gen (GValue* value,
                               gpointer v_object);
 G_GNUC_INTERNAL gpointer vala_value_get_vapi_gen (const GValue* value) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType vala_vapi_gen_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaVAPIGen, vala_vapi_gen_unref)
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
VALA_EXTERN GType vala_gidl_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaGIdlParser, vala_code_visitor_unref)
VALA_EXTERN ValaGIdlParser* vala_gidl_parser_new (void);
VALA_EXTERN ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
VALA_EXTERN void vala_gidl_parser_parse (ValaGIdlParser* self,
                             ValaCodeContext* context);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gint vala_vapi_gen_main (gchar** args,
                         gint args_length1);
 G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_new (void);
 G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (ValaVAPIGen * obj);
static GType vala_vapi_gen_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[12] = {{"vapidir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"nostdpkg", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_vapi_gen_nostdpkg, "Do not include standard packages", NULL}, {"pkg", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', (gint) 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"disable-warnings", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_vapi_gen_disable_warnings, "Disable warnings", NULL}, {"version", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', (gint) 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {G_OPTION_REMAINING, (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static inline gpointer
vala_vapi_gen_get_instance_private (ValaVAPIGen* self)
{
	return G_STRUCT_MEMBER_P (self, ValaVAPIGen_private_offset);
}

static gint
vala_vapi_gen_quit (ValaVAPIGen* self)
{
	ValaCodeContext* _tmp0_;
	ValaReport* _tmp1_;
	ValaReport* _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_report (_tmp0_);
	_tmp2_ = _tmp1_;
	if (vala_report_get_errors (_tmp2_) == 0) {
		if (!vala_vapi_gen_quiet_mode) {
			ValaCodeContext* _tmp3_;
			ValaReport* _tmp4_;
			ValaReport* _tmp5_;
			_tmp3_ = self->priv->context;
			_tmp4_ = vala_code_context_get_report (_tmp3_);
			_tmp5_ = _tmp4_;
			g_print ("Generation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp5_));
		}
		vala_code_context_pop ();
		result = 0;
		return result;
	} else {
		if (!vala_vapi_gen_quiet_mode) {
			ValaCodeContext* _tmp6_;
			ValaReport* _tmp7_;
			ValaReport* _tmp8_;
			ValaCodeContext* _tmp9_;
			ValaReport* _tmp10_;
			ValaReport* _tmp11_;
			_tmp6_ = self->priv->context;
			_tmp7_ = vala_code_context_get_report (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->priv->context;
			_tmp10_ = vala_code_context_get_report (_tmp9_);
			_tmp11_ = _tmp10_;
			g_print ("Generation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp8_), vala_report_get_warnings (_tmp11_));
		}
		vala_code_context_pop ();
		result = 1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gint
vala_vapi_gen_run (ValaVAPIGen* self)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	ValaCodeContext* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValaCodeContext* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	ValaCodeContext* _tmp7_;
	ValaReport* _tmp8_;
	ValaReport* _tmp9_;
	ValaCodeContext* _tmp10_;
	ValaReport* _tmp11_;
	ValaReport* _tmp12_;
	ValaCodeContext* _tmp13_;
	ValaCodeContext* _tmp14_;
	ValaCodeContext* _tmp15_;
	ValaReport* _tmp16_;
	ValaReport* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	ValaCodeContext* _tmp33_;
	ValaReport* _tmp34_;
	ValaReport* _tmp35_;
	const gchar* _tmp36_;
	ValaCodeContext* _tmp41_;
	ValaReport* _tmp42_;
	ValaReport* _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	ValaCodeContext* _tmp49_;
	ValaReport* _tmp50_;
	ValaReport* _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	ValaCodeContext* _tmp62_;
	ValaReport* _tmp63_;
	ValaReport* _tmp64_;
	ValaParser* parser = NULL;
	ValaParser* _tmp65_;
	ValaParser* _tmp66_;
	ValaCodeContext* _tmp67_;
	ValaCodeContext* _tmp68_;
	ValaReport* _tmp69_;
	ValaReport* _tmp70_;
	ValaGirParser* girparser = NULL;
	ValaGirParser* _tmp71_;
	ValaGirParser* _tmp72_;
	ValaCodeContext* _tmp73_;
	ValaCodeContext* _tmp74_;
	ValaReport* _tmp75_;
	ValaReport* _tmp76_;
	ValaGIdlParser* gidlparser = NULL;
	ValaGIdlParser* _tmp77_;
	ValaGIdlParser* _tmp78_;
	ValaCodeContext* _tmp79_;
	ValaCodeContext* _tmp80_;
	ValaReport* _tmp81_;
	ValaReport* _tmp82_;
	ValaCodeContext* _tmp83_;
	ValaCodeContext* _tmp84_;
	ValaReport* _tmp85_;
	ValaReport* _tmp86_;
	gchar** package_names = NULL;
	gchar** _tmp87_;
	gint package_names_length1;
	gint _package_names_size_;
	gchar* library_name = NULL;
	const gchar* _tmp130_;
	gchar* _tmp131_;
	gboolean _tmp132_ = FALSE;
	gchar** _tmp133_;
	gint _tmp133__length1;
	ValaCodeWriter* interface_writer = NULL;
	ValaCodeWriter* _tmp140_;
	gchar* vapi_filename = NULL;
	const gchar* _tmp141_;
	gchar* _tmp142_;
	const gchar* _tmp143_;
	ValaCodeWriter* _tmp147_;
	ValaCodeContext* _tmp148_;
	const gchar* _tmp149_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_vapi_gen_vapi_directories;
	_tmp2__length1 = _vala_array_length (vala_vapi_gen_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp1_, _tmp2_, _tmp2__length1);
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_vapi_gen_gir_directories;
	_tmp4__length1 = _vala_array_length (vala_vapi_gen_gir_directories);
	vala_code_context_set_gir_directories (_tmp3_, _tmp4_, _tmp4__length1);
	_tmp5_ = self->priv->context;
	_tmp6_ = vala_vapi_gen_metadata_directories;
	_tmp6__length1 = _vala_array_length (vala_vapi_gen_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp5_, _tmp6_, _tmp6__length1);
	_tmp7_ = self->priv->context;
	_tmp8_ = vala_code_context_get_report (_tmp7_);
	_tmp9_ = _tmp8_;
	vala_report_set_enable_warnings (_tmp9_, !vala_vapi_gen_disable_warnings);
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	vala_report_set_verbose_errors (_tmp12_, !vala_vapi_gen_quiet_mode);
	_tmp13_ = self->priv->context;
	vala_code_context_push (_tmp13_);
	_tmp14_ = self->priv->context;
	vala_code_context_set_target_profile (_tmp14_, VALA_PROFILE_GOBJECT, !vala_vapi_gen_nostdpkg);
	_tmp15_ = self->priv->context;
	_tmp16_ = vala_code_context_get_report (_tmp15_);
	_tmp17_ = _tmp16_;
	if (vala_report_get_errors (_tmp17_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp18_ = vala_vapi_gen_sources;
	_tmp18__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp18_;
		source_collection_length1 = _tmp18__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp19_;
			gchar* source = NULL;
			_tmp19_ = g_strdup (source_collection[source_it]);
			source = _tmp19_;
			{
				const gchar* _tmp20_;
				gchar* depsfile = NULL;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				ValaCodeContext* _tmp31_;
				const gchar* _tmp32_;
				_tmp20_ = source;
				if (!g_str_has_suffix (_tmp20_, ".gi")) {
					_g_free0 (source);
					continue;
				}
				_tmp21_ = source;
				_tmp22_ = source;
				_tmp23_ = strlen (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = strlen ("gi");
				_tmp26_ = _tmp25_;
				_tmp27_ = string_substring (_tmp21_, (glong) 0, (glong) (_tmp24_ - _tmp26_));
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp28_, "deps", NULL);
				_tmp30_ = _tmp29_;
				_g_free0 (_tmp28_);
				depsfile = _tmp30_;
				_tmp31_ = self->priv->context;
				_tmp32_ = depsfile;
				vala_code_context_add_packages_from_file (_tmp31_, _tmp32_);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	_tmp33_ = self->priv->context;
	_tmp34_ = vala_code_context_get_report (_tmp33_);
	_tmp35_ = _tmp34_;
	if (vala_report_get_errors (_tmp35_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp36_ = vala_vapi_gen_library;
	if (_tmp36_ != NULL) {
		gchar* depsfile = NULL;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		ValaCodeContext* _tmp39_;
		const gchar* _tmp40_;
		_tmp37_ = vala_vapi_gen_library;
		_tmp38_ = g_strconcat (_tmp37_, ".deps", NULL);
		depsfile = _tmp38_;
		_tmp39_ = self->priv->context;
		_tmp40_ = depsfile;
		vala_code_context_add_packages_from_file (_tmp39_, _tmp40_);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_code_context_get_report (_tmp41_);
	_tmp43_ = _tmp42_;
	if (vala_report_get_errors (_tmp43_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp44_ = vala_vapi_gen_packages;
	_tmp44__length1 = _vala_array_length (vala_vapi_gen_packages);
	if (_tmp44_ != NULL) {
		gchar** _tmp45_;
		gint _tmp45__length1;
		_tmp45_ = vala_vapi_gen_packages;
		_tmp45__length1 = _vala_array_length (vala_vapi_gen_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp45_;
			package_collection_length1 = _tmp45__length1;
			for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
				gchar* _tmp46_;
				gchar* package = NULL;
				_tmp46_ = g_strdup (package_collection[package_it]);
				package = _tmp46_;
				{
					ValaCodeContext* _tmp47_;
					const gchar* _tmp48_;
					_tmp47_ = self->priv->context;
					_tmp48_ = package;
					vala_code_context_add_external_package (_tmp47_, _tmp48_);
					_g_free0 (package);
				}
			}
		}
		vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL);
		vala_vapi_gen_packages = NULL;
	}
	_tmp49_ = self->priv->context;
	_tmp50_ = vala_code_context_get_report (_tmp49_);
	_tmp51_ = _tmp50_;
	if (vala_report_get_errors (_tmp51_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp52_ = vala_vapi_gen_sources;
	_tmp52__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp52_;
		source_collection_length1 = _tmp52__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp53_;
			gchar* source = NULL;
			_tmp53_ = g_strdup (source_collection[source_it]);
			source = _tmp53_;
			{
				const gchar* _tmp54_;
				_tmp54_ = source;
				if (g_file_test (_tmp54_, G_FILE_TEST_EXISTS)) {
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp55_;
					const gchar* _tmp56_;
					ValaSourceFile* _tmp57_;
					ValaSourceFile* _tmp58_;
					ValaCodeContext* _tmp59_;
					ValaSourceFile* _tmp60_;
					_tmp55_ = self->priv->context;
					_tmp56_ = source;
					_tmp57_ = vala_source_file_new (_tmp55_, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp56_, NULL, FALSE);
					source_file = _tmp57_;
					_tmp58_ = source_file;
					vala_source_file_set_from_commandline (_tmp58_, TRUE);
					_tmp59_ = self->priv->context;
					_tmp60_ = source_file;
					vala_code_context_add_source_file (_tmp59_, _tmp60_);
					_vala_source_file_unref0 (source_file);
				} else {
					const gchar* _tmp61_;
					_tmp61_ = source;
					vala_report_error (NULL, "%s not found", _tmp61_);
				}
				_g_free0 (source);
			}
		}
	}
	_tmp62_ = self->priv->context;
	_tmp63_ = vala_code_context_get_report (_tmp62_);
	_tmp64_ = _tmp63_;
	if (vala_report_get_errors (_tmp64_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp65_ = vala_parser_new ();
	parser = _tmp65_;
	_tmp66_ = parser;
	_tmp67_ = self->priv->context;
	vala_parser_parse (_tmp66_, _tmp67_);
	_tmp68_ = self->priv->context;
	_tmp69_ = vala_code_context_get_report (_tmp68_);
	_tmp70_ = _tmp69_;
	if (vala_report_get_errors (_tmp70_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp71_ = vala_gir_parser_new ();
	girparser = _tmp71_;
	_tmp72_ = girparser;
	_tmp73_ = self->priv->context;
	vala_gir_parser_parse (_tmp72_, _tmp73_);
	_tmp74_ = self->priv->context;
	_tmp75_ = vala_code_context_get_report (_tmp74_);
	_tmp76_ = _tmp75_;
	if (vala_report_get_errors (_tmp76_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp77_ = vala_gidl_parser_new ();
	gidlparser = _tmp77_;
	_tmp78_ = gidlparser;
	_tmp79_ = self->priv->context;
	vala_gidl_parser_parse (_tmp78_, _tmp79_);
	_tmp80_ = self->priv->context;
	_tmp81_ = vala_code_context_get_report (_tmp80_);
	_tmp82_ = _tmp81_;
	if (vala_report_get_errors (_tmp82_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp83_ = self->priv->context;
	vala_code_context_check (_tmp83_);
	_tmp84_ = self->priv->context;
	_tmp85_ = vala_code_context_get_report (_tmp84_);
	_tmp86_ = _tmp85_;
	if (vala_report_get_errors (_tmp86_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp87_ = g_new0 (gchar*, 0 + 1);
	package_names = _tmp87_;
	package_names_length1 = 0;
	_package_names_size_ = package_names_length1;
	{
		ValaList* _file_list = NULL;
		ValaCodeContext* _tmp88_;
		ValaList* _tmp89_;
		gint _file_size = 0;
		ValaList* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		gint _file_index = 0;
		_tmp88_ = self->priv->context;
		_tmp89_ = vala_code_context_get_source_files (_tmp88_);
		_file_list = _tmp89_;
		_tmp90_ = _file_list;
		_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
		_tmp92_ = _tmp91_;
		_file_size = _tmp92_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp93_;
			gint _tmp94_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp95_;
			gpointer _tmp96_;
			ValaSourceFile* _tmp97_;
			const gchar* _tmp98_;
			const gchar* _tmp99_;
			ValaSourceFile* _tmp100_;
			const gchar* _tmp101_;
			const gchar* _tmp102_;
			gchar** _tmp103_;
			gint _tmp103__length1;
			_file_index = _file_index + 1;
			_tmp93_ = _file_index;
			_tmp94_ = _file_size;
			if (!(_tmp93_ < _tmp94_)) {
				break;
			}
			_tmp95_ = _file_list;
			_tmp96_ = vala_list_get (_tmp95_, _file_index);
			file = (ValaSourceFile*) _tmp96_;
			_tmp97_ = file;
			_tmp98_ = vala_source_file_get_filename (_tmp97_);
			_tmp99_ = _tmp98_;
			if (g_str_has_suffix (_tmp99_, ".vapi")) {
				_vala_source_file_unref0 (file);
				continue;
			}
			_tmp100_ = file;
			_tmp101_ = vala_source_file_get_filename (_tmp100_);
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_vapi_gen_sources;
			_tmp103__length1 = _vala_array_length (vala_vapi_gen_sources);
			if (_vala_string_array_contains (_tmp103_, _tmp103__length1, _tmp102_)) {
				ValaSourceFile* _tmp104_;
				ValaSourceFile* _tmp105_;
				const gchar* _tmp106_;
				const gchar* _tmp107_;
				_tmp104_ = file;
				vala_source_file_set_file_type (_tmp104_, VALA_SOURCE_FILE_TYPE_SOURCE);
				_tmp105_ = file;
				_tmp106_ = vala_source_file_get_filename (_tmp105_);
				_tmp107_ = _tmp106_;
				if (g_str_has_suffix (_tmp107_, ".gir")) {
					gchar* metadata_filename = NULL;
					ValaCodeContext* _tmp108_;
					ValaSourceFile* _tmp109_;
					const gchar* _tmp110_;
					const gchar* _tmp111_;
					gchar* _tmp112_;
					const gchar* _tmp113_;
					gboolean _tmp119_ = FALSE;
					ValaSourceFile* _tmp120_;
					gboolean _tmp121_;
					gboolean _tmp122_;
					_tmp108_ = self->priv->context;
					_tmp109_ = file;
					_tmp110_ = vala_source_file_get_filename (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = vala_code_context_get_metadata_path (_tmp108_, _tmp111_);
					metadata_filename = _tmp112_;
					_tmp113_ = metadata_filename;
					if (_tmp113_ != NULL) {
						ValaSourceFile* metadata_file = NULL;
						ValaCodeContext* _tmp114_;
						const gchar* _tmp115_;
						ValaSourceFile* _tmp116_;
						ValaSourceFile* _tmp117_;
						_tmp114_ = self->priv->context;
						_tmp115_ = metadata_filename;
						_tmp116_ = vala_code_context_get_source_file (_tmp114_, _tmp115_);
						metadata_file = _tmp116_;
						_tmp117_ = metadata_file;
						if (_tmp117_ != NULL) {
							ValaSourceFile* _tmp118_;
							_tmp118_ = metadata_file;
							vala_source_file_set_file_type (_tmp118_, VALA_SOURCE_FILE_TYPE_SOURCE);
						}
					}
					_tmp120_ = file;
					_tmp121_ = vala_source_file_get_from_commandline (_tmp120_);
					_tmp122_ = _tmp121_;
					if (_tmp122_) {
						ValaSourceFile* _tmp123_;
						const gchar* _tmp124_;
						const gchar* _tmp125_;
						_tmp123_ = file;
						_tmp124_ = vala_source_file_get_package_name (_tmp123_);
						_tmp125_ = _tmp124_;
						_tmp119_ = _tmp125_ != NULL;
					} else {
						_tmp119_ = FALSE;
					}
					if (_tmp119_) {
						ValaSourceFile* _tmp126_;
						const gchar* _tmp127_;
						const gchar* _tmp128_;
						gchar* _tmp129_;
						_tmp126_ = file;
						_tmp127_ = vala_source_file_get_package_name (_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = g_strdup (_tmp128_);
						_vala_array_add1 (&package_names, &package_names_length1, &_package_names_size_, _tmp129_);
					}
					_g_free0 (metadata_filename);
				}
			}
			_vala_source_file_unref0 (file);
		}
	}
	_tmp130_ = vala_vapi_gen_library;
	_tmp131_ = g_path_get_basename (_tmp130_);
	library_name = _tmp131_;
	_tmp133_ = package_names;
	_tmp133__length1 = package_names_length1;
	if (_tmp133__length1 > 0) {
		const gchar* _tmp134_;
		gchar** _tmp135_;
		gint _tmp135__length1;
		_tmp134_ = library_name;
		_tmp135_ = package_names;
		_tmp135__length1 = package_names_length1;
		_tmp132_ = !_vala_string_array_contains (_tmp135_, _tmp135__length1, _tmp134_);
	} else {
		_tmp132_ = FALSE;
	}
	if (_tmp132_) {
		const gchar* _tmp136_;
		gchar** _tmp137_;
		gint _tmp137__length1;
		gchar* _tmp138_;
		gchar* _tmp139_;
		_tmp136_ = library_name;
		_tmp137_ = package_names;
		_tmp137__length1 = package_names_length1;
		_tmp138_ = g_strjoin ("', `", _tmp137_, NULL);
		_tmp139_ = _tmp138_;
		vala_report_warning (NULL, "Given library name `%s' does not match pkg-config name `%s'", _tmp136_, _tmp139_);
		_g_free0 (_tmp139_);
	}
	_tmp140_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_VAPIGEN);
	interface_writer = _tmp140_;
	_tmp141_ = vala_vapi_gen_library;
	_tmp142_ = g_strdup_printf ("%s.vapi", _tmp141_);
	vapi_filename = _tmp142_;
	_tmp143_ = vala_vapi_gen_directory;
	if (_tmp143_ != NULL) {
		const gchar* _tmp144_;
		const gchar* _tmp145_;
		gchar* _tmp146_;
		_tmp144_ = vala_vapi_gen_directory;
		_tmp145_ = vapi_filename;
		_tmp146_ = g_build_path ("/", _tmp144_, _tmp145_, NULL);
		_g_free0 (vapi_filename);
		vapi_filename = _tmp146_;
	}
	_tmp147_ = interface_writer;
	_tmp148_ = self->priv->context;
	_tmp149_ = vapi_filename;
	vala_code_writer_write_file (_tmp147_, _tmp148_, _tmp149_);
	_g_free0 (vala_vapi_gen_library);
	vala_vapi_gen_library = NULL;
	result = vala_vapi_gen_quit (self);
	_g_free0 (vapi_filename);
	_vala_code_visitor_unref0 (interface_writer);
	_g_free0 (library_name);
	package_names = (_vala_array_free (package_names, package_names_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}

static gint
vala_vapi_gen_main (gchar** args,
                    gint args_length1)
{
	const gchar* _tmp0_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ValaVAPIGen* vapigen = NULL;
	ValaVAPIGen* _tmp12_;
	ValaVAPIGen* _tmp13_;
	GError* _inner_error0_ = NULL;
	gint result;
	setlocale (LC_ALL, "");
	_tmp0_ = vala_get_build_version ();
	if (g_strcmp0 (_tmp0_, VALA_BUILD_VERSION) != 0) {
		const gchar* _tmp1_;
		_tmp1_ = vala_get_build_version ();
		g_printerr ("Integrity check failed (libvala %s doesn't match vapigen %s)\n", _tmp1_, VALA_BUILD_VERSION);
		result = 1;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		GOptionContext* _tmp4_;
		GOptionContext* _tmp5_;
		_tmp2_ = g_option_context_new ("- Vala API Generator");
		opt_context = _tmp2_;
		_tmp3_ = opt_context;
		g_option_context_set_help_enabled (_tmp3_, TRUE);
		_tmp4_ = opt_context;
		g_option_context_add_main_entries (_tmp4_, VALA_VAPI_GEN_options, NULL);
		_tmp5_ = opt_context;
		g_option_context_parse (_tmp5_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp6_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_print ("%s\n", _tmp8_);
		_tmp9_ = args[0];
		g_print ("Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if (vala_vapi_gen_version) {
		g_print ("Vala API Generator %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp11_ = vala_vapi_gen_sources;
	_tmp11__length1 = _vala_array_length (vala_vapi_gen_sources);
	if (_tmp11_ == NULL) {
		g_printerr ("No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp12_ = vala_vapi_gen_new ();
	vapigen = _tmp12_;
	_tmp13_ = vapigen;
	result = vala_vapi_gen_run (_tmp13_);
	_vala_vapi_gen_unref0 (vapigen);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_vapi_gen_main (argv, argc);
}

 G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_construct (GType object_type)
{
	ValaVAPIGen* self = NULL;
	self = (ValaVAPIGen*) g_type_create_instance (object_type);
	return self;
}

 G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_new (void)
{
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}

static void
vala_value_vapi_gen_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_vapi_gen_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_vapi_gen_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_vapi_gen_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_vapi_gen_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_vapi_gen_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_vapi_gen_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaVAPIGen * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_vapi_gen_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_vapi_gen_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ValaVAPIGen ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_vapi_gen_ref (value->data[0].v_pointer);
	}
	return NULL;
}

 G_GNUC_INTERNAL GParamSpec*
vala_param_spec_vapi_gen (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ValaParamSpecVAPIGen* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_VAPI_GEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

 G_GNUC_INTERNAL gpointer
vala_value_get_vapi_gen (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN), NULL);
	return value->data[0].v_pointer;
}

 G_GNUC_INTERNAL void
vala_value_set_vapi_gen (GValue* value,
                         gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_vapi_gen_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}

 G_GNUC_INTERNAL void
vala_value_take_vapi_gen (GValue* value,
                          gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}

static void
vala_vapi_gen_class_init (ValaVAPIGenClass * klass,
                          gpointer klass_data)
{
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	((ValaVAPIGenClass *) klass)->finalize = vala_vapi_gen_finalize;
	g_type_class_adjust_private_offset (klass, &ValaVAPIGen_private_offset);
}

static void
vala_vapi_gen_instance_init (ValaVAPIGen * self,
                             gpointer klass)
{
	self->priv = vala_vapi_gen_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_vapi_gen_finalize (ValaVAPIGen * obj)
{
	ValaVAPIGen * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_VAPI_GEN, ValaVAPIGen);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}

static GType
vala_vapi_gen_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_vapi_gen_init, vala_value_vapi_gen_free_value, vala_value_vapi_gen_copy_value, vala_value_vapi_gen_peek_pointer, "p", vala_value_vapi_gen_collect_value, "p", vala_value_vapi_gen_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_vapi_gen_type_id;
	vala_vapi_gen_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaVAPIGen", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaVAPIGen_private_offset = g_type_add_instance_private (vala_vapi_gen_type_id, sizeof (ValaVAPIGenPrivate));
	return vala_vapi_gen_type_id;
}

 G_GNUC_INTERNAL GType
vala_vapi_gen_get_type (void)
{
	static volatile gsize vala_vapi_gen_type_id__once = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__once)) {
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = vala_vapi_gen_get_type_once ();
		g_once_init_leave (&vala_vapi_gen_type_id__once, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__once;
}

 G_GNUC_INTERNAL gpointer
vala_vapi_gen_ref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

 G_GNUC_INTERNAL void
vala_vapi_gen_unref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_VAPI_GEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

