/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _is_sealed;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_opaque;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static guint _vala_symbol_hash_func_ghash_func (gconstpointer key);
static gboolean _vala_symbol_equal_func_gequal_func (gconstpointer a,
                                              gconstpointer b);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_class_get_is_sealed (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_sealed;
	return result;
}

void
vala_class_set_is_sealed (ValaClass* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_sealed = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_compact;
	result = *_tmp11_;
	return result;
}

gboolean
vala_class_get_is_opaque (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_opaque;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "Compact", "opaque", FALSE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_is_opaque);
		self->priv->_is_opaque = _tmp2_;
	}
	_tmp3_ = self->priv->_is_opaque;
	result = *_tmp3_;
	return result;
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_immutable;
	result = *_tmp11_;
	return result;
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

static guint
_vala_symbol_hash_func_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_symbol_hash_func ((ValaSymbol*) key);
	return result;
}

static gboolean
_vala_symbol_equal_func_gequal_func (gconstpointer a,
                                     gconstpointer b)
{
	gboolean result;
	result = vala_symbol_equal_func ((ValaSymbol*) a, (ValaSymbol*) b);
	return result;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp25_ = FALSE;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaParameter* _tmp15_;
		ValaParameter* _tmp16_;
		ValaScope* _tmp17_;
		ValaScope* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ValaParameter* _tmp23_;
		ValaParameter* _tmp24_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_parameter_new ("this", _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		vala_method_set_this_parameter (m, _tmp16_);
		_vala_code_node_unref0 (_tmp16_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_method_get_this_parameter (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_method_get_this_parameter (m);
		_tmp24_ = _tmp23_;
		vala_scope_add (_tmp18_, _tmp22_, (ValaSymbol*) _tmp24_);
	}
	_tmp26_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp27_ = _tmp26_;
	if (!VALA_IS_VOID_TYPE (_tmp27_)) {
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp28_ = vala_method_get_postconditions (m);
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp25_ = _tmp30_ > 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		ValaLocalVariable* _tmp48_;
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		if (_tmp32_ != NULL) {
			ValaScope* _tmp33_;
			ValaScope* _tmp34_;
			ValaLocalVariable* _tmp35_;
			ValaLocalVariable* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			_tmp33_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			vala_scope_remove (_tmp34_, _tmp38_);
		}
		_tmp39_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_copy (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_local_variable_new (_tmp42_, "result", NULL, _tmp44_);
		_tmp46_ = _tmp45_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp46_);
		_vala_code_node_unref0 (_tmp46_);
		_vala_code_node_unref0 (_tmp42_);
		_tmp47_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp48_ = _tmp47_;
		vala_local_variable_set_is_result (_tmp48_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_;
		_tmp49_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp50_ = _tmp49_;
		if (_tmp50_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp61_, "missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp68_ = self->priv->_is_abstract;
		if (_tmp68_) {
			ValaCreationMethod* _tmp69_;
			ValaSymbolAccessibility _tmp70_;
			ValaSymbolAccessibility _tmp71_;
			_tmp69_ = cm;
			_tmp70_ = vala_symbol_get_access ((ValaSymbol*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp67_ = _tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			gboolean _tmp72_;
			gboolean _tmp73_;
			_tmp72_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp73_ = _tmp72_;
			if (_tmp73_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp75_ = _tmp74_;
				vala_report_warning (_tmp75_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_error (_tmp77_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp16_;
	ValaField* _tmp17_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		vala_property_set_this_parameter (prop, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_property_get_this_parameter (prop);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_property_get_this_parameter (prop);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp16_ = vala_property_get_field (prop);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaField* _tmp18_;
		ValaField* _tmp19_;
		_tmp18_ = vala_property_get_field (prop);
		_tmp19_ = _tmp18_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp19_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_constructor_set_this_parameter (c, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_constructor_get_this_parameter (c);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_constructor_get_this_parameter (c);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_destructor_set_this_parameter (d, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_destructor_get_this_parameter (d);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_destructor_get_this_parameter (d);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp9_;
	ValaConstructor* _tmp10_;
	ValaConstructor* _tmp13_;
	ValaConstructor* _tmp14_;
	ValaConstructor* _tmp17_;
	ValaConstructor* _tmp18_;
	ValaDestructor* _tmp21_;
	ValaDestructor* _tmp22_;
	ValaDestructor* _tmp25_;
	ValaDestructor* _tmp26_;
	ValaDestructor* _tmp29_;
	ValaDestructor* _tmp30_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (type);
		}
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp9_ = vala_class_get_constructor (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaConstructor* _tmp11_;
		ValaConstructor* _tmp12_;
		_tmp11_ = vala_class_get_constructor (self);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
	}
	_tmp13_ = vala_class_get_class_constructor (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaConstructor* _tmp15_;
		ValaConstructor* _tmp16_;
		_tmp15_ = vala_class_get_class_constructor (self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	}
	_tmp17_ = vala_class_get_static_constructor (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		ValaConstructor* _tmp19_;
		ValaConstructor* _tmp20_;
		_tmp19_ = vala_class_get_static_constructor (self);
		_tmp20_ = _tmp19_;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
	}
	_tmp21_ = vala_class_get_destructor (self);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValaDestructor* _tmp23_;
		ValaDestructor* _tmp24_;
		_tmp23_ = vala_class_get_destructor (self);
		_tmp24_ = _tmp23_;
		vala_code_node_accept ((ValaCodeNode*) _tmp24_, visitor);
	}
	_tmp25_ = vala_class_get_static_destructor (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaDestructor* _tmp27_;
		ValaDestructor* _tmp28_;
		_tmp27_ = vala_class_get_static_destructor (self);
		_tmp28_ = _tmp27_;
		vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
	}
	_tmp29_ = vala_class_get_class_destructor (self);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		ValaDestructor* _tmp31_;
		ValaDestructor* _tmp32_;
		_tmp31_ = vala_class_get_class_destructor (self);
		_tmp32_ = _tmp31_;
		vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp8_ = vala_typesymbol_is_subtype_of (_tmp18_, t);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_prereq_index = _prereq_index + 1;
			_tmp4_ = _prereq_index;
			_tmp5_ = _prereq_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prereq_list;
			_tmp7_ = vala_list_get (_tmp6_, _prereq_index);
			prereq = (ValaDataType*) _tmp7_;
			_tmp8_ = prereq;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			type = _tmp11_;
			_tmp12_ = type;
			if (_tmp12_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp13_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp13_);
			_tmp14_ = type;
			if (VALA_IS_INTERFACE (_tmp14_)) {
				ValaTypeSymbol* _tmp15_;
				_tmp15_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (VALA_IS_CLASS (_tmp10_)) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = base_type;
				_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
				_tmp13_ = _tmp12_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			} else {
				ValaDataType* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp14_ = base_type;
				_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp73_ = FALSE;
	ValaClass* _tmp74_;
	gboolean _tmp85_ = FALSE;
	gboolean _tmp86_;
	gboolean _tmp87_;
	gboolean _tmp95_ = FALSE;
	gboolean _tmp96_;
	gboolean _tmp97_;
	gboolean _tmp109_ = FALSE;
	ValaClass* _tmp110_;
	gboolean _tmp120_;
	ValaConstructor* _tmp239_;
	ValaConstructor* _tmp240_;
	ValaConstructor* _tmp243_;
	ValaConstructor* _tmp244_;
	ValaConstructor* _tmp247_;
	ValaConstructor* _tmp248_;
	ValaDestructor* _tmp251_;
	ValaDestructor* _tmp252_;
	ValaDestructor* _tmp255_;
	ValaDestructor* _tmp256_;
	ValaDestructor* _tmp259_;
	ValaDestructor* _tmp260_;
	gboolean _tmp299_;
	gboolean _tmp300_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp341_;
	ValaArrayList* _tmp342_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp358_;
	ValaArrayList* _tmp359_;
	ValaList* _tmp373_;
	gint _tmp374_;
	gint _tmp375_;
	ValaSourceFileType _tmp399_;
	ValaSourceFileType _tmp400_;
	ValaSemanticAnalyzer* _tmp617_;
	ValaSemanticAnalyzer* _tmp618_;
	ValaSourceFile* _tmp619_;
	ValaSemanticAnalyzer* _tmp620_;
	ValaSemanticAnalyzer* _tmp621_;
	ValaSymbol* _tmp622_;
	gboolean _tmp623_;
	gboolean _tmp624_;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_class_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaSemanticAnalyzer* _tmp41_;
			ValaSemanticAnalyzer* _tmp42_;
			ValaDataType* _tmp43_;
			ValaDataType* _tmp51_;
			_base_type_reference_index = _base_type_reference_index + 1;
			_tmp28_ = _base_type_reference_index;
			_tmp29_ = _base_type_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _base_type_reference_list;
			_tmp31_ = vala_list_get (_tmp30_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp31_;
			_tmp32_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp32_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp33_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp33_)) {
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaDataType* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = base_type_reference;
				_tmp37_ = vala_code_node_to_string ((ValaCodeNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp40_ = _tmp39_;
				vala_report_error (_tmp35_, "base type `%s' of class `%s' is not an object type", _tmp38_, _tmp40_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp41_ = vala_code_context_get_analyzer (context);
			_tmp42_ = _tmp41_;
			_tmp43_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp42_, (ValaSymbol*) self, _tmp43_)) {
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaDataType* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				_tmp46_ = base_type_reference;
				_tmp47_ = vala_code_node_to_string ((ValaCodeNode*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp50_ = _tmp49_;
				vala_report_error (_tmp45_, "base type `%s' is less accessible than class `%s'", _tmp48_, _tmp50_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp48_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp51_ = base_type_reference;
			if (!vala_data_type_check_type_arguments (_tmp51_, context, FALSE)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (base_type_reference);
		}
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp52_;
		gint _type_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _type_index = 0;
		_tmp52_ = self->priv->base_types;
		_type_list = _tmp52_;
		_tmp53_ = _type_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_type_size = _tmp55_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			ValaDataType* type = NULL;
			ValaList* _tmp58_;
			gpointer _tmp59_;
			ValaDataType* _tmp60_;
			ValaSemanticAnalyzer* _tmp61_;
			ValaSemanticAnalyzer* _tmp62_;
			ValaDataType* _tmp63_;
			_type_index = _type_index + 1;
			_tmp56_ = _type_index;
			_tmp57_ = _type_size;
			if (!(_tmp56_ < _tmp57_)) {
				break;
			}
			_tmp58_ = _type_list;
			_tmp59_ = vala_list_get (_tmp58_, _type_index);
			type = (ValaDataType*) _tmp59_;
			_tmp60_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp60_, context);
			_tmp61_ = vala_code_context_get_analyzer (context);
			_tmp62_ = _tmp61_;
			_tmp63_ = type;
			vala_semantic_analyzer_check_type (_tmp62_, _tmp63_);
			_vala_code_node_unref0 (type);
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp64_;
		gint _p_size = 0;
		ValaList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _p_index = 0;
		_tmp64_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp64_;
		_tmp65_ = _p_list;
		_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
		_tmp67_ = _tmp66_;
		_p_size = _tmp67_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp68_;
			gint _tmp69_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp70_;
			gpointer _tmp71_;
			ValaTypeParameter* _tmp72_;
			_p_index = _p_index + 1;
			_tmp68_ = _p_index;
			_tmp69_ = _p_size;
			if (!(_tmp68_ < _tmp69_)) {
				break;
			}
			_tmp70_ = _p_list;
			_tmp71_ = vala_list_get (_tmp70_, _p_index);
			p = (ValaTypeParameter*) _tmp71_;
			_tmp72_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp72_, context);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp74_ = self->priv->_base_class;
	if (_tmp74_ != NULL) {
		ValaClass* _tmp75_;
		gboolean _tmp76_;
		gboolean _tmp77_;
		_tmp75_ = self->priv->_base_class;
		_tmp76_ = vala_class_get_is_singleton (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp73_ = _tmp77_;
	} else {
		_tmp73_ = FALSE;
	}
	if (_tmp73_) {
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		ValaClass* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp81_ = _tmp80_;
		_tmp82_ = self->priv->_base_class;
		_tmp83_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp82_);
		_tmp84_ = _tmp83_;
		vala_report_error (_tmp79_, "`%s' cannot inherit from SingleInstance class `%s'", _tmp81_, _tmp84_);
		_g_free0 (_tmp84_);
		_g_free0 (_tmp81_);
	}
	_tmp86_ = vala_class_get_is_singleton (self);
	_tmp87_ = _tmp86_;
	if (_tmp87_) {
		ValaSemanticAnalyzer* _tmp88_;
		ValaSemanticAnalyzer* _tmp89_;
		ValaClass* _tmp90_;
		_tmp88_ = vala_code_context_get_analyzer (context);
		_tmp89_ = _tmp88_;
		_tmp90_ = _tmp89_->object_type;
		_tmp85_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp90_);
	} else {
		_tmp85_ = FALSE;
	}
	if (_tmp85_) {
		ValaSourceReference* _tmp91_;
		ValaSourceReference* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp92_ = _tmp91_;
		_tmp93_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp94_ = _tmp93_;
		vala_report_error (_tmp92_, "SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp94_);
		_g_free0 (_tmp94_);
	}
	_tmp96_ = vala_class_get_is_singleton (self);
	_tmp97_ = _tmp96_;
	if (_tmp97_) {
		ValaConstructor* _tmp98_;
		ValaConstructor* _tmp99_;
		_tmp98_ = vala_class_get_constructor (self);
		_tmp99_ = _tmp98_;
		_tmp95_ = _tmp99_ == NULL;
	} else {
		_tmp95_ = FALSE;
	}
	if (_tmp95_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp100_;
		ValaSourceReference* _tmp101_;
		ValaConstructor* _tmp102_;
		ValaConstructor* _tmp103_;
		ValaSourceReference* _tmp104_;
		ValaSourceReference* _tmp105_;
		ValaBlock* _tmp106_;
		ValaBlock* _tmp107_;
		ValaConstructor* _tmp108_;
		_tmp100_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_constructor_new (_tmp101_);
		c = _tmp102_;
		_tmp103_ = c;
		_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp105_ = _tmp104_;
		_tmp106_ = vala_block_new (_tmp105_);
		_tmp107_ = _tmp106_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp103_, _tmp107_);
		_vala_code_node_unref0 (_tmp107_);
		_tmp108_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp108_);
		_vala_code_node_unref0 (c);
	}
	_tmp110_ = self->priv->_base_class;
	if (_tmp110_ != NULL) {
		ValaClass* _tmp111_;
		gboolean _tmp112_;
		_tmp111_ = self->priv->_base_class;
		_tmp112_ = _tmp111_->priv->_is_sealed;
		_tmp109_ = _tmp112_;
	} else {
		_tmp109_ = FALSE;
	}
	if (_tmp109_) {
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		ValaClass* _tmp117_;
		gchar* _tmp118_;
		gchar* _tmp119_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp116_ = _tmp115_;
		_tmp117_ = self->priv->_base_class;
		_tmp118_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp117_);
		_tmp119_ = _tmp118_;
		vala_report_error (_tmp114_, "`%s' cannot inherit from sealed class `%s'", _tmp116_, _tmp119_);
		_g_free0 (_tmp119_);
		_g_free0 (_tmp116_);
	}
	_tmp120_ = self->priv->_is_sealed;
	if (_tmp120_) {
		gboolean _tmp121_;
		gboolean _tmp122_;
		gboolean _tmp127_;
		gboolean _tmp132_;
		gboolean _tmp133_;
		_tmp121_ = vala_class_get_is_compact (self);
		_tmp122_ = _tmp121_;
		if (_tmp122_) {
			ValaSourceReference* _tmp123_;
			ValaSourceReference* _tmp124_;
			gchar* _tmp125_;
			gchar* _tmp126_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp126_ = _tmp125_;
			vala_report_error (_tmp124_, "Sealed class `%s' cannot be compact", _tmp126_);
			_g_free0 (_tmp126_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp127_ = self->priv->_is_abstract;
		if (_tmp127_) {
			ValaSourceReference* _tmp128_;
			ValaSourceReference* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp129_ = _tmp128_;
			_tmp130_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp131_ = _tmp130_;
			vala_report_error (_tmp129_, "Sealed class `%s' cannot be abstract", _tmp131_);
			_g_free0 (_tmp131_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp132_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp133_ = _tmp132_;
		if (!_tmp133_) {
			ValaSourceReference* _tmp134_;
			ValaSourceReference* _tmp135_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp135_ = _tmp134_;
			vala_report_error (_tmp135_, "Sealed classes are not fully supported yet");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp136_;
		gint _en_size = 0;
		ValaList* _tmp137_;
		gint _tmp138_;
		gint _tmp139_;
		gint _en_index = 0;
		_tmp136_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp136_;
		_tmp137_ = _en_list;
		_tmp138_ = vala_collection_get_size ((ValaCollection*) _tmp137_);
		_tmp139_ = _tmp138_;
		_en_size = _tmp139_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp140_;
			gint _tmp141_;
			ValaEnum* en = NULL;
			ValaList* _tmp142_;
			gpointer _tmp143_;
			ValaEnum* _tmp144_;
			_en_index = _en_index + 1;
			_tmp140_ = _en_index;
			_tmp141_ = _en_size;
			if (!(_tmp140_ < _tmp141_)) {
				break;
			}
			_tmp142_ = _en_list;
			_tmp143_ = vala_list_get (_tmp142_, _en_index);
			en = (ValaEnum*) _tmp143_;
			_tmp144_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp144_, context);
			_vala_code_node_unref0 (en);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp145_;
		gint _f_size = 0;
		ValaList* _tmp146_;
		gint _tmp147_;
		gint _tmp148_;
		gint _f_index = 0;
		_tmp145_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp145_;
		_tmp146_ = _f_list;
		_tmp147_ = vala_collection_get_size ((ValaCollection*) _tmp146_);
		_tmp148_ = _tmp147_;
		_f_size = _tmp148_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp149_;
			gint _tmp150_;
			ValaField* f = NULL;
			ValaList* _tmp151_;
			gpointer _tmp152_;
			gboolean _tmp153_ = FALSE;
			gboolean _tmp154_;
			gboolean _tmp155_;
			ValaField* _tmp193_;
			_f_index = _f_index + 1;
			_tmp149_ = _f_index;
			_tmp150_ = _f_size;
			if (!(_tmp149_ < _tmp150_)) {
				break;
			}
			_tmp151_ = _f_list;
			_tmp152_ = vala_list_get (_tmp151_, _f_index);
			f = (ValaField*) _tmp152_;
			_tmp154_ = vala_class_get_is_compact (self);
			_tmp155_ = _tmp154_;
			if (_tmp155_) {
				ValaField* _tmp156_;
				ValaMemberBinding _tmp157_;
				ValaMemberBinding _tmp158_;
				_tmp156_ = f;
				_tmp157_ = vala_field_get_binding (_tmp156_);
				_tmp158_ = _tmp157_;
				_tmp153_ = _tmp158_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp153_ = FALSE;
			}
			if (_tmp153_) {
				gboolean _tmp159_ = FALSE;
				gboolean _tmp160_ = FALSE;
				gboolean _tmp161_;
				gboolean _tmp162_;
				gboolean _tmp171_ = FALSE;
				gboolean _tmp172_ = FALSE;
				gboolean _tmp173_;
				gboolean _tmp174_;
				ValaField* _tmp187_;
				ValaMemberBinding _tmp188_;
				ValaMemberBinding _tmp189_;
				_tmp161_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp162_ = _tmp161_;
				if (!_tmp162_) {
					gboolean _tmp163_;
					gboolean _tmp164_;
					_tmp163_ = vala_class_get_is_opaque (self);
					_tmp164_ = _tmp163_;
					_tmp160_ = !_tmp164_;
				} else {
					_tmp160_ = FALSE;
				}
				if (_tmp160_) {
					ValaField* _tmp165_;
					ValaSymbolAccessibility _tmp166_;
					ValaSymbolAccessibility _tmp167_;
					_tmp165_ = f;
					_tmp166_ = vala_symbol_get_access ((ValaSymbol*) _tmp165_);
					_tmp167_ = _tmp166_;
					_tmp159_ = _tmp167_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp159_ = FALSE;
				}
				if (_tmp159_) {
					ValaField* _tmp168_;
					ValaSourceReference* _tmp169_;
					ValaSourceReference* _tmp170_;
					_tmp168_ = f;
					_tmp169_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp168_);
					_tmp170_ = _tmp169_;
					vala_report_error (_tmp170_, "private fields are only supported in opaque compact classes, use [Comp" \
"act (opaque = true)]");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp173_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp174_ = _tmp173_;
				if (!_tmp174_) {
					gboolean _tmp175_;
					gboolean _tmp176_;
					_tmp175_ = vala_class_get_is_opaque (self);
					_tmp176_ = _tmp175_;
					_tmp172_ = _tmp176_;
				} else {
					_tmp172_ = FALSE;
				}
				if (_tmp172_) {
					gboolean _tmp177_ = FALSE;
					ValaField* _tmp178_;
					ValaSymbolAccessibility _tmp179_;
					ValaSymbolAccessibility _tmp180_;
					_tmp178_ = f;
					_tmp179_ = vala_symbol_get_access ((ValaSymbol*) _tmp178_);
					_tmp180_ = _tmp179_;
					if (_tmp180_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
						_tmp177_ = TRUE;
					} else {
						ValaField* _tmp181_;
						ValaSymbolAccessibility _tmp182_;
						ValaSymbolAccessibility _tmp183_;
						_tmp181_ = f;
						_tmp182_ = vala_symbol_get_access ((ValaSymbol*) _tmp181_);
						_tmp183_ = _tmp182_;
						_tmp177_ = _tmp183_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
					}
					_tmp171_ = _tmp177_;
				} else {
					_tmp171_ = FALSE;
				}
				if (_tmp171_) {
					ValaField* _tmp184_;
					ValaSourceReference* _tmp185_;
					ValaSourceReference* _tmp186_;
					_tmp184_ = f;
					_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp184_);
					_tmp186_ = _tmp185_;
					vala_report_error (_tmp186_, "fields in opaque compact classes must be private or internal");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp187_ = f;
				_tmp188_ = vala_field_get_binding (_tmp187_);
				_tmp189_ = _tmp188_;
				if (_tmp189_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp190_;
					ValaSourceReference* _tmp191_;
					ValaSourceReference* _tmp192_;
					_tmp190_ = f;
					_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp190_);
					_tmp192_ = _tmp191_;
					vala_report_error (_tmp192_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp193_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp193_, context);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp194_;
		gint _c_size = 0;
		ValaList* _tmp195_;
		gint _tmp196_;
		gint _tmp197_;
		gint _c_index = 0;
		_tmp194_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp194_;
		_tmp195_ = _c_list;
		_tmp196_ = vala_collection_get_size ((ValaCollection*) _tmp195_);
		_tmp197_ = _tmp196_;
		_c_size = _tmp197_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp198_;
			gint _tmp199_;
			ValaConstant* c = NULL;
			ValaList* _tmp200_;
			gpointer _tmp201_;
			ValaConstant* _tmp202_;
			_c_index = _c_index + 1;
			_tmp198_ = _c_index;
			_tmp199_ = _c_size;
			if (!(_tmp198_ < _tmp199_)) {
				break;
			}
			_tmp200_ = _c_list;
			_tmp201_ = vala_list_get (_tmp200_, _c_index);
			c = (ValaConstant*) _tmp201_;
			_tmp202_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp202_, context);
			_vala_code_node_unref0 (c);
		}
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp203_;
		gint _m_size = 0;
		ValaList* _tmp204_;
		gint _tmp205_;
		gint _tmp206_;
		gint _m_index = 0;
		_tmp203_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp203_;
		_tmp204_ = _m_list;
		_tmp205_ = vala_collection_get_size ((ValaCollection*) _tmp204_);
		_tmp206_ = _tmp205_;
		_m_size = _tmp206_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp207_;
			gint _tmp208_;
			ValaMethod* m = NULL;
			ValaList* _tmp209_;
			gpointer _tmp210_;
			ValaMethod* _tmp211_;
			_m_index = _m_index + 1;
			_tmp207_ = _m_index;
			_tmp208_ = _m_size;
			if (!(_tmp207_ < _tmp208_)) {
				break;
			}
			_tmp209_ = _m_list;
			_tmp210_ = vala_list_get (_tmp209_, _m_index);
			m = (ValaMethod*) _tmp210_;
			_tmp211_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp211_, context);
			_vala_code_node_unref0 (m);
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp212_;
		gint _prop_size = 0;
		ValaList* _tmp213_;
		gint _tmp214_;
		gint _tmp215_;
		gint _prop_index = 0;
		_tmp212_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp212_;
		_tmp213_ = _prop_list;
		_tmp214_ = vala_collection_get_size ((ValaCollection*) _tmp213_);
		_tmp215_ = _tmp214_;
		_prop_size = _tmp215_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp216_;
			gint _tmp217_;
			ValaProperty* prop = NULL;
			ValaList* _tmp218_;
			gpointer _tmp219_;
			gboolean _tmp220_ = FALSE;
			ValaProperty* _tmp221_;
			ValaAttribute* _tmp222_;
			ValaProperty* _tmp229_;
			_prop_index = _prop_index + 1;
			_tmp216_ = _prop_index;
			_tmp217_ = _prop_size;
			if (!(_tmp216_ < _tmp217_)) {
				break;
			}
			_tmp218_ = _prop_list;
			_tmp219_ = vala_list_get (_tmp218_, _prop_index);
			prop = (ValaProperty*) _tmp219_;
			_tmp221_ = prop;
			_tmp222_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp221_, "NoAccessorMethod");
			if (_tmp222_ != NULL) {
				ValaSemanticAnalyzer* _tmp223_;
				ValaSemanticAnalyzer* _tmp224_;
				ValaClass* _tmp225_;
				_tmp223_ = vala_code_context_get_analyzer (context);
				_tmp224_ = _tmp223_;
				_tmp225_ = _tmp224_->object_type;
				_tmp220_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp225_);
			} else {
				_tmp220_ = FALSE;
			}
			if (_tmp220_) {
				ValaProperty* _tmp226_;
				ValaSourceReference* _tmp227_;
				ValaSourceReference* _tmp228_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp226_ = prop;
				_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp226_);
				_tmp228_ = _tmp227_;
				vala_report_error (_tmp228_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp229_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp229_, context);
			_vala_code_node_unref0 (prop);
		}
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp230_;
		gint _sig_size = 0;
		ValaList* _tmp231_;
		gint _tmp232_;
		gint _tmp233_;
		gint _sig_index = 0;
		_tmp230_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp230_;
		_tmp231_ = _sig_list;
		_tmp232_ = vala_collection_get_size ((ValaCollection*) _tmp231_);
		_tmp233_ = _tmp232_;
		_sig_size = _tmp233_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp234_;
			gint _tmp235_;
			ValaSignal* sig = NULL;
			ValaList* _tmp236_;
			gpointer _tmp237_;
			ValaSignal* _tmp238_;
			_sig_index = _sig_index + 1;
			_tmp234_ = _sig_index;
			_tmp235_ = _sig_size;
			if (!(_tmp234_ < _tmp235_)) {
				break;
			}
			_tmp236_ = _sig_list;
			_tmp237_ = vala_list_get (_tmp236_, _sig_index);
			sig = (ValaSignal*) _tmp237_;
			_tmp238_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp238_, context);
			_vala_code_node_unref0 (sig);
		}
	}
	_tmp239_ = vala_class_get_constructor (self);
	_tmp240_ = _tmp239_;
	if (_tmp240_ != NULL) {
		ValaConstructor* _tmp241_;
		ValaConstructor* _tmp242_;
		_tmp241_ = vala_class_get_constructor (self);
		_tmp242_ = _tmp241_;
		vala_code_node_check ((ValaCodeNode*) _tmp242_, context);
	}
	_tmp243_ = vala_class_get_class_constructor (self);
	_tmp244_ = _tmp243_;
	if (_tmp244_ != NULL) {
		ValaConstructor* _tmp245_;
		ValaConstructor* _tmp246_;
		_tmp245_ = vala_class_get_class_constructor (self);
		_tmp246_ = _tmp245_;
		vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
	}
	_tmp247_ = vala_class_get_static_constructor (self);
	_tmp248_ = _tmp247_;
	if (_tmp248_ != NULL) {
		ValaConstructor* _tmp249_;
		ValaConstructor* _tmp250_;
		_tmp249_ = vala_class_get_static_constructor (self);
		_tmp250_ = _tmp249_;
		vala_code_node_check ((ValaCodeNode*) _tmp250_, context);
	}
	_tmp251_ = vala_class_get_destructor (self);
	_tmp252_ = _tmp251_;
	if (_tmp252_ != NULL) {
		ValaDestructor* _tmp253_;
		ValaDestructor* _tmp254_;
		_tmp253_ = vala_class_get_destructor (self);
		_tmp254_ = _tmp253_;
		vala_code_node_check ((ValaCodeNode*) _tmp254_, context);
	}
	_tmp255_ = vala_class_get_static_destructor (self);
	_tmp256_ = _tmp255_;
	if (_tmp256_ != NULL) {
		ValaDestructor* _tmp257_;
		ValaDestructor* _tmp258_;
		_tmp257_ = vala_class_get_static_destructor (self);
		_tmp258_ = _tmp257_;
		vala_code_node_check ((ValaCodeNode*) _tmp258_, context);
	}
	_tmp259_ = vala_class_get_class_destructor (self);
	_tmp260_ = _tmp259_;
	if (_tmp260_ != NULL) {
		ValaDestructor* _tmp261_;
		ValaDestructor* _tmp262_;
		_tmp261_ = vala_class_get_class_destructor (self);
		_tmp262_ = _tmp261_;
		vala_code_node_check ((ValaCodeNode*) _tmp262_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp263_;
		gint _cl_size = 0;
		ValaList* _tmp264_;
		gint _tmp265_;
		gint _tmp266_;
		gint _cl_index = 0;
		_tmp263_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp263_;
		_tmp264_ = _cl_list;
		_tmp265_ = vala_collection_get_size ((ValaCollection*) _tmp264_);
		_tmp266_ = _tmp265_;
		_cl_size = _tmp266_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp267_;
			gint _tmp268_;
			ValaClass* cl = NULL;
			ValaList* _tmp269_;
			gpointer _tmp270_;
			ValaClass* _tmp271_;
			_cl_index = _cl_index + 1;
			_tmp267_ = _cl_index;
			_tmp268_ = _cl_size;
			if (!(_tmp267_ < _tmp268_)) {
				break;
			}
			_tmp269_ = _cl_list;
			_tmp270_ = vala_list_get (_tmp269_, _cl_index);
			cl = (ValaClass*) _tmp270_;
			_tmp271_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp271_, context);
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp272_;
		gint _iface_size = 0;
		ValaList* _tmp273_;
		gint _tmp274_;
		gint _tmp275_;
		gint _iface_index = 0;
		_tmp272_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_iface_list = _tmp272_;
		_tmp273_ = _iface_list;
		_tmp274_ = vala_collection_get_size ((ValaCollection*) _tmp273_);
		_tmp275_ = _tmp274_;
		_iface_size = _tmp275_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp276_;
			gint _tmp277_;
			ValaInterface* iface = NULL;
			ValaList* _tmp278_;
			gpointer _tmp279_;
			ValaInterface* _tmp280_;
			_iface_index = _iface_index + 1;
			_tmp276_ = _iface_index;
			_tmp277_ = _iface_size;
			if (!(_tmp276_ < _tmp277_)) {
				break;
			}
			_tmp278_ = _iface_list;
			_tmp279_ = vala_list_get (_tmp278_, _iface_index);
			iface = (ValaInterface*) _tmp279_;
			_tmp280_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp280_, context);
			_vala_code_node_unref0 (iface);
		}
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp281_;
		gint _st_size = 0;
		ValaList* _tmp282_;
		gint _tmp283_;
		gint _tmp284_;
		gint _st_index = 0;
		_tmp281_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp281_;
		_tmp282_ = _st_list;
		_tmp283_ = vala_collection_get_size ((ValaCollection*) _tmp282_);
		_tmp284_ = _tmp283_;
		_st_size = _tmp284_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp285_;
			gint _tmp286_;
			ValaStruct* st = NULL;
			ValaList* _tmp287_;
			gpointer _tmp288_;
			ValaStruct* _tmp289_;
			_st_index = _st_index + 1;
			_tmp285_ = _st_index;
			_tmp286_ = _st_size;
			if (!(_tmp285_ < _tmp286_)) {
				break;
			}
			_tmp287_ = _st_list;
			_tmp288_ = vala_list_get (_tmp287_, _st_index);
			st = (ValaStruct*) _tmp288_;
			_tmp289_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp289_, context);
			_vala_code_node_unref0 (st);
		}
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp290_;
		gint _d_size = 0;
		ValaList* _tmp291_;
		gint _tmp292_;
		gint _tmp293_;
		gint _d_index = 0;
		_tmp290_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp290_;
		_tmp291_ = _d_list;
		_tmp292_ = vala_collection_get_size ((ValaCollection*) _tmp291_);
		_tmp293_ = _tmp292_;
		_d_size = _tmp293_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp294_;
			gint _tmp295_;
			ValaDelegate* d = NULL;
			ValaList* _tmp296_;
			gpointer _tmp297_;
			ValaDelegate* _tmp298_;
			_d_index = _d_index + 1;
			_tmp294_ = _d_index;
			_tmp295_ = _d_size;
			if (!(_tmp294_ < _tmp295_)) {
				break;
			}
			_tmp296_ = _d_list;
			_tmp297_ = vala_list_get (_tmp296_, _d_index);
			d = (ValaDelegate*) _tmp297_;
			_tmp298_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp298_, context);
			_vala_code_node_unref0 (d);
		}
	}
	_tmp299_ = vala_class_get_is_compact (self);
	_tmp300_ = _tmp299_;
	if (_tmp300_) {
		gboolean _tmp316_ = FALSE;
		gboolean _tmp317_ = FALSE;
		gboolean _tmp318_ = FALSE;
		gboolean _tmp319_;
		gboolean _tmp320_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp301_;
			gint _base_type_size = 0;
			ValaList* _tmp302_;
			gint _tmp303_;
			gint _tmp304_;
			gint _base_type_index = 0;
			_tmp301_ = vala_class_get_base_types (self);
			_base_type_list = _tmp301_;
			_tmp302_ = _base_type_list;
			_tmp303_ = vala_collection_get_size ((ValaCollection*) _tmp302_);
			_tmp304_ = _tmp303_;
			_base_type_size = _tmp304_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp305_;
				gint _tmp306_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp307_;
				gpointer _tmp308_;
				ValaDataType* _tmp309_;
				ValaTypeSymbol* _tmp310_;
				ValaTypeSymbol* _tmp311_;
				_base_type_index = _base_type_index + 1;
				_tmp305_ = _base_type_index;
				_tmp306_ = _base_type_size;
				if (!(_tmp305_ < _tmp306_)) {
					break;
				}
				_tmp307_ = _base_type_list;
				_tmp308_ = vala_list_get (_tmp307_, _base_type_index);
				base_type = (ValaDataType*) _tmp308_;
				_tmp309_ = base_type;
				_tmp310_ = vala_data_type_get_type_symbol (_tmp309_);
				_tmp311_ = _tmp310_;
				if (VALA_IS_INTERFACE (_tmp311_)) {
					ValaSourceReference* _tmp312_;
					ValaSourceReference* _tmp313_;
					gchar* _tmp314_;
					gchar* _tmp315_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp312_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp313_ = _tmp312_;
					_tmp314_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp315_ = _tmp314_;
					vala_report_error (_tmp313_, "compact classes `%s' may not implement interfaces", _tmp315_);
					_g_free0 (_tmp315_);
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp319_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp320_ = _tmp319_;
		if (!_tmp320_) {
			gboolean _tmp321_;
			gboolean _tmp322_;
			_tmp321_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp322_ = _tmp321_;
			_tmp318_ = !_tmp322_;
		} else {
			_tmp318_ = FALSE;
		}
		if (_tmp318_) {
			ValaClass* _tmp323_;
			_tmp323_ = self->priv->_base_class;
			_tmp317_ = _tmp323_ != NULL;
		} else {
			_tmp317_ = FALSE;
		}
		if (_tmp317_) {
			ValaClass* _tmp324_;
			ValaSemanticAnalyzer* _tmp325_;
			ValaSemanticAnalyzer* _tmp326_;
			ValaClass* _tmp327_;
			_tmp324_ = self->priv->_base_class;
			_tmp325_ = vala_code_context_get_analyzer (context);
			_tmp326_ = _tmp325_;
			_tmp327_ = _tmp326_->gsource_type;
			_tmp316_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp324_, (ValaTypeSymbol*) _tmp327_);
		} else {
			_tmp316_ = FALSE;
		}
		if (_tmp316_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp328_;
				gint _f_size = 0;
				ValaList* _tmp329_;
				gint _tmp330_;
				gint _tmp331_;
				gint _f_index = 0;
				_tmp328_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp328_;
				_tmp329_ = _f_list;
				_tmp330_ = vala_collection_get_size ((ValaCollection*) _tmp329_);
				_tmp331_ = _tmp330_;
				_f_size = _tmp331_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp332_;
					gint _tmp333_;
					ValaField* f = NULL;
					ValaList* _tmp334_;
					gpointer _tmp335_;
					ValaField* _tmp336_;
					ValaMemberBinding _tmp337_;
					ValaMemberBinding _tmp338_;
					_f_index = _f_index + 1;
					_tmp332_ = _f_index;
					_tmp333_ = _f_size;
					if (!(_tmp332_ < _tmp333_)) {
						break;
					}
					_tmp334_ = _f_list;
					_tmp335_ = vala_list_get (_tmp334_, _f_index);
					f = (ValaField*) _tmp335_;
					_tmp336_ = f;
					_tmp337_ = vala_field_get_binding (_tmp336_);
					_tmp338_ = _tmp337_;
					if (_tmp338_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp339_;
						ValaSourceReference* _tmp340_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp339_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp340_ = _tmp339_;
						vala_report_error (_tmp340_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
			}
		}
	}
	_tmp341_ = g_direct_equal;
	_tmp342_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp341_);
	prerequisites = (ValaList*) _tmp342_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp343_;
		gint _base_type_size = 0;
		ValaList* _tmp344_;
		gint _tmp345_;
		gint _tmp346_;
		gint _base_type_index = 0;
		_tmp343_ = vala_class_get_base_types (self);
		_base_type_list = _tmp343_;
		_tmp344_ = _base_type_list;
		_tmp345_ = vala_collection_get_size ((ValaCollection*) _tmp344_);
		_tmp346_ = _tmp345_;
		_base_type_size = _tmp346_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp347_;
			gint _tmp348_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp349_;
			gpointer _tmp350_;
			ValaDataType* _tmp351_;
			ValaTypeSymbol* _tmp352_;
			ValaTypeSymbol* _tmp353_;
			_base_type_index = _base_type_index + 1;
			_tmp347_ = _base_type_index;
			_tmp348_ = _base_type_size;
			if (!(_tmp347_ < _tmp348_)) {
				break;
			}
			_tmp349_ = _base_type_list;
			_tmp350_ = vala_list_get (_tmp349_, _base_type_index);
			base_type = (ValaDataType*) _tmp350_;
			_tmp351_ = base_type;
			_tmp352_ = vala_data_type_get_type_symbol (_tmp351_);
			_tmp353_ = _tmp352_;
			if (VALA_IS_INTERFACE (_tmp353_)) {
				ValaDataType* _tmp354_;
				ValaTypeSymbol* _tmp355_;
				ValaTypeSymbol* _tmp356_;
				ValaList* _tmp357_;
				_tmp354_ = base_type;
				_tmp355_ = vala_data_type_get_type_symbol (_tmp354_);
				_tmp356_ = _tmp355_;
				_tmp357_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp356_, VALA_TYPE_INTERFACE, ValaInterface), _tmp357_);
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	_tmp358_ = g_str_equal;
	_tmp359_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp358_);
	missing_prereqs = (ValaList*) _tmp359_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp360_;
		gint _prereq_size = 0;
		ValaList* _tmp361_;
		gint _tmp362_;
		gint _tmp363_;
		gint _prereq_index = 0;
		_tmp360_ = prerequisites;
		_prereq_list = _tmp360_;
		_tmp361_ = _prereq_list;
		_tmp362_ = vala_collection_get_size ((ValaCollection*) _tmp361_);
		_tmp363_ = _tmp362_;
		_prereq_size = _tmp363_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp364_;
			gint _tmp365_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp366_;
			gpointer _tmp367_;
			ValaTypeSymbol* _tmp368_;
			_prereq_index = _prereq_index + 1;
			_tmp364_ = _prereq_index;
			_tmp365_ = _prereq_size;
			if (!(_tmp364_ < _tmp365_)) {
				break;
			}
			_tmp366_ = _prereq_list;
			_tmp367_ = vala_list_get (_tmp366_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp367_;
			_tmp368_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp368_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp369_;
				ValaTypeSymbol* _tmp370_;
				gchar* _tmp371_;
				gchar* _tmp372_;
				_tmp369_ = missing_prereqs;
				_tmp370_ = prereq;
				_tmp371_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp370_);
				_tmp372_ = _tmp371_;
				vala_list_insert (_tmp369_, 0, _tmp372_);
				_g_free0 (_tmp372_);
			}
			_vala_code_node_unref0 (prereq);
		}
	}
	_tmp373_ = missing_prereqs;
	_tmp374_ = vala_collection_get_size ((ValaCollection*) _tmp373_);
	_tmp375_ = _tmp374_;
	if (_tmp375_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp376_;
		gchar* _tmp377_;
		gchar* _tmp378_;
		gchar* _tmp379_;
		gboolean first = FALSE;
		const gchar* _tmp394_;
		gchar* _tmp395_;
		ValaSourceReference* _tmp396_;
		ValaSourceReference* _tmp397_;
		const gchar* _tmp398_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp376_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp377_ = _tmp376_;
		_tmp378_ = g_strdup_printf ("%s: some prerequisites (", _tmp377_);
		_tmp379_ = _tmp378_;
		_g_free0 (_tmp377_);
		error_string = _tmp379_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp380_;
			gint _s_size = 0;
			ValaList* _tmp381_;
			gint _tmp382_;
			gint _tmp383_;
			gint _s_index = 0;
			_tmp380_ = missing_prereqs;
			_s_list = _tmp380_;
			_tmp381_ = _s_list;
			_tmp382_ = vala_collection_get_size ((ValaCollection*) _tmp381_);
			_tmp383_ = _tmp382_;
			_s_size = _tmp383_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp384_;
				gint _tmp385_;
				gchar* s = NULL;
				ValaList* _tmp386_;
				gpointer _tmp387_;
				_s_index = _s_index + 1;
				_tmp384_ = _s_index;
				_tmp385_ = _s_size;
				if (!(_tmp384_ < _tmp385_)) {
					break;
				}
				_tmp386_ = _s_list;
				_tmp387_ = vala_list_get (_tmp386_, _s_index);
				s = (gchar*) _tmp387_;
				if (first) {
					const gchar* _tmp388_;
					const gchar* _tmp389_;
					gchar* _tmp390_;
					_tmp388_ = error_string;
					_tmp389_ = s;
					_tmp390_ = g_strdup_printf ("%s`%s'", _tmp388_, _tmp389_);
					_g_free0 (error_string);
					error_string = _tmp390_;
					first = FALSE;
				} else {
					const gchar* _tmp391_;
					const gchar* _tmp392_;
					gchar* _tmp393_;
					_tmp391_ = error_string;
					_tmp392_ = s;
					_tmp393_ = g_strdup_printf ("%s, `%s'", _tmp391_, _tmp392_);
					_g_free0 (error_string);
					error_string = _tmp393_;
				}
				_g_free0 (s);
			}
		}
		_tmp394_ = error_string;
		_tmp395_ = g_strconcat (_tmp394_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp395_;
		_tmp396_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp397_ = _tmp396_;
		_tmp398_ = error_string;
		vala_report_error (_tmp397_, "%s", _tmp398_);
		_g_free0 (error_string);
	}
	_tmp399_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp400_ = _tmp399_;
	if (_tmp400_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp551_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp401_;
			gint _base_type_size = 0;
			ValaList* _tmp402_;
			gint _tmp403_;
			gint _tmp404_;
			gint _base_type_index = 0;
			_tmp401_ = vala_class_get_base_types (self);
			_base_type_list = _tmp401_;
			_tmp402_ = _base_type_list;
			_tmp403_ = vala_collection_get_size ((ValaCollection*) _tmp402_);
			_tmp404_ = _tmp403_;
			_base_type_size = _tmp404_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp405_;
				gint _tmp406_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp407_;
				gpointer _tmp408_;
				ValaDataType* _tmp409_;
				ValaTypeSymbol* _tmp410_;
				ValaTypeSymbol* _tmp411_;
				_base_type_index = _base_type_index + 1;
				_tmp405_ = _base_type_index;
				_tmp406_ = _base_type_size;
				if (!(_tmp405_ < _tmp406_)) {
					break;
				}
				_tmp407_ = _base_type_list;
				_tmp408_ = vala_list_get (_tmp407_, _base_type_index);
				base_type = (ValaDataType*) _tmp408_;
				_tmp409_ = base_type;
				_tmp410_ = vala_data_type_get_type_symbol (_tmp409_);
				_tmp411_ = _tmp410_;
				if (VALA_IS_INTERFACE (_tmp411_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp412_;
					ValaTypeSymbol* _tmp413_;
					ValaTypeSymbol* _tmp414_;
					gboolean _tmp415_ = FALSE;
					ValaClass* _tmp416_;
					_tmp412_ = base_type;
					_tmp413_ = vala_data_type_get_type_symbol (_tmp412_);
					_tmp414_ = _tmp413_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp414_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp416_ = self->priv->_base_class;
					if (_tmp416_ != NULL) {
						ValaClass* _tmp417_;
						ValaInterface* _tmp418_;
						_tmp417_ = self->priv->_base_class;
						_tmp418_ = iface;
						_tmp415_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp417_, (ValaTypeSymbol*) _tmp418_);
					} else {
						_tmp415_ = FALSE;
					}
					if (_tmp415_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp419_;
						ValaList* _tmp420_;
						gint _m_size = 0;
						ValaList* _tmp421_;
						gint _tmp422_;
						gint _tmp423_;
						gint _m_index = 0;
						_tmp419_ = iface;
						_tmp420_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp419_);
						_m_list = _tmp420_;
						_tmp421_ = _m_list;
						_tmp422_ = vala_collection_get_size ((ValaCollection*) _tmp421_);
						_tmp423_ = _tmp422_;
						_m_size = _tmp423_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp424_;
							gint _tmp425_;
							ValaMethod* m = NULL;
							ValaList* _tmp426_;
							gpointer _tmp427_;
							ValaMethod* _tmp428_;
							gboolean _tmp429_;
							gboolean _tmp430_;
							_m_index = _m_index + 1;
							_tmp424_ = _m_index;
							_tmp425_ = _m_size;
							if (!(_tmp424_ < _tmp425_)) {
								break;
							}
							_tmp426_ = _m_list;
							_tmp427_ = vala_list_get (_tmp426_, _m_index);
							m = (ValaMethod*) _tmp427_;
							_tmp428_ = m;
							_tmp429_ = vala_method_get_is_abstract (_tmp428_);
							_tmp430_ = _tmp429_;
							if (_tmp430_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp431_ = FALSE;
									ValaClass* _tmp432_;
									ValaClass* _tmp485_;
									ValaClass* _tmp486_;
									_tmp432_ = base_class;
									if (_tmp432_ != NULL) {
										_tmp431_ = !implemented;
									} else {
										_tmp431_ = FALSE;
									}
									if (!_tmp431_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp433_;
										ValaList* _tmp434_;
										gint _impl_size = 0;
										ValaList* _tmp435_;
										gint _tmp436_;
										gint _tmp437_;
										gint _impl_index = 0;
										_tmp433_ = base_class;
										_tmp434_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp433_);
										_impl_list = _tmp434_;
										_tmp435_ = _impl_list;
										_tmp436_ = vala_collection_get_size ((ValaCollection*) _tmp435_);
										_tmp437_ = _tmp436_;
										_impl_size = _tmp437_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp438_;
											gint _tmp439_;
											ValaMethod* impl = NULL;
											ValaList* _tmp440_;
											gpointer _tmp441_;
											gboolean _tmp442_ = FALSE;
											ValaMethod* _tmp443_;
											ValaMethod* _tmp444_;
											ValaMethod* _tmp445_;
											ValaMethod* _tmp446_;
											_impl_index = _impl_index + 1;
											_tmp438_ = _impl_index;
											_tmp439_ = _impl_size;
											if (!(_tmp438_ < _tmp439_)) {
												break;
											}
											_tmp440_ = _impl_list;
											_tmp441_ = vala_list_get (_tmp440_, _impl_index);
											impl = (ValaMethod*) _tmp441_;
											_tmp443_ = impl;
											_tmp444_ = vala_method_get_base_interface_method (_tmp443_);
											_tmp445_ = _tmp444_;
											_tmp446_ = m;
											if (_tmp445_ == _tmp446_) {
												_tmp442_ = TRUE;
											} else {
												gboolean _tmp447_ = FALSE;
												gboolean _tmp448_ = FALSE;
												gboolean _tmp449_ = FALSE;
												gboolean _tmp450_ = FALSE;
												ValaClass* _tmp451_;
												_tmp451_ = base_class;
												if (_tmp451_ != self) {
													ValaMethod* _tmp452_;
													ValaMethod* _tmp453_;
													ValaMethod* _tmp454_;
													_tmp452_ = impl;
													_tmp453_ = vala_method_get_base_interface_method (_tmp452_);
													_tmp454_ = _tmp453_;
													_tmp450_ = _tmp454_ == NULL;
												} else {
													_tmp450_ = FALSE;
												}
												if (_tmp450_) {
													ValaMethod* _tmp455_;
													const gchar* _tmp456_;
													const gchar* _tmp457_;
													ValaMethod* _tmp458_;
													const gchar* _tmp459_;
													const gchar* _tmp460_;
													_tmp455_ = impl;
													_tmp456_ = vala_symbol_get_name ((ValaSymbol*) _tmp455_);
													_tmp457_ = _tmp456_;
													_tmp458_ = m;
													_tmp459_ = vala_symbol_get_name ((ValaSymbol*) _tmp458_);
													_tmp460_ = _tmp459_;
													_tmp449_ = g_strcmp0 (_tmp457_, _tmp460_) == 0;
												} else {
													_tmp449_ = FALSE;
												}
												if (_tmp449_) {
													gboolean _tmp461_ = FALSE;
													ValaMethod* _tmp462_;
													ValaDataType* _tmp463_;
													ValaDataType* _tmp464_;
													_tmp462_ = impl;
													_tmp463_ = vala_method_get_base_interface_type (_tmp462_);
													_tmp464_ = _tmp463_;
													if (_tmp464_ == NULL) {
														_tmp461_ = TRUE;
													} else {
														ValaMethod* _tmp465_;
														ValaDataType* _tmp466_;
														ValaDataType* _tmp467_;
														ValaTypeSymbol* _tmp468_;
														ValaTypeSymbol* _tmp469_;
														ValaInterface* _tmp470_;
														_tmp465_ = impl;
														_tmp466_ = vala_method_get_base_interface_type (_tmp465_);
														_tmp467_ = _tmp466_;
														_tmp468_ = vala_data_type_get_type_symbol (_tmp467_);
														_tmp469_ = _tmp468_;
														_tmp470_ = iface;
														_tmp461_ = _tmp469_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp470_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp448_ = _tmp461_;
												} else {
													_tmp448_ = FALSE;
												}
												if (_tmp448_) {
													ValaMethod* _tmp471_;
													ValaMethod* _tmp472_;
													_tmp471_ = impl;
													_tmp472_ = m;
													_tmp447_ = vala_method_compatible_no_error (_tmp471_, _tmp472_);
												} else {
													_tmp447_ = FALSE;
												}
												_tmp442_ = _tmp447_;
											}
											if (_tmp442_) {
												ValaMethod* _tmp473_;
												ValaVersionAttribute* _tmp474_;
												ValaVersionAttribute* _tmp475_;
												ValaSourceReference* _tmp476_;
												ValaSourceReference* _tmp477_;
												ValaMethod* _tmp478_;
												ValaMethod* _tmp479_;
												ValaMethod* _tmp480_;
												ValaMethod* _tmp481_;
												_tmp473_ = impl;
												_tmp474_ = vala_symbol_get_version ((ValaSymbol*) _tmp473_);
												_tmp475_ = _tmp474_;
												_tmp476_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp477_ = _tmp476_;
												vala_version_attribute_check (_tmp475_, context, _tmp477_);
												_tmp478_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp478_, TRUE);
												implemented = TRUE;
												_tmp479_ = impl;
												_tmp480_ = vala_method_get_base_interface_method (_tmp479_);
												_tmp481_ = _tmp480_;
												if (_tmp481_ == NULL) {
													ValaHashMap* _tmp482_;
													ValaMethod* _tmp483_;
													ValaMethod* _tmp484_;
													_tmp482_ = self->priv->implicit_implementations;
													_tmp483_ = m;
													_tmp484_ = impl;
													vala_map_set ((ValaMap*) _tmp482_, _tmp483_, _tmp484_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
									}
									_tmp485_ = base_class;
									_tmp486_ = _tmp485_->priv->_base_class;
									base_class = _tmp486_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp487_;
									ValaSourceReference* _tmp488_;
									gchar* _tmp489_;
									gchar* _tmp490_;
									ValaMethod* _tmp491_;
									gchar* _tmp492_;
									gchar* _tmp493_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp487_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp488_ = _tmp487_;
									_tmp489_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp490_ = _tmp489_;
									_tmp491_ = m;
									_tmp492_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp491_);
									_tmp493_ = _tmp492_;
									vala_report_error (_tmp488_, "`%s' does not implement interface method `%s'", _tmp490_, _tmp493_);
									_g_free0 (_tmp493_);
									_g_free0 (_tmp490_);
								}
							}
							_vala_code_node_unref0 (m);
						}
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp494_;
						ValaList* _tmp495_;
						gint _prop_size = 0;
						ValaList* _tmp496_;
						gint _tmp497_;
						gint _tmp498_;
						gint _prop_index = 0;
						_tmp494_ = iface;
						_tmp495_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp494_);
						_prop_list = _tmp495_;
						_tmp496_ = _prop_list;
						_tmp497_ = vala_collection_get_size ((ValaCollection*) _tmp496_);
						_tmp498_ = _tmp497_;
						_prop_size = _tmp498_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp499_;
							gint _tmp500_;
							ValaProperty* prop = NULL;
							ValaList* _tmp501_;
							gpointer _tmp502_;
							ValaProperty* _tmp503_;
							gboolean _tmp504_;
							gboolean _tmp505_;
							_prop_index = _prop_index + 1;
							_tmp499_ = _prop_index;
							_tmp500_ = _prop_size;
							if (!(_tmp499_ < _tmp500_)) {
								break;
							}
							_tmp501_ = _prop_list;
							_tmp502_ = vala_list_get (_tmp501_, _prop_index);
							prop = (ValaProperty*) _tmp502_;
							_tmp503_ = prop;
							_tmp504_ = vala_property_get_is_abstract (_tmp503_);
							_tmp505_ = _tmp504_;
							if (_tmp505_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp518_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp506_ = FALSE;
									ValaClass* _tmp507_;
									ValaClass* _tmp509_;
									ValaScope* _tmp510_;
									ValaScope* _tmp511_;
									ValaProperty* _tmp512_;
									const gchar* _tmp513_;
									const gchar* _tmp514_;
									ValaSymbol* _tmp515_;
									ValaClass* _tmp516_;
									ValaClass* _tmp517_;
									_tmp507_ = base_class;
									if (_tmp507_ != NULL) {
										ValaSymbol* _tmp508_;
										_tmp508_ = sym;
										_tmp506_ = !VALA_IS_PROPERTY (_tmp508_);
									} else {
										_tmp506_ = FALSE;
									}
									if (!_tmp506_) {
										break;
									}
									_tmp509_ = base_class;
									_tmp510_ = vala_symbol_get_scope ((ValaSymbol*) _tmp509_);
									_tmp511_ = _tmp510_;
									_tmp512_ = prop;
									_tmp513_ = vala_symbol_get_name ((ValaSymbol*) _tmp512_);
									_tmp514_ = _tmp513_;
									_tmp515_ = vala_scope_lookup (_tmp511_, _tmp514_);
									_vala_code_node_unref0 (sym);
									sym = _tmp515_;
									_tmp516_ = base_class;
									_tmp517_ = _tmp516_->priv->_base_class;
									base_class = _tmp517_;
								}
								_tmp518_ = sym;
								if (VALA_IS_PROPERTY (_tmp518_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp519_;
									ValaProperty* _tmp520_;
									gchar* invalid_match = NULL;
									gboolean _tmp521_ = FALSE;
									ValaProperty* _tmp522_;
									gboolean _tmp523_;
									gboolean _tmp524_;
									ValaSymbol* _tmp538_;
									ValaVersionAttribute* _tmp539_;
									ValaVersionAttribute* _tmp540_;
									ValaSourceReference* _tmp541_;
									ValaSourceReference* _tmp542_;
									ValaSymbol* _tmp543_;
									_tmp519_ = sym;
									_tmp520_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp519_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp520_;
									invalid_match = NULL;
									_tmp522_ = base_prop;
									_tmp523_ = vala_symbol_get_hides ((ValaSymbol*) _tmp522_);
									_tmp524_ = _tmp523_;
									if (!_tmp524_) {
										ValaProperty* _tmp525_;
										ValaProperty* _tmp526_;
										gchar* _tmp527_ = NULL;
										gboolean _tmp528_;
										_tmp525_ = base_prop;
										_tmp526_ = prop;
										_tmp528_ = vala_property_compatible (_tmp525_, _tmp526_, &_tmp527_);
										_g_free0 (invalid_match);
										invalid_match = _tmp527_;
										_tmp521_ = !_tmp528_;
									} else {
										_tmp521_ = FALSE;
									}
									if (_tmp521_) {
										ValaSourceReference* _tmp529_;
										ValaSourceReference* _tmp530_;
										ValaProperty* _tmp531_;
										gchar* _tmp532_;
										gchar* _tmp533_;
										ValaProperty* _tmp534_;
										gchar* _tmp535_;
										gchar* _tmp536_;
										const gchar* _tmp537_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp529_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp530_ = _tmp529_;
										_tmp531_ = prop;
										_tmp532_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp531_);
										_tmp533_ = _tmp532_;
										_tmp534_ = base_prop;
										_tmp535_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp534_);
										_tmp536_ = _tmp535_;
										_tmp537_ = invalid_match;
										vala_report_error (_tmp530_, "Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp533_, _tmp536_, _tmp537_);
										_g_free0 (_tmp536_);
										_g_free0 (_tmp533_);
									}
									_tmp538_ = sym;
									_tmp539_ = vala_symbol_get_version (_tmp538_);
									_tmp540_ = _tmp539_;
									_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp542_ = _tmp541_;
									vala_version_attribute_check (_tmp540_, context, _tmp542_);
									_tmp543_ = sym;
									vala_symbol_set_used (_tmp543_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp544_;
									ValaSourceReference* _tmp545_;
									gchar* _tmp546_;
									gchar* _tmp547_;
									ValaProperty* _tmp548_;
									gchar* _tmp549_;
									gchar* _tmp550_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp544_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp545_ = _tmp544_;
									_tmp546_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp547_ = _tmp546_;
									_tmp548_ = prop;
									_tmp549_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp548_);
									_tmp550_ = _tmp549_;
									vala_report_error (_tmp545_, "`%s' does not implement interface property `%s'", _tmp547_, _tmp550_);
									_g_free0 (_tmp550_);
									_g_free0 (_tmp547_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp551_ = self->priv->_is_abstract;
		if (!_tmp551_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp552_;
			_tmp552_ = self->priv->_base_class;
			base_class = _tmp552_;
			while (TRUE) {
				gboolean _tmp553_ = FALSE;
				ValaClass* _tmp554_;
				ValaClass* _tmp615_;
				ValaClass* _tmp616_;
				_tmp554_ = base_class;
				if (_tmp554_ != NULL) {
					ValaClass* _tmp555_;
					gboolean _tmp556_;
					_tmp555_ = base_class;
					_tmp556_ = _tmp555_->priv->_is_abstract;
					_tmp553_ = _tmp556_;
				} else {
					_tmp553_ = FALSE;
				}
				if (!_tmp553_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp557_;
					ValaList* _tmp558_;
					gint _base_method_size = 0;
					ValaList* _tmp559_;
					gint _tmp560_;
					gint _tmp561_;
					gint _base_method_index = 0;
					_tmp557_ = base_class;
					_tmp558_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp557_);
					_base_method_list = _tmp558_;
					_tmp559_ = _base_method_list;
					_tmp560_ = vala_collection_get_size ((ValaCollection*) _tmp559_);
					_tmp561_ = _tmp560_;
					_base_method_size = _tmp561_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp562_;
						gint _tmp563_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp564_;
						gpointer _tmp565_;
						ValaMethod* _tmp566_;
						gboolean _tmp567_;
						gboolean _tmp568_;
						_base_method_index = _base_method_index + 1;
						_tmp562_ = _base_method_index;
						_tmp563_ = _base_method_size;
						if (!(_tmp562_ < _tmp563_)) {
							break;
						}
						_tmp564_ = _base_method_list;
						_tmp565_ = vala_list_get (_tmp564_, _base_method_index);
						base_method = (ValaMethod*) _tmp565_;
						_tmp566_ = base_method;
						_tmp567_ = vala_method_get_is_abstract (_tmp566_);
						_tmp568_ = _tmp567_;
						if (_tmp568_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp569_;
							const gchar* _tmp570_;
							const gchar* _tmp571_;
							ValaSymbol* _tmp572_;
							ValaMethod* _tmp573_;
							gboolean _tmp574_ = FALSE;
							ValaMethod* _tmp575_;
							_tmp569_ = base_method;
							_tmp570_ = vala_symbol_get_name ((ValaSymbol*) _tmp569_);
							_tmp571_ = _tmp570_;
							_tmp572_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp571_);
							_tmp573_ = VALA_IS_METHOD (_tmp572_) ? ((ValaMethod*) _tmp572_) : NULL;
							if (_tmp573_ == NULL) {
								_vala_code_node_unref0 (_tmp572_);
							}
							override_method = _tmp573_;
							_tmp575_ = override_method;
							if (_tmp575_ == NULL) {
								_tmp574_ = TRUE;
							} else {
								ValaMethod* _tmp576_;
								gboolean _tmp577_;
								gboolean _tmp578_;
								_tmp576_ = override_method;
								_tmp577_ = vala_method_get_overrides (_tmp576_);
								_tmp578_ = _tmp577_;
								_tmp574_ = !_tmp578_;
							}
							if (_tmp574_) {
								ValaSourceReference* _tmp579_;
								ValaSourceReference* _tmp580_;
								gchar* _tmp581_;
								gchar* _tmp582_;
								ValaMethod* _tmp583_;
								gchar* _tmp584_;
								gchar* _tmp585_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp579_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp580_ = _tmp579_;
								_tmp581_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp582_ = _tmp581_;
								_tmp583_ = base_method;
								_tmp584_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp583_);
								_tmp585_ = _tmp584_;
								vala_report_error (_tmp580_, "`%s' does not implement abstract method `%s'", _tmp582_, _tmp585_);
								_g_free0 (_tmp585_);
								_g_free0 (_tmp582_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp586_;
					ValaList* _tmp587_;
					gint _base_property_size = 0;
					ValaList* _tmp588_;
					gint _tmp589_;
					gint _tmp590_;
					gint _base_property_index = 0;
					_tmp586_ = base_class;
					_tmp587_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp586_);
					_base_property_list = _tmp587_;
					_tmp588_ = _base_property_list;
					_tmp589_ = vala_collection_get_size ((ValaCollection*) _tmp588_);
					_tmp590_ = _tmp589_;
					_base_property_size = _tmp590_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp591_;
						gint _tmp592_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp593_;
						gpointer _tmp594_;
						ValaProperty* _tmp595_;
						gboolean _tmp596_;
						gboolean _tmp597_;
						_base_property_index = _base_property_index + 1;
						_tmp591_ = _base_property_index;
						_tmp592_ = _base_property_size;
						if (!(_tmp591_ < _tmp592_)) {
							break;
						}
						_tmp593_ = _base_property_list;
						_tmp594_ = vala_list_get (_tmp593_, _base_property_index);
						base_property = (ValaProperty*) _tmp594_;
						_tmp595_ = base_property;
						_tmp596_ = vala_property_get_is_abstract (_tmp595_);
						_tmp597_ = _tmp596_;
						if (_tmp597_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp598_;
							const gchar* _tmp599_;
							const gchar* _tmp600_;
							ValaSymbol* _tmp601_;
							ValaProperty* _tmp602_;
							gboolean _tmp603_ = FALSE;
							ValaProperty* _tmp604_;
							_tmp598_ = base_property;
							_tmp599_ = vala_symbol_get_name ((ValaSymbol*) _tmp598_);
							_tmp600_ = _tmp599_;
							_tmp601_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp600_);
							_tmp602_ = VALA_IS_PROPERTY (_tmp601_) ? ((ValaProperty*) _tmp601_) : NULL;
							if (_tmp602_ == NULL) {
								_vala_code_node_unref0 (_tmp601_);
							}
							override_property = _tmp602_;
							_tmp604_ = override_property;
							if (_tmp604_ == NULL) {
								_tmp603_ = TRUE;
							} else {
								ValaProperty* _tmp605_;
								gboolean _tmp606_;
								gboolean _tmp607_;
								_tmp605_ = override_property;
								_tmp606_ = vala_property_get_overrides (_tmp605_);
								_tmp607_ = _tmp606_;
								_tmp603_ = !_tmp607_;
							}
							if (_tmp603_) {
								ValaSourceReference* _tmp608_;
								ValaSourceReference* _tmp609_;
								gchar* _tmp610_;
								gchar* _tmp611_;
								ValaProperty* _tmp612_;
								gchar* _tmp613_;
								gchar* _tmp614_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp608_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp609_ = _tmp608_;
								_tmp610_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp611_ = _tmp610_;
								_tmp612_ = base_property;
								_tmp613_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp612_);
								_tmp614_ = _tmp613_;
								vala_report_error (_tmp609_, "`%s' does not implement abstract property `%s'", _tmp611_, _tmp614_);
								_g_free0 (_tmp614_);
								_g_free0 (_tmp611_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
				}
				_tmp615_ = base_class;
				_tmp616_ = _tmp615_->priv->_base_class;
				base_class = _tmp616_;
			}
		}
	}
	_tmp617_ = vala_code_context_get_analyzer (context);
	_tmp618_ = _tmp617_;
	_tmp619_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp618_, _tmp619_);
	_tmp620_ = vala_code_context_get_analyzer (context);
	_tmp621_ = _tmp620_;
	_tmp622_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp621_, _tmp622_);
	_tmp623_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp624_ = _tmp623_;
	result = !_tmp624_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_symbol_hash_func_ghash_func, _vala_symbol_equal_func_gequal_func, _tmp2_);
	self->priv->implicit_implementations = _tmp3_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_opaque);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}

