/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};

static gint ValaInterface_private_offset;
static gpointer vala_interface_parent_class = NULL;

static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);
static GType vala_interface_get_type_once (void);

static inline gpointer
vala_interface_get_instance_private (ValaInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInterface_private_offset);
}

/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}

/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp18_ = FALSE;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		_tmp4_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_parameter_new ("this", _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		vala_method_set_this_parameter (m, _tmp9_);
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_method_get_this_parameter (m);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_get_this_parameter (m);
		_tmp17_ = _tmp16_;
		vala_scope_add (_tmp11_, _tmp15_, (ValaSymbol*) _tmp17_);
	}
	_tmp19_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp20_ = _tmp19_;
	if (!VALA_IS_VOID_TYPE (_tmp20_)) {
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp21_ = vala_method_get_postconditions (m);
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp18_ = _tmp23_ > 0;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaDataType* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaSourceReference* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		ValaLocalVariable* _tmp33_;
		_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_data_type_copy (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_local_variable_new (_tmp27_, "result", NULL, _tmp29_);
		_tmp31_ = _tmp30_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp31_);
		_vala_code_node_unref0 (_tmp31_);
		_vala_code_node_unref0 (_tmp27_);
		_tmp32_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp33_ = _tmp32_;
		vala_local_variable_set_is_result (_tmp33_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaMemberBinding _tmp4_;
	ValaMemberBinding _tmp5_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "interface properties should be `abstract' or have `get' accessor and/o" \
"r `set' mutator");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_property_get_binding (prop);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		ValaScope* _tmp12_;
		ValaScope* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		ValaParameter* _tmp18_;
		ValaParameter* _tmp19_;
		_tmp6_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_parameter_new ("this", _tmp7_, _tmp9_);
		_tmp11_ = _tmp10_;
		vala_property_set_this_parameter (prop, _tmp11_);
		_vala_code_node_unref0 (_tmp11_);
		_vala_code_node_unref0 (_tmp7_);
		_tmp12_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_property_get_this_parameter (prop);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_symbol_get_name ((ValaSymbol*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_property_get_this_parameter (prop);
		_tmp19_ = _tmp18_;
		vala_scope_add (_tmp13_, _tmp17_, (ValaSymbol*) _tmp19_);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	ValaInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_INTERFACE_GET_CLASS (self);
	if (_klass_->get_virtuals) {
		return _klass_->get_virtuals (self);
	}
	return NULL;
}

static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}

static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			_type_index = _type_index + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = vala_list_get (_tmp7_, _type_index);
			type = (ValaDataType*) _tmp8_;
			_tmp9_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
}

static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prerequisite_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prerequisite_list = _tmp1_;
		_tmp2_ = _prerequisite_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prerequisite_size = _tmp4_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_prerequisite_index = _prerequisite_index + 1;
			_tmp5_ = _prerequisite_index;
			_tmp6_ = _prerequisite_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prerequisite_list;
			_tmp8_ = vala_list_get (_tmp7_, _prerequisite_index);
			prerequisite = (ValaDataType*) _tmp8_;
			_tmp10_ = prerequisite;
			_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = prerequisite;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = vala_typesymbol_is_subtype_of (_tmp15_, t);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}

static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->prerequisites;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->prerequisites;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->prerequisites;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp139_;
	gboolean _tmp140_;
	ValaMap* positions = NULL;
	GHashFunc _tmp278_;
	GEqualFunc _tmp279_;
	GEqualFunc _tmp280_;
	ValaHashMap* _tmp281_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	ValaSemanticAnalyzer* _tmp357_;
	ValaSemanticAnalyzer* _tmp358_;
	ValaSourceFile* _tmp359_;
	ValaSemanticAnalyzer* _tmp360_;
	ValaSemanticAnalyzer* _tmp361_;
	ValaSymbol* _tmp362_;
	gboolean _tmp363_;
	gboolean _tmp364_;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_interface_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_prerequisite_reference_list = _tmp25_;
		_tmp26_ = _prerequisite_reference_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_prerequisite_reference_size = _tmp28_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp31_;
			gpointer _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaDataType* _tmp35_;
			_prerequisite_reference_index = _prerequisite_reference_index + 1;
			_tmp29_ = _prerequisite_reference_index;
			_tmp30_ = _prerequisite_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _prerequisite_reference_list;
			_tmp32_ = vala_list_get (_tmp31_, _prerequisite_reference_index);
			prerequisite_reference = (ValaDataType*) _tmp32_;
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp34_, (ValaSymbol*) self, _tmp35_)) {
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaDataType* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp37_ = _tmp36_;
				_tmp38_ = prerequisite_reference;
				_tmp39_ = vala_code_node_to_string ((ValaCodeNode*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strdup_printf ("prerequisite `%s' is less accessible than interface `%s'", _tmp40_, _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp37_, _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp45_;
		ValaList* _tmp46_;
		gint _prereq_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _prereq_index = 0;
		_tmp45_ = vala_interface_get_prerequisites (self);
		_tmp46_ = _vala_iterable_ref0 (_tmp45_);
		_prereq_list = _tmp46_;
		_tmp47_ = _prereq_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_prereq_size = _tmp49_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp52_;
			gpointer _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp64_;
			ValaTypeSymbol* _tmp65_;
			ValaTypeSymbol* _tmp66_;
			_prereq_index = _prereq_index + 1;
			_tmp50_ = _prereq_index;
			_tmp51_ = _prereq_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _prereq_list;
			_tmp53_ = vala_list_get (_tmp52_, _prereq_index);
			prereq = (ValaDataType*) _tmp53_;
			_tmp54_ = prereq;
			if (!VALA_IS_OBJECT_TYPE (_tmp54_)) {
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaDataType* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp56_ = _tmp55_;
				_tmp57_ = prereq;
				_tmp58_ = vala_code_node_to_string ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strdup_printf ("Prerequisite `%s' of interface `%s' is not a class or interface", _tmp59_, _tmp61_);
				_tmp63_ = _tmp62_;
				vala_report_error (_tmp56_, _tmp63_);
				_g_free0 (_tmp63_);
				_g_free0 (_tmp61_);
				_g_free0 (_tmp59_);
				result = FALSE;
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp64_ = prereq;
			_tmp65_ = vala_data_type_get_type_symbol (_tmp64_);
			_tmp66_ = _tmp65_;
			if (VALA_IS_CLASS (_tmp66_)) {
				ValaClass* _tmp67_;
				ValaDataType* _tmp82_;
				ValaTypeSymbol* _tmp83_;
				ValaTypeSymbol* _tmp84_;
				ValaClass* _tmp85_;
				_tmp67_ = prereq_class;
				if (_tmp67_ != NULL) {
					ValaSourceReference* _tmp68_;
					ValaSourceReference* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					ValaDataType* _tmp72_;
					ValaTypeSymbol* _tmp73_;
					ValaTypeSymbol* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					ValaClass* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp69_ = _tmp68_;
					_tmp70_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp71_ = _tmp70_;
					_tmp72_ = prereq;
					_tmp73_ = vala_data_type_get_type_symbol (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = prereq_class;
					_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp71_, _tmp76_, _tmp79_);
					_tmp81_ = _tmp80_;
					vala_report_error (_tmp69_, _tmp81_);
					_g_free0 (_tmp81_);
					_g_free0 (_tmp79_);
					_g_free0 (_tmp76_);
					_g_free0 (_tmp71_);
					result = FALSE;
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp82_ = prereq;
				_tmp83_ = vala_data_type_get_type_symbol (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp85_;
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp86_;
		ValaList* _tmp87_;
		gint _type_size = 0;
		ValaList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _type_index = 0;
		_tmp86_ = self->priv->prerequisites;
		_tmp87_ = _vala_iterable_ref0 (_tmp86_);
		_type_list = _tmp87_;
		_tmp88_ = _type_list;
		_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_type_size = _tmp90_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp91_;
			gint _tmp92_;
			ValaDataType* type = NULL;
			ValaList* _tmp93_;
			gpointer _tmp94_;
			ValaDataType* _tmp95_;
			ValaSemanticAnalyzer* _tmp96_;
			ValaSemanticAnalyzer* _tmp97_;
			ValaDataType* _tmp98_;
			_type_index = _type_index + 1;
			_tmp91_ = _type_index;
			_tmp92_ = _type_size;
			if (!(_tmp91_ < _tmp92_)) {
				break;
			}
			_tmp93_ = _type_list;
			_tmp94_ = vala_list_get (_tmp93_, _type_index);
			type = (ValaDataType*) _tmp94_;
			_tmp95_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp95_, context);
			_tmp96_ = vala_code_context_get_analyzer (context);
			_tmp97_ = _tmp96_;
			_tmp98_ = type;
			vala_semantic_analyzer_check_type (_tmp97_, _tmp98_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp99_;
		ValaList* _tmp100_;
		gint _p_size = 0;
		ValaList* _tmp101_;
		gint _tmp102_;
		gint _tmp103_;
		gint _p_index = 0;
		_tmp99_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_tmp100_ = _vala_iterable_ref0 (_tmp99_);
		_p_list = _tmp100_;
		_tmp101_ = _p_list;
		_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
		_tmp103_ = _tmp102_;
		_p_size = _tmp103_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp104_;
			gint _tmp105_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp106_;
			gpointer _tmp107_;
			ValaTypeParameter* _tmp108_;
			_p_index = _p_index + 1;
			_tmp104_ = _p_index;
			_tmp105_ = _p_size;
			if (!(_tmp104_ < _tmp105_)) {
				break;
			}
			_tmp106_ = _p_list;
			_tmp107_ = vala_list_get (_tmp106_, _p_index);
			p = (ValaTypeParameter*) _tmp107_;
			_tmp108_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp109_;
		ValaList* _tmp110_;
		gint _en_size = 0;
		ValaList* _tmp111_;
		gint _tmp112_;
		gint _tmp113_;
		gint _en_index = 0;
		_tmp109_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_tmp110_ = _vala_iterable_ref0 (_tmp109_);
		_en_list = _tmp110_;
		_tmp111_ = _en_list;
		_tmp112_ = vala_collection_get_size ((ValaCollection*) _tmp111_);
		_tmp113_ = _tmp112_;
		_en_size = _tmp113_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp114_;
			gint _tmp115_;
			ValaEnum* en = NULL;
			ValaList* _tmp116_;
			gpointer _tmp117_;
			ValaEnum* _tmp118_;
			_en_index = _en_index + 1;
			_tmp114_ = _en_index;
			_tmp115_ = _en_size;
			if (!(_tmp114_ < _tmp115_)) {
				break;
			}
			_tmp116_ = _en_list;
			_tmp117_ = vala_list_get (_tmp116_, _en_index);
			en = (ValaEnum*) _tmp117_;
			_tmp118_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp118_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp119_;
		ValaList* _tmp120_;
		gint _f_size = 0;
		ValaList* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gint _f_index = 0;
		_tmp119_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_tmp120_ = _vala_iterable_ref0 (_tmp119_);
		_f_list = _tmp120_;
		_tmp121_ = _f_list;
		_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
		_tmp123_ = _tmp122_;
		_f_size = _tmp123_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp124_;
			gint _tmp125_;
			ValaField* f = NULL;
			ValaList* _tmp126_;
			gpointer _tmp127_;
			ValaField* _tmp128_;
			_f_index = _f_index + 1;
			_tmp124_ = _f_index;
			_tmp125_ = _f_size;
			if (!(_tmp124_ < _tmp125_)) {
				break;
			}
			_tmp126_ = _f_list;
			_tmp127_ = vala_list_get (_tmp126_, _f_index);
			f = (ValaField*) _tmp127_;
			_tmp128_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp128_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp129_;
		ValaList* _tmp130_;
		gint _c_size = 0;
		ValaList* _tmp131_;
		gint _tmp132_;
		gint _tmp133_;
		gint _c_index = 0;
		_tmp129_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_tmp130_ = _vala_iterable_ref0 (_tmp129_);
		_c_list = _tmp130_;
		_tmp131_ = _c_list;
		_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
		_tmp133_ = _tmp132_;
		_c_size = _tmp133_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp134_;
			gint _tmp135_;
			ValaConstant* c = NULL;
			ValaList* _tmp136_;
			gpointer _tmp137_;
			ValaConstant* _tmp138_;
			_c_index = _c_index + 1;
			_tmp134_ = _c_index;
			_tmp135_ = _c_size;
			if (!(_tmp134_ < _tmp135_)) {
				break;
			}
			_tmp136_ = _c_list;
			_tmp137_ = vala_list_get (_tmp136_, _c_index);
			c = (ValaConstant*) _tmp137_;
			_tmp138_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp138_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp139_ = vala_code_context_get_abi_stability (context);
	_tmp140_ = _tmp139_;
	if (_tmp140_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp141_;
			ValaList* _tmp142_;
			gint _s_size = 0;
			ValaList* _tmp143_;
			gint _tmp144_;
			gint _tmp145_;
			gint _s_index = 0;
			_tmp141_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_tmp142_ = _vala_iterable_ref0 (_tmp141_);
			_s_list = _tmp142_;
			_tmp143_ = _s_list;
			_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
			_tmp145_ = _tmp144_;
			_s_size = _tmp145_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp146_;
				gint _tmp147_;
				ValaSymbol* s = NULL;
				ValaList* _tmp148_;
				gpointer _tmp149_;
				ValaSymbol* _tmp150_;
				_s_index = _s_index + 1;
				_tmp146_ = _s_index;
				_tmp147_ = _s_size;
				if (!(_tmp146_ < _tmp147_)) {
					break;
				}
				_tmp148_ = _s_list;
				_tmp149_ = vala_list_get (_tmp148_, _s_index);
				s = (ValaSymbol*) _tmp149_;
				_tmp150_ = s;
				if (VALA_IS_METHOD (_tmp150_)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					gboolean _tmp154_ = FALSE;
					ValaMethod* _tmp155_;
					gboolean _tmp156_;
					gboolean _tmp157_;
					_tmp151_ = s;
					_tmp152_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp152_;
					_tmp153_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp153_, context);
					_tmp155_ = m;
					_tmp156_ = vala_method_get_is_virtual (_tmp155_);
					_tmp157_ = _tmp156_;
					if (_tmp157_) {
						_tmp154_ = TRUE;
					} else {
						ValaMethod* _tmp158_;
						gboolean _tmp159_;
						gboolean _tmp160_;
						_tmp158_ = m;
						_tmp159_ = vala_method_get_is_abstract (_tmp158_);
						_tmp160_ = _tmp159_;
						_tmp154_ = _tmp160_;
					}
					if (_tmp154_) {
						ValaList* _tmp161_;
						ValaMethod* _tmp162_;
						_tmp161_ = self->priv->virtuals;
						_tmp162_ = m;
						vala_collection_add ((ValaCollection*) _tmp161_, (ValaSymbol*) _tmp162_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp163_;
					_tmp163_ = s;
					if (VALA_IS_SIGNAL (_tmp163_)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp164_;
						ValaSignal* _tmp165_;
						ValaSignal* _tmp166_;
						ValaSignal* _tmp167_;
						gboolean _tmp168_;
						gboolean _tmp169_;
						_tmp164_ = s;
						_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp165_;
						_tmp166_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp166_, context);
						_tmp167_ = sig;
						_tmp168_ = vala_signal_get_is_virtual (_tmp167_);
						_tmp169_ = _tmp168_;
						if (_tmp169_) {
							ValaList* _tmp170_;
							ValaSignal* _tmp171_;
							_tmp170_ = self->priv->virtuals;
							_tmp171_ = sig;
							vala_collection_add ((ValaCollection*) _tmp170_, (ValaSymbol*) _tmp171_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp172_;
						_tmp172_ = s;
						if (VALA_IS_PROPERTY (_tmp172_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp173_;
							ValaProperty* _tmp174_;
							ValaProperty* _tmp175_;
							gboolean _tmp176_ = FALSE;
							ValaProperty* _tmp177_;
							gboolean _tmp178_;
							gboolean _tmp179_;
							_tmp173_ = s;
							_tmp174_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp173_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp174_;
							_tmp175_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp175_, context);
							_tmp177_ = prop;
							_tmp178_ = vala_property_get_is_virtual (_tmp177_);
							_tmp179_ = _tmp178_;
							if (_tmp179_) {
								_tmp176_ = TRUE;
							} else {
								ValaProperty* _tmp180_;
								gboolean _tmp181_;
								gboolean _tmp182_;
								_tmp180_ = prop;
								_tmp181_ = vala_property_get_is_abstract (_tmp180_);
								_tmp182_ = _tmp181_;
								_tmp176_ = _tmp182_;
							}
							if (_tmp176_) {
								ValaList* _tmp183_;
								ValaProperty* _tmp184_;
								_tmp183_ = self->priv->virtuals;
								_tmp184_ = prop;
								vala_collection_add ((ValaCollection*) _tmp183_, (ValaSymbol*) _tmp184_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp185_;
			ValaList* _tmp186_;
			gint _m_size = 0;
			ValaList* _tmp187_;
			gint _tmp188_;
			gint _tmp189_;
			gint _m_index = 0;
			_tmp185_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_tmp186_ = _vala_iterable_ref0 (_tmp185_);
			_m_list = _tmp186_;
			_tmp187_ = _m_list;
			_tmp188_ = vala_collection_get_size ((ValaCollection*) _tmp187_);
			_tmp189_ = _tmp188_;
			_m_size = _tmp189_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp190_;
				gint _tmp191_;
				ValaMethod* m = NULL;
				ValaList* _tmp192_;
				gpointer _tmp193_;
				ValaMethod* _tmp194_;
				gboolean _tmp195_ = FALSE;
				ValaMethod* _tmp196_;
				gboolean _tmp197_;
				gboolean _tmp198_;
				_m_index = _m_index + 1;
				_tmp190_ = _m_index;
				_tmp191_ = _m_size;
				if (!(_tmp190_ < _tmp191_)) {
					break;
				}
				_tmp192_ = _m_list;
				_tmp193_ = vala_list_get (_tmp192_, _m_index);
				m = (ValaMethod*) _tmp193_;
				_tmp194_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp194_, context);
				_tmp196_ = m;
				_tmp197_ = vala_method_get_is_virtual (_tmp196_);
				_tmp198_ = _tmp197_;
				if (_tmp198_) {
					_tmp195_ = TRUE;
				} else {
					ValaMethod* _tmp199_;
					gboolean _tmp200_;
					gboolean _tmp201_;
					_tmp199_ = m;
					_tmp200_ = vala_method_get_is_abstract (_tmp199_);
					_tmp201_ = _tmp200_;
					_tmp195_ = _tmp201_;
				}
				if (_tmp195_) {
					ValaList* _tmp202_;
					ValaMethod* _tmp203_;
					_tmp202_ = self->priv->virtuals;
					_tmp203_ = m;
					vala_collection_add ((ValaCollection*) _tmp202_, (ValaSymbol*) _tmp203_);
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp204_;
			ValaList* _tmp205_;
			gint _sig_size = 0;
			ValaList* _tmp206_;
			gint _tmp207_;
			gint _tmp208_;
			gint _sig_index = 0;
			_tmp204_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_tmp205_ = _vala_iterable_ref0 (_tmp204_);
			_sig_list = _tmp205_;
			_tmp206_ = _sig_list;
			_tmp207_ = vala_collection_get_size ((ValaCollection*) _tmp206_);
			_tmp208_ = _tmp207_;
			_sig_size = _tmp208_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp209_;
				gint _tmp210_;
				ValaSignal* sig = NULL;
				ValaList* _tmp211_;
				gpointer _tmp212_;
				ValaSignal* _tmp213_;
				ValaSignal* _tmp214_;
				gboolean _tmp215_;
				gboolean _tmp216_;
				_sig_index = _sig_index + 1;
				_tmp209_ = _sig_index;
				_tmp210_ = _sig_size;
				if (!(_tmp209_ < _tmp210_)) {
					break;
				}
				_tmp211_ = _sig_list;
				_tmp212_ = vala_list_get (_tmp211_, _sig_index);
				sig = (ValaSignal*) _tmp212_;
				_tmp213_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp213_, context);
				_tmp214_ = sig;
				_tmp215_ = vala_signal_get_is_virtual (_tmp214_);
				_tmp216_ = _tmp215_;
				if (_tmp216_) {
					ValaList* _tmp217_;
					ValaSignal* _tmp218_;
					_tmp217_ = self->priv->virtuals;
					_tmp218_ = sig;
					vala_collection_add ((ValaCollection*) _tmp217_, (ValaSymbol*) _tmp218_);
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp219_;
			ValaList* _tmp220_;
			gint _prop_size = 0;
			ValaList* _tmp221_;
			gint _tmp222_;
			gint _tmp223_;
			gint _prop_index = 0;
			_tmp219_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_tmp220_ = _vala_iterable_ref0 (_tmp219_);
			_prop_list = _tmp220_;
			_tmp221_ = _prop_list;
			_tmp222_ = vala_collection_get_size ((ValaCollection*) _tmp221_);
			_tmp223_ = _tmp222_;
			_prop_size = _tmp223_;
			_prop_index = -1;
			while (TRUE) {
				gint _tmp224_;
				gint _tmp225_;
				ValaProperty* prop = NULL;
				ValaList* _tmp226_;
				gpointer _tmp227_;
				ValaProperty* _tmp228_;
				gboolean _tmp229_ = FALSE;
				ValaProperty* _tmp230_;
				gboolean _tmp231_;
				gboolean _tmp232_;
				_prop_index = _prop_index + 1;
				_tmp224_ = _prop_index;
				_tmp225_ = _prop_size;
				if (!(_tmp224_ < _tmp225_)) {
					break;
				}
				_tmp226_ = _prop_list;
				_tmp227_ = vala_list_get (_tmp226_, _prop_index);
				prop = (ValaProperty*) _tmp227_;
				_tmp228_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp228_, context);
				_tmp230_ = prop;
				_tmp231_ = vala_property_get_is_virtual (_tmp230_);
				_tmp232_ = _tmp231_;
				if (_tmp232_) {
					_tmp229_ = TRUE;
				} else {
					ValaProperty* _tmp233_;
					gboolean _tmp234_;
					gboolean _tmp235_;
					_tmp233_ = prop;
					_tmp234_ = vala_property_get_is_abstract (_tmp233_);
					_tmp235_ = _tmp234_;
					_tmp229_ = _tmp235_;
				}
				if (_tmp229_) {
					ValaList* _tmp236_;
					ValaProperty* _tmp237_;
					_tmp236_ = self->priv->virtuals;
					_tmp237_ = prop;
					vala_collection_add ((ValaCollection*) _tmp236_, (ValaSymbol*) _tmp237_);
				}
				_vala_code_node_unref0 (prop);
			}
			_vala_iterable_unref0 (_prop_list);
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp238_;
		ValaList* _tmp239_;
		gint _cl_size = 0;
		ValaList* _tmp240_;
		gint _tmp241_;
		gint _tmp242_;
		gint _cl_index = 0;
		_tmp238_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_tmp239_ = _vala_iterable_ref0 (_tmp238_);
		_cl_list = _tmp239_;
		_tmp240_ = _cl_list;
		_tmp241_ = vala_collection_get_size ((ValaCollection*) _tmp240_);
		_tmp242_ = _tmp241_;
		_cl_size = _tmp242_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp243_;
			gint _tmp244_;
			ValaClass* cl = NULL;
			ValaList* _tmp245_;
			gpointer _tmp246_;
			ValaClass* _tmp247_;
			_cl_index = _cl_index + 1;
			_tmp243_ = _cl_index;
			_tmp244_ = _cl_size;
			if (!(_tmp243_ < _tmp244_)) {
				break;
			}
			_tmp245_ = _cl_list;
			_tmp246_ = vala_list_get (_tmp245_, _cl_index);
			cl = (ValaClass*) _tmp246_;
			_tmp247_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp247_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp248_;
		ValaList* _tmp249_;
		gint _iface_size = 0;
		ValaList* _tmp250_;
		gint _tmp251_;
		gint _tmp252_;
		gint _iface_index = 0;
		_tmp248_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_tmp249_ = _vala_iterable_ref0 (_tmp248_);
		_iface_list = _tmp249_;
		_tmp250_ = _iface_list;
		_tmp251_ = vala_collection_get_size ((ValaCollection*) _tmp250_);
		_tmp252_ = _tmp251_;
		_iface_size = _tmp252_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp253_;
			gint _tmp254_;
			ValaInterface* iface = NULL;
			ValaList* _tmp255_;
			gpointer _tmp256_;
			ValaInterface* _tmp257_;
			_iface_index = _iface_index + 1;
			_tmp253_ = _iface_index;
			_tmp254_ = _iface_size;
			if (!(_tmp253_ < _tmp254_)) {
				break;
			}
			_tmp255_ = _iface_list;
			_tmp256_ = vala_list_get (_tmp255_, _iface_index);
			iface = (ValaInterface*) _tmp256_;
			_tmp257_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp257_, context);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp258_;
		ValaList* _tmp259_;
		gint _st_size = 0;
		ValaList* _tmp260_;
		gint _tmp261_;
		gint _tmp262_;
		gint _st_index = 0;
		_tmp258_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_tmp259_ = _vala_iterable_ref0 (_tmp258_);
		_st_list = _tmp259_;
		_tmp260_ = _st_list;
		_tmp261_ = vala_collection_get_size ((ValaCollection*) _tmp260_);
		_tmp262_ = _tmp261_;
		_st_size = _tmp262_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp263_;
			gint _tmp264_;
			ValaStruct* st = NULL;
			ValaList* _tmp265_;
			gpointer _tmp266_;
			ValaStruct* _tmp267_;
			_st_index = _st_index + 1;
			_tmp263_ = _st_index;
			_tmp264_ = _st_size;
			if (!(_tmp263_ < _tmp264_)) {
				break;
			}
			_tmp265_ = _st_list;
			_tmp266_ = vala_list_get (_tmp265_, _st_index);
			st = (ValaStruct*) _tmp266_;
			_tmp267_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp267_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp268_;
		ValaList* _tmp269_;
		gint _d_size = 0;
		ValaList* _tmp270_;
		gint _tmp271_;
		gint _tmp272_;
		gint _d_index = 0;
		_tmp268_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_tmp269_ = _vala_iterable_ref0 (_tmp268_);
		_d_list = _tmp269_;
		_tmp270_ = _d_list;
		_tmp271_ = vala_collection_get_size ((ValaCollection*) _tmp270_);
		_tmp272_ = _tmp271_;
		_d_size = _tmp272_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp273_;
			gint _tmp274_;
			ValaDelegate* d = NULL;
			ValaList* _tmp275_;
			gpointer _tmp276_;
			ValaDelegate* _tmp277_;
			_d_index = _d_index + 1;
			_tmp273_ = _d_index;
			_tmp274_ = _d_size;
			if (!(_tmp273_ < _tmp274_)) {
				break;
			}
			_tmp275_ = _d_list;
			_tmp276_ = vala_list_get (_tmp275_, _d_index);
			d = (ValaDelegate*) _tmp276_;
			_tmp277_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp277_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp278_ = g_direct_hash;
	_tmp279_ = g_direct_equal;
	_tmp280_ = g_direct_equal;
	_tmp281_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp278_, _tmp279_, _tmp280_);
	positions = (ValaMap*) _tmp281_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp282_;
		ValaList* _tmp283_;
		gint _sym_size = 0;
		ValaList* _tmp284_;
		gint _tmp285_;
		gint _tmp286_;
		gint _sym_index = 0;
		_tmp282_ = self->priv->virtuals;
		_tmp283_ = _vala_iterable_ref0 (_tmp282_);
		_sym_list = _tmp283_;
		_tmp284_ = _sym_list;
		_tmp285_ = vala_collection_get_size ((ValaCollection*) _tmp284_);
		_tmp286_ = _tmp285_;
		_sym_size = _tmp286_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp287_;
			gint _tmp288_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp289_;
			gpointer _tmp290_;
			gint ordering = 0;
			ValaSymbol* _tmp291_;
			gboolean ordered = FALSE;
			gboolean _tmp300_ = FALSE;
			gboolean _tmp301_ = FALSE;
			gboolean _tmp310_ = FALSE;
			gboolean _tmp311_ = FALSE;
			gboolean _tmp312_ = FALSE;
			gboolean _tmp321_ = FALSE;
			gboolean _tmp322_ = FALSE;
			_sym_index = _sym_index + 1;
			_tmp287_ = _sym_index;
			_tmp288_ = _sym_size;
			if (!(_tmp287_ < _tmp288_)) {
				break;
			}
			_tmp289_ = _sym_list;
			_tmp290_ = vala_list_get (_tmp289_, _sym_index);
			sym = (ValaSymbol*) _tmp290_;
			_tmp291_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp291_, "CCode", "ordering", -1);
			if (ordering < -1) {
				ValaSymbol* _tmp292_;
				ValaSourceReference* _tmp293_;
				ValaSourceReference* _tmp294_;
				ValaSymbol* _tmp295_;
				gchar* _tmp296_;
				gchar* _tmp297_;
				gchar* _tmp298_;
				gchar* _tmp299_;
				_tmp292_ = sym;
				_tmp293_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp292_);
				_tmp294_ = _tmp293_;
				_tmp295_ = sym;
				_tmp296_ = vala_symbol_get_full_name (_tmp295_);
				_tmp297_ = _tmp296_;
				_tmp298_ = g_strdup_printf ("%s: Invalid ordering", _tmp297_);
				_tmp299_ = _tmp298_;
				vala_report_error (_tmp294_, _tmp299_);
				_g_free0 (_tmp299_);
				_g_free0 (_tmp297_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			ordered = ordering != -1;
			if (ordered) {
				_tmp301_ = unordered_seen;
			} else {
				_tmp301_ = FALSE;
			}
			if (_tmp301_) {
				_tmp300_ = !ordered_seen;
			} else {
				_tmp300_ = FALSE;
			}
			if (_tmp300_) {
				ValaSymbol* _tmp302_;
				ValaSourceReference* _tmp303_;
				ValaSourceReference* _tmp304_;
				ValaSymbol* _tmp305_;
				gchar* _tmp306_;
				gchar* _tmp307_;
				gchar* _tmp308_;
				gchar* _tmp309_;
				_tmp302_ = sym;
				_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp302_);
				_tmp304_ = _tmp303_;
				_tmp305_ = sym;
				_tmp306_ = vala_symbol_get_full_name (_tmp305_);
				_tmp307_ = _tmp306_;
				_tmp308_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp307_);
				_tmp309_ = _tmp308_;
				vala_report_error (_tmp304_, _tmp309_);
				_g_free0 (_tmp309_);
				_g_free0 (_tmp307_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (ordered_seen) {
				_tmp310_ = TRUE;
			} else {
				_tmp310_ = ordered;
			}
			ordered_seen = _tmp310_;
			if (!ordered) {
				_tmp312_ = !unordered_seen;
			} else {
				_tmp312_ = FALSE;
			}
			if (_tmp312_) {
				_tmp311_ = ordered_seen;
			} else {
				_tmp311_ = FALSE;
			}
			if (_tmp311_) {
				ValaSymbol* _tmp313_;
				ValaSourceReference* _tmp314_;
				ValaSourceReference* _tmp315_;
				ValaSymbol* _tmp316_;
				gchar* _tmp317_;
				gchar* _tmp318_;
				gchar* _tmp319_;
				gchar* _tmp320_;
				_tmp313_ = sym;
				_tmp314_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = sym;
				_tmp317_ = vala_symbol_get_full_name (_tmp316_);
				_tmp318_ = _tmp317_;
				_tmp319_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp318_);
				_tmp320_ = _tmp319_;
				vala_report_error (_tmp315_, _tmp320_);
				_g_free0 (_tmp320_);
				_g_free0 (_tmp318_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (unordered_seen) {
				_tmp321_ = TRUE;
			} else {
				_tmp321_ = !ordered;
			}
			unordered_seen = _tmp321_;
			if (!ordered_seen) {
				_tmp322_ = TRUE;
			} else {
				_tmp322_ = !unordered_seen;
			}
			if (_tmp322_) {
				if (ordered) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp323_;
					gpointer _tmp324_;
					ValaSymbol* _tmp325_;
					ValaMap* _tmp337_;
					ValaSymbol* _tmp338_;
					_tmp323_ = positions;
					_tmp324_ = vala_map_get (_tmp323_, (gpointer) ((gintptr) ordering));
					prev = (ValaSymbol*) _tmp324_;
					_tmp325_ = prev;
					if (_tmp325_ != NULL) {
						ValaSymbol* _tmp326_;
						ValaSourceReference* _tmp327_;
						ValaSourceReference* _tmp328_;
						ValaSymbol* _tmp329_;
						gchar* _tmp330_;
						gchar* _tmp331_;
						ValaSymbol* _tmp332_;
						const gchar* _tmp333_;
						const gchar* _tmp334_;
						gchar* _tmp335_;
						gchar* _tmp336_;
						_tmp326_ = sym;
						_tmp327_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp326_);
						_tmp328_ = _tmp327_;
						_tmp329_ = sym;
						_tmp330_ = vala_symbol_get_full_name (_tmp329_);
						_tmp331_ = _tmp330_;
						_tmp332_ = prev;
						_tmp333_ = vala_symbol_get_name (_tmp332_);
						_tmp334_ = _tmp333_;
						_tmp335_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp331_, _tmp334_);
						_tmp336_ = _tmp335_;
						vala_report_error (_tmp328_, _tmp336_);
						_g_free0 (_tmp336_);
						_g_free0 (_tmp331_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp337_ = positions;
					_tmp338_ = sym;
					vala_map_set (_tmp337_, (gpointer) ((gintptr) ordering), _tmp338_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	if (ordered_seen) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp339_ = FALSE;
				_tmp339_ = TRUE;
				while (TRUE) {
					ValaList* _tmp341_;
					gint _tmp342_;
					gint _tmp343_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp344_;
					gpointer _tmp345_;
					ValaSymbol* _tmp346_;
					gboolean _tmp353_;
					gboolean _tmp354_;
					if (!_tmp339_) {
						gint _tmp340_;
						_tmp340_ = i;
						i = _tmp340_ + 1;
					}
					_tmp339_ = FALSE;
					_tmp341_ = self->priv->virtuals;
					_tmp342_ = vala_collection_get_size ((ValaCollection*) _tmp341_);
					_tmp343_ = _tmp342_;
					if (!(i < _tmp343_)) {
						break;
					}
					_tmp344_ = positions;
					_tmp345_ = vala_map_get (_tmp344_, (gpointer) ((gintptr) i));
					sym = (ValaSymbol*) _tmp345_;
					_tmp346_ = sym;
					if (_tmp346_ == NULL) {
						ValaSourceReference* _tmp347_;
						ValaSourceReference* _tmp348_;
						gchar* _tmp349_;
						gchar* _tmp350_;
						gchar* _tmp351_;
						gchar* _tmp352_;
						_tmp347_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp348_ = _tmp347_;
						_tmp349_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp350_ = _tmp349_;
						_tmp351_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp350_, i);
						_tmp352_ = _tmp351_;
						vala_report_error (_tmp348_, _tmp352_);
						_g_free0 (_tmp352_);
						_g_free0 (_tmp350_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp353_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp354_ = _tmp353_;
					if (!_tmp354_) {
						ValaList* _tmp355_;
						ValaSymbol* _tmp356_;
						_tmp355_ = self->priv->virtuals;
						_tmp356_ = sym;
						vala_list_set (_tmp355_, i, _tmp356_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp357_ = vala_code_context_get_analyzer (context);
	_tmp358_ = _tmp357_;
	_tmp359_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp358_, _tmp359_);
	_tmp360_ = vala_code_context_get_analyzer (context);
	_tmp361_ = _tmp360_;
	_tmp362_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp361_, _tmp362_);
	_tmp363_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp364_ = _tmp363_;
	result = !_tmp364_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_interface_class_init (ValaInterfaceClass * klass,
                           gpointer klass_data)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInterface_private_offset);
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface*)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_interface_real_check;
}

static void
vala_interface_instance_init (ValaInterface * self,
                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_interface_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}

static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}

/**
 * Represents an interface declaration in the source code.
 */
static GType
vala_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
	GType vala_interface_type_id;
	vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
	ValaInterface_private_offset = g_type_add_instance_private (vala_interface_type_id, sizeof (ValaInterfacePrivate));
	return vala_interface_type_id;
}

GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		GType vala_interface_type_id;
		vala_interface_type_id = vala_interface_get_type_once ();
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}

