/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};

static gint ValaInitializerList_private_offset;
static gpointer vala_initializer_list_parent_class = NULL;

static void vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gchar* vala_initializer_list_real_to_string (ValaCodeNode* base);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);

static inline gpointer
vala_initializer_list_get_instance_private (ValaInitializerList* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInitializerList_private_offset);
}

/**
 * Appends the specified expression to this initializer
 *
 * @param expr an expression
 */
void
vala_initializer_list_append (ValaInitializerList* self,
                              ValaExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the expression
 *
 * @return expression list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_initializer_list_get_initializers (ValaInitializerList* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Creates a new initializer
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList*
vala_initializer_list_construct (GType object_type,
                                 ValaSourceReference* source_reference)
{
	ValaInitializerList* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaInitializerList*
vala_initializer_list_new (ValaSourceReference* source_reference)
{
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}

static void
vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_initializer_list_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_initializer_list_real_is_constant (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_constant (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_pure (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_pure (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gchar*
vala_initializer_list_real_to_string (ValaCodeNode* base)
{
	ValaInitializerList * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean first = FALSE;
	GString* _tmp16_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* result = NULL;
	self = (ValaInitializerList*) base;
	_tmp0_ = g_string_new ("{");
	builder = _tmp0_;
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _initializer_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _initializer_index = 0;
		_tmp1_ = self->priv->initializers;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_initializer_list = _tmp2_;
		_tmp3_ = _initializer_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_initializer_size = _tmp5_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			if (first) {
				GString* _tmp8_;
				ValaExpression* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = builder;
				_tmp9_ = initializer;
				_tmp10_ = vala_code_node_to_string ((ValaCodeNode*) _tmp9_);
				_tmp11_ = _tmp10_;
				g_string_append (_tmp8_, _tmp11_);
				_g_free0 (_tmp11_);
				first = FALSE;
			} else {
				GString* _tmp12_;
				ValaExpression* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = builder;
				_tmp13_ = initializer;
				_tmp14_ = vala_code_node_to_string ((ValaCodeNode*) _tmp13_);
				_tmp15_ = _tmp14_;
				g_string_append_printf (_tmp12_, ", %s", _tmp15_);
				_g_free0 (_tmp15_);
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	_tmp16_ = builder;
	g_string_append_c (_tmp16_, '}');
	_tmp17_ = builder;
	_tmp18_ = _tmp17_->str;
	_tmp19_ = g_strdup (_tmp18_);
	result = _tmp19_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->initializers;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->initializers;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->initializers;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_initializer_list_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaInitializerList * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp226_;
	gboolean _tmp227_;
	gboolean _tmp273_;
	gboolean _tmp274_;
	ValaDataType* _tmp281_;
	ValaDataType* _tmp282_;
	gboolean _tmp285_;
	gboolean _tmp286_;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_node_get_error ((ValaCodeNode*) _tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		} else {
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			_tmp12_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			if (VALA_IS_ARRAY_TYPE (_tmp13_)) {
				ValaArrayType* array_type = NULL;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				ValaArrayType* _tmp16_;
				gboolean requires_constants_only = FALSE;
				ValaCodeNode* node = NULL;
				ValaCodeNode* _tmp17_;
				ValaCodeNode* _tmp18_;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaDataType* inner_target_type = NULL;
				ValaArrayType* _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				_tmp14_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp15_ = _tmp14_;
				_tmp16_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp16_;
				requires_constants_only = FALSE;
				_tmp17_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp18_ = _tmp17_;
				node = _tmp18_;
				while (TRUE) {
					ValaCodeNode* _tmp19_;
					ValaCodeNode* _tmp20_;
					ValaCodeNode* _tmp21_;
					ValaCodeNode* _tmp22_;
					ValaCodeNode* _tmp23_;
					_tmp19_ = node;
					if (!(_tmp19_ != NULL)) {
						break;
					}
					_tmp20_ = node;
					if (VALA_IS_CONSTANT (_tmp20_)) {
						requires_constants_only = TRUE;
						break;
					}
					_tmp21_ = node;
					_tmp22_ = vala_code_node_get_parent_node (_tmp21_);
					_tmp23_ = _tmp22_;
					node = _tmp23_;
				}
				_tmp26_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp27_ = _tmp26_;
				if (!VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp27_)) {
					_tmp25_ = !requires_constants_only;
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					gboolean _tmp28_ = FALSE;
					ValaCodeNode* _tmp29_;
					ValaCodeNode* _tmp30_;
					_tmp29_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp30_ = _tmp29_;
					if (!VALA_IS_INITIALIZER_LIST (_tmp30_)) {
						_tmp28_ = TRUE;
					} else {
						ValaCodeNode* _tmp31_;
						ValaCodeNode* _tmp32_;
						ValaDataType* _tmp33_;
						ValaDataType* _tmp34_;
						ValaTypeSymbol* _tmp35_;
						ValaTypeSymbol* _tmp36_;
						_tmp31_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp32_ = _tmp31_;
						_tmp33_ = vala_expression_get_target_type ((ValaExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
						_tmp34_ = _tmp33_;
						_tmp35_ = vala_data_type_get_data_type (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp28_ = VALA_IS_STRUCT (_tmp36_);
					}
					_tmp24_ = _tmp28_;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					ValaCodeNode* old_parent_node = NULL;
					ValaCodeNode* _tmp37_;
					ValaCodeNode* _tmp38_;
					ValaCodeNode* _tmp39_;
					ValaArrayCreationExpression* array_creation = NULL;
					ValaArrayType* _tmp40_;
					ValaDataType* _tmp41_;
					ValaDataType* _tmp42_;
					ValaDataType* _tmp43_;
					ValaDataType* _tmp44_;
					ValaArrayType* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					ValaSourceReference* _tmp48_;
					ValaSourceReference* _tmp49_;
					ValaArrayCreationExpression* _tmp50_;
					ValaArrayCreationExpression* _tmp51_;
					ValaArrayCreationExpression* _tmp52_;
					ValaArrayType* _tmp53_;
					ValaDataType* _tmp54_;
					ValaDataType* _tmp55_;
					ValaDataType* _tmp56_;
					ValaDataType* _tmp57_;
					ValaArrayCreationExpression* _tmp58_;
					ValaDataType* _tmp59_;
					ValaDataType* _tmp60_;
					ValaArrayCreationExpression* _tmp61_;
					ValaDataType* _tmp62_;
					ValaDataType* _tmp63_;
					ValaCodeNode* _tmp64_;
					ValaArrayCreationExpression* _tmp65_;
					ValaArrayCreationExpression* _tmp66_;
					_tmp37_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp38_ = _tmp37_;
					_tmp39_ = _vala_code_node_ref0 (_tmp38_);
					old_parent_node = _tmp39_;
					_tmp40_ = array_type;
					_tmp41_ = vala_array_type_get_element_type (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = vala_data_type_copy (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = array_type;
					_tmp46_ = vala_array_type_get_rank (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp49_ = _tmp48_;
					_tmp50_ = vala_array_creation_expression_new (_tmp44_, _tmp47_, self, _tmp49_);
					_tmp51_ = _tmp50_;
					_vala_code_node_unref0 (_tmp44_);
					array_creation = _tmp51_;
					_tmp52_ = array_creation;
					_tmp53_ = array_type;
					_tmp54_ = vala_array_type_get_length_type (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = vala_data_type_copy (_tmp55_);
					_tmp57_ = _tmp56_;
					vala_array_creation_expression_set_length_type (_tmp52_, _tmp57_);
					_vala_code_node_unref0 (_tmp57_);
					_tmp58_ = array_creation;
					_tmp59_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp60_ = _tmp59_;
					vala_expression_set_target_type ((ValaExpression*) _tmp58_, _tmp60_);
					_tmp61_ = array_creation;
					_tmp62_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
					_tmp63_ = _tmp62_;
					vala_expression_set_formal_target_type ((ValaExpression*) _tmp61_, _tmp63_);
					_tmp64_ = old_parent_node;
					_tmp65_ = array_creation;
					vala_code_node_replace_expression (_tmp64_, (ValaExpression*) self, (ValaExpression*) _tmp65_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					_tmp66_ = array_creation;
					result = vala_code_node_check ((ValaCodeNode*) _tmp66_, context);
					_vala_code_node_unref0 (array_creation);
					_vala_code_node_unref0 (old_parent_node);
					_vala_code_node_unref0 (array_type);
					return result;
				}
				_tmp67_ = array_type;
				_tmp68_ = vala_array_type_get_rank (_tmp67_);
				_tmp69_ = _tmp68_;
				if (_tmp69_ > 1) {
					ValaArrayType* inner_array_type = NULL;
					ValaArrayType* _tmp70_;
					ValaDataType* _tmp71_;
					ValaArrayType* _tmp72_;
					gint _tmp73_;
					gint _tmp74_;
					ValaArrayType* _tmp75_;
					ValaDataType* _tmp76_;
					_tmp70_ = array_type;
					_tmp71_ = vala_data_type_copy ((ValaDataType*) _tmp70_);
					inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp72_ = inner_array_type;
					_tmp73_ = vala_array_type_get_rank (_tmp72_);
					_tmp74_ = _tmp73_;
					vala_array_type_set_rank (_tmp72_, _tmp74_ - 1);
					_tmp75_ = inner_array_type;
					_tmp76_ = _vala_code_node_ref0 ((ValaDataType*) _tmp75_);
					_vala_code_node_unref0 (inner_target_type);
					inner_target_type = _tmp76_;
					_vala_code_node_unref0 (inner_array_type);
				} else {
					ValaArrayType* _tmp77_;
					ValaDataType* _tmp78_;
					ValaDataType* _tmp79_;
					ValaDataType* _tmp80_;
					_tmp77_ = array_type;
					_tmp78_ = vala_array_type_get_element_type (_tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = vala_data_type_copy (_tmp79_);
					_vala_code_node_unref0 (inner_target_type);
					inner_target_type = _tmp80_;
				}
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp81_;
					gint _e_size = 0;
					ValaList* _tmp82_;
					gint _tmp83_;
					gint _tmp84_;
					gint _e_index = 0;
					_tmp81_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp81_;
					_tmp82_ = _e_list;
					_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
					_tmp84_ = _tmp83_;
					_e_size = _tmp84_;
					_e_index = -1;
					while (TRUE) {
						ValaExpression* e = NULL;
						ValaList* _tmp85_;
						gpointer _tmp86_;
						ValaExpression* _tmp87_;
						ValaDataType* _tmp88_;
						_e_index = _e_index + 1;
						if (!(_e_index < _e_size)) {
							break;
						}
						_tmp85_ = _e_list;
						_tmp86_ = vala_list_get (_tmp85_, _e_index);
						e = (ValaExpression*) _tmp86_;
						_tmp87_ = e;
						_tmp88_ = inner_target_type;
						vala_expression_set_target_type (_tmp87_, _tmp88_);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				_vala_code_node_unref0 (inner_target_type);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaDataType* _tmp89_;
				ValaDataType* _tmp90_;
				ValaTypeSymbol* _tmp91_;
				ValaTypeSymbol* _tmp92_;
				_tmp89_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_data_type_get_data_type (_tmp90_);
				_tmp92_ = _tmp91_;
				if (VALA_IS_STRUCT (_tmp92_)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp93_;
					ValaDataType* _tmp94_;
					ValaTypeSymbol* _tmp95_;
					ValaTypeSymbol* _tmp96_;
					ValaStruct* _tmp97_;
					gboolean _tmp105_ = FALSE;
					ValaCodeNode* _tmp106_;
					ValaCodeNode* _tmp107_;
					gboolean in_array_creation_initializer = FALSE;
					ValaObjectCreationExpression* struct_creation = NULL;
					ValaIterator* field_it = NULL;
					ValaStruct* _tmp156_;
					ValaList* _tmp157_;
					ValaList* _tmp158_;
					ValaIterator* _tmp159_;
					ValaIterator* _tmp160_;
					_tmp93_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp94_ = _tmp93_;
					_tmp95_ = vala_data_type_get_data_type (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp97_;
					while (TRUE) {
						ValaStruct* _tmp98_;
						ValaStruct* _tmp99_;
						ValaStruct* _tmp100_;
						ValaStruct* _tmp101_;
						ValaStruct* _tmp102_;
						ValaStruct* _tmp103_;
						ValaStruct* _tmp104_;
						_tmp98_ = st;
						_tmp99_ = vala_struct_get_base_struct (_tmp98_);
						_tmp100_ = _tmp99_;
						if (!(_tmp100_ != NULL)) {
							break;
						}
						_tmp101_ = st;
						_tmp102_ = vala_struct_get_base_struct (_tmp101_);
						_tmp103_ = _tmp102_;
						_tmp104_ = _vala_code_node_ref0 (_tmp103_);
						_vala_code_node_unref0 (st);
						st = _tmp104_;
					}
					_tmp106_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp107_ = _tmp106_;
					if (VALA_IS_INITIALIZER_LIST (_tmp107_)) {
						ValaCodeNode* _tmp108_;
						ValaCodeNode* _tmp109_;
						ValaCodeNode* _tmp110_;
						ValaCodeNode* _tmp111_;
						_tmp108_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = vala_code_node_get_parent_node (_tmp109_);
						_tmp111_ = _tmp110_;
						_tmp105_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp111_);
					} else {
						_tmp105_ = FALSE;
					}
					in_array_creation_initializer = _tmp105_;
					struct_creation = NULL;
					if (in_array_creation_initializer) {
						ValaSymbol* sym = NULL;
						ValaStruct* _tmp112_;
						ValaMemberAccess* ma = NULL;
						ValaSymbol* _tmp113_;
						const gchar* _tmp114_;
						const gchar* _tmp115_;
						ValaSourceReference* _tmp116_;
						ValaSourceReference* _tmp117_;
						ValaMemberAccess* _tmp118_;
						ValaMemberAccess* _tmp119_;
						ValaMemberAccess* _tmp120_;
						ValaSymbol* _tmp121_;
						ValaMemberAccess* inner = NULL;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp123_;
						ValaMemberAccess* _tmp146_;
						ValaSourceReference* _tmp147_;
						ValaSourceReference* _tmp148_;
						ValaObjectCreationExpression* _tmp149_;
						ValaObjectCreationExpression* _tmp150_;
						ValaDataType* _tmp151_;
						ValaDataType* _tmp152_;
						ValaDataType* _tmp153_;
						ValaDataType* _tmp154_;
						ValaObjectCreationExpression* _tmp155_;
						_tmp112_ = st;
						sym = (ValaSymbol*) _tmp112_;
						_tmp113_ = sym;
						_tmp114_ = vala_symbol_get_name (_tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp117_ = _tmp116_;
						_tmp118_ = vala_member_access_new_simple (_tmp115_, _tmp117_);
						ma = _tmp118_;
						_tmp119_ = ma;
						vala_member_access_set_creation_member (_tmp119_, TRUE);
						_tmp120_ = ma;
						_tmp121_ = sym;
						vala_expression_set_symbol_reference ((ValaExpression*) _tmp120_, _tmp121_);
						_tmp122_ = ma;
						_tmp123_ = _vala_code_node_ref0 (_tmp122_);
						inner = _tmp123_;
						while (TRUE) {
							gboolean _tmp124_ = FALSE;
							ValaSymbol* _tmp125_;
							ValaSymbol* _tmp126_;
							ValaSymbol* _tmp127_;
							ValaSymbol* _tmp133_;
							ValaSymbol* _tmp134_;
							ValaSymbol* _tmp135_;
							ValaMemberAccess* ma_inner = NULL;
							ValaSymbol* _tmp136_;
							const gchar* _tmp137_;
							const gchar* _tmp138_;
							ValaSourceReference* _tmp139_;
							ValaSourceReference* _tmp140_;
							ValaMemberAccess* _tmp141_;
							ValaMemberAccess* _tmp142_;
							ValaMemberAccess* _tmp143_;
							ValaMemberAccess* _tmp144_;
							ValaMemberAccess* _tmp145_;
							_tmp125_ = sym;
							_tmp126_ = vala_symbol_get_parent_symbol (_tmp125_);
							_tmp127_ = _tmp126_;
							if (_tmp127_ != NULL) {
								ValaSymbol* _tmp128_;
								ValaSymbol* _tmp129_;
								ValaSymbol* _tmp130_;
								ValaNamespace* _tmp131_;
								ValaNamespace* _tmp132_;
								_tmp128_ = sym;
								_tmp129_ = vala_symbol_get_parent_symbol (_tmp128_);
								_tmp130_ = _tmp129_;
								_tmp131_ = vala_code_context_get_root (context);
								_tmp132_ = _tmp131_;
								_tmp124_ = _tmp130_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp124_ = FALSE;
							}
							if (!_tmp124_) {
								break;
							}
							_tmp133_ = sym;
							_tmp134_ = vala_symbol_get_parent_symbol (_tmp133_);
							_tmp135_ = _tmp134_;
							sym = _tmp135_;
							_tmp136_ = sym;
							_tmp137_ = vala_symbol_get_name (_tmp136_);
							_tmp138_ = _tmp137_;
							_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp140_ = _tmp139_;
							_tmp141_ = vala_member_access_new_simple (_tmp138_, _tmp140_);
							ma_inner = _tmp141_;
							_tmp142_ = inner;
							_tmp143_ = ma_inner;
							vala_member_access_set_inner (_tmp142_, (ValaExpression*) _tmp143_);
							_tmp144_ = ma_inner;
							_tmp145_ = _vala_code_node_ref0 (_tmp144_);
							_vala_code_node_unref0 (inner);
							inner = _tmp145_;
							_vala_code_node_unref0 (ma_inner);
						}
						_tmp146_ = ma;
						_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp148_ = _tmp147_;
						_tmp149_ = vala_object_creation_expression_new (_tmp146_, _tmp148_);
						_vala_code_node_unref0 (struct_creation);
						struct_creation = _tmp149_;
						_tmp150_ = struct_creation;
						_tmp151_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp152_ = _tmp151_;
						_tmp153_ = vala_data_type_copy (_tmp152_);
						_tmp154_ = _tmp153_;
						vala_expression_set_target_type ((ValaExpression*) _tmp150_, _tmp154_);
						_vala_code_node_unref0 (_tmp154_);
						_tmp155_ = struct_creation;
						vala_object_creation_expression_set_struct_creation (_tmp155_, TRUE);
						_vala_code_node_unref0 (inner);
						_vala_code_node_unref0 (ma);
					}
					_tmp156_ = st;
					_tmp157_ = vala_struct_get_fields (_tmp156_);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_iterable_iterator ((ValaIterable*) _tmp158_);
					_tmp160_ = _tmp159_;
					_vala_iterable_unref0 (_tmp158_);
					field_it = _tmp160_;
					{
						ValaList* _e_list = NULL;
						ValaList* _tmp161_;
						gint _e_size = 0;
						ValaList* _tmp162_;
						gint _tmp163_;
						gint _tmp164_;
						gint _e_index = 0;
						_tmp161_ = vala_initializer_list_get_initializers (self);
						_e_list = _tmp161_;
						_tmp162_ = _e_list;
						_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
						_tmp164_ = _tmp163_;
						_e_size = _tmp164_;
						_e_index = -1;
						while (TRUE) {
							ValaExpression* e = NULL;
							ValaList* _tmp165_;
							gpointer _tmp166_;
							ValaField* field = NULL;
							_e_index = _e_index + 1;
							if (!(_e_index < _e_size)) {
								break;
							}
							_tmp165_ = _e_list;
							_tmp166_ = vala_list_get (_tmp165_, _e_index);
							e = (ValaExpression*) _tmp166_;
							field = NULL;
							while (TRUE) {
								ValaField* _tmp167_;
								ValaIterator* _tmp168_;
								ValaIterator* _tmp178_;
								gpointer _tmp179_;
								ValaField* _tmp180_;
								ValaMemberBinding _tmp181_;
								ValaMemberBinding _tmp182_;
								_tmp167_ = field;
								if (!(_tmp167_ == NULL)) {
									break;
								}
								_tmp168_ = field_it;
								if (!vala_iterator_next (_tmp168_)) {
									ValaExpression* _tmp169_;
									ValaSourceReference* _tmp170_;
									ValaSourceReference* _tmp171_;
									ValaDataType* _tmp172_;
									ValaDataType* _tmp173_;
									gchar* _tmp174_;
									gchar* _tmp175_;
									gchar* _tmp176_;
									gchar* _tmp177_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp169_ = e;
									_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp169_);
									_tmp171_ = _tmp170_;
									_tmp172_ = vala_expression_get_target_type ((ValaExpression*) self);
									_tmp173_ = _tmp172_;
									_tmp174_ = vala_code_node_to_string ((ValaCodeNode*) _tmp173_);
									_tmp175_ = _tmp174_;
									_tmp176_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp175_);
									_tmp177_ = _tmp176_;
									vala_report_error (_tmp171_, _tmp177_);
									_g_free0 (_tmp177_);
									_g_free0 (_tmp175_);
									result = FALSE;
									_vala_code_node_unref0 (field);
									_vala_code_node_unref0 (e);
									_vala_iterable_unref0 (_e_list);
									_vala_iterator_unref0 (field_it);
									_vala_code_node_unref0 (struct_creation);
									_vala_code_node_unref0 (st);
									return result;
								}
								_tmp178_ = field_it;
								_tmp179_ = vala_iterator_get (_tmp178_);
								_vala_code_node_unref0 (field);
								field = (ValaField*) _tmp179_;
								_tmp180_ = field;
								_tmp181_ = vala_field_get_binding (_tmp180_);
								_tmp182_ = _tmp181_;
								if (_tmp182_ != VALA_MEMBER_BINDING_INSTANCE) {
									_vala_code_node_unref0 (field);
									field = NULL;
								}
							}
							if (in_array_creation_initializer) {
								ValaMemberInitializer* member_init = NULL;
								ValaField* _tmp183_;
								const gchar* _tmp184_;
								const gchar* _tmp185_;
								ValaExpression* _tmp186_;
								ValaExpression* _tmp187_;
								ValaSourceReference* _tmp188_;
								ValaSourceReference* _tmp189_;
								ValaMemberInitializer* _tmp190_;
								ValaObjectCreationExpression* _tmp191_;
								ValaMemberInitializer* _tmp192_;
								_tmp183_ = field;
								_tmp184_ = vala_symbol_get_name ((ValaSymbol*) _tmp183_);
								_tmp185_ = _tmp184_;
								_tmp186_ = e;
								_tmp187_ = e;
								_tmp188_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp187_);
								_tmp189_ = _tmp188_;
								_tmp190_ = vala_member_initializer_new (_tmp185_, _tmp186_, _tmp189_);
								member_init = _tmp190_;
								_tmp191_ = struct_creation;
								_tmp192_ = member_init;
								vala_object_creation_expression_add_member_initializer (_tmp191_, _tmp192_);
								_vala_code_node_unref0 (member_init);
							} else {
								ValaExpression* _tmp193_;
								ValaField* _tmp194_;
								ValaDataType* _tmp195_;
								ValaDataType* _tmp196_;
								ValaDataType* _tmp197_;
								ValaDataType* _tmp198_;
								ValaDataType* _tmp199_;
								ValaDataType* _tmp200_;
								gboolean _tmp201_;
								gboolean _tmp202_;
								_tmp193_ = e;
								_tmp194_ = field;
								_tmp195_ = vala_variable_get_variable_type ((ValaVariable*) _tmp194_);
								_tmp196_ = _tmp195_;
								_tmp197_ = vala_data_type_copy (_tmp196_);
								_tmp198_ = _tmp197_;
								vala_expression_set_target_type (_tmp193_, _tmp198_);
								_vala_code_node_unref0 (_tmp198_);
								_tmp199_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp200_ = _tmp199_;
								_tmp201_ = vala_data_type_get_value_owned (_tmp200_);
								_tmp202_ = _tmp201_;
								if (!_tmp202_) {
									ValaExpression* _tmp203_;
									ValaDataType* _tmp204_;
									ValaDataType* _tmp205_;
									_tmp203_ = e;
									_tmp204_ = vala_expression_get_target_type (_tmp203_);
									_tmp205_ = _tmp204_;
									vala_data_type_set_value_owned (_tmp205_, FALSE);
								}
							}
							_vala_code_node_unref0 (field);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					if (in_array_creation_initializer) {
						ValaCodeNode* _tmp206_;
						ValaCodeNode* _tmp207_;
						ValaObjectCreationExpression* _tmp208_;
						ValaObjectCreationExpression* _tmp209_;
						_tmp206_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp207_ = _tmp206_;
						_tmp208_ = struct_creation;
						vala_code_node_replace_expression (_tmp207_, (ValaExpression*) self, (ValaExpression*) _tmp208_);
						vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
						_tmp209_ = struct_creation;
						result = vala_code_node_check ((ValaCodeNode*) _tmp209_, context);
						_vala_iterator_unref0 (field_it);
						_vala_code_node_unref0 (struct_creation);
						_vala_code_node_unref0 (st);
						return result;
					}
					_vala_iterator_unref0 (field_it);
					_vala_code_node_unref0 (struct_creation);
					_vala_code_node_unref0 (st);
				} else {
					ValaSourceReference* _tmp210_;
					ValaSourceReference* _tmp211_;
					ValaDataType* _tmp212_;
					ValaDataType* _tmp213_;
					gchar* _tmp214_;
					gchar* _tmp215_;
					gchar* _tmp216_;
					gchar* _tmp217_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp210_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp211_ = _tmp210_;
					_tmp212_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_node_to_string ((ValaCodeNode*) _tmp213_);
					_tmp215_ = _tmp214_;
					_tmp216_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp215_);
					_tmp217_ = _tmp216_;
					vala_report_error (_tmp211_, _tmp217_);
					_g_free0 (_tmp217_);
					_g_free0 (_tmp215_);
					result = FALSE;
					return result;
				}
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp218_;
		ValaList* _tmp219_;
		gint _expr_size = 0;
		ValaList* _tmp220_;
		gint _tmp221_;
		gint _tmp222_;
		gint _expr_index = 0;
		_tmp218_ = self->priv->initializers;
		_tmp219_ = _vala_iterable_ref0 (_tmp218_);
		_expr_list = _tmp219_;
		_tmp220_ = _expr_list;
		_tmp221_ = vala_collection_get_size ((ValaCollection*) _tmp220_);
		_tmp222_ = _tmp221_;
		_expr_size = _tmp222_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp223_;
			gpointer _tmp224_;
			ValaExpression* _tmp225_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp223_ = _expr_list;
			_tmp224_ = vala_list_get (_tmp223_, _expr_index);
			expr = (ValaExpression*) _tmp224_;
			_tmp225_ = expr;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp225_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp226_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp227_ = _tmp226_;
	if (_tmp227_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp228_;
		gint _e_size = 0;
		ValaList* _tmp229_;
		gint _tmp230_;
		gint _tmp231_;
		gint _e_index = 0;
		_tmp228_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp228_;
		_tmp229_ = _e_list;
		_tmp230_ = vala_collection_get_size ((ValaCollection*) _tmp229_);
		_tmp231_ = _tmp230_;
		_e_size = _tmp231_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp232_;
			gpointer _tmp233_;
			ValaExpression* _tmp234_;
			ValaDataType* _tmp235_;
			ValaDataType* _tmp236_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp240_;
			ValaUnaryExpression* _tmp241_;
			gboolean _tmp242_ = FALSE;
			ValaUnaryExpression* _tmp243_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp232_ = _e_list;
			_tmp233_ = vala_list_get (_tmp232_, _e_index);
			e = (ValaExpression*) _tmp233_;
			_tmp234_ = e;
			_tmp235_ = vala_expression_get_value_type (_tmp234_);
			_tmp236_ = _tmp235_;
			if (_tmp236_ == NULL) {
				ValaExpression* _tmp237_;
				ValaSourceReference* _tmp238_;
				ValaSourceReference* _tmp239_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp237_ = e;
				_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp237_);
				_tmp239_ = _tmp238_;
				vala_report_error (_tmp239_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp240_ = e;
			_tmp241_ = _vala_code_node_ref0 (VALA_IS_UNARY_EXPRESSION (_tmp240_) ? ((ValaUnaryExpression*) _tmp240_) : NULL);
			unary = _tmp241_;
			_tmp243_ = unary;
			if (_tmp243_ != NULL) {
				gboolean _tmp244_ = FALSE;
				ValaUnaryExpression* _tmp245_;
				ValaUnaryOperator _tmp246_;
				ValaUnaryOperator _tmp247_;
				_tmp245_ = unary;
				_tmp246_ = vala_unary_expression_get_operator (_tmp245_);
				_tmp247_ = _tmp246_;
				if (_tmp247_ == VALA_UNARY_OPERATOR_REF) {
					_tmp244_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp248_;
					ValaUnaryOperator _tmp249_;
					ValaUnaryOperator _tmp250_;
					_tmp248_ = unary;
					_tmp249_ = vala_unary_expression_get_operator (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp244_ = _tmp250_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp242_ = _tmp244_;
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
			} else {
				ValaExpression* _tmp251_;
				ValaDataType* _tmp252_;
				ValaDataType* _tmp253_;
				ValaExpression* _tmp254_;
				ValaDataType* _tmp255_;
				ValaDataType* _tmp256_;
				_tmp251_ = e;
				_tmp252_ = vala_expression_get_value_type (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp254_ = e;
				_tmp255_ = vala_expression_get_target_type (_tmp254_);
				_tmp256_ = _tmp255_;
				if (!vala_data_type_compatible (_tmp253_, _tmp256_)) {
					ValaExpression* _tmp257_;
					ValaExpression* _tmp258_;
					ValaSourceReference* _tmp259_;
					ValaSourceReference* _tmp260_;
					ValaExpression* _tmp261_;
					ValaDataType* _tmp262_;
					ValaDataType* _tmp263_;
					gchar* _tmp264_;
					gchar* _tmp265_;
					ValaExpression* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					gchar* _tmp269_;
					gchar* _tmp270_;
					gchar* _tmp271_;
					gchar* _tmp272_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp257_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp257_, TRUE);
					_tmp258_ = e;
					_tmp259_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp258_);
					_tmp260_ = _tmp259_;
					_tmp261_ = e;
					_tmp262_ = vala_expression_get_target_type (_tmp261_);
					_tmp263_ = _tmp262_;
					_tmp264_ = vala_code_node_to_string ((ValaCodeNode*) _tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = e;
					_tmp267_ = vala_expression_get_value_type (_tmp266_);
					_tmp268_ = _tmp267_;
					_tmp269_ = vala_code_node_to_string ((ValaCodeNode*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp271_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp265_, _tmp270_);
					_tmp272_ = _tmp271_;
					vala_report_error (_tmp260_, _tmp272_);
					_g_free0 (_tmp272_);
					_g_free0 (_tmp270_);
					_g_free0 (_tmp265_);
				}
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp273_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp274_ = _tmp273_;
	if (!_tmp274_) {
		ValaDataType* _tmp275_;
		ValaDataType* _tmp276_;
		ValaDataType* _tmp277_;
		ValaDataType* _tmp278_;
		ValaDataType* _tmp279_;
		ValaDataType* _tmp280_;
		_tmp275_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp276_ = _tmp275_;
		_tmp277_ = vala_data_type_copy (_tmp276_);
		_tmp278_ = _tmp277_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp278_);
		_vala_code_node_unref0 (_tmp278_);
		_tmp279_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp280_ = _tmp279_;
		vala_data_type_set_nullable (_tmp280_, FALSE);
	}
	_tmp281_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp282_ = _tmp281_;
	if (_tmp282_ != NULL) {
		ValaDataType* _tmp283_;
		ValaDataType* _tmp284_;
		_tmp283_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp284_ = _tmp283_;
		vala_code_node_check ((ValaCodeNode*) _tmp284_, context);
	}
	_tmp285_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp286_ = _tmp285_;
	result = !_tmp286_;
	return result;
}

static void
vala_initializer_list_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

gint
vala_initializer_list_get_size (ValaInitializerList* self)
{
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
vala_initializer_list_class_init (ValaInitializerListClass * klass,
                                  gpointer klass_data)
{
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInitializerList_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_initializer_list_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}

static void
vala_initializer_list_instance_init (ValaInitializerList * self,
                                     gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_initializer_list_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}

static void
vala_initializer_list_finalize (ValaCodeNode * obj)
{
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}

/**
 * Represents an array or struct initializer list in the source code.
 */
GType
vala_initializer_list_get_type (void)
{
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
		ValaInitializerList_private_offset = g_type_add_instance_private (vala_initializer_list_type_id, sizeof (ValaInitializerListPrivate));
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}

