/* valadelegate.c generated by valac, the Vala compiler
 * generated from valadelegate.vala, do not modify */

/* valadelegate.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaDelegatePrivate {
	ValaDataType* _sender_type;
	ValaList* type_parameters;
	ValaList* parameters;
	ValaDataType* _return_type;
	gboolean* _has_target;
	ValaList* error_types;
};

static gint ValaDelegate_private_offset;
static gpointer vala_delegate_parent_class = NULL;
static ValaCallableIface * vala_delegate_vala_callable_parent_iface = NULL;

static gint vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base,
                                                  const gchar* name);
static void vala_delegate_real_add_parameter (ValaCallable* base,
                                       ValaParameter* param);
static ValaList* vala_delegate_real_get_parameters (ValaCallable* base);
static void vala_delegate_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor);
static void vala_delegate_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base);
static void vala_delegate_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference);
static void vala_delegate_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type);
static gboolean vala_delegate_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_delegate_finalize (ValaCodeNode * obj);

static inline gpointer
vala_delegate_get_instance_private (ValaDelegate* self)
{
	return G_STRUCT_MEMBER_P (self, ValaDelegate_private_offset);
}

/**
 * Creates a new delegate.
 *
 * @param name              delegate type name
 * @param return_type       return type
 * @param source_reference  reference to source code
 * @return                  newly created delegate
 */
ValaDelegate*
vala_delegate_construct (GType object_type,
                         const gchar* name,
                         ValaDataType* return_type,
                         ValaSourceReference* source_reference,
                         ValaComment* comment)
{
	ValaDelegate* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaDelegate*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaDelegate*
vala_delegate_new (const gchar* name,
                   ValaDataType* return_type,
                   ValaSourceReference* source_reference,
                   ValaComment* comment)
{
	return vala_delegate_construct (VALA_TYPE_DELEGATE, name, return_type, source_reference, comment);
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_delegate_add_type_parameter (ValaDelegate* self,
                                  ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, p);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) p);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_delegate_get_type_parameters (ValaDelegate* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
vala_delegate_has_type_parameters (ValaDelegate* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gint
vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base,
                                             const gchar* name)
{
	ValaDelegate * self;
	gint i = 0;
	gint result = 0;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _parameter_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _parameter_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_parameter_list = _tmp1_;
		_tmp2_ = _parameter_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_parameter_size = _tmp4_;
		_parameter_index = -1;
		while (TRUE) {
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaTypeParameter* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gint _tmp10_;
			_parameter_index = _parameter_index + 1;
			if (!(_parameter_index < _parameter_size)) {
				break;
			}
			_tmp5_ = _parameter_list;
			_tmp6_ = vala_list_get (_tmp5_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp6_;
			_tmp7_ = parameter;
			_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
			_tmp9_ = _tmp8_;
			if (g_strcmp0 (_tmp9_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp10_ = i;
			i = _tmp10_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}

/**
 * Appends paramater to this callback function.
 *
 * @param param a formal parameter
 */
static void
vala_delegate_real_add_parameter (ValaCallable* base,
                                  ValaParameter* param)
{
	ValaDelegate * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaDelegate*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

/**
 * Return copy of parameter list.
 *
 * @return parameter list
 */
static ValaList*
vala_delegate_real_get_parameters (ValaCallable* base)
{
	ValaDelegate * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	self = (ValaDelegate*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Checks whether the arguments and return type of the specified method
 * matches this callback.
 *
 * @param m a method
 * @return  true if the specified method is compatible to this callback
 */
gboolean
vala_delegate_matches_method (ValaDelegate* self,
                              ValaMethod* m,
                              ValaDataType* dt)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	gboolean _tmp11_;
	ValaList* method_params = NULL;
	ValaList* _tmp12_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp13_;
	ValaIterator* _tmp14_;
	gboolean _tmp15_ = FALSE;
	ValaDataType* _tmp16_;
	gboolean first = FALSE;
	ValaIterator* _tmp55_;
	ValaArrayList* method_error_types = NULL;
	GEqualFunc _tmp56_;
	ValaArrayList* _tmp57_;
	ValaArrayList* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaList* _tmp61_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	g_return_val_if_fail (dt != NULL, FALSE);
	_tmp1_ = vala_method_get_coroutine (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !VALA_IS_SIGNAL (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_data_type_get_actual_type (_tmp8_, dt, NULL, (ValaCodeNode*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = !vala_data_type_stricter (_tmp6_, _tmp10_);
	_vala_code_node_unref0 (_tmp10_);
	if (_tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = vala_callable_get_parameters ((ValaCallable*) m);
	method_params = _tmp12_;
	_tmp13_ = method_params;
	_tmp14_ = vala_iterable_iterator ((ValaIterable*) _tmp13_);
	method_params_it = _tmp14_;
	_tmp16_ = self->priv->_sender_type;
	if (_tmp16_ != NULL) {
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp17_ = method_params;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->parameters;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp15_ = _tmp19_ == (_tmp22_ + 1);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ValaIterator* _tmp23_;
		ValaParameter* method_param = NULL;
		ValaIterator* _tmp24_;
		gpointer _tmp25_;
		ValaDataType* _tmp26_;
		ValaParameter* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		_tmp23_ = method_params_it;
		vala_iterator_next (_tmp23_);
		_tmp24_ = method_params_it;
		_tmp25_ = vala_iterator_get (_tmp24_);
		method_param = (ValaParameter*) _tmp25_;
		_tmp26_ = self->priv->_sender_type;
		_tmp27_ = method_param;
		_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) _tmp27_);
		_tmp29_ = _tmp28_;
		if (!vala_data_type_stricter (_tmp26_, _tmp29_)) {
			result = FALSE;
			_vala_code_node_unref0 (method_param);
			_vala_iterator_unref0 (method_params_it);
			_vala_iterable_unref0 (method_params);
			return result;
		}
		_vala_code_node_unref0 (method_param);
	}
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		gint _param_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _param_index = 0;
		_tmp30_ = self->priv->parameters;
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		_param_list = _tmp31_;
		_tmp32_ = _param_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_param_size = _tmp34_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp35_;
			gpointer _tmp36_;
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			ValaIterator* _tmp43_;
			ValaParameter* method_param = NULL;
			ValaIterator* _tmp44_;
			gpointer _tmp45_;
			ValaParameter* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			ValaParameter* _tmp51_;
			ValaDataType* _tmp52_;
			ValaDataType* _tmp53_;
			gboolean _tmp54_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp35_ = _param_list;
			_tmp36_ = vala_list_get (_tmp35_, _param_index);
			param = (ValaParameter*) _tmp36_;
			if (first) {
				ValaMemberBinding _tmp39_;
				ValaMemberBinding _tmp40_;
				_tmp39_ = vala_method_get_binding (m);
				_tmp40_ = _tmp39_;
				_tmp38_ = _tmp40_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				gboolean _tmp41_;
				gboolean _tmp42_;
				_tmp41_ = vala_delegate_get_has_target (self);
				_tmp42_ = _tmp41_;
				_tmp37_ = !_tmp42_;
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				first = FALSE;
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp43_ = method_params_it;
			if (!vala_iterator_next (_tmp43_)) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp44_ = method_params_it;
			_tmp45_ = vala_iterator_get (_tmp44_);
			method_param = (ValaParameter*) _tmp45_;
			_tmp46_ = param;
			_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_actual_type (_tmp48_, dt, NULL, (ValaCodeNode*) self);
			_tmp50_ = _tmp49_;
			_tmp51_ = method_param;
			_tmp52_ = vala_variable_get_variable_type ((ValaVariable*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = !vala_data_type_stricter (_tmp50_, _tmp53_);
			_vala_code_node_unref0 (_tmp50_);
			if (_tmp54_) {
				result = FALSE;
				_vala_code_node_unref0 (method_param);
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp55_ = method_params_it;
	if (vala_iterator_next (_tmp55_)) {
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_iterable_unref0 (method_params);
		return result;
	}
	_tmp56_ = g_direct_equal;
	_tmp57_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp56_);
	method_error_types = _tmp57_;
	_tmp58_ = method_error_types;
	vala_code_node_get_error_types ((ValaCodeNode*) m, (ValaCollection*) _tmp58_, NULL);
	_tmp61_ = self->priv->error_types;
	if (_tmp61_ != NULL) {
		ValaList* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		_tmp62_ = self->priv->error_types;
		_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
		_tmp64_ = _tmp63_;
		_tmp60_ = _tmp64_ > 0;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaArrayList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		_tmp65_ = method_error_types;
		_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
		_tmp67_ = _tmp66_;
		_tmp59_ = _tmp67_ == 0;
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		result = FALSE;
		_vala_iterable_unref0 (method_error_types);
		_vala_iterator_unref0 (method_params_it);
		_vala_iterable_unref0 (method_params);
		return result;
	}
	{
		ValaArrayList* _method_error_type_list = NULL;
		ValaArrayList* _tmp68_;
		ValaArrayList* _tmp69_;
		gint _method_error_type_size = 0;
		ValaArrayList* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		gint _method_error_type_index = 0;
		_tmp68_ = method_error_types;
		_tmp69_ = _vala_iterable_ref0 (_tmp68_);
		_method_error_type_list = _tmp69_;
		_tmp70_ = _method_error_type_list;
		_tmp71_ = vala_collection_get_size ((ValaCollection*) _tmp70_);
		_tmp72_ = _tmp71_;
		_method_error_type_size = _tmp72_;
		_method_error_type_index = -1;
		while (TRUE) {
			ValaDataType* method_error_type = NULL;
			ValaArrayList* _tmp73_;
			gpointer _tmp74_;
			gboolean match = FALSE;
			ValaList* _tmp75_;
			_method_error_type_index = _method_error_type_index + 1;
			if (!(_method_error_type_index < _method_error_type_size)) {
				break;
			}
			_tmp73_ = _method_error_type_list;
			_tmp74_ = vala_list_get ((ValaList*) _tmp73_, _method_error_type_index);
			method_error_type = (ValaDataType*) _tmp74_;
			match = FALSE;
			_tmp75_ = self->priv->error_types;
			if (_tmp75_ != NULL) {
				{
					ValaList* _delegate_error_type_list = NULL;
					ValaList* _tmp76_;
					ValaList* _tmp77_;
					gint _delegate_error_type_size = 0;
					ValaList* _tmp78_;
					gint _tmp79_;
					gint _tmp80_;
					gint _delegate_error_type_index = 0;
					_tmp76_ = self->priv->error_types;
					_tmp77_ = _vala_iterable_ref0 (_tmp76_);
					_delegate_error_type_list = _tmp77_;
					_tmp78_ = _delegate_error_type_list;
					_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
					_tmp80_ = _tmp79_;
					_delegate_error_type_size = _tmp80_;
					_delegate_error_type_index = -1;
					while (TRUE) {
						ValaDataType* delegate_error_type = NULL;
						ValaList* _tmp81_;
						gpointer _tmp82_;
						ValaDataType* _tmp83_;
						ValaDataType* _tmp84_;
						_delegate_error_type_index = _delegate_error_type_index + 1;
						if (!(_delegate_error_type_index < _delegate_error_type_size)) {
							break;
						}
						_tmp81_ = _delegate_error_type_list;
						_tmp82_ = vala_list_get (_tmp81_, _delegate_error_type_index);
						delegate_error_type = (ValaDataType*) _tmp82_;
						_tmp83_ = method_error_type;
						_tmp84_ = delegate_error_type;
						if (vala_data_type_compatible (_tmp83_, _tmp84_)) {
							match = TRUE;
							_vala_code_node_unref0 (delegate_error_type);
							break;
						}
						_vala_code_node_unref0 (delegate_error_type);
					}
					_vala_iterable_unref0 (_delegate_error_type_list);
				}
			}
			if (!match) {
				result = FALSE;
				_vala_code_node_unref0 (method_error_type);
				_vala_iterable_unref0 (_method_error_type_list);
				_vala_iterable_unref0 (method_error_types);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_error_type);
		}
		_vala_iterable_unref0 (_method_error_type_list);
	}
	result = TRUE;
	_vala_iterable_unref0 (method_error_types);
	_vala_iterator_unref0 (method_params_it);
	_vala_iterable_unref0 (method_params);
	return result;
}

static void
vala_delegate_real_accept (ValaCodeNode* base,
                           ValaCodeVisitor* visitor)
{
	ValaDelegate * self;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_delegate (visitor, self);
}

static void
vala_delegate_real_accept_children (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaDelegate * self;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaList* _tmp18_;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaTypeParameter* _tmp7_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp5_ = _p_list;
			_tmp6_ = vala_list_get (_tmp5_, _p_index);
			p = (ValaTypeParameter*) _tmp6_;
			_tmp7_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp8_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp9_ = _tmp8_;
	vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _param_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _param_index = 0;
		_tmp10_ = self->priv->parameters;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_param_list = _tmp11_;
		_tmp12_ = _param_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_param_size = _tmp14_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaParameter* _tmp17_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp15_ = _param_list;
			_tmp16_ = vala_list_get (_tmp15_, _param_index);
			param = (ValaParameter*) _tmp16_;
			_tmp17_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp18_ = self->priv->error_types;
	if (_tmp18_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp19_;
			ValaList* _tmp20_;
			gint _error_type_size = 0;
			ValaList* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _error_type_index = 0;
			_tmp19_ = self->priv->error_types;
			_tmp20_ = _vala_iterable_ref0 (_tmp19_);
			_error_type_list = _tmp20_;
			_tmp21_ = _error_type_list;
			_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
			_tmp23_ = _tmp22_;
			_error_type_size = _tmp23_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp24_;
				gpointer _tmp25_;
				ValaDataType* _tmp26_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp24_ = _error_type_list;
				_tmp25_ = vala_list_get (_tmp24_, _error_type_index);
				error_type = (ValaDataType*) _tmp25_;
				_tmp26_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp26_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static gboolean
vala_delegate_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaDelegate * self;
	gboolean result = FALSE;
	self = (ValaDelegate*) base;
	result = FALSE;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this delegate.
 */
void
vala_delegate_add_error_type (ValaDelegate* self,
                              ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->priv->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->error_types);
		self->priv->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_delegate_real_get_error_types (ValaCodeNode* base,
                                    ValaCollection* collection,
                                    ValaSourceReference* source_reference)
{
	ValaDelegate * self;
	ValaList* _tmp0_;
	self = (ValaDelegate*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _error_type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _error_type_index = 0;
			_tmp1_ = self->priv->error_types;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_error_type_list = _tmp2_;
			_tmp3_ = _error_type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_error_type_size = _tmp5_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp6_ = _error_type_list;
				_tmp7_ = vala_list_get (_tmp6_, _error_type_index);
				error_type = (ValaDataType*) _tmp7_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp8_;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					_tmp8_ = error_type;
					_tmp9_ = vala_data_type_copy (_tmp8_);
					type = _tmp9_;
					_tmp10_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp10_, source_reference);
					_tmp11_ = type;
					vala_collection_add (collection, _tmp11_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp12_;
					_tmp12_ = error_type;
					vala_collection_add (collection, _tmp12_);
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static void
vala_delegate_real_replace_type (ValaCodeNode* base,
                                 ValaDataType* old_type,
                                 ValaDataType* new_type)
{
	ValaDelegate * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaList* _tmp2_;
	self = (ValaDelegate*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp2_ = self->priv->error_types;
	if (_tmp2_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					ValaList* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					ValaList* _tmp8_;
					gpointer _tmp9_;
					ValaDataType* _tmp10_;
					gboolean _tmp11_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = self->priv->error_types;
					_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
					_tmp7_ = _tmp6_;
					if (!(i < _tmp7_)) {
						break;
					}
					_tmp8_ = self->priv->error_types;
					_tmp9_ = vala_list_get (_tmp8_, i);
					_tmp10_ = (ValaDataType*) _tmp9_;
					_tmp11_ = _tmp10_ == old_type;
					_vala_code_node_unref0 (_tmp10_);
					if (_tmp11_) {
						ValaList* _tmp12_;
						_tmp12_ = self->priv->error_types;
						vala_list_set (_tmp12_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_delegate_real_check (ValaCodeNode* base,
                          ValaCodeContext* context)
{
	ValaDelegate * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceReference* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	ValaTypeSymbol* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaSemanticAnalyzer* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaDataType* _tmp33_;
	ValaTypeSymbol* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaList* _tmp54_;
	ValaSemanticAnalyzer* _tmp75_;
	ValaSemanticAnalyzer* _tmp76_;
	ValaSourceFile* _tmp77_;
	gboolean _tmp78_;
	gboolean _tmp79_;
	gboolean result = FALSE;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaSemanticAnalyzer* _tmp11_;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceFile* _tmp15_;
		ValaSourceFile* _tmp16_;
		_tmp11_ = vala_code_context_get_analyzer (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_source_reference_get_file (_tmp14_);
		_tmp16_ = _tmp15_;
		vala_semantic_analyzer_set_current_source_file (_tmp12_, _tmp16_);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _p_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _p_index = 0;
		_tmp17_ = self->priv->type_parameters;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_p_list = _tmp18_;
		_tmp19_ = _p_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_p_size = _tmp21_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaTypeParameter* _tmp24_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp22_ = _p_list;
			_tmp23_ = vala_list_get (_tmp22_, _p_index);
			p = (ValaTypeParameter*) _tmp23_;
			_tmp24_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp24_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp25_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp26_ = _tmp25_;
	vala_code_node_check ((ValaCodeNode*) _tmp26_, context);
	_tmp27_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_data_type_get_data_type (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_code_context_get_analyzer (context);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_->va_list_type;
	_tmp34_ = vala_data_type_get_data_type (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp30_ == _tmp35_) {
		ValaSourceReference* _tmp36_;
		ValaSourceReference* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaTypeSymbol* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_get_data_type (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strdup_printf ("`%s' not supported as return type", _tmp43_);
		_tmp45_ = _tmp44_;
		vala_report_error (_tmp37_, _tmp45_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		result = FALSE;
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		gint _param_size = 0;
		ValaList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _param_index = 0;
		_tmp46_ = self->priv->parameters;
		_tmp47_ = _vala_iterable_ref0 (_tmp46_);
		_param_list = _tmp47_;
		_tmp48_ = _param_list;
		_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_param_size = _tmp50_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp51_;
			gpointer _tmp52_;
			ValaParameter* _tmp53_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp51_ = _param_list;
			_tmp52_ = vala_list_get (_tmp51_, _param_index);
			param = (ValaParameter*) _tmp52_;
			_tmp53_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp53_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp54_ = self->priv->error_types;
	if (_tmp54_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp55_;
			ValaList* _tmp56_;
			gint _error_type_size = 0;
			ValaList* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			gint _error_type_index = 0;
			_tmp55_ = self->priv->error_types;
			_tmp56_ = _vala_iterable_ref0 (_tmp55_);
			_error_type_list = _tmp56_;
			_tmp57_ = _error_type_list;
			_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
			_tmp59_ = _tmp58_;
			_error_type_size = _tmp59_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp60_;
				gpointer _tmp61_;
				ValaDataType* _tmp62_;
				ValaSemanticAnalyzer* _tmp63_;
				ValaSemanticAnalyzer* _tmp64_;
				ValaDataType* _tmp65_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp60_ = _error_type_list;
				_tmp61_ = vala_list_get (_tmp60_, _error_type_index);
				error_type = (ValaDataType*) _tmp61_;
				_tmp62_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp62_, context);
				_tmp63_ = vala_code_context_get_analyzer (context);
				_tmp64_ = _tmp63_;
				_tmp65_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp64_, (ValaSymbol*) self, _tmp65_)) {
					ValaSourceReference* _tmp66_;
					ValaSourceReference* _tmp67_;
					ValaDataType* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp67_ = _tmp66_;
					_tmp68_ = error_type;
					_tmp69_ = vala_code_node_to_string ((ValaCodeNode*) _tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp72_ = _tmp71_;
					_tmp73_ = g_strdup_printf ("error type `%s' is less accessible than delegate `%s'", _tmp70_, _tmp72_);
					_tmp74_ = _tmp73_;
					vala_report_error (_tmp67_, _tmp74_);
					_g_free0 (_tmp74_);
					_g_free0 (_tmp72_);
					_g_free0 (_tmp70_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp75_ = vala_code_context_get_analyzer (context);
	_tmp76_ = _tmp75_;
	_tmp77_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp76_, _tmp77_);
	_tmp78_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp79_ = _tmp78_;
	result = !_tmp79_;
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static ValaDataType*
vala_delegate_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaDelegate* self;
	ValaDataType* _tmp0_;
	self = (ValaDelegate*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_delegate_real_set_return_type (ValaCallable* base,
                                    ValaDataType* value)
{
	ValaDelegate* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaDelegate*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_delegate_get_has_target (ValaDelegate* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_target;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_target", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_has_target);
		self->priv->_has_target = _tmp2_;
	}
	_tmp3_ = self->priv->_has_target;
	result = *_tmp3_;
	return result;
}

void
vala_delegate_set_has_target (ValaDelegate* self,
                              gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_has_target);
	self->priv->_has_target = _tmp0_;
	if (value) {
		vala_code_node_remove_attribute_argument ((ValaCodeNode*) self, "CCode", "has_target");
	} else {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_target", FALSE, NULL);
	}
}

ValaDataType*
vala_delegate_get_sender_type (ValaDelegate* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sender_type;
	result = _tmp0_;
	return result;
}

void
vala_delegate_set_sender_type (ValaDelegate* self,
                               ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_sender_type);
	self->priv->_sender_type = _tmp0_;
}

static void
vala_delegate_class_init (ValaDelegateClass * klass,
                          gpointer klass_data)
{
	vala_delegate_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_delegate_finalize;
	g_type_class_adjust_private_offset (klass, &ValaDelegate_private_offset);
	((ValaTypeSymbolClass *) klass)->get_type_parameter_index = (gint (*) (ValaTypeSymbol*, const gchar*)) vala_delegate_real_get_type_parameter_index;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_delegate_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_delegate_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_delegate_real_is_reference_type;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_delegate_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_delegate_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_delegate_real_check;
}

static void
vala_delegate_vala_callable_interface_init (ValaCallableIface * iface,
                                            gpointer iface_data)
{
	vala_delegate_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_delegate_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_delegate_real_get_parameters;
	iface->get_return_type = vala_delegate_real_get_return_type;
	iface->set_return_type = vala_delegate_real_set_return_type;
}

static void
vala_delegate_instance_init (ValaDelegate * self,
                             gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_delegate_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->parameters = (ValaList*) _tmp3_;
}

static void
vala_delegate_finalize (ValaCodeNode * obj)
{
	ValaDelegate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_DELEGATE, ValaDelegate);
	_vala_code_node_unref0 (self->priv->_sender_type);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_return_type);
	_g_free0 (self->priv->_has_target);
	_vala_iterable_unref0 (self->priv->error_types);
	VALA_CODE_NODE_CLASS (vala_delegate_parent_class)->finalize (obj);
}

/**
 * Represents a function callback type.
 */
GType
vala_delegate_get_type (void)
{
	static volatile gsize vala_delegate_type_id__volatile = 0;
	if (g_once_init_enter (&vala_delegate_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDelegateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_delegate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDelegate), 0, (GInstanceInitFunc) vala_delegate_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_delegate_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_delegate_type_id;
		vala_delegate_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaDelegate", &g_define_type_info, 0);
		g_type_add_interface_static (vala_delegate_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		ValaDelegate_private_offset = g_type_add_instance_private (vala_delegate_type_id, sizeof (ValaDelegatePrivate));
		g_once_init_leave (&vala_delegate_type_id__volatile, vala_delegate_type_id);
	}
	return vala_delegate_type_id__volatile;
}

