/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};

static gint ValaCreationMethod_private_offset;
static gpointer vala_creation_method_parent_class = NULL;

static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);

static inline gpointer
vala_creation_method_get_instance_private (ValaCreationMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCreationMethod_private_offset);
}

/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}

ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}

static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaList* _tmp7_;
	ValaBlock* _tmp30_;
	ValaBlock* _tmp31_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaParameter* _tmp6_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp4_ = _param_list;
			_tmp5_ = vala_list_get (_tmp4_, _param_index);
			param = (ValaParameter*) _tmp5_;
			_tmp6_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp7_ = ((ValaMethod*) self)->error_types;
	if (_tmp7_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp8_;
			ValaList* _tmp9_;
			gint _error_type_size = 0;
			ValaList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _error_type_index = 0;
			_tmp8_ = ((ValaMethod*) self)->error_types;
			_tmp9_ = _vala_iterable_ref0 (_tmp8_);
			_error_type_list = _tmp9_;
			_tmp10_ = _error_type_list;
			_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_error_type_size = _tmp12_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp13_;
				gpointer _tmp14_;
				ValaDataType* _tmp15_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp13_ = _error_type_list;
				_tmp14_ = vala_list_get (_tmp13_, _error_type_index);
				error_type = (ValaDataType*) _tmp14_;
				_tmp15_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp16_;
		gint _precondition_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _precondition_index = 0;
		_tmp16_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp16_;
		_tmp17_ = _precondition_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_precondition_size = _tmp19_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaExpression* _tmp22_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp20_ = _precondition_list;
			_tmp21_ = vala_list_get (_tmp20_, _precondition_index);
			precondition = (ValaExpression*) _tmp21_;
			_tmp22_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp23_;
		gint _postcondition_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _postcondition_index = 0;
		_tmp23_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp23_;
		_tmp24_ = _postcondition_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_postcondition_size = _tmp26_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaExpression* _tmp29_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp27_ = _postcondition_list;
			_tmp28_ = vala_list_get (_tmp27_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp28_;
			_tmp29_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp30_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != NULL) {
		ValaBlock* _tmp32_;
		ValaBlock* _tmp33_;
		_tmp32_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp33_ = _tmp32_;
		vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaSourceFile* _tmp24_;
	ValaSourceFile* _tmp25_;
	ValaSourceFile* _tmp26_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSemanticAnalyzer* _tmp28_;
	ValaSymbol* _tmp29_;
	ValaSymbol* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSemanticAnalyzer* _tmp40_;
	ValaSemanticAnalyzer* _tmp41_;
	gint i = 0;
	ValaList* _tmp60_;
	ValaBlock* _tmp95_;
	ValaBlock* _tmp96_;
	ValaSemanticAnalyzer* _tmp221_;
	ValaSemanticAnalyzer* _tmp222_;
	ValaSourceFile* _tmp223_;
	ValaSemanticAnalyzer* _tmp224_;
	ValaSemanticAnalyzer* _tmp225_;
	ValaSymbol* _tmp226_;
	gboolean _tmp227_ = FALSE;
	gboolean _tmp228_ = FALSE;
	gboolean _tmp229_;
	gboolean _tmp230_;
	gboolean _tmp241_ = FALSE;
	ValaBlock* _tmp242_;
	ValaBlock* _tmp243_;
	gboolean _tmp282_;
	gboolean _tmp283_;
	gboolean result = FALSE;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		_tmp20_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_report_error (_tmp12_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_semantic_analyzer_get_current_source_file (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _vala_source_file_ref0 (_tmp25_);
	old_source_file = _tmp26_;
	_tmp27_ = vala_code_context_get_analyzer (context);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_semantic_analyzer_get_current_symbol (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _vala_code_node_ref0 (_tmp30_);
	old_symbol = _tmp31_;
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaSemanticAnalyzer* _tmp34_;
		ValaSemanticAnalyzer* _tmp35_;
		ValaSourceReference* _tmp36_;
		ValaSourceReference* _tmp37_;
		ValaSourceFile* _tmp38_;
		ValaSourceFile* _tmp39_;
		_tmp34_ = vala_code_context_get_analyzer (context);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_source_reference_get_file (_tmp37_);
		_tmp39_ = _tmp38_;
		vala_semantic_analyzer_set_current_source_file (_tmp35_, _tmp39_);
	}
	_tmp40_ = vala_code_context_get_analyzer (context);
	_tmp41_ = _tmp40_;
	vala_semantic_analyzer_set_current_symbol (_tmp41_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp42_;
		gint _param_size = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _param_index = 0;
		_tmp42_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp42_;
		_tmp43_ = _param_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_param_size = _tmp45_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			ValaParameter* _tmp48_;
			gboolean _tmp49_ = FALSE;
			gboolean _tmp50_ = FALSE;
			gint _tmp59_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp46_ = _param_list;
			_tmp47_ = vala_list_get (_tmp46_, _param_index);
			param = (ValaParameter*) _tmp47_;
			_tmp48_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp48_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (i == 0) {
				ValaParameter* _tmp51_;
				gboolean _tmp52_;
				gboolean _tmp53_;
				_tmp51_ = param;
				_tmp52_ = vala_parameter_get_ellipsis (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp50_ = _tmp53_;
			} else {
				_tmp50_ = FALSE;
			}
			if (_tmp50_) {
				ValaBlock* _tmp54_;
				ValaBlock* _tmp55_;
				_tmp54_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp55_ = _tmp54_;
				_tmp49_ = _tmp55_ != NULL;
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaParameter* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaSourceReference* _tmp58_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp56_ = param;
				_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp56_);
				_tmp58_ = _tmp57_;
				vala_report_error (_tmp58_, "Named parameter required before `...'");
			}
			_tmp59_ = i;
			i = _tmp59_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp60_ = ((ValaMethod*) self)->error_types;
	if (_tmp60_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp61_;
			ValaList* _tmp62_;
			gint _error_type_size = 0;
			ValaList* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			gint _error_type_index = 0;
			_tmp61_ = ((ValaMethod*) self)->error_types;
			_tmp62_ = _vala_iterable_ref0 (_tmp61_);
			_error_type_list = _tmp62_;
			_tmp63_ = _error_type_list;
			_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
			_tmp65_ = _tmp64_;
			_error_type_size = _tmp65_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp66_;
				gpointer _tmp67_;
				ValaDataType* _tmp68_;
				ValaSemanticAnalyzer* _tmp69_;
				ValaSemanticAnalyzer* _tmp70_;
				ValaDataType* _tmp71_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp66_ = _error_type_list;
				_tmp67_ = vala_list_get (_tmp66_, _error_type_index);
				error_type = (ValaDataType*) _tmp67_;
				_tmp68_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp68_, context);
				_tmp69_ = vala_code_context_get_analyzer (context);
				_tmp70_ = _tmp69_;
				_tmp71_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp70_, (ValaSymbol*) self, _tmp71_)) {
					ValaSourceReference* _tmp72_;
					ValaSourceReference* _tmp73_;
					ValaDataType* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp73_ = _tmp72_;
					_tmp74_ = error_type;
					_tmp75_ = vala_code_node_to_string ((ValaCodeNode*) _tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp78_ = _tmp77_;
					_tmp79_ = g_strdup_printf ("error type `%s' is less accessible than creation method `%s'", _tmp76_, _tmp78_);
					_tmp80_ = _tmp79_;
					vala_report_error (_tmp73_, _tmp80_);
					_g_free0 (_tmp80_);
					_g_free0 (_tmp78_);
					_g_free0 (_tmp76_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp81_;
		gint _precondition_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _precondition_index = 0;
		_tmp81_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp81_;
		_tmp82_ = _precondition_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_precondition_size = _tmp84_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp85_;
			gpointer _tmp86_;
			ValaExpression* _tmp87_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp85_ = _precondition_list;
			_tmp86_ = vala_list_get (_tmp85_, _precondition_index);
			precondition = (ValaExpression*) _tmp86_;
			_tmp87_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp87_, context);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp88_;
		gint _postcondition_size = 0;
		ValaList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _postcondition_index = 0;
		_tmp88_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp88_;
		_tmp89_ = _postcondition_list;
		_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_postcondition_size = _tmp91_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp92_;
			gpointer _tmp93_;
			ValaExpression* _tmp94_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp92_ = _postcondition_list;
			_tmp93_ = vala_list_get (_tmp92_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp93_;
			_tmp94_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp94_, context);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp95_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp96_ = _tmp95_;
	if (_tmp96_ != NULL) {
		ValaBlock* _tmp97_;
		ValaBlock* _tmp98_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaClass* _tmp101_;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		gboolean _tmp104_;
		_tmp97_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp98_ = _tmp97_;
		vala_code_node_check ((ValaCodeNode*) _tmp98_, context);
		_tmp99_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp100_) ? ((ValaClass*) _tmp100_) : NULL);
		cl = _tmp101_;
		_tmp104_ = self->priv->_chain_up;
		if (!_tmp104_) {
			ValaClass* _tmp105_;
			_tmp105_ = cl;
			_tmp103_ = _tmp105_ != NULL;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaClass* _tmp106_;
			ValaClass* _tmp107_;
			ValaClass* _tmp108_;
			_tmp106_ = cl;
			_tmp107_ = vala_class_get_base_class (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp102_ = _tmp108_ != NULL;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			gboolean _tmp109_ = FALSE;
			gboolean _tmp110_ = FALSE;
			ValaProfile _tmp111_;
			ValaProfile _tmp112_;
			_tmp111_ = vala_code_context_get_profile (context);
			_tmp112_ = _tmp111_;
			if (_tmp112_ == VALA_PROFILE_GOBJECT) {
				ValaClass* _tmp113_;
				ValaClass* _tmp114_;
				ValaClass* _tmp115_;
				ValaCreationMethod* _tmp116_;
				ValaCreationMethod* _tmp117_;
				_tmp113_ = cl;
				_tmp114_ = vala_class_get_base_class (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_class_get_default_construction_method (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp110_ = _tmp117_ != NULL;
			} else {
				_tmp110_ = FALSE;
			}
			if (_tmp110_) {
				ValaClass* _tmp118_;
				ValaClass* _tmp119_;
				ValaClass* _tmp120_;
				ValaCreationMethod* _tmp121_;
				ValaCreationMethod* _tmp122_;
				gboolean _tmp123_;
				gboolean _tmp124_;
				_tmp118_ = cl;
				_tmp119_ = vala_class_get_base_class (_tmp118_);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_class_get_default_construction_method (_tmp120_);
				_tmp122_ = _tmp121_;
				_tmp123_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp122_);
				_tmp124_ = _tmp123_;
				_tmp109_ = !_tmp124_;
			} else {
				_tmp109_ = FALSE;
			}
			if (_tmp109_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp125_;
				ValaSemanticAnalyzer* _tmp126_;
				ValaBlock* _tmp127_;
				ValaBlock* _tmp128_;
				ValaSemanticAnalyzer* _tmp129_;
				ValaSemanticAnalyzer* _tmp130_;
				ValaBlock* _tmp131_;
				ValaBlock* _tmp132_;
				ValaSemanticAnalyzer* _tmp133_;
				ValaSemanticAnalyzer* _tmp134_;
				ValaBlock* _tmp135_;
				ValaBlock* _tmp136_;
				ValaBlock* _tmp137_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp138_;
				ValaSourceReference* _tmp139_;
				ValaMemberAccess* _tmp140_;
				ValaMemberAccess* _tmp141_;
				ValaSourceReference* _tmp142_;
				ValaSourceReference* _tmp143_;
				ValaMemberAccess* _tmp144_;
				ValaMemberAccess* _tmp145_;
				ValaSourceReference* _tmp146_;
				ValaSourceReference* _tmp147_;
				ValaMethodCall* _tmp148_;
				ValaMethodCall* _tmp149_;
				ValaSourceReference* _tmp150_;
				ValaSourceReference* _tmp151_;
				ValaExpressionStatement* _tmp152_;
				ValaExpressionStatement* _tmp153_;
				ValaBlock* _tmp154_;
				ValaBlock* _tmp155_;
				ValaExpressionStatement* _tmp156_;
				ValaExpressionStatement* _tmp157_;
				ValaSemanticAnalyzer* _tmp158_;
				ValaSemanticAnalyzer* _tmp159_;
				ValaSemanticAnalyzer* _tmp160_;
				ValaSemanticAnalyzer* _tmp161_;
				ValaBlock* _tmp162_;
				ValaBlock* _tmp163_;
				_tmp125_ = vala_code_context_get_analyzer (context);
				_tmp126_ = _tmp125_;
				_tmp127_ = _tmp126_->insert_block;
				_tmp128_ = _vala_code_node_ref0 (_tmp127_);
				old_insert_block = _tmp128_;
				_tmp129_ = vala_code_context_get_analyzer (context);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp132_ = _tmp131_;
				vala_semantic_analyzer_set_current_symbol (_tmp130_, (ValaSymbol*) _tmp132_);
				_tmp133_ = vala_code_context_get_analyzer (context);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp136_ = _tmp135_;
				_tmp137_ = _vala_code_node_ref0 (_tmp136_);
				_vala_code_node_unref0 (_tmp134_->insert_block);
				_tmp134_->insert_block = _tmp137_;
				_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp139_ = _tmp138_;
				_tmp140_ = vala_member_access_new_simple ("GLib", _tmp139_);
				_tmp141_ = _tmp140_;
				_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp143_ = _tmp142_;
				_tmp144_ = vala_member_access_new ((ValaExpression*) _tmp141_, "Object", _tmp143_);
				_tmp145_ = _tmp144_;
				_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp147_ = _tmp146_;
				_tmp148_ = vala_method_call_new ((ValaExpression*) _tmp145_, _tmp147_);
				_tmp149_ = _tmp148_;
				_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp151_ = _tmp150_;
				_tmp152_ = vala_expression_statement_new ((ValaExpression*) _tmp149_, _tmp151_);
				_tmp153_ = _tmp152_;
				_vala_code_node_unref0 (_tmp149_);
				_vala_code_node_unref0 (_tmp145_);
				_vala_code_node_unref0 (_tmp141_);
				stmt = _tmp153_;
				_tmp154_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp155_ = _tmp154_;
				_tmp156_ = stmt;
				vala_block_insert_statement (_tmp155_, 0, (ValaStatement*) _tmp156_);
				_tmp157_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp157_, context);
				_tmp158_ = vala_code_context_get_analyzer (context);
				_tmp159_ = _tmp158_;
				vala_semantic_analyzer_set_current_symbol (_tmp159_, (ValaSymbol*) self);
				_tmp160_ = vala_code_context_get_analyzer (context);
				_tmp161_ = _tmp160_;
				_tmp162_ = old_insert_block;
				_tmp163_ = _vala_code_node_ref0 (_tmp162_);
				_vala_code_node_unref0 (_tmp161_->insert_block);
				_tmp161_->insert_block = _tmp163_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp164_ = FALSE;
				ValaClass* _tmp165_;
				ValaClass* _tmp166_;
				ValaClass* _tmp167_;
				ValaCreationMethod* _tmp168_;
				ValaCreationMethod* _tmp169_;
				_tmp165_ = cl;
				_tmp166_ = vala_class_get_base_class (_tmp165_);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_class_get_default_construction_method (_tmp167_);
				_tmp169_ = _tmp168_;
				if (_tmp169_ == NULL) {
					_tmp164_ = TRUE;
				} else {
					ValaClass* _tmp170_;
					ValaClass* _tmp171_;
					ValaClass* _tmp172_;
					ValaCreationMethod* _tmp173_;
					ValaCreationMethod* _tmp174_;
					ValaSymbolAccessibility _tmp175_;
					ValaSymbolAccessibility _tmp176_;
					_tmp170_ = cl;
					_tmp171_ = vala_class_get_base_class (_tmp170_);
					_tmp172_ = _tmp171_;
					_tmp173_ = vala_class_get_default_construction_method (_tmp172_);
					_tmp174_ = _tmp173_;
					_tmp175_ = vala_symbol_get_access ((ValaSymbol*) _tmp174_);
					_tmp176_ = _tmp175_;
					_tmp164_ = _tmp176_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp164_) {
					ValaSourceReference* _tmp177_;
					ValaSourceReference* _tmp178_;
					_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp178_ = _tmp177_;
					vala_report_error (_tmp178_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp179_;
					ValaClass* _tmp180_;
					ValaClass* _tmp181_;
					ValaCreationMethod* _tmp182_;
					ValaCreationMethod* _tmp183_;
					_tmp179_ = cl;
					_tmp180_ = vala_class_get_base_class (_tmp179_);
					_tmp181_ = _tmp180_;
					_tmp182_ = vala_class_get_default_construction_method (_tmp181_);
					_tmp183_ = _tmp182_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp183_) > 0) {
						ValaSourceReference* _tmp184_;
						ValaSourceReference* _tmp185_;
						_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp185_ = _tmp184_;
						vala_report_error (_tmp185_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp186_;
						ValaSemanticAnalyzer* _tmp187_;
						ValaBlock* _tmp188_;
						ValaBlock* _tmp189_;
						ValaSemanticAnalyzer* _tmp190_;
						ValaSemanticAnalyzer* _tmp191_;
						ValaBlock* _tmp192_;
						ValaBlock* _tmp193_;
						ValaSemanticAnalyzer* _tmp194_;
						ValaSemanticAnalyzer* _tmp195_;
						ValaBlock* _tmp196_;
						ValaBlock* _tmp197_;
						ValaBlock* _tmp198_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp199_;
						ValaSourceReference* _tmp200_;
						ValaBaseAccess* _tmp201_;
						ValaBaseAccess* _tmp202_;
						ValaSourceReference* _tmp203_;
						ValaSourceReference* _tmp204_;
						ValaMethodCall* _tmp205_;
						ValaMethodCall* _tmp206_;
						ValaSourceReference* _tmp207_;
						ValaSourceReference* _tmp208_;
						ValaExpressionStatement* _tmp209_;
						ValaExpressionStatement* _tmp210_;
						ValaBlock* _tmp211_;
						ValaBlock* _tmp212_;
						ValaExpressionStatement* _tmp213_;
						ValaExpressionStatement* _tmp214_;
						ValaSemanticAnalyzer* _tmp215_;
						ValaSemanticAnalyzer* _tmp216_;
						ValaSemanticAnalyzer* _tmp217_;
						ValaSemanticAnalyzer* _tmp218_;
						ValaBlock* _tmp219_;
						ValaBlock* _tmp220_;
						_tmp186_ = vala_code_context_get_analyzer (context);
						_tmp187_ = _tmp186_;
						_tmp188_ = _tmp187_->insert_block;
						_tmp189_ = _vala_code_node_ref0 (_tmp188_);
						old_insert_block = _tmp189_;
						_tmp190_ = vala_code_context_get_analyzer (context);
						_tmp191_ = _tmp190_;
						_tmp192_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp193_ = _tmp192_;
						vala_semantic_analyzer_set_current_symbol (_tmp191_, (ValaSymbol*) _tmp193_);
						_tmp194_ = vala_code_context_get_analyzer (context);
						_tmp195_ = _tmp194_;
						_tmp196_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp197_ = _tmp196_;
						_tmp198_ = _vala_code_node_ref0 (_tmp197_);
						_vala_code_node_unref0 (_tmp195_->insert_block);
						_tmp195_->insert_block = _tmp198_;
						_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_base_access_new (_tmp200_);
						_tmp202_ = _tmp201_;
						_tmp203_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp204_ = _tmp203_;
						_tmp205_ = vala_method_call_new ((ValaExpression*) _tmp202_, _tmp204_);
						_tmp206_ = _tmp205_;
						_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp208_ = _tmp207_;
						_tmp209_ = vala_expression_statement_new ((ValaExpression*) _tmp206_, _tmp208_);
						_tmp210_ = _tmp209_;
						_vala_code_node_unref0 (_tmp206_);
						_vala_code_node_unref0 (_tmp202_);
						stmt = _tmp210_;
						_tmp211_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp212_ = _tmp211_;
						_tmp213_ = stmt;
						vala_block_insert_statement (_tmp212_, 0, (ValaStatement*) _tmp213_);
						_tmp214_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp214_, context);
						_tmp215_ = vala_code_context_get_analyzer (context);
						_tmp216_ = _tmp215_;
						vala_semantic_analyzer_set_current_symbol (_tmp216_, (ValaSymbol*) self);
						_tmp217_ = vala_code_context_get_analyzer (context);
						_tmp218_ = _tmp217_;
						_tmp219_ = old_insert_block;
						_tmp220_ = _vala_code_node_ref0 (_tmp219_);
						_vala_code_node_unref0 (_tmp218_->insert_block);
						_tmp218_->insert_block = _tmp220_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp221_ = vala_code_context_get_analyzer (context);
	_tmp222_ = _tmp221_;
	_tmp223_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp222_, _tmp223_);
	_tmp224_ = vala_code_context_get_analyzer (context);
	_tmp225_ = _tmp224_;
	_tmp226_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp225_, _tmp226_);
	_tmp229_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp230_ = _tmp229_;
	if (_tmp230_) {
		_tmp228_ = TRUE;
	} else {
		gboolean _tmp231_;
		gboolean _tmp232_;
		_tmp231_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp232_ = _tmp231_;
		_tmp228_ = _tmp232_;
	}
	if (_tmp228_) {
		_tmp227_ = TRUE;
	} else {
		gboolean _tmp233_;
		gboolean _tmp234_;
		_tmp233_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp234_ = _tmp233_;
		_tmp227_ = _tmp234_;
	}
	if (_tmp227_) {
		ValaSourceReference* _tmp235_;
		ValaSourceReference* _tmp236_;
		gchar* _tmp237_;
		gchar* _tmp238_;
		gchar* _tmp239_;
		gchar* _tmp240_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp236_ = _tmp235_;
		_tmp237_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp238_ = _tmp237_;
		_tmp239_ = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp238_);
		_tmp240_ = _tmp239_;
		vala_report_error (_tmp236_, _tmp240_);
		_g_free0 (_tmp240_);
		_g_free0 (_tmp238_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp242_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp243_ = _tmp242_;
	if (_tmp243_ != NULL) {
		ValaBlock* _tmp244_;
		ValaBlock* _tmp245_;
		gboolean _tmp246_;
		gboolean _tmp247_;
		_tmp244_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_code_node_get_error ((ValaCodeNode*) _tmp245_);
		_tmp247_ = _tmp246_;
		_tmp241_ = !_tmp247_;
	} else {
		_tmp241_ = FALSE;
	}
	if (_tmp241_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp248_;
		ValaArrayList* _tmp249_;
		ValaBlock* _tmp250_;
		ValaBlock* _tmp251_;
		ValaArrayList* _tmp252_;
		_tmp248_ = g_direct_equal;
		_tmp249_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp248_);
		body_errors = _tmp249_;
		_tmp250_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp251_ = _tmp250_;
		_tmp252_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp251_, (ValaCollection*) _tmp252_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp253_;
			ValaArrayList* _tmp254_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp255_;
			gint _tmp256_;
			gint _tmp257_;
			gint _body_error_type_index = 0;
			_tmp253_ = body_errors;
			_tmp254_ = _vala_iterable_ref0 (_tmp253_);
			_body_error_type_list = _tmp254_;
			_tmp255_ = _body_error_type_list;
			_tmp256_ = vala_collection_get_size ((ValaCollection*) _tmp255_);
			_tmp257_ = _tmp256_;
			_body_error_type_size = _tmp257_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp258_;
				gpointer _tmp259_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp260_;
				gboolean _tmp270_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp258_ = _body_error_type_list;
				_tmp259_ = vala_list_get ((ValaList*) _tmp258_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp259_;
				can_propagate_error = FALSE;
				_tmp260_ = ((ValaMethod*) self)->error_types;
				if (_tmp260_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp261_;
						ValaList* _tmp262_;
						gint _method_error_type_size = 0;
						ValaList* _tmp263_;
						gint _tmp264_;
						gint _tmp265_;
						gint _method_error_type_index = 0;
						_tmp261_ = ((ValaMethod*) self)->error_types;
						_tmp262_ = _vala_iterable_ref0 (_tmp261_);
						_method_error_type_list = _tmp262_;
						_tmp263_ = _method_error_type_list;
						_tmp264_ = vala_collection_get_size ((ValaCollection*) _tmp263_);
						_tmp265_ = _tmp264_;
						_method_error_type_size = _tmp265_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp266_;
							gpointer _tmp267_;
							ValaDataType* _tmp268_;
							ValaDataType* _tmp269_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp266_ = _method_error_type_list;
							_tmp267_ = vala_list_get (_tmp266_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp267_;
							_tmp268_ = body_error_type;
							_tmp269_ = method_error_type;
							if (vala_data_type_compatible (_tmp268_, _tmp269_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				if (!can_propagate_error) {
					ValaDataType* _tmp271_;
					gboolean _tmp272_;
					gboolean _tmp273_;
					_tmp271_ = body_error_type;
					_tmp272_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp271_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp273_ = _tmp272_;
					_tmp270_ = !_tmp273_;
				} else {
					_tmp270_ = FALSE;
				}
				if (_tmp270_) {
					ValaDataType* _tmp274_;
					ValaSourceReference* _tmp275_;
					ValaSourceReference* _tmp276_;
					ValaDataType* _tmp277_;
					gchar* _tmp278_;
					gchar* _tmp279_;
					gchar* _tmp280_;
					gchar* _tmp281_;
					_tmp274_ = body_error_type;
					_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp274_);
					_tmp276_ = _tmp275_;
					_tmp277_ = body_error_type;
					_tmp278_ = vala_code_node_to_string ((ValaCodeNode*) _tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = g_strdup_printf ("unhandled error `%s'", _tmp279_);
					_tmp281_ = _tmp280_;
					vala_report_warning (_tmp276_, _tmp281_);
					_g_free0 (_tmp281_);
					_g_free0 (_tmp279_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	_tmp282_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp283_ = _tmp282_;
	result = !_tmp283_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}

void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}

gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_chain_up;
	return result;
}

void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}

static void
vala_creation_method_class_init (ValaCreationMethodClass * klass,
                                 gpointer klass_data)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCreationMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}

static void
vala_creation_method_instance_init (ValaCreationMethod * self,
                                    gpointer klass)
{
	self->priv = vala_creation_method_get_instance_private (self);
}

static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}

/**
 * Represents a type creation method.
 */
GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
		ValaCreationMethod_private_offset = g_type_add_instance_private (vala_creation_method_type_id, sizeof (ValaCreationMethodPrivate));
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}

