/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static void vala_assignment_check_constant_assignment (ValaAssignment* self,
                                                ValaMemberAccess* inner);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp91_;
	ValaExpression* _tmp92_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp239_;
	ValaExpression* _tmp240_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp241_;
	ValaExpression* _tmp242_;
	gboolean _tmp243_ = FALSE;
	gboolean _tmp244_ = FALSE;
	ValaAssignmentOperator _tmp245_;
	ValaMemberAccess* _tmp292_;
	ValaExpression* _tmp674_;
	ValaExpression* _tmp675_;
	ValaDataType* _tmp676_;
	ValaDataType* _tmp677_;
	ValaDataType* _tmp686_;
	ValaDataType* _tmp687_;
	gboolean _tmp690_;
	gboolean _tmp691_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaBlock* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		ValaDeclarationStatement* _tmp32_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp80_;
		ValaSemanticAnalyzer* _tmp81_;
		ValaList* _tmp82_;
		ValaCodeNode* _tmp83_;
		ValaCodeNode* _tmp84_;
		ValaExpressionStatement* _tmp85_;
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaExpressionStatement* _tmp88_;
		ValaExpression* _tmp89_;
		ValaExpression* _tmp90_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = vala_code_context_get_analyzer (context);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->insert_block;
		_tmp31_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp30_, (ValaStatement*) _tmp31_);
		_tmp32_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp32_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp33_ = tuple;
			_tmp34_ = vala_tuple_get_expressions (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				ValaExpression* expr = NULL;
				ValaList* _tmp38_;
				gpointer _tmp39_;
				ValaExpressionStatement* _tmp40_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				ValaExpression* _tmp49_;
				ValaExpression* _tmp50_;
				ValaSourceReference* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaMemberAccess* _tmp53_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp54_;
				ValaExpression* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaElementAccess* _tmp58_;
				ValaElementAccess* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaExpression* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaIntegerLiteral* _tmp65_;
				ValaIntegerLiteral* _tmp66_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp67_;
				ValaElementAccess* _tmp68_;
				ValaAssignmentOperator _tmp69_;
				ValaExpression* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaAssignment* _tmp73_;
				ValaAssignment* _tmp74_;
				ValaExpression* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaExpressionStatement* _tmp78_;
				gint _tmp79_;
				_expr_index = _expr_index + 1;
				if (!(_expr_index < _expr_size)) {
					break;
				}
				_tmp38_ = _expr_list;
				_tmp39_ = vala_list_get (_tmp38_, _expr_index);
				expr = (ValaExpression*) _tmp39_;
				_tmp40_ = stmt;
				if (_tmp40_ != NULL) {
					ValaSemanticAnalyzer* _tmp41_;
					ValaSemanticAnalyzer* _tmp42_;
					ValaBlock* _tmp43_;
					ValaExpressionStatement* _tmp44_;
					ValaExpressionStatement* _tmp45_;
					_tmp41_ = vala_code_context_get_analyzer (context);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp42_->insert_block;
					_tmp44_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp43_, (ValaStatement*) _tmp44_);
					_tmp45_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp45_, context);
				}
				_tmp46_ = local;
				_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_assignment_get_right (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_member_access_new_simple (_tmp48_, _tmp52_);
				temp_access = _tmp53_;
				_tmp54_ = temp_access;
				_tmp55_ = expr;
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_element_access_new ((ValaExpression*) _tmp54_, _tmp57_);
				ea = _tmp58_;
				_tmp59_ = ea;
				_tmp60_ = g_strdup_printf ("%i", i);
				_tmp61_ = _tmp60_;
				_tmp62_ = expr;
				_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_integer_literal_new (_tmp61_, _tmp64_);
				_tmp66_ = _tmp65_;
				vala_element_access_append_index (_tmp59_, (ValaExpression*) _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
				_g_free0 (_tmp61_);
				_tmp67_ = expr;
				_tmp68_ = ea;
				_tmp69_ = self->priv->_operator;
				_tmp70_ = expr;
				_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_assignment_new (_tmp67_, (ValaExpression*) _tmp68_, _tmp69_, _tmp72_);
				assign = _tmp73_;
				_tmp74_ = assign;
				_tmp75_ = expr;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_expression_statement_new ((ValaExpression*) _tmp74_, _tmp77_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp78_;
				_tmp79_ = i;
				i = _tmp79_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp80_ = vala_code_context_get_analyzer (context);
		_tmp81_ = _tmp80_;
		_tmp82_ = _tmp81_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp82_, (ValaCodeNode*) self);
		_tmp83_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = stmt;
		_tmp86_ = vala_expression_statement_get_expression (_tmp85_);
		_tmp87_ = _tmp86_;
		vala_code_node_replace_expression (_tmp84_, (ValaExpression*) self, _tmp87_);
		_tmp88_ = stmt;
		_tmp89_ = vala_expression_statement_get_expression (_tmp88_);
		_tmp90_ = _tmp89_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp90_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp91_ = vala_assignment_get_left (self);
	_tmp92_ = _tmp91_;
	vala_expression_set_lvalue (_tmp92_, TRUE);
	_tmp93_ = vala_assignment_get_left (self);
	_tmp94_ = _tmp93_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp94_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	if (VALA_IS_MEMBER_ACCESS (_tmp96_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp97_;
		ValaExpression* _tmp98_;
		ValaMemberAccess* _tmp99_;
		ValaMemberAccess* _tmp100_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		ValaMemberAccess* _tmp103_;
		ValaSymbol* _tmp104_;
		ValaSymbol* _tmp105_;
		ValaMemberAccess* _tmp121_;
		gboolean _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp133_ = FALSE;
		ValaMemberAccess* _tmp134_;
		gboolean _tmp135_;
		gboolean _tmp136_;
		ValaMemberAccess* _tmp140_;
		ValaSymbol* _tmp141_;
		ValaSymbol* _tmp142_;
		_tmp97_ = vala_assignment_get_left (self);
		_tmp98_ = _tmp97_;
		_tmp99_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp99_;
		_tmp100_ = ma;
		vala_assignment_check_constant_assignment (self, _tmp100_);
		_tmp103_ = ma;
		_tmp104_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp103_);
		_tmp105_ = _tmp104_;
		if (!VALA_IS_DYNAMIC_PROPERTY (_tmp105_)) {
			ValaMemberAccess* _tmp106_;
			ValaDataType* _tmp107_;
			ValaDataType* _tmp108_;
			_tmp106_ = ma;
			_tmp107_ = vala_expression_get_value_type ((ValaExpression*) _tmp106_);
			_tmp108_ = _tmp107_;
			_tmp102_ = _tmp108_ == NULL;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			_tmp101_ = TRUE;
		} else {
			gboolean _tmp109_ = FALSE;
			gboolean _tmp110_ = FALSE;
			ValaMemberAccess* _tmp111_;
			ValaExpression* _tmp112_;
			ValaExpression* _tmp113_;
			_tmp111_ = ma;
			_tmp112_ = vala_member_access_get_inner (_tmp111_);
			_tmp113_ = _tmp112_;
			if (_tmp113_ == NULL) {
				ValaMemberAccess* _tmp114_;
				const gchar* _tmp115_;
				const gchar* _tmp116_;
				_tmp114_ = ma;
				_tmp115_ = vala_member_access_get_member_name (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp110_ = g_strcmp0 (_tmp116_, "this") == 0;
			} else {
				_tmp110_ = FALSE;
			}
			if (_tmp110_) {
				ValaSemanticAnalyzer* _tmp117_;
				ValaSemanticAnalyzer* _tmp118_;
				_tmp117_ = vala_code_context_get_analyzer (context);
				_tmp118_ = _tmp117_;
				_tmp109_ = vala_semantic_analyzer_is_in_instance_method (_tmp118_);
			} else {
				_tmp109_ = FALSE;
			}
			_tmp101_ = _tmp109_;
		}
		if (_tmp101_) {
			ValaSourceReference* _tmp119_;
			ValaSourceReference* _tmp120_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp120_ = _tmp119_;
			vala_report_error (_tmp120_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp121_ = ma;
		_tmp122_ = vala_member_access_get_prototype_access (_tmp121_);
		_tmp123_ = _tmp122_;
		if (_tmp123_) {
			ValaSourceReference* _tmp124_;
			ValaSourceReference* _tmp125_;
			ValaMemberAccess* _tmp126_;
			ValaSymbol* _tmp127_;
			ValaSymbol* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp125_ = _tmp124_;
			_tmp126_ = ma;
			_tmp127_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = vala_symbol_get_full_name (_tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp130_);
			_tmp132_ = _tmp131_;
			vala_report_error (_tmp125_, _tmp132_);
			_g_free0 (_tmp132_);
			_g_free0 (_tmp130_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp134_ = ma;
		_tmp135_ = vala_code_node_get_error ((ValaCodeNode*) _tmp134_);
		_tmp136_ = _tmp135_;
		if (_tmp136_) {
			_tmp133_ = TRUE;
		} else {
			ValaMemberAccess* _tmp137_;
			ValaSymbol* _tmp138_;
			ValaSymbol* _tmp139_;
			_tmp137_ = ma;
			_tmp138_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp137_);
			_tmp139_ = _tmp138_;
			_tmp133_ = _tmp139_ == NULL;
		}
		if (_tmp133_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp140_ = ma;
		_tmp141_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp140_);
		_tmp142_ = _tmp141_;
		if (VALA_IS_DYNAMIC_PROPERTY (_tmp142_)) {
		} else {
			ValaExpression* _tmp143_;
			ValaExpression* _tmp144_;
			ValaMemberAccess* _tmp145_;
			ValaDataType* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaExpression* _tmp150_;
			ValaExpression* _tmp151_;
			ValaMemberAccess* _tmp152_;
			ValaDataType* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			ValaDataType* _tmp156_;
			_tmp143_ = vala_assignment_get_right (self);
			_tmp144_ = _tmp143_;
			_tmp145_ = ma;
			_tmp146_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_data_type_copy (_tmp147_);
			_tmp149_ = _tmp148_;
			vala_expression_set_formal_target_type (_tmp144_, _tmp149_);
			_vala_code_node_unref0 (_tmp149_);
			_tmp150_ = vala_assignment_get_right (self);
			_tmp151_ = _tmp150_;
			_tmp152_ = ma;
			_tmp153_ = vala_expression_get_value_type ((ValaExpression*) _tmp152_);
			_tmp154_ = _tmp153_;
			_tmp155_ = vala_data_type_copy (_tmp154_);
			_tmp156_ = _tmp155_;
			vala_expression_set_target_type (_tmp151_, _tmp156_);
			_vala_code_node_unref0 (_tmp156_);
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp157_;
		ValaExpression* _tmp158_;
		_tmp157_ = vala_assignment_get_left (self);
		_tmp158_ = _tmp157_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp158_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp159_;
			ValaExpression* _tmp160_;
			ValaElementAccess* _tmp161_;
			ValaElementAccess* _tmp162_;
			ValaExpression* _tmp163_;
			ValaExpression* _tmp164_;
			ValaElementAccess* _tmp165_;
			ValaExpression* _tmp166_;
			ValaExpression* _tmp167_;
			ValaDataType* _tmp168_;
			ValaDataType* _tmp169_;
			ValaTypeSymbol* _tmp170_;
			ValaTypeSymbol* _tmp171_;
			ValaSemanticAnalyzer* _tmp172_;
			ValaSemanticAnalyzer* _tmp173_;
			ValaDataType* _tmp174_;
			ValaTypeSymbol* _tmp175_;
			ValaTypeSymbol* _tmp176_;
			_tmp159_ = vala_assignment_get_left (self);
			_tmp160_ = _tmp159_;
			_tmp161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp161_;
			_tmp162_ = ea;
			_tmp163_ = vala_element_access_get_container (_tmp162_);
			_tmp164_ = _tmp163_;
			vala_assignment_check_constant_assignment (self, VALA_IS_MEMBER_ACCESS (_tmp164_) ? ((ValaMemberAccess*) _tmp164_) : NULL);
			_tmp165_ = ea;
			_tmp166_ = vala_element_access_get_container (_tmp165_);
			_tmp167_ = _tmp166_;
			_tmp168_ = vala_expression_get_value_type (_tmp167_);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_data_type_get_data_type (_tmp169_);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_code_context_get_analyzer (context);
			_tmp173_ = _tmp172_;
			_tmp174_ = _tmp173_->string_type;
			_tmp175_ = vala_data_type_get_data_type (_tmp174_);
			_tmp176_ = _tmp175_;
			if (_tmp171_ == _tmp176_) {
				ValaElementAccess* _tmp177_;
				ValaSourceReference* _tmp178_;
				ValaSourceReference* _tmp179_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp177_ = ea;
				_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp177_);
				_tmp179_ = _tmp178_;
				vala_report_error (_tmp179_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				ValaElementAccess* _tmp180_;
				ValaExpression* _tmp181_;
				ValaExpression* _tmp182_;
				ValaDataType* _tmp183_;
				ValaDataType* _tmp184_;
				ValaSymbol* _tmp185_;
				ValaSymbol* _tmp186_;
				gboolean _tmp187_;
				_tmp180_ = ea;
				_tmp181_ = vala_element_access_get_container (_tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_expression_get_value_type (_tmp182_);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_data_type_get_member (_tmp184_, "set");
				_tmp186_ = _tmp185_;
				_tmp187_ = VALA_IS_METHOD (_tmp186_);
				_vala_code_node_unref0 (_tmp186_);
				if (_tmp187_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp188_;
					ValaExpression* _tmp189_;
					ValaExpression* _tmp190_;
					ValaSourceReference* _tmp191_;
					ValaSourceReference* _tmp192_;
					ValaMemberAccess* _tmp193_;
					ValaMemberAccess* _tmp194_;
					ValaSourceReference* _tmp195_;
					ValaSourceReference* _tmp196_;
					ValaMethodCall* _tmp197_;
					ValaMethodCall* _tmp198_;
					ValaMethodCall* _tmp208_;
					ValaExpression* _tmp209_;
					ValaExpression* _tmp210_;
					ValaCodeNode* _tmp211_;
					ValaCodeNode* _tmp212_;
					ValaMethodCall* _tmp213_;
					ValaMethodCall* _tmp214_;
					_tmp188_ = ea;
					_tmp189_ = vala_element_access_get_container (_tmp188_);
					_tmp190_ = _tmp189_;
					_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp192_ = _tmp191_;
					_tmp193_ = vala_member_access_new (_tmp190_, "set", _tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp196_ = _tmp195_;
					_tmp197_ = vala_method_call_new ((ValaExpression*) _tmp194_, _tmp196_);
					_tmp198_ = _tmp197_;
					_vala_code_node_unref0 (_tmp194_);
					set_call = _tmp198_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp199_;
						ValaList* _tmp200_;
						gint _e_size = 0;
						ValaList* _tmp201_;
						gint _tmp202_;
						gint _tmp203_;
						gint _e_index = 0;
						_tmp199_ = ea;
						_tmp200_ = vala_element_access_get_indices (_tmp199_);
						_e_list = _tmp200_;
						_tmp201_ = _e_list;
						_tmp202_ = vala_collection_get_size ((ValaCollection*) _tmp201_);
						_tmp203_ = _tmp202_;
						_e_size = _tmp203_;
						_e_index = -1;
						while (TRUE) {
							ValaExpression* e = NULL;
							ValaList* _tmp204_;
							gpointer _tmp205_;
							ValaMethodCall* _tmp206_;
							ValaExpression* _tmp207_;
							_e_index = _e_index + 1;
							if (!(_e_index < _e_size)) {
								break;
							}
							_tmp204_ = _e_list;
							_tmp205_ = vala_list_get (_tmp204_, _e_index);
							e = (ValaExpression*) _tmp205_;
							_tmp206_ = set_call;
							_tmp207_ = e;
							vala_method_call_add_argument (_tmp206_, _tmp207_);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					_tmp208_ = set_call;
					_tmp209_ = vala_assignment_get_right (self);
					_tmp210_ = _tmp209_;
					vala_method_call_add_argument (_tmp208_, _tmp210_);
					_tmp211_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp212_ = _tmp211_;
					_tmp213_ = set_call;
					vala_code_node_replace_expression (_tmp212_, (ValaExpression*) self, (ValaExpression*) _tmp213_);
					_tmp214_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp214_, context);
					_vala_code_node_unref0 (set_call);
					_vala_code_node_unref0 (ea);
					return result;
				} else {
					ValaExpression* _tmp215_;
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaExpression* _tmp218_;
					ValaDataType* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					_tmp215_ = vala_assignment_get_right (self);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_assignment_get_left (self);
					_tmp218_ = _tmp217_;
					_tmp219_ = vala_expression_get_value_type (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_data_type_copy (_tmp220_);
					_tmp222_ = _tmp221_;
					vala_expression_set_target_type (_tmp216_, _tmp222_);
					_vala_code_node_unref0 (_tmp222_);
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp223_;
			ValaExpression* _tmp224_;
			_tmp223_ = vala_assignment_get_left (self);
			_tmp224_ = _tmp223_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp224_)) {
				ValaExpression* _tmp225_;
				ValaExpression* _tmp226_;
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				ValaDataType* _tmp229_;
				ValaDataType* _tmp230_;
				ValaDataType* _tmp231_;
				ValaDataType* _tmp232_;
				_tmp225_ = vala_assignment_get_right (self);
				_tmp226_ = _tmp225_;
				_tmp227_ = vala_assignment_get_left (self);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_expression_get_value_type (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_data_type_copy (_tmp230_);
				_tmp232_ = _tmp231_;
				vala_expression_set_target_type (_tmp226_, _tmp232_);
				_vala_code_node_unref0 (_tmp232_);
			} else {
				ValaExpression* _tmp233_;
				ValaExpression* _tmp234_;
				_tmp233_ = vala_assignment_get_left (self);
				_tmp234_ = _tmp233_;
				if (VALA_IS_LITERAL (_tmp234_)) {
					ValaSourceReference* _tmp235_;
					ValaSourceReference* _tmp236_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp236_ = _tmp235_;
					vala_report_error (_tmp236_, "Literals are immutable");
					result = FALSE;
					return result;
				} else {
					ValaSourceReference* _tmp237_;
					ValaSourceReference* _tmp238_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp238_ = _tmp237_;
					vala_report_error (_tmp238_, "unsupported lvalue in assignment");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp239_ = vala_assignment_get_right (self);
	_tmp240_ = _tmp239_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp240_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp241_ = vala_assignment_get_left (self);
	_tmp242_ = _tmp241_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp242_) ? ((ValaMemberAccess*) _tmp242_) : NULL;
	_tmp245_ = self->priv->_operator;
	if (_tmp245_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaMemberAccess* _tmp246_;
		_tmp246_ = ma;
		_tmp244_ = _tmp246_ != NULL;
	} else {
		_tmp244_ = FALSE;
	}
	if (_tmp244_) {
		gboolean _tmp247_ = FALSE;
		ValaExpression* _tmp248_;
		ValaExpression* _tmp249_;
		ValaDataType* _tmp250_;
		ValaDataType* _tmp251_;
		_tmp248_ = vala_assignment_get_left (self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_expression_get_value_type (_tmp249_);
		_tmp251_ = _tmp250_;
		if (vala_data_type_is_non_null_simple_type (_tmp251_)) {
			ValaMemberAccess* _tmp252_;
			ValaSymbol* _tmp253_;
			ValaSymbol* _tmp254_;
			_tmp252_ = ma;
			_tmp253_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp252_);
			_tmp254_ = _tmp253_;
			_tmp247_ = VALA_IS_LOCAL_VARIABLE (_tmp254_);
		} else {
			_tmp247_ = FALSE;
		}
		_tmp243_ = !_tmp247_;
	} else {
		_tmp243_ = FALSE;
	}
	if (_tmp243_) {
		ValaMemberAccess* old_value = NULL;
		ValaMemberAccess* _tmp255_;
		ValaExpression* _tmp256_;
		ValaExpression* _tmp257_;
		ValaMemberAccess* _tmp258_;
		const gchar* _tmp259_;
		const gchar* _tmp260_;
		ValaMemberAccess* _tmp261_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp262_;
		ValaBinaryExpression* bin = NULL;
		ValaBinaryOperator _tmp265_;
		ValaMemberAccess* _tmp266_;
		ValaExpression* _tmp267_;
		ValaExpression* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaSourceReference* _tmp270_;
		ValaBinaryExpression* _tmp271_;
		ValaBinaryExpression* _tmp272_;
		ValaExpression* _tmp273_;
		ValaExpression* _tmp274_;
		ValaDataType* _tmp275_;
		ValaDataType* _tmp276_;
		ValaExpression* _tmp277_;
		ValaExpression* _tmp278_;
		ValaExpression* _tmp279_;
		ValaExpression* _tmp280_;
		ValaDataType* _tmp281_;
		ValaDataType* _tmp282_;
		ValaDataType* _tmp283_;
		ValaDataType* _tmp284_;
		ValaExpression* _tmp285_;
		ValaExpression* _tmp286_;
		ValaDataType* _tmp287_;
		ValaDataType* _tmp288_;
		ValaBinaryExpression* _tmp289_;
		ValaExpression* _tmp290_;
		ValaExpression* _tmp291_;
		_tmp255_ = ma;
		_tmp256_ = vala_member_access_get_inner (_tmp255_);
		_tmp257_ = _tmp256_;
		_tmp258_ = ma;
		_tmp259_ = vala_member_access_get_member_name (_tmp258_);
		_tmp260_ = _tmp259_;
		_tmp261_ = vala_member_access_new (_tmp257_, _tmp260_, NULL);
		old_value = _tmp261_;
		_tmp262_ = self->priv->_operator;
		switch (_tmp262_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				ValaSourceReference* _tmp263_;
				ValaSourceReference* _tmp264_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp264_ = _tmp263_;
				vala_report_error (_tmp264_, "internal error: unsupported assignment operator");
				result = FALSE;
				_vala_code_node_unref0 (old_value);
				return result;
			}
		}
		_tmp265_ = bop;
		_tmp266_ = old_value;
		_tmp267_ = vala_assignment_get_right (self);
		_tmp268_ = _tmp267_;
		_tmp269_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp270_ = _tmp269_;
		_tmp271_ = vala_binary_expression_new (_tmp265_, (ValaExpression*) _tmp266_, _tmp268_, _tmp270_);
		bin = _tmp271_;
		_tmp272_ = bin;
		_tmp273_ = vala_assignment_get_right (self);
		_tmp274_ = _tmp273_;
		_tmp275_ = vala_expression_get_target_type (_tmp274_);
		_tmp276_ = _tmp275_;
		vala_expression_set_target_type ((ValaExpression*) _tmp272_, _tmp276_);
		_tmp277_ = vala_assignment_get_right (self);
		_tmp278_ = _tmp277_;
		_tmp279_ = vala_assignment_get_right (self);
		_tmp280_ = _tmp279_;
		_tmp281_ = vala_expression_get_target_type (_tmp280_);
		_tmp282_ = _tmp281_;
		_tmp283_ = vala_data_type_copy (_tmp282_);
		_tmp284_ = _tmp283_;
		vala_expression_set_target_type (_tmp278_, _tmp284_);
		_vala_code_node_unref0 (_tmp284_);
		_tmp285_ = vala_assignment_get_right (self);
		_tmp286_ = _tmp285_;
		_tmp287_ = vala_expression_get_target_type (_tmp286_);
		_tmp288_ = _tmp287_;
		vala_data_type_set_value_owned (_tmp288_, FALSE);
		_tmp289_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp289_);
		_tmp290_ = vala_assignment_get_right (self);
		_tmp291_ = _tmp290_;
		vala_code_node_check ((ValaCodeNode*) _tmp291_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp292_ = ma;
	if (_tmp292_ != NULL) {
		ValaMemberAccess* _tmp293_;
		ValaSymbol* _tmp294_;
		ValaSymbol* _tmp295_;
		gboolean _tmp482_ = FALSE;
		ValaExpression* _tmp483_;
		ValaExpression* _tmp484_;
		ValaDataType* _tmp485_;
		ValaDataType* _tmp486_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp541_;
		ValaExpression* _tmp542_;
		ValaMemberAccess* _tmp543_;
		gboolean _tmp544_ = FALSE;
		ValaMemberAccess* _tmp545_;
		_tmp293_ = ma;
		_tmp294_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp293_);
		_tmp295_ = _tmp294_;
		if (VALA_IS_PROPERTY (_tmp295_)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp296_;
			ValaSymbol* _tmp297_;
			ValaSymbol* _tmp298_;
			ValaProperty* _tmp299_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp300_;
			ValaDynamicProperty* _tmp301_;
			ValaDynamicProperty* _tmp302_;
			gboolean _tmp317_ = FALSE;
			ValaProperty* _tmp318_;
			ValaPropertyAccessor* _tmp319_;
			ValaPropertyAccessor* _tmp320_;
			_tmp296_ = ma;
			_tmp297_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp296_);
			_tmp298_ = _tmp297_;
			_tmp299_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp298_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp299_;
			_tmp300_ = prop;
			_tmp301_ = _vala_code_node_ref0 (VALA_IS_DYNAMIC_PROPERTY (_tmp300_) ? ((ValaDynamicProperty*) _tmp300_) : NULL);
			dynamic_prop = _tmp301_;
			_tmp302_ = dynamic_prop;
			if (_tmp302_ != NULL) {
				ValaDynamicProperty* _tmp303_;
				ValaExpression* _tmp304_;
				ValaExpression* _tmp305_;
				ValaDataType* _tmp306_;
				ValaDataType* _tmp307_;
				ValaDataType* _tmp308_;
				ValaDataType* _tmp309_;
				ValaExpression* _tmp310_;
				ValaExpression* _tmp311_;
				ValaDynamicProperty* _tmp312_;
				ValaDataType* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				ValaDataType* _tmp316_;
				_tmp303_ = dynamic_prop;
				_tmp304_ = vala_assignment_get_right (self);
				_tmp305_ = _tmp304_;
				_tmp306_ = vala_expression_get_value_type (_tmp305_);
				_tmp307_ = _tmp306_;
				_tmp308_ = vala_data_type_copy (_tmp307_);
				_tmp309_ = _tmp308_;
				vala_property_set_property_type ((ValaProperty*) _tmp303_, _tmp309_);
				_vala_code_node_unref0 (_tmp309_);
				_tmp310_ = vala_assignment_get_left (self);
				_tmp311_ = _tmp310_;
				_tmp312_ = dynamic_prop;
				_tmp313_ = vala_property_get_property_type ((ValaProperty*) _tmp312_);
				_tmp314_ = _tmp313_;
				_tmp315_ = vala_data_type_copy (_tmp314_);
				_tmp316_ = _tmp315_;
				vala_expression_set_value_type (_tmp311_, _tmp316_);
				_vala_code_node_unref0 (_tmp316_);
			}
			_tmp318_ = prop;
			_tmp319_ = vala_property_get_set_accessor (_tmp318_);
			_tmp320_ = _tmp319_;
			if (_tmp320_ == NULL) {
				_tmp317_ = TRUE;
			} else {
				gboolean _tmp321_ = FALSE;
				ValaProperty* _tmp322_;
				ValaPropertyAccessor* _tmp323_;
				ValaPropertyAccessor* _tmp324_;
				gboolean _tmp325_;
				gboolean _tmp326_;
				_tmp322_ = prop;
				_tmp323_ = vala_property_get_set_accessor (_tmp322_);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_property_accessor_get_writable (_tmp324_);
				_tmp326_ = _tmp325_;
				if (!_tmp326_) {
					gboolean _tmp327_ = FALSE;
					ValaSemanticAnalyzer* _tmp328_;
					ValaSemanticAnalyzer* _tmp329_;
					ValaMethod* _tmp330_;
					ValaMethod* _tmp331_;
					gboolean _tmp332_;
					_tmp328_ = vala_code_context_get_analyzer (context);
					_tmp329_ = _tmp328_;
					_tmp330_ = vala_semantic_analyzer_find_current_method (_tmp329_);
					_tmp331_ = _tmp330_;
					_tmp332_ = VALA_IS_CREATION_METHOD (_tmp331_);
					_vala_code_node_unref0 (_tmp331_);
					if (_tmp332_) {
						_tmp327_ = TRUE;
					} else {
						ValaSemanticAnalyzer* _tmp333_;
						ValaSemanticAnalyzer* _tmp334_;
						_tmp333_ = vala_code_context_get_analyzer (context);
						_tmp334_ = _tmp333_;
						_tmp327_ = vala_semantic_analyzer_is_in_constructor (_tmp334_);
					}
					_tmp321_ = !_tmp327_;
				} else {
					_tmp321_ = FALSE;
				}
				_tmp317_ = _tmp321_;
			}
			if (_tmp317_) {
				ValaMemberAccess* _tmp335_;
				ValaMemberAccess* _tmp336_;
				ValaSourceReference* _tmp337_;
				ValaSourceReference* _tmp338_;
				ValaProperty* _tmp339_;
				gchar* _tmp340_;
				gchar* _tmp341_;
				gchar* _tmp342_;
				gchar* _tmp343_;
				_tmp335_ = ma;
				vala_code_node_set_error ((ValaCodeNode*) _tmp335_, TRUE);
				_tmp336_ = ma;
				_tmp337_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp336_);
				_tmp338_ = _tmp337_;
				_tmp339_ = prop;
				_tmp340_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp339_);
				_tmp341_ = _tmp340_;
				_tmp342_ = g_strdup_printf ("Property `%s' is read-only", _tmp341_);
				_tmp343_ = _tmp342_;
				vala_report_error (_tmp338_, _tmp343_);
				_g_free0 (_tmp343_);
				_g_free0 (_tmp341_);
				result = FALSE;
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
				return result;
			} else {
				gboolean _tmp344_ = FALSE;
				gboolean _tmp345_ = FALSE;
				gboolean _tmp346_;
				gboolean _tmp347_;
				_tmp346_ = vala_code_context_get_deprecated (context);
				_tmp347_ = _tmp346_;
				if (!_tmp347_) {
					ValaProperty* _tmp348_;
					ValaPropertyAccessor* _tmp349_;
					ValaPropertyAccessor* _tmp350_;
					gboolean _tmp351_;
					gboolean _tmp352_;
					_tmp348_ = prop;
					_tmp349_ = vala_property_get_set_accessor (_tmp348_);
					_tmp350_ = _tmp349_;
					_tmp351_ = vala_property_accessor_get_writable (_tmp350_);
					_tmp352_ = _tmp351_;
					_tmp345_ = !_tmp352_;
				} else {
					_tmp345_ = FALSE;
				}
				if (_tmp345_) {
					ValaSemanticAnalyzer* _tmp353_;
					ValaSemanticAnalyzer* _tmp354_;
					ValaMethod* _tmp355_;
					ValaMethod* _tmp356_;
					_tmp353_ = vala_code_context_get_analyzer (context);
					_tmp354_ = _tmp353_;
					_tmp355_ = vala_semantic_analyzer_find_current_method (_tmp354_);
					_tmp356_ = _tmp355_;
					_tmp344_ = VALA_IS_CREATION_METHOD (_tmp356_);
					_vala_code_node_unref0 (_tmp356_);
				} else {
					_tmp344_ = FALSE;
				}
				if (_tmp344_) {
					ValaMemberAccess* _tmp357_;
					ValaExpression* _tmp358_;
					ValaExpression* _tmp359_;
					ValaSymbol* _tmp360_;
					ValaSymbol* _tmp361_;
					ValaSemanticAnalyzer* _tmp362_;
					ValaSemanticAnalyzer* _tmp363_;
					ValaMethod* _tmp364_;
					ValaMethod* _tmp365_;
					ValaParameter* _tmp366_;
					ValaParameter* _tmp367_;
					gboolean _tmp368_;
					_tmp357_ = ma;
					_tmp358_ = vala_member_access_get_inner (_tmp357_);
					_tmp359_ = _tmp358_;
					_tmp360_ = vala_expression_get_symbol_reference (_tmp359_);
					_tmp361_ = _tmp360_;
					_tmp362_ = vala_code_context_get_analyzer (context);
					_tmp363_ = _tmp362_;
					_tmp364_ = vala_semantic_analyzer_find_current_method (_tmp363_);
					_tmp365_ = _tmp364_;
					_tmp366_ = vala_method_get_this_parameter (_tmp365_);
					_tmp367_ = _tmp366_;
					_tmp368_ = _tmp361_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp367_, VALA_TYPE_SYMBOL, ValaSymbol);
					_vala_code_node_unref0 (_tmp365_);
					if (_tmp368_) {
						ValaMemberAccess* _tmp369_;
						ValaSourceReference* _tmp370_;
						ValaSourceReference* _tmp371_;
						ValaProperty* _tmp372_;
						gchar* _tmp373_;
						gchar* _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp369_ = ma;
						_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp369_);
						_tmp371_ = _tmp370_;
						_tmp372_ = prop;
						_tmp373_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = g_strdup_printf ("Property `%s' is read-only", _tmp374_);
						_tmp376_ = _tmp375_;
						vala_report_error (_tmp371_, _tmp376_);
						_g_free0 (_tmp376_);
						_g_free0 (_tmp374_);
						result = FALSE;
						_vala_code_node_unref0 (dynamic_prop);
						_vala_code_node_unref0 (prop);
						return result;
					} else {
						ValaMemberAccess* _tmp377_;
						ValaSourceReference* _tmp378_;
						ValaSourceReference* _tmp379_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp377_ = ma;
						_tmp378_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp377_);
						_tmp379_ = _tmp378_;
						vala_report_error (_tmp379_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
						result = FALSE;
						_vala_code_node_unref0 (dynamic_prop);
						_vala_code_node_unref0 (prop);
						return result;
					}
				}
			}
			_vala_code_node_unref0 (dynamic_prop);
			_vala_code_node_unref0 (prop);
		} else {
			gboolean _tmp380_ = FALSE;
			ValaMemberAccess* _tmp381_;
			ValaSymbol* _tmp382_;
			ValaSymbol* _tmp383_;
			_tmp381_ = ma;
			_tmp382_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp381_);
			_tmp383_ = _tmp382_;
			if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp383_)) {
				ValaMemberAccess* _tmp384_;
				ValaExpression* _tmp385_;
				ValaExpression* _tmp386_;
				ValaDataType* _tmp387_;
				ValaDataType* _tmp388_;
				gboolean _tmp389_;
				gboolean _tmp390_;
				_tmp384_ = ma;
				_tmp385_ = vala_member_access_get_inner (_tmp384_);
				_tmp386_ = _tmp385_;
				_tmp387_ = vala_expression_get_value_type (_tmp386_);
				_tmp388_ = _tmp387_;
				_tmp389_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp388_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp390_ = _tmp389_;
				_tmp380_ = _tmp390_;
			} else {
				_tmp380_ = FALSE;
			}
			if (_tmp380_) {
				ValaSourceReference* _tmp391_;
				ValaSourceReference* _tmp392_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp391_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp392_ = _tmp391_;
				vala_report_error (_tmp392_, "`length' field of fixed length arrays is read-only");
				result = FALSE;
				return result;
			} else {
				gboolean _tmp393_ = FALSE;
				ValaMemberAccess* _tmp394_;
				ValaSymbol* _tmp395_;
				ValaSymbol* _tmp396_;
				_tmp394_ = ma;
				_tmp395_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp394_);
				_tmp396_ = _tmp395_;
				if (VALA_IS_VARIABLE (_tmp396_)) {
					ValaExpression* _tmp397_;
					ValaExpression* _tmp398_;
					ValaDataType* _tmp399_;
					ValaDataType* _tmp400_;
					_tmp397_ = vala_assignment_get_right (self);
					_tmp398_ = _tmp397_;
					_tmp399_ = vala_expression_get_value_type (_tmp398_);
					_tmp400_ = _tmp399_;
					_tmp393_ = _tmp400_ == NULL;
				} else {
					_tmp393_ = FALSE;
				}
				if (_tmp393_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp401_;
					ValaSymbol* _tmp402_;
					ValaSymbol* _tmp403_;
					ValaVariable* _tmp404_;
					gboolean _tmp405_ = FALSE;
					ValaExpression* _tmp406_;
					ValaExpression* _tmp407_;
					ValaSymbol* _tmp408_;
					ValaSymbol* _tmp409_;
					_tmp401_ = ma;
					_tmp402_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp401_);
					_tmp403_ = _tmp402_;
					_tmp404_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp403_, VALA_TYPE_VARIABLE, ValaVariable));
					variable = _tmp404_;
					_tmp406_ = vala_assignment_get_right (self);
					_tmp407_ = _tmp406_;
					_tmp408_ = vala_expression_get_symbol_reference (_tmp407_);
					_tmp409_ = _tmp408_;
					if (VALA_IS_METHOD (_tmp409_)) {
						ValaVariable* _tmp410_;
						ValaDataType* _tmp411_;
						ValaDataType* _tmp412_;
						_tmp410_ = variable;
						_tmp411_ = vala_variable_get_variable_type (_tmp410_);
						_tmp412_ = _tmp411_;
						_tmp405_ = VALA_IS_DELEGATE_TYPE (_tmp412_);
					} else {
						_tmp405_ = FALSE;
					}
					if (_tmp405_) {
						ValaMethod* m = NULL;
						ValaExpression* _tmp413_;
						ValaExpression* _tmp414_;
						ValaSymbol* _tmp415_;
						ValaSymbol* _tmp416_;
						ValaMethod* _tmp417_;
						ValaDelegateType* dt = NULL;
						ValaVariable* _tmp418_;
						ValaDataType* _tmp419_;
						ValaDataType* _tmp420_;
						ValaDelegateType* _tmp421_;
						ValaDelegate* cb = NULL;
						ValaDelegateType* _tmp422_;
						ValaDelegate* _tmp423_;
						ValaDelegate* _tmp424_;
						ValaDelegate* _tmp425_;
						ValaDelegate* _tmp426_;
						ValaMethod* _tmp427_;
						ValaDelegateType* _tmp428_;
						ValaExpression* _tmp439_;
						ValaExpression* _tmp440_;
						ValaVariable* _tmp441_;
						ValaDataType* _tmp442_;
						ValaDataType* _tmp443_;
						ValaDataType* _tmp444_;
						ValaDataType* _tmp445_;
						_tmp413_ = vala_assignment_get_right (self);
						_tmp414_ = _tmp413_;
						_tmp415_ = vala_expression_get_symbol_reference (_tmp414_);
						_tmp416_ = _tmp415_;
						_tmp417_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp416_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp417_;
						_tmp418_ = variable;
						_tmp419_ = vala_variable_get_variable_type (_tmp418_);
						_tmp420_ = _tmp419_;
						_tmp421_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp420_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						dt = _tmp421_;
						_tmp422_ = dt;
						_tmp423_ = vala_delegate_type_get_delegate_symbol (_tmp422_);
						_tmp424_ = _tmp423_;
						_tmp425_ = _vala_code_node_ref0 (_tmp424_);
						cb = _tmp425_;
						_tmp426_ = cb;
						_tmp427_ = m;
						_tmp428_ = dt;
						if (!vala_delegate_matches_method (_tmp426_, _tmp427_, (ValaDataType*) _tmp428_)) {
							ValaSourceReference* _tmp429_;
							ValaSourceReference* _tmp430_;
							ValaMethod* _tmp431_;
							gchar* _tmp432_;
							gchar* _tmp433_;
							ValaDelegate* _tmp434_;
							gchar* _tmp435_;
							gchar* _tmp436_;
							gchar* _tmp437_;
							gchar* _tmp438_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp429_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp430_ = _tmp429_;
							_tmp431_ = m;
							_tmp432_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp431_);
							_tmp433_ = _tmp432_;
							_tmp434_ = cb;
							_tmp435_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp434_);
							_tmp436_ = _tmp435_;
							_tmp437_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp433_, _tmp436_);
							_tmp438_ = _tmp437_;
							vala_report_error (_tmp430_, _tmp438_);
							_g_free0 (_tmp438_);
							_g_free0 (_tmp436_);
							_g_free0 (_tmp433_);
							result = FALSE;
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (dt);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (variable);
							return result;
						}
						_tmp439_ = vala_assignment_get_right (self);
						_tmp440_ = _tmp439_;
						_tmp441_ = variable;
						_tmp442_ = vala_variable_get_variable_type (_tmp441_);
						_tmp443_ = _tmp442_;
						_tmp444_ = vala_data_type_copy (_tmp443_);
						_tmp445_ = _tmp444_;
						vala_expression_set_value_type (_tmp440_, _tmp445_);
						_vala_code_node_unref0 (_tmp445_);
						_vala_code_node_unref0 (cb);
						_vala_code_node_unref0 (dt);
						_vala_code_node_unref0 (m);
					} else {
						ValaSourceReference* _tmp446_;
						ValaSourceReference* _tmp447_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp446_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp447_ = _tmp446_;
						vala_report_error (_tmp447_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						_vala_code_node_unref0 (variable);
						return result;
					}
					_vala_code_node_unref0 (variable);
				} else {
					ValaMemberAccess* _tmp448_;
					ValaSymbol* _tmp449_;
					ValaSymbol* _tmp450_;
					_tmp448_ = ma;
					_tmp449_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp448_);
					_tmp450_ = _tmp449_;
					if (VALA_IS_VARIABLE (_tmp450_)) {
						ValaVariable* variable = NULL;
						ValaMemberAccess* _tmp451_;
						ValaSymbol* _tmp452_;
						ValaSymbol* _tmp453_;
						ValaArrayType* variable_array_type = NULL;
						ValaVariable* _tmp454_;
						ValaDataType* _tmp455_;
						ValaDataType* _tmp456_;
						gboolean _tmp457_ = FALSE;
						gboolean _tmp458_ = FALSE;
						gboolean _tmp459_ = FALSE;
						ValaArrayType* _tmp460_;
						_tmp451_ = ma;
						_tmp452_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp451_);
						_tmp453_ = _tmp452_;
						variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp453_, VALA_TYPE_VARIABLE, ValaVariable);
						_tmp454_ = variable;
						_tmp455_ = vala_variable_get_variable_type (_tmp454_);
						_tmp456_ = _tmp455_;
						variable_array_type = VALA_IS_ARRAY_TYPE (_tmp456_) ? ((ValaArrayType*) _tmp456_) : NULL;
						_tmp460_ = variable_array_type;
						if (_tmp460_ != NULL) {
							ValaArrayType* _tmp461_;
							gboolean _tmp462_;
							gboolean _tmp463_;
							_tmp461_ = variable_array_type;
							_tmp462_ = vala_array_type_get_inline_allocated (_tmp461_);
							_tmp463_ = _tmp462_;
							_tmp459_ = _tmp463_;
						} else {
							_tmp459_ = FALSE;
						}
						if (_tmp459_) {
							ValaExpression* _tmp464_;
							ValaExpression* _tmp465_;
							_tmp464_ = vala_assignment_get_right (self);
							_tmp465_ = _tmp464_;
							_tmp458_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp465_);
						} else {
							_tmp458_ = FALSE;
						}
						if (_tmp458_) {
							ValaExpression* _tmp466_;
							ValaExpression* _tmp467_;
							ValaInitializerList* _tmp468_;
							ValaInitializerList* _tmp469_;
							_tmp466_ = vala_assignment_get_right (self);
							_tmp467_ = _tmp466_;
							_tmp468_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp467_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
							_tmp469_ = _tmp468_;
							_tmp457_ = _tmp469_ == NULL;
						} else {
							_tmp457_ = FALSE;
						}
						if (_tmp457_) {
							ValaSourceReference* _tmp470_;
							ValaSourceReference* _tmp471_;
							ValaCodeNode* _tmp472_;
							ValaCodeNode* _tmp473_;
							ValaCodeNode* _tmp474_;
							ValaCodeNode* _tmp475_;
							ValaCodeNode* _tmp476_;
							ValaCodeNode* _tmp477_;
							ValaSourceReference* _tmp478_;
							ValaSourceReference* _tmp479_;
							ValaEmptyStatement* _tmp480_;
							ValaEmptyStatement* _tmp481_;
							_tmp470_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp471_ = _tmp470_;
							vala_report_warning (_tmp471_, "Inline allocated arrays don't require an explicit instantiation");
							_tmp472_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp473_ = _tmp472_;
							_tmp474_ = vala_code_node_get_parent_node (_tmp473_);
							_tmp475_ = _tmp474_;
							_tmp476_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp477_ = _tmp476_;
							_tmp478_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp479_ = _tmp478_;
							_tmp480_ = vala_empty_statement_new (_tmp479_);
							_tmp481_ = _tmp480_;
							vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp475_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp477_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp481_);
							_vala_code_node_unref0 (_tmp481_);
							result = TRUE;
							return result;
						}
					}
				}
			}
		}
		_tmp483_ = vala_assignment_get_left (self);
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_expression_get_value_type (_tmp484_);
		_tmp486_ = _tmp485_;
		if (_tmp486_ != NULL) {
			ValaExpression* _tmp487_;
			ValaExpression* _tmp488_;
			ValaDataType* _tmp489_;
			ValaDataType* _tmp490_;
			_tmp487_ = vala_assignment_get_right (self);
			_tmp488_ = _tmp487_;
			_tmp489_ = vala_expression_get_value_type (_tmp488_);
			_tmp490_ = _tmp489_;
			_tmp482_ = _tmp490_ != NULL;
		} else {
			_tmp482_ = FALSE;
		}
		if (_tmp482_) {
			ValaExpression* _tmp491_;
			ValaExpression* _tmp492_;
			ValaDataType* _tmp493_;
			ValaDataType* _tmp494_;
			ValaExpression* _tmp495_;
			ValaExpression* _tmp496_;
			ValaDataType* _tmp497_;
			ValaDataType* _tmp498_;
			ValaMemberAccess* _tmp515_;
			ValaSymbol* _tmp516_;
			ValaSymbol* _tmp517_;
			_tmp491_ = vala_assignment_get_right (self);
			_tmp492_ = _tmp491_;
			_tmp493_ = vala_expression_get_value_type (_tmp492_);
			_tmp494_ = _tmp493_;
			_tmp495_ = vala_assignment_get_left (self);
			_tmp496_ = _tmp495_;
			_tmp497_ = vala_expression_get_value_type (_tmp496_);
			_tmp498_ = _tmp497_;
			if (!vala_data_type_compatible (_tmp494_, _tmp498_)) {
				ValaSourceReference* _tmp499_;
				ValaSourceReference* _tmp500_;
				ValaExpression* _tmp501_;
				ValaExpression* _tmp502_;
				ValaDataType* _tmp503_;
				ValaDataType* _tmp504_;
				gchar* _tmp505_;
				gchar* _tmp506_;
				ValaExpression* _tmp507_;
				ValaExpression* _tmp508_;
				ValaDataType* _tmp509_;
				ValaDataType* _tmp510_;
				gchar* _tmp511_;
				gchar* _tmp512_;
				gchar* _tmp513_;
				gchar* _tmp514_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp499_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp500_ = _tmp499_;
				_tmp501_ = vala_assignment_get_right (self);
				_tmp502_ = _tmp501_;
				_tmp503_ = vala_expression_get_value_type (_tmp502_);
				_tmp504_ = _tmp503_;
				_tmp505_ = vala_code_node_to_string ((ValaCodeNode*) _tmp504_);
				_tmp506_ = _tmp505_;
				_tmp507_ = vala_assignment_get_left (self);
				_tmp508_ = _tmp507_;
				_tmp509_ = vala_expression_get_value_type (_tmp508_);
				_tmp510_ = _tmp509_;
				_tmp511_ = vala_code_node_to_string ((ValaCodeNode*) _tmp510_);
				_tmp512_ = _tmp511_;
				_tmp513_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp506_, _tmp512_);
				_tmp514_ = _tmp513_;
				vala_report_error (_tmp500_, _tmp514_);
				_g_free0 (_tmp514_);
				_g_free0 (_tmp512_);
				_g_free0 (_tmp506_);
				result = FALSE;
				return result;
			}
			_tmp515_ = ma;
			_tmp516_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp515_);
			_tmp517_ = _tmp516_;
			if (!VALA_IS_PROPERTY (_tmp517_)) {
				ValaExpression* _tmp518_;
				ValaExpression* _tmp519_;
				ValaDataType* _tmp520_;
				ValaDataType* _tmp521_;
				_tmp518_ = vala_assignment_get_right (self);
				_tmp519_ = _tmp518_;
				_tmp520_ = vala_expression_get_value_type (_tmp519_);
				_tmp521_ = _tmp520_;
				if (vala_data_type_is_disposable (_tmp521_)) {
					gboolean _tmp522_ = FALSE;
					ValaExpression* _tmp523_;
					ValaExpression* _tmp524_;
					ValaDataType* _tmp525_;
					ValaDataType* _tmp526_;
					_tmp523_ = vala_assignment_get_left (self);
					_tmp524_ = _tmp523_;
					_tmp525_ = vala_expression_get_value_type (_tmp524_);
					_tmp526_ = _tmp525_;
					if (!VALA_IS_POINTER_TYPE (_tmp526_)) {
						ValaExpression* _tmp527_;
						ValaExpression* _tmp528_;
						ValaDataType* _tmp529_;
						ValaDataType* _tmp530_;
						gboolean _tmp531_;
						gboolean _tmp532_;
						_tmp527_ = vala_assignment_get_left (self);
						_tmp528_ = _tmp527_;
						_tmp529_ = vala_expression_get_value_type (_tmp528_);
						_tmp530_ = _tmp529_;
						_tmp531_ = vala_data_type_get_value_owned (_tmp530_);
						_tmp532_ = _tmp531_;
						_tmp522_ = !_tmp532_;
					} else {
						_tmp522_ = FALSE;
					}
					if (_tmp522_) {
						ValaSourceReference* _tmp533_;
						ValaSourceReference* _tmp534_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp533_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp534_ = _tmp533_;
						vala_report_error (_tmp534_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp535_;
					ValaExpression* _tmp536_;
					ValaDataType* _tmp537_;
					ValaDataType* _tmp538_;
					gboolean _tmp539_;
					gboolean _tmp540_;
					_tmp535_ = vala_assignment_get_left (self);
					_tmp536_ = _tmp535_;
					_tmp537_ = vala_expression_get_value_type (_tmp536_);
					_tmp538_ = _tmp537_;
					_tmp539_ = vala_data_type_get_value_owned (_tmp538_);
					_tmp540_ = _tmp539_;
					if (_tmp540_) {
					}
				}
			}
		}
		_tmp541_ = vala_assignment_get_right (self);
		_tmp542_ = _tmp541_;
		_tmp543_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp542_) ? ((ValaMemberAccess*) _tmp542_) : NULL);
		right_ma = _tmp543_;
		_tmp545_ = right_ma;
		if (_tmp545_ != NULL) {
			ValaMemberAccess* _tmp546_;
			ValaSymbol* _tmp547_;
			ValaSymbol* _tmp548_;
			ValaMemberAccess* _tmp549_;
			ValaSymbol* _tmp550_;
			ValaSymbol* _tmp551_;
			_tmp546_ = ma;
			_tmp547_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp546_);
			_tmp548_ = _tmp547_;
			_tmp549_ = right_ma;
			_tmp550_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp549_);
			_tmp551_ = _tmp550_;
			_tmp544_ = _tmp548_ == _tmp551_;
		} else {
			_tmp544_ = FALSE;
		}
		if (_tmp544_) {
			gboolean _tmp552_ = FALSE;
			ValaMemberAccess* _tmp553_;
			ValaSymbol* _tmp554_;
			ValaSymbol* _tmp555_;
			_tmp553_ = ma;
			_tmp554_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp553_);
			_tmp555_ = _tmp554_;
			if (VALA_IS_LOCAL_VARIABLE (_tmp555_)) {
				_tmp552_ = TRUE;
			} else {
				ValaMemberAccess* _tmp556_;
				ValaSymbol* _tmp557_;
				ValaSymbol* _tmp558_;
				_tmp556_ = ma;
				_tmp557_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp556_);
				_tmp558_ = _tmp557_;
				_tmp552_ = VALA_IS_PARAMETER (_tmp558_);
			}
			if (_tmp552_) {
				ValaSourceReference* _tmp559_;
				ValaSourceReference* _tmp560_;
				_tmp559_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp560_ = _tmp559_;
				vala_report_warning (_tmp560_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp561_;
				ValaSymbol* _tmp562_;
				ValaSymbol* _tmp563_;
				_tmp561_ = ma;
				_tmp562_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp561_);
				_tmp563_ = _tmp562_;
				if (VALA_IS_FIELD (_tmp563_)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp564_;
					ValaSymbol* _tmp565_;
					ValaSymbol* _tmp566_;
					ValaField* _tmp567_;
					ValaField* _tmp568_;
					ValaMemberBinding _tmp569_;
					ValaMemberBinding _tmp570_;
					_tmp564_ = ma;
					_tmp565_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp564_);
					_tmp566_ = _tmp565_;
					_tmp567_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp566_, VALA_TYPE_FIELD, ValaField));
					f = _tmp567_;
					_tmp568_ = f;
					_tmp569_ = vala_field_get_binding (_tmp568_);
					_tmp570_ = _tmp569_;
					if (_tmp570_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp571_;
						ValaSourceReference* _tmp572_;
						_tmp571_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp572_ = _tmp571_;
						vala_report_warning (_tmp572_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp573_;
						ValaExpression* _tmp574_;
						ValaExpression* _tmp575_;
						ValaMemberAccess* _tmp576_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp577_;
						ValaExpression* _tmp578_;
						ValaExpression* _tmp579_;
						ValaMemberAccess* _tmp580_;
						gboolean _tmp581_ = FALSE;
						gboolean _tmp582_ = FALSE;
						gboolean _tmp583_ = FALSE;
						gboolean _tmp584_ = FALSE;
						gboolean _tmp585_ = FALSE;
						ValaMemberAccess* _tmp586_;
						_tmp573_ = ma;
						_tmp574_ = vala_member_access_get_inner (_tmp573_);
						_tmp575_ = _tmp574_;
						_tmp576_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp575_) ? ((ValaMemberAccess*) _tmp575_) : NULL);
						ma_inner = _tmp576_;
						_tmp577_ = right_ma;
						_tmp578_ = vala_member_access_get_inner (_tmp577_);
						_tmp579_ = _tmp578_;
						_tmp580_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp579_) ? ((ValaMemberAccess*) _tmp579_) : NULL);
						right_ma_inner = _tmp580_;
						_tmp586_ = ma_inner;
						if (_tmp586_ != NULL) {
							ValaMemberAccess* _tmp587_;
							const gchar* _tmp588_;
							const gchar* _tmp589_;
							_tmp587_ = ma_inner;
							_tmp588_ = vala_member_access_get_member_name (_tmp587_);
							_tmp589_ = _tmp588_;
							_tmp585_ = g_strcmp0 (_tmp589_, "this") == 0;
						} else {
							_tmp585_ = FALSE;
						}
						if (_tmp585_) {
							ValaMemberAccess* _tmp590_;
							ValaExpression* _tmp591_;
							ValaExpression* _tmp592_;
							_tmp590_ = ma_inner;
							_tmp591_ = vala_member_access_get_inner (_tmp590_);
							_tmp592_ = _tmp591_;
							_tmp584_ = _tmp592_ == NULL;
						} else {
							_tmp584_ = FALSE;
						}
						if (_tmp584_) {
							ValaMemberAccess* _tmp593_;
							_tmp593_ = right_ma_inner;
							_tmp583_ = _tmp593_ != NULL;
						} else {
							_tmp583_ = FALSE;
						}
						if (_tmp583_) {
							ValaMemberAccess* _tmp594_;
							const gchar* _tmp595_;
							const gchar* _tmp596_;
							_tmp594_ = right_ma_inner;
							_tmp595_ = vala_member_access_get_member_name (_tmp594_);
							_tmp596_ = _tmp595_;
							_tmp582_ = g_strcmp0 (_tmp596_, "this") == 0;
						} else {
							_tmp582_ = FALSE;
						}
						if (_tmp582_) {
							ValaMemberAccess* _tmp597_;
							ValaExpression* _tmp598_;
							ValaExpression* _tmp599_;
							_tmp597_ = right_ma_inner;
							_tmp598_ = vala_member_access_get_inner (_tmp597_);
							_tmp599_ = _tmp598_;
							_tmp581_ = _tmp599_ == NULL;
						} else {
							_tmp581_ = FALSE;
						}
						if (_tmp581_) {
							ValaSourceReference* _tmp600_;
							ValaSourceReference* _tmp601_;
							_tmp600_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp601_ = _tmp600_;
							vala_report_warning (_tmp601_, "Assignment to same variable");
						}
						_vala_code_node_unref0 (right_ma_inner);
						_vala_code_node_unref0 (ma_inner);
					}
					_vala_code_node_unref0 (f);
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
	} else {
		ValaExpression* _tmp602_;
		ValaExpression* _tmp603_;
		_tmp602_ = vala_assignment_get_left (self);
		_tmp603_ = _tmp602_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp603_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp604_;
			ValaExpression* _tmp605_;
			ValaElementAccess* _tmp606_;
			ValaExpression* _tmp607_;
			ValaExpression* _tmp608_;
			ValaDataType* _tmp609_;
			ValaDataType* _tmp610_;
			ValaExpression* _tmp611_;
			ValaExpression* _tmp612_;
			ValaDataType* _tmp613_;
			ValaDataType* _tmp614_;
			ValaExpression* _tmp631_;
			ValaExpression* _tmp632_;
			ValaDataType* _tmp633_;
			ValaDataType* _tmp634_;
			_tmp604_ = vala_assignment_get_left (self);
			_tmp605_ = _tmp604_;
			_tmp606_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp605_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp606_;
			_tmp607_ = vala_assignment_get_right (self);
			_tmp608_ = _tmp607_;
			_tmp609_ = vala_expression_get_value_type (_tmp608_);
			_tmp610_ = _tmp609_;
			_tmp611_ = vala_assignment_get_left (self);
			_tmp612_ = _tmp611_;
			_tmp613_ = vala_expression_get_value_type (_tmp612_);
			_tmp614_ = _tmp613_;
			if (!vala_data_type_compatible (_tmp610_, _tmp614_)) {
				ValaSourceReference* _tmp615_;
				ValaSourceReference* _tmp616_;
				ValaExpression* _tmp617_;
				ValaExpression* _tmp618_;
				ValaDataType* _tmp619_;
				ValaDataType* _tmp620_;
				gchar* _tmp621_;
				gchar* _tmp622_;
				ValaExpression* _tmp623_;
				ValaExpression* _tmp624_;
				ValaDataType* _tmp625_;
				ValaDataType* _tmp626_;
				gchar* _tmp627_;
				gchar* _tmp628_;
				gchar* _tmp629_;
				gchar* _tmp630_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp615_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp616_ = _tmp615_;
				_tmp617_ = vala_assignment_get_right (self);
				_tmp618_ = _tmp617_;
				_tmp619_ = vala_expression_get_value_type (_tmp618_);
				_tmp620_ = _tmp619_;
				_tmp621_ = vala_code_node_to_string ((ValaCodeNode*) _tmp620_);
				_tmp622_ = _tmp621_;
				_tmp623_ = vala_assignment_get_left (self);
				_tmp624_ = _tmp623_;
				_tmp625_ = vala_expression_get_value_type (_tmp624_);
				_tmp626_ = _tmp625_;
				_tmp627_ = vala_code_node_to_string ((ValaCodeNode*) _tmp626_);
				_tmp628_ = _tmp627_;
				_tmp629_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp622_, _tmp628_);
				_tmp630_ = _tmp629_;
				vala_report_error (_tmp616_, _tmp630_);
				_g_free0 (_tmp630_);
				_g_free0 (_tmp628_);
				_g_free0 (_tmp622_);
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			}
			_tmp631_ = vala_assignment_get_right (self);
			_tmp632_ = _tmp631_;
			_tmp633_ = vala_expression_get_value_type (_tmp632_);
			_tmp634_ = _tmp633_;
			if (vala_data_type_is_disposable (_tmp634_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp635_;
				ValaExpression* _tmp636_;
				ValaExpression* _tmp637_;
				ValaDataType* _tmp638_;
				ValaDataType* _tmp639_;
				gboolean _tmp661_ = FALSE;
				ValaDataType* _tmp662_;
				_tmp635_ = ea;
				_tmp636_ = vala_element_access_get_container (_tmp635_);
				_tmp637_ = _tmp636_;
				_tmp638_ = vala_expression_get_value_type (_tmp637_);
				_tmp639_ = _tmp638_;
				if (VALA_IS_ARRAY_TYPE (_tmp639_)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp640_;
					ValaExpression* _tmp641_;
					ValaExpression* _tmp642_;
					ValaDataType* _tmp643_;
					ValaDataType* _tmp644_;
					ValaArrayType* _tmp645_;
					ValaArrayType* _tmp646_;
					ValaDataType* _tmp647_;
					ValaDataType* _tmp648_;
					ValaDataType* _tmp649_;
					_tmp640_ = ea;
					_tmp641_ = vala_element_access_get_container (_tmp640_);
					_tmp642_ = _tmp641_;
					_tmp643_ = vala_expression_get_value_type (_tmp642_);
					_tmp644_ = _tmp643_;
					_tmp645_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp644_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp645_;
					_tmp646_ = array_type;
					_tmp647_ = vala_array_type_get_element_type (_tmp646_);
					_tmp648_ = _tmp647_;
					_tmp649_ = _vala_code_node_ref0 (_tmp648_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp649_;
					_vala_code_node_unref0 (array_type);
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp650_;
					ValaExpression* _tmp651_;
					ValaExpression* _tmp652_;
					ValaDataType* _tmp653_;
					ValaDataType* _tmp654_;
					ValaList* _tmp655_;
					ValaList* _tmp656_;
					gint _tmp657_;
					gint _tmp658_;
					ValaList* _tmp659_;
					gpointer _tmp660_;
					_tmp650_ = ea;
					_tmp651_ = vala_element_access_get_container (_tmp650_);
					_tmp652_ = _tmp651_;
					_tmp653_ = vala_expression_get_value_type (_tmp652_);
					_tmp654_ = _tmp653_;
					_tmp655_ = vala_data_type_get_type_arguments (_tmp654_);
					args = _tmp655_;
					_tmp656_ = args;
					_tmp657_ = vala_collection_get_size ((ValaCollection*) _tmp656_);
					_tmp658_ = _tmp657_;
					_vala_assert (_tmp658_ == 1, "args.size == 1");
					_tmp659_ = args;
					_tmp660_ = vala_list_get (_tmp659_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp660_;
					_vala_iterable_unref0 (args);
				}
				_tmp662_ = element_type;
				if (!VALA_IS_POINTER_TYPE (_tmp662_)) {
					ValaDataType* _tmp663_;
					gboolean _tmp664_;
					gboolean _tmp665_;
					_tmp663_ = element_type;
					_tmp664_ = vala_data_type_get_value_owned (_tmp663_);
					_tmp665_ = _tmp664_;
					_tmp661_ = !_tmp665_;
				} else {
					_tmp661_ = FALSE;
				}
				if (_tmp661_) {
					ValaSourceReference* _tmp666_;
					ValaSourceReference* _tmp667_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp666_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp667_ = _tmp666_;
					vala_report_error (_tmp667_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					_vala_code_node_unref0 (ea);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp668_;
				ValaExpression* _tmp669_;
				ValaDataType* _tmp670_;
				ValaDataType* _tmp671_;
				gboolean _tmp672_;
				gboolean _tmp673_;
				_tmp668_ = vala_assignment_get_left (self);
				_tmp669_ = _tmp668_;
				_tmp670_ = vala_expression_get_value_type (_tmp669_);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_data_type_get_value_owned (_tmp671_);
				_tmp673_ = _tmp672_;
				if (_tmp673_) {
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp674_ = vala_assignment_get_left (self);
	_tmp675_ = _tmp674_;
	_tmp676_ = vala_expression_get_value_type (_tmp675_);
	_tmp677_ = _tmp676_;
	if (_tmp677_ != NULL) {
		ValaExpression* _tmp678_;
		ValaExpression* _tmp679_;
		ValaDataType* _tmp680_;
		ValaDataType* _tmp681_;
		ValaDataType* _tmp682_;
		ValaDataType* _tmp683_;
		ValaDataType* _tmp684_;
		ValaDataType* _tmp685_;
		_tmp678_ = vala_assignment_get_left (self);
		_tmp679_ = _tmp678_;
		_tmp680_ = vala_expression_get_value_type (_tmp679_);
		_tmp681_ = _tmp680_;
		_tmp682_ = vala_data_type_copy (_tmp681_);
		_tmp683_ = _tmp682_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp683_);
		_vala_code_node_unref0 (_tmp683_);
		_tmp684_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp685_ = _tmp684_;
		vala_data_type_set_value_owned (_tmp685_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp686_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp687_ = _tmp686_;
	if (_tmp687_ != NULL) {
		ValaDataType* _tmp688_;
		ValaDataType* _tmp689_;
		_tmp688_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp689_ = _tmp688_;
		vala_code_node_check ((ValaCodeNode*) _tmp689_, context);
	}
	_tmp690_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp691_ = _tmp690_;
	result = !_tmp691_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = VALA_IS_ARRAY_TYPE (_tmp9_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}

static void
vala_assignment_check_constant_assignment (ValaAssignment* self,
                                           ValaMemberAccess* inner)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		if (!(inner != NULL)) {
			break;
		}
		_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) inner);
		_tmp1_ = _tmp0_;
		if (VALA_IS_CONSTANT (_tmp1_)) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			vala_report_error (_tmp3_, "Assignment to constant after initialization");
			break;
		}
		_tmp4_ = vala_member_access_get_inner (inner);
		_tmp5_ = _tmp4_;
		if (VALA_IS_MEMBER_ACCESS (_tmp5_)) {
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			_tmp6_ = vala_member_access_get_inner (inner);
			_tmp7_ = _tmp6_;
			inner = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		} else {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (inner);
			_tmp9_ = _tmp8_;
			if (VALA_IS_ELEMENT_ACCESS (_tmp9_)) {
				ValaExpression* _tmp10_;
				ValaExpression* _tmp11_;
				ValaExpression* _tmp12_;
				ValaExpression* _tmp13_;
				_tmp10_ = vala_member_access_get_inner (inner);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_element_access_get_container (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				_tmp13_ = _tmp12_;
				inner = VALA_IS_MEMBER_ACCESS (_tmp13_) ? ((ValaMemberAccess*) _tmp13_) : NULL;
			} else {
				inner = NULL;
			}
		}
	}
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp133_;
	ValaExpression* _tmp134_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (VALA_IS_ELEMENT_ACCESS (_tmp4_) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (VALA_IS_POINTER_INDIRECTION (_tmp7_) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp118_ = FALSE;
		gboolean _tmp119_ = FALSE;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp12_) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp16_) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (VALA_IS_FIELD (_tmp20_) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (VALA_IS_PROPERTY (_tmp24_) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			_tmp39_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp47_;
			_tmp47_ = field;
			_tmp38_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp47_);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp48_ = FALSE;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			_tmp49_ = vala_assignment_get_left (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_expression_get_value_type (_tmp50_);
			_tmp52_ = _tmp51_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp52_)) {
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp48_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp54_);
			} else {
				_tmp48_ = FALSE;
			}
			_tmp37_ = !_tmp48_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp55_ = FALSE;
			ValaExpression* _tmp62_;
			ValaExpression* _tmp63_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp64_;
			ValaExpression* _tmp65_;
			ValaTargetValue* _tmp66_;
			ValaTargetValue* _tmp67_;
			ValaTargetValue* _tmp68_;
			ValaLocalVariable* _tmp69_;
			ValaCodeNode* _tmp94_;
			ValaCodeNode* _tmp95_;
			if (instance) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp55_ = _tmp58_ != NULL;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaMemberAccess* _tmp59_;
				ValaExpression* _tmp60_;
				ValaExpression* _tmp61_;
				_tmp59_ = ma;
				_tmp60_ = vala_member_access_get_inner (_tmp59_);
				_tmp61_ = _tmp60_;
				vala_code_node_emit ((ValaCodeNode*) _tmp61_, codegen);
			}
			_tmp62_ = vala_assignment_get_right (self);
			_tmp63_ = _tmp62_;
			vala_code_node_emit ((ValaCodeNode*) _tmp63_, codegen);
			_tmp64_ = vala_assignment_get_right (self);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_expression_get_target_value (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = _vala_target_value_ref0 (_tmp67_);
			new_value = _tmp68_;
			_tmp69_ = local;
			if (_tmp69_ != NULL) {
				ValaLocalVariable* _tmp70_;
				ValaTargetValue* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaSourceReference* _tmp73_;
				_tmp70_ = local;
				_tmp71_ = new_value;
				_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp73_ = _tmp72_;
				vala_code_generator_store_local (codegen, _tmp70_, _tmp71_, FALSE, _tmp73_);
			} else {
				ValaParameter* _tmp74_;
				_tmp74_ = param;
				if (_tmp74_ != NULL) {
					ValaParameter* _tmp75_;
					ValaTargetValue* _tmp76_;
					ValaSourceReference* _tmp77_;
					ValaSourceReference* _tmp78_;
					_tmp75_ = param;
					_tmp76_ = new_value;
					_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp78_ = _tmp77_;
					vala_code_generator_store_parameter (codegen, _tmp75_, _tmp76_, FALSE, _tmp78_);
				} else {
					ValaField* _tmp79_;
					_tmp79_ = field;
					if (_tmp79_ != NULL) {
						ValaTargetValue* _tmp80_ = NULL;
						gboolean _tmp81_ = FALSE;
						ValaField* _tmp90_;
						ValaTargetValue* _tmp91_;
						ValaSourceReference* _tmp92_;
						ValaSourceReference* _tmp93_;
						if (instance) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp81_ = _tmp84_ != NULL;
						} else {
							_tmp81_ = FALSE;
						}
						if (_tmp81_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaTargetValue* _tmp88_;
							ValaTargetValue* _tmp89_;
							_tmp85_ = ma;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_target_value (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp80_ = _tmp89_;
						} else {
							_tmp80_ = NULL;
						}
						_tmp90_ = field;
						_tmp91_ = new_value;
						_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp93_ = _tmp92_;
						vala_code_generator_store_field (codegen, _tmp90_, _tmp80_, _tmp91_, _tmp93_);
					}
				}
			}
			_tmp94_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp95_ = _tmp94_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp95_)) {
				ValaLocalVariable* _tmp96_;
				_tmp96_ = local;
				if (_tmp96_ != NULL) {
					ValaLocalVariable* _tmp97_;
					ValaTargetValue* _tmp98_;
					ValaTargetValue* _tmp99_;
					_tmp97_ = local;
					_tmp98_ = vala_code_generator_load_local (codegen, _tmp97_);
					_tmp99_ = _tmp98_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp99_);
					_vala_target_value_unref0 (_tmp99_);
				} else {
					ValaParameter* _tmp100_;
					_tmp100_ = param;
					if (_tmp100_ != NULL) {
						ValaParameter* _tmp101_;
						ValaTargetValue* _tmp102_;
						ValaTargetValue* _tmp103_;
						_tmp101_ = param;
						_tmp102_ = vala_code_generator_load_parameter (codegen, _tmp101_);
						_tmp103_ = _tmp102_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp103_);
						_vala_target_value_unref0 (_tmp103_);
					} else {
						ValaField* _tmp104_;
						_tmp104_ = field;
						if (_tmp104_ != NULL) {
							ValaTargetValue* _tmp105_ = NULL;
							gboolean _tmp106_ = FALSE;
							ValaField* _tmp115_;
							ValaTargetValue* _tmp116_;
							ValaTargetValue* _tmp117_;
							if (instance) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp106_ = _tmp109_ != NULL;
							} else {
								_tmp106_ = FALSE;
							}
							if (_tmp106_) {
								ValaMemberAccess* _tmp110_;
								ValaExpression* _tmp111_;
								ValaExpression* _tmp112_;
								ValaTargetValue* _tmp113_;
								ValaTargetValue* _tmp114_;
								_tmp110_ = ma;
								_tmp111_ = vala_member_access_get_inner (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp113_ = vala_expression_get_target_value (_tmp112_);
								_tmp114_ = _tmp113_;
								_tmp105_ = _tmp114_;
							} else {
								_tmp105_ = NULL;
							}
							_tmp115_ = field;
							_tmp116_ = vala_code_generator_load_field (codegen, _tmp115_, _tmp105_);
							_tmp117_ = _tmp116_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp117_);
							_vala_target_value_unref0 (_tmp117_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp120_;
			ValaExpression* _tmp121_;
			ValaExpression* _tmp122_;
			_tmp120_ = ma;
			_tmp121_ = vala_member_access_get_inner (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp119_ = _tmp122_ != NULL;
		} else {
			_tmp119_ = FALSE;
		}
		if (_tmp119_) {
			ValaProperty* _tmp123_;
			_tmp123_ = property;
			_tmp118_ = _tmp123_ != NULL;
		} else {
			_tmp118_ = FALSE;
		}
		if (_tmp118_) {
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			vala_code_node_emit ((ValaCodeNode*) _tmp126_, codegen);
		} else {
			ValaProperty* _tmp127_;
			_tmp127_ = property;
			if (_tmp127_ == NULL) {
				ValaMemberAccess* _tmp128_;
				_tmp128_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp128_, codegen);
			}
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp129_;
		_tmp129_ = ea;
		if (_tmp129_ != NULL) {
			ValaElementAccess* _tmp130_;
			_tmp130_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp130_, codegen);
		} else {
			ValaPointerIndirection* _tmp131_;
			_tmp131_ = pi;
			if (_tmp131_ != NULL) {
				ValaPointerIndirection* _tmp132_;
				_tmp132_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp132_, codegen);
			}
		}
	}
	_tmp133_ = vala_assignment_get_right (self);
	_tmp134_ = _tmp133_;
	vala_code_node_emit ((ValaCodeNode*) _tmp134_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* _tmp13_;
	ValaLocalVariable* _tmp14_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL);
	local = _tmp8_;
	_tmp9_ = vala_assignment_get_left (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL);
	param = _tmp13_;
	_tmp14_ = local;
	if (_tmp14_ != NULL) {
		ValaLocalVariable* _tmp15_;
		_tmp15_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		ValaParameter* _tmp17_;
		_tmp17_ = param;
		if (_tmp17_ != NULL) {
			ValaParameter* _tmp18_;
			ValaParameterDirection _tmp19_;
			ValaParameterDirection _tmp20_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_direction (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaParameter* _tmp21_;
			_tmp21_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp21_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (VALA_IS_ELEMENT_ACCESS (_tmp4_) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
	} else {
		ValaElementAccess* _tmp14_;
		_tmp14_ = ea;
		if (_tmp14_ != NULL) {
			ValaElementAccess* _tmp15_;
			_tmp15_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
		}
	}
	_tmp16_ = vala_assignment_get_right (self);
	_tmp17_ = _tmp16_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass,
                            gpointer klass_data)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self,
                               gpointer klass)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}

