/* rygel-mpris-plugin.c generated by valac 0.48.5, the Vala compiler
 * generated from rygel-mpris-plugin.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <rygel-renderer.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <rygel-core.h>

#define RYGEL_MPRIS_TYPE_PLUGIN (rygel_mpris_plugin_get_type ())
#define RYGEL_MPRIS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPlugin))
#define RYGEL_MPRIS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))
#define RYGEL_MPRIS_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))

typedef struct _RygelMPRISPlugin RygelMPRISPlugin;
typedef struct _RygelMPRISPluginClass RygelMPRISPluginClass;
typedef struct _RygelMPRISPluginPrivate RygelMPRISPluginPrivate;

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY (rygel_mpris_media_player_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxy))
#define RYGEL_MPRIS_MEDIA_PLAYER_IS_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerPlayerProxy RygelMPRISMediaPlayerPlayerProxy;
typedef struct _RygelMPRISMediaPlayerPlayerProxyIface RygelMPRISMediaPlayerPlayerProxyIface;

#define RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY (rygel_mpris_media_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, RygelMPRISMediaPlayerProxy))
#define RYGEL_MPRIS_IS_MEDIA_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, RygelMPRISMediaPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerProxy RygelMPRISMediaPlayerProxy;
typedef struct _RygelMPRISMediaPlayerProxyIface RygelMPRISMediaPlayerProxyIface;

#define RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY_PROXY (rygel_mpris_media_player_proxy_proxy_get_type ())

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY_PROXY (rygel_mpris_media_player_player_proxy_proxy_get_type ())
enum  {
	RYGEL_MPRIS_PLUGIN_0_PROPERTY,
	RYGEL_MPRIS_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* rygel_mpris_plugin_properties[RYGEL_MPRIS_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MPRIS_TYPE_PLAYER (rygel_mpris_player_get_type ())
#define RYGEL_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer))
#define RYGEL_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerClass))
#define RYGEL_MPRIS_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLAYER))
#define RYGEL_MPRIS_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLAYER))
#define RYGEL_MPRIS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerClass))

typedef struct _RygelMPRISPlayer RygelMPRISPlayer;
typedef struct _RygelMPRISPlayerClass RygelMPRISPlayerClass;

struct _RygelMPRISMediaPlayerProxyIface {
	GTypeInterface parent_iface;
	gchar* (*get_identity) (RygelMPRISMediaPlayerProxy* self);
	gchar** (*get_supported_uri_schemes) (RygelMPRISMediaPlayerProxy* self, gint* result_length1);
	gchar** (*get_supported_mime_types) (RygelMPRISMediaPlayerProxy* self, gint* result_length1);
};

struct _RygelMPRISMediaPlayerPlayerProxyIface {
	GTypeInterface parent_iface;
	void (*pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play_pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*stop) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*seek) (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
	void (*open_uri) (RygelMPRISMediaPlayerPlayerProxy* self, const gchar* uri, GError** error);
	gchar* (*get_playback_status) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_rate) (RygelMPRISMediaPlayerPlayerProxy* self);
	void (*set_rate) (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
	gdouble (*get_minimum_rate) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_maximum_rate) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_volume) (RygelMPRISMediaPlayerPlayerProxy* self);
	void (*set_volume) (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
	gint64 (*get_position) (RygelMPRISMediaPlayerPlayerProxy* self);
	gboolean (*get_can_seek) (RygelMPRISMediaPlayerPlayerProxy* self);
	gboolean (*get_can_control) (RygelMPRISMediaPlayerPlayerProxy* self);
	GHashTable* (*get_metadata) (RygelMPRISMediaPlayerPlayerProxy* self);
};

struct _RygelMPRISPlugin {
	RygelMediaRendererPlugin parent_instance;
	RygelMPRISPluginPrivate * priv;
	RygelMPRISMediaPlayerPlayerProxy* actual_player;
	gchar** mime_types;
	gint mime_types_length1;
	gchar** protocols;
	gint protocols_length1;
};

struct _RygelMPRISPluginClass {
	RygelMediaRendererPluginClass parent_class;
};

static gpointer rygel_mpris_plugin_parent_class = NULL;

GType rygel_mpris_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMPRISPlugin, g_object_unref)
GType rygel_mpris_media_player_proxy_get_type (void) G_GNUC_CONST;
GType rygel_mpris_media_player_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_mpris_media_player_proxy_register_object (void* object,
                                                      GDBusConnection* connection,
                                                      const gchar* path,
                                                      GError** error);
GType rygel_mpris_media_player_player_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_mpris_media_player_player_proxy_register_object (void* object,
                                                             GDBusConnection* connection,
                                                             const gchar* path,
                                                             GError** error);
GType rygel_mpris_media_player_player_proxy_get_type (void) G_GNUC_CONST;
#define RYGEL_MPRIS_PLUGIN_MODULE_NAME "MPRIS"
#define RYGEL_MPRIS_PLUGIN_MEDIA_PLAYER_PATH "/org/mpris/MediaPlayer2"
RygelMPRISPlugin* rygel_mpris_plugin_new (const gchar* service_name,
                                          RygelMPRISMediaPlayerPlayerProxy* actual_player);
RygelMPRISPlugin* rygel_mpris_plugin_construct (GType object_type,
                                                const gchar* service_name,
                                                RygelMPRISMediaPlayerPlayerProxy* actual_player);
gchar* rygel_mpris_media_player_proxy_get_identity (RygelMPRISMediaPlayerProxy* self);
gchar** rygel_mpris_media_player_proxy_get_supported_mime_types (RygelMPRISMediaPlayerProxy* self,
                                                                 gint* result_length1);
static gchar** rygel_mpris_plugin_schemes_to_protocols (RygelMPRISPlugin* self,
                                                 gchar** schemes,
                                                 gint schemes_length1,
                                                 gint* result_length1);
gchar** rygel_mpris_media_player_proxy_get_supported_uri_schemes (RygelMPRISMediaPlayerProxy* self,
                                                                  gint* result_length1);
static RygelMediaPlayer* rygel_mpris_plugin_real_get_player (RygelMediaRendererPlugin* base);
RygelMPRISPlayer* rygel_mpris_player_new (RygelMPRISPlugin* plugin);
RygelMPRISPlayer* rygel_mpris_player_construct (GType object_type,
                                                RygelMPRISPlugin* plugin);
GType rygel_mpris_player_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMPRISPlayer, g_object_unref)
static gchar* rygel_mpris_plugin_scheme_to_protocol (RygelMPRISPlugin* self,
                                              const gchar* scheme);
static void rygel_mpris_plugin_finalize (GObject * obj);
static GType rygel_mpris_plugin_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelMPRISPlugin*
rygel_mpris_plugin_construct (GType object_type,
                              const gchar* service_name,
                              RygelMPRISMediaPlayerPlayerProxy* actual_player)
{
	RygelMPRISPlugin * self = NULL;
	gchar* title = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	RygelMPRISMediaPlayerPlayerProxy* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_ = 0;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_ = 0;
	gchar** _tmp14_;
	g_return_val_if_fail (service_name != NULL, NULL);
	g_return_val_if_fail (actual_player != NULL, NULL);
	_tmp0_ = rygel_mpris_media_player_proxy_get_identity ((RygelMPRISMediaPlayerProxy*) actual_player);
	_tmp1_ = _tmp0_;
	title = _tmp1_;
	_tmp2_ = title;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (service_name);
		_g_free0 (title);
		title = _tmp3_;
	}
	_tmp4_ = title;
	self = (RygelMPRISPlugin*) rygel_media_renderer_plugin_construct (object_type, service_name, _tmp4_, NULL, RYGEL_PLUGIN_CAPABILITIES_NONE);
	_tmp5_ = _g_object_ref0 (actual_player);
	_g_object_unref0 (self->actual_player);
	self->actual_player = _tmp5_;
	_tmp6_ = rygel_mpris_media_player_proxy_get_supported_mime_types ((RygelMPRISMediaPlayerProxy*) actual_player, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->mime_types = _tmp8_;
	self->mime_types_length1 = _tmp8__length1;
	_tmp9_ = rygel_mpris_media_player_proxy_get_supported_uri_schemes ((RygelMPRISMediaPlayerProxy*) actual_player, &_tmp10_);
	_tmp9__length1 = _tmp10_;
	_tmp11_ = _tmp9_;
	_tmp11__length1 = _tmp9__length1;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _tmp11__length1;
	_tmp14_ = rygel_mpris_plugin_schemes_to_protocols (self, _tmp12_, (gint) _tmp11__length1, &_tmp13_);
	self->protocols = (_vala_array_free (self->protocols, self->protocols_length1, (GDestroyNotify) g_free), NULL);
	self->protocols = _tmp14_;
	self->protocols_length1 = _tmp13_;
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (title);
	return self;
}

RygelMPRISPlugin*
rygel_mpris_plugin_new (const gchar* service_name,
                        RygelMPRISMediaPlayerPlayerProxy* actual_player)
{
	return rygel_mpris_plugin_construct (RYGEL_MPRIS_TYPE_PLUGIN, service_name, actual_player);
}

static RygelMediaPlayer*
rygel_mpris_plugin_real_get_player (RygelMediaRendererPlugin* base)
{
	RygelMPRISPlugin * self;
	RygelMPRISPlayer* _tmp0_;
	RygelMediaPlayer* result = NULL;
	self = (RygelMPRISPlugin*) base;
	_tmp0_ = rygel_mpris_player_new (self);
	result = (RygelMediaPlayer*) _tmp0_;
	return result;
}

static gchar**
rygel_mpris_plugin_schemes_to_protocols (RygelMPRISPlugin* self,
                                         gchar** schemes,
                                         gint schemes_length1,
                                         gint* result_length1)
{
	gchar** protocols = NULL;
	gchar** _tmp1_;
	gint protocols_length1;
	gint _protocols_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (schemes == NULL) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp0__length1;
		}
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_new0 (gchar*, schemes_length1 + 1);
	protocols = _tmp1_;
	protocols_length1 = schemes_length1;
	_protocols_size_ = protocols_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar** _tmp4_;
				gint _tmp4__length1;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < schemes_length1)) {
					break;
				}
				_tmp4_ = protocols;
				_tmp4__length1 = protocols_length1;
				_tmp5_ = schemes[i];
				_tmp6_ = rygel_mpris_plugin_scheme_to_protocol (self, _tmp5_);
				_g_free0 (_tmp4_[i]);
				_tmp4_[i] = _tmp6_;
			}
		}
	}
	_tmp7_ = protocols;
	_tmp7__length1 = protocols_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static gchar*
rygel_mpris_plugin_scheme_to_protocol (RygelMPRISPlugin* self,
                                       const gchar* scheme)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scheme != NULL, NULL);
	_tmp0_ = scheme;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("http")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("http-get");
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("file")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("internal");
				result = _tmp4_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (scheme);
				result = _tmp5_;
				return result;
			}
		}
	}
}

static void
rygel_mpris_plugin_class_init (RygelMPRISPluginClass * klass,
                               gpointer klass_data)
{
	rygel_mpris_plugin_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaRendererPluginClass *) klass)->get_player = (RygelMediaPlayer* (*) (RygelMediaRendererPlugin*)) rygel_mpris_plugin_real_get_player;
	G_OBJECT_CLASS (klass)->finalize = rygel_mpris_plugin_finalize;
}

static void
rygel_mpris_plugin_instance_init (RygelMPRISPlugin * self,
                                  gpointer klass)
{
}

static void
rygel_mpris_plugin_finalize (GObject * obj)
{
	RygelMPRISPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPlugin);
	_g_object_unref0 (self->actual_player);
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->protocols = (_vala_array_free (self->protocols, self->protocols_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (rygel_mpris_plugin_parent_class)->finalize (obj);
}

static GType
rygel_mpris_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mpris_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMPRISPlugin), 0, (GInstanceInitFunc) rygel_mpris_plugin_instance_init, NULL };
	GType rygel_mpris_plugin_type_id;
	rygel_mpris_plugin_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, "RygelMPRISPlugin", &g_define_type_info, 0);
	return rygel_mpris_plugin_type_id;
}

GType
rygel_mpris_plugin_get_type (void)
{
	static volatile gsize rygel_mpris_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mpris_plugin_type_id__volatile)) {
		GType rygel_mpris_plugin_type_id;
		rygel_mpris_plugin_type_id = rygel_mpris_plugin_get_type_once ();
		g_once_init_leave (&rygel_mpris_plugin_type_id__volatile, rygel_mpris_plugin_type_id);
	}
	return rygel_mpris_plugin_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

