/* valageniescanner.c generated by valac, the Vala compiler
 * generated from valageniescanner.vala, do not modify */

/* valageniescanner.vala
 *
 * Copyright (C) 2008-2012  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#include "vala.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define VALA_GENIE_SCANNER_TYPE_CONDITIONAL (vala_genie_scanner_conditional_get_type ())
typedef struct _ValaGenieScannerConditional ValaGenieScannerConditional;
typedef enum  {
	VALA_GENIE_SCANNER_STATE_PARENS,
	VALA_GENIE_SCANNER_STATE_BRACE,
	VALA_GENIE_SCANNER_STATE_BRACKET,
	VALA_GENIE_SCANNER_STATE_REGEX_LITERAL,
	VALA_GENIE_SCANNER_STATE_TEMPLATE,
	VALA_GENIE_SCANNER_STATE_TEMPLATE_PART
} ValaGenieScannerState;

#define VALA_GENIE_SCANNER_TYPE_STATE (vala_genie_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaGenieParamSpecScanner ValaGenieParamSpecScanner;

struct _ValaGenieScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

struct _ValaGenieScannerPrivate {
	ValaSourceFile* _source_file;
	gint _indent_spaces;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	gint current_indent_level;
	gint indent_level;
	gint pending_dedents;
	gint open_parens_count;
	gint open_brace_count;
	ValaGenieTokenType last_token;
	gboolean parse_started;
	ValaComment* _comment;
	ValaGenieScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaGenieScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaGenieParamSpecScanner {
	GParamSpec parent_instance;
};

static gint ValaGenieScanner_private_offset;
static gpointer vala_genie_scanner_parent_class = NULL;

static GType vala_genie_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGenieScannerConditional* vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self);
static void vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self);
static GType vala_genie_scanner_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_genie_scanner_set_source_file (ValaGenieScanner* self,
                                         ValaSourceFile* value);
static gboolean vala_genie_scanner_in_template (ValaGenieScanner* self);
static gboolean vala_genie_scanner_in_template_part (ValaGenieScanner* self);
static gboolean vala_genie_scanner_is_ident_char (ValaGenieScanner* self,
                                           gchar c);
static gboolean vala_genie_scanner_in_regex_literal (ValaGenieScanner* self);
static ValaSourceReference* vala_genie_scanner_get_source_reference (ValaGenieScanner* self,
                                                              gint offset,
                                                              gint length);
static gboolean vala_genie_scanner_matches (gchar* begin,
                                     const gchar* keyword);
static void _vala_array_add2 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add3 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add4 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add5 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void vala_genie_scanner_space (ValaGenieScanner* self);
static void vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self);
static inline gboolean vala_genie_scanner_newline (ValaGenieScanner* self);
static gboolean vala_genie_scanner_skip_newlines (ValaGenieScanner* self);
static gint vala_genie_scanner_count_tabs (ValaGenieScanner* self);
static void _vala_array_add6 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add7 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add8 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add9 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add10 (ValaGenieScannerState* * array,
                        int* length,
                        int* size,
                        ValaGenieScannerState value);
static gboolean vala_genie_scanner_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_pp_directive (ValaGenieScanner* self);
static gboolean vala_genie_scanner_comment (ValaGenieScanner* self,
                                     gboolean file_comment);
static void vala_genie_scanner_push_comment (ValaGenieScanner* self,
                                      const gchar* comment_item,
                                      ValaSourceReference* source_reference,
                                      gboolean file_comment);
static gboolean vala_genie_scanner_skip_tabs (ValaGenieScanner* self);
static gboolean vala_genie_scanner_pp_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_pp_space (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_if (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_else (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self);
static void vala_genie_scanner_pp_eol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self);
static void _vala_array_add11 (ValaGenieScannerConditional* * array,
                        int* length,
                        int* size,
                        const ValaGenieScannerConditional* value);
static gboolean vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self);
static void vala_genie_scanner_finalize (ValaGenieScanner * obj);

static inline gpointer
vala_genie_scanner_get_instance_private (ValaGenieScanner* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGenieScanner_private_offset);
}

static GType
vala_genie_scanner_state_get_type (void)
{
	static volatile gsize vala_genie_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_GENIE_SCANNER_STATE_PARENS, "VALA_GENIE_SCANNER_STATE_PARENS", "parens"}, {VALA_GENIE_SCANNER_STATE_BRACE, "VALA_GENIE_SCANNER_STATE_BRACE", "brace"}, {VALA_GENIE_SCANNER_STATE_BRACKET, "VALA_GENIE_SCANNER_STATE_BRACKET", "bracket"}, {VALA_GENIE_SCANNER_STATE_REGEX_LITERAL, "VALA_GENIE_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {VALA_GENIE_SCANNER_STATE_TEMPLATE, "VALA_GENIE_SCANNER_STATE_TEMPLATE", "template"}, {VALA_GENIE_SCANNER_STATE_TEMPLATE_PART, "VALA_GENIE_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {0, NULL, NULL}};
		GType vala_genie_scanner_state_type_id;
		vala_genie_scanner_state_type_id = g_enum_register_static ("ValaGenieScannerState", values);
		g_once_init_leave (&vala_genie_scanner_state_type_id__volatile, vala_genie_scanner_state_type_id);
	}
	return vala_genie_scanner_state_type_id__volatile;
}

ValaGenieScanner*
vala_genie_scanner_construct (GType object_type,
                              ValaSourceFile* source_file)
{
	ValaGenieScanner* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaGenieScanner*) g_type_create_instance (object_type);
	vala_genie_scanner_set_source_file (self, source_file);
	_tmp0_ = vala_source_file_get_mapped_contents (source_file);
	self->priv->begin = _tmp0_;
	_tmp1_ = self->priv->begin;
	self->priv->end = _tmp1_ + vala_source_file_get_mapped_length (source_file);
	_tmp2_ = self->priv->begin;
	self->priv->current = _tmp2_;
	self->priv->_indent_spaces = 0;
	self->priv->line = 1;
	self->priv->column = 1;
	self->priv->current_indent_level = 0;
	self->priv->indent_level = 0;
	self->priv->pending_dedents = 0;
	self->priv->open_parens_count = 0;
	self->priv->open_brace_count = 0;
	self->priv->parse_started = FALSE;
	self->priv->last_token = VALA_GENIE_TOKEN_TYPE_NONE;
	return self;
}

ValaGenieScanner*
vala_genie_scanner_new (ValaSourceFile* source_file)
{
	return vala_genie_scanner_construct (VALA_GENIE_TYPE_SCANNER, source_file);
}

static gboolean
vala_genie_scanner_in_template (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_genie_scanner_in_template_part (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_genie_scanner_is_ident_char (ValaGenieScanner* self,
                                  gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_ascii_isalnum (c)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_genie_scanner_in_regex_literal (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static ValaSourceReference*
vala_genie_scanner_get_source_reference (ValaGenieScanner* self,
                                         gint offset,
                                         gint length)
{
	ValaSourceReference* result = NULL;
	ValaSourceFile* _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	gchar* _tmp3_;
	ValaSourceLocation _tmp4_ = {0};
	ValaSourceReference* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	_tmp1_ = self->priv->current;
	vala_source_location_init (&_tmp2_, _tmp1_, self->priv->line, self->priv->column + offset);
	_tmp3_ = self->priv->current;
	vala_source_location_init (&_tmp4_, _tmp3_ + length, self->priv->line, (self->priv->column + offset) + length);
	_tmp5_ = vala_source_reference_new (_tmp0_, &_tmp2_, &_tmp4_);
	result = _tmp5_;
	return result;
}

ValaGenieTokenType
vala_genie_scanner_read_regex_token (ValaGenieScanner* self,
                                     ValaSourceLocation* token_begin,
                                     ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaGenieTokenType result = 0;
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint token_length_in_chars = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp107_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	_tmp2_ = self->priv->current;
	_tmp3_ = self->priv->end;
	if (_tmp2_ >= _tmp3_) {
		type = VALA_GENIE_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		switch (_tmp5_) {
			case '/':
			{
				gchar* _tmp6_;
				gint _tmp7_;
				gboolean fl_i = FALSE;
				gboolean fl_s = FALSE;
				gboolean fl_m = FALSE;
				gboolean fl_x = FALSE;
				type = VALA_GENIE_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				_tmp6_ = self->priv->current;
				self->priv->current = _tmp6_ + 1;
				_tmp7_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp7_ - 1;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					gchar* _tmp11_;
					gchar _tmp12_;
					gchar* _tmp19_;
					gchar _tmp20_;
					gchar* _tmp29_;
					gint _tmp30_;
					_tmp11_ = self->priv->current;
					_tmp12_ = _tmp11_[0];
					if (_tmp12_ == 'i') {
						_tmp10_ = TRUE;
					} else {
						gchar* _tmp13_;
						gchar _tmp14_;
						_tmp13_ = self->priv->current;
						_tmp14_ = _tmp13_[0];
						_tmp10_ = _tmp14_ == 's';
					}
					if (_tmp10_) {
						_tmp9_ = TRUE;
					} else {
						gchar* _tmp15_;
						gchar _tmp16_;
						_tmp15_ = self->priv->current;
						_tmp16_ = _tmp15_[0];
						_tmp9_ = _tmp16_ == 'm';
					}
					if (_tmp9_) {
						_tmp8_ = TRUE;
					} else {
						gchar* _tmp17_;
						gchar _tmp18_;
						_tmp17_ = self->priv->current;
						_tmp18_ = _tmp17_[0];
						_tmp8_ = _tmp18_ == 'x';
					}
					if (!_tmp8_) {
						break;
					}
					_tmp19_ = self->priv->current;
					_tmp20_ = _tmp19_[0];
					switch (_tmp20_) {
						case 'i':
						{
							if (fl_i) {
								ValaSourceReference* _tmp21_;
								ValaSourceReference* _tmp22_;
								_tmp21_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp22_ = _tmp21_;
								vala_report_error (_tmp22_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp22_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							if (fl_s) {
								ValaSourceReference* _tmp23_;
								ValaSourceReference* _tmp24_;
								_tmp23_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp24_ = _tmp23_;
								vala_report_error (_tmp24_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp24_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							if (fl_m) {
								ValaSourceReference* _tmp25_;
								ValaSourceReference* _tmp26_;
								_tmp25_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp26_ = _tmp25_;
								vala_report_error (_tmp26_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp26_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							if (fl_x) {
								ValaSourceReference* _tmp27_;
								ValaSourceReference* _tmp28_;
								_tmp27_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp28_ = _tmp27_;
								vala_report_error (_tmp28_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp28_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					_tmp29_ = self->priv->current;
					self->priv->current = _tmp29_ + 1;
					_tmp30_ = token_length_in_chars;
					token_length_in_chars = _tmp30_ + 1;
				}
				break;
			}
			default:
			{
				gboolean _tmp94_ = FALSE;
				gchar* _tmp95_;
				gchar* _tmp96_;
				type = VALA_GENIE_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp31_ = FALSE;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp36_;
					gchar _tmp37_;
					_tmp32_ = self->priv->current;
					_tmp33_ = self->priv->end;
					if (_tmp32_ < _tmp33_) {
						gchar* _tmp34_;
						gchar _tmp35_;
						_tmp34_ = self->priv->current;
						_tmp35_ = _tmp34_[0];
						_tmp31_ = _tmp35_ != '/';
					} else {
						_tmp31_ = FALSE;
					}
					if (!_tmp31_) {
						break;
					}
					_tmp36_ = self->priv->current;
					_tmp37_ = _tmp36_[0];
					if (_tmp37_ == '\\') {
						gchar* _tmp38_;
						gint _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar _tmp43_;
						_tmp38_ = self->priv->current;
						self->priv->current = _tmp38_ + 1;
						_tmp39_ = token_length_in_chars;
						token_length_in_chars = _tmp39_ + 1;
						_tmp40_ = self->priv->current;
						_tmp41_ = self->priv->end;
						if (_tmp40_ >= _tmp41_) {
							break;
						}
						_tmp42_ = self->priv->current;
						_tmp43_ = _tmp42_[0];
						switch (_tmp43_) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'N':
							case 'r':
							case 'R':
							case 't':
							case 'v':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								gchar* _tmp44_;
								gint _tmp45_;
								_tmp44_ = self->priv->current;
								self->priv->current = _tmp44_ + 1;
								_tmp45_ = token_length_in_chars;
								token_length_in_chars = _tmp45_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp46_;
								gint _tmp47_;
								gint digit_length = 0;
								_tmp46_ = self->priv->current;
								self->priv->current = _tmp46_ + 1;
								_tmp47_ = token_length_in_chars;
								token_length_in_chars = _tmp47_ + 1;
								{
									gboolean _tmp48_ = FALSE;
									digit_length = 0;
									_tmp48_ = TRUE;
									while (TRUE) {
										gboolean _tmp50_ = FALSE;
										gboolean _tmp51_ = FALSE;
										gchar* _tmp56_;
										gint _tmp57_;
										if (!_tmp48_) {
											gint _tmp49_;
											_tmp49_ = digit_length;
											digit_length = _tmp49_ + 1;
										}
										_tmp48_ = FALSE;
										if (digit_length < 4) {
											gchar* _tmp52_;
											gchar* _tmp53_;
											_tmp52_ = self->priv->current;
											_tmp53_ = self->priv->end;
											_tmp51_ = _tmp52_ < _tmp53_;
										} else {
											_tmp51_ = FALSE;
										}
										if (_tmp51_) {
											gchar* _tmp54_;
											gchar _tmp55_;
											_tmp54_ = self->priv->current;
											_tmp55_ = _tmp54_[0];
											_tmp50_ = g_ascii_isxdigit (_tmp55_);
										} else {
											_tmp50_ = FALSE;
										}
										if (!_tmp50_) {
											break;
										}
										_tmp56_ = self->priv->current;
										self->priv->current = _tmp56_ + 1;
										_tmp57_ = token_length_in_chars;
										token_length_in_chars = _tmp57_ + 1;
									}
								}
								if (digit_length != 4) {
									ValaSourceReference* _tmp58_;
									ValaSourceReference* _tmp59_;
									_tmp58_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp59_ = _tmp58_;
									vala_report_error (_tmp59_, "\\u requires four hex digits");
									_vala_source_reference_unref0 (_tmp59_);
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp60_;
								gint _tmp61_;
								gint digit_length = 0;
								_tmp60_ = self->priv->current;
								self->priv->current = _tmp60_ + 1;
								_tmp61_ = token_length_in_chars;
								token_length_in_chars = _tmp61_ + 1;
								{
									gboolean _tmp62_ = FALSE;
									digit_length = 0;
									_tmp62_ = TRUE;
									while (TRUE) {
										gboolean _tmp64_ = FALSE;
										gboolean _tmp65_ = FALSE;
										gchar* _tmp70_;
										gint _tmp71_;
										if (!_tmp62_) {
											gint _tmp63_;
											_tmp63_ = digit_length;
											digit_length = _tmp63_ + 1;
										}
										_tmp62_ = FALSE;
										if (digit_length < 2) {
											gchar* _tmp66_;
											gchar* _tmp67_;
											_tmp66_ = self->priv->current;
											_tmp67_ = self->priv->end;
											_tmp65_ = _tmp66_ < _tmp67_;
										} else {
											_tmp65_ = FALSE;
										}
										if (_tmp65_) {
											gchar* _tmp68_;
											gchar _tmp69_;
											_tmp68_ = self->priv->current;
											_tmp69_ = _tmp68_[0];
											_tmp64_ = g_ascii_isxdigit (_tmp69_);
										} else {
											_tmp64_ = FALSE;
										}
										if (!_tmp64_) {
											break;
										}
										_tmp70_ = self->priv->current;
										self->priv->current = _tmp70_ + 1;
										_tmp71_ = token_length_in_chars;
										token_length_in_chars = _tmp71_ + 1;
									}
								}
								if (digit_length != 2) {
									ValaSourceReference* _tmp72_;
									ValaSourceReference* _tmp73_;
									_tmp72_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp73_ = _tmp72_;
									vala_report_error (_tmp73_, "\\x requires two hex digits");
									_vala_source_reference_unref0 (_tmp73_);
								}
								break;
							}
							default:
							{
								gchar* _tmp74_;
								gchar _tmp75_;
								_tmp74_ = self->priv->current;
								_tmp75_ = _tmp74_[0];
								if (g_ascii_isdigit (_tmp75_)) {
									gchar* _tmp76_;
									gint _tmp77_;
									gchar* _tmp78_;
									gchar _tmp79_;
									_tmp76_ = self->priv->current;
									self->priv->current = _tmp76_ + 1;
									_tmp77_ = token_length_in_chars;
									token_length_in_chars = _tmp77_ + 1;
									_tmp78_ = self->priv->current;
									_tmp79_ = _tmp78_[0];
									if (g_ascii_isdigit (_tmp79_)) {
										gchar* _tmp80_;
										gint _tmp81_;
										_tmp80_ = self->priv->current;
										self->priv->current = _tmp80_ + 1;
										_tmp81_ = token_length_in_chars;
										token_length_in_chars = _tmp81_ + 1;
									}
								} else {
									ValaSourceReference* _tmp82_;
									ValaSourceReference* _tmp83_;
									_tmp82_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp83_ = _tmp82_;
									vala_report_error (_tmp83_, "invalid escape sequence");
									_vala_source_reference_unref0 (_tmp83_);
								}
								break;
							}
						}
					} else {
						gchar* _tmp84_;
						gchar _tmp85_;
						_tmp84_ = self->priv->current;
						_tmp85_ = _tmp84_[0];
						if (_tmp85_ == '\n') {
							break;
						} else {
							gunichar u = 0U;
							gchar* _tmp86_;
							gchar* _tmp87_;
							gchar* _tmp88_;
							_tmp86_ = self->priv->current;
							_tmp87_ = self->priv->end;
							_tmp88_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp86_, (gssize) ((glong) (_tmp87_ - _tmp88_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp89_;
								gint _tmp90_;
								_tmp89_ = self->priv->current;
								self->priv->current = _tmp89_ + g_unichar_to_utf8 (u, NULL);
								_tmp90_ = token_length_in_chars;
								token_length_in_chars = _tmp90_ + 1;
							} else {
								gchar* _tmp91_;
								ValaSourceReference* _tmp92_;
								ValaSourceReference* _tmp93_;
								_tmp91_ = self->priv->current;
								self->priv->current = _tmp91_ + 1;
								_tmp92_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp93_ = _tmp92_;
								vala_report_error (_tmp93_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp93_);
							}
						}
					}
				}
				_tmp95_ = self->priv->current;
				_tmp96_ = self->priv->end;
				if (_tmp95_ >= _tmp96_) {
					_tmp94_ = TRUE;
				} else {
					gchar* _tmp97_;
					gchar _tmp98_;
					_tmp97_ = self->priv->current;
					_tmp98_ = _tmp97_[0];
					_tmp94_ = _tmp98_ == '\n';
				}
				if (_tmp94_) {
					ValaSourceReference* _tmp99_;
					ValaSourceReference* _tmp100_;
					gint _tmp101_;
					ValaSourceLocation _tmp102_ = {0};
					ValaSourceLocation _tmp103_ = {0};
					ValaGenieTokenType _tmp104_;
					_tmp99_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
					_tmp100_ = _tmp99_;
					vala_report_error (_tmp100_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp100_);
					_tmp101_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp101_ - 1;
					_tmp104_ = vala_genie_scanner_read_token (self, &_tmp102_, &_tmp103_);
					_vala_token_begin = _tmp102_;
					_vala_token_end = _tmp103_;
					result = _tmp104_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp105_;
		gchar* _tmp106_;
		_tmp105_ = self->priv->current;
		_tmp106_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp105_ - _tmp106_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp107_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp107_, self->priv->line, self->priv->column - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

void
vala_genie_scanner_seek (ValaGenieScanner* self,
                         ValaSourceLocation* location)
{
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceLocation _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.pos;
	self->priv->current = _tmp1_;
	_tmp2_ = *location;
	self->priv->line = _tmp2_.line;
	_tmp3_ = *location;
	self->priv->column = _tmp3_.column;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack = NULL;
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack = NULL;
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
}

ValaGenieTokenType
vala_genie_scanner_get_identifier_or_keyword (gchar* begin,
                                              gint len)
{
	ValaGenieTokenType result = 0;
	switch (len) {
		case 2:
		{
			gchar _tmp0_;
			_tmp0_ = begin[0];
			switch (_tmp0_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "as")) {
						result = VALA_GENIE_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "do")) {
						result = VALA_GENIE_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar _tmp1_;
					_tmp1_ = begin[1];
					switch (_tmp1_) {
						case 'f':
						{
							result = VALA_GENIE_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_GENIE_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_GENIE_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "of")) {
						result = VALA_GENIE_TOKEN_TYPE_OF;
						return result;
					}
					if (vala_genie_scanner_matches (begin, "or")) {
						result = VALA_GENIE_TOKEN_TYPE_OP_OR;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "to")) {
						result = VALA_GENIE_TOKEN_TYPE_TO;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			gchar _tmp2_;
			_tmp2_ = begin[0];
			switch (_tmp2_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "and")) {
						result = VALA_GENIE_TOKEN_TYPE_OP_AND;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "def")) {
						result = VALA_GENIE_TOKEN_TYPE_DEF;
						return result;
					}
					break;
				}
				case 'f':
				{
					if (vala_genie_scanner_matches (begin, "for")) {
						result = VALA_GENIE_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					if (vala_genie_scanner_matches (begin, "get")) {
						result = VALA_GENIE_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "isa")) {
						result = VALA_GENIE_TOKEN_TYPE_ISA;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar _tmp3_;
					_tmp3_ = begin[1];
					switch (_tmp3_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "new")) {
								result = VALA_GENIE_TOKEN_TYPE_NEW;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "not")) {
								result = VALA_GENIE_TOKEN_TYPE_OP_NEG;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "out")) {
						result = VALA_GENIE_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_genie_scanner_matches (begin, "ref")) {
						result = VALA_GENIE_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "set")) {
						result = VALA_GENIE_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "try")) {
						result = VALA_GENIE_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "var")) {
						result = VALA_GENIE_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			gchar _tmp4_;
			_tmp4_ = begin[0];
			switch (_tmp4_) {
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "case")) {
						result = VALA_GENIE_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "dict")) {
						result = VALA_GENIE_TOKEN_TYPE_DICT;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar _tmp5_;
					_tmp5_ = begin[1];
					switch (_tmp5_) {
						case 'l':
						{
							if (vala_genie_scanner_matches (begin, "else")) {
								result = VALA_GENIE_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							if (vala_genie_scanner_matches (begin, "enum")) {
								result = VALA_GENIE_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "init")) {
						result = VALA_GENIE_TOKEN_TYPE_INIT;
						return result;
					}
					break;
				}
				case 'l':
				{
					gchar _tmp6_;
					_tmp6_ = begin[1];
					switch (_tmp6_) {
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "list")) {
								result = VALA_GENIE_TOKEN_TYPE_LIST;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "lock")) {
								result = VALA_GENIE_TOKEN_TYPE_LOCK;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'n':
				{
					if (vala_genie_scanner_matches (begin, "null")) {
						result = VALA_GENIE_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar _tmp7_;
					_tmp7_ = begin[1];
					switch (_tmp7_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "pass")) {
								result = VALA_GENIE_TOKEN_TYPE_PASS;
								return result;
							}
							break;
						}
						case 'r':
						{
							if (vala_genie_scanner_matches (begin, "prop")) {
								result = VALA_GENIE_TOKEN_TYPE_PROP;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "self")) {
						result = VALA_GENIE_TOKEN_TYPE_SELF;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "true")) {
						result = VALA_GENIE_TOKEN_TYPE_TRUE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_genie_scanner_matches (begin, "uses")) {
						result = VALA_GENIE_TOKEN_TYPE_USES;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "void")) {
						result = VALA_GENIE_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar _tmp8_;
					_tmp8_ = begin[1];
					switch (_tmp8_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "weak")) {
								result = VALA_GENIE_TOKEN_TYPE_WEAK;
								return result;
							}
							break;
						}
						case 'h':
						{
							if (vala_genie_scanner_matches (begin, "when")) {
								result = VALA_GENIE_TOKEN_TYPE_WHEN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			gchar _tmp9_;
			_tmp9_ = begin[0];
			switch (_tmp9_) {
				case 'a':
				{
					gchar _tmp10_;
					_tmp10_ = begin[1];
					switch (_tmp10_) {
						case 'r':
						{
							if (vala_genie_scanner_matches (begin, "array")) {
								result = VALA_GENIE_TOKEN_TYPE_ARRAY;
								return result;
							}
							break;
						}
						case 's':
						{
							if (vala_genie_scanner_matches (begin, "async")) {
								result = VALA_GENIE_TOKEN_TYPE_ASYNC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'b':
				{
					if (vala_genie_scanner_matches (begin, "break")) {
						result = VALA_GENIE_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar _tmp11_;
					_tmp11_ = begin[1];
					switch (_tmp11_) {
						case 'l':
						{
							if (vala_genie_scanner_matches (begin, "class")) {
								result = VALA_GENIE_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "const")) {
								result = VALA_GENIE_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "event")) {
						result = VALA_GENIE_TOKEN_TYPE_EVENT;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar _tmp12_;
					_tmp12_ = begin[1];
					switch (_tmp12_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "false")) {
								result = VALA_GENIE_TOKEN_TYPE_FALSE;
								return result;
							}
							break;
						}
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "final")) {
								result = VALA_GENIE_TOKEN_TYPE_FINAL;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "owned")) {
						result = VALA_GENIE_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "print")) {
						result = VALA_GENIE_TOKEN_TYPE_PRINT;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "super")) {
						result = VALA_GENIE_TOKEN_TYPE_SUPER;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_genie_scanner_matches (begin, "raise")) {
						result = VALA_GENIE_TOKEN_TYPE_RAISE;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_genie_scanner_matches (begin, "while")) {
						result = VALA_GENIE_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					if (vala_genie_scanner_matches (begin, "yield")) {
						result = VALA_GENIE_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			gchar _tmp13_;
			_tmp13_ = begin[0];
			switch (_tmp13_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "assert")) {
						result = VALA_GENIE_TOKEN_TYPE_ASSERT;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar _tmp14_;
					_tmp14_ = begin[1];
					switch (_tmp14_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "delete")) {
								result = VALA_GENIE_TOKEN_TYPE_DELETE;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "downto")) {
								result = VALA_GENIE_TOKEN_TYPE_DOWNTO;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					gchar _tmp15_;
					_tmp15_ = begin[1];
					switch (_tmp15_) {
						case 'x':
						{
							gchar _tmp16_;
							_tmp16_ = begin[2];
							switch (_tmp16_) {
								case 'c':
								{
									if (vala_genie_scanner_matches (begin, "except")) {
										result = VALA_GENIE_TOKEN_TYPE_EXCEPT;
										return result;
									}
									break;
								}
								case 't':
								{
									if (vala_genie_scanner_matches (begin, "extern")) {
										result = VALA_GENIE_TOKEN_TYPE_EXTERN;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "inline")) {
						result = VALA_GENIE_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar _tmp17_;
					_tmp17_ = begin[1];
					switch (_tmp17_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "params")) {
								result = VALA_GENIE_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							if (vala_genie_scanner_matches (begin, "public")) {
								result = VALA_GENIE_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					gchar _tmp18_;
					_tmp18_ = begin[1];
					switch (_tmp18_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "raises")) {
								result = VALA_GENIE_TOKEN_TYPE_RAISES;
								return result;
							}
							break;
						}
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "return")) {
								result = VALA_GENIE_TOKEN_TYPE_RETURN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					gchar _tmp19_;
					_tmp19_ = begin[1];
					switch (_tmp19_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "sealed")) {
								result = VALA_GENIE_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "sizeof")) {
								result = VALA_GENIE_TOKEN_TYPE_SIZEOF;
								return result;
							}
							break;
						}
						case 't':
						{
							gchar _tmp20_;
							_tmp20_ = begin[2];
							switch (_tmp20_) {
								case 'a':
								{
									if (vala_genie_scanner_matches (begin, "static")) {
										result = VALA_GENIE_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									if (vala_genie_scanner_matches (begin, "struct")) {
										result = VALA_GENIE_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "typeof")) {
						result = VALA_GENIE_TOKEN_TYPE_TYPEOF;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			gchar _tmp21_;
			_tmp21_ = begin[0];
			switch (_tmp21_) {
				case 'd':
				{
					gchar _tmp22_;
					_tmp22_ = begin[1];
					switch (_tmp22_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "default")) {
								result = VALA_GENIE_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							if (vala_genie_scanner_matches (begin, "dynamic")) {
								result = VALA_GENIE_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "ensures")) {
						result = VALA_GENIE_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar _tmp23_;
					_tmp23_ = begin[1];
					switch (_tmp23_) {
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "finally")) {
								result = VALA_GENIE_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "private")) {
						result = VALA_GENIE_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_genie_scanner_matches (begin, "unowned")) {
						result = VALA_GENIE_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "virtual")) {
						result = VALA_GENIE_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			gchar _tmp24_;
			_tmp24_ = begin[0];
			switch (_tmp24_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "abstract")) {
						result = VALA_GENIE_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "continue")) {
						result = VALA_GENIE_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "delegate")) {
						result = VALA_GENIE_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "internal")) {
						result = VALA_GENIE_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "override")) {
						result = VALA_GENIE_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar _tmp25_;
					_tmp25_ = begin[2];
					switch (_tmp25_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "readonly")) {
								result = VALA_GENIE_TOKEN_TYPE_READONLY;
								return result;
							}
							break;
						}
						case 'q':
						{
							if (vala_genie_scanner_matches (begin, "requires")) {
								result = VALA_GENIE_TOKEN_TYPE_REQUIRES;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "volatile")) {
						result = VALA_GENIE_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			gchar _tmp26_;
			_tmp26_ = begin[0];
			switch (_tmp26_) {
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "construct")) {
						result = VALA_GENIE_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "exception")) {
						result = VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "interface")) {
						result = VALA_GENIE_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_genie_scanner_matches (begin, "namespace")) {
						result = VALA_GENIE_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "protected")) {
						result = VALA_GENIE_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 10:
		{
			gchar _tmp27_;
			_tmp27_ = begin[0];
			switch (_tmp27_) {
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "implements")) {
						result = VALA_GENIE_TOKEN_TYPE_IMPLEMENTS;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
	return result;
}

static void
_vala_array_add2 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add3 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add4 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add5 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

ValaGenieTokenType
vala_genie_scanner_read_template_token (ValaGenieScanner* self,
                                        ValaSourceLocation* token_begin,
                                        ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaGenieTokenType result = 0;
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint token_length_in_chars = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp110_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	_tmp2_ = self->priv->current;
	_tmp3_ = self->priv->end;
	if (_tmp2_ >= _tmp3_) {
		type = VALA_GENIE_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		switch (_tmp5_) {
			case '"':
			{
				gchar* _tmp6_;
				gint _tmp7_;
				type = VALA_GENIE_TOKEN_TYPE_CLOSE_TEMPLATE;
				_tmp6_ = self->priv->current;
				self->priv->current = _tmp6_ + 1;
				_tmp7_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp7_ - 1;
				break;
			}
			case '$':
			{
				gchar* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar _tmp12_;
				_tmp8_ = _vala_token_begin.pos;
				_vala_token_begin.pos = _tmp8_ + 1;
				_tmp9_ = self->priv->current;
				self->priv->current = _tmp9_ + 1;
				_tmp11_ = self->priv->current;
				_tmp12_ = _tmp11_[0];
				if (g_ascii_isalpha (_tmp12_)) {
					_tmp10_ = TRUE;
				} else {
					gchar* _tmp13_;
					gchar _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					_tmp10_ = _tmp14_ == '_';
				}
				if (_tmp10_) {
					gint len = 0;
					ValaGenieScannerState* _tmp22_;
					gint _tmp22__length1;
					len = 0;
					while (TRUE) {
						gboolean _tmp15_ = FALSE;
						gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp20_;
						gint _tmp21_;
						_tmp16_ = self->priv->current;
						_tmp17_ = self->priv->end;
						if (_tmp16_ < _tmp17_) {
							gchar* _tmp18_;
							gchar _tmp19_;
							_tmp18_ = self->priv->current;
							_tmp19_ = _tmp18_[0];
							_tmp15_ = vala_genie_scanner_is_ident_char (self, _tmp19_);
						} else {
							_tmp15_ = FALSE;
						}
						if (!_tmp15_) {
							break;
						}
						_tmp20_ = self->priv->current;
						self->priv->current = _tmp20_ + 1;
						_tmp21_ = len;
						len = _tmp21_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
					_tmp22_ = self->priv->state_stack;
					_tmp22__length1 = self->priv->state_stack_length1;
					_vala_array_add2 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
				} else {
					gchar* _tmp23_;
					gchar _tmp24_;
					_tmp23_ = self->priv->current;
					_tmp24_ = _tmp23_[0];
					if (_tmp24_ == '(') {
						gchar* _tmp25_;
						ValaGenieScannerState* _tmp26_;
						gint _tmp26__length1;
						ValaSourceLocation _tmp27_ = {0};
						ValaSourceLocation _tmp28_ = {0};
						ValaGenieTokenType _tmp29_;
						_tmp25_ = self->priv->current;
						self->priv->current = _tmp25_ + 1;
						self->priv->column = self->priv->column + 2;
						_tmp26_ = self->priv->state_stack;
						_tmp26__length1 = self->priv->state_stack_length1;
						_vala_array_add3 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_PARENS);
						_tmp29_ = vala_genie_scanner_read_token (self, &_tmp27_, &_tmp28_);
						_vala_token_begin = _tmp27_;
						_vala_token_end = _tmp28_;
						result = _tmp29_;
						if (token_begin) {
							*token_begin = _vala_token_begin;
						}
						if (token_end) {
							*token_end = _vala_token_end;
						}
						return result;
					} else {
						gchar* _tmp30_;
						gchar _tmp31_;
						_tmp30_ = self->priv->current;
						_tmp31_ = _tmp30_[0];
						if (_tmp31_ == '$') {
							gchar* _tmp32_;
							ValaGenieScannerState* _tmp33_;
							gint _tmp33__length1;
							type = VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							_tmp32_ = self->priv->current;
							self->priv->current = _tmp32_ + 1;
							_tmp33_ = self->priv->state_stack;
							_tmp33__length1 = self->priv->state_stack_length1;
							_vala_array_add4 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp34_;
							ValaSourceReference* _tmp35_;
							ValaSourceLocation _tmp36_ = {0};
							ValaSourceLocation _tmp37_ = {0};
							ValaGenieTokenType _tmp38_;
							_tmp34_ = vala_genie_scanner_get_source_reference (self, 1, 0);
							_tmp35_ = _tmp34_;
							vala_report_error (_tmp35_, "unexpected character");
							_vala_source_reference_unref0 (_tmp35_);
							_tmp38_ = vala_genie_scanner_read_template_token (self, &_tmp36_, &_tmp37_);
							_vala_token_begin = _tmp36_;
							_vala_token_end = _tmp37_;
							result = _tmp38_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gchar* _tmp99_;
				gchar* _tmp100_;
				ValaGenieScannerState* _tmp107_;
				gint _tmp107__length1;
				type = VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp39_ = FALSE;
					gboolean _tmp40_ = FALSE;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp47_;
					gchar _tmp48_;
					_tmp41_ = self->priv->current;
					_tmp42_ = self->priv->end;
					if (_tmp41_ < _tmp42_) {
						gchar* _tmp43_;
						gchar _tmp44_;
						_tmp43_ = self->priv->current;
						_tmp44_ = _tmp43_[0];
						_tmp40_ = _tmp44_ != '"';
					} else {
						_tmp40_ = FALSE;
					}
					if (_tmp40_) {
						gchar* _tmp45_;
						gchar _tmp46_;
						_tmp45_ = self->priv->current;
						_tmp46_ = _tmp45_[0];
						_tmp39_ = _tmp46_ != '$';
					} else {
						_tmp39_ = FALSE;
					}
					if (!_tmp39_) {
						break;
					}
					_tmp47_ = self->priv->current;
					_tmp48_ = _tmp47_[0];
					if (_tmp48_ == '\\') {
						gchar* _tmp49_;
						gint _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp53_;
						gchar _tmp54_;
						_tmp49_ = self->priv->current;
						self->priv->current = _tmp49_ + 1;
						_tmp50_ = token_length_in_chars;
						token_length_in_chars = _tmp50_ + 1;
						_tmp51_ = self->priv->current;
						_tmp52_ = self->priv->end;
						if (_tmp51_ >= _tmp52_) {
							break;
						}
						_tmp53_ = self->priv->current;
						_tmp54_ = _tmp53_[0];
						switch (_tmp54_) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'v':
							{
								gchar* _tmp55_;
								gint _tmp56_;
								_tmp55_ = self->priv->current;
								self->priv->current = _tmp55_ + 1;
								_tmp56_ = token_length_in_chars;
								token_length_in_chars = _tmp56_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp57_;
								gint _tmp58_;
								gint digit_length = 0;
								_tmp57_ = self->priv->current;
								self->priv->current = _tmp57_ + 1;
								_tmp58_ = token_length_in_chars;
								token_length_in_chars = _tmp58_ + 1;
								{
									gboolean _tmp59_ = FALSE;
									digit_length = 0;
									_tmp59_ = TRUE;
									while (TRUE) {
										gboolean _tmp61_ = FALSE;
										gboolean _tmp62_ = FALSE;
										gchar* _tmp67_;
										gint _tmp68_;
										if (!_tmp59_) {
											gint _tmp60_;
											_tmp60_ = digit_length;
											digit_length = _tmp60_ + 1;
										}
										_tmp59_ = FALSE;
										if (digit_length < 4) {
											gchar* _tmp63_;
											gchar* _tmp64_;
											_tmp63_ = self->priv->current;
											_tmp64_ = self->priv->end;
											_tmp62_ = _tmp63_ < _tmp64_;
										} else {
											_tmp62_ = FALSE;
										}
										if (_tmp62_) {
											gchar* _tmp65_;
											gchar _tmp66_;
											_tmp65_ = self->priv->current;
											_tmp66_ = _tmp65_[0];
											_tmp61_ = g_ascii_isxdigit (_tmp66_);
										} else {
											_tmp61_ = FALSE;
										}
										if (!_tmp61_) {
											break;
										}
										_tmp67_ = self->priv->current;
										self->priv->current = _tmp67_ + 1;
										_tmp68_ = token_length_in_chars;
										token_length_in_chars = _tmp68_ + 1;
									}
								}
								if (digit_length != 4) {
									ValaSourceReference* _tmp69_;
									ValaSourceReference* _tmp70_;
									_tmp69_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp70_ = _tmp69_;
									vala_report_error (_tmp70_, "\\u requires four hex digits");
									_vala_source_reference_unref0 (_tmp70_);
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp71_;
								gint _tmp72_;
								gint digit_length = 0;
								_tmp71_ = self->priv->current;
								self->priv->current = _tmp71_ + 1;
								_tmp72_ = token_length_in_chars;
								token_length_in_chars = _tmp72_ + 1;
								{
									gboolean _tmp73_ = FALSE;
									digit_length = 0;
									_tmp73_ = TRUE;
									while (TRUE) {
										gboolean _tmp75_ = FALSE;
										gboolean _tmp76_ = FALSE;
										gchar* _tmp81_;
										gint _tmp82_;
										if (!_tmp73_) {
											gint _tmp74_;
											_tmp74_ = digit_length;
											digit_length = _tmp74_ + 1;
										}
										_tmp73_ = FALSE;
										if (digit_length < 2) {
											gchar* _tmp77_;
											gchar* _tmp78_;
											_tmp77_ = self->priv->current;
											_tmp78_ = self->priv->end;
											_tmp76_ = _tmp77_ < _tmp78_;
										} else {
											_tmp76_ = FALSE;
										}
										if (_tmp76_) {
											gchar* _tmp79_;
											gchar _tmp80_;
											_tmp79_ = self->priv->current;
											_tmp80_ = _tmp79_[0];
											_tmp75_ = g_ascii_isxdigit (_tmp80_);
										} else {
											_tmp75_ = FALSE;
										}
										if (!_tmp75_) {
											break;
										}
										_tmp81_ = self->priv->current;
										self->priv->current = _tmp81_ + 1;
										_tmp82_ = token_length_in_chars;
										token_length_in_chars = _tmp82_ + 1;
									}
								}
								if (digit_length != 2) {
									ValaSourceReference* _tmp83_;
									ValaSourceReference* _tmp84_;
									_tmp83_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp84_ = _tmp83_;
									vala_report_error (_tmp84_, "\\x requires two hex digits");
									_vala_source_reference_unref0 (_tmp84_);
								}
								break;
							}
							default:
							{
								ValaSourceReference* _tmp85_;
								ValaSourceReference* _tmp86_;
								_tmp85_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp86_ = _tmp85_;
								vala_report_error (_tmp86_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp86_);
								break;
							}
						}
					} else {
						gchar* _tmp87_;
						gchar _tmp88_;
						_tmp87_ = self->priv->current;
						_tmp88_ = _tmp87_[0];
						if (_tmp88_ == '\n') {
							gchar* _tmp89_;
							gint _tmp90_;
							_tmp89_ = self->priv->current;
							self->priv->current = _tmp89_ + 1;
							_tmp90_ = self->priv->line;
							self->priv->line = _tmp90_ + 1;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gunichar u = 0U;
							gchar* _tmp91_;
							gchar* _tmp92_;
							gchar* _tmp93_;
							_tmp91_ = self->priv->current;
							_tmp92_ = self->priv->end;
							_tmp93_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp91_, (gssize) ((glong) (_tmp92_ - _tmp93_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp94_;
								gint _tmp95_;
								_tmp94_ = self->priv->current;
								self->priv->current = _tmp94_ + g_unichar_to_utf8 (u, NULL);
								_tmp95_ = token_length_in_chars;
								token_length_in_chars = _tmp95_ + 1;
							} else {
								gchar* _tmp96_;
								ValaSourceReference* _tmp97_;
								ValaSourceReference* _tmp98_;
								_tmp96_ = self->priv->current;
								self->priv->current = _tmp96_ + 1;
								_tmp97_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp98_ = _tmp97_;
								vala_report_error (_tmp98_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp98_);
							}
						}
					}
				}
				_tmp99_ = self->priv->current;
				_tmp100_ = self->priv->end;
				if (_tmp99_ >= _tmp100_) {
					ValaSourceReference* _tmp101_;
					ValaSourceReference* _tmp102_;
					gint _tmp103_;
					ValaSourceLocation _tmp104_ = {0};
					ValaSourceLocation _tmp105_ = {0};
					ValaGenieTokenType _tmp106_;
					_tmp101_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
					_tmp102_ = _tmp101_;
					vala_report_error (_tmp102_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp102_);
					_tmp103_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp103_ - 1;
					_tmp106_ = vala_genie_scanner_read_token (self, &_tmp104_, &_tmp105_);
					_vala_token_begin = _tmp104_;
					_vala_token_end = _tmp105_;
					result = _tmp106_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				_tmp107_ = self->priv->state_stack;
				_tmp107__length1 = self->priv->state_stack_length1;
				_vala_array_add5 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp108_;
		gchar* _tmp109_;
		_tmp108_ = self->priv->current;
		_tmp109_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp108_ - _tmp109_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp110_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp110_, self->priv->line, self->priv->column - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

static void
_vala_array_add6 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add7 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add8 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add9 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add10 (ValaGenieScannerState* * array,
                   int* length,
                   int* size,
                   ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

ValaGenieTokenType
vala_genie_scanner_read_token (ValaGenieScanner* self,
                               ValaSourceLocation* token_begin,
                               ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaGenieTokenType result = 0;
	gchar* _tmp0_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gint token_length_in_chars = 0;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp466_;
	ValaGenieTokenType _tmp467_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
		_tmp2_ = self->priv->current;
		vala_source_location_init (&_vala_token_end, _tmp2_, self->priv->line, self->priv->column);
		result = VALA_GENIE_TOKEN_TYPE_EOF;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	if (vala_genie_scanner_in_template (self)) {
		ValaSourceLocation _tmp3_ = {0};
		ValaSourceLocation _tmp4_ = {0};
		ValaGenieTokenType _tmp5_;
		_tmp5_ = vala_genie_scanner_read_template_token (self, &_tmp3_, &_tmp4_);
		_vala_token_begin = _tmp3_;
		_vala_token_end = _tmp4_;
		result = _tmp5_;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	} else {
		if (vala_genie_scanner_in_template_part (self)) {
			gint _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = self->priv->state_stack_length1;
			self->priv->state_stack_length1 = _tmp6_ - 1;
			_tmp7_ = self->priv->current;
			vala_source_location_init (&_vala_token_begin, _tmp7_, self->priv->line, self->priv->column);
			_tmp8_ = self->priv->current;
			vala_source_location_init (&_vala_token_end, _tmp8_, self->priv->line, self->priv->column - 1);
			result = VALA_GENIE_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			if (vala_genie_scanner_in_regex_literal (self)) {
				ValaSourceLocation _tmp9_ = {0};
				ValaSourceLocation _tmp10_ = {0};
				ValaGenieTokenType _tmp11_;
				_tmp11_ = vala_genie_scanner_read_regex_token (self, &_tmp9_, &_tmp10_);
				_vala_token_begin = _tmp9_;
				_vala_token_end = _tmp10_;
				result = _tmp11_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	if (self->priv->pending_dedents > 0) {
		gint _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = self->priv->pending_dedents;
		self->priv->pending_dedents = _tmp12_ - 1;
		_tmp13_ = self->priv->indent_level;
		self->priv->indent_level = _tmp13_ - 1;
		_tmp14_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp14_, self->priv->line, self->priv->column);
		_tmp15_ = self->priv->current;
		vala_source_location_init (&_vala_token_end, _tmp15_, self->priv->line, self->priv->column);
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
		result = VALA_GENIE_TOKEN_TYPE_DEDENT;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	if (self->priv->_indent_spaces == 0) {
		_tmp16_ = TRUE;
	} else {
		ValaGenieTokenType _tmp17_;
		_tmp17_ = self->priv->last_token;
		_tmp16_ = _tmp17_ != VALA_GENIE_TOKEN_TYPE_EOL;
	}
	if (_tmp16_) {
		vala_genie_scanner_space (self);
	}
	while (TRUE) {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp26_;
		gint _tmp27_;
		_tmp20_ = self->priv->current;
		_tmp21_ = self->priv->end;
		if (_tmp20_ < _tmp21_) {
			gchar* _tmp22_;
			gchar _tmp23_;
			_tmp22_ = self->priv->current;
			_tmp23_ = _tmp22_[0];
			_tmp19_ = _tmp23_ == '\\';
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			gchar* _tmp24_;
			gchar _tmp25_;
			_tmp24_ = self->priv->current;
			_tmp25_ = _tmp24_[1];
			_tmp18_ = _tmp25_ == '\n';
		} else {
			_tmp18_ = FALSE;
		}
		if (!_tmp18_) {
			break;
		}
		_tmp26_ = self->priv->current;
		self->priv->current = _tmp26_ + 2;
		_tmp27_ = self->priv->line;
		self->priv->line = _tmp27_ + 1;
		vala_genie_scanner_skip_space_tabs (self);
	}
	while (TRUE) {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp35_;
		gint _tmp36_;
		_tmp30_ = self->priv->current;
		_tmp31_ = self->priv->end;
		if (_tmp30_ < _tmp31_) {
			gchar* _tmp32_;
			gchar _tmp33_;
			_tmp32_ = self->priv->current;
			_tmp33_ = _tmp32_[0];
			_tmp29_ = _tmp33_ == '\n';
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			gboolean _tmp34_ = FALSE;
			if (self->priv->open_parens_count > 0) {
				_tmp34_ = TRUE;
			} else {
				_tmp34_ = self->priv->open_brace_count > 0;
			}
			_tmp28_ = _tmp34_;
		} else {
			_tmp28_ = FALSE;
		}
		if (!_tmp28_) {
			break;
		}
		_tmp35_ = self->priv->current;
		self->priv->current = _tmp35_ + 1;
		_tmp36_ = self->priv->line;
		self->priv->line = _tmp36_ + 1;
		vala_genie_scanner_skip_space_tabs (self);
	}
	if (vala_genie_scanner_newline (self)) {
		_tmp39_ = self->priv->parse_started;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		ValaGenieTokenType _tmp40_;
		_tmp40_ = self->priv->last_token;
		_tmp38_ = _tmp40_ != VALA_GENIE_TOKEN_TYPE_EOL;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		ValaGenieTokenType _tmp41_;
		_tmp41_ = self->priv->last_token;
		_tmp37_ = _tmp41_ != VALA_GENIE_TOKEN_TYPE_SEMICOLON;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp42_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp42_, self->priv->line, self->priv->column);
		_tmp43_ = self->priv->current;
		vala_source_location_init (&_vala_token_end, _tmp43_, self->priv->line, self->priv->column);
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_EOL;
		result = VALA_GENIE_TOKEN_TYPE_EOL;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	while (TRUE) {
		gchar* _tmp44_;
		if (!vala_genie_scanner_skip_newlines (self)) {
			break;
		}
		_tmp44_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp44_, self->priv->line, self->priv->column);
		self->priv->current_indent_level = vala_genie_scanner_count_tabs (self);
		if (self->priv->current_indent_level == -1) {
			continue;
		}
		if (self->priv->current_indent_level > self->priv->indent_level) {
			gchar* _tmp45_;
			self->priv->indent_level = self->priv->current_indent_level;
			_tmp45_ = self->priv->current;
			vala_source_location_init (&_vala_token_end, _tmp45_, self->priv->line, self->priv->column);
			self->priv->last_token = VALA_GENIE_TOKEN_TYPE_INDENT;
			result = VALA_GENIE_TOKEN_TYPE_INDENT;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			if (self->priv->current_indent_level < self->priv->indent_level) {
				gint _tmp46_;
				gchar* _tmp47_;
				_tmp46_ = self->priv->indent_level;
				self->priv->indent_level = _tmp46_ - 1;
				self->priv->pending_dedents = self->priv->indent_level - self->priv->current_indent_level;
				_tmp47_ = self->priv->current;
				vala_source_location_init (&_vala_token_end, _tmp47_, self->priv->line, self->priv->column);
				self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
				result = VALA_GENIE_TOKEN_TYPE_DEDENT;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	_tmp48_ = self->priv->current;
	begin = _tmp48_;
	_tmp49_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp49_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	self->priv->parse_started = TRUE;
	_tmp50_ = self->priv->current;
	_tmp51_ = self->priv->end;
	if (_tmp50_ >= _tmp51_) {
		if (self->priv->indent_level > 0) {
			gint _tmp52_;
			_tmp52_ = self->priv->indent_level;
			self->priv->indent_level = _tmp52_ - 1;
			self->priv->pending_dedents = self->priv->indent_level;
			type = VALA_GENIE_TOKEN_TYPE_DEDENT;
		} else {
			type = VALA_GENIE_TOKEN_TYPE_EOF;
		}
	} else {
		gboolean _tmp53_ = FALSE;
		gchar* _tmp54_;
		gchar _tmp55_;
		_tmp54_ = self->priv->current;
		_tmp55_ = _tmp54_[0];
		if (g_ascii_isalpha (_tmp55_)) {
			_tmp53_ = TRUE;
		} else {
			gchar* _tmp56_;
			gchar _tmp57_;
			_tmp56_ = self->priv->current;
			_tmp57_ = _tmp56_[0];
			_tmp53_ = _tmp57_ == '_';
		}
		if (_tmp53_) {
			gint len = 0;
			gchar* _tmp65_;
			len = 0;
			while (TRUE) {
				gboolean _tmp58_ = FALSE;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp63_;
				gint _tmp64_;
				_tmp59_ = self->priv->current;
				_tmp60_ = self->priv->end;
				if (_tmp59_ < _tmp60_) {
					gchar* _tmp61_;
					gchar _tmp62_;
					_tmp61_ = self->priv->current;
					_tmp62_ = _tmp61_[0];
					_tmp58_ = vala_genie_scanner_is_ident_char (self, _tmp62_);
				} else {
					_tmp58_ = FALSE;
				}
				if (!_tmp58_) {
					break;
				}
				_tmp63_ = self->priv->current;
				self->priv->current = _tmp63_ + 1;
				_tmp64_ = len;
				len = _tmp64_ + 1;
			}
			_tmp65_ = begin;
			type = vala_genie_scanner_get_identifier_or_keyword (_tmp65_, len);
		} else {
			gchar* _tmp66_;
			gchar _tmp67_;
			_tmp66_ = self->priv->current;
			_tmp67_ = _tmp66_[0];
			if (_tmp67_ == '@') {
				gboolean _tmp68_ = FALSE;
				gchar* _tmp69_;
				gchar* _tmp70_;
				_tmp69_ = self->priv->current;
				_tmp70_ = self->priv->end;
				if (_tmp69_ < (_tmp70_ - 1)) {
					gchar* _tmp71_;
					gchar _tmp72_;
					_tmp71_ = self->priv->current;
					_tmp72_ = _tmp71_[1];
					_tmp68_ = _tmp72_ == '"';
				} else {
					_tmp68_ = FALSE;
				}
				if (_tmp68_) {
					gchar* _tmp73_;
					ValaGenieScannerState* _tmp74_;
					gint _tmp74__length1;
					type = VALA_GENIE_TOKEN_TYPE_OPEN_TEMPLATE;
					_tmp73_ = self->priv->current;
					self->priv->current = _tmp73_ + 2;
					_tmp74_ = self->priv->state_stack;
					_tmp74__length1 = self->priv->state_stack_length1;
					_vala_array_add6 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE);
				} else {
					gchar* _tmp75_;
					gchar* _tmp76_;
					gint len = 0;
					_tmp75_ = _vala_token_begin.pos;
					_vala_token_begin.pos = _tmp75_ + 1;
					_tmp76_ = self->priv->current;
					self->priv->current = _tmp76_ + 1;
					len = 0;
					while (TRUE) {
						gboolean _tmp77_ = FALSE;
						gchar* _tmp78_;
						gchar* _tmp79_;
						gchar* _tmp82_;
						gint _tmp83_;
						_tmp78_ = self->priv->current;
						_tmp79_ = self->priv->end;
						if (_tmp78_ < _tmp79_) {
							gchar* _tmp80_;
							gchar _tmp81_;
							_tmp80_ = self->priv->current;
							_tmp81_ = _tmp80_[0];
							_tmp77_ = vala_genie_scanner_is_ident_char (self, _tmp81_);
						} else {
							_tmp77_ = FALSE;
						}
						if (!_tmp77_) {
							break;
						}
						_tmp82_ = self->priv->current;
						self->priv->current = _tmp82_ + 1;
						_tmp83_ = len;
						len = _tmp83_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gchar* _tmp84_;
				gchar _tmp85_;
				_tmp84_ = self->priv->current;
				_tmp85_ = _tmp84_[0];
				if (g_ascii_isdigit (_tmp85_)) {
					gboolean _tmp92_ = FALSE;
					gchar* _tmp93_;
					gchar* _tmp94_;
					while (TRUE) {
						gboolean _tmp86_ = FALSE;
						gchar* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp91_;
						_tmp87_ = self->priv->current;
						_tmp88_ = self->priv->end;
						if (_tmp87_ < _tmp88_) {
							gchar* _tmp89_;
							gchar _tmp90_;
							_tmp89_ = self->priv->current;
							_tmp90_ = _tmp89_[0];
							_tmp86_ = g_ascii_isdigit (_tmp90_);
						} else {
							_tmp86_ = FALSE;
						}
						if (!_tmp86_) {
							break;
						}
						_tmp91_ = self->priv->current;
						self->priv->current = _tmp91_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL;
					_tmp93_ = self->priv->current;
					_tmp94_ = self->priv->end;
					if (_tmp93_ < _tmp94_) {
						gchar* _tmp95_;
						gchar _tmp96_;
						_tmp95_ = self->priv->current;
						_tmp96_ = _tmp95_[0];
						_tmp92_ = g_ascii_tolower (_tmp96_) == 'l';
					} else {
						_tmp92_ = FALSE;
					}
					if (_tmp92_) {
						gchar* _tmp97_;
						gboolean _tmp98_ = FALSE;
						gchar* _tmp99_;
						gchar* _tmp100_;
						_tmp97_ = self->priv->current;
						self->priv->current = _tmp97_ + 1;
						_tmp99_ = self->priv->current;
						_tmp100_ = self->priv->end;
						if (_tmp99_ < _tmp100_) {
							gchar* _tmp101_;
							gchar _tmp102_;
							_tmp101_ = self->priv->current;
							_tmp102_ = _tmp101_[0];
							_tmp98_ = g_ascii_tolower (_tmp102_) == 'l';
						} else {
							_tmp98_ = FALSE;
						}
						if (_tmp98_) {
							gchar* _tmp103_;
							_tmp103_ = self->priv->current;
							self->priv->current = _tmp103_ + 1;
						}
					} else {
						gboolean _tmp104_ = FALSE;
						gchar* _tmp105_;
						gchar* _tmp106_;
						_tmp105_ = self->priv->current;
						_tmp106_ = self->priv->end;
						if (_tmp105_ < _tmp106_) {
							gchar* _tmp107_;
							gchar _tmp108_;
							_tmp107_ = self->priv->current;
							_tmp108_ = _tmp107_[0];
							_tmp104_ = g_ascii_tolower (_tmp108_) == 'u';
						} else {
							_tmp104_ = FALSE;
						}
						if (_tmp104_) {
							gchar* _tmp109_;
							gboolean _tmp110_ = FALSE;
							gchar* _tmp111_;
							gchar* _tmp112_;
							_tmp109_ = self->priv->current;
							self->priv->current = _tmp109_ + 1;
							_tmp111_ = self->priv->current;
							_tmp112_ = self->priv->end;
							if (_tmp111_ < _tmp112_) {
								gchar* _tmp113_;
								gchar _tmp114_;
								_tmp113_ = self->priv->current;
								_tmp114_ = _tmp113_[0];
								_tmp110_ = g_ascii_tolower (_tmp114_) == 'l';
							} else {
								_tmp110_ = FALSE;
							}
							if (_tmp110_) {
								gchar* _tmp115_;
								gboolean _tmp116_ = FALSE;
								gchar* _tmp117_;
								gchar* _tmp118_;
								_tmp115_ = self->priv->current;
								self->priv->current = _tmp115_ + 1;
								_tmp117_ = self->priv->current;
								_tmp118_ = self->priv->end;
								if (_tmp117_ < _tmp118_) {
									gchar* _tmp119_;
									gchar _tmp120_;
									_tmp119_ = self->priv->current;
									_tmp120_ = _tmp119_[0];
									_tmp116_ = g_ascii_tolower (_tmp120_) == 'l';
								} else {
									_tmp116_ = FALSE;
								}
								if (_tmp116_) {
									gchar* _tmp121_;
									_tmp121_ = self->priv->current;
									self->priv->current = _tmp121_ + 1;
								}
							}
						} else {
							gboolean _tmp122_ = FALSE;
							gboolean _tmp123_ = FALSE;
							gchar* _tmp124_;
							gchar* _tmp125_;
							_tmp124_ = self->priv->current;
							_tmp125_ = self->priv->end;
							if (_tmp124_ < (_tmp125_ - 1)) {
								gchar* _tmp126_;
								gchar _tmp127_;
								_tmp126_ = self->priv->current;
								_tmp127_ = _tmp126_[0];
								_tmp123_ = _tmp127_ == '.';
							} else {
								_tmp123_ = FALSE;
							}
							if (_tmp123_) {
								gchar* _tmp128_;
								gchar _tmp129_;
								_tmp128_ = self->priv->current;
								_tmp129_ = _tmp128_[1];
								_tmp122_ = g_ascii_isdigit (_tmp129_);
							} else {
								_tmp122_ = FALSE;
							}
							if (_tmp122_) {
								gchar* _tmp130_;
								gboolean _tmp137_ = FALSE;
								gchar* _tmp138_;
								gchar* _tmp139_;
								gboolean _tmp158_ = FALSE;
								gchar* _tmp159_;
								gchar* _tmp160_;
								_tmp130_ = self->priv->current;
								self->priv->current = _tmp130_ + 1;
								while (TRUE) {
									gboolean _tmp131_ = FALSE;
									gchar* _tmp132_;
									gchar* _tmp133_;
									gchar* _tmp136_;
									_tmp132_ = self->priv->current;
									_tmp133_ = self->priv->end;
									if (_tmp132_ < _tmp133_) {
										gchar* _tmp134_;
										gchar _tmp135_;
										_tmp134_ = self->priv->current;
										_tmp135_ = _tmp134_[0];
										_tmp131_ = g_ascii_isdigit (_tmp135_);
									} else {
										_tmp131_ = FALSE;
									}
									if (!_tmp131_) {
										break;
									}
									_tmp136_ = self->priv->current;
									self->priv->current = _tmp136_ + 1;
								}
								_tmp138_ = self->priv->current;
								_tmp139_ = self->priv->end;
								if (_tmp138_ < _tmp139_) {
									gchar* _tmp140_;
									gchar _tmp141_;
									_tmp140_ = self->priv->current;
									_tmp141_ = _tmp140_[0];
									_tmp137_ = g_ascii_tolower (_tmp141_) == 'e';
								} else {
									_tmp137_ = FALSE;
								}
								if (_tmp137_) {
									gchar* _tmp142_;
									gboolean _tmp143_ = FALSE;
									gchar* _tmp144_;
									gchar* _tmp145_;
									_tmp142_ = self->priv->current;
									self->priv->current = _tmp142_ + 1;
									_tmp144_ = self->priv->current;
									_tmp145_ = self->priv->end;
									if (_tmp144_ < _tmp145_) {
										gboolean _tmp146_ = FALSE;
										gchar* _tmp147_;
										gchar _tmp148_;
										_tmp147_ = self->priv->current;
										_tmp148_ = _tmp147_[0];
										if (_tmp148_ == '+') {
											_tmp146_ = TRUE;
										} else {
											gchar* _tmp149_;
											gchar _tmp150_;
											_tmp149_ = self->priv->current;
											_tmp150_ = _tmp149_[0];
											_tmp146_ = _tmp150_ == '-';
										}
										_tmp143_ = _tmp146_;
									} else {
										_tmp143_ = FALSE;
									}
									if (_tmp143_) {
										gchar* _tmp151_;
										_tmp151_ = self->priv->current;
										self->priv->current = _tmp151_ + 1;
									}
									while (TRUE) {
										gboolean _tmp152_ = FALSE;
										gchar* _tmp153_;
										gchar* _tmp154_;
										gchar* _tmp157_;
										_tmp153_ = self->priv->current;
										_tmp154_ = self->priv->end;
										if (_tmp153_ < _tmp154_) {
											gchar* _tmp155_;
											gchar _tmp156_;
											_tmp155_ = self->priv->current;
											_tmp156_ = _tmp155_[0];
											_tmp152_ = g_ascii_isdigit (_tmp156_);
										} else {
											_tmp152_ = FALSE;
										}
										if (!_tmp152_) {
											break;
										}
										_tmp157_ = self->priv->current;
										self->priv->current = _tmp157_ + 1;
									}
								}
								_tmp159_ = self->priv->current;
								_tmp160_ = self->priv->end;
								if (_tmp159_ < _tmp160_) {
									gchar* _tmp161_;
									gchar _tmp162_;
									_tmp161_ = self->priv->current;
									_tmp162_ = _tmp161_[0];
									_tmp158_ = g_ascii_tolower (_tmp162_) == 'f';
								} else {
									_tmp158_ = FALSE;
								}
								if (_tmp158_) {
									gchar* _tmp163_;
									_tmp163_ = self->priv->current;
									self->priv->current = _tmp163_ + 1;
								}
								type = VALA_GENIE_TOKEN_TYPE_REAL_LITERAL;
							} else {
								gboolean _tmp164_ = FALSE;
								gboolean _tmp165_ = FALSE;
								gboolean _tmp166_ = FALSE;
								gboolean _tmp167_ = FALSE;
								gchar* _tmp168_;
								gchar* _tmp169_;
								_tmp168_ = self->priv->current;
								_tmp169_ = self->priv->end;
								if (_tmp168_ < _tmp169_) {
									gchar* _tmp170_;
									gchar* _tmp171_;
									_tmp170_ = self->priv->current;
									_tmp171_ = begin;
									_tmp167_ = _tmp170_ == (_tmp171_ + 1);
								} else {
									_tmp167_ = FALSE;
								}
								if (_tmp167_) {
									gchar* _tmp172_;
									gchar _tmp173_;
									_tmp172_ = begin;
									_tmp173_ = _tmp172_[0];
									_tmp166_ = _tmp173_ == '0';
								} else {
									_tmp166_ = FALSE;
								}
								if (_tmp166_) {
									gchar* _tmp174_;
									gchar _tmp175_;
									_tmp174_ = begin;
									_tmp175_ = _tmp174_[1];
									_tmp165_ = _tmp175_ == 'x';
								} else {
									_tmp165_ = FALSE;
								}
								if (_tmp165_) {
									gchar* _tmp176_;
									gchar _tmp177_;
									_tmp176_ = begin;
									_tmp177_ = _tmp176_[2];
									_tmp164_ = g_ascii_isxdigit (_tmp177_);
								} else {
									_tmp164_ = FALSE;
								}
								if (_tmp164_) {
									gchar* _tmp178_;
									_tmp178_ = self->priv->current;
									self->priv->current = _tmp178_ + 1;
									while (TRUE) {
										gboolean _tmp179_ = FALSE;
										gchar* _tmp180_;
										gchar* _tmp181_;
										gchar* _tmp184_;
										_tmp180_ = self->priv->current;
										_tmp181_ = self->priv->end;
										if (_tmp180_ < _tmp181_) {
											gchar* _tmp182_;
											gchar _tmp183_;
											_tmp182_ = self->priv->current;
											_tmp183_ = _tmp182_[0];
											_tmp179_ = g_ascii_isxdigit (_tmp183_);
										} else {
											_tmp179_ = FALSE;
										}
										if (!_tmp179_) {
											break;
										}
										_tmp184_ = self->priv->current;
										self->priv->current = _tmp184_ + 1;
									}
								} else {
									gboolean _tmp185_ = FALSE;
									gchar* _tmp186_;
									gchar* _tmp187_;
									_tmp186_ = self->priv->current;
									_tmp187_ = self->priv->end;
									if (_tmp186_ < _tmp187_) {
										gchar* _tmp188_;
										gchar _tmp189_;
										_tmp188_ = self->priv->current;
										_tmp189_ = _tmp188_[0];
										_tmp185_ = vala_genie_scanner_is_ident_char (self, _tmp189_);
									} else {
										_tmp185_ = FALSE;
									}
									if (_tmp185_) {
										while (TRUE) {
											gboolean _tmp190_ = FALSE;
											gchar* _tmp191_;
											gchar* _tmp192_;
											gchar* _tmp195_;
											_tmp191_ = self->priv->current;
											_tmp192_ = self->priv->end;
											if (_tmp191_ < _tmp192_) {
												gchar* _tmp193_;
												gchar _tmp194_;
												_tmp193_ = self->priv->current;
												_tmp194_ = _tmp193_[0];
												_tmp190_ = vala_genie_scanner_is_ident_char (self, _tmp194_);
											} else {
												_tmp190_ = FALSE;
											}
											if (!_tmp190_) {
												break;
											}
											_tmp195_ = self->priv->current;
											self->priv->current = _tmp195_ + 1;
										}
										type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
									}
								}
							}
						}
					}
				} else {
					gchar* _tmp196_;
					gchar _tmp197_;
					_tmp196_ = self->priv->current;
					_tmp197_ = _tmp196_[0];
					switch (_tmp197_) {
						case '{':
						{
							gint _tmp198_;
							ValaGenieScannerState* _tmp199_;
							gint _tmp199__length1;
							gchar* _tmp200_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACE;
							_tmp198_ = self->priv->open_brace_count;
							self->priv->open_brace_count = _tmp198_ + 1;
							_tmp199_ = self->priv->state_stack;
							_tmp199__length1 = self->priv->state_stack_length1;
							_vala_array_add7 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_BRACE);
							_tmp200_ = self->priv->current;
							self->priv->current = _tmp200_ + 1;
							break;
						}
						case '}':
						{
							gint _tmp201_;
							ValaGenieScannerState* _tmp202_;
							gint _tmp202__length1;
							gchar* _tmp204_;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE;
							_tmp201_ = self->priv->open_brace_count;
							self->priv->open_brace_count = _tmp201_ - 1;
							_tmp202_ = self->priv->state_stack;
							_tmp202__length1 = self->priv->state_stack_length1;
							if (_tmp202__length1 > 0) {
								gint _tmp203_;
								_tmp203_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp203_ - 1;
							}
							_tmp204_ = self->priv->current;
							self->priv->current = _tmp204_ + 1;
							break;
						}
						case '(':
						{
							gint _tmp205_;
							ValaGenieScannerState* _tmp206_;
							gint _tmp206__length1;
							gchar* _tmp207_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_PARENS;
							_tmp205_ = self->priv->open_parens_count;
							self->priv->open_parens_count = _tmp205_ + 1;
							_tmp206_ = self->priv->state_stack;
							_tmp206__length1 = self->priv->state_stack_length1;
							_vala_array_add8 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_PARENS);
							_tmp207_ = self->priv->current;
							self->priv->current = _tmp207_ + 1;
							break;
						}
						case ')':
						{
							gint _tmp208_;
							gchar* _tmp209_;
							ValaGenieScannerState* _tmp210_;
							gint _tmp210__length1;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS;
							_tmp208_ = self->priv->open_parens_count;
							self->priv->open_parens_count = _tmp208_ - 1;
							_tmp209_ = self->priv->current;
							self->priv->current = _tmp209_ + 1;
							_tmp210_ = self->priv->state_stack;
							_tmp210__length1 = self->priv->state_stack_length1;
							if (_tmp210__length1 > 0) {
								gint _tmp211_;
								_tmp211_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp211_ - 1;
							}
							if (vala_genie_scanner_in_template (self)) {
								type = VALA_GENIE_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							ValaGenieScannerState* _tmp212_;
							gint _tmp212__length1;
							gchar* _tmp213_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET;
							_tmp212_ = self->priv->state_stack;
							_tmp212__length1 = self->priv->state_stack_length1;
							_vala_array_add9 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_BRACKET);
							_tmp213_ = self->priv->current;
							self->priv->current = _tmp213_ + 1;
							break;
						}
						case ']':
						{
							ValaGenieScannerState* _tmp214_;
							gint _tmp214__length1;
							gchar* _tmp216_;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
							_tmp214_ = self->priv->state_stack;
							_tmp214__length1 = self->priv->state_stack_length1;
							if (_tmp214__length1 > 0) {
								gint _tmp215_;
								_tmp215_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp215_ - 1;
							}
							_tmp216_ = self->priv->current;
							self->priv->current = _tmp216_ + 1;
							break;
						}
						case '.':
						{
							gchar* _tmp217_;
							gchar* _tmp218_;
							gchar* _tmp219_;
							type = VALA_GENIE_TOKEN_TYPE_DOT;
							_tmp217_ = self->priv->current;
							self->priv->current = _tmp217_ + 1;
							_tmp218_ = self->priv->current;
							_tmp219_ = self->priv->end;
							if (_tmp218_ < (_tmp219_ - 1)) {
								gboolean _tmp220_ = FALSE;
								gchar* _tmp221_;
								gchar _tmp222_;
								_tmp221_ = self->priv->current;
								_tmp222_ = _tmp221_[0];
								if (_tmp222_ == '.') {
									gchar* _tmp223_;
									gchar _tmp224_;
									_tmp223_ = self->priv->current;
									_tmp224_ = _tmp223_[1];
									_tmp220_ = _tmp224_ == '.';
								} else {
									_tmp220_ = FALSE;
								}
								if (_tmp220_) {
									gchar* _tmp225_;
									type = VALA_GENIE_TOKEN_TYPE_ELLIPSIS;
									_tmp225_ = self->priv->current;
									self->priv->current = _tmp225_ + 2;
								}
							}
							break;
						}
						case ':':
						{
							gchar* _tmp226_;
							type = VALA_GENIE_TOKEN_TYPE_COLON;
							_tmp226_ = self->priv->current;
							self->priv->current = _tmp226_ + 1;
							break;
						}
						case ',':
						{
							gchar* _tmp227_;
							type = VALA_GENIE_TOKEN_TYPE_COMMA;
							_tmp227_ = self->priv->current;
							self->priv->current = _tmp227_ + 1;
							break;
						}
						case ';':
						{
							gchar* _tmp228_;
							type = VALA_GENIE_TOKEN_TYPE_SEMICOLON;
							_tmp228_ = self->priv->current;
							self->priv->current = _tmp228_ + 1;
							break;
						}
						case '#':
						{
							gchar* _tmp229_;
							type = VALA_GENIE_TOKEN_TYPE_HASH;
							_tmp229_ = self->priv->current;
							self->priv->current = _tmp229_ + 1;
							break;
						}
						case '?':
						{
							gchar* _tmp230_;
							type = VALA_GENIE_TOKEN_TYPE_INTERR;
							_tmp230_ = self->priv->current;
							self->priv->current = _tmp230_ + 1;
							break;
						}
						case '|':
						{
							gchar* _tmp231_;
							gchar* _tmp232_;
							gchar* _tmp233_;
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_OR;
							_tmp231_ = self->priv->current;
							self->priv->current = _tmp231_ + 1;
							_tmp232_ = self->priv->current;
							_tmp233_ = self->priv->end;
							if (_tmp232_ < _tmp233_) {
								gchar* _tmp234_;
								gchar _tmp235_;
								_tmp234_ = self->priv->current;
								_tmp235_ = _tmp234_[0];
								switch (_tmp235_) {
									case '=':
									{
										gchar* _tmp236_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										_tmp236_ = self->priv->current;
										self->priv->current = _tmp236_ + 1;
										break;
									}
									case '|':
									{
										gchar* _tmp237_;
										type = VALA_GENIE_TOKEN_TYPE_OP_OR;
										_tmp237_ = self->priv->current;
										self->priv->current = _tmp237_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							gchar* _tmp238_;
							gchar* _tmp239_;
							gchar* _tmp240_;
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_AND;
							_tmp238_ = self->priv->current;
							self->priv->current = _tmp238_ + 1;
							_tmp239_ = self->priv->current;
							_tmp240_ = self->priv->end;
							if (_tmp239_ < _tmp240_) {
								gchar* _tmp241_;
								gchar _tmp242_;
								_tmp241_ = self->priv->current;
								_tmp242_ = _tmp241_[0];
								switch (_tmp242_) {
									case '=':
									{
										gchar* _tmp243_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										_tmp243_ = self->priv->current;
										self->priv->current = _tmp243_ + 1;
										break;
									}
									case '&':
									{
										gchar* _tmp244_;
										type = VALA_GENIE_TOKEN_TYPE_OP_AND;
										_tmp244_ = self->priv->current;
										self->priv->current = _tmp244_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gchar* _tmp245_;
							gboolean _tmp246_ = FALSE;
							gchar* _tmp247_;
							gchar* _tmp248_;
							type = VALA_GENIE_TOKEN_TYPE_CARRET;
							_tmp245_ = self->priv->current;
							self->priv->current = _tmp245_ + 1;
							_tmp247_ = self->priv->current;
							_tmp248_ = self->priv->end;
							if (_tmp247_ < _tmp248_) {
								gchar* _tmp249_;
								gchar _tmp250_;
								_tmp249_ = self->priv->current;
								_tmp250_ = _tmp249_[0];
								_tmp246_ = _tmp250_ == '=';
							} else {
								_tmp246_ = FALSE;
							}
							if (_tmp246_) {
								gchar* _tmp251_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								_tmp251_ = self->priv->current;
								self->priv->current = _tmp251_ + 1;
							}
							break;
						}
						case '~':
						{
							gchar* _tmp252_;
							type = VALA_GENIE_TOKEN_TYPE_TILDE;
							_tmp252_ = self->priv->current;
							self->priv->current = _tmp252_ + 1;
							break;
						}
						case '=':
						{
							gchar* _tmp253_;
							gchar* _tmp254_;
							gchar* _tmp255_;
							type = VALA_GENIE_TOKEN_TYPE_ASSIGN;
							_tmp253_ = self->priv->current;
							self->priv->current = _tmp253_ + 1;
							_tmp254_ = self->priv->current;
							_tmp255_ = self->priv->end;
							if (_tmp254_ < _tmp255_) {
								gchar* _tmp256_;
								gchar _tmp257_;
								_tmp256_ = self->priv->current;
								_tmp257_ = _tmp256_[0];
								switch (_tmp257_) {
									case '=':
									{
										gchar* _tmp258_;
										type = VALA_GENIE_TOKEN_TYPE_OP_EQ;
										_tmp258_ = self->priv->current;
										self->priv->current = _tmp258_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp259_;
										type = VALA_GENIE_TOKEN_TYPE_LAMBDA;
										_tmp259_ = self->priv->current;
										self->priv->current = _tmp259_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							gchar* _tmp260_;
							gchar* _tmp261_;
							gchar* _tmp262_;
							type = VALA_GENIE_TOKEN_TYPE_OP_LT;
							_tmp260_ = self->priv->current;
							self->priv->current = _tmp260_ + 1;
							_tmp261_ = self->priv->current;
							_tmp262_ = self->priv->end;
							if (_tmp261_ < _tmp262_) {
								gchar* _tmp263_;
								gchar _tmp264_;
								_tmp263_ = self->priv->current;
								_tmp264_ = _tmp263_[0];
								switch (_tmp264_) {
									case '=':
									{
										gchar* _tmp265_;
										type = VALA_GENIE_TOKEN_TYPE_OP_LE;
										_tmp265_ = self->priv->current;
										self->priv->current = _tmp265_ + 1;
										break;
									}
									case '<':
									{
										gchar* _tmp266_;
										gboolean _tmp267_ = FALSE;
										gchar* _tmp268_;
										gchar* _tmp269_;
										type = VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT;
										_tmp266_ = self->priv->current;
										self->priv->current = _tmp266_ + 1;
										_tmp268_ = self->priv->current;
										_tmp269_ = self->priv->end;
										if (_tmp268_ < _tmp269_) {
											gchar* _tmp270_;
											gchar _tmp271_;
											_tmp270_ = self->priv->current;
											_tmp271_ = _tmp270_[0];
											_tmp267_ = _tmp271_ == '=';
										} else {
											_tmp267_ = FALSE;
										}
										if (_tmp267_) {
											gchar* _tmp272_;
											type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											_tmp272_ = self->priv->current;
											self->priv->current = _tmp272_ + 1;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gchar* _tmp273_;
							gboolean _tmp274_ = FALSE;
							gchar* _tmp275_;
							gchar* _tmp276_;
							type = VALA_GENIE_TOKEN_TYPE_OP_GT;
							_tmp273_ = self->priv->current;
							self->priv->current = _tmp273_ + 1;
							_tmp275_ = self->priv->current;
							_tmp276_ = self->priv->end;
							if (_tmp275_ < _tmp276_) {
								gchar* _tmp277_;
								gchar _tmp278_;
								_tmp277_ = self->priv->current;
								_tmp278_ = _tmp277_[0];
								_tmp274_ = _tmp278_ == '=';
							} else {
								_tmp274_ = FALSE;
							}
							if (_tmp274_) {
								gchar* _tmp279_;
								type = VALA_GENIE_TOKEN_TYPE_OP_GE;
								_tmp279_ = self->priv->current;
								self->priv->current = _tmp279_ + 1;
							}
							break;
						}
						case '!':
						{
							gchar* _tmp280_;
							gboolean _tmp281_ = FALSE;
							gchar* _tmp282_;
							gchar* _tmp283_;
							type = VALA_GENIE_TOKEN_TYPE_OP_NEG;
							_tmp280_ = self->priv->current;
							self->priv->current = _tmp280_ + 1;
							_tmp282_ = self->priv->current;
							_tmp283_ = self->priv->end;
							if (_tmp282_ < _tmp283_) {
								gchar* _tmp284_;
								gchar _tmp285_;
								_tmp284_ = self->priv->current;
								_tmp285_ = _tmp284_[0];
								_tmp281_ = _tmp285_ == '=';
							} else {
								_tmp281_ = FALSE;
							}
							if (_tmp281_) {
								gchar* _tmp286_;
								type = VALA_GENIE_TOKEN_TYPE_OP_NE;
								_tmp286_ = self->priv->current;
								self->priv->current = _tmp286_ + 1;
							}
							break;
						}
						case '+':
						{
							gchar* _tmp287_;
							gchar* _tmp288_;
							gchar* _tmp289_;
							type = VALA_GENIE_TOKEN_TYPE_PLUS;
							_tmp287_ = self->priv->current;
							self->priv->current = _tmp287_ + 1;
							_tmp288_ = self->priv->current;
							_tmp289_ = self->priv->end;
							if (_tmp288_ < _tmp289_) {
								gchar* _tmp290_;
								gchar _tmp291_;
								_tmp290_ = self->priv->current;
								_tmp291_ = _tmp290_[0];
								switch (_tmp291_) {
									case '=':
									{
										gchar* _tmp292_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD;
										_tmp292_ = self->priv->current;
										self->priv->current = _tmp292_ + 1;
										break;
									}
									case '+':
									{
										gchar* _tmp293_;
										type = VALA_GENIE_TOKEN_TYPE_OP_INC;
										_tmp293_ = self->priv->current;
										self->priv->current = _tmp293_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							gchar* _tmp294_;
							gchar* _tmp295_;
							gchar* _tmp296_;
							type = VALA_GENIE_TOKEN_TYPE_MINUS;
							_tmp294_ = self->priv->current;
							self->priv->current = _tmp294_ + 1;
							_tmp295_ = self->priv->current;
							_tmp296_ = self->priv->end;
							if (_tmp295_ < _tmp296_) {
								gchar* _tmp297_;
								gchar _tmp298_;
								_tmp297_ = self->priv->current;
								_tmp298_ = _tmp297_[0];
								switch (_tmp298_) {
									case '=':
									{
										gchar* _tmp299_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB;
										_tmp299_ = self->priv->current;
										self->priv->current = _tmp299_ + 1;
										break;
									}
									case '-':
									{
										gchar* _tmp300_;
										type = VALA_GENIE_TOKEN_TYPE_OP_DEC;
										_tmp300_ = self->priv->current;
										self->priv->current = _tmp300_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp301_;
										type = VALA_GENIE_TOKEN_TYPE_OP_PTR;
										_tmp301_ = self->priv->current;
										self->priv->current = _tmp301_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gchar* _tmp302_;
							gboolean _tmp303_ = FALSE;
							gchar* _tmp304_;
							gchar* _tmp305_;
							type = VALA_GENIE_TOKEN_TYPE_STAR;
							_tmp302_ = self->priv->current;
							self->priv->current = _tmp302_ + 1;
							_tmp304_ = self->priv->current;
							_tmp305_ = self->priv->end;
							if (_tmp304_ < _tmp305_) {
								gchar* _tmp306_;
								gchar _tmp307_;
								_tmp306_ = self->priv->current;
								_tmp307_ = _tmp306_[0];
								_tmp303_ = _tmp307_ == '=';
							} else {
								_tmp303_ = FALSE;
							}
							if (_tmp303_) {
								gchar* _tmp308_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL;
								_tmp308_ = self->priv->current;
								self->priv->current = _tmp308_ + 1;
							}
							break;
						}
						case '/':
						{
							ValaGenieTokenType _tmp309_;
							_tmp309_ = self->priv->last_token;
							switch (_tmp309_) {
								case VALA_GENIE_TOKEN_TYPE_ASSIGN:
								case VALA_GENIE_TOKEN_TYPE_COMMA:
								case VALA_GENIE_TOKEN_TYPE_MINUS:
								case VALA_GENIE_TOKEN_TYPE_OP_AND:
								case VALA_GENIE_TOKEN_TYPE_OP_EQ:
								case VALA_GENIE_TOKEN_TYPE_OP_GE:
								case VALA_GENIE_TOKEN_TYPE_OP_GT:
								case VALA_GENIE_TOKEN_TYPE_OP_INC:
								case VALA_GENIE_TOKEN_TYPE_OP_LE:
								case VALA_GENIE_TOKEN_TYPE_OP_LT:
								case VALA_GENIE_TOKEN_TYPE_OP_NE:
								case VALA_GENIE_TOKEN_TYPE_OP_NEG:
								case VALA_GENIE_TOKEN_TYPE_OP_OR:
								case VALA_GENIE_TOKEN_TYPE_OPEN_BRACE:
								case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
								case VALA_GENIE_TOKEN_TYPE_PLUS:
								case VALA_GENIE_TOKEN_TYPE_RETURN:
								{
									ValaGenieScannerState* _tmp310_;
									gint _tmp310__length1;
									gchar* _tmp311_;
									type = VALA_GENIE_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_tmp310_ = self->priv->state_stack;
									_tmp310__length1 = self->priv->state_stack_length1;
									_vala_array_add10 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_REGEX_LITERAL);
									_tmp311_ = self->priv->current;
									self->priv->current = _tmp311_ + 1;
									break;
								}
								default:
								{
									gchar* _tmp312_;
									gboolean _tmp313_ = FALSE;
									gchar* _tmp314_;
									gchar* _tmp315_;
									type = VALA_GENIE_TOKEN_TYPE_DIV;
									_tmp312_ = self->priv->current;
									self->priv->current = _tmp312_ + 1;
									_tmp314_ = self->priv->current;
									_tmp315_ = self->priv->end;
									if (_tmp314_ < _tmp315_) {
										gchar* _tmp316_;
										gchar _tmp317_;
										_tmp316_ = self->priv->current;
										_tmp317_ = _tmp316_[0];
										_tmp313_ = _tmp317_ == '=';
									} else {
										_tmp313_ = FALSE;
									}
									if (_tmp313_) {
										gchar* _tmp318_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV;
										_tmp318_ = self->priv->current;
										self->priv->current = _tmp318_ + 1;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gchar* _tmp319_;
							gboolean _tmp320_ = FALSE;
							gchar* _tmp321_;
							gchar* _tmp322_;
							type = VALA_GENIE_TOKEN_TYPE_PERCENT;
							_tmp319_ = self->priv->current;
							self->priv->current = _tmp319_ + 1;
							_tmp321_ = self->priv->current;
							_tmp322_ = self->priv->end;
							if (_tmp321_ < _tmp322_) {
								gchar* _tmp323_;
								gchar _tmp324_;
								_tmp323_ = self->priv->current;
								_tmp324_ = _tmp323_[0];
								_tmp320_ = _tmp324_ == '=';
							} else {
								_tmp320_ = FALSE;
							}
							if (_tmp320_) {
								gchar* _tmp325_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT;
								_tmp325_ = self->priv->current;
								self->priv->current = _tmp325_ + 1;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gchar* _tmp326_;
							gchar _tmp327_;
							gchar* _tmp372_;
							gchar* _tmp442_;
							gchar* _tmp443_;
							_tmp326_ = begin;
							_tmp327_ = _tmp326_[0];
							if (_tmp327_ == '\'') {
								type = VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp328_ = FALSE;
								gboolean _tmp329_ = FALSE;
								gchar* _tmp330_;
								gchar* _tmp331_;
								_tmp330_ = self->priv->current;
								_tmp331_ = self->priv->end;
								if (_tmp330_ < (_tmp331_ - 6)) {
									gchar* _tmp332_;
									gchar _tmp333_;
									_tmp332_ = begin;
									_tmp333_ = _tmp332_[1];
									_tmp329_ = _tmp333_ == '"';
								} else {
									_tmp329_ = FALSE;
								}
								if (_tmp329_) {
									gchar* _tmp334_;
									gchar _tmp335_;
									_tmp334_ = begin;
									_tmp335_ = _tmp334_[2];
									_tmp328_ = _tmp335_ == '"';
								} else {
									_tmp328_ = FALSE;
								}
								if (_tmp328_) {
									gchar* _tmp336_;
									gboolean _tmp361_ = FALSE;
									gboolean _tmp362_ = FALSE;
									gchar* _tmp363_;
									gchar _tmp364_;
									type = VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									_tmp336_ = self->priv->current;
									self->priv->current = _tmp336_ + 3;
									while (TRUE) {
										gchar* _tmp337_;
										gchar* _tmp338_;
										gboolean _tmp339_ = FALSE;
										gboolean _tmp340_ = FALSE;
										gboolean _tmp341_ = FALSE;
										gchar* _tmp342_;
										gchar _tmp343_;
										_tmp337_ = self->priv->current;
										_tmp338_ = self->priv->end;
										if (!(_tmp337_ < (_tmp338_ - 4))) {
											break;
										}
										_tmp342_ = self->priv->current;
										_tmp343_ = _tmp342_[0];
										if (_tmp343_ == '"') {
											gchar* _tmp344_;
											gchar _tmp345_;
											_tmp344_ = self->priv->current;
											_tmp345_ = _tmp344_[1];
											_tmp341_ = _tmp345_ == '"';
										} else {
											_tmp341_ = FALSE;
										}
										if (_tmp341_) {
											gchar* _tmp346_;
											gchar _tmp347_;
											_tmp346_ = self->priv->current;
											_tmp347_ = _tmp346_[2];
											_tmp340_ = _tmp347_ == '"';
										} else {
											_tmp340_ = FALSE;
										}
										if (_tmp340_) {
											gchar* _tmp348_;
											gchar _tmp349_;
											_tmp348_ = self->priv->current;
											_tmp349_ = _tmp348_[3];
											_tmp339_ = _tmp349_ != '"';
										} else {
											_tmp339_ = FALSE;
										}
										if (_tmp339_) {
											break;
										} else {
											gchar* _tmp350_;
											gchar _tmp351_;
											_tmp350_ = self->priv->current;
											_tmp351_ = _tmp350_[0];
											if (_tmp351_ == '\n') {
												gchar* _tmp352_;
												gint _tmp353_;
												_tmp352_ = self->priv->current;
												self->priv->current = _tmp352_ + 1;
												_tmp353_ = self->priv->line;
												self->priv->line = _tmp353_ + 1;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar u = 0U;
												gchar* _tmp354_;
												gchar* _tmp355_;
												gchar* _tmp356_;
												_tmp354_ = self->priv->current;
												_tmp355_ = self->priv->end;
												_tmp356_ = self->priv->current;
												u = g_utf8_get_char_validated ((const gchar*) _tmp354_, (gssize) ((glong) (_tmp355_ - _tmp356_)));
												if (u != ((gunichar) -1)) {
													gchar* _tmp357_;
													gint _tmp358_;
													_tmp357_ = self->priv->current;
													self->priv->current = _tmp357_ + g_unichar_to_utf8 (u, NULL);
													_tmp358_ = token_length_in_chars;
													token_length_in_chars = _tmp358_ + 1;
												} else {
													ValaSourceReference* _tmp359_;
													ValaSourceReference* _tmp360_;
													_tmp359_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
													_tmp360_ = _tmp359_;
													vala_report_error (_tmp360_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp360_);
												}
											}
										}
									}
									_tmp363_ = self->priv->current;
									_tmp364_ = _tmp363_[0];
									if (_tmp364_ == '"') {
										gchar* _tmp365_;
										gchar _tmp366_;
										_tmp365_ = self->priv->current;
										_tmp366_ = _tmp365_[1];
										_tmp362_ = _tmp366_ == '"';
									} else {
										_tmp362_ = FALSE;
									}
									if (_tmp362_) {
										gchar* _tmp367_;
										gchar _tmp368_;
										_tmp367_ = self->priv->current;
										_tmp368_ = _tmp367_[2];
										_tmp361_ = _tmp368_ == '"';
									} else {
										_tmp361_ = FALSE;
									}
									if (_tmp361_) {
										gchar* _tmp369_;
										_tmp369_ = self->priv->current;
										self->priv->current = _tmp369_ + 3;
									} else {
										ValaSourceReference* _tmp370_;
										ValaSourceReference* _tmp371_;
										_tmp370_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp371_ = _tmp370_;
										vala_report_error (_tmp371_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp371_);
									}
									break;
								} else {
									type = VALA_GENIE_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							_tmp372_ = self->priv->current;
							self->priv->current = _tmp372_ + 1;
							while (TRUE) {
								gboolean _tmp373_ = FALSE;
								gchar* _tmp374_;
								gchar* _tmp375_;
								gchar* _tmp380_;
								gchar _tmp381_;
								gboolean _tmp432_ = FALSE;
								gboolean _tmp433_ = FALSE;
								gchar* _tmp434_;
								gchar* _tmp435_;
								_tmp374_ = self->priv->current;
								_tmp375_ = self->priv->end;
								if (_tmp374_ < _tmp375_) {
									gchar* _tmp376_;
									gchar _tmp377_;
									gchar* _tmp378_;
									gchar _tmp379_;
									_tmp376_ = self->priv->current;
									_tmp377_ = _tmp376_[0];
									_tmp378_ = begin;
									_tmp379_ = _tmp378_[0];
									_tmp373_ = _tmp377_ != _tmp379_;
								} else {
									_tmp373_ = FALSE;
								}
								if (!_tmp373_) {
									break;
								}
								_tmp380_ = self->priv->current;
								_tmp381_ = _tmp380_[0];
								if (_tmp381_ == '\\') {
									gchar* _tmp382_;
									gint _tmp383_;
									gchar* _tmp384_;
									gchar* _tmp385_;
									gchar* _tmp386_;
									gchar _tmp387_;
									_tmp382_ = self->priv->current;
									self->priv->current = _tmp382_ + 1;
									_tmp383_ = token_length_in_chars;
									token_length_in_chars = _tmp383_ + 1;
									_tmp384_ = self->priv->current;
									_tmp385_ = self->priv->end;
									if (_tmp384_ >= _tmp385_) {
										break;
									}
									_tmp386_ = self->priv->current;
									_tmp387_ = _tmp386_[0];
									switch (_tmp387_) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										case 'v':
										{
											gchar* _tmp388_;
											gint _tmp389_;
											_tmp388_ = self->priv->current;
											self->priv->current = _tmp388_ + 1;
											_tmp389_ = token_length_in_chars;
											token_length_in_chars = _tmp389_ + 1;
											break;
										}
										case 'u':
										{
											gchar* _tmp390_;
											gint _tmp391_;
											gint digit_length = 0;
											_tmp390_ = self->priv->current;
											self->priv->current = _tmp390_ + 1;
											_tmp391_ = token_length_in_chars;
											token_length_in_chars = _tmp391_ + 1;
											{
												gboolean _tmp392_ = FALSE;
												digit_length = 0;
												_tmp392_ = TRUE;
												while (TRUE) {
													gboolean _tmp394_ = FALSE;
													gboolean _tmp395_ = FALSE;
													gchar* _tmp400_;
													gint _tmp401_;
													if (!_tmp392_) {
														gint _tmp393_;
														_tmp393_ = digit_length;
														digit_length = _tmp393_ + 1;
													}
													_tmp392_ = FALSE;
													if (digit_length < 4) {
														gchar* _tmp396_;
														gchar* _tmp397_;
														_tmp396_ = self->priv->current;
														_tmp397_ = self->priv->end;
														_tmp395_ = _tmp396_ < _tmp397_;
													} else {
														_tmp395_ = FALSE;
													}
													if (_tmp395_) {
														gchar* _tmp398_;
														gchar _tmp399_;
														_tmp398_ = self->priv->current;
														_tmp399_ = _tmp398_[0];
														_tmp394_ = g_ascii_isxdigit (_tmp399_);
													} else {
														_tmp394_ = FALSE;
													}
													if (!_tmp394_) {
														break;
													}
													_tmp400_ = self->priv->current;
													self->priv->current = _tmp400_ + 1;
													_tmp401_ = token_length_in_chars;
													token_length_in_chars = _tmp401_ + 1;
												}
											}
											if (digit_length != 4) {
												ValaSourceReference* _tmp402_;
												ValaSourceReference* _tmp403_;
												_tmp402_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
												_tmp403_ = _tmp402_;
												vala_report_error (_tmp403_, "\\u requires four hex digits");
												_vala_source_reference_unref0 (_tmp403_);
											}
											break;
										}
										case 'x':
										{
											gchar* _tmp404_;
											gint _tmp405_;
											gint digit_length = 0;
											_tmp404_ = self->priv->current;
											self->priv->current = _tmp404_ + 1;
											_tmp405_ = token_length_in_chars;
											token_length_in_chars = _tmp405_ + 1;
											{
												gboolean _tmp406_ = FALSE;
												digit_length = 0;
												_tmp406_ = TRUE;
												while (TRUE) {
													gboolean _tmp408_ = FALSE;
													gboolean _tmp409_ = FALSE;
													gchar* _tmp414_;
													gint _tmp415_;
													if (!_tmp406_) {
														gint _tmp407_;
														_tmp407_ = digit_length;
														digit_length = _tmp407_ + 1;
													}
													_tmp406_ = FALSE;
													if (digit_length < 2) {
														gchar* _tmp410_;
														gchar* _tmp411_;
														_tmp410_ = self->priv->current;
														_tmp411_ = self->priv->end;
														_tmp409_ = _tmp410_ < _tmp411_;
													} else {
														_tmp409_ = FALSE;
													}
													if (_tmp409_) {
														gchar* _tmp412_;
														gchar _tmp413_;
														_tmp412_ = self->priv->current;
														_tmp413_ = _tmp412_[0];
														_tmp408_ = g_ascii_isxdigit (_tmp413_);
													} else {
														_tmp408_ = FALSE;
													}
													if (!_tmp408_) {
														break;
													}
													_tmp414_ = self->priv->current;
													self->priv->current = _tmp414_ + 1;
													_tmp415_ = token_length_in_chars;
													token_length_in_chars = _tmp415_ + 1;
												}
											}
											if (digit_length != 2) {
												ValaSourceReference* _tmp416_;
												ValaSourceReference* _tmp417_;
												_tmp416_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
												_tmp417_ = _tmp416_;
												vala_report_error (_tmp417_, "\\x requires two hex digits");
												_vala_source_reference_unref0 (_tmp417_);
											}
											break;
										}
										default:
										{
											ValaSourceReference* _tmp418_;
											ValaSourceReference* _tmp419_;
											_tmp418_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
											_tmp419_ = _tmp418_;
											vala_report_error (_tmp419_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp419_);
											break;
										}
									}
								} else {
									gchar* _tmp420_;
									gchar _tmp421_;
									_tmp420_ = self->priv->current;
									_tmp421_ = _tmp420_[0];
									if (_tmp421_ == '\n') {
										gchar* _tmp422_;
										gint _tmp423_;
										_tmp422_ = self->priv->current;
										self->priv->current = _tmp422_ + 1;
										_tmp423_ = self->priv->line;
										self->priv->line = _tmp423_ + 1;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gunichar u = 0U;
										gchar* _tmp424_;
										gchar* _tmp425_;
										gchar* _tmp426_;
										_tmp424_ = self->priv->current;
										_tmp425_ = self->priv->end;
										_tmp426_ = self->priv->current;
										u = g_utf8_get_char_validated ((const gchar*) _tmp424_, (gssize) ((glong) (_tmp425_ - _tmp426_)));
										if (u != ((gunichar) -1)) {
											gchar* _tmp427_;
											gint _tmp428_;
											_tmp427_ = self->priv->current;
											self->priv->current = _tmp427_ + g_unichar_to_utf8 (u, NULL);
											_tmp428_ = token_length_in_chars;
											token_length_in_chars = _tmp428_ + 1;
										} else {
											gchar* _tmp429_;
											ValaSourceReference* _tmp430_;
											ValaSourceReference* _tmp431_;
											_tmp429_ = self->priv->current;
											self->priv->current = _tmp429_ + 1;
											_tmp430_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
											_tmp431_ = _tmp430_;
											vala_report_error (_tmp431_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp431_);
										}
									}
								}
								_tmp434_ = self->priv->current;
								_tmp435_ = self->priv->end;
								if (_tmp434_ < _tmp435_) {
									gchar* _tmp436_;
									gchar _tmp437_;
									_tmp436_ = begin;
									_tmp437_ = _tmp436_[0];
									_tmp433_ = _tmp437_ == '\'';
								} else {
									_tmp433_ = FALSE;
								}
								if (_tmp433_) {
									gchar* _tmp438_;
									gchar _tmp439_;
									_tmp438_ = self->priv->current;
									_tmp439_ = _tmp438_[0];
									_tmp432_ = _tmp439_ != '\'';
								} else {
									_tmp432_ = FALSE;
								}
								if (_tmp432_) {
									ValaSourceReference* _tmp440_;
									ValaSourceReference* _tmp441_;
									_tmp440_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp441_ = _tmp440_;
									vala_report_error (_tmp441_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp441_);
								}
							}
							_tmp442_ = self->priv->current;
							_tmp443_ = self->priv->end;
							if (_tmp442_ < _tmp443_) {
								gchar* _tmp444_;
								_tmp444_ = self->priv->current;
								self->priv->current = _tmp444_ + 1;
							} else {
								ValaSourceReference* _tmp445_;
								ValaSourceReference* _tmp446_;
								gchar* _tmp447_;
								gchar _tmp448_;
								gchar* _tmp449_;
								gchar* _tmp450_;
								_tmp445_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp446_ = _tmp445_;
								_tmp447_ = begin;
								_tmp448_ = _tmp447_[0];
								_tmp449_ = g_strdup_printf ("syntax error, expected %c", (gint) _tmp448_);
								_tmp450_ = _tmp449_;
								vala_report_error (_tmp446_, _tmp450_);
								_g_free0 (_tmp450_);
								_vala_source_reference_unref0 (_tmp446_);
							}
							break;
						}
						default:
						{
							gunichar u = 0U;
							gchar* _tmp451_;
							gchar* _tmp452_;
							gchar* _tmp453_;
							gint _tmp460_;
							ValaSourceLocation _tmp461_ = {0};
							ValaSourceLocation _tmp462_ = {0};
							ValaGenieTokenType _tmp463_;
							_tmp451_ = self->priv->current;
							_tmp452_ = self->priv->end;
							_tmp453_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp451_, (gssize) ((glong) (_tmp452_ - _tmp453_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp454_;
								ValaSourceReference* _tmp455_;
								ValaSourceReference* _tmp456_;
								_tmp454_ = self->priv->current;
								self->priv->current = _tmp454_ + g_unichar_to_utf8 (u, NULL);
								_tmp455_ = vala_genie_scanner_get_source_reference (self, 0, 0);
								_tmp456_ = _tmp455_;
								vala_report_error (_tmp456_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp456_);
							} else {
								gchar* _tmp457_;
								ValaSourceReference* _tmp458_;
								ValaSourceReference* _tmp459_;
								_tmp457_ = self->priv->current;
								self->priv->current = _tmp457_ + 1;
								_tmp458_ = vala_genie_scanner_get_source_reference (self, 0, 0);
								_tmp459_ = _tmp458_;
								vala_report_error (_tmp459_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp459_);
							}
							_tmp460_ = self->priv->column;
							self->priv->column = _tmp460_ + 1;
							_tmp463_ = vala_genie_scanner_read_token (self, &_tmp461_, &_tmp462_);
							_vala_token_begin = _tmp461_;
							_vala_token_end = _tmp462_;
							result = _tmp463_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp464_;
		gchar* _tmp465_;
		_tmp464_ = self->priv->current;
		_tmp465_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp464_ - _tmp465_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp466_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp466_, self->priv->line, self->priv->column - 1);
	_tmp467_ = type;
	self->priv->last_token = _tmp467_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

static gint
vala_genie_scanner_count_tabs (ValaGenieScanner* self)
{
	gint result = 0;
	gint tab_count = 0;
	gboolean _tmp16_ = FALSE;
	gchar* _tmp17_;
	gchar* _tmp18_;
	g_return_val_if_fail (self != NULL, 0);
	tab_count = 0;
	if (self->priv->_indent_spaces == 0) {
		while (TRUE) {
			gboolean _tmp0_ = FALSE;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp1_ = self->priv->current;
			_tmp2_ = self->priv->end;
			if (_tmp1_ < _tmp2_) {
				gchar* _tmp3_;
				gchar _tmp4_;
				_tmp3_ = self->priv->current;
				_tmp4_ = _tmp3_[0];
				_tmp0_ = _tmp4_ == '\t';
			} else {
				_tmp0_ = FALSE;
			}
			if (!_tmp0_) {
				break;
			}
			_tmp5_ = self->priv->current;
			self->priv->current = _tmp5_ + 1;
			_tmp6_ = self->priv->column;
			self->priv->column = _tmp6_ + 1;
			_tmp7_ = tab_count;
			tab_count = _tmp7_ + 1;
		}
	} else {
		gint space_count = 0;
		space_count = 0;
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp9_ = self->priv->current;
			_tmp10_ = self->priv->end;
			if (_tmp9_ < _tmp10_) {
				gchar* _tmp11_;
				gchar _tmp12_;
				_tmp11_ = self->priv->current;
				_tmp12_ = _tmp11_[0];
				_tmp8_ = _tmp12_ == ' ';
			} else {
				_tmp8_ = FALSE;
			}
			if (!_tmp8_) {
				break;
			}
			_tmp13_ = self->priv->current;
			self->priv->current = _tmp13_ + 1;
			_tmp14_ = self->priv->column;
			self->priv->column = _tmp14_ + 1;
			_tmp15_ = space_count;
			space_count = _tmp15_ + 1;
		}
		tab_count = space_count / self->priv->_indent_spaces;
	}
	vala_genie_scanner_space (self);
	_tmp17_ = self->priv->current;
	_tmp18_ = self->priv->end;
	if (_tmp17_ < _tmp18_) {
		gchar* _tmp19_;
		gchar _tmp20_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_[0];
		_tmp16_ = _tmp20_ == '\n';
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		result = -1;
		return result;
	}
	result = tab_count;
	return result;
}

static gboolean
vala_genie_scanner_matches (gchar* begin,
                            const gchar* keyword)
{
	gboolean result = FALSE;
	gchar* keyword_array = NULL;
	glong len = 0L;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (keyword != NULL, FALSE);
	keyword_array = (gchar*) keyword;
	_tmp0_ = strlen (keyword);
	_tmp1_ = _tmp0_;
	len = (glong) _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar _tmp4_;
				gchar* _tmp5_;
				gchar _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(((glong) i) < len)) {
					break;
				}
				_tmp4_ = begin[i];
				_tmp5_ = keyword_array;
				_tmp6_ = _tmp5_[i];
				if (_tmp4_ != _tmp6_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_genie_scanner_whitespace (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean found = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp0_ = _tmp7_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	if (self->priv->column == 1) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = self->priv->current;
		_tmp13_ = self->priv->end;
		_tmp11_ = _tmp12_ < _tmp13_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* _tmp14_;
		gchar _tmp15_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_[0];
		_tmp10_ = _tmp15_ == '#';
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		vala_genie_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}

static inline gboolean
vala_genie_scanner_newline (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = _tmp0_[0];
	if (_tmp1_ == '\n') {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_genie_scanner_skip_newlines (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean new_lines = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	new_lines = FALSE;
	while (TRUE) {
		gchar* _tmp0_;
		gint _tmp1_;
		if (!vala_genie_scanner_newline (self)) {
			break;
		}
		_tmp0_ = self->priv->current;
		self->priv->current = _tmp0_ + 1;
		_tmp1_ = self->priv->line;
		self->priv->line = _tmp1_ + 1;
		self->priv->column = 1;
		self->priv->current_indent_level = 0;
		new_lines = TRUE;
	}
	result = new_lines;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
vala_genie_scanner_comment (ValaGenieScanner* self,
                            gboolean file_comment)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp13_;
	gchar _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		_tmp2_ = _tmp4_ > (_tmp5_ - 2);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		_tmp1_ = _tmp7_ != '/';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[1];
		if (_tmp10_ != '/') {
			gchar* _tmp11_;
			gchar _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = _tmp11_[1];
			_tmp8_ = _tmp12_ != '*';
		} else {
			_tmp8_ = FALSE;
		}
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_[1];
	if (_tmp14_ == '/') {
		ValaSourceReference* source_reference = NULL;
		gchar* _tmp16_;
		gboolean _tmp23_ = FALSE;
		gchar* _tmp24_;
		gchar _tmp25_;
		ValaSourceReference* _tmp29_;
		source_reference = NULL;
		if (file_comment) {
			ValaSourceReference* _tmp15_;
			_tmp15_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp15_;
		}
		_tmp16_ = self->priv->current;
		self->priv->current = _tmp16_ + 2;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp22_;
			_tmp18_ = self->priv->current;
			_tmp19_ = self->priv->end;
			if (_tmp18_ < _tmp19_) {
				gchar* _tmp20_;
				gchar _tmp21_;
				_tmp20_ = self->priv->current;
				_tmp21_ = _tmp20_[0];
				_tmp17_ = _tmp21_ != '\n';
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			_tmp22_ = self->priv->current;
			self->priv->current = _tmp22_ + 1;
		}
		_tmp24_ = self->priv->current;
		_tmp25_ = _tmp24_[0];
		if (_tmp25_ == '\n') {
			ValaGenieTokenType _tmp26_;
			_tmp26_ = self->priv->last_token;
			_tmp23_ = _tmp26_ == VALA_GENIE_TOKEN_TYPE_EOL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			gchar* _tmp27_;
			gint _tmp28_;
			_tmp27_ = self->priv->current;
			self->priv->current = _tmp27_ + 1;
			_tmp28_ = self->priv->line;
			self->priv->line = _tmp28_ + 1;
			self->priv->column = 1;
			self->priv->current_indent_level = 0;
		}
		_tmp29_ = source_reference;
		if (_tmp29_ != NULL) {
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaSourceReference* _tmp35_;
			_tmp30_ = self->priv->begin;
			_tmp31_ = self->priv->current;
			_tmp32_ = self->priv->begin;
			_tmp33_ = string_substring ((const gchar*) _tmp30_, (glong) 0, (glong) (_tmp31_ - _tmp32_));
			_tmp34_ = _tmp33_;
			_tmp35_ = source_reference;
			vala_genie_scanner_push_comment (self, _tmp34_, _tmp35_, file_comment);
			_g_free0 (_tmp34_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference = NULL;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gchar* _tmp40_;
		gchar _tmp41_;
		gchar* _tmp43_;
		gchar* begin = NULL;
		gchar* _tmp44_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		ValaSourceReference* _tmp62_;
		gchar* _tmp69_;
		source_reference = NULL;
		if (file_comment) {
			gchar* _tmp37_;
			gchar _tmp38_;
			_tmp37_ = self->priv->current;
			_tmp38_ = _tmp37_[2];
			_tmp36_ = _tmp38_ == '*';
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp40_ = self->priv->current;
		_tmp41_ = _tmp40_[2];
		if (_tmp41_ == '*') {
			_tmp39_ = TRUE;
		} else {
			_tmp39_ = file_comment;
		}
		if (_tmp39_) {
			ValaSourceReference* _tmp42_;
			_tmp42_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp42_;
		}
		_tmp43_ = self->priv->current;
		self->priv->current = _tmp43_ + 2;
		_tmp44_ = self->priv->current;
		begin = _tmp44_;
		while (TRUE) {
			gboolean _tmp45_ = FALSE;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp53_;
			gchar _tmp54_;
			gchar* _tmp56_;
			gint _tmp57_;
			_tmp46_ = self->priv->current;
			_tmp47_ = self->priv->end;
			if (_tmp46_ < (_tmp47_ - 1)) {
				gboolean _tmp48_ = FALSE;
				gchar* _tmp49_;
				gchar _tmp50_;
				_tmp49_ = self->priv->current;
				_tmp50_ = _tmp49_[0];
				if (_tmp50_ != '*') {
					_tmp48_ = TRUE;
				} else {
					gchar* _tmp51_;
					gchar _tmp52_;
					_tmp51_ = self->priv->current;
					_tmp52_ = _tmp51_[1];
					_tmp48_ = _tmp52_ != '/';
				}
				_tmp45_ = _tmp48_;
			} else {
				_tmp45_ = FALSE;
			}
			if (!_tmp45_) {
				break;
			}
			_tmp53_ = self->priv->current;
			_tmp54_ = _tmp53_[0];
			if (_tmp54_ == '\n') {
				gint _tmp55_;
				_tmp55_ = self->priv->line;
				self->priv->line = _tmp55_ + 1;
				self->priv->column = 0;
			}
			_tmp56_ = self->priv->current;
			self->priv->current = _tmp56_ + 1;
			_tmp57_ = self->priv->column;
			self->priv->column = _tmp57_ + 1;
		}
		_tmp58_ = self->priv->current;
		_tmp59_ = self->priv->end;
		if (_tmp58_ == (_tmp59_ - 1)) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			_tmp60_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_tmp61_ = _tmp60_;
			vala_report_error (_tmp61_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp61_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp62_ = source_reference;
		if (_tmp62_ != NULL) {
			gchar* comment = NULL;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			const gchar* _tmp67_;
			ValaSourceReference* _tmp68_;
			_tmp63_ = begin;
			_tmp64_ = self->priv->current;
			_tmp65_ = begin;
			_tmp66_ = string_substring ((const gchar*) _tmp63_, (glong) 0, (glong) (_tmp64_ - _tmp65_));
			comment = _tmp66_;
			_tmp67_ = comment;
			_tmp68_ = source_reference;
			vala_genie_scanner_push_comment (self, _tmp67_, _tmp68_, file_comment);
			_g_free0 (comment);
		}
		_tmp69_ = self->priv->current;
		self->priv->current = _tmp69_ + 2;
		self->priv->column = self->priv->column + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_genie_scanner_skip_tabs (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean found = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = _tmp4_ == '\t';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		found = TRUE;
	}
	result = found;
	return result;
}

static void
vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = vala_genie_scanner_skip_tabs (self);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static void
vala_genie_scanner_space (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

void
vala_genie_scanner_parse_file_comments (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, TRUE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
vala_genie_scanner_push_comment (ValaGenieScanner* self,
                                 const gchar* comment_item,
                                 ValaSourceReference* source_reference,
                                 gboolean file_comment)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	if (string_get (comment_item, (glong) 0) == '*') {
		ValaComment* _tmp0_;
		ValaComment* _tmp3_;
		_tmp0_ = self->priv->_comment;
		if (_tmp0_ != NULL) {
			ValaSourceFile* _tmp1_;
			ValaComment* _tmp2_;
			_tmp1_ = self->priv->_source_file;
			_tmp2_ = self->priv->_comment;
			vala_source_file_add_comment (_tmp1_, _tmp2_);
		}
		_tmp3_ = vala_comment_new (comment_item, source_reference);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp3_;
	}
	if (file_comment) {
		ValaSourceFile* _tmp4_;
		ValaComment* _tmp5_;
		ValaComment* _tmp6_;
		_tmp4_ = self->priv->_source_file;
		_tmp5_ = vala_comment_new (comment_item, source_reference);
		_tmp6_ = _tmp5_;
		vala_source_file_add_comment (_tmp4_, _tmp6_);
		_vala_comment_unref0 (_tmp6_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = NULL;
	}
}

/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer
_vala_comment_ref0 (gpointer self)
{
	return self ? vala_comment_ref (self) : NULL;
}

ValaComment*
vala_genie_scanner_pop_comment (ValaGenieScanner* self)
{
	ValaComment* result = NULL;
	ValaComment* _tmp0_;
	ValaComment* comment = NULL;
	ValaComment* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_comment;
	_tmp2_ = _vala_comment_ref0 (_tmp1_);
	comment = _tmp2_;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = NULL;
	result = comment;
	return result;
}

static gboolean
vala_genie_scanner_pp_whitespace (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean found = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp0_ = _tmp7_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	result = found;
	return result;
}

static void
vala_genie_scanner_pp_space (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_pp_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static void
vala_genie_scanner_pp_directive (ValaGenieScanner* self)
{
	gchar* _tmp0_;
	gint _tmp1_;
	gchar* begin = NULL;
	gchar* _tmp2_;
	gint len = 0;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp21_ = FALSE;
	ValaGenieScannerConditional* _tmp22_;
	gint _tmp22__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->column;
	self->priv->column = _tmp1_ + 1;
	vala_genie_scanner_pp_space (self);
	_tmp2_ = self->priv->current;
	begin = _tmp2_;
	len = 0;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		if (_tmp4_ < _tmp5_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp3_ = g_ascii_isalnum (_tmp7_);
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
		_tmp10_ = len;
		len = _tmp10_ + 1;
	}
	if (len == 2) {
		gchar* _tmp12_;
		_tmp12_ = begin;
		_tmp11_ = vala_genie_scanner_matches (_tmp12_, "if");
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		vala_genie_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp13_ = FALSE;
		if (len == 4) {
			gchar* _tmp14_;
			_tmp14_ = begin;
			_tmp13_ = vala_genie_scanner_matches (_tmp14_, "elif");
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			vala_genie_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp15_ = FALSE;
			if (len == 4) {
				gchar* _tmp16_;
				_tmp16_ = begin;
				_tmp15_ = vala_genie_scanner_matches (_tmp16_, "else");
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				vala_genie_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp17_ = FALSE;
				if (len == 5) {
					gchar* _tmp18_;
					_tmp18_ = begin;
					_tmp17_ = vala_genie_scanner_matches (_tmp18_, "endif");
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					vala_genie_scanner_parse_pp_endif (self);
				} else {
					ValaSourceReference* _tmp19_;
					ValaSourceReference* _tmp20_;
					_tmp19_ = vala_genie_scanner_get_source_reference (self, -len, len);
					_tmp20_ = _tmp19_;
					vala_report_error (_tmp20_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp20_);
				}
			}
		}
	}
	_tmp22_ = self->priv->conditional_stack;
	_tmp22__length1 = self->priv->conditional_stack_length1;
	if (_tmp22__length1 > 0) {
		ValaGenieScannerConditional* _tmp23_;
		gint _tmp23__length1;
		ValaGenieScannerConditional* _tmp24_;
		gint _tmp24__length1;
		ValaGenieScannerConditional _tmp25_;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp25_ = _tmp23_[_tmp24__length1 - 1];
		_tmp21_ = _tmp25_.skip_section;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gboolean bol = FALSE;
		bol = FALSE;
		while (TRUE) {
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			gchar* _tmp35_;
			gchar _tmp36_;
			gchar* _tmp40_;
			gint _tmp41_;
			_tmp26_ = self->priv->current;
			_tmp27_ = self->priv->end;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			if (bol) {
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp30_ = self->priv->current;
				_tmp31_ = self->priv->end;
				_tmp29_ = _tmp30_ < _tmp31_;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				gchar* _tmp32_;
				gchar _tmp33_;
				_tmp32_ = self->priv->current;
				_tmp33_ = _tmp32_[0];
				_tmp28_ = _tmp33_ == '#';
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				gchar* _tmp34_;
				_tmp34_ = self->priv->current;
				self->priv->current = _tmp34_ - (self->priv->column - 1);
				self->priv->column = 1;
				return;
			}
			_tmp35_ = self->priv->current;
			_tmp36_ = _tmp35_[0];
			if (_tmp36_ == '\n') {
				gint _tmp37_;
				_tmp37_ = self->priv->line;
				self->priv->line = _tmp37_ + 1;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gchar* _tmp38_;
				gchar _tmp39_;
				_tmp38_ = self->priv->current;
				_tmp39_ = _tmp38_[0];
				if (!g_ascii_isspace (_tmp39_)) {
					bol = FALSE;
				}
			}
			_tmp40_ = self->priv->current;
			self->priv->current = _tmp40_ + 1;
			_tmp41_ = self->priv->column;
			self->priv->column = _tmp41_ + 1;
		}
	}
}

static void
vala_genie_scanner_pp_eol (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ != '\n';
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp6_);
	}
}

static void
_vala_array_add11 (ValaGenieScannerConditional* * array,
                   int* length,
                   int* size,
                   const ValaGenieScannerConditional* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
vala_genie_scanner_parse_pp_if (ValaGenieScanner* self)
{
	gboolean condition = FALSE;
	ValaGenieScannerConditional* _tmp0_;
	gint _tmp0__length1;
	ValaGenieScannerConditional _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	condition = vala_genie_scanner_parse_pp_expression (self);
	vala_genie_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	memset (&_tmp1_, 0, sizeof (ValaGenieScannerConditional));
	_vala_array_add11 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp1_);
	if (condition) {
		gboolean _tmp3_ = FALSE;
		ValaGenieScannerConditional* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = self->priv->conditional_stack;
		_tmp4__length1 = self->priv->conditional_stack_length1;
		if (_tmp4__length1 == 1) {
			_tmp3_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp5_;
			gint _tmp5__length1;
			ValaGenieScannerConditional* _tmp6_;
			gint _tmp6__length1;
			ValaGenieScannerConditional _tmp7_;
			_tmp5_ = self->priv->conditional_stack;
			_tmp5__length1 = self->priv->conditional_stack_length1;
			_tmp6_ = self->priv->conditional_stack;
			_tmp6__length1 = self->priv->conditional_stack_length1;
			_tmp7_ = _tmp5_[_tmp6__length1 - 2];
			_tmp3_ = !_tmp7_.skip_section;
		}
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaGenieScannerConditional* _tmp8_;
		gint _tmp8__length1;
		ValaGenieScannerConditional* _tmp9_;
		gint _tmp9__length1;
		_tmp8_ = self->priv->conditional_stack;
		_tmp8__length1 = self->priv->conditional_stack_length1;
		_tmp9_ = self->priv->conditional_stack;
		_tmp9__length1 = self->priv->conditional_stack_length1;
		_tmp8_[_tmp9__length1 - 1].matched = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp10_;
		gint _tmp10__length1;
		ValaGenieScannerConditional* _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = self->priv->conditional_stack;
		_tmp10__length1 = self->priv->conditional_stack_length1;
		_tmp11_ = self->priv->conditional_stack;
		_tmp11__length1 = self->priv->conditional_stack_length1;
		_tmp10_[_tmp11__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self)
{
	gboolean condition = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	condition = vala_genie_scanner_parse_pp_expression (self);
	vala_genie_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerConditional _tmp4_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_.else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp6_);
		return;
	}
	if (condition) {
		ValaGenieScannerConditional* _tmp9_;
		gint _tmp9__length1;
		ValaGenieScannerConditional* _tmp10_;
		gint _tmp10__length1;
		ValaGenieScannerConditional _tmp11_;
		_tmp9_ = self->priv->conditional_stack;
		_tmp9__length1 = self->priv->conditional_stack_length1;
		_tmp10_ = self->priv->conditional_stack;
		_tmp10__length1 = self->priv->conditional_stack_length1;
		_tmp11_ = _tmp9_[_tmp10__length1 - 1];
		_tmp8_ = !_tmp11_.matched;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gboolean _tmp12_ = FALSE;
		ValaGenieScannerConditional* _tmp13_;
		gint _tmp13__length1;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		if (_tmp13__length1 == 1) {
			_tmp12_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp14_;
			gint _tmp14__length1;
			ValaGenieScannerConditional* _tmp15_;
			gint _tmp15__length1;
			ValaGenieScannerConditional _tmp16_;
			_tmp14_ = self->priv->conditional_stack;
			_tmp14__length1 = self->priv->conditional_stack_length1;
			_tmp15_ = self->priv->conditional_stack;
			_tmp15__length1 = self->priv->conditional_stack_length1;
			_tmp16_ = _tmp14_[_tmp15__length1 - 2];
			_tmp12_ = !_tmp16_.skip_section;
		}
		_tmp7_ = _tmp12_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaGenieScannerConditional* _tmp17_;
		gint _tmp17__length1;
		ValaGenieScannerConditional* _tmp18_;
		gint _tmp18__length1;
		ValaGenieScannerConditional* _tmp19_;
		gint _tmp19__length1;
		ValaGenieScannerConditional* _tmp20_;
		gint _tmp20__length1;
		_tmp17_ = self->priv->conditional_stack;
		_tmp17__length1 = self->priv->conditional_stack_length1;
		_tmp18_ = self->priv->conditional_stack;
		_tmp18__length1 = self->priv->conditional_stack_length1;
		_tmp17_[_tmp18__length1 - 1].matched = TRUE;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp19_[_tmp20__length1 - 1].skip_section = FALSE;
	} else {
		ValaGenieScannerConditional* _tmp21_;
		gint _tmp21__length1;
		ValaGenieScannerConditional* _tmp22_;
		gint _tmp22__length1;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp21_[_tmp22__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_genie_scanner_parse_pp_else (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp7_ = FALSE;
	ValaGenieScannerConditional* _tmp8_;
	gint _tmp8__length1;
	ValaGenieScannerConditional* _tmp9_;
	gint _tmp9__length1;
	ValaGenieScannerConditional _tmp10_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerConditional _tmp4_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_.else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp6_);
		return;
	}
	_tmp8_ = self->priv->conditional_stack;
	_tmp8__length1 = self->priv->conditional_stack_length1;
	_tmp9_ = self->priv->conditional_stack;
	_tmp9__length1 = self->priv->conditional_stack_length1;
	_tmp10_ = _tmp8_[_tmp9__length1 - 1];
	if (!_tmp10_.matched) {
		gboolean _tmp11_ = FALSE;
		ValaGenieScannerConditional* _tmp12_;
		gint _tmp12__length1;
		_tmp12_ = self->priv->conditional_stack;
		_tmp12__length1 = self->priv->conditional_stack_length1;
		if (_tmp12__length1 == 1) {
			_tmp11_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp13_;
			gint _tmp13__length1;
			ValaGenieScannerConditional* _tmp14_;
			gint _tmp14__length1;
			ValaGenieScannerConditional _tmp15_;
			_tmp13_ = self->priv->conditional_stack;
			_tmp13__length1 = self->priv->conditional_stack_length1;
			_tmp14_ = self->priv->conditional_stack;
			_tmp14__length1 = self->priv->conditional_stack_length1;
			_tmp15_ = _tmp13_[_tmp14__length1 - 2];
			_tmp11_ = !_tmp15_.skip_section;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaGenieScannerConditional* _tmp16_;
		gint _tmp16__length1;
		ValaGenieScannerConditional* _tmp17_;
		gint _tmp17__length1;
		ValaGenieScannerConditional* _tmp18_;
		gint _tmp18__length1;
		ValaGenieScannerConditional* _tmp19_;
		gint _tmp19__length1;
		_tmp16_ = self->priv->conditional_stack;
		_tmp16__length1 = self->priv->conditional_stack_length1;
		_tmp17_ = self->priv->conditional_stack;
		_tmp17__length1 = self->priv->conditional_stack_length1;
		_tmp16_[_tmp17__length1 - 1].matched = TRUE;
		_tmp18_ = self->priv->conditional_stack;
		_tmp18__length1 = self->priv->conditional_stack_length1;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp18_[_tmp19__length1 - 1].skip_section = FALSE;
	} else {
		ValaGenieScannerConditional* _tmp20_;
		gint _tmp20__length1;
		ValaGenieScannerConditional* _tmp21_;
		gint _tmp21__length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp20_[_tmp21__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self)
{
	ValaGenieScannerConditional* _tmp0_;
	gint _tmp0__length1;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	if (_tmp0__length1 == 0) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack_length1 = _tmp3_ - 1;
}

static gboolean
vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gint len = 0;
	gchar* identifier = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean defined = FALSE;
	const gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = vala_genie_scanner_is_ident_char (self, _tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		_tmp7_ = len;
		len = _tmp7_ + 1;
	}
	if (len == 0) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		_tmp8_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp9_);
		result = FALSE;
		return result;
	}
	_tmp10_ = self->priv->current;
	_tmp11_ = string_substring ((const gchar*) (_tmp10_ - len), (glong) 0, (glong) len);
	identifier = _tmp11_;
	_tmp12_ = identifier;
	if (g_strcmp0 (_tmp12_, "true") == 0) {
		defined = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = identifier;
		if (g_strcmp0 (_tmp13_, "false") == 0) {
			defined = FALSE;
		} else {
			ValaSourceFile* _tmp14_;
			ValaCodeContext* _tmp15_;
			ValaCodeContext* _tmp16_;
			const gchar* _tmp17_;
			_tmp14_ = self->priv->_source_file;
			_tmp15_ = vala_source_file_get_context (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = identifier;
			defined = vala_code_context_is_defined (_tmp16_, _tmp17_);
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->end;
	if (_tmp0_ >= _tmp1_) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		if (vala_genie_scanner_is_ident_char (self, _tmp5_)) {
			result = vala_genie_scanner_parse_pp_symbol (self);
			return result;
		} else {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			if (_tmp7_ == '(') {
				gchar* _tmp8_;
				gint _tmp9_;
				gboolean _result_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->column;
				self->priv->column = _tmp9_ + 1;
				vala_genie_scanner_pp_space (self);
				_result_ = vala_genie_scanner_parse_pp_expression (self);
				vala_genie_scanner_pp_space (self);
				_tmp11_ = self->priv->current;
				_tmp12_ = self->priv->end;
				if (_tmp11_ < _tmp12_) {
					gchar* _tmp13_;
					gchar _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					_tmp10_ = _tmp14_ == ')';
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					gint _tmp16_;
					_tmp15_ = self->priv->current;
					self->priv->current = _tmp15_ + 1;
					_tmp16_ = self->priv->column;
					self->priv->column = _tmp16_ + 1;
				} else {
					ValaSourceReference* _tmp17_;
					ValaSourceReference* _tmp18_;
					_tmp17_ = vala_genie_scanner_get_source_reference (self, 0, 0);
					_tmp18_ = _tmp17_;
					vala_report_error (_tmp18_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp18_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp19_;
				ValaSourceReference* _tmp20_;
				_tmp19_ = vala_genie_scanner_get_source_reference (self, 0, 0);
				_tmp20_ = _tmp19_;
				vala_report_error (_tmp20_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp20_);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ < _tmp2_) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		vala_genie_scanner_pp_space (self);
		result = !vala_genie_scanner_parse_pp_unary_expression (self);
		return result;
	}
	result = vala_genie_scanner_parse_pp_primary_expression (self);
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean left = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_unary_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '=';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '=';
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gchar* _tmp8_;
			gboolean right = FALSE;
			_tmp8_ = self->priv->current;
			self->priv->current = _tmp8_ + 2;
			self->priv->column = self->priv->column + 2;
			vala_genie_scanner_pp_space (self);
			right = vala_genie_scanner_parse_pp_unary_expression (self);
			left = left == right;
		} else {
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = self->priv->end;
			if (_tmp11_ < (_tmp12_ - 1)) {
				gchar* _tmp13_;
				gchar _tmp14_;
				_tmp13_ = self->priv->current;
				_tmp14_ = _tmp13_[0];
				_tmp10_ = _tmp14_ == '!';
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				gchar* _tmp15_;
				gchar _tmp16_;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_[1];
				_tmp9_ = _tmp16_ == '=';
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gchar* _tmp17_;
				gboolean right = FALSE;
				_tmp17_ = self->priv->current;
				self->priv->current = _tmp17_ + 2;
				self->priv->column = self->priv->column + 2;
				vala_genie_scanner_pp_space (self);
				right = vala_genie_scanner_parse_pp_unary_expression (self);
				left = left != right;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean left = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_equality_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gboolean right = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '&';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '&';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		self->priv->column = self->priv->column + 2;
		vala_genie_scanner_pp_space (self);
		right = vala_genie_scanner_parse_pp_equality_expression (self);
		if (left) {
			_tmp9_ = right;
		} else {
			_tmp9_ = FALSE;
		}
		left = _tmp9_;
	}
	result = left;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean left = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_and_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gboolean right = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '|';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '|';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		self->priv->column = self->priv->column + 2;
		vala_genie_scanner_pp_space (self);
		right = vala_genie_scanner_parse_pp_and_expression (self);
		if (left) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = right;
		}
		left = _tmp9_;
	}
	result = left;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_genie_scanner_parse_pp_or_expression (self);
	return result;
}

ValaSourceFile*
vala_genie_scanner_get_source_file (ValaGenieScanner* self)
{
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static void
vala_genie_scanner_set_source_file (ValaGenieScanner* self,
                                    ValaSourceFile* value)
{
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp0_;
}

gint
vala_genie_scanner_get_indent_spaces (ValaGenieScanner* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_indent_spaces;
	return result;
}

void
vala_genie_scanner_set_indent_spaces (ValaGenieScanner* self,
                                      gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_indent_spaces = value;
}

static ValaGenieScannerConditional*
vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self)
{
	ValaGenieScannerConditional* dup;
	dup = g_new0 (ValaGenieScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaGenieScannerConditional));
	return dup;
}

static void
vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self)
{
	g_free (self);
}

static GType
vala_genie_scanner_conditional_get_type (void)
{
	static volatile gsize vala_genie_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_conditional_type_id__volatile)) {
		GType vala_genie_scanner_conditional_type_id;
		vala_genie_scanner_conditional_type_id = g_boxed_type_register_static ("ValaGenieScannerConditional", (GBoxedCopyFunc) vala_genie_scanner_conditional_dup, (GBoxedFreeFunc) vala_genie_scanner_conditional_free);
		g_once_init_leave (&vala_genie_scanner_conditional_type_id__volatile, vala_genie_scanner_conditional_type_id);
	}
	return vala_genie_scanner_conditional_type_id__volatile;
}

static void
vala_genie_value_scanner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_genie_value_scanner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_genie_scanner_unref (value->data[0].v_pointer);
	}
}

static void
vala_genie_value_scanner_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_genie_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_genie_value_scanner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_genie_value_scanner_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGenieScanner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_genie_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_genie_value_scanner_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	ValaGenieScanner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_genie_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_genie_param_spec_scanner (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ValaGenieParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GENIE_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_genie_value_get_scanner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}

void
vala_genie_value_set_scanner (GValue* value,
                              gpointer v_object)
{
	ValaGenieScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_genie_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}

void
vala_genie_value_take_scanner (GValue* value,
                               gpointer v_object)
{
	ValaGenieScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}

static void
vala_genie_scanner_class_init (ValaGenieScannerClass * klass,
                               gpointer klass_data)
{
	vala_genie_scanner_parent_class = g_type_class_peek_parent (klass);
	((ValaGenieScannerClass *) klass)->finalize = vala_genie_scanner_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGenieScanner_private_offset);
}

static void
vala_genie_scanner_instance_init (ValaGenieScanner * self,
                                  gpointer klass)
{
	self->priv = vala_genie_scanner_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_genie_scanner_finalize (ValaGenieScanner * obj)
{
	ValaGenieScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GENIE_TYPE_SCANNER, ValaGenieScanner);
	g_signal_handlers_destroy (self);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}

/**
 * Lexical scanner for Genie source files.
 */
GType
vala_genie_scanner_get_type (void)
{
	static volatile gsize vala_genie_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_genie_value_scanner_init, vala_genie_value_scanner_free_value, vala_genie_value_scanner_copy_value, vala_genie_value_scanner_peek_pointer, "p", vala_genie_value_scanner_collect_value, "p", vala_genie_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGenieScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_genie_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenieScanner), 0, (GInstanceInitFunc) vala_genie_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_genie_scanner_type_id;
		vala_genie_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGenieScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		ValaGenieScanner_private_offset = g_type_add_instance_private (vala_genie_scanner_type_id, sizeof (ValaGenieScannerPrivate));
		g_once_init_leave (&vala_genie_scanner_type_id__volatile, vala_genie_scanner_type_id);
	}
	return vala_genie_scanner_type_id__volatile;
}

gpointer
vala_genie_scanner_ref (gpointer instance)
{
	ValaGenieScanner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_genie_scanner_unref (gpointer instance)
{
	ValaGenieScanner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GENIE_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

