// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Error;
use InetAddress;
use SocketFamily;
use ffi;
use glib;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct InetAddressMask(Object<ffi::GInetAddressMask, ffi::GInetAddressMaskClass>);

    match fn {
        get_type => || ffi::g_inet_address_mask_get_type(),
    }
}

impl InetAddressMask {
    pub fn new(addr: &InetAddress, length: u32) -> Result<InetAddressMask, Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_inet_address_mask_new(addr.to_glib_none().0, length, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    pub fn new_from_string(mask_string: &str) -> Result<InetAddressMask, Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_inet_address_mask_new_from_string(mask_string.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }
}

unsafe impl Send for InetAddressMask {}
unsafe impl Sync for InetAddressMask {}

pub trait InetAddressMaskExt {
    fn get_address(&self) -> InetAddress;

    fn get_family(&self) -> SocketFamily;

    fn get_length(&self) -> u32;

    fn matches(&self, address: &InetAddress) -> bool;

    fn to_string(&self) -> String;

    fn set_property_address(&self, address: Option<&InetAddress>);

    fn set_property_length(&self, length: u32);

    fn connect_property_address_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_family_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_length_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<InetAddressMask> + IsA<glib::object::Object>> InetAddressMaskExt for O {
    fn get_address(&self) -> InetAddress {
        unsafe {
            from_glib_none(ffi::g_inet_address_mask_get_address(self.to_glib_none().0))
        }
    }

    fn get_family(&self) -> SocketFamily {
        unsafe {
            from_glib(ffi::g_inet_address_mask_get_family(self.to_glib_none().0))
        }
    }

    fn get_length(&self) -> u32 {
        unsafe {
            ffi::g_inet_address_mask_get_length(self.to_glib_none().0)
        }
    }

    fn matches(&self, address: &InetAddress) -> bool {
        unsafe {
            from_glib(ffi::g_inet_address_mask_matches(self.to_glib_none().0, address.to_glib_none().0))
        }
    }

    fn to_string(&self) -> String {
        unsafe {
            from_glib_full(ffi::g_inet_address_mask_to_string(self.to_glib_none().0))
        }
    }

    fn set_property_address(&self, address: Option<&InetAddress>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "address".to_glib_none().0, Value::from(address).to_glib_none().0);
        }
    }

    fn set_property_length(&self, length: u32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "length".to_glib_none().0, Value::from(&length).to_glib_none().0);
        }
    }

    fn connect_property_address_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + Send + Sync + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::address",
                transmute(notify_address_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_family_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + Send + Sync + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::family",
                transmute(notify_family_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_length_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + Send + Sync + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::length",
                transmute(notify_length_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn notify_address_trampoline<P>(this: *mut ffi::GInetAddressMask, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddressMask> {
    let f: &&(Fn(&P) + Send + Sync + 'static) = transmute(f);
    f(&InetAddressMask::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_family_trampoline<P>(this: *mut ffi::GInetAddressMask, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddressMask> {
    let f: &&(Fn(&P) + Send + Sync + 'static) = transmute(f);
    f(&InetAddressMask::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_length_trampoline<P>(this: *mut ffi::GInetAddressMask, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<InetAddressMask> {
    let f: &&(Fn(&P) + Send + Sync + 'static) = transmute(f);
    f(&InetAddressMask::from_glib_borrow(this).downcast_unchecked())
}
