/* rygel-tracker-video-item-factory.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-tracker-video-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <rygel-server.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gee.h>
#include <rygel-core.h>

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_TYPE_VIDEO_ITEM_FACTORY (rygel_tracker_video_item_factory_get_type ())
#define RYGEL_TRACKER_VIDEO_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_VIDEO_ITEM_FACTORY, RygelTrackerVideoItemFactory))
#define RYGEL_TRACKER_VIDEO_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_VIDEO_ITEM_FACTORY, RygelTrackerVideoItemFactoryClass))
#define RYGEL_TRACKER_IS_VIDEO_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_VIDEO_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_VIDEO_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_VIDEO_ITEM_FACTORY))
#define RYGEL_TRACKER_VIDEO_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_VIDEO_ITEM_FACTORY, RygelTrackerVideoItemFactoryClass))

typedef struct _RygelTrackerVideoItemFactory RygelTrackerVideoItemFactory;
typedef struct _RygelTrackerVideoItemFactoryClass RygelTrackerVideoItemFactoryClass;
typedef struct _RygelTrackerVideoItemFactoryPrivate RygelTrackerVideoItemFactoryPrivate;
typedef enum  {
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TRACKER_ID,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY
} RygelTrackerItemFactoryMetadata;

#define RYGEL_TRACKER_ITEM_FACTORY_TYPE_METADATA (rygel_tracker_item_factory_metadata_get_type ())
typedef enum  {
	RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_HEIGHT = RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY,
	RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_WIDTH,
	RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_DURATION,
	RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_LAST_KEY
} RygelTrackerVideoItemFactoryVideoMetadata;

#define RYGEL_TRACKER_VIDEO_ITEM_FACTORY_TYPE_VIDEO_METADATA (rygel_tracker_video_item_factory_video_metadata_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaFileItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaFileItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
	void (*add_resources) (RygelTrackerItemFactory* self, RygelMediaFileItem* item, GError** error);
};

struct _RygelTrackerVideoItemFactory {
	RygelTrackerItemFactory parent_instance;
	RygelTrackerVideoItemFactoryPrivate * priv;
};

struct _RygelTrackerVideoItemFactoryClass {
	RygelTrackerItemFactoryClass parent_class;
};

static gpointer rygel_tracker_video_item_factory_parent_class = NULL;

gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value,
                                           gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value,
                                            gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelTrackerItemFactory, rygel_tracker_item_factory_unref)
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelTrackerSearchContainer, g_object_unref)
GType rygel_tracker_video_item_factory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelTrackerVideoItemFactory, rygel_tracker_item_factory_unref)
GType rygel_tracker_item_factory_metadata_get_type (void) G_GNUC_CONST;
static GType rygel_tracker_video_item_factory_video_metadata_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RYGEL_TRACKER_VIDEO_ITEM_FACTORY_CATEGORY "nmm:Video"
#define RYGEL_TRACKER_VIDEO_ITEM_FACTORY_CATEGORY_IRI "http://www.tracker-project.org/" "temp/nmm#Video"
RygelTrackerVideoItemFactory* rygel_tracker_video_item_factory_new (void);
RygelTrackerVideoItemFactory* rygel_tracker_video_item_factory_construct (GType object_type);
RygelTrackerItemFactory* rygel_tracker_item_factory_construct (GType object_type,
                                                               const gchar* category,
                                                               const gchar* category_iri,
                                                               const gchar* upnp_class,
                                                               const gchar* upload_dir);
static RygelMediaFileItem* rygel_tracker_video_item_factory_real_create (RygelTrackerItemFactory* base,
                                                                  const gchar* id,
                                                                  const gchar* uri,
                                                                  RygelTrackerSearchContainer* parent,
                                                                  TrackerSparqlCursor* metadata,
                                                                  GError** error);
void rygel_tracker_item_factory_set_metadata (RygelTrackerItemFactory* self,
                                              RygelMediaFileItem* item,
                                              const gchar* uri,
                                              TrackerSparqlCursor* metadata,
                                              GError** error);
static void rygel_tracker_video_item_factory_real_set_metadata (RygelTrackerItemFactory* base,
                                                         RygelMediaFileItem* item,
                                                         const gchar* uri,
                                                         TrackerSparqlCursor* metadata,
                                                         GError** error);
void rygel_tracker_item_factory_set_ref_id (RygelTrackerItemFactory* self,
                                            RygelMediaFileItem* item,
                                            const gchar* prefix);
void rygel_tracker_item_factory_add_resources (RygelTrackerItemFactory* self,
                                               RygelMediaFileItem* item,
                                               GError** error);

static GType
rygel_tracker_video_item_factory_video_metadata_get_type (void)
{
	static volatile gsize rygel_tracker_video_item_factory_video_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_video_item_factory_video_metadata_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_HEIGHT, "RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_HEIGHT", "height"}, {RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_WIDTH, "RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_WIDTH", "width"}, {RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_DURATION, "RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_DURATION", "duration"}, {RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_LAST_KEY, "RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
		GType rygel_tracker_video_item_factory_video_metadata_type_id;
		rygel_tracker_video_item_factory_video_metadata_type_id = g_enum_register_static ("RygelTrackerVideoItemFactoryVideoMetadata", values);
		g_once_init_leave (&rygel_tracker_video_item_factory_video_metadata_type_id__volatile, rygel_tracker_video_item_factory_video_metadata_type_id);
	}
	return rygel_tracker_video_item_factory_video_metadata_type_id__volatile;
}

RygelTrackerVideoItemFactory*
rygel_tracker_video_item_factory_construct (GType object_type)
{
	RygelTrackerVideoItemFactory* self = NULL;
	gchar* upload_folder = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	_tmp1_ = g_strdup (_tmp0_);
	upload_folder = _tmp1_;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = rygel_meta_config_get_default ();
		config = _tmp2_;
		_tmp4_ = rygel_configuration_get_video_upload_folder ((RygelConfiguration*) config, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch13_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (upload_folder);
		upload_folder = _tmp5_;
		_g_free0 (_tmp3_);
		_g_object_unref0 (config);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (upload_folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = upload_folder;
	self = (RygelTrackerVideoItemFactory*) rygel_tracker_item_factory_construct (object_type, RYGEL_TRACKER_VIDEO_ITEM_FACTORY_CATEGORY, RYGEL_TRACKER_VIDEO_ITEM_FACTORY_CATEGORY_IRI, RYGEL_VIDEO_ITEM_UPNP_CLASS, _tmp6_);
	_tmp7_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "height");
	_tmp8_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, "width");
	_tmp9_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "res@duration");
	_g_free0 (upload_folder);
	return self;
}

RygelTrackerVideoItemFactory*
rygel_tracker_video_item_factory_new (void)
{
	return rygel_tracker_video_item_factory_construct (RYGEL_TRACKER_TYPE_VIDEO_ITEM_FACTORY);
}

static RygelMediaFileItem*
rygel_tracker_video_item_factory_real_create (RygelTrackerItemFactory* base,
                                              const gchar* id,
                                              const gchar* uri,
                                              RygelTrackerSearchContainer* parent,
                                              TrackerSparqlCursor* metadata,
                                              GError** error)
{
	RygelTrackerVideoItemFactory * self;
	RygelMediaFileItem* result = NULL;
	RygelVideoItem* item = NULL;
	RygelVideoItem* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (RygelTrackerVideoItemFactory*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = rygel_video_item_new (id, (RygelMediaContainer*) parent, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
	item = _tmp0_;
	rygel_tracker_item_factory_set_metadata ((RygelTrackerItemFactory*) self, (RygelMediaFileItem*) item, uri, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (item);
		return NULL;
	}
	result = (RygelMediaFileItem*) item;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_tracker_video_item_factory_real_set_metadata (RygelTrackerItemFactory* base,
                                                    RygelMediaFileItem* item,
                                                    const gchar* uri,
                                                    TrackerSparqlCursor* metadata,
                                                    GError** error)
{
	RygelTrackerVideoItemFactory * self;
	RygelVideoItem* video = NULL;
	RygelVideoItem* _tmp0_;
	RygelVideoItem* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (RygelTrackerVideoItemFactory*) base;
	g_return_if_fail (item != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (rygel_tracker_video_item_factory_parent_class)->set_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory), item, uri, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	rygel_tracker_item_factory_set_ref_id ((RygelTrackerItemFactory*) self, item, "AllVideos");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) item) : NULL);
	video = _tmp0_;
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_WIDTH)) {
		RygelVideoItem* _tmp1_;
		_tmp1_ = video;
		rygel_visual_item_set_width ((RygelVisualItem*) _tmp1_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_WIDTH));
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_HEIGHT)) {
		RygelVideoItem* _tmp2_;
		_tmp2_ = video;
		rygel_visual_item_set_height ((RygelVisualItem*) _tmp2_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_HEIGHT));
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_DURATION)) {
		RygelVideoItem* _tmp3_;
		_tmp3_ = video;
		rygel_audio_item_set_duration ((RygelAudioItem*) _tmp3_, (glong) ((gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_TRACKER_VIDEO_ITEM_FACTORY_VIDEO_METADATA_DURATION)));
	}
	_tmp4_ = video;
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (rygel_tracker_video_item_factory_parent_class)->add_resources (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory), (RygelMediaFileItem*) _tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (video);
		return;
	}
	_g_object_unref0 (video);
}

static void
rygel_tracker_video_item_factory_class_init (RygelTrackerVideoItemFactoryClass * klass,
                                             gpointer klass_data)
{
	rygel_tracker_video_item_factory_parent_class = g_type_class_peek_parent (klass);
	((RygelTrackerItemFactoryClass *) klass)->create = (RygelMediaFileItem* (*) (RygelTrackerItemFactory*, const gchar*, const gchar*, RygelTrackerSearchContainer*, TrackerSparqlCursor*, GError**)) rygel_tracker_video_item_factory_real_create;
	((RygelTrackerItemFactoryClass *) klass)->set_metadata = (void (*) (RygelTrackerItemFactory*, RygelMediaFileItem*, const gchar*, TrackerSparqlCursor*, GError**)) rygel_tracker_video_item_factory_real_set_metadata;
}

static void
rygel_tracker_video_item_factory_instance_init (RygelTrackerVideoItemFactory * self,
                                                gpointer klass)
{
}

/**
 * Tracker video item factory.
 */
GType
rygel_tracker_video_item_factory_get_type (void)
{
	static volatile gsize rygel_tracker_video_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_video_item_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerVideoItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_video_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerVideoItemFactory), 0, (GInstanceInitFunc) rygel_tracker_video_item_factory_instance_init, NULL };
		GType rygel_tracker_video_item_factory_type_id;
		rygel_tracker_video_item_factory_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_ITEM_FACTORY, "RygelTrackerVideoItemFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_video_item_factory_type_id__volatile, rygel_tracker_video_item_factory_type_id);
	}
	return rygel_tracker_video_item_factory_type_id__volatile;
}

