/* rygel-tracker-insertion-query.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-tracker-insertion-query.vala, do not modify */

/*
 * Copyright (C) 2010-2012 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-server.h>

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;

#define RYGEL_TRACKER_TYPE_INSERTION_QUERY (rygel_tracker_insertion_query_get_type ())
#define RYGEL_TRACKER_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQuery))
#define RYGEL_TRACKER_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))
#define RYGEL_TRACKER_IS_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_IS_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_INSERTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))

typedef struct _RygelTrackerInsertionQuery RygelTrackerInsertionQuery;
typedef struct _RygelTrackerInsertionQueryClass RygelTrackerInsertionQueryClass;
typedef struct _RygelTrackerInsertionQueryPrivate RygelTrackerInsertionQueryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE (rygel_tracker_miner_files_index_iface_get_type ())
#define RYGEL_TRACKER_MINER_FILES_INDEX_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE, RygelTrackerMinerFilesIndexIface))
#define RYGEL_TRACKER_IS_MINER_FILES_INDEX_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE))
#define RYGEL_TRACKER_MINER_FILES_INDEX_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE, RygelTrackerMinerFilesIndexIfaceIface))

typedef struct _RygelTrackerMinerFilesIndexIface RygelTrackerMinerFilesIndexIface;
typedef struct _RygelTrackerMinerFilesIndexIfaceIface RygelTrackerMinerFilesIndexIfaceIface;

#define RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE_PROXY (rygel_tracker_miner_files_index_iface_proxy_get_type ())
typedef struct _RygelTrackerInsertionQueryExecuteData RygelTrackerInsertionQueryExecuteData;

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerInsertionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerInsertionQueryPrivate * priv;
	gchar* id;
};

struct _RygelTrackerInsertionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerInsertionQueryPrivate {
	gchar* uri;
};

struct _RygelTrackerMinerFilesIndexIfaceIface {
	GTypeInterface parent_iface;
	void (*index_file) (RygelTrackerMinerFilesIndexIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*index_file_finish) (RygelTrackerMinerFilesIndexIface* self, GAsyncResult* _res_, GError** error);
};

struct _RygelTrackerInsertionQueryExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackerInsertionQuery* self;
	TrackerSparqlConnection* resources;
	gchar* str;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GVariant* v;
	const gchar* _tmp2_;
	GVariant* _tmp3_;
	GVariantIter* iter1;
	GVariantIter* iter2;
	GVariantIter* iter3;
	gchar* key;
	GVariant* _tmp4_;
	GVariantIter* _tmp5_;
	GVariantIter* _tmp6_;
	GVariantIter* _tmp7_;
	gboolean _tmp8_;
	GVariantIter* _tmp9_;
	GVariantIter* _tmp10_;
	gboolean _tmp11_;
	GVariantIter* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	const gchar* _tmp16_;
	TrackerSparqlCursor* cursor;
	gchar* _tmp17_;
	gchar* _tmp18_;
	TrackerSparqlCursor* _tmp19_;
	TrackerSparqlCursor* _tmp20_;
	gboolean _tmp21_;
	TrackerSparqlCursor* _tmp22_;
	TrackerSparqlCursor* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	GError* _error_;
	GFile* file;
	const gchar* _tmp26_;
	GFile* _tmp27_;
	gboolean _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	RygelTrackerMinerFilesIndexIface* miner;
	RygelTrackerMinerFilesIndexIface* _tmp31_;
	RygelTrackerMinerFilesIndexIface* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GError* _inner_error0_;
};

static gint RygelTrackerInsertionQuery_private_offset;
static gpointer rygel_tracker_insertion_query_parent_class = NULL;

gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value,
                                    gpointer v_object);
void rygel_tracker_value_take_query (GValue* value,
                                     gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelTrackerQuery, rygel_tracker_query_unref)
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelTrackerQueryTriplets, g_object_unref)
GType rygel_tracker_insertion_query_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelTrackerInsertionQuery, rygel_tracker_query_unref)
#define RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID "x"
#define RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID "_:" RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_SERVICE "org.freedesktop.Tracker1.Miner.Files.Index"
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_PATH "/org/freedesktop/Tracker1/Miner/Files/Index"
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH "urn:uuid:472ed0cc-40ff-4e37-9c0c-062d78656540"
#define RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_ID_QUERY_TEMPLATE "SELECT ?resource WHERE { ?resource a nie:DataObject; nie:url '%s' }"
#define RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_NOT_BOUND_TEMPLATE "OPTIONAL { ?resource a nie:DataObject; nie:url '%s' } " "FILTER (!bound(?resource))"
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_new (RygelMediaFileItem* item,
                                                               const gchar* category);
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_construct (GType object_type,
                                                                     RygelMediaFileItem* item,
                                                                     const gchar* category);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const gchar* subject,
                                                           const gchar* predicate,
                                                           const gchar* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type,
                                                                 const gchar* subject,
                                                                 const gchar* predicate,
                                                                 const gchar* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value,
                                            gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value,
                                             gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelTrackerQueryTriplet, rygel_tracker_query_triplet_unref)
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new_with_graph (const gchar* graph,
                                                                      const gchar* subject,
                                                                      const gchar* predicate,
                                                                      const gchar* object);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct_with_graph (GType object_type,
                                                                            const gchar* graph,
                                                                            const gchar* subject,
                                                                            const gchar* predicate,
                                                                            const gchar* object);
RygelTrackerQuery* rygel_tracker_query_construct (GType object_type,
                                                  RygelTrackerQueryTriplets* triplets);
static void rygel_tracker_insertion_query_real_execute_data_free (gpointer _data);
static void rygel_tracker_insertion_query_real_execute (RygelTrackerQuery* base,
                                                 TrackerSparqlConnection* resources,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean rygel_tracker_insertion_query_real_execute_co (RygelTrackerInsertionQueryExecuteData* _data_);
gchar* rygel_tracker_query_to_string (RygelTrackerQuery* self);
static void rygel_tracker_insertion_query_execute_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static gchar* rygel_tracker_insertion_query_get_resource_id_query (RygelTrackerInsertionQuery* self);
GType rygel_tracker_miner_files_index_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_miner_files_index_iface_register_object (void* object,
                                                             GDBusConnection* connection,
                                                             const gchar* path,
                                                             GError** error);
GType rygel_tracker_miner_files_index_iface_get_type (void) G_GNUC_CONST;
void rygel_tracker_miner_files_index_iface_index_file (RygelTrackerMinerFilesIndexIface* self,
                                                       const gchar* uri,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
void rygel_tracker_miner_files_index_iface_index_file_finish (RygelTrackerMinerFilesIndexIface* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
static gchar* rygel_tracker_insertion_query_real_to_string (RygelTrackerQuery* base);
static void rygel_tracker_insertion_query_finalize (RygelTrackerQuery * obj);

static inline gpointer
rygel_tracker_insertion_query_get_instance_private (RygelTrackerInsertionQuery* self)
{
	return G_STRUCT_MEMBER_P (self, RygelTrackerInsertionQuery_private_offset);
}

RygelTrackerInsertionQuery*
rygel_tracker_insertion_query_construct (GType object_type,
                                         RygelMediaFileItem* item,
                                         const gchar* category)
{
	RygelTrackerInsertionQuery* self = NULL;
	gchar* type = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	RygelTrackerQueryTriplets* triplets = NULL;
	RygelTrackerQueryTriplets* _tmp7_;
	RygelTrackerQueryTriplets* _tmp8_;
	RygelTrackerQueryTriplet* _tmp9_;
	RygelTrackerQueryTriplet* _tmp10_;
	RygelTrackerQueryTriplets* _tmp11_;
	const gchar* _tmp12_;
	RygelTrackerQueryTriplet* _tmp13_;
	RygelTrackerQueryTriplet* _tmp14_;
	RygelTrackerQueryTriplets* _tmp15_;
	RygelTrackerQueryTriplet* _tmp16_;
	RygelTrackerQueryTriplet* _tmp17_;
	RygelTrackerQueryTriplets* _tmp18_;
	RygelTrackerQueryTriplet* _tmp19_;
	RygelTrackerQueryTriplet* _tmp20_;
	RygelTrackerQueryTriplets* _tmp21_;
	RygelTrackerQueryTriplet* _tmp22_;
	RygelTrackerQueryTriplet* _tmp23_;
	RygelTrackerQueryTriplets* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	RygelTrackerQueryTriplet* _tmp31_;
	RygelTrackerQueryTriplet* _tmp32_;
	RygelTrackerQueryTriplets* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	RygelTrackerQueryTriplet* _tmp40_;
	RygelTrackerQueryTriplet* _tmp41_;
	gchar* dlna_profile = NULL;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	RygelTrackerQueryTriplets* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	RygelTrackerQueryTriplet* _tmp54_;
	RygelTrackerQueryTriplet* _tmp55_;
	RygelTrackerQueryTriplets* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	RygelTrackerQueryTriplet* _tmp63_;
	RygelTrackerQueryTriplet* _tmp64_;
	gchar* date = NULL;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	RygelTrackerQueryTriplets* _tmp71_;
	const gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	RygelTrackerQueryTriplet* _tmp77_;
	RygelTrackerQueryTriplet* _tmp78_;
	gint64 _tmp79_;
	gint64 _tmp80_;
	RygelTrackerQueryTriplets* _tmp92_;
	gchar* _tmp93_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = g_strdup ("nie:DataObject");
	type = _tmp0_;
	_tmp1_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) item);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	file = _tmp4_;
	_tmp5_ = file;
	if (!g_file_is_native (_tmp5_)) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("nfo:RemoteDataObject");
		_g_free0 (type);
		type = _tmp6_;
	}
	_tmp7_ = rygel_tracker_query_triplets_new ();
	triplets = _tmp7_;
	_tmp8_ = triplets;
	_tmp9_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "a", category);
	_tmp10_ = _tmp9_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp10_);
	_rygel_tracker_query_triplet_unref0 (_tmp10_);
	_tmp11_ = triplets;
	_tmp12_ = type;
	_tmp13_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "a", _tmp12_);
	_tmp14_ = _tmp13_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp14_);
	_rygel_tracker_query_triplet_unref0 (_tmp14_);
	_tmp15_ = triplets;
	_tmp16_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nmm:uPnPShared", "true");
	_tmp17_ = _tmp16_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp17_);
	_rygel_tracker_query_triplet_unref0 (_tmp17_);
	_tmp18_ = triplets;
	_tmp19_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "tracker:available", "true");
	_tmp20_ = _tmp19_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp20_);
	_rygel_tracker_query_triplet_unref0 (_tmp20_);
	_tmp21_ = triplets;
	_tmp22_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:generator", "\"rygel\"");
	_tmp23_ = _tmp22_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp23_);
	_rygel_tracker_query_triplet_unref0 (_tmp23_);
	_tmp24_ = triplets;
	_tmp25_ = rygel_media_object_get_title ((RygelMediaObject*) item);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("\"", _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp28_, "\"", NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:title", _tmp30_);
	_tmp32_ = _tmp31_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp32_);
	_rygel_tracker_query_triplet_unref0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_tmp33_ = triplets;
	_tmp34_ = rygel_media_file_item_get_mime_type (item);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat ("\"", _tmp35_, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat (_tmp37_, "\"", NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = rygel_tracker_query_triplet_new_with_graph (RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH, RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:mimeType", _tmp39_);
	_tmp41_ = _tmp40_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp41_);
	_rygel_tracker_query_triplet_unref0 (_tmp41_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_tmp42_ = g_strdup ("");
	dlna_profile = _tmp42_;
	_tmp43_ = rygel_media_file_item_get_dlna_profile (item);
	_tmp44_ = _tmp43_;
	if (_tmp44_ != NULL) {
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp45_ = rygel_media_file_item_get_dlna_profile (item);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_strdup (_tmp46_);
		_g_free0 (dlna_profile);
		dlna_profile = _tmp47_;
	}
	_tmp48_ = triplets;
	_tmp49_ = dlna_profile;
	_tmp50_ = g_strconcat ("\"", _tmp49_, NULL);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strconcat (_tmp51_, "\"", NULL);
	_tmp53_ = _tmp52_;
	_tmp54_ = rygel_tracker_query_triplet_new_with_graph (RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH, RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nmm:dlnaProfile", _tmp53_);
	_tmp55_ = _tmp54_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp55_);
	_rygel_tracker_query_triplet_unref0 (_tmp55_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp51_);
	_tmp56_ = triplets;
	_tmp57_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) item);
	_tmp58_ = _tmp57_;
	_tmp59_ = g_strconcat ("\"", _tmp58_, NULL);
	_tmp60_ = _tmp59_;
	_tmp61_ = g_strconcat (_tmp60_, "\"", NULL);
	_tmp62_ = _tmp61_;
	_tmp63_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:url", _tmp62_);
	_tmp64_ = _tmp63_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp64_);
	_rygel_tracker_query_triplet_unref0 (_tmp64_);
	_g_free0 (_tmp62_);
	_g_free0 (_tmp60_);
	_g_free0 (_tmp58_);
	_tmp65_ = rygel_media_object_get_date ((RygelMediaObject*) item);
	_tmp66_ = _tmp65_;
	if (_tmp66_ == NULL) {
		GTimeVal now = {0};
		gchar* _tmp67_;
		g_get_current_time (&now);
		_tmp67_ = g_time_val_to_iso8601 (&now);
		_g_free0 (date);
		date = _tmp67_;
	} else {
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_;
		_tmp68_ = rygel_media_object_get_date ((RygelMediaObject*) item);
		_tmp69_ = _tmp68_;
		_tmp70_ = g_strdup (_tmp69_);
		_g_free0 (date);
		date = _tmp70_;
	}
	_tmp71_ = triplets;
	_tmp72_ = date;
	_tmp73_ = g_strconcat ("\"", _tmp72_, NULL);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_strconcat (_tmp74_, "\"", NULL);
	_tmp76_ = _tmp75_;
	_tmp77_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:contentCreated", _tmp76_);
	_tmp78_ = _tmp77_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp71_, _tmp78_);
	_rygel_tracker_query_triplet_unref0 (_tmp78_);
	_g_free0 (_tmp76_);
	_g_free0 (_tmp74_);
	_tmp79_ = rygel_media_file_item_get_size (item);
	_tmp80_ = _tmp79_;
	if (_tmp80_ > ((gint64) 0)) {
		RygelTrackerQueryTriplets* _tmp81_;
		gint64 _tmp82_;
		gint64 _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		RygelTrackerQueryTriplet* _tmp90_;
		RygelTrackerQueryTriplet* _tmp91_;
		_tmp81_ = triplets;
		_tmp82_ = rygel_media_file_item_get_size (item);
		_tmp83_ = _tmp82_;
		_tmp84_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = g_strconcat ("\"", _tmp85_, NULL);
		_tmp87_ = _tmp86_;
		_tmp88_ = g_strconcat (_tmp87_, "\"", NULL);
		_tmp89_ = _tmp88_;
		_tmp90_ = rygel_tracker_query_triplet_new_with_graph (RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH, RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:byteSize", _tmp89_);
		_tmp91_ = _tmp90_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp81_, _tmp91_);
		_rygel_tracker_query_triplet_unref0 (_tmp91_);
		_g_free0 (_tmp89_);
		_g_free0 (_tmp87_);
		_g_free0 (_tmp85_);
	}
	_tmp92_ = triplets;
	self = (RygelTrackerInsertionQuery*) rygel_tracker_query_construct (object_type, _tmp92_);
	_tmp93_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) item);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp93_;
	_g_free0 (date);
	_g_free0 (dlna_profile);
	_g_object_unref0 (triplets);
	_g_object_unref0 (file);
	_g_free0 (type);
	return self;
}

RygelTrackerInsertionQuery*
rygel_tracker_insertion_query_new (RygelMediaFileItem* item,
                                   const gchar* category)
{
	return rygel_tracker_insertion_query_construct (RYGEL_TRACKER_TYPE_INSERTION_QUERY, item, category);
}

static void
rygel_tracker_insertion_query_real_execute_data_free (gpointer _data)
{
	RygelTrackerInsertionQueryExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->resources);
	_rygel_tracker_query_unref0 (_data_->self);
	g_slice_free (RygelTrackerInsertionQueryExecuteData, _data_);
}

static gpointer
_rygel_tracker_query_ref0 (gpointer self)
{
	return self ? rygel_tracker_query_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_tracker_insertion_query_real_execute (RygelTrackerQuery* base,
                                            TrackerSparqlConnection* resources,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	RygelTrackerInsertionQuery * self;
	RygelTrackerInsertionQueryExecuteData* _data_;
	RygelTrackerInsertionQuery* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	self = (RygelTrackerInsertionQuery*) base;
	_data_ = g_slice_new0 (RygelTrackerInsertionQueryExecuteData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_insertion_query_real_execute_data_free);
	_tmp0_ = _rygel_tracker_query_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (resources);
	_g_object_unref0 (_data_->resources);
	_data_->resources = _tmp1_;
	rygel_tracker_insertion_query_real_execute_co (_data_);
}

static void
rygel_tracker_insertion_query_real_execute_finish (RygelTrackerQuery* base,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	RygelTrackerInsertionQueryExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_tracker_insertion_query_execute_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	RygelTrackerInsertionQueryExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_insertion_query_real_execute_co (_data_);
}

static gboolean
rygel_tracker_insertion_query_real_execute_co (RygelTrackerInsertionQueryExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_tracker_query_to_string ((RygelTrackerQuery*) _data_->self);
	_data_->str = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->str;
	g_debug ("rygel-tracker-insertion-query.vala:128: Executing SPARQL query: %s", _data_->_tmp1_);
	_data_->_tmp2_ = _data_->str;
	_data_->_state_ = 1;
	tracker_sparql_connection_update_blank_async (_data_->resources, _data_->_tmp2_, G_PRIORITY_DEFAULT, NULL, rygel_tracker_insertion_query_execute_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = tracker_sparql_connection_update_blank_finish (_data_->resources, _data_->_res_, &_data_->_inner_error0_);
	_data_->v = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->str);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->key = NULL;
	_data_->_tmp4_ = _data_->v;
	_data_->_tmp5_ = g_variant_iter_new (_data_->_tmp4_);
	_g_variant_iter_free0 (_data_->iter1);
	_data_->iter1 = _data_->_tmp5_;
	while (TRUE) {
		_data_->_tmp6_ = _data_->iter1;
		_data_->_tmp7_ = NULL;
		_data_->_tmp8_ = g_variant_iter_next (_data_->_tmp6_, "aa{ss}", &_data_->_tmp7_, NULL);
		_g_variant_iter_free0 (_data_->iter2);
		_data_->iter2 = _data_->_tmp7_;
		if (!_data_->_tmp8_) {
			break;
		}
		while (TRUE) {
			_data_->_tmp9_ = _data_->iter2;
			_data_->_tmp10_ = NULL;
			_data_->_tmp11_ = g_variant_iter_next (_data_->_tmp9_, "a{ss}", &_data_->_tmp10_, NULL);
			_g_variant_iter_free0 (_data_->iter3);
			_data_->iter3 = _data_->_tmp10_;
			if (!_data_->_tmp11_) {
				break;
			}
			while (TRUE) {
				_data_->_tmp12_ = _data_->iter3;
				_data_->_tmp13_ = NULL;
				_data_->_tmp14_ = NULL;
				_data_->_tmp15_ = g_variant_iter_next (_data_->_tmp12_, "{ss}", &_data_->_tmp13_, &_data_->_tmp14_, NULL);
				_g_free0 (_data_->key);
				_data_->key = _data_->_tmp13_;
				_g_free0 (_data_->self->id);
				_data_->self->id = _data_->_tmp14_;
				if (!_data_->_tmp15_) {
					break;
				}
				break;
			}
		}
	}
	_data_->_tmp16_ = _data_->self->id;
	if (_data_->_tmp16_ == NULL) {
		_data_->_tmp17_ = rygel_tracker_insertion_query_get_resource_id_query (_data_->self);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_state_ = 2;
		tracker_sparql_connection_query_async (_data_->resources, _data_->_tmp18_, NULL, rygel_tracker_insertion_query_execute_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp19_ = tracker_sparql_connection_query_finish (_data_->resources, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_g_free0 (_data_->_tmp18_);
		_data_->cursor = _data_->_tmp20_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->key);
			_g_variant_iter_free0 (_data_->iter3);
			_g_variant_iter_free0 (_data_->iter2);
			_g_variant_iter_free0 (_data_->iter1);
			_g_variant_unref0 (_data_->v);
			_g_free0 (_data_->str);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			while (TRUE) {
				_data_->_tmp22_ = _data_->cursor;
				_data_->_tmp21_ = tracker_sparql_cursor_next (_data_->_tmp22_, NULL, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch12_g_error;
				}
				if (!_data_->_tmp21_) {
					break;
				}
				_data_->_tmp23_ = _data_->cursor;
				_data_->_tmp24_ = tracker_sparql_cursor_get_string (_data_->_tmp23_, 0, NULL);
				_data_->_tmp25_ = g_strdup (_data_->_tmp24_);
				_g_free0 (_data_->self->id);
				_data_->self->id = _data_->_tmp25_;
				break;
			}
		}
		goto __finally12;
		__catch12_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_g_error_free0 (_data_->_error_);
		}
		__finally12:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->cursor);
			_g_free0 (_data_->key);
			_g_variant_iter_free0 (_data_->iter3);
			_g_variant_iter_free0 (_data_->iter2);
			_g_variant_iter_free0 (_data_->iter1);
			_g_variant_unref0 (_data_->v);
			_g_free0 (_data_->str);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->cursor);
	} else {
		_data_->_tmp26_ = _data_->self->priv->uri;
		_data_->_tmp27_ = g_file_new_for_uri (_data_->_tmp26_);
		_data_->file = _data_->_tmp27_;
		_data_->_tmp29_ = _data_->file;
		if (g_file_is_native (_data_->_tmp29_)) {
			_data_->_tmp30_ = _data_->file;
			_data_->_tmp28_ = g_file_query_exists (_data_->_tmp30_, NULL);
		} else {
			_data_->_tmp28_ = FALSE;
		}
		if (_data_->_tmp28_) {
			_data_->_tmp31_ = (RygelTrackerMinerFilesIndexIface*) g_initable_new (RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE_PROXY, NULL, &_data_->_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_TRACKER_INSERTION_QUERY_MINER_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_TRACKER_INSERTION_QUERY_MINER_PATH, "g-interface-name", "org.freedesktop.Tracker1.Miner.Files.Index", "g-interface-info", g_type_get_qdata (RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
			_data_->miner = (RygelTrackerMinerFilesIndexIface*) _data_->_tmp31_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->key);
				_g_variant_iter_free0 (_data_->iter3);
				_g_variant_iter_free0 (_data_->iter2);
				_g_variant_iter_free0 (_data_->iter1);
				_g_variant_unref0 (_data_->v);
				_g_free0 (_data_->str);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp32_ = _data_->miner;
			_data_->_tmp33_ = _data_->self->priv->uri;
			rygel_tracker_miner_files_index_iface_index_file (_data_->_tmp32_, _data_->_tmp33_, NULL, NULL);
			_g_object_unref0 (_data_->miner);
		}
		_g_object_unref0 (_data_->file);
	}
	_data_->_tmp34_ = _data_->self->id;
	g_debug ("rygel-tracker-insertion-query.vala:168: Created item in Tracker store " \
"with ID '%s'", _data_->_tmp34_);
	_g_free0 (_data_->key);
	_g_variant_iter_free0 (_data_->iter3);
	_g_variant_iter_free0 (_data_->iter2);
	_g_variant_iter_free0 (_data_->iter1);
	_g_variant_unref0 (_data_->v);
	_g_free0 (_data_->str);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
rygel_tracker_insertion_query_real_to_string (RygelTrackerQuery* base)
{
	RygelTrackerInsertionQuery * self;
	gchar* result = NULL;
	gchar* query = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	self = (RygelTrackerInsertionQuery*) base;
	_tmp0_ = RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_insertion_query_parent_class)->to_string (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("INSERT { ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, " }", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	query = _tmp5_;
	_tmp6_ = query;
	_tmp7_ = self->priv->uri;
	_tmp8_ = g_strdup_printf (RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_NOT_BOUND_TEMPLATE, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("WHERE {", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "}", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp6_, _tmp13_, NULL);
	_g_free0 (query);
	query = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	result = query;
	return result;
}

static gchar*
rygel_tracker_insertion_query_get_resource_id_query (RygelTrackerInsertionQuery* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_strdup_printf (RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_ID_QUERY_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_tracker_insertion_query_class_init (RygelTrackerInsertionQueryClass * klass,
                                          gpointer klass_data)
{
	rygel_tracker_insertion_query_parent_class = g_type_class_peek_parent (klass);
	((RygelTrackerQueryClass *) klass)->finalize = rygel_tracker_insertion_query_finalize;
	g_type_class_adjust_private_offset (klass, &RygelTrackerInsertionQuery_private_offset);
	((RygelTrackerQueryClass *) klass)->execute = (void (*) (RygelTrackerQuery*, TrackerSparqlConnection*, GAsyncReadyCallback, gpointer)) rygel_tracker_insertion_query_real_execute;
	((RygelTrackerQueryClass *) klass)->execute_finish = (void (*) (RygelTrackerQuery*, GAsyncResult*, GError**)) rygel_tracker_insertion_query_real_execute_finish;
	((RygelTrackerQueryClass *) klass)->to_string = (gchar* (*) (RygelTrackerQuery*)) rygel_tracker_insertion_query_real_to_string;
}

static void
rygel_tracker_insertion_query_instance_init (RygelTrackerInsertionQuery * self,
                                             gpointer klass)
{
	self->priv = rygel_tracker_insertion_query_get_instance_private (self);
}

static void
rygel_tracker_insertion_query_finalize (RygelTrackerQuery * obj)
{
	RygelTrackerInsertionQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQuery);
	_g_free0 (self->id);
	_g_free0 (self->priv->uri);
	RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_insertion_query_parent_class)->finalize (obj);
}

/**
 * Represents Tracker SPARQL Insertion query
 */
GType
rygel_tracker_insertion_query_get_type (void)
{
	static volatile gsize rygel_tracker_insertion_query_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_insertion_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerInsertionQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_insertion_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerInsertionQuery), 0, (GInstanceInitFunc) rygel_tracker_insertion_query_instance_init, NULL };
		GType rygel_tracker_insertion_query_type_id;
		rygel_tracker_insertion_query_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_QUERY, "RygelTrackerInsertionQuery", &g_define_type_info, 0);
		RygelTrackerInsertionQuery_private_offset = g_type_add_instance_private (rygel_tracker_insertion_query_type_id, sizeof (RygelTrackerInsertionQueryPrivate));
		g_once_init_leave (&rygel_tracker_insertion_query_type_id__volatile, rygel_tracker_insertion_query_type_id);
	}
	return rygel_tracker_insertion_query_type_id__volatile;
}

