/* rygel-lms-category-container.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-lms-category-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>,
 *           (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <rygel-server.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-db.h>
#include <gee.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_LMS_TYPE_CATEGORY_CONTAINER (rygel_lms_category_container_get_type ())
#define RYGEL_LMS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer))
#define RYGEL_LMS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))

typedef struct _RygelLMSCategoryContainer RygelLMSCategoryContainer;
typedef struct _RygelLMSCategoryContainerClass RygelLMSCategoryContainerClass;
typedef struct _RygelLMSCategoryContainerPrivate RygelLMSCategoryContainerPrivate;

#define RYGEL_LMS_TYPE_DATABASE (rygel_lms_database_get_type ())
#define RYGEL_LMS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabase))
#define RYGEL_LMS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))
#define RYGEL_LMS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))

typedef struct _RygelLMSDatabase RygelLMSDatabase;
typedef struct _RygelLMSDatabaseClass RygelLMSDatabaseClass;
enum  {
	RYGEL_LMS_CATEGORY_CONTAINER_0_PROPERTY,
	RYGEL_LMS_CATEGORY_CONTAINER_SEARCH_CLASSES_PROPERTY,
	RYGEL_LMS_CATEGORY_CONTAINER_LMS_DB_PROPERTY,
	RYGEL_LMS_CATEGORY_CONTAINER_DB_ID_PROPERTY,
	RYGEL_LMS_CATEGORY_CONTAINER_SQL_ALL_PROPERTY,
	RYGEL_LMS_CATEGORY_CONTAINER_SQL_FIND_OBJECT_PROPERTY,
	RYGEL_LMS_CATEGORY_CONTAINER_SQL_COUNT_PROPERTY,
	RYGEL_LMS_CATEGORY_CONTAINER_SQL_ADDED_PROPERTY,
	RYGEL_LMS_CATEGORY_CONTAINER_SQL_REMOVED_PROPERTY,
	RYGEL_LMS_CATEGORY_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_database_cursor_iterator_unref (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
typedef struct _RygelLmsCategoryContainerSearchData RygelLmsCategoryContainerSearchData;
typedef struct _RygelLmsCategoryContainerGetChildrenData RygelLmsCategoryContainerGetChildrenData;
typedef struct _RygelLmsCategoryContainerFindObjectData RygelLmsCategoryContainerFindObjectData;
typedef struct _RygelLmsCategoryContainerAddChildData RygelLmsCategoryContainerAddChildData;
typedef struct _RygelLmsCategoryContainerRemoveChildData RygelLmsCategoryContainerRemoveChildData;

typedef enum  {
	RYGEL_LMS_CATEGORY_CONTAINER_ERROR_SQLITE_ERROR,
	RYGEL_LMS_CATEGORY_CONTAINER_ERROR_GENERAL_ERROR,
	RYGEL_LMS_CATEGORY_CONTAINER_ERROR_INVALID_TYPE,
	RYGEL_LMS_CATEGORY_CONTAINER_ERROR_UNSUPPORTED_SEARCH
} RygelLMSCategoryContainerError;
#define RYGEL_LMS_CATEGORY_CONTAINER_ERROR rygel_lms_category_container_error_quark ()
struct _RygelLMSCategoryContainer {
	RygelMediaContainer parent_instance;
	RygelLMSCategoryContainerPrivate * priv;
	RygelDatabaseCursor* cursor_all;
	RygelDatabaseCursor* cursor_find_object;
	RygelDatabaseCursor* cursor_added;
	RygelDatabaseCursor* cursor_removed;
	gchar* child_prefix;
	gchar* ref_prefix;
};

struct _RygelLMSCategoryContainerClass {
	RygelMediaContainerClass parent_class;
	RygelMediaObject* (*object_from_statement) (RygelLMSCategoryContainer* self, sqlite3_stmt* statement);
	gchar* (*get_sql_all_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	gchar* (*get_sql_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	guint (*get_child_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args);
	RygelMediaObjects* (*get_children_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count);
};

struct _RygelLMSCategoryContainerPrivate {
	GeeArrayList* _search_classes;
	RygelLMSDatabase* _lms_db;
	gchar* _db_id;
	gchar* _sql_all;
	gchar* _sql_find_object;
	gchar* _sql_count;
	gchar* _sql_added;
	gchar* _sql_removed;
};

struct _RygelLmsCategoryContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLMSCategoryContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	GValueArray* args;
	GValueArray* _tmp0_;
	gchar* filter;
	GValueArray* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GValueArray* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GValueArray* _tmp9_;
	RygelMediaObjects* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	RygelMediaObjects* _tmp13_;
	guint _tmp14_;
	RygelMediaObjects* _tmp15_;
	RygelMediaObjects* _tmp16_;
	GError* _inner_error0_;
};

struct _RygelLmsCategoryContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLMSCategoryContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* retval;
	RygelMediaObjects* _tmp0_;
	GValue* args;
	GValue _tmp1_;
	GValue _tmp2_;
	GValue* _tmp3_;
	gint args_length1;
	gint _args_size_;
	RygelDatabaseCursor* _tmp4_;
	GValue* _tmp5_;
	gint _tmp5__length1;
	RygelDatabaseCursorIterator* _stmt_it;
	RygelDatabaseCursor* _tmp6_;
	RygelDatabaseCursorIterator* _tmp7_;
	gboolean _tmp8_;
	RygelDatabaseCursorIterator* _tmp9_;
	sqlite3_stmt* stmt;
	RygelDatabaseCursorIterator* _tmp10_;
	sqlite3_stmt* _tmp11_;
	RygelMediaObjects* _tmp12_;
	sqlite3_stmt* _tmp13_;
	RygelMediaObject* _tmp14_;
	RygelMediaObject* _tmp15_;
	GError* _inner_error0_;
};

struct _RygelLmsCategoryContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLMSCategoryContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	RygelMediaObject* object;
	gchar* real_id;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint index;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GValue* args;
	const gchar* _tmp8_;
	GValue _tmp9_;
	GValue* _tmp10_;
	gint args_length1;
	gint _args_size_;
	RygelDatabaseCursor* _tmp11_;
	GValue* _tmp12_;
	gint _tmp12__length1;
	RygelDatabaseCursorIterator* _statement_it;
	RygelDatabaseCursor* _tmp13_;
	RygelDatabaseCursorIterator* _tmp14_;
	gboolean _tmp15_;
	RygelDatabaseCursorIterator* _tmp16_;
	sqlite3_stmt* statement;
	RygelDatabaseCursorIterator* _tmp17_;
	sqlite3_stmt* _tmp18_;
	RygelMediaObject* child;
	sqlite3_stmt* _tmp19_;
	RygelMediaObject* _tmp20_;
	RygelMediaObject* _tmp21_;
	RygelMediaObject* _tmp22_;
	RygelLMSCategoryContainer* container;
	RygelMediaObject* _tmp23_;
	RygelLMSCategoryContainer* _tmp24_;
	RygelMediaObject* _tmp25_;
	RygelLMSCategoryContainer* _tmp26_;
	RygelMediaObject* _tmp27_;
	RygelMediaObject* _tmp28_;
	RygelMediaObject* _tmp29_;
	RygelMediaObject* _tmp30_;
	RygelMediaContainer* _tmp31_;
	RygelMediaContainer* _tmp32_;
	GError* e;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GError* _tmp35_;
	const gchar* _tmp36_;
	GError* _inner_error0_;
};

struct _RygelLmsCategoryContainerAddChildData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLMSCategoryContainer* self;
	RygelMediaObject* object;
};

struct _RygelLmsCategoryContainerRemoveChildData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLMSCategoryContainer* self;
	RygelMediaObject* object;
};

static gint RygelLMSCategoryContainer_private_offset;
static gpointer rygel_lms_category_container_parent_class = NULL;
static RygelTrackableContainerIface * rygel_lms_category_container_rygel_trackable_container_parent_iface = NULL;
static RygelSearchableContainerIface * rygel_lms_category_container_rygel_searchable_container_parent_iface = NULL;

GQuark rygel_lms_category_container_error_quark (void);
GType rygel_lms_category_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelLMSCategoryContainer, g_object_unref)
GType rygel_lms_database_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelLMSDatabase, g_object_unref)
RygelMediaObject* rygel_lms_category_container_object_from_statement (RygelLMSCategoryContainer* self,
                                                                      sqlite3_stmt* statement);
static RygelMediaObject* rygel_lms_category_container_real_object_from_statement (RygelLMSCategoryContainer* self,
                                                                           sqlite3_stmt* statement);
gchar* rygel_lms_category_container_get_sql_all_with_filter (RygelLMSCategoryContainer* self,
                                                             const gchar* filter);
static gchar* rygel_lms_category_container_real_get_sql_all_with_filter (RygelLMSCategoryContainer* self,
                                                                  const gchar* filter);
const gchar* rygel_lms_category_container_get_sql_all (RygelLMSCategoryContainer* self);
gchar* rygel_lms_category_container_get_sql_count_with_filter (RygelLMSCategoryContainer* self,
                                                               const gchar* filter);
static gchar* rygel_lms_category_container_real_get_sql_count_with_filter (RygelLMSCategoryContainer* self,
                                                                    const gchar* filter);
const gchar* rygel_lms_category_container_get_sql_count (RygelLMSCategoryContainer* self);
static gchar* rygel_lms_category_container_map_operand_to_column (const gchar* operand,
                                                           gchar* * collate,
                                                           gboolean for_sort,
                                                           GError** error);
static gchar* rygel_lms_category_container_relational_expression_to_sql (RygelRelationalExpression* exp,
                                                                  GValueArray* args,
                                                                  GError** error);
static void _vala_GValue_free (GValue* self);
static gchar* rygel_lms_category_container_logical_expression_to_sql (RygelLogicalExpression* expression,
                                                               GValueArray* args,
                                                               GError** error);
static gchar* rygel_lms_category_container_search_expression_to_sql (RygelSearchExpression* expression,
                                                              GValueArray* args,
                                                              GError** error);
guint rygel_lms_category_container_get_child_count_with_filter (RygelLMSCategoryContainer* self,
                                                                const gchar* where_filter,
                                                                GValueArray* args);
static guint rygel_lms_category_container_real_get_child_count_with_filter (RygelLMSCategoryContainer* self,
                                                                     const gchar* where_filter,
                                                                     GValueArray* args);
RygelLMSDatabase* rygel_lms_category_container_get_lms_db (RygelLMSCategoryContainer* self);
RygelMediaObjects* rygel_lms_category_container_get_children_with_filter (RygelLMSCategoryContainer* self,
                                                                          const gchar* where_filter,
                                                                          GValueArray* args,
                                                                          const gchar* sort_criteria,
                                                                          guint offset,
                                                                          guint max_count);
static RygelMediaObjects* rygel_lms_category_container_real_get_children_with_filter (RygelLMSCategoryContainer* self,
                                                                               const gchar* where_filter,
                                                                               GValueArray* args,
                                                                               const gchar* sort_criteria,
                                                                               guint offset,
                                                                               guint max_count);
static void rygel_lms_category_container_real_search_data_free (gpointer _data);
static void rygel_lms_category_container_real_search (RygelSearchableContainer* base,
                                               RygelSearchExpression* expression,
                                               guint offset,
                                               guint max_count,
                                               const gchar* sort_criteria,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean rygel_lms_category_container_real_search_co (RygelLmsCategoryContainerSearchData* _data_);
static void rygel_lms_category_container_search_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void rygel_lms_category_container_real_get_children_data_free (gpointer _data);
static void rygel_lms_category_container_real_get_children (RygelMediaContainer* base,
                                                     guint offset,
                                                     guint max_count,
                                                     const gchar* sort_criteria,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean rygel_lms_category_container_real_get_children_co (RygelLmsCategoryContainerGetChildrenData* _data_);
static void _vala_GValue_array_free (GValue * array,
                              gint array_length);
static void rygel_lms_category_container_real_find_object_data_free (gpointer _data);
static void rygel_lms_category_container_real_find_object (RygelMediaContainer* base,
                                                    const gchar* id,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean rygel_lms_category_container_real_find_object_co (RygelLmsCategoryContainerFindObjectData* _data_);
static void rygel_lms_category_container_find_object_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
gchar* rygel_lms_category_container_build_child_id (RygelLMSCategoryContainer* self,
                                                    gint db_id);
gchar* rygel_lms_category_container_build_reference_id (RygelLMSCategoryContainer* self,
                                                        gint db_id);
static void rygel_lms_category_container_real_add_child_data_free (gpointer _data);
static void rygel_lms_category_container_real_add_child (RygelTrackableContainer* base,
                                                  RygelMediaObject* object,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gboolean rygel_lms_category_container_real_add_child_co (RygelLmsCategoryContainerAddChildData* _data_);
static void rygel_lms_category_container_real_remove_child_data_free (gpointer _data);
static void rygel_lms_category_container_real_remove_child (RygelTrackableContainer* base,
                                                     RygelMediaObject* object,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean rygel_lms_category_container_real_remove_child_co (RygelLmsCategoryContainerRemoveChildData* _data_);
static void rygel_lms_category_container_on_db_updated (RygelLMSCategoryContainer* self,
                                                 guint64 old_id,
                                                 guint64 new_id);
RygelLMSCategoryContainer* rygel_lms_category_container_construct (GType object_type,
                                                                   const gchar* db_id,
                                                                   RygelMediaContainer* parent,
                                                                   const gchar* title,
                                                                   RygelLMSDatabase* lms_db,
                                                                   const gchar* sql_all,
                                                                   const gchar* sql_find_object,
                                                                   const gchar* sql_count,
                                                                   const gchar* sql_added,
                                                                   const gchar* sql_removed);
static void rygel_lms_category_container_set_lms_db (RygelLMSCategoryContainer* self,
                                              RygelLMSDatabase* value);
const gchar* rygel_lms_category_container_get_db_id (RygelLMSCategoryContainer* self);
static void rygel_lms_category_container_set_db_id (RygelLMSCategoryContainer* self,
                                             const gchar* value);
static void rygel_lms_category_container_set_sql_all (RygelLMSCategoryContainer* self,
                                               const gchar* value);
const gchar* rygel_lms_category_container_get_sql_find_object (RygelLMSCategoryContainer* self);
static void rygel_lms_category_container_set_sql_find_object (RygelLMSCategoryContainer* self,
                                                       const gchar* value);
static void rygel_lms_category_container_set_sql_count (RygelLMSCategoryContainer* self,
                                                 const gchar* value);
const gchar* rygel_lms_category_container_get_sql_added (RygelLMSCategoryContainer* self);
static void rygel_lms_category_container_set_sql_added (RygelLMSCategoryContainer* self,
                                                 const gchar* value);
const gchar* rygel_lms_category_container_get_sql_removed (RygelLMSCategoryContainer* self);
static void rygel_lms_category_container_set_sql_removed (RygelLMSCategoryContainer* self,
                                                   const gchar* value);
static GObject * rygel_lms_category_container_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _rygel_lms_category_container_on_db_updated_rygel_lms_database_db_updated (RygelLMSDatabase* _sender,
                                                                                guint64 old_update_id,
                                                                                guint64 new_update_id,
                                                                                gpointer self);
static void rygel_lms_category_container_finalize (GObject * obj);
static void _vala_rygel_lms_category_container_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_rygel_lms_category_container_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

GQuark
rygel_lms_category_container_error_quark (void)
{
	return g_quark_from_static_string ("rygel-lms-category-container-error-quark");
}

static inline gpointer
rygel_lms_category_container_get_instance_private (RygelLMSCategoryContainer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelLMSCategoryContainer_private_offset);
}

static RygelMediaObject*
rygel_lms_category_container_real_object_from_statement (RygelLMSCategoryContainer* self,
                                                         sqlite3_stmt* statement)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_lms_category_container_object_from_statement'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

RygelMediaObject*
rygel_lms_category_container_object_from_statement (RygelLMSCategoryContainer* self,
                                                    sqlite3_stmt* statement)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS (self)->object_from_statement (self, statement);
}

static gchar*
rygel_lms_category_container_real_get_sql_all_with_filter (RygelLMSCategoryContainer* self,
                                                           const gchar* filter)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = self->priv->_sql_all;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
rygel_lms_category_container_get_sql_all_with_filter (RygelLMSCategoryContainer* self,
                                                      const gchar* filter)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS (self)->get_sql_all_with_filter (self, filter);
}

static gchar*
rygel_lms_category_container_real_get_sql_count_with_filter (RygelLMSCategoryContainer* self,
                                                             const gchar* filter)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = self->priv->_sql_count;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
rygel_lms_category_container_get_sql_count_with_filter (RygelLMSCategoryContainer* self,
                                                        const gchar* filter)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS (self)->get_sql_count_with_filter (self, filter);
}

static gchar*
rygel_lms_category_container_map_operand_to_column (const gchar* operand,
                                                    gchar* * collate,
                                                    gboolean for_sort,
                                                    GError** error)
{
	gchar* _vala_collate = NULL;
	gchar* result = NULL;
	gchar* column = NULL;
	gboolean use_collation = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (operand != NULL, NULL);
	column = NULL;
	use_collation = FALSE;
	_tmp0_ = operand;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("title");
				_g_free0 (column);
				column = _tmp3_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("upnp:artist")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("artist");
				_g_free0 (column);
				column = _tmp4_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("creator");
				_g_free0 (column);
				column = _tmp5_;
				use_collation = TRUE;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* message = NULL;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				GError* _tmp8_;
				_tmp6_ = g_strdup_printf ("Unsupported column %s", operand);
				message = _tmp6_;
				_tmp7_ = message;
				_tmp8_ = g_error_new_literal (RYGEL_LMS_CATEGORY_CONTAINER_ERROR, RYGEL_LMS_CATEGORY_CONTAINER_ERROR_UNSUPPORTED_SEARCH, _tmp7_);
				_inner_error0_ = _tmp8_;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (message);
				_g_free0 (column);
				return NULL;
			}
		}
	}
	if (use_collation) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("COLLATE CASEFOLD");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp10_;
	}
	result = column;
	if (collate) {
		*collate = _vala_collate;
	} else {
		_g_free0 (_vala_collate);
	}
	return result;
}

static void
_vala_GValue_free (GValue* self)
{
	g_value_unset (self);
	g_free (self);
}

static gchar*
rygel_lms_category_container_relational_expression_to_sql (RygelRelationalExpression* exp,
                                                           GValueArray* args,
                                                           GError** error)
{
	gchar* result = NULL;
	GValue* v = NULL;
	gchar* collate = NULL;
	gchar* column = NULL;
	gconstpointer _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	RygelDatabaseSqlOperator* operator = NULL;
	gconstpointer _tmp3_;
	GValue* _tmp31_;
	RygelDatabaseSqlOperator* _tmp34_;
	gchar* _tmp35_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	v = NULL;
	collate = NULL;
	_tmp0_ = ((RygelSearchExpression*) exp)->operand1;
	_tmp2_ = rygel_lms_category_container_map_operand_to_column ((const gchar*) _tmp0_, &_tmp1_, FALSE, &_inner_error0_);
	_g_free0 (collate);
	collate = _tmp1_;
	column = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (collate);
		__vala_GValue_free0 (v);
		return NULL;
	}
	_tmp3_ = ((RygelSearchExpression*) exp)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp3_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
			gchar* sql_function = NULL;
			gconstpointer _tmp4_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp4_ = ((RygelSearchExpression*) exp)->operand2;
			if (g_strcmp0 ((const gchar*) _tmp4_, "true") == 0) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("%s IS NOT NULL AND %s != ''");
				_g_free0 (sql_function);
				sql_function = _tmp5_;
			} else {
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("%s IS NULL OR %s = ''");
				_g_free0 (sql_function);
				sql_function = _tmp6_;
			}
			_tmp7_ = sql_function;
			_tmp8_ = column;
			_tmp9_ = column;
			_tmp10_ = g_strdup_printf (_tmp7_, _tmp8_, _tmp9_);
			result = _tmp10_;
			_g_free0 (sql_function);
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			gconstpointer _tmp11_;
			GValue* _tmp12_ = NULL;
			gconstpointer _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			RygelDatabaseSqlOperator* _tmp16_;
			_tmp11_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp12_ = g_new0 (GValue, 1);
			g_value_init (_tmp12_, G_TYPE_STRING);
			g_value_set_string (_tmp12_, (const gchar*) _tmp11_);
			__vala_GValue_free0 (v);
			v = _tmp12_;
			_tmp13_ = ((RygelSearchExpression*) exp)->op;
			_tmp14_ = column;
			_tmp15_ = collate;
			_tmp16_ = rygel_database_sql_operator_new_from_search_criteria_op ((GUPnPSearchCriteriaOp) ((gintptr) _tmp13_), _tmp14_, _tmp15_);
			_g_object_unref0 (operator);
			operator = _tmp16_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			const gchar* _tmp17_;
			RygelDatabaseSqlFunction* _tmp18_;
			gconstpointer _tmp19_;
			GValue* _tmp20_ = NULL;
			_tmp17_ = column;
			_tmp18_ = rygel_database_sql_function_new ("contains", _tmp17_);
			_g_object_unref0 (operator);
			operator = (RygelDatabaseSqlOperator*) _tmp18_;
			_tmp19_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp20_ = g_new0 (GValue, 1);
			g_value_init (_tmp20_, G_TYPE_STRING);
			g_value_set_string (_tmp20_, (const gchar*) _tmp19_);
			__vala_GValue_free0 (v);
			v = _tmp20_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			const gchar* _tmp21_;
			RygelDatabaseSqlFunction* _tmp22_;
			gconstpointer _tmp23_;
			GValue* _tmp24_ = NULL;
			_tmp21_ = column;
			_tmp22_ = rygel_database_sql_function_new ("NOT contains", _tmp21_);
			_g_object_unref0 (operator);
			operator = (RygelDatabaseSqlOperator*) _tmp22_;
			_tmp23_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp24_ = g_new0 (GValue, 1);
			g_value_init (_tmp24_, G_TYPE_STRING);
			g_value_set_string (_tmp24_, (const gchar*) _tmp23_);
			__vala_GValue_free0 (v);
			v = _tmp24_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			const gchar* _tmp25_;
			RygelDatabaseSqlOperator* _tmp26_;
			gconstpointer _tmp27_;
			gchar* _tmp28_;
			GValue* _tmp29_ = NULL;
			_tmp25_ = column;
			_tmp26_ = rygel_database_sql_operator_new ("LIKE", _tmp25_, "");
			_g_object_unref0 (operator);
			operator = _tmp26_;
			_tmp27_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp28_ = g_strdup_printf ("%s%%", (const gchar*) _tmp27_);
			_tmp29_ = g_new0 (GValue, 1);
			g_value_init (_tmp29_, G_TYPE_STRING);
			g_value_take_string (_tmp29_, _tmp28_);
			__vala_GValue_free0 (v);
			v = _tmp29_;
			break;
		}
		default:
		{
			gconstpointer _tmp30_;
			_tmp30_ = ((RygelSearchExpression*) exp)->op;
			g_warning ("rygel-lms-category-container.vala:149: Unsupported op %d", (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp30_)));
			result = NULL;
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
	}
	_tmp31_ = v;
	if (_tmp31_ != NULL) {
		GValue* _tmp32_;
		GValue _tmp33_;
		_tmp32_ = v;
		_tmp33_ = *_tmp32_;
		g_value_array_append (args, &_tmp33_);
	}
	_tmp34_ = operator;
	_tmp35_ = rygel_database_sql_operator_to_string (_tmp34_);
	result = _tmp35_;
	_g_object_unref0 (operator);
	_g_free0 (column);
	_g_free0 (collate);
	__vala_GValue_free0 (v);
	return result;
}

static gchar*
rygel_lms_category_container_logical_expression_to_sql (RygelLogicalExpression* expression,
                                                        GValueArray* args,
                                                        GError** error)
{
	gchar* result = NULL;
	gchar* left_sql_string = NULL;
	gconstpointer _tmp0_;
	gchar* _tmp1_;
	gchar* right_sql_string = NULL;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	const gchar* operator_sql_string = NULL;
	gconstpointer _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (expression != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = ((RygelSearchExpression*) expression)->operand1;
	_tmp1_ = rygel_lms_category_container_search_expression_to_sql ((RygelSearchExpression*) _tmp0_, args, &_inner_error0_);
	left_sql_string = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = ((RygelSearchExpression*) expression)->operand2;
	_tmp3_ = rygel_lms_category_container_search_expression_to_sql ((RygelSearchExpression*) _tmp2_, args, &_inner_error0_);
	right_sql_string = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (left_sql_string);
		return NULL;
	}
	operator_sql_string = "OR";
	_tmp4_ = ((RygelSearchExpression*) expression)->op;
	if (((RygelLogicalOperator) ((gintptr) _tmp4_)) == RYGEL_LOGICAL_OPERATOR_AND) {
		operator_sql_string = "AND";
	}
	_tmp5_ = left_sql_string;
	_tmp6_ = operator_sql_string;
	_tmp7_ = right_sql_string;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp5_, _tmp6_, _tmp7_);
	result = _tmp8_;
	_g_free0 (right_sql_string);
	_g_free0 (left_sql_string);
	return result;
}

static gchar*
rygel_lms_category_container_search_expression_to_sql (RygelSearchExpression* expression,
                                                       GValueArray* args,
                                                       GError** error)
{
	gchar* result = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	if (expression == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = rygel_lms_category_container_logical_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) expression) : NULL, args, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp1_);
		return result;
	} else {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = rygel_lms_category_container_relational_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) expression) : NULL, args, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		result = _tmp6_;
		_g_free0 (_tmp4_);
		return result;
	}
}

static guint
rygel_lms_category_container_real_get_child_count_with_filter (RygelLMSCategoryContainer* self,
                                                               const gchar* where_filter,
                                                               GValueArray* args)
{
	guint result = 0U;
	gchar* query = NULL;
	gchar* _tmp0_;
	guint _tmp7_ = 0U;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (where_filter != NULL, 0U);
	g_return_val_if_fail (args != NULL, 0U);
	_tmp0_ = rygel_lms_category_container_get_sql_count_with_filter (self, where_filter);
	query = _tmp0_;
	{
		gint _tmp1_ = 0;
		RygelLMSDatabase* _tmp2_;
		GValue* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = self->priv->_lms_db;
		_tmp3_ = args->values;
		_tmp3__length1 = args->n_values;
		_tmp1_ = rygel_database_database_query_value ((RygelDatabaseDatabase*) _tmp2_, query, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint _tmp4_ = 0U;
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch2_rygel_database_database_error;
			}
			_g_free0 (query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = (guint) _tmp1_;
		_g_free0 (query);
		return result;
	}
	goto __finally2;
	__catch2_rygel_database_database_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("rygel-lms-category-container.vala:206: Query failed: %s", _tmp6_);
		result = (guint) 0;
		_g_error_free0 (e);
		_g_free0 (query);
		return result;
	}
	__finally2:
	_g_free0 (query);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp7_;
}

guint
rygel_lms_category_container_get_child_count_with_filter (RygelLMSCategoryContainer* self,
                                                          const gchar* where_filter,
                                                          GValueArray* args)
{
	g_return_val_if_fail (self != NULL, 0U);
	return RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS (self)->get_child_count_with_filter (self, where_filter, args);
}

static RygelMediaObjects*
rygel_lms_category_container_real_get_children_with_filter (RygelLMSCategoryContainer* self,
                                                            const gchar* where_filter,
                                                            GValueArray* args,
                                                            const gchar* sort_criteria,
                                                            guint offset,
                                                            guint max_count)
{
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_;
	GValue v = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_;
	gchar* query = NULL;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (where_filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	children = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_UINT);
	g_value_set_uint (&_tmp1_, max_count);
	v = _tmp1_;
	_tmp2_ = v;
	g_value_array_append (args, &_tmp2_);
	g_value_init (&_tmp3_, G_TYPE_UINT);
	g_value_set_uint (&_tmp3_, offset);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp3_;
	_tmp4_ = v;
	g_value_array_append (args, &_tmp4_);
	_tmp5_ = rygel_lms_category_container_get_sql_all_with_filter (self, where_filter);
	query = _tmp5_;
	{
		RygelDatabaseCursor* cursor = NULL;
		RygelLMSDatabase* _tmp6_;
		const gchar* _tmp7_;
		GValue* _tmp8_;
		gint _tmp8__length1;
		RygelDatabaseCursor* _tmp9_;
		_tmp6_ = self->priv->_lms_db;
		_tmp7_ = query;
		_tmp8_ = args->values;
		_tmp8__length1 = args->n_values;
		_tmp9_ = rygel_database_database_exec_cursor ((RygelDatabaseDatabase*) _tmp6_, _tmp7_, _tmp8_, (gint) _tmp8__length1, &_inner_error0_);
		cursor = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch3_rygel_database_database_error;
			}
			_g_free0 (query);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			_g_object_unref0 (children);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			RygelDatabaseCursorIterator* _stmt_it = NULL;
			RygelDatabaseCursor* _tmp10_;
			RygelDatabaseCursorIterator* _tmp11_;
			_tmp10_ = cursor;
			_tmp11_ = rygel_database_cursor_iterator (_tmp10_);
			_stmt_it = _tmp11_;
			while (TRUE) {
				gboolean _tmp12_ = FALSE;
				RygelDatabaseCursorIterator* _tmp13_;
				sqlite3_stmt* stmt = NULL;
				RygelDatabaseCursorIterator* _tmp14_;
				sqlite3_stmt* _tmp15_;
				RygelMediaObjects* _tmp16_;
				sqlite3_stmt* _tmp17_;
				RygelMediaObject* _tmp18_;
				RygelMediaObject* _tmp19_;
				_tmp13_ = _stmt_it;
				_tmp12_ = rygel_database_cursor_iterator_next (_tmp13_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch3_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					_g_free0 (query);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				if (!_tmp12_) {
					break;
				}
				_tmp14_ = _stmt_it;
				_tmp15_ = rygel_database_cursor_iterator_get (_tmp14_, &_inner_error0_);
				stmt = _tmp15_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch3_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					_g_free0 (query);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp16_ = children;
				_tmp17_ = stmt;
				_tmp18_ = rygel_lms_category_container_object_from_statement (self, _tmp17_);
				_tmp19_ = _tmp18_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp19_);
				_g_object_unref0 (_tmp19_);
			}
			_rygel_database_cursor_iterator_unref0 (_stmt_it);
		}
		_g_object_unref0 (cursor);
	}
	goto __finally3;
	__catch3_rygel_database_database_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("rygel-lms-category-container.vala:231: Query failed: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (query);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		_g_object_unref0 (children);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = children;
	_g_free0 (query);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}

RygelMediaObjects*
rygel_lms_category_container_get_children_with_filter (RygelLMSCategoryContainer* self,
                                                       const gchar* where_filter,
                                                       GValueArray* args,
                                                       const gchar* sort_criteria,
                                                       guint offset,
                                                       guint max_count)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS (self)->get_children_with_filter (self, where_filter, args, sort_criteria, offset, max_count);
}

static void
rygel_lms_category_container_real_search_data_free (gpointer _data)
{
	RygelLmsCategoryContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLmsCategoryContainerSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

static void
rygel_lms_category_container_real_search (RygelSearchableContainer* base,
                                          RygelSearchExpression* expression,
                                          guint offset,
                                          guint max_count,
                                          const gchar* sort_criteria,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	RygelLMSCategoryContainer * self;
	RygelLmsCategoryContainerSearchData* _data_;
	RygelLMSCategoryContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	self = (RygelLMSCategoryContainer*) base;
	_data_ = g_slice_new0 (RygelLmsCategoryContainerSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_lms_category_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	rygel_lms_category_container_real_search_co (_data_);
}

static RygelMediaObjects*
rygel_lms_category_container_real_search_finish (RygelSearchableContainer* base,
                                                 GAsyncResult* _res_,
                                                 guint* total_matches,
                                                 GError** error)
{
	RygelMediaObjects* result;
	RygelLmsCategoryContainerSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_lms_category_container_search_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	RygelLmsCategoryContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_lms_category_container_real_search_co (_data_);
}

static gboolean
rygel_lms_category_container_real_search_co (RygelLmsCategoryContainerSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("rygel-lms-category-container.vala:244: search()");
	{
		_data_->_tmp0_ = g_value_array_new ((guint) 0);
		_data_->args = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->args;
		_data_->_tmp2_ = rygel_lms_category_container_search_expression_to_sql (_data_->expression, _data_->_tmp1_, &_data_->_inner_error0_);
		_data_->filter = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_value_array_free0 (_data_->args);
			goto __catch4_g_error;
		}
		_data_->_tmp3_ = _data_->filter;
		_data_->_tmp4_ = _data_->args;
		_data_->total_matches = rygel_lms_category_container_get_child_count_with_filter (_data_->self, _data_->_tmp3_, _data_->_tmp4_);
		if (_data_->expression != NULL) {
			_data_->_tmp5_ = rygel_search_expression_to_string (_data_->expression);
			_data_->_tmp6_ = _data_->_tmp5_;
			g_debug ("rygel-lms-category-container.vala:252:   Original search: %s", _data_->_tmp6_);
			_g_free0 (_data_->_tmp6_);
			_data_->_tmp7_ = _data_->filter;
			g_debug ("rygel-lms-category-container.vala:253:   Parsed search expression: %s", _data_->_tmp7_);
			g_debug ("rygel-lms-category-container.vala:254:   Filtered cild count is %u", _data_->total_matches);
		}
		if (_data_->max_count == ((guint) 0)) {
			_data_->max_count = G_MAXUINT;
		}
		_data_->_tmp8_ = _data_->filter;
		_data_->_tmp9_ = _data_->args;
		_data_->_tmp10_ = rygel_lms_category_container_get_children_with_filter (_data_->self, _data_->_tmp8_, _data_->_tmp9_, _data_->sort_criteria, _data_->offset, _data_->max_count);
		_data_->result = _data_->_tmp10_;
		_g_free0 (_data_->filter);
		_g_value_array_free0 (_data_->args);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_debug ("rygel-lms-category-container.vala:267:   Falling back to simple_search" \
"(): %s", _data_->_tmp12_);
		_data_->_tmp14_ = 0U;
		_data_->_state_ = 1;
		rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->expression, _data_->offset, _data_->max_count, _data_->sort_criteria, _data_->cancellable, rygel_lms_category_container_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp15_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp14_, &_data_->_inner_error0_);
		_data_->total_matches = _data_->_tmp14_;
		_data_->_tmp13_ = _data_->_tmp15_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_error_free0 (_data_->e);
			goto __finally4;
		}
		_data_->_tmp16_ = _data_->_tmp13_;
		_data_->_tmp13_ = NULL;
		_data_->result = _data_->_tmp16_;
		_g_object_unref0 (_data_->_tmp13_);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally4:
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_lms_category_container_real_get_children_data_free (gpointer _data)
{
	RygelLmsCategoryContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLmsCategoryContainerGetChildrenData, _data_);
}

static void
rygel_lms_category_container_real_get_children (RygelMediaContainer* base,
                                                guint offset,
                                                guint max_count,
                                                const gchar* sort_criteria,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	RygelLMSCategoryContainer * self;
	RygelLmsCategoryContainerGetChildrenData* _data_;
	RygelLMSCategoryContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelLMSCategoryContainer*) base;
	_data_ = g_slice_new0 (RygelLmsCategoryContainerGetChildrenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_lms_category_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp1_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_lms_category_container_real_get_children_co (_data_);
}

static RygelMediaObjects*
rygel_lms_category_container_real_get_children_finish (RygelMediaContainer* base,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	RygelMediaObjects* result;
	RygelLmsCategoryContainerGetChildrenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_vala_GValue_array_free (GValue * array,
                         gint array_length)
{
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

static gboolean
rygel_lms_category_container_real_get_children_co (RygelLmsCategoryContainerGetChildrenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_objects_new ();
	_data_->retval = _data_->_tmp0_;
	memset (&_data_->_tmp1_, 0, sizeof (GValue));
	g_value_init (&_data_->_tmp1_, G_TYPE_UINT);
	g_value_set_uint (&_data_->_tmp1_, _data_->max_count);
	memset (&_data_->_tmp2_, 0, sizeof (GValue));
	g_value_init (&_data_->_tmp2_, G_TYPE_UINT);
	g_value_set_uint (&_data_->_tmp2_, _data_->offset);
	_data_->_tmp3_ = g_new0 (GValue, 2);
	_data_->_tmp3_[0] = _data_->_tmp1_;
	_data_->_tmp3_[1] = _data_->_tmp2_;
	_data_->args = _data_->_tmp3_;
	_data_->args_length1 = 2;
	_data_->_args_size_ = _data_->args_length1;
	_data_->_tmp4_ = _data_->self->cursor_all;
	_data_->_tmp5_ = _data_->args;
	_data_->_tmp5__length1 = _data_->args_length1;
	rygel_database_cursor_bind (_data_->_tmp4_, _data_->_tmp5_, (gint) _data_->_tmp5__length1, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
		_g_object_unref0 (_data_->retval);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp6_ = _data_->self->cursor_all;
		_data_->_tmp7_ = rygel_database_cursor_iterator (_data_->_tmp6_);
		_data_->_stmt_it = _data_->_tmp7_;
		while (TRUE) {
			_data_->_tmp9_ = _data_->_stmt_it;
			_data_->_tmp8_ = rygel_database_cursor_iterator_next (_data_->_tmp9_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_rygel_database_cursor_iterator_unref0 (_data_->_stmt_it);
				_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
				_g_object_unref0 (_data_->retval);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (!_data_->_tmp8_) {
				break;
			}
			_data_->_tmp10_ = _data_->_stmt_it;
			_data_->_tmp11_ = rygel_database_cursor_iterator_get (_data_->_tmp10_, &_data_->_inner_error0_);
			_data_->stmt = _data_->_tmp11_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_rygel_database_cursor_iterator_unref0 (_data_->_stmt_it);
				_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
				_g_object_unref0 (_data_->retval);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp12_ = _data_->retval;
			_data_->_tmp13_ = _data_->stmt;
			_data_->_tmp14_ = rygel_lms_category_container_object_from_statement (_data_->self, _data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp12_, _data_->_tmp15_);
			_g_object_unref0 (_data_->_tmp15_);
		}
		_rygel_database_cursor_iterator_unref0 (_data_->_stmt_it);
	}
	_data_->result = _data_->retval;
	_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_lms_category_container_real_find_object_data_free (gpointer _data)
{
	RygelLmsCategoryContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLmsCategoryContainerFindObjectData, _data_);
}

static void
rygel_lms_category_container_real_find_object (RygelMediaContainer* base,
                                               const gchar* id,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	RygelLMSCategoryContainer * self;
	RygelLmsCategoryContainerFindObjectData* _data_;
	RygelLMSCategoryContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelLMSCategoryContainer*) base;
	_data_ = g_slice_new0 (RygelLmsCategoryContainerFindObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_lms_category_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_lms_category_container_real_find_object_co (_data_);
}

static RygelMediaObject*
rygel_lms_category_container_real_find_object_finish (RygelMediaContainer* base,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	RygelMediaObject* result;
	RygelLmsCategoryContainerFindObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
rygel_lms_category_container_find_object_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	RygelLmsCategoryContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_lms_category_container_real_find_object_co (_data_);
}

static gboolean
rygel_lms_category_container_real_find_object_co (RygelLmsCategoryContainerFindObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->child_prefix;
	if (!g_str_has_prefix (_data_->id, _data_->_tmp0_)) {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->object = NULL;
	_data_->_tmp1_ = _data_->self->child_prefix;
	_data_->_tmp2_ = strlen (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = string_substring (_data_->id, (glong) _data_->_tmp3_, (glong) -1);
	_data_->real_id = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->real_id;
	_data_->index = string_index_of_char (_data_->_tmp5_, (gunichar) ':', 0);
	if (_data_->index > 0) {
		_data_->_tmp6_ = _data_->real_id;
		_data_->_tmp7_ = string_slice (_data_->_tmp6_, (glong) 0, (glong) _data_->index);
		_g_free0 (_data_->real_id);
		_data_->real_id = _data_->_tmp7_;
	}
	{
		_data_->_tmp8_ = _data_->real_id;
		memset (&_data_->_tmp9_, 0, sizeof (GValue));
		g_value_init (&_data_->_tmp9_, G_TYPE_INT);
		g_value_set_int (&_data_->_tmp9_, atoi (_data_->_tmp8_));
		_data_->_tmp10_ = g_new0 (GValue, 1);
		_data_->_tmp10_[0] = _data_->_tmp9_;
		_data_->args = _data_->_tmp10_;
		_data_->args_length1 = 1;
		_data_->_args_size_ = _data_->args_length1;
		_data_->_tmp11_ = _data_->self->cursor_find_object;
		_data_->_tmp12_ = _data_->args;
		_data_->_tmp12__length1 = _data_->args_length1;
		rygel_database_cursor_bind (_data_->_tmp11_, _data_->_tmp12_, (gint) _data_->_tmp12__length1, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
			if (_data_->_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch5_rygel_database_database_error;
			}
			_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
			_g_free0 (_data_->real_id);
			_g_object_unref0 (_data_->object);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp13_ = _data_->self->cursor_find_object;
			_data_->_tmp14_ = rygel_database_cursor_iterator (_data_->_tmp13_);
			_data_->_statement_it = _data_->_tmp14_;
			while (TRUE) {
				_data_->_tmp16_ = _data_->_statement_it;
				_data_->_tmp15_ = rygel_database_cursor_iterator_next (_data_->_tmp16_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_data_->_statement_it);
					_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
					if (_data_->_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch5_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_data_->_statement_it);
					_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
					_g_free0 (_data_->real_id);
					_g_object_unref0 (_data_->object);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				if (!_data_->_tmp15_) {
					break;
				}
				_data_->_tmp17_ = _data_->_statement_it;
				_data_->_tmp18_ = rygel_database_cursor_iterator_get (_data_->_tmp17_, &_data_->_inner_error0_);
				_data_->statement = _data_->_tmp18_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_data_->_statement_it);
					_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
					if (_data_->_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch5_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_data_->_statement_it);
					_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
					_g_free0 (_data_->real_id);
					_g_object_unref0 (_data_->object);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp19_ = _data_->statement;
				_data_->_tmp20_ = rygel_lms_category_container_object_from_statement (_data_->self, _data_->_tmp19_);
				_data_->child = _data_->_tmp20_;
				if (_data_->index < 0) {
					_data_->_tmp21_ = _data_->child;
					_data_->_tmp22_ = _g_object_ref0 (_data_->_tmp21_);
					_g_object_unref0 (_data_->object);
					_data_->object = _data_->_tmp22_;
				} else {
					_data_->_tmp23_ = _data_->child;
					_data_->_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp23_, RYGEL_LMS_TYPE_CATEGORY_CONTAINER) ? ((RygelLMSCategoryContainer*) _data_->_tmp23_) : NULL);
					_data_->container = _data_->_tmp24_;
					_data_->_tmp26_ = _data_->container;
					_data_->_state_ = 1;
					rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp26_, _data_->id, _data_->cancellable, rygel_lms_category_container_find_object_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp27_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp26_, _data_->_res_, &_data_->_inner_error0_);
					_data_->_tmp25_ = _data_->_tmp27_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->container);
						_g_object_unref0 (_data_->child);
						_rygel_database_cursor_iterator_unref0 (_data_->_statement_it);
						_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
						if (_data_->_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
							goto __catch5_rygel_database_database_error;
						}
						goto __finally5;
					}
					_data_->_tmp28_ = _data_->_tmp25_;
					_data_->_tmp25_ = NULL;
					_g_object_unref0 (_data_->object);
					_data_->object = _data_->_tmp28_;
					_data_->_tmp29_ = _data_->object;
					_data_->_tmp30_ = _data_->object;
					_data_->_tmp31_ = rygel_media_object_get_parent (_data_->_tmp30_);
					_data_->_tmp32_ = _data_->_tmp31_;
					rygel_media_object_set_parent_ref (_data_->_tmp29_, _data_->_tmp32_);
					_g_object_unref0 (_data_->_tmp25_);
					_g_object_unref0 (_data_->container);
				}
				_g_object_unref0 (_data_->child);
			}
			_rygel_database_cursor_iterator_unref0 (_data_->_statement_it);
		}
		_data_->args = (_vala_GValue_array_free (_data_->args, _data_->args_length1), NULL);
	}
	goto __finally5;
	__catch5_rygel_database_database_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp33_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = _data_->e;
		_data_->_tmp36_ = _data_->_tmp35_->message;
		g_debug ("rygel-lms-category-container.vala:332: find_object %s in %s: %s", _data_->id, _data_->_tmp34_, _data_->_tmp36_);
		_g_error_free0 (_data_->e);
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->real_id);
		_g_object_unref0 (_data_->object);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->object;
	_g_free0 (_data_->real_id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
rygel_lms_category_container_build_child_id (RygelLMSCategoryContainer* self,
                                             gint db_id)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->child_prefix;
	_tmp1_ = g_strdup_printf ("%s%d", _tmp0_, db_id);
	result = _tmp1_;
	return result;
}

gchar*
rygel_lms_category_container_build_reference_id (RygelLMSCategoryContainer* self,
                                                 gint db_id)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->ref_prefix;
	_tmp1_ = g_strdup_printf ("%s%d", _tmp0_, db_id);
	result = _tmp1_;
	return result;
}

static void
rygel_lms_category_container_real_add_child_data_free (gpointer _data)
{
	RygelLmsCategoryContainerAddChildData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLmsCategoryContainerAddChildData, _data_);
}

static void
rygel_lms_category_container_real_add_child (RygelTrackableContainer* base,
                                             RygelMediaObject* object,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	RygelLMSCategoryContainer * self;
	RygelLmsCategoryContainerAddChildData* _data_;
	RygelLMSCategoryContainer* _tmp0_;
	RygelMediaObject* _tmp1_;
	self = (RygelLMSCategoryContainer*) base;
	_data_ = g_slice_new0 (RygelLmsCategoryContainerAddChildData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_lms_category_container_real_add_child_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (object);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp1_;
	rygel_lms_category_container_real_add_child_co (_data_);
}

static void
rygel_lms_category_container_real_add_child_finish (RygelTrackableContainer* base,
                                                    GAsyncResult* _res_)
{
	RygelLmsCategoryContainerAddChildData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
rygel_lms_category_container_real_add_child_co (RygelLmsCategoryContainerAddChildData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_lms_category_container_real_remove_child_data_free (gpointer _data)
{
	RygelLmsCategoryContainerRemoveChildData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLmsCategoryContainerRemoveChildData, _data_);
}

static void
rygel_lms_category_container_real_remove_child (RygelTrackableContainer* base,
                                                RygelMediaObject* object,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	RygelLMSCategoryContainer * self;
	RygelLmsCategoryContainerRemoveChildData* _data_;
	RygelLMSCategoryContainer* _tmp0_;
	RygelMediaObject* _tmp1_;
	self = (RygelLMSCategoryContainer*) base;
	_data_ = g_slice_new0 (RygelLmsCategoryContainerRemoveChildData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_lms_category_container_real_remove_child_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (object);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp1_;
	rygel_lms_category_container_real_remove_child_co (_data_);
}

static void
rygel_lms_category_container_real_remove_child_finish (RygelTrackableContainer* base,
                                                       GAsyncResult* _res_)
{
	RygelLmsCategoryContainerRemoveChildData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
rygel_lms_category_container_real_remove_child_co (RygelLmsCategoryContainerRemoveChildData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_lms_category_container_on_db_updated (RygelLMSCategoryContainer* self,
                                            guint64 old_id,
                                            guint64 new_id)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint _tmp0_ = 0;
		RygelLMSDatabase* _tmp1_;
		const gchar* _tmp2_;
		guint64 _tmp3_ = 0ULL;
		GValue* args = NULL;
		GValue _tmp4_ = {0};
		GValue _tmp5_ = {0};
		GValue* _tmp6_;
		gint args_length1;
		gint _args_size_;
		RygelDatabaseCursor* _tmp7_;
		GValue* _tmp8_;
		gint _tmp8__length1;
		RygelDatabaseCursor* _tmp18_;
		GValue* _tmp19_;
		gint _tmp19__length1;
		_tmp1_ = self->priv->_lms_db;
		_tmp2_ = self->priv->_sql_count;
		_tmp0_ = rygel_database_database_query_value ((RygelDatabaseDatabase*) _tmp1_, _tmp2_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch6_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		rygel_media_container_set_child_count ((RygelMediaContainer*) self, _tmp0_);
		if (new_id < old_id) {
			_tmp3_ = (guint64) 0;
		} else {
			_tmp3_ = old_id;
		}
		g_value_init (&_tmp4_, G_TYPE_UINT64);
		g_value_set_uint64 (&_tmp4_, _tmp3_);
		g_value_init (&_tmp5_, G_TYPE_UINT64);
		g_value_set_uint64 (&_tmp5_, new_id);
		_tmp6_ = g_new0 (GValue, 2);
		_tmp6_[0] = _tmp4_;
		_tmp6_[1] = _tmp5_;
		args = _tmp6_;
		args_length1 = 2;
		_args_size_ = args_length1;
		_tmp7_ = self->cursor_added;
		_tmp8_ = args;
		_tmp8__length1 = args_length1;
		rygel_database_cursor_bind (_tmp7_, _tmp8_, (gint) _tmp8__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch6_rygel_database_database_error;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			RygelDatabaseCursorIterator* _stmt_it = NULL;
			RygelDatabaseCursor* _tmp9_;
			RygelDatabaseCursorIterator* _tmp10_;
			_tmp9_ = self->cursor_added;
			_tmp10_ = rygel_database_cursor_iterator (_tmp9_);
			_stmt_it = _tmp10_;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				RygelDatabaseCursorIterator* _tmp12_;
				sqlite3_stmt* stmt = NULL;
				RygelDatabaseCursorIterator* _tmp13_;
				sqlite3_stmt* _tmp14_;
				RygelMediaObject* object = NULL;
				sqlite3_stmt* _tmp15_;
				RygelMediaObject* _tmp16_;
				RygelMediaObject* _tmp17_;
				_tmp12_ = _stmt_it;
				_tmp11_ = rygel_database_cursor_iterator_next (_tmp12_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch6_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp13_ = _stmt_it;
				_tmp14_ = rygel_database_cursor_iterator_get (_tmp13_, &_inner_error0_);
				stmt = _tmp14_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch6_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp15_ = stmt;
				_tmp16_ = rygel_lms_category_container_object_from_statement (self, _tmp15_);
				object = _tmp16_;
				_tmp17_ = object;
				rygel_trackable_container_add_child_tracked ((RygelTrackableContainer*) self, _tmp17_, NULL, NULL);
				_g_object_unref0 (object);
			}
			_rygel_database_cursor_iterator_unref0 (_stmt_it);
		}
		_tmp18_ = self->cursor_removed;
		_tmp19_ = args;
		_tmp19__length1 = args_length1;
		rygel_database_cursor_bind (_tmp18_, _tmp19_, (gint) _tmp19__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch6_rygel_database_database_error;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			RygelDatabaseCursorIterator* _stmt_it = NULL;
			RygelDatabaseCursor* _tmp20_;
			RygelDatabaseCursorIterator* _tmp21_;
			_tmp20_ = self->cursor_removed;
			_tmp21_ = rygel_database_cursor_iterator (_tmp20_);
			_stmt_it = _tmp21_;
			while (TRUE) {
				gboolean _tmp22_ = FALSE;
				RygelDatabaseCursorIterator* _tmp23_;
				sqlite3_stmt* stmt = NULL;
				RygelDatabaseCursorIterator* _tmp24_;
				sqlite3_stmt* _tmp25_;
				RygelMediaObject* object = NULL;
				sqlite3_stmt* _tmp26_;
				RygelMediaObject* _tmp27_;
				RygelMediaObject* _tmp28_;
				_tmp23_ = _stmt_it;
				_tmp22_ = rygel_database_cursor_iterator_next (_tmp23_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch6_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				if (!_tmp22_) {
					break;
				}
				_tmp24_ = _stmt_it;
				_tmp25_ = rygel_database_cursor_iterator_get (_tmp24_, &_inner_error0_);
				stmt = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch6_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp26_ = stmt;
				_tmp27_ = rygel_lms_category_container_object_from_statement (self, _tmp26_);
				object = _tmp27_;
				_tmp28_ = object;
				rygel_trackable_container_remove_child_tracked ((RygelTrackableContainer*) self, _tmp28_, NULL, NULL);
				_g_object_unref0 (object);
			}
			_rygel_database_cursor_iterator_unref0 (_stmt_it);
		}
		args = (_vala_GValue_array_free (args, args_length1), NULL);
	}
	goto __finally6;
	__catch6_rygel_database_database_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("rygel-lms-category-container.vala:372: Can't perform container update:" \
" %s", _tmp30_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

RygelLMSCategoryContainer*
rygel_lms_category_container_construct (GType object_type,
                                        const gchar* db_id,
                                        RygelMediaContainer* parent,
                                        const gchar* title,
                                        RygelLMSDatabase* lms_db,
                                        const gchar* sql_all,
                                        const gchar* sql_find_object,
                                        const gchar* sql_count,
                                        const gchar* sql_added,
                                        const gchar* sql_removed)
{
	RygelLMSCategoryContainer * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (db_id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	g_return_val_if_fail (sql_all != NULL, NULL);
	g_return_val_if_fail (sql_find_object != NULL, NULL);
	g_return_val_if_fail (sql_count != NULL, NULL);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) parent);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:%s", _tmp1_, db_id);
	_tmp3_ = _tmp2_;
	self = (RygelLMSCategoryContainer*) g_object_new (object_type, "id", _tmp3_, "db-id", db_id, "parent", parent, "title", title, "lms-db", lms_db, "sql-all", sql_all, "sql-find-object", sql_find_object, "sql-count", sql_count, "sql-added", sql_added, "sql-removed", sql_removed, NULL);
	_g_free0 (_tmp3_);
	return self;
}

static GeeArrayList*
rygel_lms_category_container_real_get_search_classes (RygelSearchableContainer* base)
{
	GeeArrayList* result;
	RygelLMSCategoryContainer* self;
	GeeArrayList* _tmp0_;
	self = (RygelLMSCategoryContainer*) base;
	_tmp0_ = self->priv->_search_classes;
	result = _tmp0_;
	return result;
}

static void
rygel_lms_category_container_real_set_search_classes (RygelSearchableContainer* base,
                                                      GeeArrayList* value)
{
	RygelLMSCategoryContainer* self;
	self = (RygelLMSCategoryContainer*) base;
	if (rygel_lms_category_container_real_get_search_classes (base) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_search_classes);
		self->priv->_search_classes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SEARCH_CLASSES_PROPERTY]);
	}
}

RygelLMSDatabase*
rygel_lms_category_container_get_lms_db (RygelLMSCategoryContainer* self)
{
	RygelLMSDatabase* result;
	RygelLMSDatabase* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lms_db;
	result = _tmp0_;
	return result;
}

static void
rygel_lms_category_container_set_lms_db (RygelLMSCategoryContainer* self,
                                         RygelLMSDatabase* value)
{
	g_return_if_fail (self != NULL);
	if (rygel_lms_category_container_get_lms_db (self) != value) {
		self->priv->_lms_db = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_LMS_DB_PROPERTY]);
	}
}

const gchar*
rygel_lms_category_container_get_db_id (RygelLMSCategoryContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_db_id;
	result = _tmp0_;
	return result;
}

static void
rygel_lms_category_container_set_db_id (RygelLMSCategoryContainer* self,
                                        const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_lms_category_container_get_db_id (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_db_id);
		self->priv->_db_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_DB_ID_PROPERTY]);
	}
}

const gchar*
rygel_lms_category_container_get_sql_all (RygelLMSCategoryContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql_all;
	result = _tmp0_;
	return result;
}

static void
rygel_lms_category_container_set_sql_all (RygelLMSCategoryContainer* self,
                                          const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_lms_category_container_get_sql_all (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sql_all);
		self->priv->_sql_all = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SQL_ALL_PROPERTY]);
	}
}

const gchar*
rygel_lms_category_container_get_sql_find_object (RygelLMSCategoryContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql_find_object;
	result = _tmp0_;
	return result;
}

static void
rygel_lms_category_container_set_sql_find_object (RygelLMSCategoryContainer* self,
                                                  const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_lms_category_container_get_sql_find_object (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sql_find_object);
		self->priv->_sql_find_object = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SQL_FIND_OBJECT_PROPERTY]);
	}
}

const gchar*
rygel_lms_category_container_get_sql_count (RygelLMSCategoryContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql_count;
	result = _tmp0_;
	return result;
}

static void
rygel_lms_category_container_set_sql_count (RygelLMSCategoryContainer* self,
                                            const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_lms_category_container_get_sql_count (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sql_count);
		self->priv->_sql_count = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SQL_COUNT_PROPERTY]);
	}
}

const gchar*
rygel_lms_category_container_get_sql_added (RygelLMSCategoryContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql_added;
	result = _tmp0_;
	return result;
}

static void
rygel_lms_category_container_set_sql_added (RygelLMSCategoryContainer* self,
                                            const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_lms_category_container_get_sql_added (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sql_added);
		self->priv->_sql_added = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SQL_ADDED_PROPERTY]);
	}
}

const gchar*
rygel_lms_category_container_get_sql_removed (RygelLMSCategoryContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql_removed;
	result = _tmp0_;
	return result;
}

static void
rygel_lms_category_container_set_sql_removed (RygelLMSCategoryContainer* self,
                                              const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_lms_category_container_get_sql_removed (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sql_removed);
		self->priv->_sql_removed = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SQL_REMOVED_PROPERTY]);
	}
}

static void
_rygel_lms_category_container_on_db_updated_rygel_lms_database_db_updated (RygelLMSDatabase* _sender,
                                                                           guint64 old_update_id,
                                                                           guint64 new_update_id,
                                                                           gpointer self)
{
	rygel_lms_category_container_on_db_updated ((RygelLMSCategoryContainer*) self, old_update_id, new_update_id);
}

static GObject *
rygel_lms_category_container_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	RygelLMSCategoryContainer * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gint index = 0;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (rygel_lms_category_container_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s:", _tmp3_);
	_g_free0 (self->child_prefix);
	self->child_prefix = _tmp4_;
	_tmp5_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp6_ = _tmp5_;
	index = string_index_of_char (_tmp6_, (gunichar) ':', 0);
	_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_slice (_tmp8_, (glong) 0, (glong) index);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, ":all:", NULL);
	_g_free0 (self->ref_prefix);
	self->ref_prefix = _tmp11_;
	_g_free0 (_tmp10_);
	{
		RygelDatabaseCursor* _tmp12_ = NULL;
		RygelLMSDatabase* _tmp13_;
		const gchar* _tmp14_;
		RygelDatabaseCursor* _tmp15_;
		RygelDatabaseCursor* _tmp16_;
		RygelDatabaseCursor* _tmp17_ = NULL;
		RygelLMSDatabase* _tmp18_;
		const gchar* _tmp19_;
		RygelDatabaseCursor* _tmp20_;
		RygelDatabaseCursor* _tmp21_;
		gint _tmp22_ = 0;
		RygelLMSDatabase* _tmp23_;
		const gchar* _tmp24_;
		gboolean _tmp25_ = FALSE;
		const gchar* _tmp26_;
		_tmp13_ = self->priv->_lms_db;
		_tmp14_ = self->priv->_sql_all;
		_tmp15_ = rygel_database_database_exec_cursor ((RygelDatabaseDatabase*) _tmp13_, _tmp14_, NULL, (gint) 0, &_inner_error0_);
		_tmp12_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch7_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp16_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (self->cursor_all);
		self->cursor_all = _tmp16_;
		_tmp18_ = self->priv->_lms_db;
		_tmp19_ = self->priv->_sql_find_object;
		_tmp20_ = rygel_database_database_exec_cursor ((RygelDatabaseDatabase*) _tmp18_, _tmp19_, NULL, (gint) 0, &_inner_error0_);
		_tmp17_ = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp12_);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch7_rygel_database_database_error;
			}
			_g_object_unref0 (_tmp12_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp21_ = _tmp17_;
		_tmp17_ = NULL;
		_g_object_unref0 (self->cursor_find_object);
		self->cursor_find_object = _tmp21_;
		_tmp23_ = self->priv->_lms_db;
		_tmp24_ = self->priv->_sql_count;
		_tmp22_ = rygel_database_database_query_value ((RygelDatabaseDatabase*) _tmp23_, _tmp24_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp17_);
			_g_object_unref0 (_tmp12_);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch7_rygel_database_database_error;
			}
			_g_object_unref0 (_tmp17_);
			_g_object_unref0 (_tmp12_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		rygel_media_container_set_child_count ((RygelMediaContainer*) self, _tmp22_);
		_tmp26_ = self->priv->_sql_added;
		if (_tmp26_ != NULL) {
			const gchar* _tmp27_;
			_tmp27_ = self->priv->_sql_removed;
			_tmp25_ = _tmp27_ != NULL;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			RygelDatabaseCursor* _tmp28_ = NULL;
			RygelLMSDatabase* _tmp29_;
			const gchar* _tmp30_;
			RygelDatabaseCursor* _tmp31_;
			RygelDatabaseCursor* _tmp32_;
			RygelDatabaseCursor* _tmp33_ = NULL;
			RygelLMSDatabase* _tmp34_;
			const gchar* _tmp35_;
			RygelDatabaseCursor* _tmp36_;
			RygelDatabaseCursor* _tmp37_;
			RygelLMSDatabase* _tmp38_;
			_tmp29_ = self->priv->_lms_db;
			_tmp30_ = self->priv->_sql_added;
			_tmp31_ = rygel_database_database_exec_cursor ((RygelDatabaseDatabase*) _tmp29_, _tmp30_, NULL, (gint) 0, &_inner_error0_);
			_tmp28_ = _tmp31_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp17_);
				_g_object_unref0 (_tmp12_);
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch7_rygel_database_database_error;
				}
				_g_object_unref0 (_tmp17_);
				_g_object_unref0 (_tmp12_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp32_ = _tmp28_;
			_tmp28_ = NULL;
			_g_object_unref0 (self->cursor_added);
			self->cursor_added = _tmp32_;
			_tmp34_ = self->priv->_lms_db;
			_tmp35_ = self->priv->_sql_removed;
			_tmp36_ = rygel_database_database_exec_cursor ((RygelDatabaseDatabase*) _tmp34_, _tmp35_, NULL, (gint) 0, &_inner_error0_);
			_tmp33_ = _tmp36_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (_tmp17_);
				_g_object_unref0 (_tmp12_);
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch7_rygel_database_database_error;
				}
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (_tmp17_);
				_g_object_unref0 (_tmp12_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp37_ = _tmp33_;
			_tmp33_ = NULL;
			_g_object_unref0 (self->cursor_removed);
			self->cursor_removed = _tmp37_;
			_tmp38_ = self->priv->_lms_db;
			g_signal_connect_object (_tmp38_, "db-updated", (GCallback) _rygel_lms_category_container_on_db_updated_rygel_lms_database_db_updated, self, 0);
			_g_object_unref0 (_tmp33_);
			_g_object_unref0 (_tmp28_);
		}
		_g_object_unref0 (_tmp17_);
		_g_object_unref0 (_tmp12_);
	}
	goto __finally7;
	__catch7_rygel_database_database_error:
	{
		GError* e = NULL;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp39_ = rygel_media_object_get_title ((RygelMediaObject*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		g_warning ("rygel-lms-category-container.vala:422: Container %s: %s", _tmp40_, _tmp42_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
rygel_lms_category_container_class_init (RygelLMSCategoryContainerClass * klass,
                                         gpointer klass_data)
{
	rygel_lms_category_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelLMSCategoryContainer_private_offset);
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*) (RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_category_container_real_object_from_statement;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_all_with_filter = (gchar* (*) (RygelLMSCategoryContainer*, const gchar*)) rygel_lms_category_container_real_get_sql_all_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_count_with_filter = (gchar* (*) (RygelLMSCategoryContainer*, const gchar*)) rygel_lms_category_container_real_get_sql_count_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_child_count_with_filter = (guint (*) (RygelLMSCategoryContainer*, const gchar*, GValueArray*)) rygel_lms_category_container_real_get_child_count_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_children_with_filter = (RygelMediaObjects* (*) (RygelLMSCategoryContainer*, const gchar*, GValueArray*, const gchar*, guint, guint)) rygel_lms_category_container_real_get_children_with_filter;
	((RygelMediaContainerClass *) klass)->get_children = (void (*) (RygelMediaContainer*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_lms_category_container_real_get_children;
	((RygelMediaContainerClass *) klass)->get_children_finish = (RygelMediaObjects* (*) (RygelMediaContainer*, GAsyncResult*, GError**)) rygel_lms_category_container_real_get_children_finish;
	((RygelMediaContainerClass *) klass)->find_object = (void (*) (RygelMediaContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_lms_category_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = (RygelMediaObject* (*) (RygelMediaContainer*, GAsyncResult*, GError**)) rygel_lms_category_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_lms_category_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_lms_category_container_set_property;
	G_OBJECT_CLASS (klass)->constructor = rygel_lms_category_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = rygel_lms_category_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SEARCH_CLASSES_PROPERTY, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SEARCH_CLASSES_PROPERTY] = g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_LMS_DB_PROPERTY, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_LMS_DB_PROPERTY] = g_param_spec_object ("lms-db", "lms-db", "lms-db", RYGEL_LMS_TYPE_DATABASE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_DB_ID_PROPERTY, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_DB_ID_PROPERTY] = g_param_spec_string ("db-id", "db-id", "db-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SQL_ALL_PROPERTY, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SQL_ALL_PROPERTY] = g_param_spec_string ("sql-all", "sql-all", "sql-all", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SQL_FIND_OBJECT_PROPERTY, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SQL_FIND_OBJECT_PROPERTY] = g_param_spec_string ("sql-find-object", "sql-find-object", "sql-find-object", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SQL_COUNT_PROPERTY, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SQL_COUNT_PROPERTY] = g_param_spec_string ("sql-count", "sql-count", "sql-count", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SQL_ADDED_PROPERTY, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SQL_ADDED_PROPERTY] = g_param_spec_string ("sql-added", "sql-added", "sql-added", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SQL_REMOVED_PROPERTY, rygel_lms_category_container_properties[RYGEL_LMS_CATEGORY_CONTAINER_SQL_REMOVED_PROPERTY] = g_param_spec_string ("sql-removed", "sql-removed", "sql-removed", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
rygel_lms_category_container_rygel_trackable_container_interface_init (RygelTrackableContainerIface * iface,
                                                                       gpointer iface_data)
{
	rygel_lms_category_container_rygel_trackable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_child = (void (*) (RygelTrackableContainer*, RygelMediaObject*, GAsyncReadyCallback, gpointer)) rygel_lms_category_container_real_add_child;
	iface->add_child_finish = (void (*) (RygelTrackableContainer*, GAsyncResult*)) rygel_lms_category_container_real_add_child_finish;
	iface->remove_child = (void (*) (RygelTrackableContainer*, RygelMediaObject*, GAsyncReadyCallback, gpointer)) rygel_lms_category_container_real_remove_child;
	iface->remove_child_finish = (void (*) (RygelTrackableContainer*, GAsyncResult*)) rygel_lms_category_container_real_remove_child_finish;
}

static void
rygel_lms_category_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface,
                                                                        gpointer iface_data)
{
	rygel_lms_category_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (RygelSearchableContainer*, RygelSearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_lms_category_container_real_search;
	iface->search_finish = (RygelMediaObjects* (*) (RygelSearchableContainer*, GAsyncResult*, guint*, GError**)) rygel_lms_category_container_real_search_finish;
	iface->get_search_classes = rygel_lms_category_container_real_get_search_classes;
	iface->set_search_classes = rygel_lms_category_container_real_set_search_classes;
}

static void
rygel_lms_category_container_instance_init (RygelLMSCategoryContainer * self,
                                            gpointer klass)
{
	self->priv = rygel_lms_category_container_get_instance_private (self);
}

static void
rygel_lms_category_container_finalize (GObject * obj)
{
	RygelLMSCategoryContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer);
	_g_object_unref0 (self->priv->_search_classes);
	_g_free0 (self->priv->_db_id);
	_g_free0 (self->priv->_sql_all);
	_g_free0 (self->priv->_sql_find_object);
	_g_free0 (self->priv->_sql_count);
	_g_free0 (self->priv->_sql_added);
	_g_free0 (self->priv->_sql_removed);
	_g_object_unref0 (self->cursor_all);
	_g_object_unref0 (self->cursor_find_object);
	_g_object_unref0 (self->cursor_added);
	_g_object_unref0 (self->cursor_removed);
	_g_free0 (self->child_prefix);
	_g_free0 (self->ref_prefix);
	G_OBJECT_CLASS (rygel_lms_category_container_parent_class)->finalize (obj);
}

GType
rygel_lms_category_container_get_type (void)
{
	static volatile gsize rygel_lms_category_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_lms_category_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLMSCategoryContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_category_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSCategoryContainer), 0, (GInstanceInitFunc) rygel_lms_category_container_instance_init, NULL };
		static const GInterfaceInfo rygel_trackable_container_info = { (GInterfaceInitFunc) rygel_lms_category_container_rygel_trackable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_lms_category_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_lms_category_container_type_id;
		rygel_lms_category_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelLMSCategoryContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_lms_category_container_type_id, RYGEL_TYPE_TRACKABLE_CONTAINER, &rygel_trackable_container_info);
		g_type_add_interface_static (rygel_lms_category_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		RygelLMSCategoryContainer_private_offset = g_type_add_instance_private (rygel_lms_category_container_type_id, sizeof (RygelLMSCategoryContainerPrivate));
		g_once_init_leave (&rygel_lms_category_container_type_id__volatile, rygel_lms_category_container_type_id);
	}
	return rygel_lms_category_container_type_id__volatile;
}

static void
_vala_rygel_lms_category_container_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	RygelLMSCategoryContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer);
	switch (property_id) {
		case RYGEL_LMS_CATEGORY_CONTAINER_SEARCH_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_LMS_DB_PROPERTY:
		g_value_set_object (value, rygel_lms_category_container_get_lms_db (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_DB_ID_PROPERTY:
		g_value_set_string (value, rygel_lms_category_container_get_db_id (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_ALL_PROPERTY:
		g_value_set_string (value, rygel_lms_category_container_get_sql_all (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_FIND_OBJECT_PROPERTY:
		g_value_set_string (value, rygel_lms_category_container_get_sql_find_object (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_COUNT_PROPERTY:
		g_value_set_string (value, rygel_lms_category_container_get_sql_count (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_ADDED_PROPERTY:
		g_value_set_string (value, rygel_lms_category_container_get_sql_added (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_REMOVED_PROPERTY:
		g_value_set_string (value, rygel_lms_category_container_get_sql_removed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_lms_category_container_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	RygelLMSCategoryContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer);
	switch (property_id) {
		case RYGEL_LMS_CATEGORY_CONTAINER_SEARCH_CLASSES_PROPERTY:
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_LMS_DB_PROPERTY:
		rygel_lms_category_container_set_lms_db (self, g_value_get_object (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_DB_ID_PROPERTY:
		rygel_lms_category_container_set_db_id (self, g_value_get_string (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_ALL_PROPERTY:
		rygel_lms_category_container_set_sql_all (self, g_value_get_string (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_FIND_OBJECT_PROPERTY:
		rygel_lms_category_container_set_sql_find_object (self, g_value_get_string (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_COUNT_PROPERTY:
		rygel_lms_category_container_set_sql_count (self, g_value_get_string (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_ADDED_PROPERTY:
		rygel_lms_category_container_set_sql_added (self, g_value_get_string (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_REMOVED_PROPERTY:
		rygel_lms_category_container_set_sql_removed (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

