/* rygel-energy-management.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-energy-management.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
/* EnergyManagement service implementation. The service will be run on
 * plugins that have
 *     energy-management=true
 * set in their configuration. It requires UPower to function properly.
 *
 * Every network interface that supports Wake-On should have a
 * configuration group:
 *     [EnergyManagement-eth0]
 *     mode-on-suspend=IP-down-WakeOn
 *     supported-transport=UDP-Broadcast
 *     password=FEEDDEADBEEF
 * mode-on-suspend is required (without it the mode will always be
 * "Unimplemented"), other configuration items are not.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <glib.h>
#include <gee.h>
#include <libgssdp/gssdp.h>
#include <glib/gi18n-lib.h>

#define TYPE_UPOWER (upower_get_type ())
#define UPOWER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPOWER, UPower))
#define IS_UPOWER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPOWER))
#define UPOWER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_UPOWER, UPowerIface))

typedef struct _UPower UPower;
typedef struct _UPowerIface UPowerIface;

#define TYPE_UPOWER_PROXY (upower_proxy_get_type ())
enum  {
	UPOWER_SLEEPING_SIGNAL,
	UPOWER_RESUMING_SIGNAL,
	UPOWER_NUM_SIGNALS
};
static guint upower_signals[UPOWER_NUM_SIGNALS] = {0};
typedef GDBusProxy UPowerProxy;
typedef GDBusProxyClass UPowerProxyClass;

#define RYGEL_TYPE_ENERGY_MANAGEMENT (rygel_energy_management_get_type ())
#define RYGEL_ENERGY_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagement))
#define RYGEL_ENERGY_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagementClass))
#define RYGEL_IS_ENERGY_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENERGY_MANAGEMENT))
#define RYGEL_IS_ENERGY_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENERGY_MANAGEMENT))
#define RYGEL_ENERGY_MANAGEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagementClass))

typedef struct _RygelEnergyManagement RygelEnergyManagement;
typedef struct _RygelEnergyManagementClass RygelEnergyManagementClass;
typedef struct _RygelEnergyManagementPrivate RygelEnergyManagementPrivate;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
enum  {
	RYGEL_ENERGY_MANAGEMENT_0_PROPERTY,
	RYGEL_ENERGY_MANAGEMENT_NUM_PROPERTIES
};
static GParamSpec* rygel_energy_management_properties[RYGEL_ENERGY_MANAGEMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _UPowerIface {
	GTypeInterface parent_iface;
};

struct _RygelEnergyManagement {
	GUPnPService parent_instance;
	RygelEnergyManagementPrivate * priv;
};

struct _RygelEnergyManagementClass {
	GUPnPServiceClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gchar* (*get_interface) (RygelConfiguration* self, GError** error) G_GNUC_DEPRECATED;
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelEnergyManagementPrivate {
	RygelConfiguration* config;
	gboolean sleeping;
	UPower* upower;
};

static gint RygelEnergyManagement_private_offset;
static gpointer rygel_energy_management_parent_class = NULL;

GType upower_get_type (void) G_GNUC_CONST;
GType upower_proxy_get_type (void) G_GNUC_CONST;
guint upower_register_object (void* object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error);
static void upower_proxy_g_signal (GDBusProxy* proxy,
                            const gchar* sender_name,
                            const gchar* signal_name,
                            GVariant* parameters);
static void _dbus_handle_upower_sleeping (UPower* self,
                                   GVariant* parameters);
static void _dbus_handle_upower_resuming (UPower* self,
                                   GVariant* parameters);
static void upower_proxy_upower_interface_init (UPowerIface* iface);
static void upower_dbus_interface_method_call (GDBusConnection* connection,
                                        const gchar* sender,
                                        const gchar* object_path,
                                        const gchar* interface_name,
                                        const gchar* method_name,
                                        GVariant* parameters,
                                        GDBusMethodInvocation* invocation,
                                        gpointer user_data);
static GVariant* upower_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data);
static gboolean upower_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data);
static void _dbus_upower_sleeping (GObject* _sender,
                            gpointer* _data);
static void _dbus_upower_resuming (GObject* _sender,
                            gpointer* _data);
static void _upower_unregister_object (gpointer user_data);
GType rygel_energy_management_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelEnergyManagement, g_object_unref)
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_ENERGY_MANAGEMENT_UPNP_ID "urn:upnp-org:serviceId:EnergyManagement"
#define RYGEL_ENERGY_MANAGEMENT_UPNP_TYPE "urn:schemas-upnp-org:service:EnergyManagement:1"
#define RYGEL_ENERGY_MANAGEMENT_DESCRIPTION_PATH "xml/EnergyManagement.xml"
#define RYGEL_ENERGY_MANAGEMENT_TEMPLATE "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" "<NetworkInterfaceInfo xsi:schemaLocation=\"urn:schemas-upnp-org:lp:em-" \
"NetworkInterfaceInfo http://www.upnp.org/schemas/lp/em-NetworkInterfac" \
"eInfo.xsd\" " "                      xmlns=\"urn:schemas-upnp-org:lp:em-NetworkInterf" \
"aceInfo\" " "                      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-ins" \
"tance\">" "%s" "</NetworkInterfaceInfo>"
static void rygel_energy_management_real_constructed (GObject* base);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMetaConfig, g_object_unref)
RygelMetaConfig* rygel_meta_config_get_default (void);
static void rygel_energy_management_upower_sleeping_cb (RygelEnergyManagement* self);
static void _rygel_energy_management_upower_sleeping_cb_upower_sleeping (UPower* _sender,
                                                                  gpointer self);
static void rygel_energy_management_upower_resuming_cb (RygelEnergyManagement* self);
static void _rygel_energy_management_upower_resuming_cb_upower_resuming (UPower* _sender,
                                                                  gpointer self);
static void rygel_energy_management_query_network_interface_info_cb (RygelEnergyManagement* self,
                                                              GUPnPService* em,
                                                              const gchar* var,
                                                              GValue* val);
static void _rygel_energy_management_query_network_interface_info_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                            const gchar* variable,
                                                                                            GValue* value,
                                                                                            gpointer self);
static void rygel_energy_management_query_proxied_network_interface_info_cb (RygelEnergyManagement* self,
                                                                      GUPnPService* em,
                                                                      const gchar* var,
                                                                      GValue* val);
static void _rygel_energy_management_query_proxied_network_interface_info_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                                    const gchar* variable,
                                                                                                    GValue* value,
                                                                                                    gpointer self);
static void rygel_energy_management_get_interface_info_cb (RygelEnergyManagement* self,
                                                    GUPnPService* em,
                                                    GUPnPServiceAction* action);
static void _rygel_energy_management_get_interface_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                  GUPnPServiceAction* action,
                                                                                  gpointer self);
static gchar* rygel_energy_management_create_network_interface_info (RygelEnergyManagement* self);
gboolean rygel_energy_management_get_mac_and_network_type (const gchar* iface,
                                                           gchar* * mac,
                                                           gchar* * type);
gchar* rygel_configuration_get_string (RygelConfiguration* self,
                                       const gchar* section,
                                       const gchar* key,
                                       GError** error);
static gchar* rygel_energy_management_create_proxied_network_interface_info (RygelEnergyManagement* self);
RygelEnergyManagement* rygel_energy_management_new (void);
RygelEnergyManagement* rygel_energy_management_construct (GType object_type);
static void rygel_energy_management_finalize (GObject * obj);

static const GDBusMethodInfo * const _upower_dbus_method_info[] = {NULL};
static const GDBusArgInfo * const _upower_dbus_arg_info_sleeping[] = {NULL};
static const GDBusSignalInfo _upower_dbus_signal_info_sleeping = {-1, "Sleeping", (GDBusArgInfo **) (&_upower_dbus_arg_info_sleeping), NULL};
static const GDBusArgInfo * const _upower_dbus_arg_info_resuming[] = {NULL};
static const GDBusSignalInfo _upower_dbus_signal_info_resuming = {-1, "Resuming", (GDBusArgInfo **) (&_upower_dbus_arg_info_resuming), NULL};
static const GDBusSignalInfo * const _upower_dbus_signal_info[] = {&_upower_dbus_signal_info_sleeping, &_upower_dbus_signal_info_resuming, NULL};
static const GDBusPropertyInfo * const _upower_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _upower_dbus_interface_info = {-1, "org.freedesktop.UPower", (GDBusMethodInfo **) (&_upower_dbus_method_info), (GDBusSignalInfo **) (&_upower_dbus_signal_info), (GDBusPropertyInfo **) (&_upower_dbus_property_info), NULL};
static const GDBusInterfaceVTable _upower_dbus_interface_vtable = {upower_dbus_interface_method_call, upower_dbus_interface_get_property, upower_dbus_interface_set_property};

static void
upower_default_init (UPowerIface * iface,
                     gpointer iface_data)
{
	upower_signals[UPOWER_SLEEPING_SIGNAL] = g_signal_new ("sleeping", TYPE_UPOWER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	upower_signals[UPOWER_RESUMING_SIGNAL] = g_signal_new ("resuming", TYPE_UPOWER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

GType
upower_get_type (void)
{
	static volatile gsize upower_type_id__volatile = 0;
	if (g_once_init_enter (&upower_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UPowerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) upower_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType upower_type_id;
		upower_type_id = g_type_register_static (G_TYPE_INTERFACE, "UPower", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (upower_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (upower_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) upower_proxy_get_type);
		g_type_set_qdata (upower_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.UPower");
		g_type_set_qdata (upower_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_upower_dbus_interface_info));
		g_type_set_qdata (upower_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) upower_register_object);
		g_once_init_leave (&upower_type_id__volatile, upower_type_id);
	}
	return upower_type_id__volatile;
}

G_DEFINE_TYPE_EXTENDED (UPowerProxy, upower_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_UPOWER, upower_proxy_upower_interface_init) )
static void
upower_proxy_class_init (UPowerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = upower_proxy_g_signal;
}

static void
_dbus_handle_upower_sleeping (UPower* self,
                              GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "sleeping");
}

static void
_dbus_handle_upower_resuming (UPower* self,
                              GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "resuming");
}

static void
upower_proxy_g_signal (GDBusProxy* proxy,
                       const gchar* sender_name,
                       const gchar* signal_name,
                       GVariant* parameters)
{
	if (strcmp (signal_name, "Sleeping") == 0) {
		_dbus_handle_upower_sleeping ((UPower*) proxy, parameters);
	} else if (strcmp (signal_name, "Resuming") == 0) {
		_dbus_handle_upower_resuming ((UPower*) proxy, parameters);
	}
}

static void
upower_proxy_init (UPowerProxy* self)
{
}

static void
upower_proxy_upower_interface_init (UPowerIface* iface)
{
}

static void
upower_dbus_interface_method_call (GDBusConnection* connection,
                                   const gchar* sender,
                                   const gchar* object_path,
                                   const gchar* interface_name,
                                   const gchar* method_name,
                                   GVariant* parameters,
                                   GDBusMethodInvocation* invocation,
                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
upower_dbus_interface_get_property (GDBusConnection* connection,
                                    const gchar* sender,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* property_name,
                                    GError** error,
                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
upower_dbus_interface_set_property (GDBusConnection* connection,
                                    const gchar* sender,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* property_name,
                                    GVariant* value,
                                    GError** error,
                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_upower_sleeping (GObject* _sender,
                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.UPower", "Sleeping", _arguments, NULL);
}

static void
_dbus_upower_resuming (GObject* _sender,
                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.UPower", "Resuming", _arguments, NULL);
}

guint
upower_register_object (gpointer object,
                        GDBusConnection* connection,
                        const gchar* path,
                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_upower_dbus_interface_info), &_upower_dbus_interface_vtable, data, _upower_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "sleeping", (GCallback) _dbus_upower_sleeping, data);
	g_signal_connect (object, "resuming", (GCallback) _dbus_upower_resuming, data);
	return result;
}

static void
_upower_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_upower_sleeping, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_upower_resuming, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
rygel_energy_management_get_instance_private (RygelEnergyManagement* self)
{
	return G_STRUCT_MEMBER_P (self, RygelEnergyManagement_private_offset);
}

static void
_rygel_energy_management_upower_sleeping_cb_upower_sleeping (UPower* _sender,
                                                             gpointer self)
{
	rygel_energy_management_upower_sleeping_cb ((RygelEnergyManagement*) self);
}

static void
_rygel_energy_management_upower_resuming_cb_upower_resuming (UPower* _sender,
                                                             gpointer self)
{
	rygel_energy_management_upower_resuming_cb ((RygelEnergyManagement*) self);
}

static void
_rygel_energy_management_query_network_interface_info_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                       const gchar* variable,
                                                                                       GValue* value,
                                                                                       gpointer self)
{
	rygel_energy_management_query_network_interface_info_cb ((RygelEnergyManagement*) self, _sender, variable, value);
}

static void
_rygel_energy_management_query_proxied_network_interface_info_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                               const gchar* variable,
                                                                                               GValue* value,
                                                                                               gpointer self)
{
	rygel_energy_management_query_proxied_network_interface_info_cb ((RygelEnergyManagement*) self, _sender, variable, value);
}

static void
_rygel_energy_management_get_interface_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                             GUPnPServiceAction* action,
                                                                             gpointer self)
{
	rygel_energy_management_get_interface_info_cb ((RygelEnergyManagement*) self, _sender, action);
}

static void
rygel_energy_management_real_constructed (GObject* base)
{
	RygelEnergyManagement * self;
	RygelMetaConfig* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (RygelEnergyManagement*) base;
	G_OBJECT_CLASS (rygel_energy_management_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
	_tmp0_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp0_;
	self->priv->sleeping = FALSE;
	{
		UPower* _tmp1_ = NULL;
		UPower* _tmp2_;
		UPower* _tmp3_;
		UPower* _tmp4_;
		UPower* _tmp5_;
		_tmp2_ = (UPower*) g_initable_new (TYPE_UPOWER_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", "org.freedesktop.UPower", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/UPower", "g-interface-name", "org.freedesktop.UPower", "g-interface-info", g_type_get_qdata (TYPE_UPOWER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_tmp1_ = (UPower*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch7_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->upower);
		self->priv->upower = _tmp3_;
		_tmp4_ = self->priv->upower;
		g_signal_connect_object (_tmp4_, "sleeping", (GCallback) _rygel_energy_management_upower_sleeping_cb_upower_sleeping, self, 0);
		_tmp5_ = self->priv->upower;
		g_signal_connect_object (_tmp5_, "resuming", (GCallback) _rygel_energy_management_upower_resuming_cb_upower_resuming, self, 0);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally7;
	__catch7_g_io_error:
	{
		GError* err = NULL;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (err);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_connect_object ((GUPnPService*) self, "query-variable::NetworkInterfaceInfo", (GCallback) _rygel_energy_management_query_network_interface_info_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ProxiedNetworkInterfaceInfo", (GCallback) _rygel_energy_management_query_proxied_network_interface_info_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetInterfaceInfo", (GCallback) _rygel_energy_management_get_interface_info_cb_gupnp_service_action_invoked, self, 0);
}

static void
rygel_energy_management_upower_sleeping_cb (RygelEnergyManagement* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->sleeping == TRUE) {
		return;
	}
	self->priv->sleeping = TRUE;
	_tmp0_ = rygel_energy_management_create_network_interface_info (self);
	_tmp1_ = _tmp0_;
	gupnp_service_notify ((GUPnPService*) self, "NetworkInterfaceInfo", G_TYPE_STRING, _tmp1_, NULL);
	_g_free0 (_tmp1_);
}

static void
rygel_energy_management_upower_resuming_cb (RygelEnergyManagement* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->sleeping == FALSE) {
		return;
	}
	self->priv->sleeping = FALSE;
	_tmp0_ = rygel_energy_management_create_network_interface_info (self);
	_tmp1_ = _tmp0_;
	gupnp_service_notify ((GUPnPService*) self, "NetworkInterfaceInfo", G_TYPE_STRING, _tmp1_, NULL);
	_g_free0 (_tmp1_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gchar*
rygel_energy_management_create_network_interface_info (RygelEnergyManagement* self)
{
	gchar* result = NULL;
	gchar* mac_address = NULL;
	gchar* type = NULL;
	gboolean success = FALSE;
	gchar* iface = NULL;
	GUPnPRootDevice* _tmp0_;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPContext* _tmp3_;
	GUPnPContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* config_section = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_;
	gchar* mac = NULL;
	gchar* _tmp13_;
	gchar* wake_pattern = NULL;
	gchar* _tmp14_;
	GInetAddress* ip_addr = NULL;
	GUPnPRootDevice* _tmp19_;
	GUPnPRootDevice* _tmp20_;
	GUPnPRootDevice* _tmp21_;
	GUPnPContext* _tmp22_;
	GUPnPContext* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GInetAddress* _tmp27_;
	GInetAddress* _tmp28_;
	gboolean _tmp29_ = FALSE;
	GInetAddress* _tmp30_;
	gboolean is_ipv6 = FALSE;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gchar* associated_ips = NULL;
	GUPnPRootDevice* _tmp36_;
	GUPnPRootDevice* _tmp37_;
	GUPnPRootDevice* _tmp38_;
	GUPnPContext* _tmp39_;
	GUPnPContext* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* mode = NULL;
	gboolean _tmp46_ = FALSE;
	gchar* transport_node = NULL;
	gchar* device_info = NULL;
	GUPnPRootDevice* _tmp59_;
	GUPnPRootDevice* _tmp60_;
	GUPnPRootDevice* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	GUPnPRootDevice* _tmp64_;
	GUPnPRootDevice* _tmp65_;
	GUPnPRootDevice* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	success = TRUE;
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gssdp_client_get_interface ((GSSDPClient*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp2_);
	iface = _tmp8_;
	_tmp9_ = g_strdup_printf ("EnergyManagement-%s", iface);
	config_section = _tmp9_;
	_tmp12_ = rygel_energy_management_get_mac_and_network_type (iface, &_tmp10_, &_tmp11_);
	_g_free0 (mac_address);
	mac_address = _tmp10_;
	_g_free0 (type);
	type = _tmp11_;
	success = _tmp12_;
	_tmp13_ = string_replace (mac_address, ":", "");
	mac = _tmp13_;
	_tmp14_ = g_strdup_printf ("FFFFFFFFFFFF%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s", mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac);
	wake_pattern = _tmp14_;
	{
		gchar* password = NULL;
		RygelConfiguration* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = self->priv->config;
		_tmp16_ = rygel_configuration_get_string (_tmp15_, config_section, "password", &_inner_error0_);
		password = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch9_g_error;
		}
		_tmp17_ = wake_pattern;
		_tmp18_ = g_strconcat (_tmp17_, password, NULL);
		_g_free0 (wake_pattern);
		wake_pattern = _tmp18_;
		_g_free0 (password);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (wake_pattern);
		_g_free0 (mac);
		_g_free0 (config_section);
		_g_free0 (iface);
		_g_free0 (type);
		_g_free0 (mac_address);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	g_object_get ((GUPnPService*) self, "root-device", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp21_);
	_tmp23_ = _tmp22_;
	g_object_get ((GSSDPClient*) _tmp23_, "host-ip", &_tmp24_, NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp27_ = g_inet_address_new_from_string (_tmp26_);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	_g_object_unref0 (_tmp21_);
	ip_addr = _tmp28_;
	_tmp30_ = ip_addr;
	if (_tmp30_ != NULL) {
		GInetAddress* _tmp31_;
		GSocketFamily _tmp32_;
		GSocketFamily _tmp33_;
		_tmp31_ = ip_addr;
		_tmp32_ = g_inet_address_get_family (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp29_ = _tmp33_ == G_SOCKET_FAMILY_IPV6;
	} else {
		_tmp29_ = FALSE;
	}
	is_ipv6 = _tmp29_;
	if (is_ipv6) {
		_tmp34_ = 6;
	} else {
		_tmp34_ = 4;
	}
	if (is_ipv6) {
		_tmp35_ = 6;
	} else {
		_tmp35_ = 4;
	}
	g_object_get ((GUPnPService*) self, "root-device", &_tmp36_, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp39_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp38_);
	_tmp40_ = _tmp39_;
	g_object_get ((GSSDPClient*) _tmp40_, "host-ip", &_tmp41_, NULL);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strdup_printf ("<Ipv%d>%s</Ipv%d>", _tmp34_, _tmp43_, _tmp35_);
	_tmp45_ = _tmp44_;
	_g_free0 (_tmp43_);
	_g_object_unref0 (_tmp38_);
	associated_ips = _tmp45_;
	if (!success) {
		_tmp46_ = TRUE;
	} else {
		UPower* _tmp47_;
		_tmp47_ = self->priv->upower;
		_tmp46_ = _tmp47_ == NULL;
	}
	if (_tmp46_) {
		gchar* _tmp48_;
		_tmp48_ = g_strdup ("Unimplemented");
		_g_free0 (mode);
		mode = _tmp48_;
	} else {
		{
			gchar* sleep_mode = NULL;
			RygelConfiguration* _tmp49_;
			gchar* _tmp50_;
			const gchar* _tmp51_ = NULL;
			gchar* _tmp53_;
			_tmp49_ = self->priv->config;
			_tmp50_ = rygel_configuration_get_string (_tmp49_, config_section, "mode-on-suspend", &_inner_error0_);
			sleep_mode = _tmp50_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch10_g_error;
			}
			if (self->priv->sleeping) {
				const gchar* _tmp52_;
				_tmp52_ = sleep_mode;
				_tmp51_ = _tmp52_;
			} else {
				_tmp51_ = "IP-up";
			}
			_tmp53_ = g_strdup (_tmp51_);
			_g_free0 (mode);
			mode = _tmp53_;
			_g_free0 (sleep_mode);
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* _error_ = NULL;
			gchar* _tmp54_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp54_ = g_strdup ("Unimplemented");
			_g_free0 (mode);
			mode = _tmp54_;
			_g_error_free0 (_error_);
		}
		__finally10:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (mode);
			_g_free0 (associated_ips);
			_g_object_unref0 (ip_addr);
			_g_free0 (wake_pattern);
			_g_free0 (mac);
			_g_free0 (config_section);
			_g_free0 (iface);
			_g_free0 (type);
			_g_free0 (mac_address);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		gchar* val = NULL;
		RygelConfiguration* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp55_ = self->priv->config;
		_tmp56_ = rygel_configuration_get_string (_tmp55_, config_section, "supported-transport", &_inner_error0_);
		val = _tmp56_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch11_g_error;
		}
		_tmp57_ = g_strdup_printf ("<WakeSupportedTransport>%s</WakeSupportedTransport>", val);
		_g_free0 (transport_node);
		transport_node = _tmp57_;
		_g_free0 (val);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp58_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp58_ = g_strdup ("");
		_g_free0 (transport_node);
		transport_node = _tmp58_;
		_g_error_free0 (_error_);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (transport_node);
		_g_free0 (mode);
		_g_free0 (associated_ips);
		_g_object_unref0 (ip_addr);
		_g_free0 (wake_pattern);
		_g_free0 (mac);
		_g_free0 (config_section);
		_g_free0 (iface);
		_g_free0 (type);
		_g_free0 (mac_address);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	g_object_get ((GUPnPService*) self, "root-device", &_tmp59_, NULL);
	_tmp60_ = _tmp59_;
	_tmp61_ = _tmp60_;
	_tmp62_ = gupnp_device_info_get_udn ((GUPnPDeviceInfo*) _tmp61_);
	_tmp63_ = _tmp62_;
	g_object_get ((GUPnPService*) self, "root-device", &_tmp64_, NULL);
	_tmp65_ = _tmp64_;
	_tmp66_ = _tmp65_;
	_tmp67_ = gupnp_device_info_get_friendly_name ((GUPnPDeviceInfo*) _tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = mode;
	_tmp70_ = associated_ips;
	_tmp71_ = wake_pattern;
	_tmp72_ = transport_node;
	_tmp73_ = g_strdup_printf ("<DeviceInterface>" "<DeviceUUID>%s</DeviceUUID>" "<FriendlyName>%s</FriendlyName>" "<NetworkInterface>" "<SystemName>%s</SystemName>" "<MacAddress>%s</MacAddress>" "<InterfaceType>%s</InterfaceType>" "<NetworkInterfaceMode>%s</NetworkInterfaceMode>" "<AssociatedIpAddresses>%s</AssociatedIpAddresses>" "<WakeOnPattern>%s</WakeOnPattern>" "%s" "</NetworkInterface>" "</DeviceInterface>", _tmp63_, _tmp68_, iface, mac_address, type, _tmp69_, _tmp70_, _tmp71_, _tmp72_);
	_tmp74_ = _tmp73_;
	_g_free0 (_tmp68_);
	_g_object_unref0 (_tmp66_);
	_g_object_unref0 (_tmp61_);
	device_info = _tmp74_;
	_tmp75_ = g_strdup_printf (RYGEL_ENERGY_MANAGEMENT_TEMPLATE, device_info);
	result = _tmp75_;
	_g_free0 (device_info);
	_g_free0 (transport_node);
	_g_free0 (mode);
	_g_free0 (associated_ips);
	_g_object_unref0 (ip_addr);
	_g_free0 (wake_pattern);
	_g_free0 (mac);
	_g_free0 (config_section);
	_g_free0 (iface);
	_g_free0 (type);
	_g_free0 (mac_address);
	return result;
}

static gchar*
rygel_energy_management_create_proxied_network_interface_info (RygelEnergyManagement* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_ENERGY_MANAGEMENT_TEMPLATE, "");
	result = _tmp0_;
	return result;
}

static void
rygel_energy_management_query_network_interface_info_cb (RygelEnergyManagement* self,
                                                         GUPnPService* em,
                                                         const gchar* var,
                                                         GValue* val)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (em != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = rygel_energy_management_create_network_interface_info (self);
	_tmp1_ = _tmp0_;
	g_value_set_string (val, _tmp1_);
	_g_free0 (_tmp1_);
}

static void
rygel_energy_management_query_proxied_network_interface_info_cb (RygelEnergyManagement* self,
                                                                 GUPnPService* em,
                                                                 const gchar* var,
                                                                 GValue* val)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (em != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = rygel_energy_management_create_proxied_network_interface_info (self);
	_tmp1_ = _tmp0_;
	g_value_set_string (val, _tmp1_);
	_g_free0 (_tmp1_);
}

static void
rygel_energy_management_get_interface_info_cb (RygelEnergyManagement* self,
                                               GUPnPService* em,
                                               GUPnPServiceAction* action)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (em != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 0)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp0_ = rygel_energy_management_create_network_interface_info (self);
	_tmp1_ = _tmp0_;
	gupnp_service_action_set (action, "NetworkInterfaceInfo", G_TYPE_STRING, _tmp1_, NULL);
	_g_free0 (_tmp1_);
	_tmp2_ = rygel_energy_management_create_proxied_network_interface_info (self);
	_tmp3_ = _tmp2_;
	gupnp_service_action_set (action, "ProxiedNetworkInterfaceInfo", G_TYPE_STRING, _tmp3_, NULL);
	_g_free0 (_tmp3_);
	gupnp_service_action_return (action);
}

RygelEnergyManagement*
rygel_energy_management_construct (GType object_type)
{
	RygelEnergyManagement * self = NULL;
	self = (RygelEnergyManagement*) g_object_new (object_type, NULL);
	return self;
}

RygelEnergyManagement*
rygel_energy_management_new (void)
{
	return rygel_energy_management_construct (RYGEL_TYPE_ENERGY_MANAGEMENT);
}

static void
rygel_energy_management_class_init (RygelEnergyManagementClass * klass,
                                    gpointer klass_data)
{
	rygel_energy_management_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelEnergyManagement_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_energy_management_real_constructed;
	G_OBJECT_CLASS (klass)->finalize = rygel_energy_management_finalize;
}

static void
rygel_energy_management_instance_init (RygelEnergyManagement * self,
                                       gpointer klass)
{
	self->priv = rygel_energy_management_get_instance_private (self);
}

static void
rygel_energy_management_finalize (GObject * obj)
{
	RygelEnergyManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagement);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->upower);
	G_OBJECT_CLASS (rygel_energy_management_parent_class)->finalize (obj);
}

/**
 * Implementation of UPnP EnergyManagement service.
 */
GType
rygel_energy_management_get_type (void)
{
	static volatile gsize rygel_energy_management_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_energy_management_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelEnergyManagementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_energy_management_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelEnergyManagement), 0, (GInstanceInitFunc) rygel_energy_management_instance_init, NULL };
		GType rygel_energy_management_type_id;
		rygel_energy_management_type_id = g_type_register_static (gupnp_service_get_type (), "RygelEnergyManagement", &g_define_type_info, 0);
		RygelEnergyManagement_private_offset = g_type_add_instance_private (rygel_energy_management_type_id, sizeof (RygelEnergyManagementPrivate));
		g_once_init_leave (&rygel_energy_management_type_id__volatile, rygel_energy_management_type_id);
	}
	return rygel_energy_management_type_id__volatile;
}

