/* rygel-user-config.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-user-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Krzesimir Nowak <krnowak@openismus.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gobject/gvaluecollector.h>

typedef enum  {
	RYGEL_ENTRY_TYPE_STRING,
	RYGEL_ENTRY_TYPE_BOOL,
	RYGEL_ENTRY_TYPE_INT
} RygelEntryType;

#define RYGEL_TYPE_ENTRY_TYPE (rygel_entry_type_get_type ())

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
typedef struct _RygelUserConfigPrivate RygelUserConfigPrivate;
enum  {
	RYGEL_USER_CONFIG_0_PROPERTY,
	RYGEL_USER_CONFIG_NUM_PROPERTIES
};
static GParamSpec* rygel_user_config_properties[RYGEL_USER_CONFIG_NUM_PROPERTIES];

#define RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR (rygel_user_config_config_pair_get_type ())
#define RYGEL_USER_CONFIG_CONFIG_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPair))
#define RYGEL_USER_CONFIG_CONFIG_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPairClass))
#define RYGEL_USER_CONFIG_IS_CONFIG_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR))
#define RYGEL_USER_CONFIG_IS_CONFIG_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR))
#define RYGEL_USER_CONFIG_CONFIG_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPairClass))

typedef struct _RygelUserConfigConfigPair RygelUserConfigConfigPair;
typedef struct _RygelUserConfigConfigPairClass RygelUserConfigConfigPairClass;

#define RYGEL_USER_CONFIG_TYPE_SECTION_PAIR (rygel_user_config_section_pair_get_type ())
#define RYGEL_USER_CONFIG_SECTION_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPair))
#define RYGEL_USER_CONFIG_SECTION_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPairClass))
#define RYGEL_USER_CONFIG_IS_SECTION_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR))
#define RYGEL_USER_CONFIG_IS_SECTION_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR))
#define RYGEL_USER_CONFIG_SECTION_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPairClass))

typedef struct _RygelUserConfigSectionPair RygelUserConfigSectionPair;
typedef struct _RygelUserConfigSectionPairClass RygelUserConfigSectionPairClass;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelUserConfigSectionPairPrivate RygelUserConfigSectionPairPrivate;
typedef enum  {
	RYGEL_SECTION_ENTRY_TITLE,
	RYGEL_SECTION_ENTRY_ENABLED
} RygelSectionEntry;

#define RYGEL_TYPE_SECTION_ENTRY (rygel_section_entry_get_type ())
#define _rygel_user_config_section_pair_unref0(var) ((var == NULL) ? NULL : (var = (rygel_user_config_section_pair_unref (var), NULL)))
typedef struct _RygelUserConfigConfigPairPrivate RygelUserConfigConfigPairPrivate;
typedef enum  {
	RYGEL_CONFIGURATION_ENTRY_INTERFACE,
	RYGEL_CONFIGURATION_ENTRY_PORT,
	RYGEL_CONFIGURATION_ENTRY_TRANSCODING,
	RYGEL_CONFIGURATION_ENTRY_ALLOW_UPLOAD,
	RYGEL_CONFIGURATION_ENTRY_ALLOW_DELETION,
	RYGEL_CONFIGURATION_ENTRY_LOG_LEVELS,
	RYGEL_CONFIGURATION_ENTRY_PLUGIN_PATH,
	RYGEL_CONFIGURATION_ENTRY_VIDEO_UPLOAD_FOLDER,
	RYGEL_CONFIGURATION_ENTRY_MUSIC_UPLOAD_FOLDER,
	RYGEL_CONFIGURATION_ENTRY_PICTURE_UPLOAD_FOLDER
} RygelConfigurationEntry;

#define RYGEL_TYPE_CONFIGURATION_ENTRY (rygel_configuration_entry_get_type ())
#define _rygel_user_config_config_pair_unref0(var) ((var == NULL) ? NULL : (var = (rygel_user_config_config_pair_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _RygelUserConfigParamSpecConfigPair RygelUserConfigParamSpecConfigPair;
typedef struct _RygelUserConfigParamSpecSectionPair RygelUserConfigParamSpecSectionPair;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gchar* (*get_interface) (RygelConfiguration* self, GError** error) G_GNUC_DEPRECATED;
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelUserConfig {
	GObject parent_instance;
	RygelUserConfigPrivate * priv;
	GKeyFile* key_file;
	GKeyFile* sys_key_file;
	GFileMonitor* key_file_monitor;
	GFileMonitor* sys_key_file_monitor;
};

struct _RygelUserConfigClass {
	GObjectClass parent_class;
};

struct _RygelUserConfigPrivate {
	guint system_config_timer_id;
	guint local_config_timer_id;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()
struct _RygelUserConfigSectionPair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelUserConfigSectionPairPrivate * priv;
	RygelSectionEntry entry;
	RygelEntryType type;
};

struct _RygelUserConfigSectionPairClass {
	GTypeClass parent_class;
	void (*finalize) (RygelUserConfigSectionPair *self);
};

struct _RygelUserConfigConfigPair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelUserConfigConfigPairPrivate * priv;
	RygelConfigurationEntry entry;
	RygelEntryType type;
};

struct _RygelUserConfigConfigPairClass {
	GTypeClass parent_class;
	void (*finalize) (RygelUserConfigConfigPair *self);
};

struct _Block1Data {
	int _ref_count_;
	RygelUserConfig* self;
	GFile* file;
};

struct _Block2Data {
	int _ref_count_;
	RygelUserConfig* self;
	GFile* file;
};

struct _RygelUserConfigParamSpecConfigPair {
	GParamSpec parent_instance;
};

struct _RygelUserConfigParamSpecSectionPair {
	GParamSpec parent_instance;
};

static gint RygelUserConfig_private_offset;
static gpointer rygel_user_config_parent_class = NULL;
static RygelUserConfig* rygel_user_config_config;
static RygelUserConfig* rygel_user_config_config = NULL;
static GeeHashMap* rygel_user_config_config_keys;
static GeeHashMap* rygel_user_config_config_keys = NULL;
static GeeHashMap* rygel_user_config_section_keys;
static GeeHashMap* rygel_user_config_section_keys = NULL;
static gpointer rygel_user_config_config_pair_parent_class = NULL;
static gpointer rygel_user_config_section_pair_parent_class = NULL;
static RygelConfigurationIface * rygel_user_config_rygel_configuration_parent_iface = NULL;

GType rygel_entry_type_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_user_config_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelUserConfig, g_object_unref)
static gpointer rygel_user_config_config_pair_ref (gpointer instance);
static void rygel_user_config_config_pair_unref (gpointer instance);
static GParamSpec* rygel_user_config_param_spec_config_pair (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags) G_GNUC_UNUSED;
static void rygel_user_config_value_set_config_pair (GValue* value,
                                              gpointer v_object) G_GNUC_UNUSED;
static void rygel_user_config_value_take_config_pair (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static gpointer rygel_user_config_value_get_config_pair (const GValue* value) G_GNUC_UNUSED;
static GType rygel_user_config_config_pair_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelUserConfigConfigPair, rygel_user_config_config_pair_unref)
static gpointer rygel_user_config_section_pair_ref (gpointer instance);
static void rygel_user_config_section_pair_unref (gpointer instance);
static GParamSpec* rygel_user_config_param_spec_section_pair (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void rygel_user_config_value_set_section_pair (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static void rygel_user_config_value_take_section_pair (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer rygel_user_config_value_get_section_pair (const GValue* value) G_GNUC_UNUSED;
static GType rygel_user_config_section_pair_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelUserConfigSectionPair, rygel_user_config_section_pair_unref)
#define RYGEL_USER_CONFIG_GENERAL_SECTION "general"
#define RYGEL_USER_CONFIG_CONFIG_FILE "rygel.conf"
#define RYGEL_USER_CONFIG_IFACE_KEY "interface"
#define RYGEL_USER_CONFIG_PORT_KEY "port"
#define RYGEL_USER_CONFIG_ENABLED_KEY "enabled"
#define RYGEL_USER_CONFIG_TITLE_KEY "title"
#define RYGEL_USER_CONFIG_TRANSCODING_KEY "enable-transcoding"
#define RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY "allow-upload"
#define RYGEL_USER_CONFIG_ALLOW_DELETION_KEY "allow-deletion"
#define RYGEL_USER_CONFIG_LOG_LEVELS_KEY "log-level"
#define RYGEL_USER_CONFIG_PLUGIN_PATH_KEY "plugin-path"
#define RYGEL_USER_CONFIG_ENGINE_PATH_KEY "engine-path"
#define RYGEL_USER_CONFIG_MEDIA_ENGINE_KEY "media-engine"
#define RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY "upload-folder"
#define RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY "video-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
#define RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY "music-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
#define RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY "picture-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
static gchar** rygel_user_config_real_get_interfaces (RygelConfiguration* base,
                                               GError** error);
GeeArrayList* rygel_configuration_get_string_list (RygelConfiguration* self,
                                                   const gchar* section,
                                                   const gchar* key,
                                                   GError** error);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base,
                                             GError** error);
gchar* rygel_configuration_get_string (RygelConfiguration* self,
                                       const gchar* section,
                                       const gchar* key,
                                       GError** error);
static gint rygel_user_config_real_get_port (RygelConfiguration* base,
                                      GError** error);
gint rygel_configuration_get_int (RygelConfiguration* self,
                                  const gchar* section,
                                  const gchar* key,
                                  gint min,
                                  gint max,
                                  GError** error);
static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base,
                                                 GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self,
                                       const gchar* section,
                                       const gchar* key,
                                       GError** error);
static gboolean rygel_user_config_real_get_allow_upload (RygelConfiguration* base,
                                                  GError** error);
static gboolean rygel_user_config_real_get_allow_deletion (RygelConfiguration* base,
                                                    GError** error);
static gchar* rygel_user_config_real_get_log_levels (RygelConfiguration* base,
                                              GError** error);
static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base,
                                               GError** error);
static gchar* rygel_user_config_real_get_engine_path (RygelConfiguration* base,
                                               GError** error);
static gchar* rygel_user_config_real_get_media_engine (RygelConfiguration* base,
                                                GError** error);
static gchar* rygel_user_config_real_get_video_upload_folder (RygelConfiguration* base,
                                                       GError** error);
static gchar* rygel_user_config_real_get_music_upload_folder (RygelConfiguration* base,
                                                       GError** error);
static gchar* rygel_user_config_real_get_picture_upload_folder (RygelConfiguration* base,
                                                         GError** error);
RygelUserConfig* rygel_user_config_get_default (GError** error);
RygelUserConfig* rygel_user_config_new (const gchar* local_path,
                                        GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type,
                                              const gchar* local_path,
                                              GError** error);
static void rygel_user_config_initialize (RygelUserConfig* self,
                                   const gchar* local_path,
                                   const gchar* system_path,
                                   GError** error);
static void rygel_user_config_on_system_config_changed (RygelUserConfig* self,
                                                 GFileMonitor* monitor,
                                                 GFile* file,
                                                 GFile* other_file,
                                                 GFileMonitorEvent event_type);
static void _rygel_user_config_on_system_config_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                         GFile* file,
                                                                         GFile* other_file,
                                                                         GFileMonitorEvent event_type,
                                                                         gpointer self);
static void rygel_user_config_on_local_config_changed (RygelUserConfig* self,
                                                GFileMonitor* monitor,
                                                GFile* file,
                                                GFile* other_file,
                                                GFileMonitorEvent event_type);
static void _rygel_user_config_on_local_config_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                        GFile* file,
                                                                        GFile* other_file,
                                                                        GFileMonitorEvent event_type,
                                                                        gpointer self);
RygelUserConfig* rygel_user_config_new_with_paths (const gchar* local_path,
                                                   const gchar* system_path,
                                                   GError** error);
RygelUserConfig* rygel_user_config_construct_with_paths (GType object_type,
                                                         const gchar* local_path,
                                                         const gchar* system_path,
                                                         GError** error);
static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base,
                                             const gchar* section,
                                             GError** error);
static gchar* rygel_user_config_real_get_title (RygelConfiguration* base,
                                         const gchar* section,
                                         GError** error);
static gchar* rygel_user_config_get_string_from_keyfiles (const gchar* section,
                                                   const gchar* key,
                                                   GKeyFile* key_file,
                                                   GKeyFile* sys_key_file,
                                                   GError** error);
GQuark rygel_configuration_error_quark (void);
static gchar* rygel_user_config_real_get_string (RygelConfiguration* base,
                                          const gchar* section,
                                          const gchar* key,
                                          GError** error);
static GeeArrayList* rygel_user_config_get_string_list_from_keyfiles (const gchar* section,
                                                               const gchar* key,
                                                               GKeyFile* key_file,
                                                               GKeyFile* sys_key_file,
                                                               GError** error);
static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base,
                                                      const gchar* section,
                                                      const gchar* key,
                                                      GError** error);
static gint rygel_user_config_get_int_from_keyfiles (const gchar* section,
                                              const gchar* key,
                                              gint min,
                                              gint max,
                                              GKeyFile* key_file,
                                              GKeyFile* sys_key_file,
                                              GError** error);
static gint rygel_user_config_real_get_int (RygelConfiguration* base,
                                     const gchar* section,
                                     const gchar* key,
                                     gint min,
                                     gint max,
                                     GError** error);
static GeeArrayList* rygel_user_config_get_int_list_from_keyfiles (const gchar* section,
                                                            const gchar* key,
                                                            GKeyFile* key_file,
                                                            GKeyFile* sys_key_file,
                                                            GError** error);
static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base,
                                                   const gchar* section,
                                                   const gchar* key,
                                                   GError** error);
static gboolean rygel_user_config_get_bool_from_keyfiles (const gchar* section,
                                                   const gchar* key,
                                                   GKeyFile* key_file,
                                                   GKeyFile* sys_key_file,
                                                   GError** error);
static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base,
                                          const gchar* section,
                                          const gchar* key,
                                          GError** error);
static gchar* rygel_user_config_get_value_from_keyfiles (const gchar* section,
                                                  const gchar* key,
                                                  GKeyFile* key_file,
                                                  GKeyFile* sys_key_file,
                                                  GError** error);
static GeeHashSet* rygel_user_config_get_sections (GKeyFile* key_file,
                                            GKeyFile* sys_key_file);
static GeeHashSet* rygel_user_config_get_keys (const gchar* section,
                                        GKeyFile* key_file,
                                        GKeyFile* sys_key_file);
static gboolean rygel_user_config_are_values_different (const gchar* section,
                                                 const gchar* key,
                                                 GKeyFile* old_key_file,
                                                 GKeyFile* old_sys_key_file,
                                                 GKeyFile* new_key_file,
                                                 GKeyFile* new_sys_key_file,
                                                 RygelEntryType type);
static void rygel_user_config_emit_conditionally (RygelUserConfig* self,
                                           const gchar* section,
                                           const gchar* key,
                                           GKeyFile* old_key_file,
                                           GKeyFile* old_sys_key_file,
                                           GKeyFile* key_file,
                                           GKeyFile* sys_key_file,
                                           GeeHashMap* config_keys);
GType rygel_section_entry_get_type (void) G_GNUC_CONST;
GType rygel_configuration_entry_get_type (void) G_GNUC_CONST;
static void rygel_user_config_emit_unconditionally (RygelUserConfig* self,
                                             const gchar* section,
                                             const gchar* key,
                                             GeeHashMap* config_keys);
static void rygel_user_config_compare_and_notify (RygelUserConfig* self,
                                           GKeyFile* key_file,
                                           GKeyFile* sys_key_file);
static void rygel_user_config_reload_compare_and_notify_system (RygelUserConfig* self,
                                                         GFile* system);
static void rygel_user_config_reload_compare_and_notify_local (RygelUserConfig* self,
                                                        GFile* local);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block1Data* _data1_);
static gboolean ___lambda4__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda5_ (Block2Data* _data2_);
static gboolean ___lambda5__gsource_func (gpointer self);
static RygelUserConfigConfigPair* rygel_user_config_config_pair_new (RygelConfigurationEntry entry,
                                                              RygelEntryType type);
static RygelUserConfigConfigPair* rygel_user_config_config_pair_construct (GType object_type,
                                                                    RygelConfigurationEntry entry,
                                                                    RygelEntryType type);
static RygelUserConfigSectionPair* rygel_user_config_section_pair_new (RygelSectionEntry entry,
                                                                RygelEntryType type);
static RygelUserConfigSectionPair* rygel_user_config_section_pair_construct (GType object_type,
                                                                      RygelSectionEntry entry,
                                                                      RygelEntryType type);
static void rygel_user_config_config_pair_finalize (RygelUserConfigConfigPair * obj);
static void rygel_user_config_section_pair_finalize (RygelUserConfigSectionPair * obj);
static void rygel_user_config_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

GType
rygel_entry_type_get_type (void)
{
	static volatile gsize rygel_entry_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_entry_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_ENTRY_TYPE_STRING, "RYGEL_ENTRY_TYPE_STRING", "string"}, {RYGEL_ENTRY_TYPE_BOOL, "RYGEL_ENTRY_TYPE_BOOL", "bool"}, {RYGEL_ENTRY_TYPE_INT, "RYGEL_ENTRY_TYPE_INT", "int"}, {0, NULL, NULL}};
		GType rygel_entry_type_type_id;
		rygel_entry_type_type_id = g_enum_register_static ("RygelEntryType", values);
		g_once_init_leave (&rygel_entry_type_type_id__volatile, rygel_entry_type_type_id);
	}
	return rygel_entry_type_type_id__volatile;
}

static inline gpointer
rygel_user_config_get_instance_private (RygelUserConfig* self)
{
	return G_STRUCT_MEMBER_P (self, RygelUserConfig_private_offset);
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
rygel_user_config_real_get_interfaces (RygelConfiguration* base,
                                       GError** error)
{
	RygelUserConfig * self;
	gchar** result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_;
	gchar** interfaces = NULL;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	gint interfaces_length1;
	gint _interfaces_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string_list ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_IFACE_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = gee_collection_to_array ((GeeCollection*) _tmp0_, &_tmp2_);
	interfaces = _tmp3_;
	interfaces_length1 = _tmp2_;
	_interfaces_size_ = interfaces_length1;
	_tmp4_ = interfaces;
	_tmp4__length1 = interfaces_length1;
	if (_tmp4_ != NULL) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = interfaces;
		_tmp5__length1 = interfaces_length1;
		_vala_array_add1 (&interfaces, &interfaces_length1, &_interfaces_size_, NULL);
	}
	result = interfaces;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gchar*
rygel_user_config_real_get_interface (RygelConfiguration* base,
                                      GError** error)
{
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_IFACE_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static gint
rygel_user_config_real_get_port (RygelConfiguration* base,
                                 GError** error)
{
	RygelUserConfig * self;
	gint result = 0;
	gint _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_int ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_PORT_KEY, (gint) 0U, (gint) G_MAXUINT16, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp1_ = -1;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static gboolean
rygel_user_config_real_get_transcoding (RygelConfiguration* base,
                                        GError** error)
{
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_TRANSCODING_KEY, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static gboolean
rygel_user_config_real_get_allow_upload (RygelConfiguration* base,
                                         GError** error)
{
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static gboolean
rygel_user_config_real_get_allow_deletion (RygelConfiguration* base,
                                           GError** error)
{
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_ALLOW_DELETION_KEY, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static gchar*
rygel_user_config_real_get_log_levels (RygelConfiguration* base,
                                       GError** error)
{
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_LOG_LEVELS_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
rygel_user_config_real_get_plugin_path (RygelConfiguration* base,
                                        GError** error)
{
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_PLUGIN_PATH_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
rygel_user_config_real_get_engine_path (RygelConfiguration* base,
                                        GError** error)
{
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_ENGINE_PATH_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
rygel_user_config_real_get_media_engine (RygelConfiguration* base,
                                         GError** error)
{
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_MEDIA_ENGINE_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
rygel_user_config_real_get_video_upload_folder (RygelConfiguration* base,
                                                GError** error)
{
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
rygel_user_config_real_get_music_upload_folder (RygelConfiguration* base,
                                                GError** error)
{
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
rygel_user_config_real_get_picture_upload_folder (RygelConfiguration* base,
                                                  GError** error)
{
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelUserConfig*
rygel_user_config_get_default (GError** error)
{
	RygelUserConfig* result = NULL;
	RygelUserConfig* _tmp0_;
	RygelUserConfig* _tmp7_;
	RygelUserConfig* _tmp8_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = rygel_user_config_config;
	if (_tmp0_ == NULL) {
		gchar* path = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		RygelUserConfig* _tmp3_ = NULL;
		const gchar* _tmp4_;
		RygelUserConfig* _tmp5_;
		RygelUserConfig* _tmp6_;
		_tmp1_ = g_get_user_config_dir ();
		_tmp2_ = g_build_filename (_tmp1_, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
		path = _tmp2_;
		_tmp4_ = path;
		_tmp5_ = rygel_user_config_new (_tmp4_, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (path);
			return NULL;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (rygel_user_config_config);
		rygel_user_config_config = _tmp6_;
		_g_object_unref0 (_tmp3_);
		_g_free0 (path);
	}
	_tmp7_ = rygel_user_config_config;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	result = _tmp8_;
	return result;
}

static void
_rygel_user_config_on_system_config_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                    GFile* file,
                                                                    GFile* other_file,
                                                                    GFileMonitorEvent event_type,
                                                                    gpointer self)
{
	rygel_user_config_on_system_config_changed ((RygelUserConfig*) self, _sender, file, other_file, event_type);
}

static void
_rygel_user_config_on_local_config_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                   GFile* file,
                                                                   GFile* other_file,
                                                                   GFileMonitorEvent event_type,
                                                                   gpointer self)
{
	rygel_user_config_on_local_config_changed ((RygelUserConfig*) self, _sender, file, other_file, event_type);
}

static void
rygel_user_config_initialize (RygelUserConfig* self,
                              const gchar* local_path,
                              const gchar* system_path,
                              GError** error)
{
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	GKeyFile* _tmp2_;
	GFile* sys_key_g_file = NULL;
	GFile* _tmp3_;
	GFileMonitor* _tmp4_ = NULL;
	GFile* _tmp5_;
	GFileMonitor* _tmp6_;
	GFileMonitor* _tmp7_;
	GFileMonitor* _tmp8_;
	GFile* key_g_file = NULL;
	GFile* _tmp13_;
	GFileMonitor* _tmp14_ = NULL;
	GFile* _tmp15_;
	GFileMonitor* _tmp16_;
	GFileMonitor* _tmp17_;
	GFileMonitor* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local_path != NULL);
	g_return_if_fail (system_path != NULL);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->key_file);
	self->key_file = _tmp0_;
	_tmp1_ = g_key_file_new ();
	_g_key_file_unref0 (self->sys_key_file);
	self->sys_key_file = _tmp1_;
	_tmp2_ = self->sys_key_file;
	g_key_file_load_from_file (_tmp2_, system_path, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	g_debug ("rygel-user-config.vala:228: Loaded system configuration from file '%s'", system_path);
	_tmp3_ = g_file_new_for_path (system_path);
	sys_key_g_file = _tmp3_;
	_tmp5_ = sys_key_g_file;
	_tmp6_ = g_file_monitor_file (_tmp5_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
	_tmp4_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (sys_key_g_file);
		return;
	}
	_tmp7_ = _tmp4_;
	_tmp4_ = NULL;
	_g_object_unref0 (self->sys_key_file_monitor);
	self->sys_key_file_monitor = _tmp7_;
	_tmp8_ = self->sys_key_file_monitor;
	g_signal_connect_object (_tmp8_, "changed", (GCallback) _rygel_user_config_on_system_config_changed_g_file_monitor_changed, self, 0);
	{
		GKeyFile* _tmp9_;
		_tmp9_ = self->key_file;
		g_key_file_load_from_file (_tmp9_, local_path, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_debug ("rygel-user-config.vala:243: Loaded user configuration from file '%s'", local_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		GKeyFile* _tmp12_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning (_ ("Failed to load user configuration from file “%s”: %s"), local_path, _tmp11_);
		_tmp12_ = g_key_file_new ();
		_g_key_file_unref0 (self->key_file);
		self->key_file = _tmp12_;
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (sys_key_g_file);
		return;
	}
	_tmp13_ = g_file_new_for_path (local_path);
	key_g_file = _tmp13_;
	_tmp15_ = key_g_file;
	_tmp16_ = g_file_monitor_file (_tmp15_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
	_tmp14_ = _tmp16_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (key_g_file);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (sys_key_g_file);
		return;
	}
	_tmp17_ = _tmp14_;
	_tmp14_ = NULL;
	_g_object_unref0 (self->key_file_monitor);
	self->key_file_monitor = _tmp17_;
	_tmp18_ = self->key_file_monitor;
	g_signal_connect_object (_tmp18_, "changed", (GCallback) _rygel_user_config_on_local_config_changed_g_file_monitor_changed, self, 0);
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (key_g_file);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (sys_key_g_file);
}

RygelUserConfig*
rygel_user_config_construct (GType object_type,
                             const gchar* local_path,
                             GError** error)
{
	RygelUserConfig * self = NULL;
	gchar* system_path = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (local_path != NULL, NULL);
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
	_tmp0_ = g_build_filename (SYS_CONFIG_DIR, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
	system_path = _tmp0_;
	rygel_user_config_initialize (self, local_path, system_path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (system_path);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_free0 (system_path);
	return self;
}

RygelUserConfig*
rygel_user_config_new (const gchar* local_path,
                       GError** error)
{
	return rygel_user_config_construct (RYGEL_TYPE_USER_CONFIG, local_path, error);
}

RygelUserConfig*
rygel_user_config_construct_with_paths (GType object_type,
                                        const gchar* local_path,
                                        const gchar* system_path,
                                        GError** error)
{
	RygelUserConfig * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (local_path != NULL, NULL);
	g_return_val_if_fail (system_path != NULL, NULL);
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
	rygel_user_config_initialize (self, local_path, system_path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

RygelUserConfig*
rygel_user_config_new_with_paths (const gchar* local_path,
                                  const gchar* system_path,
                                  GError** error)
{
	return rygel_user_config_construct_with_paths (RYGEL_TYPE_USER_CONFIG, local_path, system_path, error);
}

static gboolean
rygel_user_config_real_get_enabled (RygelConfiguration* base,
                                    const gchar* section,
                                    GError** error)
{
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, section, RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static gchar*
rygel_user_config_real_get_title (RygelConfiguration* base,
                                  const gchar* section,
                                  GError** error)
{
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, RYGEL_USER_CONFIG_TITLE_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gchar*
rygel_user_config_get_string_from_keyfiles (const gchar* section,
                                            const gchar* key,
                                            GKeyFile* key_file,
                                            GKeyFile* sys_key_file,
                                            GError** error)
{
	gchar* result = NULL;
	gchar* val = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_key_file_get_string (key_file, section, key, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (val);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (val);
		val = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp3_ = FALSE;
		GError* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		if (g_error_matches (_tmp4_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp3_ = TRUE;
		} else {
			GError* _tmp5_;
			_tmp5_ = _error_;
			_tmp3_ = g_error_matches (_tmp5_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		if (_tmp3_) {
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = g_key_file_get_string (sys_key_file, section, key, &_inner_error0_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (_error_);
				goto __finally1;
			}
			_tmp8_ = _tmp6_;
			_tmp6_ = NULL;
			_g_free0 (val);
			val = _tmp8_;
			_g_free0 (_tmp6_);
		} else {
			GError* _tmp9_;
			GError* _tmp10_;
			_tmp9_ = _error_;
			_tmp10_ = _g_error_copy0 (_tmp9_);
			_inner_error0_ = _tmp10_;
			_g_error_free0 (_error_);
			goto __finally1;
		}
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (val);
		return NULL;
	}
	_tmp12_ = val;
	if (_tmp12_ == NULL) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = val;
		_tmp11_ = g_strcmp0 (_tmp13_, "") == 0;
	}
	if (_tmp11_) {
		GError* _tmp14_;
		_tmp14_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available for “%s”"), key);
		_inner_error0_ = _tmp14_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static gchar*
rygel_user_config_real_get_string (RygelConfiguration* base,
                                   const gchar* section,
                                   const gchar* key,
                                   GError** error)
{
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	GKeyFile* _tmp1_;
	GKeyFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = self->key_file;
	_tmp2_ = self->sys_key_file;
	_tmp3_ = rygel_user_config_get_string_from_keyfiles (section, key, _tmp1_, _tmp2_, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_free0 (_tmp0_);
	return result;
}

static GeeArrayList*
rygel_user_config_get_string_list_from_keyfiles (const gchar* section,
                                                 const gchar* key,
                                                 GKeyFile* key_file,
                                                 GKeyFile* sys_key_file,
                                                 GError** error)
{
	GeeArrayList* result = NULL;
	GeeArrayList* str_list = NULL;
	GeeArrayList* _tmp0_;
	gchar** strings = NULL;
	gint strings_length1 = 0;
	gint _strings_size_ = 0;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	str_list = _tmp0_;
	{
		gchar** _tmp1_ = NULL;
		gsize _tmp2_ = 0;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_key_file_get_string_list (key_file, section, key, &_tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (str_list);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		strings = _tmp4_;
		strings_length1 = _tmp4__length1;
		_strings_size_ = strings_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = _error_;
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp5_ = TRUE;
		} else {
			GError* _tmp7_;
			_tmp7_ = _error_;
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		if (_tmp5_) {
			gchar** _tmp8_ = NULL;
			gsize _tmp9_ = 0;
			gchar** _tmp10_;
			gint _tmp8__length1;
			gint __tmp8__size_;
			gchar** _tmp11_;
			gint _tmp11__length1;
			_tmp10_ = g_key_file_get_string_list (sys_key_file, section, key, &_tmp9_, &_inner_error0_);
			_tmp8_ = _tmp10_;
			_tmp8__length1 = _tmp9_;
			__tmp8__size_ = _tmp8__length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (_error_);
				goto __finally2;
			}
			_tmp11_ = _tmp8_;
			_tmp11__length1 = _tmp8__length1;
			_tmp8_ = NULL;
			_tmp8__length1 = 0;
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			strings = _tmp11_;
			strings_length1 = _tmp11__length1;
			_strings_size_ = strings_length1;
			_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		} else {
			GError* _tmp12_;
			GError* _tmp13_;
			_tmp12_ = _error_;
			_tmp13_ = _g_error_copy0 (_tmp12_);
			_inner_error0_ = _tmp13_;
			_g_error_free0 (_error_);
			goto __finally2;
		}
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (str_list);
		return NULL;
	}
	_tmp14_ = strings;
	_tmp14__length1 = strings_length1;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = _tmp14_;
		str_collection_length1 = _tmp14__length1;
		for (str_it = 0; str_it < _tmp14__length1; str_it = str_it + 1) {
			gchar* _tmp15_;
			gchar* str = NULL;
			_tmp15_ = g_strdup (str_collection[str_it]);
			str = _tmp15_;
			{
				GeeArrayList* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = str_list;
				_tmp17_ = str;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
				_g_free0 (str);
			}
		}
	}
	result = str_list;
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static GeeArrayList*
rygel_user_config_real_get_string_list (RygelConfiguration* base,
                                        const gchar* section,
                                        const gchar* key,
                                        GError** error)
{
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GKeyFile* _tmp1_;
	GKeyFile* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = self->key_file;
	_tmp2_ = self->sys_key_file;
	_tmp3_ = rygel_user_config_get_string_list_from_keyfiles (section, key, _tmp1_, _tmp2_, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gint
rygel_user_config_get_int_from_keyfiles (const gchar* section,
                                         const gchar* key,
                                         gint min,
                                         gint max,
                                         GKeyFile* key_file,
                                         GKeyFile* sys_key_file,
                                         GError** error)
{
	gint result = 0;
	gint val = 0;
	gboolean _tmp9_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	g_return_val_if_fail (key_file != NULL, 0);
	g_return_val_if_fail (sys_key_file != NULL, 0);
	{
		gint _tmp0_ = 0;
		_tmp0_ = g_key_file_get_integer (key_file, section, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp1_ = -1;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch3_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		val = _tmp0_;
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp2_ = FALSE;
		GError* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		if (g_error_matches (_tmp3_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp2_ = TRUE;
		} else {
			GError* _tmp4_;
			_tmp4_ = _error_;
			_tmp2_ = g_error_matches (_tmp4_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		if (_tmp2_) {
			gint _tmp5_ = 0;
			_tmp5_ = g_key_file_get_integer (sys_key_file, section, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (_error_);
				goto __finally3;
			}
			val = _tmp5_;
		} else {
			GError* _tmp6_;
			GError* _tmp7_;
			_tmp6_ = _error_;
			_tmp7_ = _g_error_copy0 (_tmp6_);
			_inner_error0_ = _tmp7_;
			_g_error_free0 (_error_);
			goto __finally3;
		}
		_g_error_free0 (_error_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp8_ = -1;
		g_propagate_error (error, _inner_error0_);
		return _tmp8_;
	}
	if (val < min) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = val > max;
	}
	if (_tmp9_) {
		GError* _tmp10_;
		gint _tmp11_ = -1;
		_tmp10_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, _ ("Value of “%s” out of range"), key);
		_inner_error0_ = _tmp10_;
		g_propagate_error (error, _inner_error0_);
		return _tmp11_;
	}
	result = val;
	return result;
}

static gint
rygel_user_config_real_get_int (RygelConfiguration* base,
                                const gchar* section,
                                const gchar* key,
                                gint min,
                                gint max,
                                GError** error)
{
	RygelUserConfig * self;
	gint result = 0;
	gint _tmp0_ = 0;
	GKeyFile* _tmp1_;
	GKeyFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp1_ = self->key_file;
	_tmp2_ = self->sys_key_file;
	_tmp0_ = rygel_user_config_get_int_from_keyfiles (section, key, min, max, _tmp1_, _tmp2_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp3_ = -1;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	}
	result = _tmp0_;
	return result;
}

static GeeArrayList*
rygel_user_config_get_int_list_from_keyfiles (const gchar* section,
                                              const gchar* key,
                                              GKeyFile* key_file,
                                              GKeyFile* sys_key_file,
                                              GError** error)
{
	GeeArrayList* result = NULL;
	GeeArrayList* int_list = NULL;
	GeeArrayList* _tmp0_;
	gint* ints = NULL;
	gint ints_length1 = 0;
	gint _ints_size_ = 0;
	gint* _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	int_list = _tmp0_;
	{
		gint* _tmp1_ = NULL;
		gsize _tmp2_ = 0;
		gint* _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gint* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_key_file_get_integer_list (key_file, section, key, &_tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch4_g_key_file_error;
			}
			ints = (g_free (ints), NULL);
			_g_object_unref0 (int_list);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		ints = (g_free (ints), NULL);
		ints = _tmp4_;
		ints_length1 = _tmp4__length1;
		_ints_size_ = ints_length1;
		_tmp1_ = (g_free (_tmp1_), NULL);
	}
	goto __finally4;
	__catch4_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = _error_;
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp5_ = TRUE;
		} else {
			GError* _tmp7_;
			_tmp7_ = _error_;
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		if (_tmp5_) {
			gint* _tmp8_ = NULL;
			gsize _tmp9_ = 0;
			gint* _tmp10_;
			gint _tmp8__length1;
			gint __tmp8__size_;
			gint* _tmp11_;
			gint _tmp11__length1;
			_tmp10_ = g_key_file_get_integer_list (sys_key_file, section, key, &_tmp9_, &_inner_error0_);
			_tmp8_ = _tmp10_;
			_tmp8__length1 = _tmp9_;
			__tmp8__size_ = _tmp8__length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (_error_);
				goto __finally4;
			}
			_tmp11_ = _tmp8_;
			_tmp11__length1 = _tmp8__length1;
			_tmp8_ = NULL;
			_tmp8__length1 = 0;
			ints = (g_free (ints), NULL);
			ints = _tmp11_;
			ints_length1 = _tmp11__length1;
			_ints_size_ = ints_length1;
			_tmp8_ = (g_free (_tmp8_), NULL);
		} else {
			GError* _tmp12_;
			GError* _tmp13_;
			_tmp12_ = _error_;
			_tmp13_ = _g_error_copy0 (_tmp12_);
			_inner_error0_ = _tmp13_;
			_g_error_free0 (_error_);
			goto __finally4;
		}
		_g_error_free0 (_error_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		ints = (g_free (ints), NULL);
		_g_object_unref0 (int_list);
		return NULL;
	}
	_tmp14_ = ints;
	_tmp14__length1 = ints_length1;
	{
		gint* num_collection = NULL;
		gint num_collection_length1 = 0;
		gint _num_collection_size_ = 0;
		gint num_it = 0;
		num_collection = _tmp14_;
		num_collection_length1 = _tmp14__length1;
		for (num_it = 0; num_it < _tmp14__length1; num_it = num_it + 1) {
			gint num = 0;
			num = num_collection[num_it];
			{
				GeeArrayList* _tmp15_;
				_tmp15_ = int_list;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, (gpointer) ((gintptr) num));
			}
		}
	}
	result = int_list;
	ints = (g_free (ints), NULL);
	return result;
}

static GeeArrayList*
rygel_user_config_real_get_int_list (RygelConfiguration* base,
                                     const gchar* section,
                                     const gchar* key,
                                     GError** error)
{
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GKeyFile* _tmp1_;
	GKeyFile* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = self->key_file;
	_tmp2_ = self->sys_key_file;
	_tmp3_ = rygel_user_config_get_int_list_from_keyfiles (section, key, _tmp1_, _tmp2_, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gboolean
rygel_user_config_get_bool_from_keyfiles (const gchar* section,
                                          const gchar* key,
                                          GKeyFile* key_file,
                                          GKeyFile* sys_key_file,
                                          GError** error)
{
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (key_file != NULL, FALSE);
	g_return_val_if_fail (sys_key_file != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = g_key_file_get_boolean (key_file, section, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch5_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		val = _tmp0_;
	}
	goto __finally5;
	__catch5_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp2_ = FALSE;
		GError* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		if (g_error_matches (_tmp3_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp2_ = TRUE;
		} else {
			GError* _tmp4_;
			_tmp4_ = _error_;
			_tmp2_ = g_error_matches (_tmp4_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		if (_tmp2_) {
			gboolean _tmp5_ = FALSE;
			_tmp5_ = g_key_file_get_boolean (sys_key_file, section, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (_error_);
				goto __finally5;
			}
			val = _tmp5_;
		} else {
			GError* _tmp6_;
			GError* _tmp7_;
			_tmp6_ = _error_;
			_tmp7_ = _g_error_copy0 (_tmp6_);
			_inner_error0_ = _tmp7_;
			_g_error_free0 (_error_);
			goto __finally5;
		}
		_g_error_free0 (_error_);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp8_;
	}
	result = val;
	return result;
}

static gboolean
rygel_user_config_real_get_bool (RygelConfiguration* base,
                                 const gchar* section,
                                 const gchar* key,
                                 GError** error)
{
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GKeyFile* _tmp1_;
	GKeyFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = self->key_file;
	_tmp2_ = self->sys_key_file;
	_tmp0_ = rygel_user_config_get_bool_from_keyfiles (section, key, _tmp1_, _tmp2_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	}
	result = _tmp0_;
	return result;
}

static gchar*
rygel_user_config_get_value_from_keyfiles (const gchar* section,
                                           const gchar* key,
                                           GKeyFile* key_file,
                                           GKeyFile* sys_key_file,
                                           GError** error)
{
	gchar* result = NULL;
	gchar* val = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_key_file_get_value (key_file, section, key, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch6_g_key_file_error;
			}
			_g_free0 (val);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (val);
		val = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally6;
	__catch6_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp3_ = FALSE;
		GError* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		if (g_error_matches (_tmp4_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp3_ = TRUE;
		} else {
			GError* _tmp5_;
			_tmp5_ = _error_;
			_tmp3_ = g_error_matches (_tmp5_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		if (_tmp3_) {
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = g_key_file_get_value (sys_key_file, section, key, &_inner_error0_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (_error_);
				goto __finally6;
			}
			_tmp8_ = _tmp6_;
			_tmp6_ = NULL;
			_g_free0 (val);
			val = _tmp8_;
			_g_free0 (_tmp6_);
		} else {
			GError* _tmp9_;
			GError* _tmp10_;
			_tmp9_ = _error_;
			_tmp10_ = _g_error_copy0 (_tmp9_);
			_inner_error0_ = _tmp10_;
			_g_error_free0 (_error_);
			goto __finally6;
		}
		_g_error_free0 (_error_);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}

static GeeHashSet*
rygel_user_config_get_sections (GKeyFile* key_file,
                                GKeyFile* sys_key_file)
{
	GeeHashSet* result = NULL;
	GeeHashSet* sections = NULL;
	GeeHashSet* _tmp0_;
	gsize _tmp1_ = 0;
	gchar** _tmp2_;
	gsize _tmp6_ = 0;
	gchar** _tmp7_;
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	sections = _tmp0_;
	_tmp2_ = g_key_file_get_groups (key_file, &_tmp1_);
	{
		gchar** section_collection = NULL;
		gint section_collection_length1 = 0;
		gint _section_collection_size_ = 0;
		gint section_it = 0;
		section_collection = _tmp2_;
		section_collection_length1 = _tmp1_;
		for (section_it = 0; section_it < _tmp1_; section_it = section_it + 1) {
			gchar* _tmp3_;
			gchar* section = NULL;
			_tmp3_ = g_strdup (section_collection[section_it]);
			section = _tmp3_;
			{
				GeeHashSet* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = sections;
				_tmp5_ = section;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
				_g_free0 (section);
			}
		}
		section_collection = (_vala_array_free (section_collection, section_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp7_ = g_key_file_get_groups (sys_key_file, &_tmp6_);
	{
		gchar** section_collection = NULL;
		gint section_collection_length1 = 0;
		gint _section_collection_size_ = 0;
		gint section_it = 0;
		section_collection = _tmp7_;
		section_collection_length1 = _tmp6_;
		for (section_it = 0; section_it < _tmp6_; section_it = section_it + 1) {
			gchar* _tmp8_;
			gchar* section = NULL;
			_tmp8_ = g_strdup (section_collection[section_it]);
			section = _tmp8_;
			{
				GeeHashSet* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = sections;
				_tmp10_ = section;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
				_g_free0 (section);
			}
		}
		section_collection = (_vala_array_free (section_collection, section_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = sections;
	return result;
}

static GeeHashSet*
rygel_user_config_get_keys (const gchar* section,
                            GKeyFile* key_file,
                            GKeyFile* sys_key_file)
{
	GeeHashSet* result = NULL;
	GeeHashSet* keys = NULL;
	GeeHashSet* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	keys = _tmp0_;
	{
		gchar** _tmp1_ = NULL;
		gsize _tmp2_ = 0;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		_tmp3_ = g_key_file_get_keys (key_file, section, &_tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch7_g_error;
		}
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp1_;
			key_collection_length1 = _tmp1__length1;
			for (key_it = 0; key_it < _tmp1__length1; key_it = key_it + 1) {
				gchar* _tmp4_;
				gchar* key = NULL;
				_tmp4_ = g_strdup (key_collection[key_it]);
				key = _tmp4_;
				{
					const gchar* _tmp5_;
					_tmp5_ = key;
					gee_abstract_collection_add ((GeeAbstractCollection*) keys, _tmp5_);
					_g_free0 (key);
				}
			}
		}
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (keys);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		gchar** _tmp6_ = NULL;
		gsize _tmp7_ = 0;
		gchar** _tmp8_;
		gint _tmp6__length1;
		gint __tmp6__size_;
		_tmp8_ = g_key_file_get_keys (sys_key_file, section, &_tmp7_, &_inner_error0_);
		_tmp6_ = _tmp8_;
		_tmp6__length1 = _tmp7_;
		__tmp6__size_ = _tmp6__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch8_g_error;
		}
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp6_;
			key_collection_length1 = _tmp6__length1;
			for (key_it = 0; key_it < _tmp6__length1; key_it = key_it + 1) {
				gchar* _tmp9_;
				gchar* key = NULL;
				_tmp9_ = g_strdup (key_collection[key_it]);
				key = _tmp9_;
				{
					const gchar* _tmp10_;
					_tmp10_ = key;
					gee_abstract_collection_add ((GeeAbstractCollection*) keys, _tmp10_);
					_g_free0 (key);
				}
			}
		}
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (keys);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = keys;
	return result;
}

static gboolean
rygel_user_config_are_values_different (const gchar* section,
                                        const gchar* key,
                                        GKeyFile* old_key_file,
                                        GKeyFile* old_sys_key_file,
                                        GKeyFile* new_key_file,
                                        GKeyFile* new_sys_key_file,
                                        RygelEntryType type)
{
	gboolean result = FALSE;
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (old_key_file != NULL, FALSE);
	g_return_val_if_fail (old_sys_key_file != NULL, FALSE);
	g_return_val_if_fail (new_key_file != NULL, FALSE);
	g_return_val_if_fail (new_sys_key_file != NULL, FALSE);
	{
		switch (type) {
			case RYGEL_ENTRY_TYPE_STRING:
			{
				gchar* old_value = NULL;
				gchar* _tmp0_;
				gchar* new_value = NULL;
				gchar* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp0_ = rygel_user_config_get_string_from_keyfiles (section, key, old_key_file, old_sys_key_file, &_inner_error0_);
				old_value = _tmp0_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch9_g_error;
				}
				_tmp1_ = rygel_user_config_get_string_from_keyfiles (section, key, new_key_file, new_sys_key_file, &_inner_error0_);
				new_value = _tmp1_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (old_value);
					goto __catch9_g_error;
				}
				_tmp2_ = old_value;
				_tmp3_ = new_value;
				result = g_strcmp0 (_tmp2_, _tmp3_) != 0;
				_g_free0 (new_value);
				_g_free0 (old_value);
				return result;
			}
			case RYGEL_ENTRY_TYPE_BOOL:
			{
				gboolean old_value = FALSE;
				gboolean new_value = FALSE;
				old_value = rygel_user_config_get_bool_from_keyfiles (section, key, old_key_file, old_sys_key_file, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch9_g_error;
				}
				new_value = rygel_user_config_get_bool_from_keyfiles (section, key, new_key_file, new_sys_key_file, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch9_g_error;
				}
				result = old_value != new_value;
				return result;
			}
			case RYGEL_ENTRY_TYPE_INT:
			{
				gint old_value = 0;
				gint new_value = 0;
				old_value = rygel_user_config_get_int_from_keyfiles (section, key, G_MININT, G_MAXINT, old_key_file, old_sys_key_file, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch9_g_error;
				}
				new_value = rygel_user_config_get_int_from_keyfiles (section, key, G_MININT, G_MAXINT, new_key_file, new_sys_key_file, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch9_g_error;
				}
				result = old_value != new_value;
				return result;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		result = TRUE;
		_g_error_free0 (e);
		return result;
	}
	__finally9:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp4_;
}

static void
rygel_user_config_emit_conditionally (RygelUserConfig* self,
                                      const gchar* section,
                                      const gchar* key,
                                      GKeyFile* old_key_file,
                                      GKeyFile* old_sys_key_file,
                                      GKeyFile* key_file,
                                      GKeyFile* sys_key_file,
                                      GeeHashMap* config_keys)
{
	GeeHashMap* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (old_key_file != NULL);
	g_return_if_fail (old_sys_key_file != NULL);
	g_return_if_fail (key_file != NULL);
	g_return_if_fail (sys_key_file != NULL);
	g_return_if_fail (config_keys != NULL);
	_tmp0_ = rygel_user_config_section_keys;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, key)) {
		RygelUserConfigSectionPair* pair = NULL;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		gboolean emit = FALSE;
		RygelUserConfigSectionPair* _tmp3_;
		RygelEntryType _tmp4_;
		_tmp1_ = rygel_user_config_section_keys;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, key);
		pair = (RygelUserConfigSectionPair*) _tmp2_;
		_tmp3_ = pair;
		_tmp4_ = _tmp3_->type;
		emit = rygel_user_config_are_values_different (section, key, old_key_file, old_sys_key_file, key_file, sys_key_file, _tmp4_);
		if (emit) {
			RygelUserConfigSectionPair* _tmp5_;
			RygelSectionEntry _tmp6_;
			_tmp5_ = pair;
			_tmp6_ = _tmp5_->entry;
			g_signal_emit_by_name ((RygelConfiguration*) self, "section-changed", section, _tmp6_);
		}
		_rygel_user_config_section_pair_unref0 (pair);
	} else {
		if (gee_abstract_map_has_key ((GeeAbstractMap*) config_keys, key)) {
			RygelUserConfigConfigPair* pair = NULL;
			gpointer _tmp7_;
			gboolean emit = FALSE;
			RygelUserConfigConfigPair* _tmp8_;
			RygelEntryType _tmp9_;
			_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) config_keys, key);
			pair = (RygelUserConfigConfigPair*) _tmp7_;
			_tmp8_ = pair;
			_tmp9_ = _tmp8_->type;
			emit = rygel_user_config_are_values_different (section, key, old_key_file, old_sys_key_file, key_file, sys_key_file, _tmp9_);
			if (emit) {
				RygelUserConfigConfigPair* _tmp10_;
				RygelConfigurationEntry _tmp11_;
				_tmp10_ = pair;
				_tmp11_ = _tmp10_->entry;
				g_signal_emit_by_name ((RygelConfiguration*) self, "configuration-changed", _tmp11_);
			}
			_rygel_user_config_config_pair_unref0 (pair);
		} else {
			gboolean emit = FALSE;
			emit = FALSE;
			{
				gchar* old_value = NULL;
				gchar* _tmp12_;
				gchar* new_value = NULL;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp12_ = rygel_user_config_get_value_from_keyfiles (section, key, old_key_file, old_sys_key_file, &_inner_error0_);
				old_value = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch10_g_error;
				}
				_tmp13_ = rygel_user_config_get_value_from_keyfiles (section, key, key_file, sys_key_file, &_inner_error0_);
				new_value = _tmp13_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (old_value);
					goto __catch10_g_error;
				}
				_tmp14_ = old_value;
				_tmp15_ = new_value;
				emit = g_strcmp0 (_tmp14_, _tmp15_) != 0;
				_g_free0 (new_value);
				_g_free0 (old_value);
			}
			goto __finally10;
			__catch10_g_error:
			{
				GError* e = NULL;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				emit = TRUE;
				_g_error_free0 (e);
			}
			__finally10:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (emit) {
				g_signal_emit_by_name ((RygelConfiguration*) self, "setting-changed", section, key);
			}
		}
	}
}

static void
rygel_user_config_emit_unconditionally (RygelUserConfig* self,
                                        const gchar* section,
                                        const gchar* key,
                                        GeeHashMap* config_keys)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (config_keys != NULL);
	_tmp0_ = rygel_user_config_section_keys;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, key)) {
		RygelUserConfigSectionPair* pair = NULL;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		RygelUserConfigSectionPair* _tmp3_;
		RygelSectionEntry _tmp4_;
		_tmp1_ = rygel_user_config_section_keys;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, key);
		pair = (RygelUserConfigSectionPair*) _tmp2_;
		_tmp3_ = pair;
		_tmp4_ = _tmp3_->entry;
		g_signal_emit_by_name ((RygelConfiguration*) self, "section-changed", section, _tmp4_);
		_rygel_user_config_section_pair_unref0 (pair);
	} else {
		if (gee_abstract_map_has_key ((GeeAbstractMap*) config_keys, key)) {
			RygelUserConfigConfigPair* pair = NULL;
			gpointer _tmp5_;
			RygelUserConfigConfigPair* _tmp6_;
			RygelConfigurationEntry _tmp7_;
			_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) config_keys, key);
			pair = (RygelUserConfigConfigPair*) _tmp5_;
			_tmp6_ = pair;
			_tmp7_ = _tmp6_->entry;
			g_signal_emit_by_name ((RygelConfiguration*) self, "configuration-changed", _tmp7_);
			_rygel_user_config_config_pair_unref0 (pair);
		} else {
			g_signal_emit_by_name ((RygelConfiguration*) self, "setting-changed", section, key);
		}
	}
}

static gpointer
_g_key_file_ref0 (gpointer self)
{
	return self ? g_key_file_ref (self) : NULL;
}

static void
rygel_user_config_compare_and_notify (RygelUserConfig* self,
                                      GKeyFile* key_file,
                                      GKeyFile* sys_key_file)
{
	GKeyFile* old_key_file = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	GKeyFile* old_sys_key_file = NULL;
	GKeyFile* _tmp2_;
	GKeyFile* _tmp3_;
	GeeHashSet* old_sections = NULL;
	GKeyFile* _tmp4_;
	GKeyFile* _tmp5_;
	GeeHashSet* _tmp6_;
	GeeHashSet* new_sections = NULL;
	GeeHashSet* _tmp7_;
	GKeyFile* _tmp8_;
	GKeyFile* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_file != NULL);
	g_return_if_fail (sys_key_file != NULL);
	_tmp0_ = self->key_file;
	_tmp1_ = _g_key_file_ref0 (_tmp0_);
	old_key_file = _tmp1_;
	_tmp2_ = self->sys_key_file;
	_tmp3_ = _g_key_file_ref0 (_tmp2_);
	old_sys_key_file = _tmp3_;
	_tmp4_ = old_key_file;
	_tmp5_ = old_sys_key_file;
	_tmp6_ = rygel_user_config_get_sections (_tmp4_, _tmp5_);
	old_sections = _tmp6_;
	_tmp7_ = rygel_user_config_get_sections (key_file, sys_key_file);
	new_sections = _tmp7_;
	_tmp8_ = _g_key_file_ref0 (key_file);
	_g_key_file_unref0 (self->key_file);
	self->key_file = _tmp8_;
	_tmp9_ = _g_key_file_ref0 (sys_key_file);
	_g_key_file_unref0 (self->sys_key_file);
	self->sys_key_file = _tmp9_;
	{
		GeeIterator* _section_it = NULL;
		GeeHashSet* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp10_ = old_sections;
		_tmp11_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp10_);
		_section_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* section = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			GeeHashSet* old_keys = NULL;
			const gchar* _tmp15_;
			GKeyFile* _tmp16_;
			GKeyFile* _tmp17_;
			GeeHashSet* _tmp18_;
			GeeHashMap* _tmp19_ = NULL;
			GeeHashMap* _tmp20_;
			const gchar* _tmp21_;
			GeeHashMap* config_keys = NULL;
			GeeHashMap* _tmp26_;
			GeeHashSet* _tmp27_;
			const gchar* _tmp28_;
			_tmp12_ = _section_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _section_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			section = (gchar*) _tmp14_;
			_tmp15_ = section;
			_tmp16_ = old_key_file;
			_tmp17_ = old_sys_key_file;
			_tmp18_ = rygel_user_config_get_keys (_tmp15_, _tmp16_, _tmp17_);
			old_keys = _tmp18_;
			_tmp20_ = rygel_user_config_config_keys;
			_tmp21_ = section;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp20_, _tmp21_)) {
				GeeHashMap* _tmp22_;
				const gchar* _tmp23_;
				gpointer _tmp24_;
				_tmp22_ = rygel_user_config_config_keys;
				_tmp23_ = section;
				_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp23_);
				_g_object_unref0 (_tmp19_);
				_tmp19_ = (GeeHashMap*) _tmp24_;
			} else {
				GeeHashMap* _tmp25_;
				_tmp25_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, (GBoxedCopyFunc) rygel_user_config_config_pair_ref, (GDestroyNotify) rygel_user_config_config_pair_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (_tmp19_);
				_tmp19_ = _tmp25_;
			}
			_tmp26_ = _g_object_ref0 (_tmp19_);
			config_keys = _tmp26_;
			_tmp27_ = new_sections;
			_tmp28_ = section;
			if (gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp27_, _tmp28_)) {
				GeeHashSet* new_keys = NULL;
				const gchar* _tmp29_;
				GeeHashSet* _tmp30_;
				_tmp29_ = section;
				_tmp30_ = rygel_user_config_get_keys (_tmp29_, key_file, sys_key_file);
				new_keys = _tmp30_;
				{
					GeeIterator* _key_it = NULL;
					GeeHashSet* _tmp31_;
					GeeIterator* _tmp32_;
					_tmp31_ = old_keys;
					_tmp32_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp31_);
					_key_it = _tmp32_;
					while (TRUE) {
						GeeIterator* _tmp33_;
						gchar* key = NULL;
						GeeIterator* _tmp34_;
						gpointer _tmp35_;
						GeeHashSet* _tmp36_;
						const gchar* _tmp37_;
						_tmp33_ = _key_it;
						if (!gee_iterator_next (_tmp33_)) {
							break;
						}
						_tmp34_ = _key_it;
						_tmp35_ = gee_iterator_get (_tmp34_);
						key = (gchar*) _tmp35_;
						_tmp36_ = new_keys;
						_tmp37_ = key;
						if (gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp36_, _tmp37_)) {
							const gchar* _tmp38_;
							const gchar* _tmp39_;
							GKeyFile* _tmp40_;
							GKeyFile* _tmp41_;
							GeeHashMap* _tmp42_;
							_tmp38_ = section;
							_tmp39_ = key;
							_tmp40_ = old_key_file;
							_tmp41_ = old_sys_key_file;
							_tmp42_ = config_keys;
							rygel_user_config_emit_conditionally (self, _tmp38_, _tmp39_, _tmp40_, _tmp41_, key_file, sys_key_file, _tmp42_);
						} else {
							const gchar* _tmp43_;
							const gchar* _tmp44_;
							GeeHashMap* _tmp45_;
							_tmp43_ = section;
							_tmp44_ = key;
							_tmp45_ = config_keys;
							rygel_user_config_emit_unconditionally (self, _tmp43_, _tmp44_, _tmp45_);
						}
						_g_free0 (key);
					}
					_g_object_unref0 (_key_it);
				}
				{
					GeeIterator* _key_it = NULL;
					GeeHashSet* _tmp46_;
					GeeIterator* _tmp47_;
					_tmp46_ = new_keys;
					_tmp47_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp46_);
					_key_it = _tmp47_;
					while (TRUE) {
						GeeIterator* _tmp48_;
						gchar* key = NULL;
						GeeIterator* _tmp49_;
						gpointer _tmp50_;
						const gchar* _tmp51_;
						const gchar* _tmp52_;
						GeeHashMap* _tmp53_;
						_tmp48_ = _key_it;
						if (!gee_iterator_next (_tmp48_)) {
							break;
						}
						_tmp49_ = _key_it;
						_tmp50_ = gee_iterator_get (_tmp49_);
						key = (gchar*) _tmp50_;
						_tmp51_ = section;
						_tmp52_ = key;
						_tmp53_ = config_keys;
						rygel_user_config_emit_unconditionally (self, _tmp51_, _tmp52_, _tmp53_);
						_g_free0 (key);
					}
					_g_object_unref0 (_key_it);
				}
				_g_object_unref0 (new_keys);
			} else {
				{
					GeeIterator* _key_it = NULL;
					GeeHashSet* _tmp54_;
					GeeIterator* _tmp55_;
					_tmp54_ = old_keys;
					_tmp55_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp54_);
					_key_it = _tmp55_;
					while (TRUE) {
						GeeIterator* _tmp56_;
						gchar* key = NULL;
						GeeIterator* _tmp57_;
						gpointer _tmp58_;
						const gchar* _tmp59_;
						const gchar* _tmp60_;
						GeeHashMap* _tmp61_;
						_tmp56_ = _key_it;
						if (!gee_iterator_next (_tmp56_)) {
							break;
						}
						_tmp57_ = _key_it;
						_tmp58_ = gee_iterator_get (_tmp57_);
						key = (gchar*) _tmp58_;
						_tmp59_ = section;
						_tmp60_ = key;
						_tmp61_ = config_keys;
						rygel_user_config_emit_unconditionally (self, _tmp59_, _tmp60_, _tmp61_);
						_g_free0 (key);
					}
					_g_object_unref0 (_key_it);
				}
			}
			_g_object_unref0 (config_keys);
			_g_object_unref0 (_tmp19_);
			_g_object_unref0 (old_keys);
			_g_free0 (section);
		}
		_g_object_unref0 (_section_it);
	}
	{
		GeeIterator* _section_it = NULL;
		GeeHashSet* _tmp62_;
		GeeIterator* _tmp63_;
		_tmp62_ = new_sections;
		_tmp63_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp62_);
		_section_it = _tmp63_;
		while (TRUE) {
			GeeIterator* _tmp64_;
			gchar* section = NULL;
			GeeIterator* _tmp65_;
			gpointer _tmp66_;
			GeeHashSet* keys = NULL;
			const gchar* _tmp67_;
			GeeHashSet* _tmp68_;
			GeeHashMap* _tmp69_ = NULL;
			GeeHashMap* _tmp70_;
			const gchar* _tmp71_;
			GeeHashMap* config_keys = NULL;
			GeeHashMap* _tmp76_;
			_tmp64_ = _section_it;
			if (!gee_iterator_next (_tmp64_)) {
				break;
			}
			_tmp65_ = _section_it;
			_tmp66_ = gee_iterator_get (_tmp65_);
			section = (gchar*) _tmp66_;
			_tmp67_ = section;
			_tmp68_ = rygel_user_config_get_keys (_tmp67_, sys_key_file, key_file);
			keys = _tmp68_;
			_tmp70_ = rygel_user_config_config_keys;
			_tmp71_ = section;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp70_, _tmp71_)) {
				GeeHashMap* _tmp72_;
				const gchar* _tmp73_;
				gpointer _tmp74_;
				_tmp72_ = rygel_user_config_config_keys;
				_tmp73_ = section;
				_tmp74_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp72_, _tmp73_);
				_g_object_unref0 (_tmp69_);
				_tmp69_ = (GeeHashMap*) _tmp74_;
			} else {
				GeeHashMap* _tmp75_;
				_tmp75_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, (GBoxedCopyFunc) rygel_user_config_config_pair_ref, (GDestroyNotify) rygel_user_config_config_pair_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (_tmp69_);
				_tmp69_ = _tmp75_;
			}
			_tmp76_ = _g_object_ref0 (_tmp69_);
			config_keys = _tmp76_;
			{
				GeeIterator* _key_it = NULL;
				GeeHashSet* _tmp77_;
				GeeIterator* _tmp78_;
				_tmp77_ = keys;
				_tmp78_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp77_);
				_key_it = _tmp78_;
				while (TRUE) {
					GeeIterator* _tmp79_;
					gchar* key = NULL;
					GeeIterator* _tmp80_;
					gpointer _tmp81_;
					const gchar* _tmp82_;
					const gchar* _tmp83_;
					GeeHashMap* _tmp84_;
					_tmp79_ = _key_it;
					if (!gee_iterator_next (_tmp79_)) {
						break;
					}
					_tmp80_ = _key_it;
					_tmp81_ = gee_iterator_get (_tmp80_);
					key = (gchar*) _tmp81_;
					_tmp82_ = section;
					_tmp83_ = key;
					_tmp84_ = config_keys;
					rygel_user_config_emit_unconditionally (self, _tmp82_, _tmp83_, _tmp84_);
					_g_free0 (key);
				}
				_g_object_unref0 (_key_it);
			}
			_g_object_unref0 (config_keys);
			_g_object_unref0 (_tmp69_);
			_g_object_unref0 (keys);
			_g_free0 (section);
		}
		_g_object_unref0 (_section_it);
	}
	_g_object_unref0 (new_sections);
	_g_object_unref0 (old_sections);
	_g_key_file_unref0 (old_sys_key_file);
	_g_key_file_unref0 (old_key_file);
}

static void
rygel_user_config_reload_compare_and_notify_system (RygelUserConfig* self,
                                                    GFile* system)
{
	GKeyFile* sys_key_file = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (system != NULL);
	_tmp0_ = g_key_file_new ();
	sys_key_file = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_file_get_path (system);
		_tmp2_ = _tmp1_;
		g_key_file_load_from_file (sys_key_file, _tmp2_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (sys_key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->key_file;
	rygel_user_config_compare_and_notify (self, _tmp3_, sys_key_file);
	_g_key_file_unref0 (sys_key_file);
}

static void
rygel_user_config_reload_compare_and_notify_local (RygelUserConfig* self,
                                                   GFile* local)
{
	GKeyFile* key_file = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = g_key_file_new ();
	key_file = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_file_get_path (local);
		_tmp2_ = _tmp1_;
		g_key_file_load_from_file (key_file, _tmp2_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->sys_key_file;
	rygel_user_config_compare_and_notify (self, key_file, _tmp3_);
	_g_key_file_unref0 (key_file);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelUserConfig* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->file);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda4_ (Block1Data* _data1_)
{
	RygelUserConfig* self;
	gboolean result = FALSE;
	self = _data1_->self;
	self->priv->system_config_timer_id = (guint) 0;
	rygel_user_config_reload_compare_and_notify_system (self, _data1_->file);
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ (self);
	return result;
}

static void
rygel_user_config_on_system_config_changed (RygelUserConfig* self,
                                            GFileMonitor* monitor,
                                            GFile* file,
                                            GFile* other_file,
                                            GFileMonitorEvent event_type)
{
	Block1Data* _data1_;
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data1_->file);
	_data1_->file = _tmp0_;
	if (self->priv->system_config_timer_id != ((guint) 0)) {
		g_source_remove (self->priv->system_config_timer_id);
	}
	self->priv->system_config_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelUserConfig* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->file);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda5_ (Block2Data* _data2_)
{
	RygelUserConfig* self;
	gboolean result = FALSE;
	self = _data2_->self;
	self->priv->local_config_timer_id = (guint) 0;
	rygel_user_config_reload_compare_and_notify_local (self, _data2_->file);
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ (self);
	return result;
}

static void
rygel_user_config_on_local_config_changed (RygelUserConfig* self,
                                           GFileMonitor* monitor,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event_type)
{
	Block2Data* _data2_;
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data2_->file);
	_data2_->file = _tmp0_;
	if (self->priv->local_config_timer_id != ((guint) 0)) {
		g_source_remove (self->priv->local_config_timer_id);
	}
	self->priv->local_config_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda5__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static RygelUserConfigConfigPair*
rygel_user_config_config_pair_construct (GType object_type,
                                         RygelConfigurationEntry entry,
                                         RygelEntryType type)
{
	RygelUserConfigConfigPair* self = NULL;
	self = (RygelUserConfigConfigPair*) g_type_create_instance (object_type);
	self->entry = entry;
	self->type = type;
	return self;
}

static RygelUserConfigConfigPair*
rygel_user_config_config_pair_new (RygelConfigurationEntry entry,
                                   RygelEntryType type)
{
	return rygel_user_config_config_pair_construct (RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, entry, type);
}

static void
rygel_user_config_value_config_pair_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_user_config_value_config_pair_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_user_config_config_pair_unref (value->data[0].v_pointer);
	}
}

static void
rygel_user_config_value_config_pair_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_user_config_config_pair_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_user_config_value_config_pair_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_user_config_value_config_pair_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelUserConfigConfigPair * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_user_config_config_pair_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_user_config_value_config_pair_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	RygelUserConfigConfigPair ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_user_config_config_pair_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
rygel_user_config_param_spec_config_pair (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	RygelUserConfigParamSpecConfigPair* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
rygel_user_config_value_get_config_pair (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR), NULL);
	return value->data[0].v_pointer;
}

static void
rygel_user_config_value_set_config_pair (GValue* value,
                                         gpointer v_object)
{
	RygelUserConfigConfigPair * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_user_config_config_pair_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_user_config_config_pair_unref (old);
	}
}

static void
rygel_user_config_value_take_config_pair (GValue* value,
                                          gpointer v_object)
{
	RygelUserConfigConfigPair * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_user_config_config_pair_unref (old);
	}
}

static void
rygel_user_config_config_pair_class_init (RygelUserConfigConfigPairClass * klass,
                                          gpointer klass_data)
{
	rygel_user_config_config_pair_parent_class = g_type_class_peek_parent (klass);
	((RygelUserConfigConfigPairClass *) klass)->finalize = rygel_user_config_config_pair_finalize;
}

static void
rygel_user_config_config_pair_instance_init (RygelUserConfigConfigPair * self,
                                             gpointer klass)
{
	self->ref_count = 1;
}

static void
rygel_user_config_config_pair_finalize (RygelUserConfigConfigPair * obj)
{
	RygelUserConfigConfigPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPair);
	g_signal_handlers_destroy (self);
}

static GType
rygel_user_config_config_pair_get_type (void)
{
	static volatile gsize rygel_user_config_config_pair_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_config_pair_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_user_config_value_config_pair_init, rygel_user_config_value_config_pair_free_value, rygel_user_config_value_config_pair_copy_value, rygel_user_config_value_config_pair_peek_pointer, "p", rygel_user_config_value_config_pair_collect_value, "p", rygel_user_config_value_config_pair_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigConfigPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_config_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfigConfigPair), 0, (GInstanceInitFunc) rygel_user_config_config_pair_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_user_config_config_pair_type_id;
		rygel_user_config_config_pair_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelUserConfigConfigPair", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_user_config_config_pair_type_id__volatile, rygel_user_config_config_pair_type_id);
	}
	return rygel_user_config_config_pair_type_id__volatile;
}

static gpointer
rygel_user_config_config_pair_ref (gpointer instance)
{
	RygelUserConfigConfigPair * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
rygel_user_config_config_pair_unref (gpointer instance)
{
	RygelUserConfigConfigPair * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_USER_CONFIG_CONFIG_PAIR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static RygelUserConfigSectionPair*
rygel_user_config_section_pair_construct (GType object_type,
                                          RygelSectionEntry entry,
                                          RygelEntryType type)
{
	RygelUserConfigSectionPair* self = NULL;
	self = (RygelUserConfigSectionPair*) g_type_create_instance (object_type);
	self->entry = entry;
	self->type = type;
	return self;
}

static RygelUserConfigSectionPair*
rygel_user_config_section_pair_new (RygelSectionEntry entry,
                                    RygelEntryType type)
{
	return rygel_user_config_section_pair_construct (RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, entry, type);
}

static void
rygel_user_config_value_section_pair_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_user_config_value_section_pair_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_user_config_section_pair_unref (value->data[0].v_pointer);
	}
}

static void
rygel_user_config_value_section_pair_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_user_config_section_pair_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_user_config_value_section_pair_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_user_config_value_section_pair_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelUserConfigSectionPair * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_user_config_section_pair_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_user_config_value_section_pair_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	RygelUserConfigSectionPair ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_user_config_section_pair_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
rygel_user_config_param_spec_section_pair (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	RygelUserConfigParamSpecSectionPair* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
rygel_user_config_value_get_section_pair (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR), NULL);
	return value->data[0].v_pointer;
}

static void
rygel_user_config_value_set_section_pair (GValue* value,
                                          gpointer v_object)
{
	RygelUserConfigSectionPair * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_user_config_section_pair_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_user_config_section_pair_unref (old);
	}
}

static void
rygel_user_config_value_take_section_pair (GValue* value,
                                           gpointer v_object)
{
	RygelUserConfigSectionPair * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_user_config_section_pair_unref (old);
	}
}

static void
rygel_user_config_section_pair_class_init (RygelUserConfigSectionPairClass * klass,
                                           gpointer klass_data)
{
	rygel_user_config_section_pair_parent_class = g_type_class_peek_parent (klass);
	((RygelUserConfigSectionPairClass *) klass)->finalize = rygel_user_config_section_pair_finalize;
}

static void
rygel_user_config_section_pair_instance_init (RygelUserConfigSectionPair * self,
                                              gpointer klass)
{
	self->ref_count = 1;
}

static void
rygel_user_config_section_pair_finalize (RygelUserConfigSectionPair * obj)
{
	RygelUserConfigSectionPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPair);
	g_signal_handlers_destroy (self);
}

static GType
rygel_user_config_section_pair_get_type (void)
{
	static volatile gsize rygel_user_config_section_pair_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_section_pair_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_user_config_value_section_pair_init, rygel_user_config_value_section_pair_free_value, rygel_user_config_value_section_pair_copy_value, rygel_user_config_value_section_pair_peek_pointer, "p", rygel_user_config_value_section_pair_collect_value, "p", rygel_user_config_value_section_pair_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigSectionPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_section_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfigSectionPair), 0, (GInstanceInitFunc) rygel_user_config_section_pair_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_user_config_section_pair_type_id;
		rygel_user_config_section_pair_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelUserConfigSectionPair", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_user_config_section_pair_type_id__volatile, rygel_user_config_section_pair_type_id);
	}
	return rygel_user_config_section_pair_type_id__volatile;
}

static gpointer
rygel_user_config_section_pair_ref (gpointer instance)
{
	RygelUserConfigSectionPair * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
rygel_user_config_section_pair_unref (gpointer instance)
{
	RygelUserConfigSectionPair * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_USER_CONFIG_SECTION_PAIR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
rygel_user_config_class_init (RygelUserConfigClass * klass,
                              gpointer klass_data)
{
	GeeHashMap* general_config_keys = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	RygelUserConfigConfigPair* _tmp4_;
	RygelUserConfigConfigPair* _tmp5_;
	GeeHashMap* _tmp6_;
	RygelUserConfigConfigPair* _tmp7_;
	RygelUserConfigConfigPair* _tmp8_;
	GeeHashMap* _tmp9_;
	RygelUserConfigConfigPair* _tmp10_;
	RygelUserConfigConfigPair* _tmp11_;
	GeeHashMap* _tmp12_;
	RygelUserConfigConfigPair* _tmp13_;
	RygelUserConfigConfigPair* _tmp14_;
	GeeHashMap* _tmp15_;
	RygelUserConfigConfigPair* _tmp16_;
	RygelUserConfigConfigPair* _tmp17_;
	GeeHashMap* _tmp18_;
	RygelUserConfigConfigPair* _tmp19_;
	RygelUserConfigConfigPair* _tmp20_;
	GeeHashMap* _tmp21_;
	RygelUserConfigConfigPair* _tmp22_;
	RygelUserConfigConfigPair* _tmp23_;
	GeeHashMap* _tmp24_;
	RygelUserConfigConfigPair* _tmp25_;
	RygelUserConfigConfigPair* _tmp26_;
	GeeHashMap* _tmp27_;
	RygelUserConfigConfigPair* _tmp28_;
	RygelUserConfigConfigPair* _tmp29_;
	GeeHashMap* _tmp30_;
	RygelUserConfigConfigPair* _tmp31_;
	RygelUserConfigConfigPair* _tmp32_;
	GeeHashMap* _tmp33_;
	GeeHashMap* _tmp34_;
	GeeHashMap* _tmp35_;
	RygelUserConfigSectionPair* _tmp36_;
	RygelUserConfigSectionPair* _tmp37_;
	GeeHashMap* _tmp38_;
	RygelUserConfigSectionPair* _tmp39_;
	RygelUserConfigSectionPair* _tmp40_;
	rygel_user_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelUserConfig_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_user_config_finalize;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, (GBoxedCopyFunc) rygel_user_config_config_pair_ref, (GDestroyNotify) rygel_user_config_config_pair_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	general_config_keys = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (rygel_user_config_config_keys);
	rygel_user_config_config_keys = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, (GBoxedCopyFunc) rygel_user_config_section_pair_ref, (GDestroyNotify) rygel_user_config_section_pair_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (rygel_user_config_section_keys);
	rygel_user_config_section_keys = _tmp2_;
	_tmp3_ = general_config_keys;
	_tmp4_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_INTERFACE, RYGEL_ENTRY_TYPE_STRING);
	_tmp5_ = _tmp4_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, RYGEL_USER_CONFIG_IFACE_KEY, _tmp5_);
	_rygel_user_config_config_pair_unref0 (_tmp5_);
	_tmp6_ = general_config_keys;
	_tmp7_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_PORT, RYGEL_ENTRY_TYPE_INT);
	_tmp8_ = _tmp7_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, RYGEL_USER_CONFIG_PORT_KEY, _tmp8_);
	_rygel_user_config_config_pair_unref0 (_tmp8_);
	_tmp9_ = general_config_keys;
	_tmp10_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_TRANSCODING, RYGEL_ENTRY_TYPE_BOOL);
	_tmp11_ = _tmp10_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, RYGEL_USER_CONFIG_TRANSCODING_KEY, _tmp11_);
	_rygel_user_config_config_pair_unref0 (_tmp11_);
	_tmp12_ = general_config_keys;
	_tmp13_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_ALLOW_UPLOAD, RYGEL_ENTRY_TYPE_BOOL);
	_tmp14_ = _tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY, _tmp14_);
	_rygel_user_config_config_pair_unref0 (_tmp14_);
	_tmp15_ = general_config_keys;
	_tmp16_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_ALLOW_DELETION, RYGEL_ENTRY_TYPE_BOOL);
	_tmp17_ = _tmp16_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, RYGEL_USER_CONFIG_ALLOW_DELETION_KEY, _tmp17_);
	_rygel_user_config_config_pair_unref0 (_tmp17_);
	_tmp18_ = general_config_keys;
	_tmp19_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_LOG_LEVELS, RYGEL_ENTRY_TYPE_STRING);
	_tmp20_ = _tmp19_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, RYGEL_USER_CONFIG_LOG_LEVELS_KEY, _tmp20_);
	_rygel_user_config_config_pair_unref0 (_tmp20_);
	_tmp21_ = general_config_keys;
	_tmp22_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_PLUGIN_PATH, RYGEL_ENTRY_TYPE_STRING);
	_tmp23_ = _tmp22_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, RYGEL_USER_CONFIG_PLUGIN_PATH_KEY, _tmp23_);
	_rygel_user_config_config_pair_unref0 (_tmp23_);
	_tmp24_ = general_config_keys;
	_tmp25_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_VIDEO_UPLOAD_FOLDER, RYGEL_ENTRY_TYPE_STRING);
	_tmp26_ = _tmp25_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY, _tmp26_);
	_rygel_user_config_config_pair_unref0 (_tmp26_);
	_tmp27_ = general_config_keys;
	_tmp28_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_MUSIC_UPLOAD_FOLDER, RYGEL_ENTRY_TYPE_STRING);
	_tmp29_ = _tmp28_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY, _tmp29_);
	_rygel_user_config_config_pair_unref0 (_tmp29_);
	_tmp30_ = general_config_keys;
	_tmp31_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_PICTURE_UPLOAD_FOLDER, RYGEL_ENTRY_TYPE_STRING);
	_tmp32_ = _tmp31_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY, _tmp32_);
	_rygel_user_config_config_pair_unref0 (_tmp32_);
	_tmp33_ = rygel_user_config_config_keys;
	_tmp34_ = general_config_keys;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, RYGEL_USER_CONFIG_GENERAL_SECTION, _tmp34_);
	_tmp35_ = rygel_user_config_section_keys;
	_tmp36_ = rygel_user_config_section_pair_new (RYGEL_SECTION_ENTRY_ENABLED, RYGEL_ENTRY_TYPE_BOOL);
	_tmp37_ = _tmp36_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp35_, RYGEL_USER_CONFIG_ENABLED_KEY, _tmp37_);
	_rygel_user_config_section_pair_unref0 (_tmp37_);
	_tmp38_ = rygel_user_config_section_keys;
	_tmp39_ = rygel_user_config_section_pair_new (RYGEL_SECTION_ENTRY_TITLE, RYGEL_ENTRY_TYPE_STRING);
	_tmp40_ = _tmp39_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp38_, RYGEL_USER_CONFIG_TITLE_KEY, _tmp40_);
	_rygel_user_config_section_pair_unref0 (_tmp40_);
	_g_object_unref0 (general_config_keys);
}

static void
rygel_user_config_rygel_configuration_interface_init (RygelConfigurationIface * iface,
                                                      gpointer iface_data)
{
	rygel_user_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_interfaces = (gchar** (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_interfaces;
	iface->get_interface = (gchar* (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_interface;
	iface->get_port = (gint (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_port;
	iface->get_transcoding = (gboolean (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_transcoding;
	iface->get_allow_upload = (gboolean (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_allow_upload;
	iface->get_allow_deletion = (gboolean (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_allow_deletion;
	iface->get_log_levels = (gchar* (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_log_levels;
	iface->get_plugin_path = (gchar* (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_plugin_path;
	iface->get_engine_path = (gchar* (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_engine_path;
	iface->get_media_engine = (gchar* (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_media_engine;
	iface->get_video_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_video_upload_folder;
	iface->get_music_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_music_upload_folder;
	iface->get_picture_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_user_config_real_get_picture_upload_folder;
	iface->get_enabled = (gboolean (*) (RygelConfiguration*, const gchar*, GError**)) rygel_user_config_real_get_enabled;
	iface->get_title = (gchar* (*) (RygelConfiguration*, const gchar*, GError**)) rygel_user_config_real_get_title;
	iface->get_string = (gchar* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_string_list;
	iface->get_int = (gint (*) (RygelConfiguration*, const gchar*, const gchar*, gint, gint, GError**)) rygel_user_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_int_list;
	iface->get_bool = (gboolean (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_bool;
}

static void
rygel_user_config_instance_init (RygelUserConfig * self,
                                 gpointer klass)
{
	self->priv = rygel_user_config_get_instance_private (self);
	self->priv->system_config_timer_id = (guint) 0;
	self->priv->local_config_timer_id = (guint) 0;
}

static void
rygel_user_config_finalize (GObject * obj)
{
	RygelUserConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_USER_CONFIG, RygelUserConfig);
	_g_key_file_unref0 (self->key_file);
	_g_key_file_unref0 (self->sys_key_file);
	_g_object_unref0 (self->key_file_monitor);
	_g_object_unref0 (self->sys_key_file_monitor);
	G_OBJECT_CLASS (rygel_user_config_parent_class)->finalize (obj);
}

/**
 * Manages the user configuration for Rygel.
 */
GType
rygel_user_config_get_type (void)
{
	static volatile gsize rygel_user_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfig), 0, (GInstanceInitFunc) rygel_user_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_user_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_user_config_type_id;
		rygel_user_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelUserConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_user_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		RygelUserConfig_private_offset = g_type_add_instance_private (rygel_user_config_type_id, sizeof (RygelUserConfigPrivate));
		g_once_init_leave (&rygel_user_config_type_id__volatile, rygel_user_config_type_id);
	}
	return rygel_user_config_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

