/* rygel-video-item.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-video-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel-core.h>

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
typedef struct _RygelMediaFileItemPrivate RygelMediaFileItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
enum  {
	RYGEL_VIDEO_ITEM_0_PROPERTY,
	RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY,
	RYGEL_VIDEO_ITEM_WIDTH_PROPERTY,
	RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY,
	RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY,
	RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY,
	RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY,
	RYGEL_VIDEO_ITEM_NUM_PROPERTIES
};
static GParamSpec* rygel_video_item_properties[RYGEL_VIDEO_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelMediaFileItem {
	RygelMediaItem parent_instance;
	RygelMediaFileItemPrivate * priv;
};

struct _RygelMediaFileItemClass {
	RygelMediaItemClass parent_class;
	RygelMediaResource* (*get_primary_resource) (RygelMediaFileItem* self);
	gchar* (*get_extension) (RygelMediaFileItem* self);
	void (*add_engine_resources) (RygelMediaFileItem* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_engine_resources_finish) (RygelMediaFileItem* self, GAsyncResult* _res_);
	void (*add_additional_resources) (RygelMediaFileItem* self, RygelHTTPServer* server);
};

struct _RygelAudioItem {
	RygelMediaFileItem parent_instance;
	RygelAudioItemPrivate * priv;
};

struct _RygelAudioItemClass {
	RygelMediaFileItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gchar* _author;
	gint _width;
	gint _height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
	GeeArrayList* _subtitles;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

static gint RygelVideoItem_private_offset;
static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface * rygel_video_item_rygel_visual_item_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObject, g_object_unref)
GType rygel_serializer_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSerializer, g_object_unref)
GType rygel_http_server_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPServer, g_object_unref)
GType rygel_http_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPRequest, g_object_unref)
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaResource, g_object_unref)
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPSeekRequest, g_object_unref)
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelPlaySpeedRequest, g_object_unref)
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPResponseElement, g_object_unref)
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaContainer, g_object_unref)
GType rygel_media_item_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaItem, g_object_unref)
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaFileItem, g_object_unref)
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelAudioItem, g_object_unref)
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelThumbnail, rygel_icon_info_unref)
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelVideoItem, g_object_unref)
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void rygel_value_set_subtitle (GValue* value,
                               gpointer v_object);
void rygel_value_take_subtitle (GValue* value,
                                gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSubtitle, rygel_subtitle_unref)
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
RygelVideoItem* rygel_video_item_new (const gchar* id,
                                      RygelMediaContainer* parent,
                                      const gchar* title,
                                      const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type,
                                            const gchar* id,
                                            RygelMediaContainer* parent,
                                            const gchar* title,
                                            const gchar* upnp_class);
static void rygel_video_item_real_constructed (GObject* base);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self,
                                       GeeArrayList* value);
void rygel_video_item_set_subtitles (RygelVideoItem* self,
                                     GeeArrayList* value);
static void rygel_video_item_real_add_uri (RygelMediaObject* base,
                                    const gchar* uri);
void rygel_media_object_add_uri (RygelMediaObject* self,
                                 const gchar* uri);
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self,
                                              const gchar* uri);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSubtitleManager, g_object_unref)
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
GeeArrayList* rygel_subtitle_manager_get_subtitles (RygelSubtitleManager* self,
                                                    const gchar* uri,
                                                    GError** error);
GeeArrayList* rygel_video_item_get_subtitles (RygelVideoItem* self);
static RygelMediaResource* rygel_video_item_real_get_primary_resource (RygelMediaFileItem* base);
RygelMediaResource* rygel_media_file_item_get_primary_resource (RygelMediaFileItem* self);
void rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self,
                                                       RygelMediaResource* res);
static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base,
                                                RygelMediaObject* media_object,
                                                const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self,
                                              const gchar* prop1,
                                              const gchar* prop2);
const gchar* rygel_video_item_get_author (RygelVideoItem* self);
gint rygel_media_object_compare_by_property (RygelMediaObject* self,
                                             RygelMediaObject* media_object,
                                             const gchar* property);
static gchar* rygel_video_item_get_first (RygelVideoItem* self,
                                   GList* contributors);
static void rygel_video_item_real_apply_didl_lite (RygelMediaObject* base,
                                            GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self,
                                         GUPnPDIDLLiteObject* didl_object);
void rygel_video_item_set_author (RygelVideoItem* self,
                                  const gchar* value);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base,
                                                      RygelSerializer* serializer,
                                                      RygelHTTPServer* http_server,
                                                      GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self,
                                                   RygelSerializer* serializer,
                                                   RygelHTTPServer* http_server,
                                                   GError** error);
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self,
                                                const gchar* uri,
                                                GError** error);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self,
                                       const gchar* uri);
gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self,
                                                RygelMediaObject* object,
                                                gint thumbnail_index,
                                                gint subtitle_index,
                                                const gchar* resource_name);
void rygel_subtitle_add_didl_node (RygelSubtitle* self,
                                   GUPnPDIDLLiteItem* didl_item);
RygelSubtitle* rygel_subtitle_new (const gchar* mime_type,
                                   const gchar* caption_type);
RygelSubtitle* rygel_subtitle_construct (GType object_type,
                                         const gchar* mime_type,
                                         const gchar* caption_type);
gboolean rygel_http_server_is_local (RygelHTTPServer* self);
static void rygel_video_item_real_add_additional_resources (RygelMediaFileItem* base,
                                                     RygelHTTPServer* server);
void rygel_media_file_item_add_additional_resources (RygelMediaFileItem* self,
                                                     RygelHTTPServer* server);
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self,
                                                RygelHTTPServer* http_server);
static void rygel_video_item_finalize (GObject * obj);
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
static void _vala_rygel_video_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
void rygel_visual_item_set_width (RygelVisualItem* self,
                                  gint value);
void rygel_visual_item_set_height (RygelVisualItem* self,
                                   gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self,
                                        gint value);
static void _vala_rygel_video_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
rygel_video_item_get_instance_private (RygelVideoItem* self)
{
	return G_STRUCT_MEMBER_P (self, RygelVideoItem_private_offset);
}

RygelVideoItem*
rygel_video_item_construct (GType object_type,
                            const gchar* id,
                            RygelMediaContainer* parent,
                            const gchar* title,
                            const gchar* upnp_class)
{
	RygelVideoItem * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelVideoItem*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "upnp-class", upnp_class, NULL);
	return self;
}

RygelVideoItem*
rygel_video_item_new (const gchar* id,
                      RygelMediaContainer* parent,
                      const gchar* title,
                      const gchar* upnp_class)
{
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM, id, parent, title, upnp_class);
}

static void
rygel_video_item_real_constructed (GObject* base)
{
	RygelVideoItem * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	self = (RygelVideoItem*) base;
	G_OBJECT_CLASS (rygel_video_item_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem));
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, (GDestroyNotify) rygel_icon_info_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, (GDestroyNotify) rygel_subtitle_unref, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	rygel_video_item_set_subtitles (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

static void
rygel_video_item_real_add_uri (RygelMediaObject* base,
                               const gchar* uri)
{
	RygelVideoItem * self;
	RygelSubtitleManager* subtitle_manager = NULL;
	RygelSubtitleManager* _tmp0_;
	RygelSubtitleManager* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_if_fail (uri != NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->add_uri ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), uri);
	rygel_visual_item_add_thumbnail_for_uri ((RygelVisualItem*) self, uri);
	_tmp0_ = rygel_subtitle_manager_get_default ();
	subtitle_manager = _tmp0_;
	_tmp1_ = subtitle_manager;
	if (_tmp1_ != NULL) {
		{
			GeeArrayList* subtitles = NULL;
			RygelSubtitleManager* _tmp2_;
			GeeArrayList* _tmp3_;
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
			_tmp2_ = subtitle_manager;
			_tmp3_ = rygel_subtitle_manager_get_subtitles (_tmp2_, uri, &_inner_error0_);
			subtitles = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch5_g_error;
			}
			_tmp4_ = self->priv->_subtitles;
			_tmp5_ = subtitles;
			gee_array_list_add_all (_tmp4_, (GeeCollection*) _tmp5_);
			_g_object_unref0 (subtitles);
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* err = NULL;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_g_error_free0 (err);
		}
		__finally5:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (subtitle_manager);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (subtitle_manager);
}

static RygelMediaResource*
rygel_video_item_real_get_primary_resource (RygelMediaFileItem* base)
{
	RygelVideoItem * self;
	RygelMediaResource* result = NULL;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_video_item_parent_class)->get_primary_resource ((RygelMediaFileItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem));
	res = _tmp0_;
	rygel_visual_item_set_visual_resource_properties ((RygelVisualItem*) self, res);
	result = res;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
rygel_video_item_real_compare_by_property (RygelMediaObject* base,
                                           RygelMediaObject* media_object,
                                           const gchar* property)
{
	RygelVideoItem * self;
	gint result = 0;
	RygelVideoItem* item = NULL;
	RygelVideoItem* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	self = (RygelVideoItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (media_object, RYGEL_TYPE_VIDEO_ITEM)) {
		result = 1;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (media_object, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) media_object) : NULL);
	item = _tmp0_;
	_tmp1_ = property;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("upnp:author")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				RygelVideoItem* _tmp5_;
				const gchar* _tmp6_;
				_tmp4_ = self->priv->_author;
				_tmp5_ = item;
				_tmp6_ = _tmp5_->priv->_author;
				result = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp4_, _tmp6_);
				_g_object_unref0 (item);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				RygelVideoItem* _tmp7_;
				_tmp7_ = item;
				result = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), (RygelMediaObject*) _tmp7_, property);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	_g_object_unref0 (item);
}

static gchar*
rygel_video_item_get_first (RygelVideoItem* self,
                            GList* contributors)
{
	gchar* result = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	if (contributors != NULL) {
		gconstpointer _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = contributors->data;
		_tmp1_ = gupnp_didl_lite_contributor_get_name ((GUPnPDIDLLiteContributor*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup ("");
	result = _tmp4_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
rygel_video_item_real_apply_didl_lite (RygelMediaObject* base,
                                       GUPnPDIDLLiteObject* didl_object)
{
	RygelVideoItem * self;
	GList* _tmp0_;
	GList* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (RygelVideoItem*) base;
	g_return_if_fail (didl_object != NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), didl_object);
	_tmp0_ = gupnp_didl_lite_object_get_authors (didl_object);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_video_item_get_first (self, _tmp1_);
	_tmp3_ = _tmp2_;
	rygel_video_item_set_author (self, _tmp3_);
	_g_free0 (_tmp3_);
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (_g_list_free__g_object_unref0_ (_tmp1_), NULL));
}

static gpointer
_rygel_subtitle_ref0 (gpointer self)
{
	return self ? rygel_subtitle_ref (self) : NULL;
}

static GUPnPDIDLLiteObject*
rygel_video_item_real_serialize (RygelMediaObject* base,
                                 RygelSerializer* serializer,
                                 RygelHTTPServer* http_server,
                                 GError** error)
{
	RygelVideoItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_;
	GUPnPDIDLLiteItem* didl_item = NULL;
	GUPnPDIDLLiteItem* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GError* _inner_error0_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp1_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), serializer, http_server, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_didl_lite_item_get_type ()) ? ((GUPnPDIDLLiteItem*) _tmp0_) : NULL);
	didl_item = _tmp2_;
	_tmp4_ = self->priv->_author;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->_author;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GUPnPDIDLLiteContributor* contributor = NULL;
		GUPnPDIDLLiteItem* _tmp6_;
		GUPnPDIDLLiteContributor* _tmp7_;
		GUPnPDIDLLiteContributor* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = didl_item;
		_tmp7_ = gupnp_didl_lite_object_add_author ((GUPnPDIDLLiteObject*) _tmp6_);
		contributor = _tmp7_;
		_tmp8_ = contributor;
		_tmp9_ = self->priv->_author;
		gupnp_didl_lite_contributor_set_name (_tmp8_, _tmp9_);
		_g_object_unref0 (contributor);
	}
	_tmp10_ = rygel_media_file_item_get_place_holder ((RygelMediaFileItem*) self);
	_tmp11_ = _tmp10_;
	if (!_tmp11_) {
		RygelSubtitle* main_subtitle = NULL;
		gpointer _tmp12_;
		RygelSubtitle* _tmp13_;
		RygelSubtitle* _tmp59_;
		_tmp12_ = NULL;
		_tmp13_ = _rygel_subtitle_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_SUBTITLE) ? ((RygelSubtitle*) _tmp12_) : NULL);
		main_subtitle = _tmp13_;
		{
			GeeArrayList* _subtitle_list = NULL;
			GeeArrayList* _tmp14_;
			GeeArrayList* _tmp15_;
			gint _subtitle_size = 0;
			GeeArrayList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _subtitle_index = 0;
			_tmp14_ = self->priv->_subtitles;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_subtitle_list = _tmp15_;
			_tmp16_ = _subtitle_list;
			_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_subtitle_size = _tmp18_;
			_subtitle_index = -1;
			while (TRUE) {
				RygelSubtitle* subtitle = NULL;
				GeeArrayList* _tmp19_;
				gpointer _tmp20_;
				gchar* protocol = NULL;
				RygelSubtitle* _tmp28_;
				const gchar* _tmp29_;
				gboolean _tmp55_ = FALSE;
				_subtitle_index = _subtitle_index + 1;
				if (!(_subtitle_index < _subtitle_size)) {
					break;
				}
				_tmp19_ = _subtitle_list;
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _subtitle_index);
				subtitle = (RygelSubtitle*) _tmp20_;
				{
					gchar* _tmp21_ = NULL;
					RygelSubtitle* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp22_ = subtitle;
					_tmp23_ = _tmp22_->uri;
					_tmp24_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp23_, &_inner_error0_);
					_tmp21_ = _tmp24_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch6_g_error;
					}
					_tmp25_ = _tmp21_;
					_tmp21_ = NULL;
					_g_free0 (protocol);
					protocol = _tmp25_;
					_g_free0 (_tmp21_);
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					RygelSubtitle* _tmp26_;
					const gchar* _tmp27_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp26_ = subtitle;
					_tmp27_ = _tmp26_->uri;
					g_message ("rygel-video-item.vala:155: Could not determine protocol for URI %s", _tmp27_);
					_g_error_free0 (e);
					_g_free0 (protocol);
					_rygel_subtitle_unref0 (subtitle);
					continue;
				}
				__finally6:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (protocol);
					_rygel_subtitle_unref0 (subtitle);
					_g_object_unref0 (_subtitle_list);
					_rygel_subtitle_unref0 (main_subtitle);
					_g_object_unref0 (didl_item);
					_g_object_unref0 (_tmp0_);
					return NULL;
				}
				_tmp28_ = subtitle;
				_tmp29_ = _tmp28_->uri;
				if (rygel_http_server_need_proxy (http_server, _tmp29_)) {
					gchar* uri = NULL;
					RygelSubtitle* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gint index = 0;
					GeeArrayList* _tmp33_;
					RygelSubtitle* _tmp34_;
					RygelSubtitle* _tmp35_;
					gchar* _tmp36_;
					RygelSubtitle* _tmp37_;
					GUPnPDIDLLiteItem* _tmp38_;
					RygelSubtitle* _tmp39_;
					RygelSubtitle* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp30_ = subtitle;
					_tmp31_ = _tmp30_->uri;
					_tmp32_ = g_strdup (_tmp31_);
					uri = _tmp32_;
					_tmp33_ = self->priv->_subtitles;
					_tmp34_ = subtitle;
					index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp33_, _tmp34_);
					_tmp35_ = subtitle;
					_tmp36_ = rygel_http_server_create_uri_for_object (http_server, (RygelMediaObject*) self, -1, index, NULL);
					_g_free0 (_tmp35_->uri);
					_tmp35_->uri = _tmp36_;
					_tmp37_ = subtitle;
					_tmp38_ = didl_item;
					rygel_subtitle_add_didl_node (_tmp37_, _tmp38_);
					_tmp39_ = main_subtitle;
					if (_tmp39_ == NULL) {
						RygelSubtitle* _tmp40_;
						const gchar* _tmp41_;
						RygelSubtitle* _tmp42_;
						const gchar* _tmp43_;
						RygelSubtitle* _tmp44_;
						RygelSubtitle* _tmp45_;
						RygelSubtitle* _tmp46_;
						const gchar* _tmp47_;
						gchar* _tmp48_;
						_tmp40_ = subtitle;
						_tmp41_ = _tmp40_->mime_type;
						_tmp42_ = subtitle;
						_tmp43_ = _tmp42_->caption_type;
						_tmp44_ = rygel_subtitle_new (_tmp41_, _tmp43_);
						_rygel_subtitle_unref0 (main_subtitle);
						main_subtitle = _tmp44_;
						_tmp45_ = main_subtitle;
						_tmp46_ = subtitle;
						_tmp47_ = _tmp46_->uri;
						_tmp48_ = g_strdup (_tmp47_);
						_g_free0 (_tmp45_->uri);
						_tmp45_->uri = _tmp48_;
					}
					_tmp49_ = subtitle;
					_tmp50_ = uri;
					_tmp51_ = g_strdup (_tmp50_);
					_g_free0 (_tmp49_->uri);
					_tmp49_->uri = _tmp51_;
					_g_free0 (uri);
				} else {
					RygelSubtitle* _tmp52_;
					_tmp52_ = main_subtitle;
					if (_tmp52_ == NULL) {
						RygelSubtitle* _tmp53_;
						RygelSubtitle* _tmp54_;
						_tmp53_ = subtitle;
						_tmp54_ = _rygel_subtitle_ref0 (_tmp53_);
						_rygel_subtitle_unref0 (main_subtitle);
						main_subtitle = _tmp54_;
					}
				}
				if (rygel_http_server_is_local (http_server)) {
					_tmp55_ = TRUE;
				} else {
					const gchar* _tmp56_;
					_tmp56_ = protocol;
					_tmp55_ = g_strcmp0 (_tmp56_, "internal") != 0;
				}
				if (_tmp55_) {
					RygelSubtitle* _tmp57_;
					GUPnPDIDLLiteItem* _tmp58_;
					_tmp57_ = subtitle;
					_tmp58_ = didl_item;
					rygel_subtitle_add_didl_node (_tmp57_, _tmp58_);
				}
				_g_free0 (protocol);
				_rygel_subtitle_unref0 (subtitle);
			}
			_g_object_unref0 (_subtitle_list);
		}
		_tmp59_ = main_subtitle;
		if (_tmp59_ != NULL) {
			GList* resources = NULL;
			GUPnPDIDLLiteItem* _tmp60_;
			GList* _tmp61_;
			GList* _tmp62_;
			_tmp60_ = didl_item;
			_tmp61_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _tmp60_);
			resources = _tmp61_;
			_tmp62_ = resources;
			{
				GList* resource_collection = NULL;
				GList* resource_it = NULL;
				resource_collection = _tmp62_;
				for (resource_it = resource_collection; resource_it != NULL; resource_it = resource_it->next) {
					GUPnPDIDLLiteResource* _tmp63_;
					GUPnPDIDLLiteResource* resource = NULL;
					_tmp63_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) resource_it->data);
					resource = _tmp63_;
					{
						GUPnPDIDLLiteResource* _tmp64_;
						RygelSubtitle* _tmp65_;
						const gchar* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
						GUPnPDIDLLiteResource* _tmp69_;
						RygelSubtitle* _tmp70_;
						const gchar* _tmp71_;
						_tmp64_ = resource;
						_tmp65_ = main_subtitle;
						_tmp66_ = _tmp65_->caption_type;
						_tmp67_ = g_utf8_strup (_tmp66_, (gssize) -1);
						_tmp68_ = _tmp67_;
						gupnp_didl_lite_resource_set_subtitle_file_type (_tmp64_, _tmp68_);
						_g_free0 (_tmp68_);
						_tmp69_ = resource;
						_tmp70_ = main_subtitle;
						_tmp71_ = _tmp70_->uri;
						gupnp_didl_lite_resource_set_subtitle_file_uri (_tmp69_, _tmp71_);
						_g_object_unref0 (resource);
					}
				}
			}
			(resources == NULL) ? NULL : (resources = (_g_list_free__g_object_unref0_ (resources), NULL));
		}
		_rygel_subtitle_unref0 (main_subtitle);
	}
	result = (GUPnPDIDLLiteObject*) didl_item;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
rygel_video_item_real_add_additional_resources (RygelMediaFileItem* base,
                                                RygelHTTPServer* server)
{
	RygelVideoItem * self;
	self = (RygelVideoItem*) base;
	g_return_if_fail (server != NULL);
	RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_video_item_parent_class)->add_additional_resources ((RygelMediaFileItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), server);
	rygel_visual_item_add_thumbnail_resources ((RygelVisualItem*) self, server);
}

const gchar*
rygel_video_item_get_author (RygelVideoItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_author;
	result = _tmp0_;
	return result;
}

void
rygel_video_item_set_author (RygelVideoItem* self,
                             const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_video_item_get_author (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_author);
		self->priv->_author = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY]);
	}
}

static gint
rygel_video_item_real_get_width (RygelVisualItem* base)
{
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_width;
	return result;
}

static void
rygel_video_item_real_set_width (RygelVisualItem* base,
                                 gint value)
{
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	if (rygel_video_item_real_get_width (base) != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_WIDTH_PROPERTY]);
	}
}

static gint
rygel_video_item_real_get_height (RygelVisualItem* base)
{
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_height;
	return result;
}

static void
rygel_video_item_real_set_height (RygelVisualItem* base,
                                  gint value)
{
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	if (rygel_video_item_real_get_height (base) != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY]);
	}
}

static gint
rygel_video_item_real_get_color_depth (RygelVisualItem* base)
{
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_color_depth;
	return result;
}

static void
rygel_video_item_real_set_color_depth (RygelVisualItem* base,
                                       gint value)
{
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	if (rygel_video_item_real_get_color_depth (base) != value) {
		self->priv->_color_depth = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY]);
	}
}

static GeeArrayList*
rygel_video_item_real_get_thumbnails (RygelVisualItem* base)
{
	GeeArrayList* result;
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_thumbnails;
	result = _tmp0_;
	return result;
}

static void
rygel_video_item_real_set_thumbnails (RygelVisualItem* base,
                                      GeeArrayList* value)
{
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	if (rygel_video_item_real_get_thumbnails (base) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_thumbnails);
		self->priv->_thumbnails = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY]);
	}
}

GeeArrayList*
rygel_video_item_get_subtitles (RygelVideoItem* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subtitles;
	result = _tmp0_;
	return result;
}

void
rygel_video_item_set_subtitles (RygelVideoItem* self,
                                GeeArrayList* value)
{
	g_return_if_fail (self != NULL);
	if (rygel_video_item_get_subtitles (self) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_subtitles);
		self->priv->_subtitles = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY]);
	}
}

static void
rygel_video_item_class_init (RygelVideoItemClass * klass,
                             gpointer klass_data)
{
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelVideoItem_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_video_item_real_constructed;
	((RygelMediaObjectClass *) klass)->add_uri = (void (*) (RygelMediaObject*, const gchar*)) rygel_video_item_real_add_uri;
	((RygelMediaFileItemClass *) klass)->get_primary_resource = (RygelMediaResource* (*) (RygelMediaFileItem*)) rygel_video_item_real_get_primary_resource;
	((RygelMediaObjectClass *) klass)->compare_by_property = (gint (*) (RygelMediaObject*, RygelMediaObject*, const gchar*)) rygel_video_item_real_compare_by_property;
	((RygelMediaObjectClass *) klass)->apply_didl_lite = (void (*) (RygelMediaObject*, GUPnPDIDLLiteObject*)) rygel_video_item_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject*, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_video_item_real_serialize;
	((RygelMediaFileItemClass *) klass)->add_additional_resources = (void (*) (RygelMediaFileItem*, RygelHTTPServer*)) rygel_video_item_real_add_additional_resources;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_video_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_video_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY] = g_param_spec_string ("author", "author", "author", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The width of the item source content (this.uri) in pixels
	     * A value of -1 means that the width is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_WIDTH_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The height of the item source content (this.uri) in pixels
	     * A value of -1 means that the height is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The number of bits per pixel in the source video resource (this.uri)
	     * A value of -1 means that the color depth is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY] = g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Thumbnail pictures to represent the video.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY] = g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY] = g_param_spec_object ("subtitles", "subtitles", "subtitles", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface,
                                                   gpointer iface_data)
{
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_width = rygel_video_item_real_get_width;
	iface->set_width = rygel_video_item_real_set_width;
	iface->get_height = rygel_video_item_real_get_height;
	iface->set_height = rygel_video_item_real_set_height;
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
}

static void
rygel_video_item_instance_init (RygelVideoItem * self,
                                gpointer klass)
{
	self->priv = rygel_video_item_get_instance_private (self);
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_color_depth = -1;
}

static void
rygel_video_item_finalize (GObject * obj)
{
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
	_g_free0 (self->priv->_author);
	_g_object_unref0 (self->priv->_thumbnails);
	_g_object_unref0 (self->priv->_subtitles);
	G_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
}

/**
 * Represents a video item.
 */
GType
rygel_video_item_get_type (void)
{
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		RygelVideoItem_private_offset = g_type_add_instance_private (rygel_video_item_type_id, sizeof (RygelVideoItemPrivate));
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}

static void
_vala_rygel_video_item_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
	switch (property_id) {
		case RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY:
		g_value_set_string (value, rygel_video_item_get_author (self));
		break;
		case RYGEL_VIDEO_ITEM_WIDTH_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_width ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_height ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_color_depth ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY:
		g_value_set_object (value, rygel_visual_item_get_thumbnails ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY:
		g_value_set_object (value, rygel_video_item_get_subtitles (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_video_item_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
	switch (property_id) {
		case RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY:
		rygel_video_item_set_author (self, g_value_get_string (value));
		break;
		case RYGEL_VIDEO_ITEM_WIDTH_PROPERTY:
		rygel_visual_item_set_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY:
		rygel_visual_item_set_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY:
		rygel_visual_item_set_color_depth ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY:
		rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, g_value_get_object (value));
		break;
		case RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY:
		rygel_video_item_set_subtitles (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

