/* rygel-media-export-recursive-file-monitor.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-media-export-recursive-file-monitor.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
typedef struct _RygelMediaExportRecursiveFileMonitorPrivate RygelMediaExportRecursiveFileMonitorPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_recursive_file_monitor_properties[RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportRecursiveFileMonitorAddData RygelMediaExportRecursiveFileMonitorAddData;
enum  {
	RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CHANGED_SIGNAL,
	RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_NUM_SIGNALS
};
static guint rygel_media_export_recursive_file_monitor_signals[RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_NUM_SIGNALS] = {0};

struct _RygelMediaExportRecursiveFileMonitor {
	GObject parent_instance;
	RygelMediaExportRecursiveFileMonitorPrivate * priv;
};

struct _RygelMediaExportRecursiveFileMonitorClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportRecursiveFileMonitorPrivate {
	GCancellable* cancellable;
	GeeHashMap* monitors;
	gboolean monitor_changes;
};

struct _RygelMediaExportRecursiveFileMonitorAddData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportRecursiveFileMonitor* self;
	GFile* file;
	GeeHashMap* _tmp0_;
	GFileInfo* info;
	GFileInfo* _tmp1_;
	GFileInfo* _tmp2_;
	GFileMonitor* file_monitor;
	GCancellable* _tmp3_;
	GFileMonitor* _tmp4_;
	GeeHashMap* _tmp5_;
	GFileMonitor* _tmp6_;
	GFileMonitor* _tmp7_;
	GError* err;
	GError* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _inner_error0_;
};

static gint RygelMediaExportRecursiveFileMonitor_private_offset;
static gpointer rygel_media_export_recursive_file_monitor_parent_class = NULL;

GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportRecursiveFileMonitor, g_object_unref)
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type,
                                                                                           GCancellable* cancellable);
static void rygel_media_export_recursive_file_monitor_on_config_changed (RygelMediaExportRecursiveFileMonitor* self,
                                                                  RygelConfiguration* config,
                                                                  const gchar* section,
                                                                  const gchar* key);
static void _rygel_media_export_recursive_file_monitor_on_config_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                                                                       const gchar* section,
                                                                                                       const gchar* key,
                                                                                                       gpointer self);
#define RYGEL_MEDIA_EXPORT_PLUGIN_NAME "MediaExport"
void rygel_media_export_recursive_file_monitor_cancel (RygelMediaExportRecursiveFileMonitor* self);
static void _rygel_media_export_recursive_file_monitor_cancel_g_cancellable_cancelled (GCancellable* _sender,
                                                                                gpointer self);
void rygel_media_export_recursive_file_monitor_on_monitor_changed (RygelMediaExportRecursiveFileMonitor* self,
                                                                   GFile* file,
                                                                   GFile* other_file,
                                                                   GFileMonitorEvent event_type);
void rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self,
                                                    GFile* file,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self,
                                                           GAsyncResult* _res_);
static void _rygel_media_export_recursive_file_monitor_on_monitor_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                           GFile* file,
                                                                                           GFile* other_file,
                                                                                           GFileMonitorEvent event_type,
                                                                                           gpointer self);
static void rygel_media_export_recursive_file_monitor_add_data_free (gpointer _data);
static gboolean rygel_media_export_recursive_file_monitor_add_co (RygelMediaExportRecursiveFileMonitorAddData* _data_);
static void rygel_media_export_recursive_file_monitor_add_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static void rygel_media_export_recursive_file_monitor_finalize (GObject * obj);

static inline gpointer
rygel_media_export_recursive_file_monitor_get_instance_private (RygelMediaExportRecursiveFileMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportRecursiveFileMonitor_private_offset);
}

static void
_rygel_media_export_recursive_file_monitor_on_config_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                                                                  const gchar* section,
                                                                                                  const gchar* key,
                                                                                                  gpointer self)
{
	rygel_media_export_recursive_file_monitor_on_config_changed ((RygelMediaExportRecursiveFileMonitor*) self, _sender, section, key);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_rygel_media_export_recursive_file_monitor_cancel_g_cancellable_cancelled (GCancellable* _sender,
                                                                           gpointer self)
{
	rygel_media_export_recursive_file_monitor_cancel ((RygelMediaExportRecursiveFileMonitor*) self);
}

RygelMediaExportRecursiveFileMonitor*
rygel_media_export_recursive_file_monitor_construct (GType object_type,
                                                     GCancellable* cancellable)
{
	RygelMediaExportRecursiveFileMonitor * self = NULL;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp0_;
	RygelMetaConfig* _tmp1_;
	RygelMetaConfig* _tmp2_;
	GCancellable* _tmp3_;
	GeeHashMap* _tmp4_;
	self = (RygelMediaExportRecursiveFileMonitor*) g_object_new (object_type, NULL);
	self->priv->monitor_changes = TRUE;
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	_tmp1_ = config;
	g_signal_connect_object ((RygelConfiguration*) _tmp1_, "setting-changed", (GCallback) _rygel_media_export_recursive_file_monitor_on_config_changed_rygel_configuration_setting_changed, self, 0);
	_tmp2_ = config;
	rygel_media_export_recursive_file_monitor_on_config_changed (self, (RygelConfiguration*) _tmp2_, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "monitor-changes");
	if (!self->priv->monitor_changes) {
		g_message ("rygel-media-export-recursive-file-monitor.vala:36: %s", _ ("Will not monitor file changes"));
	}
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp3_;
	_tmp4_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->monitors);
	self->priv->monitors = _tmp4_;
	if (cancellable != NULL) {
		g_signal_connect_object (cancellable, "cancelled", (GCallback) _rygel_media_export_recursive_file_monitor_cancel_g_cancellable_cancelled, self, 0);
	}
	_g_object_unref0 (config);
	return self;
}

RygelMediaExportRecursiveFileMonitor*
rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable)
{
	return rygel_media_export_recursive_file_monitor_construct (RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, cancellable);
}

static void
_rygel_media_export_recursive_file_monitor_on_monitor_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                      GFile* file,
                                                                                      GFile* other_file,
                                                                                      GFileMonitorEvent event_type,
                                                                                      gpointer self)
{
	rygel_media_export_recursive_file_monitor_on_monitor_changed ((RygelMediaExportRecursiveFileMonitor*) self, file, other_file, event_type);
}

void
rygel_media_export_recursive_file_monitor_on_monitor_changed (RygelMediaExportRecursiveFileMonitor* self,
                                                              GFile* file,
                                                              GFile* other_file,
                                                              GFileMonitorEvent event_type)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (self->priv->monitor_changes) {
		g_signal_emit (self, rygel_media_export_recursive_file_monitor_signals[RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CHANGED_SIGNAL], 0, file, other_file, event_type);
	}
	switch (event_type) {
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			rygel_media_export_recursive_file_monitor_add (self, file, NULL, NULL);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			GFileMonitor* file_monitor = NULL;
			GeeHashMap* _tmp0_;
			gpointer _tmp1_;
			GFileMonitor* _tmp2_;
			_tmp0_ = self->priv->monitors;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, file);
			file_monitor = (GFileMonitor*) _tmp1_;
			_tmp2_ = file_monitor;
			if (_tmp2_ != NULL) {
				gchar* _tmp3_;
				gchar* _tmp4_;
				GeeHashMap* _tmp5_;
				GFileMonitor* _tmp6_;
				GFileMonitor* _tmp7_;
				guint _tmp8_;
				_tmp3_ = g_file_get_uri (file);
				_tmp4_ = _tmp3_;
				g_debug ("rygel-media-export-recursive-file-monitor.vala:62: Folder %s gone; rem" \
"oving watch", _tmp4_);
				_g_free0 (_tmp4_);
				_tmp5_ = self->priv->monitors;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, file, NULL);
				_tmp6_ = file_monitor;
				g_file_monitor_cancel (_tmp6_);
				_tmp7_ = file_monitor;
				g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp8_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _rygel_media_export_recursive_file_monitor_on_monitor_changed_g_file_monitor_changed, self);
			}
			_g_object_unref0 (file_monitor);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
rygel_media_export_recursive_file_monitor_add_data_free (gpointer _data)
{
	RygelMediaExportRecursiveFileMonitorAddData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportRecursiveFileMonitorAddData, _data_);
}

void
rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self,
                                               GFile* file,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	RygelMediaExportRecursiveFileMonitorAddData* _data_;
	RygelMediaExportRecursiveFileMonitor* _tmp0_;
	GFile* _tmp1_;
	_data_ = g_slice_new0 (RygelMediaExportRecursiveFileMonitorAddData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_recursive_file_monitor_add_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	rygel_media_export_recursive_file_monitor_add_co (_data_);
}

void
rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self,
                                                      GAsyncResult* _res_)
{
	RygelMediaExportRecursiveFileMonitorAddData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_media_export_recursive_file_monitor_add_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	RygelMediaExportRecursiveFileMonitorAddData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_recursive_file_monitor_add_co (_data_);
}

static gboolean
rygel_media_export_recursive_file_monitor_add_co (RygelMediaExportRecursiveFileMonitorAddData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->monitors;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp0_, _data_->file)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rygel_media_export_recursive_file_monitor_add_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		_data_->info = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch50_g_error;
		}
		_data_->_tmp2_ = _data_->info;
		if (g_file_info_get_file_type (_data_->_tmp2_) != G_FILE_TYPE_DIRECTORY) {
			_g_object_unref0 (_data_->info);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp3_ = _data_->self->priv->cancellable;
		_data_->_tmp4_ = g_file_monitor_directory (_data_->file, G_FILE_MONITOR_NONE, _data_->_tmp3_, &_data_->_inner_error0_);
		_data_->file_monitor = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->info);
			goto __catch50_g_error;
		}
		_data_->_tmp5_ = _data_->self->priv->monitors;
		_data_->_tmp6_ = _data_->file_monitor;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp5_, _data_->file, _data_->_tmp6_);
		_data_->_tmp7_ = _data_->file_monitor;
		g_signal_connect_object (_data_->_tmp7_, "changed", (GCallback) _rygel_media_export_recursive_file_monitor_on_monitor_changed_g_file_monitor_changed, _data_->self, 0);
		_g_object_unref0 (_data_->file_monitor);
		_g_object_unref0 (_data_->info);
	}
	goto __finally50;
	__catch50_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->err;
		if (g_error_matches (_data_->_tmp8_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp9_ = g_file_get_uri (_data_->file);
			_data_->_tmp10_ = _data_->_tmp9_;
			g_debug ("rygel-media-export-recursive-file-monitor.vala:97: File %s disappeared" \
" while trying to get information", _data_->_tmp10_);
			_g_free0 (_data_->_tmp10_);
		} else {
			_data_->_tmp11_ = _data_->err;
			if (g_error_matches (_data_->_tmp11_, G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED)) {
				_data_->_tmp12_ = g_file_get_uri (_data_->file);
				_data_->_tmp13_ = _data_->_tmp12_;
				g_debug ("rygel-media-export-recursive-file-monitor.vala:100: File monitoring is" \
" not supported for %s", _data_->_tmp13_);
				_g_free0 (_data_->_tmp13_);
			} else {
				_data_->_tmp14_ = g_file_get_uri (_data_->file);
				_data_->_tmp15_ = _data_->_tmp14_;
				_data_->_tmp16_ = _data_->err;
				_data_->_tmp17_ = _data_->_tmp16_->message;
				g_warning (_ ("Failed to setup up file monitor for %s: %s"), _data_->_tmp15_, _data_->_tmp17_);
				_g_free0 (_data_->_tmp15_);
			}
		}
		_g_error_free0 (_data_->err);
	}
	__finally50:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_media_export_recursive_file_monitor_cancel (RygelMediaExportRecursiveFileMonitor* self)
{
	GeeHashMap* _tmp10_;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _monitor_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->monitors;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_monitor_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GFileMonitor* monitor = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GFileMonitor* _tmp9_;
			_tmp6_ = _monitor_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _monitor_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			monitor = (GFileMonitor*) _tmp8_;
			_tmp9_ = monitor;
			g_file_monitor_cancel (_tmp9_);
			_g_object_unref0 (monitor);
		}
		_g_object_unref0 (_monitor_it);
	}
	_tmp10_ = self->priv->monitors;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp10_);
}

static void
rygel_media_export_recursive_file_monitor_on_config_changed (RygelMediaExportRecursiveFileMonitor* self,
                                                             RygelConfiguration* config,
                                                             const gchar* section,
                                                             const gchar* key)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (section, RYGEL_MEDIA_EXPORT_PLUGIN_NAME) != 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, "monitor-changes") != 0;
	}
	if (_tmp0_) {
		return;
	}
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = rygel_configuration_get_bool (config, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "monitor-changes", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch51_g_error;
		}
		self->priv->monitor_changes = _tmp1_;
	}
	goto __finally51;
	__catch51_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally51:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_enum (param_values + 3), data2);
}

static void
rygel_media_export_recursive_file_monitor_class_init (RygelMediaExportRecursiveFileMonitorClass * klass,
                                                      gpointer klass_data)
{
	rygel_media_export_recursive_file_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportRecursiveFileMonitor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_recursive_file_monitor_finalize;
	rygel_media_export_recursive_file_monitor_signals[RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CHANGED_SIGNAL] = g_signal_new ("changed", RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_monitor_event_get_type ());
}

static void
rygel_media_export_recursive_file_monitor_instance_init (RygelMediaExportRecursiveFileMonitor * self,
                                                         gpointer klass)
{
	self->priv = rygel_media_export_recursive_file_monitor_get_instance_private (self);
}

static void
rygel_media_export_recursive_file_monitor_finalize (GObject * obj)
{
	RygelMediaExportRecursiveFileMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->monitors);
	G_OBJECT_CLASS (rygel_media_export_recursive_file_monitor_parent_class)->finalize (obj);
}

GType
rygel_media_export_recursive_file_monitor_get_type (void)
{
	static volatile gsize rygel_media_export_recursive_file_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_recursive_file_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportRecursiveFileMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_recursive_file_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportRecursiveFileMonitor), 0, (GInstanceInitFunc) rygel_media_export_recursive_file_monitor_instance_init, NULL };
		GType rygel_media_export_recursive_file_monitor_type_id;
		rygel_media_export_recursive_file_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportRecursiveFileMonitor", &g_define_type_info, 0);
		RygelMediaExportRecursiveFileMonitor_private_offset = g_type_add_instance_private (rygel_media_export_recursive_file_monitor_type_id, sizeof (RygelMediaExportRecursiveFileMonitorPrivate));
		g_once_init_leave (&rygel_media_export_recursive_file_monitor_type_id__volatile, rygel_media_export_recursive_file_monitor_type_id);
	}
	return rygel_media_export_recursive_file_monitor_type_id__volatile;
}

