/* valaunaryexpression.c generated by valac, the Vala compiler
 * generated from valaunaryexpression.vala, do not modify */

/* valaunaryexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaUnaryExpressionPrivate {
	ValaUnaryOperator _operator;
	ValaExpression* _inner;
};


static gint ValaUnaryExpression_private_offset;
static gpointer vala_unary_expression_parent_class = NULL;

static void vala_unary_expression_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static void vala_unary_expression_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_unary_expression_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static const gchar* vala_unary_expression_get_operator_string (ValaUnaryExpression* self);
static gchar* vala_unary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_unary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_unary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_unary_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gboolean vala_unary_expression_is_numeric_type (ValaUnaryExpression* self,
                                                ValaDataType* type);
static gboolean vala_unary_expression_is_integer_type (ValaUnaryExpression* self,
                                                ValaDataType* type);
static ValaMemberAccess* vala_unary_expression_find_member_access (ValaUnaryExpression* self,
                                                            ValaExpression* expr);
static gboolean vala_unary_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_unary_expression_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_unary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                       ValaCollection* collection);
static void vala_unary_expression_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_unary_expression_finalize (ValaCodeNode * obj);


static inline gpointer
vala_unary_expression_get_instance_private (ValaUnaryExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaUnaryExpression_private_offset);
}


/**
 * Creates a new unary expression.
 *
 * @param op     unary operator
 * @param _inner operand
 * @param source reference to source code
 * @return       newly created binary expression
 */
ValaUnaryExpression*
vala_unary_expression_construct (GType object_type,
                                 ValaUnaryOperator op,
                                 ValaExpression* _inner,
                                 ValaSourceReference* source)
{
	ValaUnaryExpression* self = NULL;
	g_return_val_if_fail (_inner != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaUnaryExpression*) vala_expression_construct (object_type);
	vala_unary_expression_set_operator (self, op);
	vala_unary_expression_set_inner (self, _inner);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaUnaryExpression*
vala_unary_expression_new (ValaUnaryOperator op,
                           ValaExpression* _inner,
                           ValaSourceReference* source)
{
	return vala_unary_expression_construct (VALA_TYPE_UNARY_EXPRESSION, op, _inner, source);
}


static void
vala_unary_expression_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaUnaryExpression * self;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_unary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_unary_expression_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
}


static void
vala_unary_expression_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_unary_expression_set_inner (self, new_node);
	}
}


static const gchar*
vala_unary_expression_get_operator_string (ValaUnaryExpression* self)
{
	const gchar* result = NULL;
	ValaUnaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operator;
	switch (_tmp0_) {
		case VALA_UNARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_UNARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			result = "!";
			return result;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			result = "~";
			return result;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		{
			result = "++";
			return result;
		}
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			result = "--";
			return result;
		}
		case VALA_UNARY_OPERATOR_REF:
		{
			result = "ref ";
			return result;
		}
		case VALA_UNARY_OPERATOR_OUT:
		{
			result = "out ";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gchar*
vala_unary_expression_real_to_string (ValaCodeNode* base)
{
	ValaUnaryExpression * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (ValaUnaryExpression*) base;
	_tmp0_ = vala_unary_expression_get_operator_string (self);
	_tmp1_ = self->priv->_inner;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp0_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_unary_expression_real_is_constant (ValaExpression* base)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	gboolean _tmp3_ = FALSE;
	ValaUnaryOperator _tmp4_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_operator;
	if (_tmp4_ == VALA_UNARY_OPERATOR_REF) {
		_tmp3_ = TRUE;
	} else {
		ValaUnaryOperator _tmp5_;
		_tmp5_ = self->priv->_operator;
		_tmp3_ = _tmp5_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp3_) {
		ValaField* field = NULL;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaField* _tmp10_;
		gboolean _tmp11_ = FALSE;
		ValaField* _tmp12_;
		_tmp6_ = vala_unary_expression_get_inner (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_symbol_reference (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp9_) : NULL);
		field = _tmp10_;
		_tmp12_ = field;
		if (_tmp12_ != NULL) {
			ValaField* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp13_ = field;
			_tmp14_ = vala_field_get_binding (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			result = TRUE;
			_vala_code_node_unref0 (field);
			return result;
		} else {
			result = FALSE;
			_vala_code_node_unref0 (field);
			return result;
		}
		_vala_code_node_unref0 (field);
	}
	_tmp16_ = vala_unary_expression_get_inner (self);
	_tmp17_ = _tmp16_;
	result = vala_expression_is_constant (_tmp17_);
	return result;
}


static gboolean
vala_unary_expression_real_is_pure (ValaExpression* base)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = vala_unary_expression_get_inner (self);
	_tmp4_ = _tmp3_;
	result = vala_expression_is_pure (_tmp4_);
	return result;
}


static gboolean
vala_unary_expression_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_accessible (_tmp1_, sym);
	return result;
}


static gboolean
vala_unary_expression_is_numeric_type (ValaUnaryExpression* self,
                                       ValaDataType* type)
{
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaStruct* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaStruct* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_data_type (type);
	_tmp1_ = _tmp0_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_STRUCT)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_data_type_get_data_type (type);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_STRUCT, ValaStruct));
	st = _tmp4_;
	_tmp6_ = st;
	if (vala_struct_is_integer_type (_tmp6_)) {
		_tmp5_ = TRUE;
	} else {
		ValaStruct* _tmp7_;
		_tmp7_ = st;
		_tmp5_ = vala_struct_is_floating_type (_tmp7_);
	}
	result = _tmp5_;
	_vala_code_node_unref0 (st);
	return result;
}


static gboolean
vala_unary_expression_is_integer_type (ValaUnaryExpression* self,
                                       ValaDataType* type)
{
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaStruct* _tmp4_;
	ValaStruct* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_data_type (type);
	_tmp1_ = _tmp0_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_STRUCT)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_data_type_get_data_type (type);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_STRUCT, ValaStruct));
	st = _tmp4_;
	_tmp5_ = st;
	result = vala_struct_is_integer_type (_tmp5_);
	_vala_code_node_unref0 (st);
	return result;
}


static ValaMemberAccess*
vala_unary_expression_find_member_access (ValaUnaryExpression* self,
                                          ValaExpression* expr)
{
	ValaMemberAccess* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (expr, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* _tmp0_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (expr, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		result = _tmp0_;
		return result;
	}
	result = NULL;
	return result;
}


static gboolean
vala_unary_expression_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaUnaryOperator _tmp5_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaExpression* _tmp20_;
	ValaExpression* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gboolean _tmp36_ = FALSE;
	ValaUnaryOperator _tmp37_;
	gboolean _tmp197_;
	gboolean _tmp198_;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_operator;
	if (_tmp5_ == VALA_UNARY_OPERATOR_REF) {
		_tmp4_ = TRUE;
	} else {
		ValaUnaryOperator _tmp6_;
		_tmp6_ = self->priv->_operator;
		_tmp4_ = _tmp6_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp4_) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp7_ = vala_unary_expression_get_inner (self);
		_tmp8_ = _tmp7_;
		vala_expression_set_lvalue (_tmp8_, TRUE);
		_tmp9_ = vala_unary_expression_get_inner (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		vala_expression_set_target_type (_tmp10_, _tmp12_);
	} else {
		gboolean _tmp13_ = FALSE;
		ValaUnaryOperator _tmp14_;
		_tmp14_ = self->priv->_operator;
		if (_tmp14_ == VALA_UNARY_OPERATOR_INCREMENT) {
			_tmp13_ = TRUE;
		} else {
			ValaUnaryOperator _tmp15_;
			_tmp15_ = self->priv->_operator;
			_tmp13_ = _tmp15_ == VALA_UNARY_OPERATOR_DECREMENT;
		}
		if (_tmp13_) {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			_tmp16_ = vala_unary_expression_get_inner (self);
			_tmp17_ = _tmp16_;
			vala_expression_set_lvalue (_tmp17_, TRUE);
		}
	}
	_tmp18_ = vala_unary_expression_get_inner (self);
	_tmp19_ = _tmp18_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp19_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp20_ = vala_unary_expression_get_inner (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_expression_get_value_type (_tmp21_);
	_tmp23_ = _tmp22_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_FIELD_PROTOTYPE)) {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp24_ = vala_unary_expression_get_inner (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_unary_expression_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_full_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp33_);
		_tmp35_ = _tmp34_;
		vala_report_error (_tmp27_, _tmp35_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
		result = FALSE;
		return result;
	}
	_tmp37_ = self->priv->_operator;
	if (_tmp37_ == VALA_UNARY_OPERATOR_PLUS) {
		_tmp36_ = TRUE;
	} else {
		ValaUnaryOperator _tmp38_;
		_tmp38_ = self->priv->_operator;
		_tmp36_ = _tmp38_ == VALA_UNARY_OPERATOR_MINUS;
	}
	if (_tmp36_) {
		ValaExpression* _tmp39_;
		ValaExpression* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		_tmp39_ = vala_unary_expression_get_inner (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_expression_get_value_type (_tmp40_);
		_tmp42_ = _tmp41_;
		if (!vala_unary_expression_is_numeric_type (self, _tmp42_)) {
			ValaSourceReference* _tmp43_;
			ValaSourceReference* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_unary_expression_get_inner (self);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_code_node_to_string ((ValaCodeNode*) _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strdup_printf ("Operator not supported for `%s'", _tmp50_);
			_tmp52_ = _tmp51_;
			vala_report_error (_tmp44_, _tmp52_);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp50_);
			result = FALSE;
			return result;
		}
		_tmp53_ = vala_unary_expression_get_inner (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_expression_get_value_type (_tmp54_);
		_tmp56_ = _tmp55_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp56_);
	} else {
		ValaUnaryOperator _tmp57_;
		_tmp57_ = self->priv->_operator;
		if (_tmp57_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
			ValaExpression* _tmp58_;
			ValaExpression* _tmp59_;
			ValaDataType* _tmp60_;
			ValaDataType* _tmp61_;
			ValaSemanticAnalyzer* _tmp62_;
			ValaSemanticAnalyzer* _tmp63_;
			ValaDataType* _tmp64_;
			ValaExpression* _tmp75_;
			ValaExpression* _tmp76_;
			ValaDataType* _tmp77_;
			ValaDataType* _tmp78_;
			_tmp58_ = vala_unary_expression_get_inner (self);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_expression_get_value_type (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_context_get_analyzer (context);
			_tmp63_ = _tmp62_;
			_tmp64_ = _tmp63_->bool_type;
			if (!vala_data_type_compatible (_tmp61_, _tmp64_)) {
				ValaSourceReference* _tmp65_;
				ValaSourceReference* _tmp66_;
				ValaExpression* _tmp67_;
				ValaExpression* _tmp68_;
				ValaDataType* _tmp69_;
				ValaDataType* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp66_ = _tmp65_;
				_tmp67_ = vala_unary_expression_get_inner (self);
				_tmp68_ = _tmp67_;
				_tmp69_ = vala_expression_get_value_type (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_code_node_to_string ((ValaCodeNode*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = g_strdup_printf ("Operator not supported for `%s'", _tmp72_);
				_tmp74_ = _tmp73_;
				vala_report_error (_tmp66_, _tmp74_);
				_g_free0 (_tmp74_);
				_g_free0 (_tmp72_);
				result = FALSE;
				return result;
			}
			_tmp75_ = vala_unary_expression_get_inner (self);
			_tmp76_ = _tmp75_;
			_tmp77_ = vala_expression_get_value_type (_tmp76_);
			_tmp78_ = _tmp77_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp78_);
		} else {
			ValaUnaryOperator _tmp79_;
			_tmp79_ = self->priv->_operator;
			if (_tmp79_ == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
				gboolean _tmp80_ = FALSE;
				ValaExpression* _tmp81_;
				ValaExpression* _tmp82_;
				ValaDataType* _tmp83_;
				ValaDataType* _tmp84_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaDataType* _tmp101_;
				ValaDataType* _tmp102_;
				_tmp81_ = vala_unary_expression_get_inner (self);
				_tmp82_ = _tmp81_;
				_tmp83_ = vala_expression_get_value_type (_tmp82_);
				_tmp84_ = _tmp83_;
				if (!vala_unary_expression_is_integer_type (self, _tmp84_)) {
					ValaExpression* _tmp85_;
					ValaExpression* _tmp86_;
					ValaDataType* _tmp87_;
					ValaDataType* _tmp88_;
					_tmp85_ = vala_unary_expression_get_inner (self);
					_tmp86_ = _tmp85_;
					_tmp87_ = vala_expression_get_value_type (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp80_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, VALA_TYPE_ENUM_VALUE_TYPE);
				} else {
					_tmp80_ = FALSE;
				}
				if (_tmp80_) {
					ValaSourceReference* _tmp89_;
					ValaSourceReference* _tmp90_;
					ValaExpression* _tmp91_;
					ValaExpression* _tmp92_;
					ValaDataType* _tmp93_;
					ValaDataType* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					gchar* _tmp97_;
					gchar* _tmp98_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp90_ = _tmp89_;
					_tmp91_ = vala_unary_expression_get_inner (self);
					_tmp92_ = _tmp91_;
					_tmp93_ = vala_expression_get_value_type (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = vala_code_node_to_string ((ValaCodeNode*) _tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = g_strdup_printf ("Operator not supported for `%s'", _tmp96_);
					_tmp98_ = _tmp97_;
					vala_report_error (_tmp90_, _tmp98_);
					_g_free0 (_tmp98_);
					_g_free0 (_tmp96_);
					result = FALSE;
					return result;
				}
				_tmp99_ = vala_unary_expression_get_inner (self);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_value_type (_tmp100_);
				_tmp102_ = _tmp101_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp102_);
			} else {
				gboolean _tmp103_ = FALSE;
				ValaUnaryOperator _tmp104_;
				_tmp104_ = self->priv->_operator;
				if (_tmp104_ == VALA_UNARY_OPERATOR_INCREMENT) {
					_tmp103_ = TRUE;
				} else {
					ValaUnaryOperator _tmp105_;
					_tmp105_ = self->priv->_operator;
					_tmp103_ = _tmp105_ == VALA_UNARY_OPERATOR_DECREMENT;
				}
				if (_tmp103_) {
					ValaExpression* _tmp106_;
					ValaExpression* _tmp107_;
					ValaDataType* _tmp108_;
					ValaDataType* _tmp109_;
					ValaMemberAccess* ma = NULL;
					ValaExpression* _tmp120_;
					ValaExpression* _tmp121_;
					ValaMemberAccess* _tmp122_;
					ValaMemberAccess* _tmp123_;
					ValaMemberAccess* old_value = NULL;
					ValaMemberAccess* _tmp126_;
					ValaExpression* _tmp127_;
					ValaExpression* _tmp128_;
					ValaMemberAccess* _tmp129_;
					const gchar* _tmp130_;
					const gchar* _tmp131_;
					ValaExpression* _tmp132_;
					ValaExpression* _tmp133_;
					ValaSourceReference* _tmp134_;
					ValaSourceReference* _tmp135_;
					ValaMemberAccess* _tmp136_;
					ValaBinaryOperator _tmp137_ = 0;
					ValaUnaryOperator _tmp138_;
					ValaBinaryExpression* bin = NULL;
					ValaMemberAccess* _tmp139_;
					ValaIntegerLiteral* _tmp140_;
					ValaIntegerLiteral* _tmp141_;
					ValaSourceReference* _tmp142_;
					ValaSourceReference* _tmp143_;
					ValaBinaryExpression* _tmp144_;
					ValaBinaryExpression* _tmp145_;
					ValaAssignment* assignment = NULL;
					ValaMemberAccess* _tmp146_;
					ValaBinaryExpression* _tmp147_;
					ValaSourceReference* _tmp148_;
					ValaSourceReference* _tmp149_;
					ValaAssignment* _tmp150_;
					ValaAssignment* _tmp151_;
					ValaDataType* _tmp152_;
					ValaDataType* _tmp153_;
					ValaSemanticAnalyzer* _tmp154_;
					ValaSemanticAnalyzer* _tmp155_;
					ValaList* _tmp156_;
					ValaCodeNode* _tmp157_;
					ValaCodeNode* _tmp158_;
					ValaAssignment* _tmp159_;
					ValaAssignment* _tmp160_;
					_tmp106_ = vala_unary_expression_get_inner (self);
					_tmp107_ = _tmp106_;
					_tmp108_ = vala_expression_get_value_type (_tmp107_);
					_tmp109_ = _tmp108_;
					if (!vala_unary_expression_is_integer_type (self, _tmp109_)) {
						ValaSourceReference* _tmp110_;
						ValaSourceReference* _tmp111_;
						ValaExpression* _tmp112_;
						ValaExpression* _tmp113_;
						ValaDataType* _tmp114_;
						ValaDataType* _tmp115_;
						gchar* _tmp116_;
						gchar* _tmp117_;
						gchar* _tmp118_;
						gchar* _tmp119_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp110_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp111_ = _tmp110_;
						_tmp112_ = vala_unary_expression_get_inner (self);
						_tmp113_ = _tmp112_;
						_tmp114_ = vala_expression_get_value_type (_tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_code_node_to_string ((ValaCodeNode*) _tmp115_);
						_tmp117_ = _tmp116_;
						_tmp118_ = g_strdup_printf ("Operator not supported for `%s'", _tmp117_);
						_tmp119_ = _tmp118_;
						vala_report_error (_tmp111_, _tmp119_);
						_g_free0 (_tmp119_);
						_g_free0 (_tmp117_);
						result = FALSE;
						return result;
					}
					_tmp120_ = vala_unary_expression_get_inner (self);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_unary_expression_find_member_access (self, _tmp121_);
					ma = _tmp122_;
					_tmp123_ = ma;
					if (_tmp123_ == NULL) {
						ValaSourceReference* _tmp124_;
						ValaSourceReference* _tmp125_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp125_ = _tmp124_;
						vala_report_error (_tmp125_, "Prefix operators not supported for this expression");
						result = FALSE;
						_vala_code_node_unref0 (ma);
						return result;
					}
					_tmp126_ = ma;
					_tmp127_ = vala_member_access_get_inner (_tmp126_);
					_tmp128_ = _tmp127_;
					_tmp129_ = ma;
					_tmp130_ = vala_member_access_get_member_name (_tmp129_);
					_tmp131_ = _tmp130_;
					_tmp132_ = vala_unary_expression_get_inner (self);
					_tmp133_ = _tmp132_;
					_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp133_);
					_tmp135_ = _tmp134_;
					_tmp136_ = vala_member_access_new (_tmp128_, _tmp131_, _tmp135_);
					old_value = _tmp136_;
					_tmp138_ = self->priv->_operator;
					if (_tmp138_ == VALA_UNARY_OPERATOR_INCREMENT) {
						_tmp137_ = VALA_BINARY_OPERATOR_PLUS;
					} else {
						_tmp137_ = VALA_BINARY_OPERATOR_MINUS;
					}
					_tmp139_ = old_value;
					_tmp140_ = vala_integer_literal_new ("1", NULL);
					_tmp141_ = _tmp140_;
					_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp143_ = _tmp142_;
					_tmp144_ = vala_binary_expression_new (_tmp137_, (ValaExpression*) _tmp139_, (ValaExpression*) _tmp141_, _tmp143_);
					_tmp145_ = _tmp144_;
					_vala_code_node_unref0 (_tmp141_);
					bin = _tmp145_;
					_tmp146_ = ma;
					_tmp147_ = bin;
					_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp149_ = _tmp148_;
					_tmp150_ = vala_assignment_new ((ValaExpression*) _tmp146_, (ValaExpression*) _tmp147_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp149_);
					assignment = _tmp150_;
					_tmp151_ = assignment;
					_tmp152_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp153_ = _tmp152_;
					vala_expression_set_target_type ((ValaExpression*) _tmp151_, _tmp153_);
					_tmp154_ = vala_code_context_get_analyzer (context);
					_tmp155_ = _tmp154_;
					_tmp156_ = _tmp155_->replaced_nodes;
					vala_collection_add ((ValaCollection*) _tmp156_, (ValaCodeNode*) self);
					_tmp157_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = assignment;
					vala_code_node_replace_expression (_tmp158_, (ValaExpression*) self, (ValaExpression*) _tmp159_);
					_tmp160_ = assignment;
					vala_code_node_check ((ValaCodeNode*) _tmp160_, context);
					result = TRUE;
					_vala_code_node_unref0 (assignment);
					_vala_code_node_unref0 (bin);
					_vala_code_node_unref0 (old_value);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp161_ = FALSE;
					ValaUnaryOperator _tmp162_;
					_tmp162_ = self->priv->_operator;
					if (_tmp162_ == VALA_UNARY_OPERATOR_REF) {
						_tmp161_ = TRUE;
					} else {
						ValaUnaryOperator _tmp163_;
						_tmp163_ = self->priv->_operator;
						_tmp161_ = _tmp163_ == VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp161_) {
						ValaElementAccess* ea = NULL;
						ValaExpression* _tmp164_;
						ValaExpression* _tmp165_;
						ValaElementAccess* _tmp166_;
						gboolean _tmp167_ = FALSE;
						gboolean _tmp168_ = FALSE;
						gboolean _tmp169_ = FALSE;
						ValaExpression* _tmp170_;
						ValaExpression* _tmp171_;
						ValaSymbol* _tmp172_;
						ValaSymbol* _tmp173_;
						_tmp164_ = vala_unary_expression_get_inner (self);
						_tmp165_ = _tmp164_;
						_tmp166_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp165_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp165_) : NULL);
						ea = _tmp166_;
						_tmp170_ = vala_unary_expression_get_inner (self);
						_tmp171_ = _tmp170_;
						_tmp172_ = vala_expression_get_symbol_reference (_tmp171_);
						_tmp173_ = _tmp172_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp173_, VALA_TYPE_FIELD)) {
							_tmp169_ = TRUE;
						} else {
							ValaExpression* _tmp174_;
							ValaExpression* _tmp175_;
							ValaSymbol* _tmp176_;
							ValaSymbol* _tmp177_;
							_tmp174_ = vala_unary_expression_get_inner (self);
							_tmp175_ = _tmp174_;
							_tmp176_ = vala_expression_get_symbol_reference (_tmp175_);
							_tmp177_ = _tmp176_;
							_tmp169_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp177_, VALA_TYPE_PARAMETER);
						}
						if (_tmp169_) {
							_tmp168_ = TRUE;
						} else {
							ValaExpression* _tmp178_;
							ValaExpression* _tmp179_;
							ValaSymbol* _tmp180_;
							ValaSymbol* _tmp181_;
							_tmp178_ = vala_unary_expression_get_inner (self);
							_tmp179_ = _tmp178_;
							_tmp180_ = vala_expression_get_symbol_reference (_tmp179_);
							_tmp181_ = _tmp180_;
							_tmp168_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp181_, VALA_TYPE_LOCAL_VARIABLE);
						}
						if (_tmp168_) {
							_tmp167_ = TRUE;
						} else {
							gboolean _tmp182_ = FALSE;
							ValaElementAccess* _tmp183_;
							_tmp183_ = ea;
							if (_tmp183_ != NULL) {
								ValaElementAccess* _tmp184_;
								ValaExpression* _tmp185_;
								ValaExpression* _tmp186_;
								ValaDataType* _tmp187_;
								ValaDataType* _tmp188_;
								_tmp184_ = ea;
								_tmp185_ = vala_element_access_get_container (_tmp184_);
								_tmp186_ = _tmp185_;
								_tmp187_ = vala_expression_get_value_type (_tmp186_);
								_tmp188_ = _tmp187_;
								_tmp182_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp188_, VALA_TYPE_ARRAY_TYPE);
							} else {
								_tmp182_ = FALSE;
							}
							_tmp167_ = _tmp182_;
						}
						if (_tmp167_) {
							ValaExpression* _tmp189_;
							ValaExpression* _tmp190_;
							ValaDataType* _tmp191_;
							ValaDataType* _tmp192_;
							vala_expression_set_lvalue ((ValaExpression*) self, TRUE);
							_tmp189_ = vala_unary_expression_get_inner (self);
							_tmp190_ = _tmp189_;
							_tmp191_ = vala_expression_get_value_type (_tmp190_);
							_tmp192_ = _tmp191_;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp192_);
						} else {
							ValaSourceReference* _tmp193_;
							ValaSourceReference* _tmp194_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp194_ = _tmp193_;
							vala_report_error (_tmp194_, "ref and out method arguments can only be used with fields, parameters," \
" local variables, and array element access");
							result = FALSE;
							_vala_code_node_unref0 (ea);
							return result;
						}
						_vala_code_node_unref0 (ea);
					} else {
						ValaSourceReference* _tmp195_;
						ValaSourceReference* _tmp196_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp196_ = _tmp195_;
						vala_report_error (_tmp196_, "internal error: unsupported unary operator");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp197_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp198_ = _tmp197_;
	result = !_tmp198_;
	return result;
}


static void
vala_unary_expression_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	vala_code_visitor_visit_unary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_unary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryOperator _tmp3_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp3_ = self->priv->_operator;
	if (_tmp3_ == VALA_UNARY_OPERATOR_OUT) {
		_tmp2_ = TRUE;
	} else {
		ValaUnaryOperator _tmp4_;
		_tmp4_ = self->priv->_operator;
		_tmp2_ = _tmp4_ == VALA_UNARY_OPERATOR_REF;
	}
	if (_tmp2_) {
		ValaLocalVariable* local = NULL;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaLocalVariable* _tmp9_;
		ValaParameter* param = NULL;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaParameter* _tmp14_;
		ValaLocalVariable* _tmp15_;
		gboolean _tmp17_ = FALSE;
		ValaParameter* _tmp18_;
		_tmp5_ = vala_unary_expression_get_inner (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_symbol_reference (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp8_) : NULL);
		local = _tmp9_;
		_tmp10_ = vala_unary_expression_get_inner (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp13_) : NULL);
		param = _tmp14_;
		_tmp15_ = local;
		if (_tmp15_ != NULL) {
			ValaLocalVariable* _tmp16_;
			_tmp16_ = local;
			vala_collection_add (collection, (ValaVariable*) _tmp16_);
		}
		_tmp18_ = param;
		if (_tmp18_ != NULL) {
			ValaParameter* _tmp19_;
			ValaParameterDirection _tmp20_;
			ValaParameterDirection _tmp21_;
			_tmp19_ = param;
			_tmp20_ = vala_parameter_get_direction (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp17_ = _tmp21_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			ValaParameter* _tmp22_;
			_tmp22_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp22_);
		}
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	}
}


static void
vala_unary_expression_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaUnaryExpression * self;
	ValaUnaryOperator _tmp0_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_operator;
	if (_tmp0_ != VALA_UNARY_OPERATOR_OUT) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		_tmp1_ = vala_unary_expression_get_inner (self);
		_tmp2_ = _tmp1_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp2_, collection);
	}
}


ValaUnaryOperator
vala_unary_expression_get_operator (ValaUnaryExpression* self)
{
	ValaUnaryOperator result;
	ValaUnaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_unary_expression_set_operator (ValaUnaryExpression* self,
                                    ValaUnaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaExpression*
vala_unary_expression_get_inner (ValaUnaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


void
vala_unary_expression_set_inner (ValaUnaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_unary_expression_class_init (ValaUnaryExpressionClass * klass)
{
	vala_unary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_unary_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaUnaryExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_unary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_unary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_unary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_unary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression *)) vala_unary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_unary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_unary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_unary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_unary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_unary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_unary_expression_real_get_used_variables;
}


static void
vala_unary_expression_instance_init (ValaUnaryExpression * self)
{
	self->priv = vala_unary_expression_get_instance_private (self);
}


static void
vala_unary_expression_finalize (ValaCodeNode * obj)
{
	ValaUnaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	VALA_CODE_NODE_CLASS (vala_unary_expression_parent_class)->finalize (obj);
}


/**
 * Represents an expression with one operand in the source code.
 *
 * Supports +, -, !, ~, ref, out.
 */
GType
vala_unary_expression_get_type (void)
{
	static volatile gsize vala_unary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaUnaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnaryExpression), 0, (GInstanceInitFunc) vala_unary_expression_instance_init, NULL };
		GType vala_unary_expression_type_id;
		vala_unary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaUnaryExpression", &g_define_type_info, 0);
		ValaUnaryExpression_private_offset = g_type_add_instance_private (vala_unary_expression_type_id, sizeof (ValaUnaryExpressionPrivate));
		g_once_init_leave (&vala_unary_expression_type_id__volatile, vala_unary_expression_type_id);
	}
	return vala_unary_expression_type_id__volatile;
}


GType
vala_unary_operator_get_type (void)
{
	static volatile gsize vala_unary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_UNARY_OPERATOR_NONE, "VALA_UNARY_OPERATOR_NONE", "none"}, {VALA_UNARY_OPERATOR_PLUS, "VALA_UNARY_OPERATOR_PLUS", "plus"}, {VALA_UNARY_OPERATOR_MINUS, "VALA_UNARY_OPERATOR_MINUS", "minus"}, {VALA_UNARY_OPERATOR_LOGICAL_NEGATION, "VALA_UNARY_OPERATOR_LOGICAL_NEGATION", "logical-negation"}, {VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT, "VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT", "bitwise-complement"}, {VALA_UNARY_OPERATOR_INCREMENT, "VALA_UNARY_OPERATOR_INCREMENT", "increment"}, {VALA_UNARY_OPERATOR_DECREMENT, "VALA_UNARY_OPERATOR_DECREMENT", "decrement"}, {VALA_UNARY_OPERATOR_REF, "VALA_UNARY_OPERATOR_REF", "ref"}, {VALA_UNARY_OPERATOR_OUT, "VALA_UNARY_OPERATOR_OUT", "out"}, {0, NULL, NULL}};
		GType vala_unary_operator_type_id;
		vala_unary_operator_type_id = g_enum_register_static ("ValaUnaryOperator", values);
		g_once_init_leave (&vala_unary_operator_type_id__volatile, vala_unary_operator_type_id);
	}
	return vala_unary_operator_type_id__volatile;
}



