/* commentconverter.c generated by valac, the Vala compiler
 * generated from commentconverter.vala, do not modify */

/* commentconverter.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <valadoc.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <float.h>
#include <math.h>


#define GTKDOC_TYPE_COMMENT_CONVERTER (gtkdoc_comment_converter_get_type ())
#define GTKDOC_COMMENT_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverter))
#define GTKDOC_COMMENT_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverterClass))
#define GTKDOC_IS_COMMENT_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_COMMENT_CONVERTER))
#define GTKDOC_IS_COMMENT_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_COMMENT_CONVERTER))
#define GTKDOC_COMMENT_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverterClass))

typedef struct _GtkdocCommentConverter GtkdocCommentConverter;
typedef struct _GtkdocCommentConverterClass GtkdocCommentConverterClass;
typedef struct _GtkdocCommentConverterPrivate GtkdocCommentConverterPrivate;

#define GTKDOC_TYPE_HEADER (gtkdoc_header_get_type ())
#define GTKDOC_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_HEADER, GtkdocHeader))
#define GTKDOC_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))
#define GTKDOC_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_HEADER))
#define GTKDOC_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_HEADER))
#define GTKDOC_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))

typedef struct _GtkdocHeader GtkdocHeader;
typedef struct _GtkdocHeaderClass GtkdocHeaderClass;
enum  {
	GTKDOC_COMMENT_CONVERTER_DUMMY_PROPERTY,
	GTKDOC_COMMENT_CONVERTER_LAST_PROPERTY
};
static GParamSpec* gtkdoc_comment_converter_properties[GTKDOC_COMMENT_CONVERTER_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _gtkdoc_header_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_header_unref (var), NULL)))

struct _GtkdocCommentConverter {
	ValadocContentContentVisitor parent_instance;
	GtkdocCommentConverterPrivate * priv;
	ValadocApiNode* node_reference;
	gboolean is_dbus;
	gchar* brief_comment;
	gchar* long_comment;
	gchar* returns;
	ValaList* parameters;
	ValaList* versioning;
	gchar** see_also;
	gint see_also_length1;
};

struct _GtkdocCommentConverterClass {
	ValadocContentContentVisitorClass parent_class;
};

struct _GtkdocCommentConverterPrivate {
	GString* current_builder;
	gboolean in_brief_comment;
	ValadocErrorReporter* reporter;
};


static gpointer gtkdoc_comment_converter_parent_class = NULL;

GType gtkdoc_comment_converter_get_type (void) G_GNUC_CONST;
gpointer gtkdoc_header_ref (gpointer instance);
void gtkdoc_header_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_header (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gtkdoc_value_set_header (GValue* value, gpointer v_object);
void gtkdoc_value_take_header (GValue* value, gpointer v_object);
gpointer gtkdoc_value_get_header (const GValue* value);
GType gtkdoc_header_get_type (void) G_GNUC_CONST;
#define GTKDOC_COMMENT_CONVERTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverterPrivate))
GtkdocCommentConverter* gtkdoc_comment_converter_new (ValadocErrorReporter* reporter, ValadocApiNode* node_reference);
GtkdocCommentConverter* gtkdoc_comment_converter_construct (GType object_type, ValadocErrorReporter* reporter, ValadocApiNode* node_reference);
void gtkdoc_comment_converter_convert (GtkdocCommentConverter* self, ValadocContentComment* comment, gboolean is_dbus);
static void gtkdoc_comment_converter_real_visit_comment (ValadocContentContentVisitor* base, ValadocContentComment* c);
static void gtkdoc_comment_converter_real_visit_embedded (ValadocContentContentVisitor* base, ValadocContentEmbedded* em);
static void gtkdoc_comment_converter_real_visit_headline (ValadocContentContentVisitor* base, ValadocContentHeadline* hl);
static void gtkdoc_comment_converter_real_visit_wiki_link (ValadocContentContentVisitor* base, ValadocContentWikiLink* link);
static void gtkdoc_comment_converter_real_visit_link (ValadocContentContentVisitor* base, ValadocContentLink* link);
static void gtkdoc_comment_converter_real_visit_symbol_link (ValadocContentContentVisitor* base, ValadocContentSymbolLink* sl);
gchar* gtkdoc_get_docbook_link (ValadocApiItem* item, gboolean is_dbus, gboolean is_async_finish);
static void gtkdoc_comment_converter_real_visit_list (ValadocContentContentVisitor* base, ValadocContentList* list);
static void gtkdoc_comment_converter_real_visit_list_item (ValadocContentContentVisitor* base, ValadocContentListItem* item);
static void gtkdoc_comment_converter_real_visit_paragraph (ValadocContentContentVisitor* base, ValadocContentParagraph* para);
static void gtkdoc_comment_converter_real_visit_warning (ValadocContentContentVisitor* base, ValadocContentWarning* element);
static void gtkdoc_comment_converter_real_visit_note (ValadocContentContentVisitor* base, ValadocContentNote* element);
static void gtkdoc_comment_converter_real_visit_page (ValadocContentContentVisitor* base, ValadocContentPage* page);
static void gtkdoc_comment_converter_real_visit_run (ValadocContentContentVisitor* base, ValadocContentRun* run);
static void gtkdoc_comment_converter_real_visit_source_code (ValadocContentContentVisitor* base, ValadocContentSourceCode* code);
static void gtkdoc_comment_converter_real_visit_table (ValadocContentContentVisitor* base, ValadocContentTable* t);
static void gtkdoc_comment_converter_real_visit_table_row (ValadocContentContentVisitor* base, ValadocContentTableRow* row);
static void gtkdoc_comment_converter_real_visit_table_cell (ValadocContentContentVisitor* base, ValadocContentTableCell* cell);
static void gtkdoc_comment_converter_real_visit_taglet (ValadocContentContentVisitor* base, ValadocContentTaglet* t);
gdouble gtkdoc_get_parameter_pos (ValadocApiNode* node, const gchar* name);
GtkdocHeader* gtkdoc_header_new (const gchar* name, const gchar* value, gdouble pos, gboolean block);
GtkdocHeader* gtkdoc_header_construct (GType object_type, const gchar* name, const gchar* value, gdouble pos, gboolean block);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void gtkdoc_comment_converter_real_visit_text (ValadocContentContentVisitor* base, ValadocContentText* t);
static void gtkdoc_comment_converter_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GtkdocCommentConverter* gtkdoc_comment_converter_construct (GType object_type, ValadocErrorReporter* reporter, ValadocApiNode* node_reference) {
	GtkdocCommentConverter * self = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiNode* _tmp1_;
	ValadocErrorReporter* _tmp2_;
	ValadocErrorReporter* _tmp3_;
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (GtkdocCommentConverter*) valadoc_content_content_visitor_construct (object_type);
	_tmp0_ = node_reference;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->node_reference);
	self->node_reference = _tmp1_;
	_tmp2_ = reporter;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp3_;
	return self;
}


GtkdocCommentConverter* gtkdoc_comment_converter_new (ValadocErrorReporter* reporter, ValadocApiNode* node_reference) {
	return gtkdoc_comment_converter_construct (GTKDOC_TYPE_COMMENT_CONVERTER, reporter, node_reference);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void gtkdoc_comment_converter_convert (GtkdocCommentConverter* self, ValadocContentComment* comment, gboolean is_dbus) {
	gboolean _tmp0_;
	ValadocContentComment* _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	_tmp0_ = is_dbus;
	self->is_dbus = _tmp0_;
	_tmp1_ = comment;
	valadoc_content_content_element_accept ((ValadocContentContentElement*) _tmp1_, (ValadocContentContentVisitor*) self);
	_tmp2_ = self->priv->current_builder;
	_tmp3_ = _tmp2_->str;
	_tmp4_ = string_strip (_tmp3_);
	_g_free0 (self->long_comment);
	self->long_comment = _tmp4_;
	_tmp5_ = self->long_comment;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		_g_free0 (self->long_comment);
		self->long_comment = NULL;
	}
}


static void gtkdoc_comment_converter_real_visit_comment (ValadocContentContentVisitor* base, ValadocContentComment* c) {
	GtkdocCommentConverter * self;
	ValadocContentComment* _tmp0_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp0_, (ValadocContentContentVisitor*) self);
}


static void gtkdoc_comment_converter_real_visit_embedded (ValadocContentContentVisitor* base, ValadocContentEmbedded* em) {
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	ValadocContentEmbedded* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp8_;
	ValadocContentEmbedded* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValadocContentEmbedded* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValadocContentEmbedded* _tmp19_;
	GString* _tmp20_;
	GString* _tmp21_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (em != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<figure>");
	_tmp1_ = em;
	_tmp2_ = valadoc_content_embedded_get_caption (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GString* _tmp4_;
		ValadocContentEmbedded* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = self->priv->current_builder;
		_tmp5_ = em;
		_tmp6_ = valadoc_content_embedded_get_caption (_tmp5_);
		_tmp7_ = _tmp6_;
		g_string_append_printf (_tmp4_, "<title>%s</title>", _tmp7_);
	}
	_tmp8_ = self->priv->current_builder;
	_tmp9_ = em;
	_tmp10_ = valadoc_content_embedded_get_url (_tmp9_);
	_tmp11_ = _tmp10_;
	g_string_append_printf (_tmp8_, "<mediaobject><imageobject><imagedata fileref=\"%s\"/></imageobject>", _tmp11_);
	_tmp12_ = em;
	_tmp13_ = valadoc_content_embedded_get_caption (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		GString* _tmp15_;
		ValadocContentEmbedded* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = self->priv->current_builder;
		_tmp16_ = em;
		_tmp17_ = valadoc_content_embedded_get_caption (_tmp16_);
		_tmp18_ = _tmp17_;
		g_string_append_printf (_tmp15_, "<textobject><phrase>%s</phrase></textobject>", _tmp18_);
	}
	_tmp19_ = em;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp19_, (ValadocContentContentVisitor*) self);
	_tmp20_ = self->priv->current_builder;
	g_string_append (_tmp20_, "</mediaobject>");
	_tmp21_ = self->priv->current_builder;
	g_string_append (_tmp21_, "</figure>");
}


static void gtkdoc_comment_converter_real_visit_headline (ValadocContentContentVisitor* base, ValadocContentHeadline* hl) {
	GtkdocCommentConverter * self;
	ValadocErrorReporter* _tmp0_;
	GString* _tmp1_;
	ValadocContentHeadline* _tmp2_;
	GString* _tmp3_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (hl != NULL);
	_tmp0_ = self->priv->reporter;
	valadoc_error_reporter_simple_warning (_tmp0_, "GtkDoc", "Headline elements not supported");
	_tmp1_ = self->priv->current_builder;
	g_string_append (_tmp1_, "\n");
	_tmp2_ = hl;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp2_, (ValadocContentContentVisitor*) self);
	_tmp3_ = self->priv->current_builder;
	g_string_append (_tmp3_, "\n");
}


static void gtkdoc_comment_converter_real_visit_wiki_link (ValadocContentContentVisitor* base, ValadocContentWikiLink* link) {
	GtkdocCommentConverter * self;
	ValadocContentWikiLink* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (link != NULL);
	_tmp0_ = link;
	_tmp1_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		ValadocContentWikiLink* _tmp5_;
		_tmp5_ = link;
		valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp5_, (ValadocContentContentVisitor*) self);
	} else {
		GString* _tmp6_;
		ValadocContentWikiLink* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = self->priv->current_builder;
		_tmp7_ = link;
		_tmp8_ = valadoc_content_wiki_link_get_name (_tmp7_);
		_tmp9_ = _tmp8_;
		g_string_append (_tmp6_, _tmp9_);
	}
}


static void gtkdoc_comment_converter_real_visit_link (ValadocContentContentVisitor* base, ValadocContentLink* link) {
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	ValadocContentLink* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValadocContentLink* _tmp4_;
	GString* _tmp5_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (link != NULL);
	_tmp0_ = self->priv->current_builder;
	_tmp1_ = link;
	_tmp2_ = valadoc_content_link_get_url (_tmp1_);
	_tmp3_ = _tmp2_;
	g_string_append_printf (_tmp0_, "<ulink url=\"%s\">", _tmp3_);
	_tmp4_ = link;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp4_, (ValadocContentContentVisitor*) self);
	_tmp5_ = self->priv->current_builder;
	g_string_append (_tmp5_, "</ulink>");
}


static void gtkdoc_comment_converter_real_visit_symbol_link (ValadocContentContentVisitor* base, ValadocContentSymbolLink* sl) {
	GtkdocCommentConverter * self;
	ValadocContentSymbolLink* _tmp0_;
	ValadocApiNode* _tmp1_;
	ValadocApiNode* _tmp2_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (sl != NULL);
	_tmp0_ = sl;
	_tmp1_ = valadoc_content_symbol_link_get_symbol (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValadocContentSymbolLink* _tmp6_;
		ValadocApiNode* _tmp7_;
		ValadocApiNode* _tmp8_;
		_tmp6_ = sl;
		_tmp7_ = valadoc_content_symbol_link_get_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALADOC_API_TYPE_METHOD)) {
			ValadocContentSymbolLink* _tmp9_;
			ValadocApiNode* _tmp10_;
			ValadocApiNode* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp9_ = sl;
			_tmp10_ = valadoc_content_symbol_link_get_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = valadoc_api_method_get_is_constructor (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			_tmp13_ = _tmp12_;
			_tmp5_ = _tmp13_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValadocContentSymbolLink* _tmp14_;
			ValadocApiNode* _tmp15_;
			ValadocApiNode* _tmp16_;
			ValadocApiItem* _tmp17_;
			ValadocApiItem* _tmp18_;
			_tmp14_ = sl;
			_tmp15_ = valadoc_content_symbol_link_get_symbol (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = valadoc_api_item_get_parent ((ValadocApiItem*) G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			_tmp18_ = _tmp17_;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALADOC_API_TYPE_CLASS);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValadocContentSymbolLink* _tmp19_;
			ValadocApiNode* _tmp20_;
			ValadocApiNode* _tmp21_;
			ValadocApiItem* _tmp22_;
			ValadocApiItem* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
			_tmp19_ = sl;
			_tmp20_ = valadoc_content_symbol_link_get_symbol (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = valadoc_api_item_get_parent ((ValadocApiItem*) G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			_tmp23_ = _tmp22_;
			_tmp24_ = valadoc_api_class_get_is_abstract (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp25_ = _tmp24_;
			_tmp3_ = _tmp25_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gchar* _tmp26_ = NULL;
			ValadocContentSymbolLink* _tmp27_;
			ValadocApiNode* _tmp28_;
			ValadocApiNode* _tmp29_;
			ValadocApiItem* _tmp30_;
			ValadocApiItem* _tmp31_;
			gboolean _tmp32_;
			gchar* _tmp33_;
			GString* _tmp38_;
			_tmp27_ = sl;
			_tmp28_ = valadoc_content_symbol_link_get_symbol (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = valadoc_api_item_get_parent ((ValadocApiItem*) G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			_tmp31_ = _tmp30_;
			_tmp32_ = self->is_dbus;
			_tmp33_ = gtkdoc_get_docbook_link (_tmp31_, _tmp32_, FALSE);
			_tmp26_ = _tmp33_;
			if (_tmp26_ == NULL) {
				ValadocContentSymbolLink* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp34_ = sl;
				_tmp35_ = valadoc_content_symbol_link_get_given_symbol_name (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strdup (_tmp36_);
				_g_free0 (_tmp26_);
				_tmp26_ = _tmp37_;
			}
			_tmp38_ = self->priv->current_builder;
			g_string_append (_tmp38_, _tmp26_);
			_g_free0 (_tmp26_);
		} else {
			gchar* _tmp39_ = NULL;
			ValadocContentSymbolLink* _tmp40_;
			ValadocApiNode* _tmp41_;
			ValadocApiNode* _tmp42_;
			gboolean _tmp43_;
			gchar* _tmp44_;
			GString* _tmp49_;
			_tmp40_ = sl;
			_tmp41_ = valadoc_content_symbol_link_get_symbol (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = self->is_dbus;
			_tmp44_ = gtkdoc_get_docbook_link ((ValadocApiItem*) _tmp42_, _tmp43_, FALSE);
			_tmp39_ = _tmp44_;
			if (_tmp39_ == NULL) {
				ValadocContentSymbolLink* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp45_ = sl;
				_tmp46_ = valadoc_content_symbol_link_get_given_symbol_name (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = g_strdup (_tmp47_);
				_g_free0 (_tmp39_);
				_tmp39_ = _tmp48_;
			}
			_tmp49_ = self->priv->current_builder;
			g_string_append (_tmp49_, _tmp39_);
			_g_free0 (_tmp39_);
		}
	} else {
		GString* _tmp50_;
		ValadocContentSymbolLink* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		_tmp50_ = self->priv->current_builder;
		_tmp51_ = sl;
		_tmp52_ = valadoc_content_symbol_link_get_given_symbol_name (_tmp51_);
		_tmp53_ = _tmp52_;
		g_string_append (_tmp50_, _tmp53_);
	}
}


static void gtkdoc_comment_converter_real_visit_list (ValadocContentContentVisitor* base, ValadocContentList* list) {
	GtkdocCommentConverter * self;
	gchar* tag = NULL;
	gchar* _tmp0_;
	ValadocContentList* _tmp1_;
	ValadocContentListBullet _tmp2_;
	ValadocContentListBullet _tmp3_;
	ValadocContentList* _tmp19_;
	GString* _tmp20_;
	const gchar* _tmp21_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (list != NULL);
	_tmp0_ = g_strdup ("orderedlist");
	tag = _tmp0_;
	_tmp1_ = list;
	_tmp2_ = valadoc_content_list_get_bullet (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case VALADOC_CONTENT_LIST_BULLET_NONE:
		{
			GString* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = self->priv->current_builder;
			g_string_append (_tmp4_, "<itemizedlist mark=\"none\">");
			_tmp5_ = g_strdup ("itemizedlist");
			_g_free0 (tag);
			tag = _tmp5_;
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_UNORDERED:
		{
			GString* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = self->priv->current_builder;
			g_string_append (_tmp6_, "<itemizedlist>");
			_tmp7_ = g_strdup ("itemizedlist");
			_g_free0 (tag);
			tag = _tmp7_;
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED:
		{
			GString* _tmp8_;
			_tmp8_ = self->priv->current_builder;
			g_string_append (_tmp8_, "<orderedlist>");
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_NUMBER:
		{
			GString* _tmp9_;
			_tmp9_ = self->priv->current_builder;
			g_string_append (_tmp9_, "<orderedlist numeration=\"arabic\">");
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ALPHA:
		{
			GString* _tmp10_;
			_tmp10_ = self->priv->current_builder;
			g_string_append (_tmp10_, "<orderedlist numeration=\"loweralpha\">");
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ALPHA:
		{
			GString* _tmp11_;
			_tmp11_ = self->priv->current_builder;
			g_string_append (_tmp11_, "<orderedlist numeration=\"upperalpha\">");
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ROMAN:
		{
			GString* _tmp12_;
			_tmp12_ = self->priv->current_builder;
			g_string_append (_tmp12_, "<orderedlist numeration=\"lowerroman\">");
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ROMAN:
		{
			GString* _tmp13_;
			_tmp13_ = self->priv->current_builder;
			g_string_append (_tmp13_, "<orderedlist numeration=\"upperroman\">");
			break;
		}
		default:
		{
			ValadocErrorReporter* _tmp14_;
			ValadocContentList* _tmp15_;
			ValadocContentListBullet _tmp16_;
			ValadocContentListBullet _tmp17_;
			const gchar* _tmp18_;
			_tmp14_ = self->priv->reporter;
			_tmp15_ = list;
			_tmp16_ = valadoc_content_list_get_bullet (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = valadoc_content_list_bullet_to_string (_tmp17_);
			valadoc_error_reporter_simple_warning (_tmp14_, "GtkDoc", "unsupported list type: '%s'", _tmp18_);
			break;
		}
	}
	_tmp19_ = list;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp19_, (ValadocContentContentVisitor*) self);
	_tmp20_ = self->priv->current_builder;
	_tmp21_ = tag;
	g_string_append_printf (_tmp20_, "</%s>", _tmp21_);
	_g_free0 (tag);
}


static void gtkdoc_comment_converter_real_visit_list_item (ValadocContentContentVisitor* base, ValadocContentListItem* item) {
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	ValadocContentListItem* _tmp1_;
	GString* _tmp2_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<listitem>");
	_tmp1_ = item;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp1_, (ValadocContentContentVisitor*) self);
	_tmp2_ = self->priv->current_builder;
	g_string_append (_tmp2_, "</listitem>");
}


static void gtkdoc_comment_converter_real_visit_paragraph (ValadocContentContentVisitor* base, ValadocContentParagraph* para) {
	GtkdocCommentConverter * self;
	gboolean _tmp0_;
	ValadocContentParagraph* _tmp2_;
	gboolean _tmp3_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (para != NULL);
	_tmp0_ = self->priv->in_brief_comment;
	if (!_tmp0_) {
		GString* _tmp1_;
		_tmp1_ = self->priv->current_builder;
		g_string_append (_tmp1_, "<para>");
	}
	_tmp2_ = para;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp2_, (ValadocContentContentVisitor*) self);
	_tmp3_ = self->priv->in_brief_comment;
	if (_tmp3_) {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		GString* _tmp7_;
		_tmp4_ = self->priv->current_builder;
		_tmp5_ = _tmp4_->str;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (self->brief_comment);
		self->brief_comment = _tmp6_;
		_tmp7_ = g_string_new ("");
		_g_string_free0 (self->priv->current_builder);
		self->priv->current_builder = _tmp7_;
		self->priv->in_brief_comment = FALSE;
	} else {
		GString* _tmp8_;
		_tmp8_ = self->priv->current_builder;
		g_string_append (_tmp8_, "</para>");
	}
}


static void gtkdoc_comment_converter_real_visit_warning (ValadocContentContentVisitor* base, ValadocContentWarning* element) {
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	ValadocContentWarning* _tmp1_;
	GString* _tmp2_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<warning>");
	_tmp1_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp1_, (ValadocContentContentVisitor*) self);
	_tmp2_ = self->priv->current_builder;
	g_string_append (_tmp2_, "</warning>");
}


static void gtkdoc_comment_converter_real_visit_note (ValadocContentContentVisitor* base, ValadocContentNote* element) {
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	ValadocContentNote* _tmp1_;
	GString* _tmp2_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<note>");
	_tmp1_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp1_, (ValadocContentContentVisitor*) self);
	_tmp2_ = self->priv->current_builder;
	g_string_append (_tmp2_, "</note>");
}


static void gtkdoc_comment_converter_real_visit_page (ValadocContentContentVisitor* base, ValadocContentPage* page) {
	GtkdocCommentConverter * self;
	ValadocContentPage* _tmp0_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp0_, (ValadocContentContentVisitor*) self);
}


static void gtkdoc_comment_converter_real_visit_run (ValadocContentContentVisitor* base, ValadocContentRun* run) {
	GtkdocCommentConverter * self;
	gchar* tag = NULL;
	ValadocContentRun* _tmp0_;
	ValadocContentRunStyle _tmp1_;
	ValadocContentRunStyle _tmp2_;
	ValadocContentRun* _tmp11_;
	const gchar* _tmp12_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (run != NULL);
	tag = NULL;
	_tmp0_ = run;
	_tmp1_ = valadoc_content_run_get_style (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case VALADOC_CONTENT_RUN_STYLE_BOLD:
		{
			GString* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = self->priv->current_builder;
			g_string_append (_tmp3_, "<emphasis role=\"bold\">");
			_tmp4_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp4_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_ITALIC:
		{
			GString* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = self->priv->current_builder;
			g_string_append (_tmp5_, "<emphasis>");
			_tmp6_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp6_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_UNDERLINED:
		{
			GString* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->current_builder;
			g_string_append (_tmp7_, "<emphasis role=\"underline\">");
			_tmp8_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp8_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_MONOSPACED:
		{
			GString* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = self->priv->current_builder;
			g_string_append (_tmp9_, "<code>");
			_tmp10_ = g_strdup ("code");
			_g_free0 (tag);
			tag = _tmp10_;
			break;
		}
		default:
		break;
	}
	_tmp11_ = run;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp11_, (ValadocContentContentVisitor*) self);
	_tmp12_ = tag;
	if (_tmp12_ != NULL) {
		GString* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = self->priv->current_builder;
		_tmp14_ = tag;
		g_string_append_printf (_tmp13_, "</%s>", _tmp14_);
	}
	_g_free0 (tag);
}


static void gtkdoc_comment_converter_real_visit_source_code (ValadocContentContentVisitor* base, ValadocContentSourceCode* code) {
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	GString* _tmp1_;
	ValadocContentSourceCode* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GString* _tmp7_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (code != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "\n|[\n");
	_tmp1_ = self->priv->current_builder;
	_tmp2_ = code;
	_tmp3_ = valadoc_content_source_code_get_code (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	g_string_append (_tmp1_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->current_builder;
	g_string_append (_tmp7_, "\n]|\n");
}


static void gtkdoc_comment_converter_real_visit_table (ValadocContentContentVisitor* base, ValadocContentTable* t) {
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	ValadocContentTable* _tmp1_;
	GString* _tmp2_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<table>");
	_tmp1_ = t;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp1_, (ValadocContentContentVisitor*) self);
	_tmp2_ = self->priv->current_builder;
	g_string_append (_tmp2_, "</table>");
}


static void gtkdoc_comment_converter_real_visit_table_row (ValadocContentContentVisitor* base, ValadocContentTableRow* row) {
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	ValadocContentTableRow* _tmp1_;
	GString* _tmp2_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<tr>");
	_tmp1_ = row;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp1_, (ValadocContentContentVisitor*) self);
	_tmp2_ = self->priv->current_builder;
	g_string_append (_tmp2_, "</tr>");
}


static void gtkdoc_comment_converter_real_visit_table_cell (ValadocContentContentVisitor* base, ValadocContentTableCell* cell) {
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	ValadocContentTableCell* _tmp1_;
	GString* _tmp2_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (cell != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<td>");
	_tmp1_ = cell;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp1_, (ValadocContentContentVisitor*) self);
	_tmp2_ = self->priv->current_builder;
	g_string_append (_tmp2_, "</td>");
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void gtkdoc_comment_converter_real_visit_taglet (ValadocContentContentVisitor* base, ValadocContentTaglet* t) {
	GtkdocCommentConverter * self;
	GString* old_builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	ValadocContentTaglet* _tmp2_;
	ValadocContentTaglet* _tmp3_;
	GString* _tmp89_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->current_builder;
	self->priv->current_builder = NULL;
	old_builder = _tmp0_;
	_tmp1_ = g_string_new ("");
	_g_string_free0 (self->priv->current_builder);
	self->priv->current_builder = _tmp1_;
	_tmp2_ = t;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp2_, (ValadocContentContentVisitor*) self);
	_tmp3_ = t;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_TAGLETS_TYPE_PARAM)) {
		gdouble pos = 0.0;
		gchar* param_name = NULL;
		ValadocContentTaglet* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		ValadocApiNode* _tmp8_;
		GtkdocHeader* header = NULL;
		const gchar* _tmp12_;
		GString* _tmp13_;
		const gchar* _tmp14_;
		gdouble _tmp15_;
		GtkdocHeader* _tmp16_;
		ValaList* _tmp17_;
		GtkdocHeader* _tmp18_;
		pos = DBL_MAX;
		_tmp4_ = t;
		_tmp5_ = valadoc_taglets_param_get_parameter_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALADOC_TAGLETS_TYPE_PARAM, ValadocTagletsParam));
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup (_tmp6_);
		param_name = _tmp7_;
		_tmp8_ = self->node_reference;
		if (_tmp8_ != NULL) {
			ValadocApiNode* _tmp9_;
			const gchar* _tmp10_;
			gdouble _tmp11_;
			_tmp9_ = self->node_reference;
			_tmp10_ = param_name;
			_tmp11_ = gtkdoc_get_parameter_pos (_tmp9_, _tmp10_);
			pos = _tmp11_;
		}
		_tmp12_ = param_name;
		_tmp13_ = self->priv->current_builder;
		_tmp14_ = _tmp13_->str;
		_tmp15_ = pos;
		_tmp16_ = gtkdoc_header_new (_tmp12_, _tmp14_, _tmp15_, TRUE);
		header = _tmp16_;
		_tmp17_ = self->parameters;
		_tmp18_ = header;
		vala_collection_add ((ValaCollection*) _tmp17_, _tmp18_);
		_gtkdoc_header_unref0 (header);
		_g_free0 (param_name);
	} else {
		ValadocContentTaglet* _tmp19_;
		_tmp19_ = t;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALADOC_TAGLETS_TYPE_INHERIT_DOC)) {
			ValadocContentTaglet* _tmp20_;
			ValadocContentContentElement* _tmp21_;
			ValadocContentContentElement* _tmp22_;
			_tmp20_ = t;
			_tmp21_ = valadoc_content_inline_taglet_produce_content ((ValadocContentInlineTaglet*) G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALADOC_TAGLETS_TYPE_INHERIT_DOC, ValadocTagletsInheritDoc));
			_tmp22_ = _tmp21_;
			valadoc_content_content_element_accept (_tmp22_, (ValadocContentContentVisitor*) self);
			_g_object_unref0 (_tmp22_);
		} else {
			ValadocContentTaglet* _tmp23_;
			_tmp23_ = t;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALADOC_TAGLETS_TYPE_RETURN)) {
				GString* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp24_ = self->priv->current_builder;
				_tmp25_ = _tmp24_->str;
				_tmp26_ = g_strdup (_tmp25_);
				_g_free0 (self->returns);
				self->returns = _tmp26_;
			} else {
				ValadocContentTaglet* _tmp27_;
				_tmp27_ = t;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALADOC_TAGLETS_TYPE_SINCE)) {
					GtkdocHeader* header = NULL;
					ValadocContentTaglet* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					GtkdocHeader* _tmp31_;
					ValaList* _tmp32_;
					GtkdocHeader* _tmp33_;
					_tmp28_ = t;
					_tmp29_ = valadoc_taglets_since_get_version (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALADOC_TAGLETS_TYPE_SINCE, ValadocTagletsSince));
					_tmp30_ = _tmp29_;
					_tmp31_ = gtkdoc_header_new ("Since", _tmp30_, DBL_MAX, TRUE);
					header = _tmp31_;
					_tmp32_ = self->versioning;
					_tmp33_ = header;
					vala_collection_add ((ValaCollection*) _tmp32_, _tmp33_);
					_gtkdoc_header_unref0 (header);
				} else {
					ValadocContentTaglet* _tmp34_;
					_tmp34_ = t;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALADOC_TAGLETS_TYPE_DEPRECATED)) {
						GtkdocHeader* header = NULL;
						GString* _tmp35_;
						const gchar* _tmp36_;
						GtkdocHeader* _tmp37_;
						ValaList* _tmp38_;
						GtkdocHeader* _tmp39_;
						_tmp35_ = self->priv->current_builder;
						_tmp36_ = _tmp35_->str;
						_tmp37_ = gtkdoc_header_new ("Deprecated", _tmp36_, DBL_MAX, TRUE);
						header = _tmp37_;
						_tmp38_ = self->versioning;
						_tmp39_ = header;
						vala_collection_add ((ValaCollection*) _tmp38_, _tmp39_);
						_gtkdoc_header_unref0 (header);
					} else {
						ValadocContentTaglet* _tmp40_;
						_tmp40_ = t;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, VALADOC_TAGLETS_TYPE_SEE)) {
							ValadocTagletsSee* see = NULL;
							ValadocContentTaglet* _tmp41_;
							ValadocTagletsSee* _tmp42_;
							gchar** see_also = NULL;
							gchar** _tmp43_;
							gint _tmp43__length1;
							gchar** _tmp44_;
							gint _tmp44__length1;
							gint see_also_length1;
							gint _see_also_size_;
							ValadocTagletsSee* _tmp45_;
							ValadocApiNode* _tmp46_;
							ValadocApiNode* _tmp47_;
							gchar** _tmp65_;
							gint _tmp65__length1;
							gchar** _tmp66_;
							gint _tmp66__length1;
							_tmp41_ = t;
							_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALADOC_TAGLETS_TYPE_SEE, ValadocTagletsSee));
							see = _tmp42_;
							_tmp43_ = self->see_also;
							_tmp43__length1 = self->see_also_length1;
							_tmp44_ = (_tmp43_ != NULL) ? _vala_array_dup1 (_tmp43_, _tmp43__length1) : ((gpointer) _tmp43_);
							_tmp44__length1 = _tmp43__length1;
							see_also = _tmp44_;
							see_also_length1 = _tmp44__length1;
							_see_also_size_ = see_also_length1;
							_tmp45_ = see;
							_tmp46_ = valadoc_taglets_see_get_symbol (_tmp45_);
							_tmp47_ = _tmp46_;
							if (_tmp47_ != NULL) {
								gchar* _tmp48_ = NULL;
								ValadocTagletsSee* _tmp49_;
								ValadocApiNode* _tmp50_;
								ValadocApiNode* _tmp51_;
								gboolean _tmp52_;
								gchar* _tmp53_;
								gchar** _tmp58_;
								gint _tmp58__length1;
								gchar* _tmp59_;
								_tmp49_ = see;
								_tmp50_ = valadoc_taglets_see_get_symbol (_tmp49_);
								_tmp51_ = _tmp50_;
								_tmp52_ = self->is_dbus;
								_tmp53_ = gtkdoc_get_docbook_link ((ValadocApiItem*) _tmp51_, _tmp52_, FALSE);
								_tmp48_ = _tmp53_;
								if (_tmp48_ == NULL) {
									ValadocTagletsSee* _tmp54_;
									const gchar* _tmp55_;
									const gchar* _tmp56_;
									gchar* _tmp57_;
									_tmp54_ = see;
									_tmp55_ = valadoc_taglets_see_get_symbol_name (_tmp54_);
									_tmp56_ = _tmp55_;
									_tmp57_ = g_strdup (_tmp56_);
									_g_free0 (_tmp48_);
									_tmp48_ = _tmp57_;
								}
								_tmp58_ = see_also;
								_tmp58__length1 = see_also_length1;
								_tmp59_ = _tmp48_;
								_tmp48_ = NULL;
								_vala_array_add1 (&see_also, &see_also_length1, &_see_also_size_, _tmp59_);
								_g_free0 (_tmp48_);
							} else {
								gchar** _tmp60_;
								gint _tmp60__length1;
								ValadocTagletsSee* _tmp61_;
								const gchar* _tmp62_;
								const gchar* _tmp63_;
								gchar* _tmp64_;
								_tmp60_ = see_also;
								_tmp60__length1 = see_also_length1;
								_tmp61_ = see;
								_tmp62_ = valadoc_taglets_see_get_symbol_name (_tmp61_);
								_tmp63_ = _tmp62_;
								_tmp64_ = g_strdup (_tmp63_);
								_vala_array_add2 (&see_also, &see_also_length1, &_see_also_size_, _tmp64_);
							}
							_tmp65_ = see_also;
							_tmp65__length1 = see_also_length1;
							_tmp66_ = (_tmp65_ != NULL) ? _vala_array_dup2 (_tmp65_, _tmp65__length1) : ((gpointer) _tmp65_);
							_tmp66__length1 = _tmp65__length1;
							self->see_also = (_vala_array_free (self->see_also, self->see_also_length1, (GDestroyNotify) g_free), NULL);
							self->see_also = _tmp66_;
							self->see_also_length1 = _tmp66__length1;
							see_also = (_vala_array_free (see_also, see_also_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (see);
						} else {
							ValadocContentTaglet* _tmp67_;
							_tmp67_ = t;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALADOC_TAGLETS_TYPE_LINK)) {
								ValadocContentTaglet* _tmp68_;
								ValadocContentContentElement* _tmp69_;
								ValadocContentContentElement* _tmp70_;
								_tmp68_ = t;
								_tmp69_ = valadoc_content_inline_taglet_produce_content ((ValadocContentInlineTaglet*) G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALADOC_TAGLETS_TYPE_LINK, ValadocTagletsLink));
								_tmp70_ = _tmp69_;
								valadoc_content_content_element_accept (_tmp70_, (ValadocContentContentVisitor*) self);
								_g_object_unref0 (_tmp70_);
							} else {
								ValadocContentTaglet* _tmp71_;
								_tmp71_ = t;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALADOC_TAGLETS_TYPE_THROWS)) {
									ValadocTagletsThrows* taglet = NULL;
									ValadocContentTaglet* _tmp72_;
									ValadocTagletsThrows* _tmp73_;
									gchar* _tmp74_ = NULL;
									ValadocTagletsThrows* _tmp75_;
									ValadocApiNode* _tmp76_;
									ValadocApiNode* _tmp77_;
									gchar* _tmp78_;
									gchar* link = NULL;
									gchar* _tmp83_;
									GString* _tmp84_;
									const gchar* _tmp85_;
									GString* _tmp86_;
									const gchar* _tmp87_;
									_tmp72_ = t;
									_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALADOC_TAGLETS_TYPE_THROWS, ValadocTagletsThrows));
									taglet = _tmp73_;
									_tmp75_ = taglet;
									_tmp76_ = valadoc_taglets_throws_get_error_domain (_tmp75_);
									_tmp77_ = _tmp76_;
									_tmp78_ = gtkdoc_get_docbook_link ((ValadocApiItem*) _tmp77_, FALSE, FALSE);
									_tmp74_ = _tmp78_;
									if (_tmp74_ == NULL) {
										ValadocTagletsThrows* _tmp79_;
										const gchar* _tmp80_;
										const gchar* _tmp81_;
										gchar* _tmp82_;
										_tmp79_ = taglet;
										_tmp80_ = valadoc_taglets_throws_get_error_domain_name (_tmp79_);
										_tmp81_ = _tmp80_;
										_tmp82_ = g_strdup (_tmp81_);
										_g_free0 (_tmp74_);
										_tmp74_ = _tmp82_;
									}
									_tmp83_ = g_strdup (_tmp74_);
									link = _tmp83_;
									_tmp84_ = old_builder;
									_tmp85_ = link;
									_tmp86_ = self->priv->current_builder;
									_tmp87_ = _tmp86_->str;
									g_string_append_printf (_tmp84_, "\n<para>%s will be returned in @error %s</para>", _tmp85_, _tmp87_);
									_g_free0 (link);
									_g_free0 (_tmp74_);
									_g_object_unref0 (taglet);
								} else {
									ValadocErrorReporter* _tmp88_;
									_tmp88_ = self->priv->reporter;
									valadoc_error_reporter_simple_warning (_tmp88_, "GtkDoc", "Taglet not supported");
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp89_ = old_builder;
	old_builder = NULL;
	_g_string_free0 (self->priv->current_builder);
	self->priv->current_builder = _tmp89_;
	_g_string_free0 (old_builder);
}


static void gtkdoc_comment_converter_real_visit_text (ValadocContentContentVisitor* base, ValadocContentText* t) {
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	ValadocContentText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValadocContentText* _tmp6_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->current_builder;
	_tmp1_ = t;
	_tmp2_ = valadoc_content_text_get_content (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) -1);
	_tmp5_ = _tmp4_;
	g_string_append (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = t;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp6_, (ValadocContentContentVisitor*) self);
}


static void gtkdoc_comment_converter_class_init (GtkdocCommentConverterClass * klass) {
	gtkdoc_comment_converter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkdocCommentConverterPrivate));
	((ValadocContentContentVisitorClass *) klass)->visit_comment = (void (*) (ValadocContentContentVisitor *, ValadocContentComment*)) gtkdoc_comment_converter_real_visit_comment;
	((ValadocContentContentVisitorClass *) klass)->visit_embedded = (void (*) (ValadocContentContentVisitor *, ValadocContentEmbedded*)) gtkdoc_comment_converter_real_visit_embedded;
	((ValadocContentContentVisitorClass *) klass)->visit_headline = (void (*) (ValadocContentContentVisitor *, ValadocContentHeadline*)) gtkdoc_comment_converter_real_visit_headline;
	((ValadocContentContentVisitorClass *) klass)->visit_wiki_link = (void (*) (ValadocContentContentVisitor *, ValadocContentWikiLink*)) gtkdoc_comment_converter_real_visit_wiki_link;
	((ValadocContentContentVisitorClass *) klass)->visit_link = (void (*) (ValadocContentContentVisitor *, ValadocContentLink*)) gtkdoc_comment_converter_real_visit_link;
	((ValadocContentContentVisitorClass *) klass)->visit_symbol_link = (void (*) (ValadocContentContentVisitor *, ValadocContentSymbolLink*)) gtkdoc_comment_converter_real_visit_symbol_link;
	((ValadocContentContentVisitorClass *) klass)->visit_list = (void (*) (ValadocContentContentVisitor *, ValadocContentList*)) gtkdoc_comment_converter_real_visit_list;
	((ValadocContentContentVisitorClass *) klass)->visit_list_item = (void (*) (ValadocContentContentVisitor *, ValadocContentListItem*)) gtkdoc_comment_converter_real_visit_list_item;
	((ValadocContentContentVisitorClass *) klass)->visit_paragraph = (void (*) (ValadocContentContentVisitor *, ValadocContentParagraph*)) gtkdoc_comment_converter_real_visit_paragraph;
	((ValadocContentContentVisitorClass *) klass)->visit_warning = (void (*) (ValadocContentContentVisitor *, ValadocContentWarning*)) gtkdoc_comment_converter_real_visit_warning;
	((ValadocContentContentVisitorClass *) klass)->visit_note = (void (*) (ValadocContentContentVisitor *, ValadocContentNote*)) gtkdoc_comment_converter_real_visit_note;
	((ValadocContentContentVisitorClass *) klass)->visit_page = (void (*) (ValadocContentContentVisitor *, ValadocContentPage*)) gtkdoc_comment_converter_real_visit_page;
	((ValadocContentContentVisitorClass *) klass)->visit_run = (void (*) (ValadocContentContentVisitor *, ValadocContentRun*)) gtkdoc_comment_converter_real_visit_run;
	((ValadocContentContentVisitorClass *) klass)->visit_source_code = (void (*) (ValadocContentContentVisitor *, ValadocContentSourceCode*)) gtkdoc_comment_converter_real_visit_source_code;
	((ValadocContentContentVisitorClass *) klass)->visit_table = (void (*) (ValadocContentContentVisitor *, ValadocContentTable*)) gtkdoc_comment_converter_real_visit_table;
	((ValadocContentContentVisitorClass *) klass)->visit_table_row = (void (*) (ValadocContentContentVisitor *, ValadocContentTableRow*)) gtkdoc_comment_converter_real_visit_table_row;
	((ValadocContentContentVisitorClass *) klass)->visit_table_cell = (void (*) (ValadocContentContentVisitor *, ValadocContentTableCell*)) gtkdoc_comment_converter_real_visit_table_cell;
	((ValadocContentContentVisitorClass *) klass)->visit_taglet = (void (*) (ValadocContentContentVisitor *, ValadocContentTaglet*)) gtkdoc_comment_converter_real_visit_taglet;
	((ValadocContentContentVisitorClass *) klass)->visit_text = (void (*) (ValadocContentContentVisitor *, ValadocContentText*)) gtkdoc_comment_converter_real_visit_text;
	G_OBJECT_CLASS (klass)->finalize = gtkdoc_comment_converter_finalize;
}


static void gtkdoc_comment_converter_instance_init (GtkdocCommentConverter * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	gchar** _tmp4_;
	GString* _tmp5_;
	self->priv = GTKDOC_COMMENT_CONVERTER_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp0_);
	self->parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp2_);
	self->versioning = (ValaList*) _tmp3_;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	self->see_also = _tmp4_;
	self->see_also_length1 = 0;
	_tmp5_ = g_string_new ("");
	self->priv->current_builder = _tmp5_;
	self->priv->in_brief_comment = TRUE;
}


static void gtkdoc_comment_converter_finalize (GObject * obj) {
	GtkdocCommentConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverter);
	_g_object_unref0 (self->node_reference);
	_g_free0 (self->brief_comment);
	_g_free0 (self->long_comment);
	_g_free0 (self->returns);
	_vala_iterable_unref0 (self->parameters);
	_vala_iterable_unref0 (self->versioning);
	self->see_also = (_vala_array_free (self->see_also, self->see_also_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (self->priv->current_builder);
	_g_object_unref0 (self->priv->reporter);
	G_OBJECT_CLASS (gtkdoc_comment_converter_parent_class)->finalize (obj);
}


GType gtkdoc_comment_converter_get_type (void) {
	static volatile gsize gtkdoc_comment_converter_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_comment_converter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocCommentConverterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_comment_converter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocCommentConverter), 0, (GInstanceInitFunc) gtkdoc_comment_converter_instance_init, NULL };
		GType gtkdoc_comment_converter_type_id;
		gtkdoc_comment_converter_type_id = g_type_register_static (VALADOC_CONTENT_TYPE_CONTENT_VISITOR, "GtkdocCommentConverter", &g_define_type_info, 0);
		g_once_init_leave (&gtkdoc_comment_converter_type_id__volatile, gtkdoc_comment_converter_type_id);
	}
	return gtkdoc_comment_converter_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



