/* valaloop.c generated by valac, the Vala compiler
 * generated from valaloop.vala, do not modify */

/* valaloop.vala
 *
 * Copyright (C) 2009-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"

enum  {
	VALA_LOOP_DUMMY_PROPERTY,
	VALA_LOOP_LAST_PROPERTY
};
static GParamSpec* vala_loop_properties[VALA_LOOP_LAST_PROPERTY];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaLoopPrivate {
	ValaBlock* _body;
};


static gpointer vala_loop_parent_class = NULL;
static ValaStatementIface * vala_loop_vala_statement_parent_iface = NULL;

#define VALA_LOOP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOOP, ValaLoopPrivate))
static void vala_loop_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_loop_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_loop_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_loop_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_loop_finalize (ValaCodeNode * obj);


/**
 * Creates a new loop.
 *
 * @param body             loop body
 * @param source_reference reference to source code
 * @return                 newly created while statement
 */
ValaLoop* vala_loop_construct (GType object_type, ValaBlock* body, ValaSourceReference* source_reference) {
	ValaLoop* self = NULL;
	ValaBlock* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaLoop*) vala_code_node_construct (object_type);
	_tmp0_ = body;
	vala_loop_set_body (self, _tmp0_);
	_tmp1_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	return self;
}


ValaLoop* vala_loop_new (ValaBlock* body, ValaSourceReference* source_reference) {
	return vala_loop_construct (VALA_TYPE_LOOP, body, source_reference);
}


static void vala_loop_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaLoop * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaLoop*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_loop (_tmp0_, self);
}


static void vala_loop_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaLoop * self;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	self = (ValaLoop*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_loop_get_body (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
}


static gboolean vala_loop_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaLoop * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaBlock* _tmp7_;
	ValaBlock* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	self = (ValaLoop*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_loop_get_body (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	_tmp7_ = vala_loop_get_body (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp8_);
	_tmp10_ = _tmp9_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp10_);
	_vala_iterable_unref0 (_tmp10_);
	_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp12_ = _tmp11_;
	result = !_tmp12_;
	return result;
}


static void vala_loop_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaLoop * self;
	ValaCodeGenerator* _tmp0_;
	self = (ValaLoop*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = codegen;
	vala_code_visitor_visit_loop ((ValaCodeVisitor*) _tmp0_, self);
}


ValaBlock* vala_loop_get_body (ValaLoop* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_loop_set_body (ValaLoop* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp1_;
	_tmp2_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_loop_class_init (ValaLoopClass * klass) {
	vala_loop_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_loop_finalize;
	g_type_class_add_private (klass, sizeof (ValaLoopPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_loop_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_loop_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_loop_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_loop_real_emit;
}


static void vala_loop_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_loop_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_loop_instance_init (ValaLoop * self) {
	self->priv = VALA_LOOP_GET_PRIVATE (self);
}


static void vala_loop_finalize (ValaCodeNode * obj) {
	ValaLoop * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOOP, ValaLoop);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_loop_parent_class)->finalize (obj);
}


/**
 * Represents an endless loop.
 */
GType vala_loop_get_type (void) {
	static volatile gsize vala_loop_type_id__volatile = 0;
	if (g_once_init_enter (&vala_loop_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLoopClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_loop_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLoop), 0, (GInstanceInitFunc) vala_loop_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_loop_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_loop_type_id;
		vala_loop_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaLoop", &g_define_type_info, 0);
		g_type_add_interface_static (vala_loop_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_loop_type_id__volatile, vala_loop_type_id);
	}
	return vala_loop_type_id__volatile;
}



