/* valaflowanalyzer.c generated by valac, the Vala compiler
 * generated from valaflowanalyzer.vala, do not modify */

/* valaflowanalyzer.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET (vala_flow_analyzer_jump_target_get_type ())
#define VALA_FLOW_ANALYZER_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))

typedef struct _ValaFlowAnalyzerJumpTarget ValaFlowAnalyzerJumpTarget;
typedef struct _ValaFlowAnalyzerJumpTargetClass ValaFlowAnalyzerJumpTargetClass;
enum  {
	VALA_FLOW_ANALYZER_DUMMY_PROPERTY,
	VALA_FLOW_ANALYZER_LAST_PROPERTY
};
static GParamSpec* vala_flow_analyzer_properties[VALA_FLOW_ANALYZER_LAST_PROPERTY];
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_basic_block_unref0(var) ((var == NULL) ? NULL : (var = (vala_basic_block_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_flow_analyzer_jump_target_unref0(var) ((var == NULL) ? NULL : (var = (vala_flow_analyzer_jump_target_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_phi_function_unref0(var) ((var == NULL) ? NULL : (var = (vala_phi_function_unref (var), NULL)))
typedef struct _ValaFlowAnalyzerJumpTargetPrivate ValaFlowAnalyzerJumpTargetPrivate;
enum  {
	VALA_FLOW_ANALYZER_JUMP_TARGET_DUMMY_PROPERTY,
	VALA_FLOW_ANALYZER_JUMP_TARGET_LAST_PROPERTY
};
static GParamSpec* vala_flow_analyzer_jump_target_properties[VALA_FLOW_ANALYZER_JUMP_TARGET_LAST_PROPERTY];
typedef struct _ValaFlowAnalyzerParamSpecJumpTarget ValaFlowAnalyzerParamSpecJumpTarget;

struct _ValaFlowAnalyzerPrivate {
	ValaCodeContext* context;
	ValaBasicBlock* current_block;
	gboolean unreachable_reported;
	ValaList* jump_stack;
	ValaMap* var_map;
	ValaSet* used_vars;
	ValaMap* phi_functions;
};

struct _ValaFlowAnalyzerJumpTarget {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaFlowAnalyzerJumpTargetPrivate * priv;
};

struct _ValaFlowAnalyzerJumpTargetClass {
	GTypeClass parent_class;
	void (*finalize) (ValaFlowAnalyzerJumpTarget *self);
};

struct _ValaFlowAnalyzerJumpTargetPrivate {
	gboolean _is_break_target;
	gboolean _is_continue_target;
	gboolean _is_return_target;
	gboolean _is_exit_target;
	gboolean _is_error_target;
	ValaErrorDomain* _error_domain;
	ValaErrorCode* _error_code;
	ValaClass* _error_class;
	gboolean _is_finally_clause;
	ValaBasicBlock* _basic_block;
	ValaBasicBlock* _last_block;
	ValaCatchClause* _catch_clause;
};

struct _ValaFlowAnalyzerParamSpecJumpTarget {
	GParamSpec parent_instance;
};


static gpointer vala_flow_analyzer_parent_class = NULL;
static gpointer vala_flow_analyzer_jump_target_parent_class = NULL;

static gpointer vala_flow_analyzer_jump_target_ref (gpointer instance);
static void vala_flow_analyzer_jump_target_unref (gpointer instance);
static GParamSpec* vala_flow_analyzer_param_spec_jump_target (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void vala_flow_analyzer_value_set_jump_target (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void vala_flow_analyzer_value_take_jump_target (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_flow_analyzer_value_get_jump_target (const GValue* value) G_GNUC_UNUSED;
static GType vala_flow_analyzer_jump_target_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_FLOW_ANALYZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzerPrivate))
static void vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* le);
static void vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self);
static void vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self, ValaSubroutine* m);
static void vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_return_target (GType object_type, ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_exit_target (GType object_type, ValaBasicBlock* basic_block);
static void vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self, ValaBasicBlock* entry_block);
static ValaList* vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self, ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self, ValaList* block_list, ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self, ValaList* block_list, ValaBasicBlock* entry_block);
static void vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self, ValaList* block_list, ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self, ValaBasicBlock* entry_block);
static void vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self, ValaBasicBlock* current, ValaList* list);
static ValaBasicBlock* vala_flow_analyzer_intersect (ValaFlowAnalyzer* self, ValaBasicBlock** idoms, int idoms_length1, ValaBasicBlock* b1, ValaBasicBlock* b2);
static ValaMap* vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self, ValaList* block_list, ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self, ValaBasicBlock* block);
static ValaVariable* vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self, ValaMap* var_map, ValaVariable* var_symbol);
static void vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static gboolean vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self, ValaCodeNode* node);
static void vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self, ValaCodeNode* node, gboolean always_fail);
static void vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
static void vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static gboolean vala_flow_analyzer_always_true (ValaFlowAnalyzer* self, ValaExpression* condition);
static gboolean vala_flow_analyzer_always_false (ValaFlowAnalyzer* self, ValaExpression* condition);
static void vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_break_target (GType object_type, ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_continue_target (GType object_type, ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorDomain* vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorCode* vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt);
static void vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_any_target (GType object_type, ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block, ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type, ValaBasicBlock* basic_block, ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block, ValaCatchClause* catch_clause, ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaClass* error_class);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_error_target (GType object_type, ValaBasicBlock* basic_block, ValaCatchClause* catch_clause, ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaClass* error_class);
static ValaCatchClause* vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base, ValaUnlockStatement* stmt);
static void vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base, ValaExpression* expr);
#define VALA_FLOW_ANALYZER_JUMP_TARGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetPrivate))
static void vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self, ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self, gboolean value);
static void vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self, gboolean value);
static void vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self, gboolean value);
static void vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self, gboolean value);
static void vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self, ValaCatchClause* value);
static void vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self, ValaErrorDomain* value);
static void vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self, ValaErrorCode* value);
static void vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self, ValaClass* value);
static void vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self, gboolean value);
static void vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self, ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self, gboolean value);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new (void);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct (GType object_type);
static ValaClass* vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj);
static void vala_flow_analyzer_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ValaFlowAnalyzer* vala_flow_analyzer_construct (GType object_type) {
	ValaFlowAnalyzer* self = NULL;
	self = (ValaFlowAnalyzer*) vala_code_visitor_construct (object_type);
	return self;
}


ValaFlowAnalyzer* vala_flow_analyzer_new (void) {
	return vala_flow_analyzer_construct (VALA_TYPE_FLOW_ANALYZER);
}


/**
 * Build control flow graph in the specified context.
 *
 * @param context a code context
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void vala_flow_analyzer_analyze (ValaFlowAnalyzer* self, ValaCodeContext* context) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaList* source_files = NULL;
	ValaCodeContext* _tmp2_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = _vala_code_context_ref0 (_tmp0_);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = context;
	_tmp3_ = vala_code_context_get_source_files (_tmp2_);
	source_files = _tmp3_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _file_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _file_index = 0;
		_tmp4_ = source_files;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_file_list = _tmp5_;
		_tmp6_ = _file_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_file_size = _tmp8_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaSourceFile* _tmp15_;
			ValaSourceFileType _tmp16_;
			ValaSourceFileType _tmp17_;
			_tmp9_ = _file_index;
			_file_index = _tmp9_ + 1;
			_tmp10_ = _file_index;
			_tmp11_ = _file_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _file_list;
			_tmp13_ = _file_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			file = (ValaSourceFile*) _tmp14_;
			_tmp15_ = file;
			_tmp16_ = vala_source_file_get_file_type (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				ValaSourceFile* _tmp18_;
				_tmp18_ = file;
				vala_source_file_accept (_tmp18_, (ValaCodeVisitor*) self);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (source_files);
}


static void vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaFlowAnalyzer * self;
	ValaSourceFile* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = source_file;
	vala_source_file_accept_children (_tmp0_, (ValaCodeVisitor*) self);
}


static void vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaFlowAnalyzer * self;
	ValaClass* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaFlowAnalyzer * self;
	ValaStruct* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaFlowAnalyzer * self;
	ValaInterface* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaFlowAnalyzer * self;
	ValaEnum* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = en;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	ValaFlowAnalyzer * self;
	ValaErrorDomain* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (ed != NULL);
	_tmp0_ = ed;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	ValaField* _tmp1_;
	gboolean _tmp2_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (f != NULL);
	_tmp1_ = f;
	_tmp2_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp1_);
	if (_tmp2_) {
		ValaField* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = f;
		_tmp4_ = vala_symbol_get_used ((ValaSymbol*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp6_ = FALSE;
		ValaField* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = f;
		_tmp8_ = vala_symbol_is_private_symbol ((ValaSymbol*) _tmp7_);
		if (!_tmp8_) {
			gboolean _tmp9_ = FALSE;
			ValaCodeContext* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = self->priv->context;
			_tmp11_ = vala_code_context_get_internal_header_filename (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				_tmp9_ = TRUE;
			} else {
				ValaCodeContext* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = self->priv->context;
				_tmp14_ = vala_code_context_get_use_fast_vapi (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_;
			}
			_tmp6_ = _tmp9_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
		} else {
			ValaField* _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaField* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp16_ = f;
			_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = f;
			_tmp20_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup_printf ("field `%s' never used", _tmp21_);
			_tmp23_ = _tmp22_;
			vala_report_warning (_tmp18_, _tmp23_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp21_);
		}
	}
}


static gpointer _vala_basic_block_ref0 (gpointer self) {
	return self ? vala_basic_block_ref (self) : NULL;
}


static void vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* le) {
	ValaFlowAnalyzer * self;
	ValaBasicBlock* old_current_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	gboolean old_unreachable_reported = FALSE;
	gboolean _tmp2_;
	ValaList* old_jump_stack = NULL;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	ValaLambdaExpression* _tmp7_;
	ValaBasicBlock* _tmp8_;
	ValaList* _tmp9_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (le != NULL);
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	old_current_block = _tmp1_;
	_tmp2_ = self->priv->unreachable_reported;
	old_unreachable_reported = _tmp2_;
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = _vala_iterable_ref0 (_tmp3_);
	old_jump_stack = _tmp4_;
	vala_flow_analyzer_mark_unreachable (self);
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp5_);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = (ValaList*) _tmp6_;
	_tmp7_ = le;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp7_, (ValaCodeVisitor*) self);
	_tmp8_ = _vala_basic_block_ref0 (old_current_block);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp8_;
	self->priv->unreachable_reported = old_unreachable_reported;
	_tmp9_ = _vala_iterable_ref0 (old_jump_stack);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = _tmp9_;
	_vala_iterable_unref0 (old_jump_stack);
	_vala_basic_block_unref0 (old_current_block);
}


static void vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaMethod* _tmp5_;
	gboolean _tmp6_;
	ValaMethod* _tmp43_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	_tmp5_ = m;
	_tmp6_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp5_);
	if (_tmp6_) {
		ValaMethod* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = m;
		_tmp8_ = vala_symbol_get_used ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = !_tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaMethod* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = m;
		_tmp11_ = vala_method_get_entry_point (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp3_ = !_tmp12_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp13_ = m;
		_tmp14_ = vala_method_get_overrides (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp2_ = !_tmp15_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp16_ = FALSE;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		_tmp17_ = m;
		_tmp18_ = vala_method_get_base_interface_method (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ == NULL) {
			_tmp16_ = TRUE;
		} else {
			ValaMethod* _tmp20_;
			ValaMethod* _tmp21_;
			ValaMethod* _tmp22_;
			ValaMethod* _tmp23_;
			_tmp20_ = m;
			_tmp21_ = vala_method_get_base_interface_method (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = m;
			_tmp16_ = _tmp22_ == _tmp23_;
		}
		_tmp1_ = _tmp16_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaMethod* _tmp24_;
		_tmp24_ = m;
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_CREATION_METHOD);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp25_ = FALSE;
		ValaMethod* _tmp26_;
		gboolean _tmp27_;
		_tmp26_ = m;
		_tmp27_ = vala_symbol_is_private_symbol ((ValaSymbol*) _tmp26_);
		if (!_tmp27_) {
			gboolean _tmp28_ = FALSE;
			ValaCodeContext* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp29_ = self->priv->context;
			_tmp30_ = vala_code_context_get_internal_header_filename (_tmp29_);
			_tmp31_ = _tmp30_;
			if (_tmp31_ != NULL) {
				_tmp28_ = TRUE;
			} else {
				ValaCodeContext* _tmp32_;
				gboolean _tmp33_;
				gboolean _tmp34_;
				_tmp32_ = self->priv->context;
				_tmp33_ = vala_code_context_get_use_fast_vapi (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp28_ = _tmp34_;
			}
			_tmp25_ = _tmp28_;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
		} else {
			ValaMethod* _tmp35_;
			ValaSourceReference* _tmp36_;
			ValaSourceReference* _tmp37_;
			ValaMethod* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp35_ = m;
			_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = m;
			_tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strdup_printf ("method `%s' never used", _tmp40_);
			_tmp42_ = _tmp41_;
			vala_report_warning (_tmp37_, _tmp42_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
		}
	}
	_tmp43_ = m;
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) _tmp43_);
}


static void vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaFlowAnalyzer * self;
	ValaSignal* _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp2_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = sig;
	_tmp1_ = vala_signal_get_default_handler (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaSignal* _tmp3_;
		ValaMethod* _tmp4_;
		ValaMethod* _tmp5_;
		_tmp3_ = sig;
		_tmp4_ = vala_signal_get_default_handler (_tmp3_);
		_tmp5_ = _tmp4_;
		vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) _tmp5_);
	}
}


static void vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self, ValaSubroutine* m) {
	ValaSubroutine* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	ValaSubroutine* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaBasicBlock* _tmp5_;
	ValaSubroutine* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaBasicBlock* _tmp8_;
	ValaSubroutine* _tmp9_;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaSubroutine* _tmp12_;
	ValaBasicBlock* _tmp13_;
	ValaBasicBlock* _tmp14_;
	ValaSubroutine* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaSubroutine* _tmp18_;
	ValaBasicBlock* _tmp46_;
	ValaSubroutine* _tmp47_;
	ValaBasicBlock* _tmp48_;
	ValaBasicBlock* _tmp49_;
	ValaBasicBlock* _tmp50_;
	ValaBasicBlock* _tmp51_;
	ValaSubroutine* _tmp52_;
	ValaList* _tmp53_;
	ValaSubroutine* _tmp54_;
	ValaBasicBlock* _tmp55_;
	ValaBasicBlock* _tmp56_;
	ValaFlowAnalyzerJumpTarget* _tmp57_;
	ValaFlowAnalyzerJumpTarget* _tmp58_;
	ValaList* _tmp59_;
	ValaSubroutine* _tmp60_;
	ValaBasicBlock* _tmp61_;
	ValaBasicBlock* _tmp62_;
	ValaFlowAnalyzerJumpTarget* _tmp63_;
	ValaFlowAnalyzerJumpTarget* _tmp64_;
	ValaSubroutine* _tmp65_;
	ValaList* _tmp66_;
	ValaList* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	gpointer _tmp70_;
	ValaFlowAnalyzerJumpTarget* _tmp71_;
	ValaBasicBlock* _tmp72_;
	ValaSubroutine* _tmp84_;
	ValaBasicBlock* _tmp85_;
	ValaBasicBlock* _tmp86_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_subroutine_get_body (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = m;
	_tmp4_ = vala_basic_block_new_entry ();
	_tmp5_ = _tmp4_;
	vala_subroutine_set_entry_block (_tmp3_, _tmp5_);
	_vala_basic_block_unref0 (_tmp5_);
	_tmp6_ = m;
	_tmp7_ = vala_basic_block_new ();
	_tmp8_ = _tmp7_;
	vala_subroutine_set_return_block (_tmp6_, _tmp8_);
	_vala_basic_block_unref0 (_tmp8_);
	_tmp9_ = m;
	_tmp10_ = vala_basic_block_new_exit ();
	_tmp11_ = _tmp10_;
	vala_subroutine_set_exit_block (_tmp9_, _tmp11_);
	_vala_basic_block_unref0 (_tmp11_);
	_tmp12_ = m;
	_tmp13_ = vala_subroutine_get_return_block (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = m;
	_tmp16_ = vala_subroutine_get_exit_block (_tmp15_);
	_tmp17_ = _tmp16_;
	vala_basic_block_connect (_tmp14_, _tmp17_);
	_tmp18_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_METHOD)) {
		{
			ValaList* _param_list = NULL;
			ValaSubroutine* _tmp19_;
			ValaList* _tmp20_;
			gint _param_size = 0;
			ValaList* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _param_index = 0;
			_tmp19_ = m;
			_tmp20_ = vala_callable_get_parameters ((ValaCallable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_METHOD, ValaMethod));
			_param_list = _tmp20_;
			_tmp21_ = _param_list;
			_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
			_tmp23_ = _tmp22_;
			_param_size = _tmp23_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				ValaParameter* param = NULL;
				ValaList* _tmp27_;
				gint _tmp28_;
				gpointer _tmp29_;
				ValaParameter* _tmp30_;
				ValaParameterDirection _tmp31_;
				ValaParameterDirection _tmp32_;
				_tmp24_ = _param_index;
				_param_index = _tmp24_ + 1;
				_tmp25_ = _param_index;
				_tmp26_ = _param_size;
				if (!(_tmp25_ < _tmp26_)) {
					break;
				}
				_tmp27_ = _param_list;
				_tmp28_ = _param_index;
				_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
				param = (ValaParameter*) _tmp29_;
				_tmp30_ = param;
				_tmp31_ = vala_parameter_get_direction (_tmp30_);
				_tmp32_ = _tmp31_;
				if (_tmp32_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaMemberAccess* param_ma = NULL;
					ValaParameter* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					ValaParameter* _tmp36_;
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaMemberAccess* _tmp39_;
					ValaMemberAccess* _tmp40_;
					ValaParameter* _tmp41_;
					ValaSubroutine* _tmp42_;
					ValaBasicBlock* _tmp43_;
					ValaBasicBlock* _tmp44_;
					ValaMemberAccess* _tmp45_;
					_tmp33_ = param;
					_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = param;
					_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = vala_member_access_new_simple (_tmp35_, _tmp38_);
					param_ma = _tmp39_;
					_tmp40_ = param_ma;
					_tmp41_ = param;
					vala_expression_set_symbol_reference ((ValaExpression*) _tmp40_, (ValaSymbol*) _tmp41_);
					_tmp42_ = m;
					_tmp43_ = vala_subroutine_get_return_block (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = param_ma;
					vala_basic_block_add_node (_tmp44_, (ValaCodeNode*) _tmp45_);
					_vala_code_node_unref0 (param_ma);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	}
	_tmp46_ = vala_basic_block_new ();
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp46_;
	_tmp47_ = m;
	_tmp48_ = vala_subroutine_get_entry_block (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = self->priv->current_block;
	vala_basic_block_connect (_tmp49_, _tmp50_);
	_tmp51_ = self->priv->current_block;
	_tmp52_ = m;
	vala_basic_block_add_node (_tmp51_, (ValaCodeNode*) _tmp52_);
	_tmp53_ = self->priv->jump_stack;
	_tmp54_ = m;
	_tmp55_ = vala_subroutine_get_return_block (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_flow_analyzer_jump_target_new_return_target (_tmp56_);
	_tmp58_ = _tmp57_;
	vala_collection_add ((ValaCollection*) _tmp53_, _tmp58_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp58_);
	_tmp59_ = self->priv->jump_stack;
	_tmp60_ = m;
	_tmp61_ = vala_subroutine_get_exit_block (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = vala_flow_analyzer_jump_target_new_exit_target (_tmp62_);
	_tmp64_ = _tmp63_;
	vala_collection_add ((ValaCollection*) _tmp59_, _tmp64_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp64_);
	_tmp65_ = m;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp65_, (ValaCodeVisitor*) self);
	_tmp66_ = self->priv->jump_stack;
	_tmp67_ = self->priv->jump_stack;
	_tmp68_ = vala_collection_get_size ((ValaCollection*) _tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = vala_list_remove_at (_tmp66_, _tmp69_ - 1);
	_tmp71_ = (ValaFlowAnalyzerJumpTarget*) _tmp70_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp71_);
	_tmp72_ = self->priv->current_block;
	if (_tmp72_ != NULL) {
		ValaSubroutine* _tmp73_;
		gboolean _tmp74_;
		gboolean _tmp75_;
		ValaBasicBlock* _tmp80_;
		ValaSubroutine* _tmp81_;
		ValaBasicBlock* _tmp82_;
		ValaBasicBlock* _tmp83_;
		_tmp73_ = m;
		_tmp74_ = vala_subroutine_get_has_result (_tmp73_);
		_tmp75_ = _tmp74_;
		if (_tmp75_) {
			ValaSubroutine* _tmp76_;
			ValaSourceReference* _tmp77_;
			ValaSourceReference* _tmp78_;
			ValaSubroutine* _tmp79_;
			_tmp76_ = m;
			_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp76_);
			_tmp78_ = _tmp77_;
			vala_report_error (_tmp78_, "missing return statement at end of subroutine body");
			_tmp79_ = m;
			vala_code_node_set_error ((ValaCodeNode*) _tmp79_, TRUE);
		}
		_tmp80_ = self->priv->current_block;
		_tmp81_ = m;
		_tmp82_ = vala_subroutine_get_return_block (_tmp81_);
		_tmp83_ = _tmp82_;
		vala_basic_block_connect (_tmp80_, _tmp83_);
	}
	_tmp84_ = m;
	_tmp85_ = vala_subroutine_get_entry_block (_tmp84_);
	_tmp86_ = _tmp85_;
	vala_flow_analyzer_analyze_body (self, _tmp86_);
}


static void vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self, ValaBasicBlock* entry_block) {
	ValaList* block_list = NULL;
	ValaBasicBlock* _tmp0_;
	ValaList* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaBasicBlock* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaBasicBlock* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = entry_block;
	_tmp1_ = vala_flow_analyzer_get_depth_first_list (self, _tmp0_);
	block_list = _tmp1_;
	_tmp2_ = entry_block;
	vala_flow_analyzer_build_dominator_tree (self, block_list, _tmp2_);
	_tmp3_ = entry_block;
	vala_flow_analyzer_build_dominator_frontier (self, block_list, _tmp3_);
	_tmp4_ = entry_block;
	vala_flow_analyzer_insert_phi_functions (self, block_list, _tmp4_);
	_tmp5_ = entry_block;
	vala_flow_analyzer_check_variables (self, _tmp5_);
	_vala_iterable_unref0 (block_list);
}


static ValaList* vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self, ValaBasicBlock* entry_block) {
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaBasicBlock* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp0_);
	list = _tmp1_;
	_tmp2_ = entry_block;
	vala_flow_analyzer_depth_first_traverse (self, _tmp2_, (ValaList*) list);
	result = (ValaList*) list;
	return result;
}


static void vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self, ValaBasicBlock* current, ValaList* list) {
	ValaBasicBlock* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaBasicBlock* _tmp3_;
	ValaBasicBlock* _tmp18_;
	ValaList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	ValaList* _tmp22_;
	ValaBasicBlock* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (list != NULL);
	_tmp0_ = current;
	_tmp1_ = vala_basic_block_get_postorder_visited (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = current;
	vala_basic_block_set_postorder_visited (_tmp3_, TRUE);
	{
		ValaList* _succ_list = NULL;
		ValaBasicBlock* _tmp4_;
		ValaList* _tmp5_;
		gint _succ_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _succ_index = 0;
		_tmp4_ = current;
		_tmp5_ = vala_basic_block_get_successors (_tmp4_);
		_succ_list = _tmp5_;
		_tmp6_ = _succ_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_succ_size = _tmp8_;
		_succ_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaBasicBlock* _tmp15_;
			ValaBasicBlock* _tmp16_;
			ValaList* _tmp17_;
			_tmp9_ = _succ_index;
			_succ_index = _tmp9_ + 1;
			_tmp10_ = _succ_index;
			_tmp11_ = _succ_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _succ_list;
			_tmp13_ = _succ_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			_tmp15_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp14_);
			succ = _tmp15_;
			_tmp16_ = succ;
			_tmp17_ = list;
			vala_flow_analyzer_depth_first_traverse (self, _tmp16_, _tmp17_);
			_vala_basic_block_unref0 (succ);
		}
		_vala_iterable_unref0 (_succ_list);
	}
	_tmp18_ = current;
	_tmp19_ = list;
	_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
	_tmp21_ = _tmp20_;
	vala_basic_block_set_postorder_number (_tmp18_, _tmp21_);
	_tmp22_ = list;
	_tmp23_ = current;
	vala_list_insert (_tmp22_, 0, _tmp23_);
}


static void vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self, ValaList* block_list, ValaBasicBlock* entry_block) {
	ValaBasicBlock** idoms = NULL;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValaBasicBlock** _tmp3_;
	gint idoms_length1;
	gint _idoms_size_;
	ValaBasicBlock** _tmp4_;
	gint _tmp4__length1;
	ValaBasicBlock* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	ValaBasicBlock* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaBasicBlock* _tmp10_;
	gboolean changed = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = block_list;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (ValaBasicBlock*, _tmp2_ + 1);
	idoms = _tmp3_;
	idoms_length1 = _tmp2_;
	_idoms_size_ = idoms_length1;
	_tmp4_ = idoms;
	_tmp4__length1 = idoms_length1;
	_tmp5_ = entry_block;
	_tmp6_ = vala_basic_block_get_postorder_number (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = entry_block;
	_tmp9_ = _vala_basic_block_ref0 (_tmp8_);
	_vala_basic_block_unref0 (_tmp4_[_tmp7_]);
	_tmp4_[_tmp7_] = _tmp9_;
	_tmp10_ = _tmp4_[_tmp7_];
	changed = TRUE;
	while (TRUE) {
		gboolean _tmp11_;
		_tmp11_ = changed;
		if (!_tmp11_) {
			break;
		}
		changed = FALSE;
		{
			ValaList* _block_list = NULL;
			ValaList* _tmp12_;
			ValaList* _tmp13_;
			gint _block_size = 0;
			ValaList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _block_index = 0;
			_tmp12_ = block_list;
			_tmp13_ = _vala_iterable_ref0 (_tmp12_);
			_block_list = _tmp13_;
			_tmp14_ = _block_list;
			_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			_block_size = _tmp16_;
			_block_index = -1;
			while (TRUE) {
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				ValaBasicBlock* block = NULL;
				ValaList* _tmp20_;
				gint _tmp21_;
				gpointer _tmp22_;
				ValaBasicBlock* _tmp23_;
				ValaBasicBlock* _tmp24_;
				ValaBasicBlock* new_idom = NULL;
				gboolean first = FALSE;
				ValaBasicBlock** _tmp49_;
				gint _tmp49__length1;
				ValaBasicBlock* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				ValaBasicBlock* _tmp53_;
				ValaBasicBlock* _tmp54_;
				_tmp17_ = _block_index;
				_block_index = _tmp17_ + 1;
				_tmp18_ = _block_index;
				_tmp19_ = _block_size;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = _block_list;
				_tmp21_ = _block_index;
				_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
				block = (ValaBasicBlock*) _tmp22_;
				_tmp23_ = block;
				_tmp24_ = entry_block;
				if (_tmp23_ == _tmp24_) {
					_vala_basic_block_unref0 (block);
					continue;
				}
				new_idom = NULL;
				first = TRUE;
				{
					ValaList* _pred_list = NULL;
					ValaBasicBlock* _tmp25_;
					ValaList* _tmp26_;
					gint _pred_size = 0;
					ValaList* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					gint _pred_index = 0;
					_tmp25_ = block;
					_tmp26_ = vala_basic_block_get_predecessors (_tmp25_);
					_pred_list = _tmp26_;
					_tmp27_ = _pred_list;
					_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
					_tmp29_ = _tmp28_;
					_pred_size = _tmp29_;
					_pred_index = -1;
					while (TRUE) {
						gint _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						ValaBasicBlock* pred = NULL;
						ValaList* _tmp33_;
						gint _tmp34_;
						gpointer _tmp35_;
						ValaBasicBlock* _tmp36_;
						ValaBasicBlock** _tmp37_;
						gint _tmp37__length1;
						ValaBasicBlock* _tmp38_;
						gint _tmp39_;
						gint _tmp40_;
						ValaBasicBlock* _tmp41_;
						_tmp30_ = _pred_index;
						_pred_index = _tmp30_ + 1;
						_tmp31_ = _pred_index;
						_tmp32_ = _pred_size;
						if (!(_tmp31_ < _tmp32_)) {
							break;
						}
						_tmp33_ = _pred_list;
						_tmp34_ = _pred_index;
						_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
						_tmp36_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp35_);
						pred = _tmp36_;
						_tmp37_ = idoms;
						_tmp37__length1 = idoms_length1;
						_tmp38_ = pred;
						_tmp39_ = vala_basic_block_get_postorder_number (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = _tmp37_[_tmp40_];
						if (_tmp41_ != NULL) {
							gboolean _tmp42_;
							_tmp42_ = first;
							if (_tmp42_) {
								ValaBasicBlock* _tmp43_;
								ValaBasicBlock* _tmp44_;
								_tmp43_ = pred;
								_tmp44_ = _vala_basic_block_ref0 (_tmp43_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp44_;
								first = FALSE;
							} else {
								ValaBasicBlock** _tmp45_;
								gint _tmp45__length1;
								ValaBasicBlock* _tmp46_;
								ValaBasicBlock* _tmp47_;
								ValaBasicBlock* _tmp48_;
								_tmp45_ = idoms;
								_tmp45__length1 = idoms_length1;
								_tmp46_ = pred;
								_tmp47_ = new_idom;
								_tmp48_ = vala_flow_analyzer_intersect (self, _tmp45_, _tmp45__length1, _tmp46_, _tmp47_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp48_;
							}
						}
						_vala_basic_block_unref0 (pred);
					}
					_vala_iterable_unref0 (_pred_list);
				}
				_tmp49_ = idoms;
				_tmp49__length1 = idoms_length1;
				_tmp50_ = block;
				_tmp51_ = vala_basic_block_get_postorder_number (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = _tmp49_[_tmp52_];
				_tmp54_ = new_idom;
				if (_tmp53_ != _tmp54_) {
					ValaBasicBlock** _tmp55_;
					gint _tmp55__length1;
					ValaBasicBlock* _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					ValaBasicBlock* _tmp59_;
					ValaBasicBlock* _tmp60_;
					ValaBasicBlock* _tmp61_;
					_tmp55_ = idoms;
					_tmp55__length1 = idoms_length1;
					_tmp56_ = block;
					_tmp57_ = vala_basic_block_get_postorder_number (_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = new_idom;
					_tmp60_ = _vala_basic_block_ref0 (_tmp59_);
					_vala_basic_block_unref0 (_tmp55_[_tmp58_]);
					_tmp55_[_tmp58_] = _tmp60_;
					_tmp61_ = _tmp55_[_tmp58_];
					changed = TRUE;
				}
				_vala_basic_block_unref0 (new_idom);
				_vala_basic_block_unref0 (block);
			}
			_vala_iterable_unref0 (_block_list);
		}
	}
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp62_;
		ValaList* _tmp63_;
		gint _block_size = 0;
		ValaList* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		gint _block_index = 0;
		_tmp62_ = block_list;
		_tmp63_ = _vala_iterable_ref0 (_tmp62_);
		_block_list = _tmp63_;
		_tmp64_ = _block_list;
		_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
		_tmp66_ = _tmp65_;
		_block_size = _tmp66_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp70_;
			gint _tmp71_;
			gpointer _tmp72_;
			ValaBasicBlock* _tmp73_;
			ValaBasicBlock* _tmp74_;
			ValaBasicBlock** _tmp75_;
			gint _tmp75__length1;
			ValaBasicBlock* _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			ValaBasicBlock* _tmp79_;
			ValaBasicBlock* _tmp80_;
			_tmp67_ = _block_index;
			_block_index = _tmp67_ + 1;
			_tmp68_ = _block_index;
			_tmp69_ = _block_size;
			if (!(_tmp68_ < _tmp69_)) {
				break;
			}
			_tmp70_ = _block_list;
			_tmp71_ = _block_index;
			_tmp72_ = vala_list_get (_tmp70_, _tmp71_);
			block = (ValaBasicBlock*) _tmp72_;
			_tmp73_ = block;
			_tmp74_ = entry_block;
			if (_tmp73_ == _tmp74_) {
				_vala_basic_block_unref0 (block);
				continue;
			}
			_tmp75_ = idoms;
			_tmp75__length1 = idoms_length1;
			_tmp76_ = block;
			_tmp77_ = vala_basic_block_get_postorder_number (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = _tmp75_[_tmp78_];
			_tmp80_ = block;
			vala_basic_block_add_child (_tmp79_, _tmp80_);
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	idoms = (_vala_array_free (idoms, idoms_length1, (GDestroyNotify) vala_basic_block_unref), NULL);
}


static ValaBasicBlock* vala_flow_analyzer_intersect (ValaFlowAnalyzer* self, ValaBasicBlock** idoms, int idoms_length1, ValaBasicBlock* b1, ValaBasicBlock* b2) {
	ValaBasicBlock* result = NULL;
	ValaBasicBlock* _tmp24_;
	ValaBasicBlock* _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (b1 != NULL, NULL);
	g_return_val_if_fail (b2 != NULL, NULL);
	while (TRUE) {
		ValaBasicBlock* _tmp0_;
		ValaBasicBlock* _tmp1_;
		_tmp0_ = b1;
		_tmp1_ = b2;
		if (!(_tmp0_ != _tmp1_)) {
			break;
		}
		while (TRUE) {
			ValaBasicBlock* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			ValaBasicBlock* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaBasicBlock** _tmp8_;
			gint _tmp8__length1;
			ValaBasicBlock* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaBasicBlock* _tmp12_;
			_tmp2_ = b1;
			_tmp3_ = vala_basic_block_get_postorder_number (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = b2;
			_tmp6_ = vala_basic_block_get_postorder_number (_tmp5_);
			_tmp7_ = _tmp6_;
			if (!(_tmp4_ < _tmp7_)) {
				break;
			}
			_tmp8_ = idoms;
			_tmp8__length1 = idoms_length1;
			_tmp9_ = b2;
			_tmp10_ = vala_basic_block_get_postorder_number (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp8_[_tmp11_];
			b1 = _tmp12_;
		}
		while (TRUE) {
			ValaBasicBlock* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaBasicBlock* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaBasicBlock** _tmp19_;
			gint _tmp19__length1;
			ValaBasicBlock* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			ValaBasicBlock* _tmp23_;
			_tmp13_ = b2;
			_tmp14_ = vala_basic_block_get_postorder_number (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = b1;
			_tmp17_ = vala_basic_block_get_postorder_number (_tmp16_);
			_tmp18_ = _tmp17_;
			if (!(_tmp15_ < _tmp18_)) {
				break;
			}
			_tmp19_ = idoms;
			_tmp19__length1 = idoms_length1;
			_tmp20_ = b2;
			_tmp21_ = vala_basic_block_get_postorder_number (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp19_[_tmp22_];
			b2 = _tmp23_;
		}
	}
	_tmp24_ = b1;
	_tmp25_ = _vala_basic_block_ref0 (_tmp24_);
	result = _tmp25_;
	return result;
}


static void vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self, ValaList* block_list, ValaBasicBlock* entry_block) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	{
		gint i = 0;
		ValaList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = block_list;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		i = _tmp2_ - 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				ValaBasicBlock* block = NULL;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ >= 0)) {
					break;
				}
				_tmp6_ = block_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				block = (ValaBasicBlock*) _tmp8_;
				{
					ValaList* _succ_list = NULL;
					ValaBasicBlock* _tmp9_;
					ValaList* _tmp10_;
					gint _succ_size = 0;
					ValaList* _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
					gint _succ_index = 0;
					_tmp9_ = block;
					_tmp10_ = vala_basic_block_get_successors (_tmp9_);
					_succ_list = _tmp10_;
					_tmp11_ = _succ_list;
					_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
					_tmp13_ = _tmp12_;
					_succ_size = _tmp13_;
					_succ_index = -1;
					while (TRUE) {
						gint _tmp14_;
						gint _tmp15_;
						gint _tmp16_;
						ValaBasicBlock* succ = NULL;
						ValaList* _tmp17_;
						gint _tmp18_;
						gpointer _tmp19_;
						ValaBasicBlock* _tmp20_;
						ValaBasicBlock* _tmp21_;
						ValaBasicBlock* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaBasicBlock* _tmp24_;
						_tmp14_ = _succ_index;
						_succ_index = _tmp14_ + 1;
						_tmp15_ = _succ_index;
						_tmp16_ = _succ_size;
						if (!(_tmp15_ < _tmp16_)) {
							break;
						}
						_tmp17_ = _succ_list;
						_tmp18_ = _succ_index;
						_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
						_tmp20_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp19_);
						succ = _tmp20_;
						_tmp21_ = succ;
						_tmp22_ = vala_basic_block_get_parent (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = block;
						if (_tmp23_ != _tmp24_) {
							ValaBasicBlock* _tmp25_;
							ValaBasicBlock* _tmp26_;
							_tmp25_ = block;
							_tmp26_ = succ;
							vala_basic_block_add_dominator_frontier (_tmp25_, _tmp26_);
						}
						_vala_basic_block_unref0 (succ);
					}
					_vala_iterable_unref0 (_succ_list);
				}
				{
					ValaList* _child_list = NULL;
					ValaBasicBlock* _tmp27_;
					ValaList* _tmp28_;
					gint _child_size = 0;
					ValaList* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					gint _child_index = 0;
					_tmp27_ = block;
					_tmp28_ = vala_basic_block_get_children (_tmp27_);
					_child_list = _tmp28_;
					_tmp29_ = _child_list;
					_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
					_tmp31_ = _tmp30_;
					_child_size = _tmp31_;
					_child_index = -1;
					while (TRUE) {
						gint _tmp32_;
						gint _tmp33_;
						gint _tmp34_;
						ValaBasicBlock* child = NULL;
						ValaList* _tmp35_;
						gint _tmp36_;
						gpointer _tmp37_;
						_tmp32_ = _child_index;
						_child_index = _tmp32_ + 1;
						_tmp33_ = _child_index;
						_tmp34_ = _child_size;
						if (!(_tmp33_ < _tmp34_)) {
							break;
						}
						_tmp35_ = _child_list;
						_tmp36_ = _child_index;
						_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
						child = (ValaBasicBlock*) _tmp37_;
						{
							ValaIterator* _child_frontier_it = NULL;
							ValaBasicBlock* _tmp38_;
							ValaSet* _tmp39_;
							ValaSet* _tmp40_;
							ValaIterator* _tmp41_;
							ValaIterator* _tmp42_;
							_tmp38_ = child;
							_tmp39_ = vala_basic_block_get_dominator_frontier (_tmp38_);
							_tmp40_ = _tmp39_;
							_tmp41_ = vala_iterable_iterator ((ValaIterable*) _tmp40_);
							_tmp42_ = _tmp41_;
							_vala_iterable_unref0 (_tmp40_);
							_child_frontier_it = _tmp42_;
							while (TRUE) {
								ValaIterator* _tmp43_;
								gboolean _tmp44_;
								ValaBasicBlock* child_frontier = NULL;
								ValaIterator* _tmp45_;
								gpointer _tmp46_;
								ValaBasicBlock* _tmp47_;
								ValaBasicBlock* _tmp48_;
								ValaBasicBlock* _tmp49_;
								ValaBasicBlock* _tmp50_;
								_tmp43_ = _child_frontier_it;
								_tmp44_ = vala_iterator_next (_tmp43_);
								if (!_tmp44_) {
									break;
								}
								_tmp45_ = _child_frontier_it;
								_tmp46_ = vala_iterator_get (_tmp45_);
								child_frontier = (ValaBasicBlock*) _tmp46_;
								_tmp47_ = child_frontier;
								_tmp48_ = vala_basic_block_get_parent (_tmp47_);
								_tmp49_ = _tmp48_;
								_tmp50_ = block;
								if (_tmp49_ != _tmp50_) {
									ValaBasicBlock* _tmp51_;
									ValaBasicBlock* _tmp52_;
									_tmp51_ = block;
									_tmp52_ = child_frontier;
									vala_basic_block_add_dominator_frontier (_tmp51_, _tmp52_);
								}
								_vala_basic_block_unref0 (child_frontier);
							}
							_vala_iterator_unref0 (_child_frontier_it);
						}
						_vala_basic_block_unref0 (child);
					}
					_vala_iterable_unref0 (_child_list);
				}
				_vala_basic_block_unref0 (block);
			}
		}
	}
}


static ValaMap* vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self, ValaList* block_list, ValaBasicBlock* entry_block) {
	ValaMap* result = NULL;
	ValaHashMap* map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (block_list != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SET, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	map = _tmp3_;
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _block_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _block_index = 0;
		_tmp4_ = block_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_block_list = _tmp5_;
		_tmp6_ = _block_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_block_size = _tmp8_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp15_;
			ValaArrayList* _tmp16_;
			_tmp9_ = _block_index;
			_block_index = _tmp9_ + 1;
			_tmp10_ = _block_index;
			_tmp11_ = _block_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _block_list;
			_tmp13_ = _block_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			block = (ValaBasicBlock*) _tmp14_;
			_tmp15_ = g_direct_equal;
			_tmp16_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp15_);
			defined_variables = _tmp16_;
			{
				ValaList* _node_list = NULL;
				ValaBasicBlock* _tmp17_;
				ValaList* _tmp18_;
				gint _node_size = 0;
				ValaList* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gint _node_index = 0;
				_tmp17_ = block;
				_tmp18_ = vala_basic_block_get_nodes (_tmp17_);
				_node_list = _tmp18_;
				_tmp19_ = _node_list;
				_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
				_tmp21_ = _tmp20_;
				_node_size = _tmp21_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					ValaCodeNode* node = NULL;
					ValaList* _tmp25_;
					gint _tmp26_;
					gpointer _tmp27_;
					ValaCodeNode* _tmp28_;
					ValaArrayList* _tmp29_;
					_tmp22_ = _node_index;
					_node_index = _tmp22_ + 1;
					_tmp23_ = _node_index;
					_tmp24_ = _node_size;
					if (!(_tmp23_ < _tmp24_)) {
						break;
					}
					_tmp25_ = _node_list;
					_tmp26_ = _node_index;
					_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
					node = (ValaCodeNode*) _tmp27_;
					_tmp28_ = node;
					_tmp29_ = defined_variables;
					vala_code_node_get_defined_variables (_tmp28_, (ValaCollection*) _tmp29_);
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp30_;
				ValaArrayList* _tmp31_;
				gint _variable_size = 0;
				ValaArrayList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _variable_index = 0;
				_tmp30_ = defined_variables;
				_tmp31_ = _vala_iterable_ref0 (_tmp30_);
				_variable_list = _tmp31_;
				_tmp32_ = _variable_list;
				_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				_variable_size = _tmp34_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp38_;
					gint _tmp39_;
					gpointer _tmp40_;
					ValaSet* block_set = NULL;
					ValaHashMap* _tmp41_;
					ValaVariable* _tmp42_;
					gpointer _tmp43_;
					ValaSet* _tmp44_;
					ValaSet* _tmp51_;
					ValaBasicBlock* _tmp52_;
					_tmp35_ = _variable_index;
					_variable_index = _tmp35_ + 1;
					_tmp36_ = _variable_index;
					_tmp37_ = _variable_size;
					if (!(_tmp36_ < _tmp37_)) {
						break;
					}
					_tmp38_ = _variable_list;
					_tmp39_ = _variable_index;
					_tmp40_ = vala_list_get ((ValaList*) _tmp38_, _tmp39_);
					variable = (ValaVariable*) _tmp40_;
					_tmp41_ = map;
					_tmp42_ = variable;
					_tmp43_ = vala_map_get ((ValaMap*) _tmp41_, _tmp42_);
					block_set = (ValaSet*) _tmp43_;
					_tmp44_ = block_set;
					if (_tmp44_ == NULL) {
						GHashFunc _tmp45_;
						GEqualFunc _tmp46_;
						ValaHashSet* _tmp47_;
						ValaHashMap* _tmp48_;
						ValaVariable* _tmp49_;
						ValaSet* _tmp50_;
						_tmp45_ = g_direct_hash;
						_tmp46_ = g_direct_equal;
						_tmp47_ = vala_hash_set_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp45_, _tmp46_);
						_vala_iterable_unref0 (block_set);
						block_set = (ValaSet*) _tmp47_;
						_tmp48_ = map;
						_tmp49_ = variable;
						_tmp50_ = block_set;
						vala_map_set ((ValaMap*) _tmp48_, _tmp49_, _tmp50_);
					}
					_tmp51_ = block_set;
					_tmp52_ = block;
					vala_collection_add ((ValaCollection*) _tmp51_, _tmp52_);
					_vala_iterable_unref0 (block_set);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	result = (ValaMap*) map;
	return result;
}


static void vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self, ValaList* block_list, ValaBasicBlock* entry_block) {
	ValaMap* assign = NULL;
	ValaList* _tmp0_;
	ValaBasicBlock* _tmp1_;
	ValaMap* _tmp2_;
	gint counter = 0;
	ValaArrayList* work_list = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValaHashMap* added = NULL;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GEqualFunc _tmp7_;
	ValaHashMap* _tmp8_;
	ValaHashMap* phi = NULL;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashMap* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = block_list;
	_tmp1_ = entry_block;
	_tmp2_ = vala_flow_analyzer_get_assignment_map (self, _tmp0_, _tmp1_);
	assign = _tmp2_;
	counter = 0;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp3_);
	work_list = _tmp4_;
	_tmp5_ = g_direct_hash;
	_tmp6_ = g_direct_equal;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp5_, _tmp6_, _tmp7_);
	added = _tmp8_;
	_tmp9_ = g_direct_hash;
	_tmp10_ = g_direct_equal;
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp9_, _tmp10_, _tmp11_);
	phi = _tmp12_;
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _block_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _block_index = 0;
		_tmp13_ = block_list;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_block_list = _tmp14_;
		_tmp15_ = _block_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_block_size = _tmp17_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp21_;
			gint _tmp22_;
			gpointer _tmp23_;
			ValaHashMap* _tmp24_;
			ValaBasicBlock* _tmp25_;
			ValaHashMap* _tmp26_;
			ValaBasicBlock* _tmp27_;
			_tmp18_ = _block_index;
			_block_index = _tmp18_ + 1;
			_tmp19_ = _block_index;
			_tmp20_ = _block_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _block_list;
			_tmp22_ = _block_index;
			_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
			block = (ValaBasicBlock*) _tmp23_;
			_tmp24_ = added;
			_tmp25_ = block;
			vala_map_set ((ValaMap*) _tmp24_, _tmp25_, (gpointer) ((gintptr) 0));
			_tmp26_ = phi;
			_tmp27_ = block;
			vala_map_set ((ValaMap*) _tmp26_, _tmp27_, (gpointer) ((gintptr) 0));
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	{
		ValaIterator* _variable_it = NULL;
		ValaMap* _tmp28_;
		ValaSet* _tmp29_;
		ValaSet* _tmp30_;
		ValaIterator* _tmp31_;
		ValaIterator* _tmp32_;
		_tmp28_ = assign;
		_tmp29_ = vala_map_get_keys (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_iterable_iterator ((ValaIterable*) _tmp30_);
		_tmp32_ = _tmp31_;
		_vala_iterable_unref0 (_tmp30_);
		_variable_it = _tmp32_;
		while (TRUE) {
			ValaIterator* _tmp33_;
			gboolean _tmp34_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp35_;
			gpointer _tmp36_;
			gint _tmp37_;
			_tmp33_ = _variable_it;
			_tmp34_ = vala_iterator_next (_tmp33_);
			if (!_tmp34_) {
				break;
			}
			_tmp35_ = _variable_it;
			_tmp36_ = vala_iterator_get (_tmp35_);
			variable = (ValaVariable*) _tmp36_;
			_tmp37_ = counter;
			counter = _tmp37_ + 1;
			{
				ValaIterator* _block_it = NULL;
				ValaMap* _tmp38_;
				ValaVariable* _tmp39_;
				gpointer _tmp40_;
				ValaSet* _tmp41_;
				ValaIterator* _tmp42_;
				ValaIterator* _tmp43_;
				_tmp38_ = assign;
				_tmp39_ = variable;
				_tmp40_ = vala_map_get (_tmp38_, _tmp39_);
				_tmp41_ = (ValaSet*) _tmp40_;
				_tmp42_ = vala_iterable_iterator ((ValaIterable*) _tmp41_);
				_tmp43_ = _tmp42_;
				_vala_iterable_unref0 (_tmp41_);
				_block_it = _tmp43_;
				while (TRUE) {
					ValaIterator* _tmp44_;
					gboolean _tmp45_;
					ValaBasicBlock* block = NULL;
					ValaIterator* _tmp46_;
					gpointer _tmp47_;
					ValaArrayList* _tmp48_;
					ValaBasicBlock* _tmp49_;
					ValaHashMap* _tmp50_;
					ValaBasicBlock* _tmp51_;
					gint _tmp52_;
					_tmp44_ = _block_it;
					_tmp45_ = vala_iterator_next (_tmp44_);
					if (!_tmp45_) {
						break;
					}
					_tmp46_ = _block_it;
					_tmp47_ = vala_iterator_get (_tmp46_);
					block = (ValaBasicBlock*) _tmp47_;
					_tmp48_ = work_list;
					_tmp49_ = block;
					vala_collection_add ((ValaCollection*) _tmp48_, _tmp49_);
					_tmp50_ = added;
					_tmp51_ = block;
					_tmp52_ = counter;
					vala_map_set ((ValaMap*) _tmp50_, _tmp51_, (gpointer) ((gintptr) _tmp52_));
					_vala_basic_block_unref0 (block);
				}
				_vala_iterator_unref0 (_block_it);
			}
			while (TRUE) {
				ValaArrayList* _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				ValaBasicBlock* block = NULL;
				ValaArrayList* _tmp56_;
				gpointer _tmp57_;
				_tmp53_ = work_list;
				_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
				_tmp55_ = _tmp54_;
				if (!(_tmp55_ > 0)) {
					break;
				}
				_tmp56_ = work_list;
				_tmp57_ = vala_list_remove_at ((ValaList*) _tmp56_, 0);
				block = (ValaBasicBlock*) _tmp57_;
				{
					ValaIterator* _frontier_it = NULL;
					ValaBasicBlock* _tmp58_;
					ValaSet* _tmp59_;
					ValaSet* _tmp60_;
					ValaIterator* _tmp61_;
					ValaIterator* _tmp62_;
					_tmp58_ = block;
					_tmp59_ = vala_basic_block_get_dominator_frontier (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = vala_iterable_iterator ((ValaIterable*) _tmp60_);
					_tmp62_ = _tmp61_;
					_vala_iterable_unref0 (_tmp60_);
					_frontier_it = _tmp62_;
					while (TRUE) {
						ValaIterator* _tmp63_;
						gboolean _tmp64_;
						ValaBasicBlock* frontier = NULL;
						ValaIterator* _tmp65_;
						gpointer _tmp66_;
						gint blockPhi = 0;
						ValaHashMap* _tmp67_;
						ValaBasicBlock* _tmp68_;
						gpointer _tmp69_;
						gint _tmp70_;
						gint _tmp71_;
						_tmp63_ = _frontier_it;
						_tmp64_ = vala_iterator_next (_tmp63_);
						if (!_tmp64_) {
							break;
						}
						_tmp65_ = _frontier_it;
						_tmp66_ = vala_iterator_get (_tmp65_);
						frontier = (ValaBasicBlock*) _tmp66_;
						_tmp67_ = phi;
						_tmp68_ = frontier;
						_tmp69_ = vala_map_get ((ValaMap*) _tmp67_, _tmp68_);
						blockPhi = (gint) ((gintptr) _tmp69_);
						_tmp70_ = blockPhi;
						_tmp71_ = counter;
						if (_tmp70_ < _tmp71_) {
							ValaBasicBlock* _tmp72_;
							ValaVariable* _tmp73_;
							ValaBasicBlock* _tmp74_;
							ValaList* _tmp75_;
							ValaList* _tmp76_;
							gint _tmp77_;
							gint _tmp78_;
							ValaPhiFunction* _tmp79_;
							ValaPhiFunction* _tmp80_;
							ValaHashMap* _tmp81_;
							ValaBasicBlock* _tmp82_;
							gint _tmp83_;
							gint block_added = 0;
							ValaHashMap* _tmp84_;
							ValaBasicBlock* _tmp85_;
							gpointer _tmp86_;
							gint _tmp87_;
							gint _tmp88_;
							_tmp72_ = frontier;
							_tmp73_ = variable;
							_tmp74_ = frontier;
							_tmp75_ = vala_basic_block_get_predecessors (_tmp74_);
							_tmp76_ = _tmp75_;
							_tmp77_ = vala_collection_get_size ((ValaCollection*) _tmp76_);
							_tmp78_ = _tmp77_;
							_tmp79_ = vala_phi_function_new (_tmp73_, _tmp78_);
							_tmp80_ = _tmp79_;
							vala_basic_block_add_phi_function (_tmp72_, _tmp80_);
							_vala_phi_function_unref0 (_tmp80_);
							_vala_iterable_unref0 (_tmp76_);
							_tmp81_ = phi;
							_tmp82_ = frontier;
							_tmp83_ = counter;
							vala_map_set ((ValaMap*) _tmp81_, _tmp82_, (gpointer) ((gintptr) _tmp83_));
							_tmp84_ = added;
							_tmp85_ = frontier;
							_tmp86_ = vala_map_get ((ValaMap*) _tmp84_, _tmp85_);
							block_added = (gint) ((gintptr) _tmp86_);
							_tmp87_ = block_added;
							_tmp88_ = counter;
							if (_tmp87_ < _tmp88_) {
								ValaHashMap* _tmp89_;
								ValaBasicBlock* _tmp90_;
								gint _tmp91_;
								ValaArrayList* _tmp92_;
								ValaBasicBlock* _tmp93_;
								_tmp89_ = added;
								_tmp90_ = frontier;
								_tmp91_ = counter;
								vala_map_set ((ValaMap*) _tmp89_, _tmp90_, (gpointer) ((gintptr) _tmp91_));
								_tmp92_ = work_list;
								_tmp93_ = frontier;
								vala_collection_add ((ValaCollection*) _tmp92_, _tmp93_);
							}
						}
						_vala_basic_block_unref0 (frontier);
					}
					_vala_iterator_unref0 (_frontier_it);
				}
				_vala_basic_block_unref0 (block);
			}
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	_vala_map_unref0 (phi);
	_vala_map_unref0 (added);
	_vala_iterable_unref0 (work_list);
	_vala_map_unref0 (assign);
}


static void vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self, ValaBasicBlock* entry_block) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaArrayList* used_vars_queue = NULL;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->var_map);
	self->priv->var_map = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_);
	_vala_iterable_unref0 (self->priv->used_vars);
	self->priv->used_vars = (ValaSet*) _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_PHI_FUNCTION, (GBoxedCopyFunc) vala_phi_function_ref, (GDestroyNotify) vala_phi_function_unref, _tmp7_, _tmp8_, _tmp9_);
	_vala_map_unref0 (self->priv->phi_functions);
	self->priv->phi_functions = (ValaMap*) _tmp10_;
	_tmp11_ = entry_block;
	vala_flow_analyzer_check_block_variables (self, _tmp11_);
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp12_);
	used_vars_queue = _tmp13_;
	{
		ValaIterator* _variable_it = NULL;
		ValaSet* _tmp14_;
		ValaIterator* _tmp15_;
		_tmp14_ = self->priv->used_vars;
		_tmp15_ = vala_iterable_iterator ((ValaIterable*) _tmp14_);
		_variable_it = _tmp15_;
		while (TRUE) {
			ValaIterator* _tmp16_;
			gboolean _tmp17_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp18_;
			gpointer _tmp19_;
			ValaArrayList* _tmp20_;
			ValaVariable* _tmp21_;
			_tmp16_ = _variable_it;
			_tmp17_ = vala_iterator_next (_tmp16_);
			if (!_tmp17_) {
				break;
			}
			_tmp18_ = _variable_it;
			_tmp19_ = vala_iterator_get (_tmp18_);
			variable = (ValaVariable*) _tmp19_;
			_tmp20_ = used_vars_queue;
			_tmp21_ = variable;
			vala_collection_add ((ValaCollection*) _tmp20_, _tmp21_);
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	while (TRUE) {
		ValaArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		ValaVariable* used_var = NULL;
		ValaArrayList* _tmp25_;
		gpointer _tmp26_;
		ValaPhiFunction* phi = NULL;
		ValaMap* _tmp27_;
		ValaVariable* _tmp28_;
		gpointer _tmp29_;
		ValaPhiFunction* _tmp30_;
		_tmp22_ = used_vars_queue;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		if (!(_tmp24_ > 0)) {
			break;
		}
		_tmp25_ = used_vars_queue;
		_tmp26_ = vala_list_remove_at ((ValaList*) _tmp25_, 0);
		used_var = (ValaVariable*) _tmp26_;
		_tmp27_ = self->priv->phi_functions;
		_tmp28_ = used_var;
		_tmp29_ = vala_map_get (_tmp27_, _tmp28_);
		phi = (ValaPhiFunction*) _tmp29_;
		_tmp30_ = phi;
		if (_tmp30_ != NULL) {
			{
				ValaList* _variable_list = NULL;
				ValaPhiFunction* _tmp31_;
				ValaList* _tmp32_;
				ValaList* _tmp33_;
				ValaList* _tmp34_;
				gint _variable_size = 0;
				ValaList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _variable_index = 0;
				_tmp31_ = phi;
				_tmp32_ = vala_phi_function_get_operands (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = _vala_iterable_ref0 (_tmp33_);
				_variable_list = _tmp34_;
				_tmp35_ = _variable_list;
				_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				_variable_size = _tmp37_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					ValaVariable* variable = NULL;
					ValaList* _tmp41_;
					gint _tmp42_;
					gpointer _tmp43_;
					ValaVariable* _tmp44_;
					ValaSet* _tmp62_;
					ValaVariable* _tmp63_;
					gboolean _tmp64_;
					_tmp38_ = _variable_index;
					_variable_index = _tmp38_ + 1;
					_tmp39_ = _variable_index;
					_tmp40_ = _variable_size;
					if (!(_tmp39_ < _tmp40_)) {
						break;
					}
					_tmp41_ = _variable_list;
					_tmp42_ = _variable_index;
					_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
					variable = (ValaVariable*) _tmp43_;
					_tmp44_ = variable;
					if (_tmp44_ == NULL) {
						ValaVariable* _tmp45_;
						_tmp45_ = used_var;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, VALA_TYPE_LOCAL_VARIABLE)) {
							ValaVariable* _tmp46_;
							ValaSourceReference* _tmp47_;
							ValaSourceReference* _tmp48_;
							ValaVariable* _tmp49_;
							const gchar* _tmp50_;
							const gchar* _tmp51_;
							gchar* _tmp52_;
							gchar* _tmp53_;
							_tmp46_ = used_var;
							_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp46_);
							_tmp48_ = _tmp47_;
							_tmp49_ = used_var;
							_tmp50_ = vala_symbol_get_name ((ValaSymbol*) _tmp49_);
							_tmp51_ = _tmp50_;
							_tmp52_ = g_strdup_printf ("use of possibly unassigned local variable `%s'", _tmp51_);
							_tmp53_ = _tmp52_;
							vala_report_error (_tmp48_, _tmp53_);
							_g_free0 (_tmp53_);
						} else {
							ValaVariable* _tmp54_;
							ValaSourceReference* _tmp55_;
							ValaSourceReference* _tmp56_;
							ValaVariable* _tmp57_;
							const gchar* _tmp58_;
							const gchar* _tmp59_;
							gchar* _tmp60_;
							gchar* _tmp61_;
							_tmp54_ = used_var;
							_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
							_tmp56_ = _tmp55_;
							_tmp57_ = used_var;
							_tmp58_ = vala_symbol_get_name ((ValaSymbol*) _tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = g_strdup_printf ("use of possibly unassigned parameter `%s'", _tmp59_);
							_tmp61_ = _tmp60_;
							vala_report_warning (_tmp56_, _tmp61_);
							_g_free0 (_tmp61_);
						}
						_vala_code_node_unref0 (variable);
						continue;
					}
					_tmp62_ = self->priv->used_vars;
					_tmp63_ = variable;
					_tmp64_ = vala_collection_contains ((ValaCollection*) _tmp62_, _tmp63_);
					if (!_tmp64_) {
						ValaVariable* _tmp65_;
						ValaVariable* _tmp66_;
						ValaSourceReference* _tmp67_;
						ValaSourceReference* _tmp68_;
						ValaSet* _tmp69_;
						ValaVariable* _tmp70_;
						ValaArrayList* _tmp71_;
						ValaVariable* _tmp72_;
						_tmp65_ = variable;
						_tmp66_ = used_var;
						_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp66_);
						_tmp68_ = _tmp67_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp65_, _tmp68_);
						_tmp69_ = self->priv->used_vars;
						_tmp70_ = variable;
						vala_collection_add ((ValaCollection*) _tmp69_, _tmp70_);
						_tmp71_ = used_vars_queue;
						_tmp72_ = variable;
						vala_collection_add ((ValaCollection*) _tmp71_, _tmp72_);
					}
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
		}
		_vala_phi_function_unref0 (phi);
		_vala_code_node_unref0 (used_var);
	}
	_vala_iterable_unref0 (used_vars_queue);
}


static void vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self, ValaBasicBlock* block) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	{
		ValaIterator* _phi_it = NULL;
		ValaBasicBlock* _tmp0_;
		ValaSet* _tmp1_;
		ValaSet* _tmp2_;
		ValaIterator* _tmp3_;
		ValaIterator* _tmp4_;
		_tmp0_ = block;
		_tmp1_ = vala_basic_block_get_phi_functions (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_vala_iterable_unref0 (_tmp2_);
		_phi_it = _tmp4_;
		while (TRUE) {
			ValaIterator* _tmp5_;
			gboolean _tmp6_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp7_;
			gpointer _tmp8_;
			ValaVariable* versioned_var = NULL;
			ValaMap* _tmp9_;
			ValaPhiFunction* _tmp10_;
			ValaVariable* _tmp11_;
			ValaVariable* _tmp12_;
			ValaVariable* _tmp13_;
			ValaMap* _tmp14_;
			ValaVariable* _tmp15_;
			ValaPhiFunction* _tmp16_;
			_tmp5_ = _phi_it;
			_tmp6_ = vala_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _phi_it;
			_tmp8_ = vala_iterator_get (_tmp7_);
			phi = (ValaPhiFunction*) _tmp8_;
			_tmp9_ = self->priv->var_map;
			_tmp10_ = phi;
			_tmp11_ = vala_phi_function_get_original_variable (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_flow_analyzer_process_assignment (self, _tmp9_, _tmp12_);
			versioned_var = _tmp13_;
			_tmp14_ = self->priv->phi_functions;
			_tmp15_ = versioned_var;
			_tmp16_ = phi;
			vala_map_set (_tmp14_, _tmp15_, _tmp16_);
			_vala_code_node_unref0 (versioned_var);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaBasicBlock* _tmp17_;
		ValaList* _tmp18_;
		gint _node_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _node_index = 0;
		_tmp17_ = block;
		_tmp18_ = vala_basic_block_get_nodes (_tmp17_);
		_node_list = _tmp18_;
		_tmp19_ = _node_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_node_size = _tmp21_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ValaArrayList* used_variables = NULL;
			GEqualFunc _tmp28_;
			ValaArrayList* _tmp29_;
			ValaCodeNode* _tmp30_;
			ValaArrayList* _tmp31_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp82_;
			ValaArrayList* _tmp83_;
			ValaCodeNode* _tmp84_;
			ValaArrayList* _tmp85_;
			_tmp22_ = _node_index;
			_node_index = _tmp22_ + 1;
			_tmp23_ = _node_index;
			_tmp24_ = _node_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _node_list;
			_tmp26_ = _node_index;
			_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
			node = (ValaCodeNode*) _tmp27_;
			_tmp28_ = g_direct_equal;
			_tmp29_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp28_);
			used_variables = _tmp29_;
			_tmp30_ = node;
			_tmp31_ = used_variables;
			vala_code_node_get_used_variables (_tmp30_, (ValaCollection*) _tmp31_);
			{
				ValaArrayList* _var_symbol_list = NULL;
				ValaArrayList* _tmp32_;
				ValaArrayList* _tmp33_;
				gint _var_symbol_size = 0;
				ValaArrayList* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint _var_symbol_index = 0;
				_tmp32_ = used_variables;
				_tmp33_ = _vala_iterable_ref0 (_tmp32_);
				_var_symbol_list = _tmp33_;
				_tmp34_ = _var_symbol_list;
				_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
				_tmp36_ = _tmp35_;
				_var_symbol_size = _tmp36_;
				_var_symbol_index = -1;
				while (TRUE) {
					gint _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					ValaVariable* var_symbol = NULL;
					ValaArrayList* _tmp40_;
					gint _tmp41_;
					gpointer _tmp42_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp43_;
					ValaVariable* _tmp44_;
					gpointer _tmp45_;
					gboolean _tmp46_ = FALSE;
					ValaList* _tmp47_;
					ValaVariable* versioned_variable = NULL;
					ValaList* _tmp68_;
					ValaList* _tmp69_;
					gint _tmp70_;
					gint _tmp71_;
					gpointer _tmp72_;
					ValaSet* _tmp73_;
					ValaVariable* _tmp74_;
					gboolean _tmp75_;
					ValaSet* _tmp80_;
					ValaVariable* _tmp81_;
					_tmp37_ = _var_symbol_index;
					_var_symbol_index = _tmp37_ + 1;
					_tmp38_ = _var_symbol_index;
					_tmp39_ = _var_symbol_size;
					if (!(_tmp38_ < _tmp39_)) {
						break;
					}
					_tmp40_ = _var_symbol_list;
					_tmp41_ = _var_symbol_index;
					_tmp42_ = vala_list_get ((ValaList*) _tmp40_, _tmp41_);
					var_symbol = (ValaVariable*) _tmp42_;
					_tmp43_ = self->priv->var_map;
					_tmp44_ = var_symbol;
					_tmp45_ = vala_map_get (_tmp43_, (ValaSymbol*) _tmp44_);
					variable_stack = (ValaList*) _tmp45_;
					_tmp47_ = variable_stack;
					if (_tmp47_ == NULL) {
						_tmp46_ = TRUE;
					} else {
						ValaList* _tmp48_;
						gint _tmp49_;
						gint _tmp50_;
						_tmp48_ = variable_stack;
						_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
						_tmp50_ = _tmp49_;
						_tmp46_ = _tmp50_ == 0;
					}
					if (_tmp46_) {
						ValaVariable* _tmp51_;
						_tmp51_ = var_symbol;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_LOCAL_VARIABLE)) {
							ValaCodeNode* _tmp52_;
							ValaSourceReference* _tmp53_;
							ValaSourceReference* _tmp54_;
							ValaVariable* _tmp55_;
							const gchar* _tmp56_;
							const gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp59_;
							_tmp52_ = node;
							_tmp53_ = vala_code_node_get_source_reference (_tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = var_symbol;
							_tmp56_ = vala_symbol_get_name ((ValaSymbol*) _tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = g_strdup_printf ("use of possibly unassigned local variable `%s'", _tmp57_);
							_tmp59_ = _tmp58_;
							vala_report_error (_tmp54_, _tmp59_);
							_g_free0 (_tmp59_);
						} else {
							ValaCodeNode* _tmp60_;
							ValaSourceReference* _tmp61_;
							ValaSourceReference* _tmp62_;
							ValaVariable* _tmp63_;
							const gchar* _tmp64_;
							const gchar* _tmp65_;
							gchar* _tmp66_;
							gchar* _tmp67_;
							_tmp60_ = node;
							_tmp61_ = vala_code_node_get_source_reference (_tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = var_symbol;
							_tmp64_ = vala_symbol_get_name ((ValaSymbol*) _tmp63_);
							_tmp65_ = _tmp64_;
							_tmp66_ = g_strdup_printf ("use of possibly unassigned parameter `%s'", _tmp65_);
							_tmp67_ = _tmp66_;
							vala_report_warning (_tmp62_, _tmp67_);
							_g_free0 (_tmp67_);
						}
						_vala_iterable_unref0 (variable_stack);
						_vala_code_node_unref0 (var_symbol);
						continue;
					}
					_tmp68_ = variable_stack;
					_tmp69_ = variable_stack;
					_tmp70_ = vala_collection_get_size ((ValaCollection*) _tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = vala_list_get (_tmp68_, _tmp71_ - 1);
					versioned_variable = (ValaVariable*) _tmp72_;
					_tmp73_ = self->priv->used_vars;
					_tmp74_ = versioned_variable;
					_tmp75_ = vala_collection_contains ((ValaCollection*) _tmp73_, _tmp74_);
					if (!_tmp75_) {
						ValaVariable* _tmp76_;
						ValaCodeNode* _tmp77_;
						ValaSourceReference* _tmp78_;
						ValaSourceReference* _tmp79_;
						_tmp76_ = versioned_variable;
						_tmp77_ = node;
						_tmp78_ = vala_code_node_get_source_reference (_tmp77_);
						_tmp79_ = _tmp78_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp76_, _tmp79_);
					}
					_tmp80_ = self->priv->used_vars;
					_tmp81_ = versioned_variable;
					vala_collection_add ((ValaCollection*) _tmp80_, _tmp81_);
					_vala_code_node_unref0 (versioned_variable);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (var_symbol);
				}
				_vala_iterable_unref0 (_var_symbol_list);
			}
			_tmp82_ = g_direct_equal;
			_tmp83_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp82_);
			defined_variables = _tmp83_;
			_tmp84_ = node;
			_tmp85_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp84_, (ValaCollection*) _tmp85_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp86_;
				ValaArrayList* _tmp87_;
				gint _variable_size = 0;
				ValaArrayList* _tmp88_;
				gint _tmp89_;
				gint _tmp90_;
				gint _variable_index = 0;
				_tmp86_ = defined_variables;
				_tmp87_ = _vala_iterable_ref0 (_tmp86_);
				_variable_list = _tmp87_;
				_tmp88_ = _variable_list;
				_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
				_tmp90_ = _tmp89_;
				_variable_size = _tmp90_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp91_;
					gint _tmp92_;
					gint _tmp93_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp94_;
					gint _tmp95_;
					gpointer _tmp96_;
					ValaMap* _tmp97_;
					ValaVariable* _tmp98_;
					ValaVariable* _tmp99_;
					ValaVariable* _tmp100_;
					_tmp91_ = _variable_index;
					_variable_index = _tmp91_ + 1;
					_tmp92_ = _variable_index;
					_tmp93_ = _variable_size;
					if (!(_tmp92_ < _tmp93_)) {
						break;
					}
					_tmp94_ = _variable_list;
					_tmp95_ = _variable_index;
					_tmp96_ = vala_list_get ((ValaList*) _tmp94_, _tmp95_);
					variable = (ValaVariable*) _tmp96_;
					_tmp97_ = self->priv->var_map;
					_tmp98_ = variable;
					_tmp99_ = vala_flow_analyzer_process_assignment (self, _tmp97_, _tmp98_);
					_tmp100_ = _tmp99_;
					_vala_code_node_unref0 (_tmp100_);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_iterable_unref0 (used_variables);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	{
		ValaList* _succ_list = NULL;
		ValaBasicBlock* _tmp101_;
		ValaList* _tmp102_;
		gint _succ_size = 0;
		ValaList* _tmp103_;
		gint _tmp104_;
		gint _tmp105_;
		gint _succ_index = 0;
		_tmp101_ = block;
		_tmp102_ = vala_basic_block_get_successors (_tmp101_);
		_succ_list = _tmp102_;
		_tmp103_ = _succ_list;
		_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
		_tmp105_ = _tmp104_;
		_succ_size = _tmp105_;
		_succ_index = -1;
		while (TRUE) {
			gint _tmp106_;
			gint _tmp107_;
			gint _tmp108_;
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp109_;
			gint _tmp110_;
			gpointer _tmp111_;
			ValaBasicBlock* _tmp112_;
			gint j = 0;
			_tmp106_ = _succ_index;
			_succ_index = _tmp106_ + 1;
			_tmp107_ = _succ_index;
			_tmp108_ = _succ_size;
			if (!(_tmp107_ < _tmp108_)) {
				break;
			}
			_tmp109_ = _succ_list;
			_tmp110_ = _succ_index;
			_tmp111_ = vala_list_get (_tmp109_, _tmp110_);
			_tmp112_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp111_);
			succ = _tmp112_;
			j = 0;
			{
				ValaList* _pred_list = NULL;
				ValaBasicBlock* _tmp113_;
				ValaList* _tmp114_;
				gint _pred_size = 0;
				ValaList* _tmp115_;
				gint _tmp116_;
				gint _tmp117_;
				gint _pred_index = 0;
				_tmp113_ = succ;
				_tmp114_ = vala_basic_block_get_predecessors (_tmp113_);
				_pred_list = _tmp114_;
				_tmp115_ = _pred_list;
				_tmp116_ = vala_collection_get_size ((ValaCollection*) _tmp115_);
				_tmp117_ = _tmp116_;
				_pred_size = _tmp117_;
				_pred_index = -1;
				while (TRUE) {
					gint _tmp118_;
					gint _tmp119_;
					gint _tmp120_;
					ValaBasicBlock* pred = NULL;
					ValaList* _tmp121_;
					gint _tmp122_;
					gpointer _tmp123_;
					ValaBasicBlock* _tmp124_;
					ValaBasicBlock* _tmp125_;
					ValaBasicBlock* _tmp126_;
					gint _tmp127_;
					_tmp118_ = _pred_index;
					_pred_index = _tmp118_ + 1;
					_tmp119_ = _pred_index;
					_tmp120_ = _pred_size;
					if (!(_tmp119_ < _tmp120_)) {
						break;
					}
					_tmp121_ = _pred_list;
					_tmp122_ = _pred_index;
					_tmp123_ = vala_list_get (_tmp121_, _tmp122_);
					_tmp124_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp123_);
					pred = _tmp124_;
					_tmp125_ = pred;
					_tmp126_ = block;
					if (_tmp125_ == _tmp126_) {
						_vala_basic_block_unref0 (pred);
						break;
					}
					_tmp127_ = j;
					j = _tmp127_ + 1;
					_vala_basic_block_unref0 (pred);
				}
				_vala_iterable_unref0 (_pred_list);
			}
			{
				ValaIterator* _phi_it = NULL;
				ValaBasicBlock* _tmp128_;
				ValaSet* _tmp129_;
				ValaSet* _tmp130_;
				ValaIterator* _tmp131_;
				ValaIterator* _tmp132_;
				_tmp128_ = succ;
				_tmp129_ = vala_basic_block_get_phi_functions (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_iterable_iterator ((ValaIterable*) _tmp130_);
				_tmp132_ = _tmp131_;
				_vala_iterable_unref0 (_tmp130_);
				_phi_it = _tmp132_;
				while (TRUE) {
					ValaIterator* _tmp133_;
					gboolean _tmp134_;
					ValaPhiFunction* phi = NULL;
					ValaIterator* _tmp135_;
					gpointer _tmp136_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp137_;
					ValaPhiFunction* _tmp138_;
					ValaVariable* _tmp139_;
					ValaVariable* _tmp140_;
					gpointer _tmp141_;
					gboolean _tmp142_ = FALSE;
					ValaList* _tmp143_;
					_tmp133_ = _phi_it;
					_tmp134_ = vala_iterator_next (_tmp133_);
					if (!_tmp134_) {
						break;
					}
					_tmp135_ = _phi_it;
					_tmp136_ = vala_iterator_get (_tmp135_);
					phi = (ValaPhiFunction*) _tmp136_;
					_tmp137_ = self->priv->var_map;
					_tmp138_ = phi;
					_tmp139_ = vala_phi_function_get_original_variable (_tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = vala_map_get (_tmp137_, (ValaSymbol*) _tmp140_);
					variable_stack = (ValaList*) _tmp141_;
					_tmp143_ = variable_stack;
					if (_tmp143_ != NULL) {
						ValaList* _tmp144_;
						gint _tmp145_;
						gint _tmp146_;
						_tmp144_ = variable_stack;
						_tmp145_ = vala_collection_get_size ((ValaCollection*) _tmp144_);
						_tmp146_ = _tmp145_;
						_tmp142_ = _tmp146_ > 0;
					} else {
						_tmp142_ = FALSE;
					}
					if (_tmp142_) {
						ValaPhiFunction* _tmp147_;
						ValaList* _tmp148_;
						ValaList* _tmp149_;
						gint _tmp150_;
						ValaList* _tmp151_;
						ValaList* _tmp152_;
						gint _tmp153_;
						gint _tmp154_;
						gpointer _tmp155_;
						ValaVariable* _tmp156_;
						_tmp147_ = phi;
						_tmp148_ = vala_phi_function_get_operands (_tmp147_);
						_tmp149_ = _tmp148_;
						_tmp150_ = j;
						_tmp151_ = variable_stack;
						_tmp152_ = variable_stack;
						_tmp153_ = vala_collection_get_size ((ValaCollection*) _tmp152_);
						_tmp154_ = _tmp153_;
						_tmp155_ = vala_list_get (_tmp151_, _tmp154_ - 1);
						_tmp156_ = (ValaVariable*) _tmp155_;
						vala_list_set (_tmp149_, _tmp150_, _tmp156_);
						_vala_code_node_unref0 (_tmp156_);
					}
					_vala_iterable_unref0 (variable_stack);
					_vala_phi_function_unref0 (phi);
				}
				_vala_iterator_unref0 (_phi_it);
			}
			_vala_basic_block_unref0 (succ);
		}
		_vala_iterable_unref0 (_succ_list);
	}
	{
		ValaList* _child_list = NULL;
		ValaBasicBlock* _tmp157_;
		ValaList* _tmp158_;
		gint _child_size = 0;
		ValaList* _tmp159_;
		gint _tmp160_;
		gint _tmp161_;
		gint _child_index = 0;
		_tmp157_ = block;
		_tmp158_ = vala_basic_block_get_children (_tmp157_);
		_child_list = _tmp158_;
		_tmp159_ = _child_list;
		_tmp160_ = vala_collection_get_size ((ValaCollection*) _tmp159_);
		_tmp161_ = _tmp160_;
		_child_size = _tmp161_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp162_;
			gint _tmp163_;
			gint _tmp164_;
			ValaBasicBlock* child = NULL;
			ValaList* _tmp165_;
			gint _tmp166_;
			gpointer _tmp167_;
			ValaBasicBlock* _tmp168_;
			_tmp162_ = _child_index;
			_child_index = _tmp162_ + 1;
			_tmp163_ = _child_index;
			_tmp164_ = _child_size;
			if (!(_tmp163_ < _tmp164_)) {
				break;
			}
			_tmp165_ = _child_list;
			_tmp166_ = _child_index;
			_tmp167_ = vala_list_get (_tmp165_, _tmp166_);
			child = (ValaBasicBlock*) _tmp167_;
			_tmp168_ = child;
			vala_flow_analyzer_check_block_variables (self, _tmp168_);
			_vala_basic_block_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	{
		ValaIterator* _phi_it = NULL;
		ValaBasicBlock* _tmp169_;
		ValaSet* _tmp170_;
		ValaSet* _tmp171_;
		ValaIterator* _tmp172_;
		ValaIterator* _tmp173_;
		_tmp169_ = block;
		_tmp170_ = vala_basic_block_get_phi_functions (_tmp169_);
		_tmp171_ = _tmp170_;
		_tmp172_ = vala_iterable_iterator ((ValaIterable*) _tmp171_);
		_tmp173_ = _tmp172_;
		_vala_iterable_unref0 (_tmp171_);
		_phi_it = _tmp173_;
		while (TRUE) {
			ValaIterator* _tmp174_;
			gboolean _tmp175_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp176_;
			gpointer _tmp177_;
			ValaList* variable_stack = NULL;
			ValaMap* _tmp178_;
			ValaPhiFunction* _tmp179_;
			ValaVariable* _tmp180_;
			ValaVariable* _tmp181_;
			gpointer _tmp182_;
			ValaList* _tmp183_;
			ValaList* _tmp184_;
			gint _tmp185_;
			gint _tmp186_;
			gpointer _tmp187_;
			ValaVariable* _tmp188_;
			_tmp174_ = _phi_it;
			_tmp175_ = vala_iterator_next (_tmp174_);
			if (!_tmp175_) {
				break;
			}
			_tmp176_ = _phi_it;
			_tmp177_ = vala_iterator_get (_tmp176_);
			phi = (ValaPhiFunction*) _tmp177_;
			_tmp178_ = self->priv->var_map;
			_tmp179_ = phi;
			_tmp180_ = vala_phi_function_get_original_variable (_tmp179_);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_map_get (_tmp178_, (ValaSymbol*) _tmp181_);
			variable_stack = (ValaList*) _tmp182_;
			_tmp183_ = variable_stack;
			_tmp184_ = variable_stack;
			_tmp185_ = vala_collection_get_size ((ValaCollection*) _tmp184_);
			_tmp186_ = _tmp185_;
			_tmp187_ = vala_list_remove_at (_tmp183_, _tmp186_ - 1);
			_tmp188_ = (ValaVariable*) _tmp187_;
			_vala_code_node_unref0 (_tmp188_);
			_vala_iterable_unref0 (variable_stack);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaBasicBlock* _tmp189_;
		ValaList* _tmp190_;
		gint _node_size = 0;
		ValaList* _tmp191_;
		gint _tmp192_;
		gint _tmp193_;
		gint _node_index = 0;
		_tmp189_ = block;
		_tmp190_ = vala_basic_block_get_nodes (_tmp189_);
		_node_list = _tmp190_;
		_tmp191_ = _node_list;
		_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
		_tmp193_ = _tmp192_;
		_node_size = _tmp193_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp194_;
			gint _tmp195_;
			gint _tmp196_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp197_;
			gint _tmp198_;
			gpointer _tmp199_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp200_;
			ValaArrayList* _tmp201_;
			ValaCodeNode* _tmp202_;
			ValaArrayList* _tmp203_;
			_tmp194_ = _node_index;
			_node_index = _tmp194_ + 1;
			_tmp195_ = _node_index;
			_tmp196_ = _node_size;
			if (!(_tmp195_ < _tmp196_)) {
				break;
			}
			_tmp197_ = _node_list;
			_tmp198_ = _node_index;
			_tmp199_ = vala_list_get (_tmp197_, _tmp198_);
			node = (ValaCodeNode*) _tmp199_;
			_tmp200_ = g_direct_equal;
			_tmp201_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp200_);
			defined_variables = _tmp201_;
			_tmp202_ = node;
			_tmp203_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp202_, (ValaCollection*) _tmp203_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp204_;
				ValaArrayList* _tmp205_;
				gint _variable_size = 0;
				ValaArrayList* _tmp206_;
				gint _tmp207_;
				gint _tmp208_;
				gint _variable_index = 0;
				_tmp204_ = defined_variables;
				_tmp205_ = _vala_iterable_ref0 (_tmp204_);
				_variable_list = _tmp205_;
				_tmp206_ = _variable_list;
				_tmp207_ = vala_collection_get_size ((ValaCollection*) _tmp206_);
				_tmp208_ = _tmp207_;
				_variable_size = _tmp208_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp209_;
					gint _tmp210_;
					gint _tmp211_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp212_;
					gint _tmp213_;
					gpointer _tmp214_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp215_;
					ValaVariable* _tmp216_;
					gpointer _tmp217_;
					ValaList* _tmp218_;
					ValaList* _tmp219_;
					gint _tmp220_;
					gint _tmp221_;
					gpointer _tmp222_;
					ValaVariable* _tmp223_;
					_tmp209_ = _variable_index;
					_variable_index = _tmp209_ + 1;
					_tmp210_ = _variable_index;
					_tmp211_ = _variable_size;
					if (!(_tmp210_ < _tmp211_)) {
						break;
					}
					_tmp212_ = _variable_list;
					_tmp213_ = _variable_index;
					_tmp214_ = vala_list_get ((ValaList*) _tmp212_, _tmp213_);
					variable = (ValaVariable*) _tmp214_;
					_tmp215_ = self->priv->var_map;
					_tmp216_ = variable;
					_tmp217_ = vala_map_get (_tmp215_, (ValaSymbol*) _tmp216_);
					variable_stack = (ValaList*) _tmp217_;
					_tmp218_ = variable_stack;
					_tmp219_ = variable_stack;
					_tmp220_ = vala_collection_get_size ((ValaCollection*) _tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_list_remove_at (_tmp218_, _tmp221_ - 1);
					_tmp223_ = (ValaVariable*) _tmp222_;
					_vala_code_node_unref0 (_tmp223_);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}


static ValaVariable* vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self, ValaMap* var_map, ValaVariable* var_symbol) {
	ValaVariable* result = NULL;
	ValaList* variable_stack = NULL;
	ValaMap* _tmp0_;
	ValaVariable* _tmp1_;
	gpointer _tmp2_;
	ValaList* _tmp3_;
	ValaVariable* versioned_var = NULL;
	ValaVariable* _tmp11_;
	ValaList* _tmp36_;
	ValaVariable* _tmp37_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (var_map != NULL, NULL);
	g_return_val_if_fail (var_symbol != NULL, NULL);
	_tmp0_ = var_map;
	_tmp1_ = var_symbol;
	_tmp2_ = vala_map_get (_tmp0_, (ValaSymbol*) _tmp1_);
	variable_stack = (ValaList*) _tmp2_;
	_tmp3_ = variable_stack;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		ValaMap* _tmp6_;
		ValaVariable* _tmp7_;
		ValaList* _tmp8_;
		ValaVariable* _tmp9_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (variable_stack);
		variable_stack = (ValaList*) _tmp5_;
		_tmp6_ = var_map;
		_tmp7_ = var_symbol;
		_tmp8_ = variable_stack;
		vala_map_set (_tmp6_, (ValaSymbol*) _tmp7_, _tmp8_);
		_tmp9_ = var_symbol;
		vala_variable_set_single_assignment (_tmp9_, TRUE);
	} else {
		ValaVariable* _tmp10_;
		_tmp10_ = var_symbol;
		vala_variable_set_single_assignment (_tmp10_, FALSE);
	}
	_tmp11_ = var_symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_LOCAL_VARIABLE)) {
		ValaVariable* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		ValaVariable* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		ValaVariable* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaLocalVariable* _tmp23_;
		_tmp12_ = var_symbol;
		_tmp13_ = vala_variable_get_variable_type (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_data_type_copy (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = var_symbol;
		_tmp18_ = vala_symbol_get_name ((ValaSymbol*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = var_symbol;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_local_variable_new (_tmp16_, _tmp19_, NULL, _tmp22_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp23_;
		_vala_code_node_unref0 (_tmp16_);
	} else {
		ValaVariable* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		ValaVariable* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		ValaVariable* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp24_ = var_symbol;
		_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = var_symbol;
		_tmp28_ = vala_variable_get_variable_type (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_data_type_copy (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = var_symbol;
		_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_parameter_new (_tmp26_, _tmp31_, _tmp34_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp35_;
		_vala_code_node_unref0 (_tmp31_);
	}
	_tmp36_ = variable_stack;
	_tmp37_ = versioned_var;
	vala_collection_add ((ValaCollection*) _tmp36_, _tmp37_);
	result = versioned_var;
	_vala_iterable_unref0 (variable_stack);
	return result;
}


static void vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaFlowAnalyzer * self;
	ValaCreationMethod* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	vala_code_visitor_visit_method ((ValaCodeVisitor*) self, (ValaMethod*) _tmp0_);
}


static void vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaFlowAnalyzer * self;
	ValaProperty* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	ValaFlowAnalyzer * self;
	ValaPropertyAccessor* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (acc != NULL);
	_tmp0_ = acc;
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) _tmp0_);
}


static void vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	ValaFlowAnalyzer * self;
	ValaBlock* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (b != NULL);
	_tmp0_ = b;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaDeclarationStatement* _tmp0_;
	ValaDeclarationStatement* _tmp1_;
	gboolean _tmp2_;
	ValaDeclarationStatement* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	ValaBasicBlock* _tmp23_;
	ValaDeclarationStatement* _tmp24_;
	ValaLocalVariable* local = NULL;
	ValaDeclarationStatement* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	ValaLocalVariable* _tmp28_;
	gboolean _tmp29_ = FALSE;
	ValaLocalVariable* _tmp30_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
	_tmp1_ = stmt;
	_tmp2_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp1_);
	if (_tmp2_) {
		ValaDeclarationStatement* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp3_ = stmt;
		_tmp4_ = vala_declaration_statement_get_declaration (_tmp3_);
		_tmp5_ = _tmp4_;
		vala_code_node_set_unreachable ((ValaCodeNode*) _tmp5_, TRUE);
		return;
	}
	_tmp6_ = stmt;
	_tmp7_ = vala_declaration_statement_get_declaration (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_used (_tmp8_);
	_tmp10_ = _tmp9_;
	if (!_tmp10_) {
		ValaDeclarationStatement* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaDeclarationStatement* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp11_ = stmt;
		_tmp12_ = vala_declaration_statement_get_declaration (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = stmt;
		_tmp17_ = vala_declaration_statement_get_declaration (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup_printf ("local variable `%s' declared but never used", _tmp20_);
		_tmp22_ = _tmp21_;
		vala_report_warning (_tmp15_, _tmp22_);
		_g_free0 (_tmp22_);
	}
	_tmp23_ = self->priv->current_block;
	_tmp24_ = stmt;
	vala_basic_block_add_node (_tmp23_, (ValaCodeNode*) _tmp24_);
	_tmp25_ = stmt;
	_tmp26_ = vala_declaration_statement_get_declaration (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp27_) : NULL);
	local = _tmp28_;
	_tmp30_ = local;
	if (_tmp30_ != NULL) {
		ValaLocalVariable* _tmp31_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		_tmp31_ = local;
		_tmp32_ = vala_variable_get_initializer ((ValaVariable*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp29_ = _tmp33_ != NULL;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		ValaLocalVariable* _tmp34_;
		ValaExpression* _tmp35_;
		ValaExpression* _tmp36_;
		_tmp34_ = local;
		_tmp35_ = vala_variable_get_initializer ((ValaVariable*) _tmp34_);
		_tmp36_ = _tmp35_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp36_, FALSE);
	}
	_vala_code_node_unref0 (local);
}


static void vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
	ValaFlowAnalyzer * self;
	ValaLocalVariable* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (local != NULL);
	_tmp0_ = local;
	_tmp1_ = vala_variable_get_initializer ((ValaVariable*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaLocalVariable* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp3_ = local;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) _tmp3_);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, (ValaCodeVisitor*) self);
	}
}


static void vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaExpressionStatement* _tmp0_;
	ValaExpressionStatement* _tmp1_;
	gboolean _tmp2_;
	ValaBasicBlock* _tmp3_;
	ValaExpressionStatement* _tmp4_;
	ValaExpressionStatement* _tmp5_;
	ValaExpressionStatement* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
	_tmp1_ = stmt;
	_tmp2_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->current_block;
	_tmp4_ = stmt;
	vala_basic_block_add_node (_tmp3_, (ValaCodeNode*) _tmp4_);
	_tmp5_ = stmt;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp5_, FALSE);
	_tmp6_ = stmt;
	_tmp7_ = vala_expression_statement_get_expression (_tmp6_);
	_tmp8_ = _tmp7_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_METHOD_CALL)) {
		ValaMethodCall* expr = NULL;
		ValaExpressionStatement* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaMethodCall* _tmp12_;
		ValaMemberAccess* ma = NULL;
		ValaMethodCall* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaMemberAccess* _tmp16_;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		ValaMemberAccess* _tmp19_;
		_tmp9_ = stmt;
		_tmp10_ = vala_expression_statement_get_expression (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
		expr = _tmp12_;
		_tmp13_ = expr;
		_tmp14_ = vala_method_call_get_call (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp15_) : NULL);
		ma = _tmp16_;
		_tmp19_ = ma;
		if (_tmp19_ != NULL) {
			ValaMemberAccess* _tmp20_;
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			_tmp20_ = ma;
			_tmp21_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp18_ = _tmp22_ != NULL;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaMemberAccess* _tmp23_;
			ValaSymbol* _tmp24_;
			ValaSymbol* _tmp25_;
			ValaAttribute* _tmp26_;
			ValaAttribute* _tmp27_;
			_tmp23_ = ma;
			_tmp24_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp25_, "NoReturn");
			_tmp27_ = _tmp26_;
			_tmp17_ = _tmp27_ != NULL;
			_vala_code_node_unref0 (_tmp27_);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			vala_flow_analyzer_mark_unreachable (self);
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (expr);
			return;
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
}


static gboolean vala_flow_analyzer_always_true (ValaFlowAnalyzer* self, ValaExpression* condition) {
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBooleanLiteral* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = condition;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) _tmp0_) : NULL);
	literal = _tmp1_;
	_tmp3_ = literal;
	if (_tmp3_ != NULL) {
		ValaBooleanLiteral* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = literal;
		_tmp5_ = vala_boolean_literal_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean vala_flow_analyzer_always_false (ValaFlowAnalyzer* self, ValaExpression* condition) {
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBooleanLiteral* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = condition;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) _tmp0_) : NULL);
	literal = _tmp1_;
	_tmp3_ = literal;
	if (_tmp3_ != NULL) {
		ValaBooleanLiteral* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = literal;
		_tmp5_ = vala_boolean_literal_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_vala_code_node_unref0 (literal);
	return result;
}


static void vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaIfStatement* _tmp0_;
	gboolean _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaIfStatement* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaIfStatement* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp9_;
	ValaBasicBlock* _tmp10_;
	ValaIfStatement* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	gboolean _tmp14_;
	ValaIfStatement* _tmp18_;
	ValaBlock* _tmp19_;
	ValaBlock* _tmp20_;
	ValaBasicBlock* last_true_block = NULL;
	ValaBasicBlock* _tmp21_;
	ValaBasicBlock* _tmp22_;
	ValaIfStatement* _tmp23_;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	gboolean _tmp26_;
	ValaIfStatement* _tmp30_;
	ValaBlock* _tmp31_;
	ValaBlock* _tmp32_;
	ValaBasicBlock* last_false_block = NULL;
	ValaBasicBlock* _tmp36_;
	ValaBasicBlock* _tmp37_;
	gboolean _tmp38_ = FALSE;
	ValaBasicBlock* _tmp39_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->current_block;
	_tmp3_ = stmt;
	_tmp4_ = vala_if_statement_get_condition (_tmp3_);
	_tmp5_ = _tmp4_;
	vala_basic_block_add_node (_tmp2_, (ValaCodeNode*) _tmp5_);
	_tmp6_ = stmt;
	_tmp7_ = vala_if_statement_get_condition (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp8_, FALSE);
	_tmp9_ = self->priv->current_block;
	_tmp10_ = _vala_basic_block_ref0 (_tmp9_);
	last_block = _tmp10_;
	_tmp11_ = stmt;
	_tmp12_ = vala_if_statement_get_condition (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_flow_analyzer_always_false (self, _tmp13_);
	if (_tmp14_) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp15_;
		ValaBasicBlock* _tmp16_;
		ValaBasicBlock* _tmp17_;
		_tmp15_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp15_;
		_tmp16_ = last_block;
		_tmp17_ = self->priv->current_block;
		vala_basic_block_connect (_tmp16_, _tmp17_);
	}
	_tmp18_ = stmt;
	_tmp19_ = vala_if_statement_get_true_statement (_tmp18_);
	_tmp20_ = _tmp19_;
	vala_code_node_accept ((ValaCodeNode*) _tmp20_, (ValaCodeVisitor*) self);
	_tmp21_ = self->priv->current_block;
	_tmp22_ = _vala_basic_block_ref0 (_tmp21_);
	last_true_block = _tmp22_;
	_tmp23_ = stmt;
	_tmp24_ = vala_if_statement_get_condition (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_flow_analyzer_always_true (self, _tmp25_);
	if (_tmp26_) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp27_;
		ValaBasicBlock* _tmp28_;
		ValaBasicBlock* _tmp29_;
		_tmp27_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp27_;
		_tmp28_ = last_block;
		_tmp29_ = self->priv->current_block;
		vala_basic_block_connect (_tmp28_, _tmp29_);
	}
	_tmp30_ = stmt;
	_tmp31_ = vala_if_statement_get_false_statement (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ != NULL) {
		ValaIfStatement* _tmp33_;
		ValaBlock* _tmp34_;
		ValaBlock* _tmp35_;
		_tmp33_ = stmt;
		_tmp34_ = vala_if_statement_get_false_statement (_tmp33_);
		_tmp35_ = _tmp34_;
		vala_code_node_accept ((ValaCodeNode*) _tmp35_, (ValaCodeVisitor*) self);
	}
	_tmp36_ = self->priv->current_block;
	_tmp37_ = _vala_basic_block_ref0 (_tmp36_);
	last_false_block = _tmp37_;
	_tmp39_ = last_true_block;
	if (_tmp39_ != NULL) {
		_tmp38_ = TRUE;
	} else {
		ValaBasicBlock* _tmp40_;
		_tmp40_ = last_false_block;
		_tmp38_ = _tmp40_ != NULL;
	}
	if (_tmp38_) {
		ValaBasicBlock* _tmp41_;
		ValaBasicBlock* _tmp42_;
		ValaBasicBlock* _tmp45_;
		_tmp41_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp41_;
		_tmp42_ = last_true_block;
		if (_tmp42_ != NULL) {
			ValaBasicBlock* _tmp43_;
			ValaBasicBlock* _tmp44_;
			_tmp43_ = last_true_block;
			_tmp44_ = self->priv->current_block;
			vala_basic_block_connect (_tmp43_, _tmp44_);
		}
		_tmp45_ = last_false_block;
		if (_tmp45_ != NULL) {
			ValaBasicBlock* _tmp46_;
			ValaBasicBlock* _tmp47_;
			_tmp46_ = last_false_block;
			_tmp47_ = self->priv->current_block;
			vala_basic_block_connect (_tmp46_, _tmp47_);
		}
	}
	_vala_basic_block_unref0 (last_false_block);
	_vala_basic_block_unref0 (last_true_block);
	_vala_basic_block_unref0 (last_block);
}


static void vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaSwitchStatement* _tmp0_;
	gboolean _tmp1_;
	ValaBasicBlock* after_switch_block = NULL;
	ValaBasicBlock* _tmp2_;
	ValaList* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaFlowAnalyzerJumpTarget* _tmp5_;
	ValaFlowAnalyzerJumpTarget* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaSwitchStatement* _tmp8_;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaBasicBlock* condition_block = NULL;
	ValaBasicBlock* _tmp11_;
	ValaBasicBlock* _tmp12_;
	ValaSwitchStatement* _tmp13_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	gboolean has_default_label = FALSE;
	gboolean _tmp51_;
	ValaBasicBlock* _tmp54_;
	ValaList* _tmp55_;
	ValaList* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gboolean _tmp59_;
	ValaList* _tmp62_;
	ValaList* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gpointer _tmp66_;
	ValaFlowAnalyzerJumpTarget* _tmp67_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_basic_block_new ();
	after_switch_block = _tmp2_;
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = after_switch_block;
	_tmp5_ = vala_flow_analyzer_jump_target_new_break_target (_tmp4_);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp6_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp6_);
	_tmp7_ = self->priv->current_block;
	_tmp8_ = stmt;
	_tmp9_ = vala_switch_statement_get_expression (_tmp8_);
	_tmp10_ = _tmp9_;
	vala_basic_block_add_node (_tmp7_, (ValaCodeNode*) _tmp10_);
	_tmp11_ = self->priv->current_block;
	_tmp12_ = _vala_basic_block_ref0 (_tmp11_);
	condition_block = _tmp12_;
	_tmp13_ = stmt;
	_tmp14_ = vala_switch_statement_get_expression (_tmp13_);
	_tmp15_ = _tmp14_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp15_, FALSE);
	has_default_label = FALSE;
	{
		ValaList* _section_list = NULL;
		ValaSwitchStatement* _tmp16_;
		ValaList* _tmp17_;
		gint _section_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _section_index = 0;
		_tmp16_ = stmt;
		_tmp17_ = vala_switch_statement_get_sections (_tmp16_);
		_section_list = _tmp17_;
		_tmp18_ = _section_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_section_size = _tmp20_;
		_section_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			ValaSwitchSection* section = NULL;
			ValaList* _tmp24_;
			gint _tmp25_;
			gpointer _tmp26_;
			ValaBasicBlock* _tmp27_;
			ValaBasicBlock* _tmp28_;
			ValaBasicBlock* _tmp29_;
			ValaSwitchSection* _tmp42_;
			gboolean _tmp43_;
			ValaBasicBlock* _tmp44_;
			_tmp21_ = _section_index;
			_section_index = _tmp21_ + 1;
			_tmp22_ = _section_index;
			_tmp23_ = _section_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _section_list;
			_tmp25_ = _section_index;
			_tmp26_ = vala_list_get (_tmp24_, _tmp25_);
			section = (ValaSwitchSection*) _tmp26_;
			_tmp27_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp27_;
			_tmp28_ = condition_block;
			_tmp29_ = self->priv->current_block;
			vala_basic_block_connect (_tmp28_, _tmp29_);
			{
				ValaList* _section_stmt_list = NULL;
				ValaSwitchSection* _tmp30_;
				ValaList* _tmp31_;
				gint _section_stmt_size = 0;
				ValaList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _section_stmt_index = 0;
				_tmp30_ = section;
				_tmp31_ = vala_block_get_statements ((ValaBlock*) _tmp30_);
				_section_stmt_list = _tmp31_;
				_tmp32_ = _section_stmt_list;
				_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				_section_stmt_size = _tmp34_;
				_section_stmt_index = -1;
				while (TRUE) {
					gint _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					ValaStatement* section_stmt = NULL;
					ValaList* _tmp38_;
					gint _tmp39_;
					gpointer _tmp40_;
					ValaStatement* _tmp41_;
					_tmp35_ = _section_stmt_index;
					_section_stmt_index = _tmp35_ + 1;
					_tmp36_ = _section_stmt_index;
					_tmp37_ = _section_stmt_size;
					if (!(_tmp36_ < _tmp37_)) {
						break;
					}
					_tmp38_ = _section_stmt_list;
					_tmp39_ = _section_stmt_index;
					_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
					section_stmt = (ValaStatement*) _tmp40_;
					_tmp41_ = section_stmt;
					vala_code_node_accept ((ValaCodeNode*) _tmp41_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (section_stmt);
				}
				_vala_iterable_unref0 (_section_stmt_list);
			}
			_tmp42_ = section;
			_tmp43_ = vala_switch_section_has_default_label (_tmp42_);
			if (_tmp43_) {
				has_default_label = TRUE;
			}
			_tmp44_ = self->priv->current_block;
			if (_tmp44_ != NULL) {
				ValaSwitchSection* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				ValaSwitchSection* _tmp48_;
				ValaBasicBlock* _tmp49_;
				ValaBasicBlock* _tmp50_;
				_tmp45_ = section;
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp47_, "missing break statement at end of switch section");
				_tmp48_ = section;
				vala_code_node_set_error ((ValaCodeNode*) _tmp48_, TRUE);
				_tmp49_ = self->priv->current_block;
				_tmp50_ = after_switch_block;
				vala_basic_block_connect (_tmp49_, _tmp50_);
			}
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	_tmp51_ = has_default_label;
	if (!_tmp51_) {
		ValaBasicBlock* _tmp52_;
		ValaBasicBlock* _tmp53_;
		_tmp52_ = condition_block;
		_tmp53_ = after_switch_block;
		vala_basic_block_connect (_tmp52_, _tmp53_);
	}
	_tmp54_ = after_switch_block;
	_tmp55_ = vala_basic_block_get_predecessors (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_collection_get_size ((ValaCollection*) _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = _tmp58_ > 0;
	_vala_iterable_unref0 (_tmp56_);
	if (_tmp59_) {
		ValaBasicBlock* _tmp60_;
		ValaBasicBlock* _tmp61_;
		_tmp60_ = after_switch_block;
		_tmp61_ = _vala_basic_block_ref0 (_tmp60_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp61_;
	} else {
		vala_flow_analyzer_mark_unreachable (self);
	}
	_tmp62_ = self->priv->jump_stack;
	_tmp63_ = self->priv->jump_stack;
	_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_list_remove_at (_tmp62_, _tmp65_ - 1);
	_tmp67_ = (ValaFlowAnalyzerJumpTarget*) _tmp66_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp67_);
	_vala_basic_block_unref0 (condition_block);
	_vala_basic_block_unref0 (after_switch_block);
}


static void vala_flow_analyzer_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt) {
	ValaFlowAnalyzer * self;
	ValaLoop* _tmp0_;
	gboolean _tmp1_;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp2_;
	ValaList* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaFlowAnalyzerJumpTarget* _tmp5_;
	ValaFlowAnalyzerJumpTarget* _tmp6_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp7_;
	ValaList* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaFlowAnalyzerJumpTarget* _tmp10_;
	ValaFlowAnalyzerJumpTarget* _tmp11_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp12_;
	ValaBasicBlock* _tmp13_;
	ValaBasicBlock* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaLoop* _tmp18_;
	ValaBlock* _tmp19_;
	ValaBlock* _tmp20_;
	ValaBasicBlock* _tmp21_;
	ValaBasicBlock* _tmp24_;
	ValaList* _tmp25_;
	ValaList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gboolean _tmp29_;
	ValaList* _tmp32_;
	ValaList* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gpointer _tmp36_;
	ValaFlowAnalyzerJumpTarget* _tmp37_;
	ValaList* _tmp38_;
	ValaList* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gpointer _tmp42_;
	ValaFlowAnalyzerJumpTarget* _tmp43_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_basic_block_new ();
	loop_block = _tmp2_;
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = loop_block;
	_tmp5_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp4_);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp6_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp6_);
	_tmp7_ = vala_basic_block_new ();
	after_loop_block = _tmp7_;
	_tmp8_ = self->priv->jump_stack;
	_tmp9_ = after_loop_block;
	_tmp10_ = vala_flow_analyzer_jump_target_new_break_target (_tmp9_);
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp8_, _tmp11_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp11_);
	_tmp12_ = self->priv->current_block;
	_tmp13_ = _vala_basic_block_ref0 (_tmp12_);
	last_block = _tmp13_;
	_tmp14_ = last_block;
	_tmp15_ = loop_block;
	vala_basic_block_connect (_tmp14_, _tmp15_);
	_tmp16_ = loop_block;
	_tmp17_ = _vala_basic_block_ref0 (_tmp16_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp17_;
	_tmp18_ = stmt;
	_tmp19_ = vala_loop_get_body (_tmp18_);
	_tmp20_ = _tmp19_;
	vala_code_node_accept ((ValaCodeNode*) _tmp20_, (ValaCodeVisitor*) self);
	_tmp21_ = self->priv->current_block;
	if (_tmp21_ != NULL) {
		ValaBasicBlock* _tmp22_;
		ValaBasicBlock* _tmp23_;
		_tmp22_ = self->priv->current_block;
		_tmp23_ = loop_block;
		vala_basic_block_connect (_tmp22_, _tmp23_);
	}
	_tmp24_ = after_loop_block;
	_tmp25_ = vala_basic_block_get_predecessors (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = _tmp28_ == 0;
	_vala_iterable_unref0 (_tmp26_);
	if (_tmp29_) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp30_;
		ValaBasicBlock* _tmp31_;
		_tmp30_ = after_loop_block;
		_tmp31_ = _vala_basic_block_ref0 (_tmp30_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp31_;
	}
	_tmp32_ = self->priv->jump_stack;
	_tmp33_ = self->priv->jump_stack;
	_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_list_remove_at (_tmp32_, _tmp35_ - 1);
	_tmp37_ = (ValaFlowAnalyzerJumpTarget*) _tmp36_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp37_);
	_tmp38_ = self->priv->jump_stack;
	_tmp39_ = self->priv->jump_stack;
	_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = vala_list_remove_at (_tmp38_, _tmp41_ - 1);
	_tmp43_ = (ValaFlowAnalyzerJumpTarget*) _tmp42_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp43_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}


static void vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaForeachStatement* _tmp0_;
	gboolean _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaForeachStatement* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaForeachStatement* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp9_;
	ValaList* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaFlowAnalyzerJumpTarget* _tmp12_;
	ValaFlowAnalyzerJumpTarget* _tmp13_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp14_;
	ValaList* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaFlowAnalyzerJumpTarget* _tmp17_;
	ValaFlowAnalyzerJumpTarget* _tmp18_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp19_;
	ValaBasicBlock* _tmp20_;
	ValaBasicBlock* _tmp21_;
	ValaBasicBlock* _tmp22_;
	ValaBasicBlock* _tmp23_;
	ValaBasicBlock* _tmp24_;
	ValaBasicBlock* _tmp25_;
	ValaForeachStatement* _tmp26_;
	ValaForeachStatement* _tmp27_;
	ValaBlock* _tmp28_;
	ValaBlock* _tmp29_;
	ValaBasicBlock* _tmp30_;
	ValaBasicBlock* _tmp33_;
	ValaBasicBlock* _tmp34_;
	ValaBasicBlock* _tmp35_;
	ValaBasicBlock* _tmp38_;
	ValaBasicBlock* _tmp39_;
	ValaList* _tmp40_;
	ValaList* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gpointer _tmp44_;
	ValaFlowAnalyzerJumpTarget* _tmp45_;
	ValaList* _tmp46_;
	ValaList* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gpointer _tmp50_;
	ValaFlowAnalyzerJumpTarget* _tmp51_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->current_block;
	_tmp3_ = stmt;
	_tmp4_ = vala_foreach_statement_get_collection (_tmp3_);
	_tmp5_ = _tmp4_;
	vala_basic_block_add_node (_tmp2_, (ValaCodeNode*) _tmp5_);
	_tmp6_ = stmt;
	_tmp7_ = vala_foreach_statement_get_collection (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp8_, FALSE);
	_tmp9_ = vala_basic_block_new ();
	loop_block = _tmp9_;
	_tmp10_ = self->priv->jump_stack;
	_tmp11_ = loop_block;
	_tmp12_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp11_);
	_tmp13_ = _tmp12_;
	vala_collection_add ((ValaCollection*) _tmp10_, _tmp13_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp13_);
	_tmp14_ = vala_basic_block_new ();
	after_loop_block = _tmp14_;
	_tmp15_ = self->priv->jump_stack;
	_tmp16_ = after_loop_block;
	_tmp17_ = vala_flow_analyzer_jump_target_new_break_target (_tmp16_);
	_tmp18_ = _tmp17_;
	vala_collection_add ((ValaCollection*) _tmp15_, _tmp18_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp18_);
	_tmp19_ = self->priv->current_block;
	_tmp20_ = _vala_basic_block_ref0 (_tmp19_);
	last_block = _tmp20_;
	_tmp21_ = last_block;
	_tmp22_ = loop_block;
	vala_basic_block_connect (_tmp21_, _tmp22_);
	_tmp23_ = loop_block;
	_tmp24_ = _vala_basic_block_ref0 (_tmp23_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp24_;
	_tmp25_ = self->priv->current_block;
	_tmp26_ = stmt;
	vala_basic_block_add_node (_tmp25_, (ValaCodeNode*) _tmp26_);
	_tmp27_ = stmt;
	_tmp28_ = vala_foreach_statement_get_body (_tmp27_);
	_tmp29_ = _tmp28_;
	vala_code_node_accept ((ValaCodeNode*) _tmp29_, (ValaCodeVisitor*) self);
	_tmp30_ = self->priv->current_block;
	if (_tmp30_ != NULL) {
		ValaBasicBlock* _tmp31_;
		ValaBasicBlock* _tmp32_;
		_tmp31_ = self->priv->current_block;
		_tmp32_ = loop_block;
		vala_basic_block_connect (_tmp31_, _tmp32_);
	}
	_tmp33_ = last_block;
	_tmp34_ = after_loop_block;
	vala_basic_block_connect (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->current_block;
	if (_tmp35_ != NULL) {
		ValaBasicBlock* _tmp36_;
		ValaBasicBlock* _tmp37_;
		_tmp36_ = self->priv->current_block;
		_tmp37_ = after_loop_block;
		vala_basic_block_connect (_tmp36_, _tmp37_);
	}
	_tmp38_ = after_loop_block;
	_tmp39_ = _vala_basic_block_ref0 (_tmp38_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp39_;
	_tmp40_ = self->priv->jump_stack;
	_tmp41_ = self->priv->jump_stack;
	_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_list_remove_at (_tmp40_, _tmp43_ - 1);
	_tmp45_ = (ValaFlowAnalyzerJumpTarget*) _tmp44_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp45_);
	_tmp46_ = self->priv->jump_stack;
	_tmp47_ = self->priv->jump_stack;
	_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_list_remove_at (_tmp46_, _tmp49_ - 1);
	_tmp51_ = (ValaFlowAnalyzerJumpTarget*) _tmp50_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp51_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}


static void vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaBreakStatement* _tmp0_;
	gboolean _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaBreakStatement* _tmp3_;
	ValaBreakStatement* _tmp31_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaBreakStatement* _tmp34_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->current_block;
	_tmp3_ = stmt;
	vala_basic_block_add_node (_tmp2_, (ValaCodeNode*) _tmp3_);
	{
		gint i = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->jump_stack;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		i = _tmp6_ - 1;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp10_;
				gint _tmp11_;
				gpointer _tmp12_;
				ValaFlowAnalyzerJumpTarget* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ - 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				if (!(_tmp9_ >= 0)) {
					break;
				}
				_tmp10_ = self->priv->jump_stack;
				_tmp11_ = i;
				_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp12_;
				_tmp13_ = jump_target;
				_tmp14_ = vala_flow_analyzer_jump_target_get_is_break_target (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_) {
					ValaBasicBlock* _tmp16_;
					ValaFlowAnalyzerJumpTarget* _tmp17_;
					ValaBasicBlock* _tmp18_;
					ValaBasicBlock* _tmp19_;
					_tmp16_ = self->priv->current_block;
					_tmp17_ = jump_target;
					_tmp18_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp17_);
					_tmp19_ = _tmp18_;
					vala_basic_block_connect (_tmp16_, _tmp19_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp20_;
					gboolean _tmp21_;
					gboolean _tmp22_;
					_tmp20_ = jump_target;
					_tmp21_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp20_);
					_tmp22_ = _tmp21_;
					if (_tmp22_) {
						ValaBasicBlock* _tmp23_;
						ValaFlowAnalyzerJumpTarget* _tmp24_;
						ValaBasicBlock* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaFlowAnalyzerJumpTarget* _tmp27_;
						ValaBasicBlock* _tmp28_;
						ValaBasicBlock* _tmp29_;
						ValaBasicBlock* _tmp30_;
						_tmp23_ = self->priv->current_block;
						_tmp24_ = jump_target;
						_tmp25_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp24_);
						_tmp26_ = _tmp25_;
						vala_basic_block_connect (_tmp23_, _tmp26_);
						_tmp27_ = jump_target;
						_tmp28_ = vala_flow_analyzer_jump_target_get_last_block (_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = _vala_basic_block_ref0 (_tmp29_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp30_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp31_ = stmt;
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
	_tmp33_ = _tmp32_;
	vala_report_error (_tmp33_, "no enclosing loop or switch statement found");
	_tmp34_ = stmt;
	vala_code_node_set_error ((ValaCodeNode*) _tmp34_, TRUE);
}


static void vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaContinueStatement* _tmp0_;
	gboolean _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaContinueStatement* _tmp3_;
	ValaContinueStatement* _tmp31_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaContinueStatement* _tmp34_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->current_block;
	_tmp3_ = stmt;
	vala_basic_block_add_node (_tmp2_, (ValaCodeNode*) _tmp3_);
	{
		gint i = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->jump_stack;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		i = _tmp6_ - 1;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp10_;
				gint _tmp11_;
				gpointer _tmp12_;
				ValaFlowAnalyzerJumpTarget* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ - 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				if (!(_tmp9_ >= 0)) {
					break;
				}
				_tmp10_ = self->priv->jump_stack;
				_tmp11_ = i;
				_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp12_;
				_tmp13_ = jump_target;
				_tmp14_ = vala_flow_analyzer_jump_target_get_is_continue_target (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_) {
					ValaBasicBlock* _tmp16_;
					ValaFlowAnalyzerJumpTarget* _tmp17_;
					ValaBasicBlock* _tmp18_;
					ValaBasicBlock* _tmp19_;
					_tmp16_ = self->priv->current_block;
					_tmp17_ = jump_target;
					_tmp18_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp17_);
					_tmp19_ = _tmp18_;
					vala_basic_block_connect (_tmp16_, _tmp19_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp20_;
					gboolean _tmp21_;
					gboolean _tmp22_;
					_tmp20_ = jump_target;
					_tmp21_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp20_);
					_tmp22_ = _tmp21_;
					if (_tmp22_) {
						ValaBasicBlock* _tmp23_;
						ValaFlowAnalyzerJumpTarget* _tmp24_;
						ValaBasicBlock* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaFlowAnalyzerJumpTarget* _tmp27_;
						ValaBasicBlock* _tmp28_;
						ValaBasicBlock* _tmp29_;
						ValaBasicBlock* _tmp30_;
						_tmp23_ = self->priv->current_block;
						_tmp24_ = jump_target;
						_tmp25_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp24_);
						_tmp26_ = _tmp25_;
						vala_basic_block_connect (_tmp23_, _tmp26_);
						_tmp27_ = jump_target;
						_tmp28_ = vala_flow_analyzer_jump_target_get_last_block (_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = _vala_basic_block_ref0 (_tmp29_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp30_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp31_ = stmt;
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
	_tmp33_ = _tmp32_;
	vala_report_error (_tmp33_, "no enclosing loop found");
	_tmp34_ = stmt;
	vala_code_node_set_error ((ValaCodeNode*) _tmp34_, TRUE);
}


static void vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaReturnStatement* _tmp0_;
	ValaReturnStatement* _tmp1_;
	gboolean _tmp2_;
	ValaBasicBlock* _tmp3_;
	ValaReturnStatement* _tmp4_;
	ValaReturnStatement* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaReturnStatement* _tmp38_;
	ValaSourceReference* _tmp39_;
	ValaSourceReference* _tmp40_;
	ValaReturnStatement* _tmp41_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
	_tmp1_ = stmt;
	_tmp2_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->current_block;
	_tmp4_ = stmt;
	vala_basic_block_add_node (_tmp3_, (ValaCodeNode*) _tmp4_);
	_tmp5_ = stmt;
	_tmp6_ = vala_return_statement_get_return_expression (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaReturnStatement* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = stmt;
		_tmp9_ = vala_return_statement_get_return_expression (_tmp8_);
		_tmp10_ = _tmp9_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp10_, FALSE);
	}
	{
		gint i = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = self->priv->jump_stack;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		i = _tmp13_ - 1;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint _tmp16_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				ValaFlowAnalyzerJumpTarget* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp22_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ - 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ >= 0)) {
					break;
				}
				_tmp17_ = self->priv->jump_stack;
				_tmp18_ = i;
				_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp19_;
				_tmp20_ = jump_target;
				_tmp21_ = vala_flow_analyzer_jump_target_get_is_return_target (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_) {
					ValaBasicBlock* _tmp23_;
					ValaFlowAnalyzerJumpTarget* _tmp24_;
					ValaBasicBlock* _tmp25_;
					ValaBasicBlock* _tmp26_;
					_tmp23_ = self->priv->current_block;
					_tmp24_ = jump_target;
					_tmp25_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp24_);
					_tmp26_ = _tmp25_;
					vala_basic_block_connect (_tmp23_, _tmp26_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp27_;
					gboolean _tmp28_;
					gboolean _tmp29_;
					_tmp27_ = jump_target;
					_tmp28_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp27_);
					_tmp29_ = _tmp28_;
					if (_tmp29_) {
						ValaBasicBlock* _tmp30_;
						ValaFlowAnalyzerJumpTarget* _tmp31_;
						ValaBasicBlock* _tmp32_;
						ValaBasicBlock* _tmp33_;
						ValaFlowAnalyzerJumpTarget* _tmp34_;
						ValaBasicBlock* _tmp35_;
						ValaBasicBlock* _tmp36_;
						ValaBasicBlock* _tmp37_;
						_tmp30_ = self->priv->current_block;
						_tmp31_ = jump_target;
						_tmp32_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp31_);
						_tmp33_ = _tmp32_;
						vala_basic_block_connect (_tmp30_, _tmp33_);
						_tmp34_ = jump_target;
						_tmp35_ = vala_flow_analyzer_jump_target_get_last_block (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = _vala_basic_block_ref0 (_tmp36_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp37_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp38_ = stmt;
	_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp38_);
	_tmp40_ = _tmp39_;
	vala_report_error (_tmp40_, "no enclosing loop found");
	_tmp41_ = stmt;
	vala_code_node_set_error ((ValaCodeNode*) _tmp41_, TRUE);
}


static void vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self, ValaCodeNode* node, gboolean always_fail) {
	ValaCodeNode* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_tree_can_fail (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ValaBasicBlock* last_block = NULL;
		ValaBasicBlock* _tmp3_;
		ValaBasicBlock* _tmp4_;
		gboolean _tmp100_;
		_tmp3_ = self->priv->current_block;
		_tmp4_ = _vala_basic_block_ref0 (_tmp3_);
		last_block = _tmp4_;
		{
			ValaList* _error_data_type_list = NULL;
			ValaCodeNode* _tmp5_;
			ValaList* _tmp6_;
			gint _error_data_type_size = 0;
			ValaList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _error_data_type_index = 0;
			_tmp5_ = node;
			_tmp6_ = vala_code_node_get_error_types (_tmp5_);
			_error_data_type_list = _tmp6_;
			_tmp7_ = _error_data_type_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_error_data_type_size = _tmp9_;
			_error_data_type_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				ValaDataType* error_data_type = NULL;
				ValaList* _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				ValaErrorType* error_type = NULL;
				ValaDataType* _tmp16_;
				ValaErrorType* _tmp17_;
				ValaBasicBlock* _tmp18_;
				ValaBasicBlock* _tmp19_;
				_tmp10_ = _error_data_type_index;
				_error_data_type_index = _tmp10_ + 1;
				_tmp11_ = _error_data_type_index;
				_tmp12_ = _error_data_type_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _error_data_type_list;
				_tmp14_ = _error_data_type_index;
				_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
				error_data_type = (ValaDataType*) _tmp15_;
				_tmp16_ = error_data_type;
				_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_ERROR_TYPE) ? ((ValaErrorType*) _tmp16_) : NULL);
				error_type = _tmp17_;
				_tmp18_ = last_block;
				_tmp19_ = _vala_basic_block_ref0 (_tmp18_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp19_;
				self->priv->unreachable_reported = TRUE;
				{
					gint i = 0;
					ValaList* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					_tmp20_ = self->priv->jump_stack;
					_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
					_tmp22_ = _tmp21_;
					i = _tmp22_ - 1;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							gint _tmp25_;
							ValaFlowAnalyzerJumpTarget* jump_target = NULL;
							ValaList* _tmp26_;
							gint _tmp27_;
							gpointer _tmp28_;
							ValaFlowAnalyzerJumpTarget* _tmp29_;
							gboolean _tmp30_;
							gboolean _tmp31_;
							if (!_tmp23_) {
								gint _tmp24_;
								_tmp24_ = i;
								i = _tmp24_ - 1;
							}
							_tmp23_ = FALSE;
							_tmp25_ = i;
							if (!(_tmp25_ >= 0)) {
								break;
							}
							_tmp26_ = self->priv->jump_stack;
							_tmp27_ = i;
							_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
							jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp28_;
							_tmp29_ = jump_target;
							_tmp30_ = vala_flow_analyzer_jump_target_get_is_exit_target (_tmp29_);
							_tmp31_ = _tmp30_;
							if (_tmp31_) {
								ValaBasicBlock* _tmp32_;
								ValaFlowAnalyzerJumpTarget* _tmp33_;
								ValaBasicBlock* _tmp34_;
								ValaBasicBlock* _tmp35_;
								_tmp32_ = self->priv->current_block;
								_tmp33_ = jump_target;
								_tmp34_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp33_);
								_tmp35_ = _tmp34_;
								vala_basic_block_connect (_tmp32_, _tmp35_);
								vala_flow_analyzer_mark_unreachable (self);
								_vala_flow_analyzer_jump_target_unref0 (jump_target);
								break;
							} else {
								ValaFlowAnalyzerJumpTarget* _tmp36_;
								gboolean _tmp37_;
								gboolean _tmp38_;
								_tmp36_ = jump_target;
								_tmp37_ = vala_flow_analyzer_jump_target_get_is_error_target (_tmp36_);
								_tmp38_ = _tmp37_;
								if (_tmp38_) {
									gboolean _tmp39_ = FALSE;
									ValaFlowAnalyzerJumpTarget* _tmp40_;
									ValaErrorDomain* _tmp41_;
									ValaErrorDomain* _tmp42_;
									_tmp40_ = jump_target;
									_tmp41_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp40_);
									_tmp42_ = _tmp41_;
									if (_tmp42_ == NULL) {
										_tmp39_ = TRUE;
									} else {
										gboolean _tmp43_ = FALSE;
										ValaFlowAnalyzerJumpTarget* _tmp44_;
										ValaErrorDomain* _tmp45_;
										ValaErrorDomain* _tmp46_;
										ValaErrorType* _tmp47_;
										ValaErrorDomain* _tmp48_;
										ValaErrorDomain* _tmp49_;
										_tmp44_ = jump_target;
										_tmp45_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp44_);
										_tmp46_ = _tmp45_;
										_tmp47_ = error_type;
										_tmp48_ = vala_error_type_get_error_domain (_tmp47_);
										_tmp49_ = _tmp48_;
										if (_tmp46_ == _tmp49_) {
											gboolean _tmp50_ = FALSE;
											ValaFlowAnalyzerJumpTarget* _tmp51_;
											ValaErrorCode* _tmp52_;
											ValaErrorCode* _tmp53_;
											_tmp51_ = jump_target;
											_tmp52_ = vala_flow_analyzer_jump_target_get_error_code (_tmp51_);
											_tmp53_ = _tmp52_;
											if (_tmp53_ == NULL) {
												_tmp50_ = TRUE;
											} else {
												ValaFlowAnalyzerJumpTarget* _tmp54_;
												ValaErrorCode* _tmp55_;
												ValaErrorCode* _tmp56_;
												ValaErrorType* _tmp57_;
												ValaErrorCode* _tmp58_;
												ValaErrorCode* _tmp59_;
												_tmp54_ = jump_target;
												_tmp55_ = vala_flow_analyzer_jump_target_get_error_code (_tmp54_);
												_tmp56_ = _tmp55_;
												_tmp57_ = error_type;
												_tmp58_ = vala_error_type_get_error_code (_tmp57_);
												_tmp59_ = _tmp58_;
												_tmp50_ = _tmp56_ == _tmp59_;
											}
											_tmp43_ = _tmp50_;
										} else {
											_tmp43_ = FALSE;
										}
										_tmp39_ = _tmp43_;
									}
									if (_tmp39_) {
										ValaBasicBlock* _tmp60_;
										ValaFlowAnalyzerJumpTarget* _tmp61_;
										ValaBasicBlock* _tmp62_;
										ValaBasicBlock* _tmp63_;
										_tmp60_ = self->priv->current_block;
										_tmp61_ = jump_target;
										_tmp62_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp61_);
										_tmp63_ = _tmp62_;
										vala_basic_block_connect (_tmp60_, _tmp63_);
										vala_flow_analyzer_mark_unreachable (self);
										_vala_flow_analyzer_jump_target_unref0 (jump_target);
										break;
									} else {
										gboolean _tmp64_ = FALSE;
										ValaErrorType* _tmp65_;
										ValaErrorDomain* _tmp66_;
										ValaErrorDomain* _tmp67_;
										_tmp65_ = error_type;
										_tmp66_ = vala_error_type_get_error_domain (_tmp65_);
										_tmp67_ = _tmp66_;
										if (_tmp67_ == NULL) {
											_tmp64_ = TRUE;
										} else {
											gboolean _tmp68_ = FALSE;
											ValaErrorType* _tmp69_;
											ValaErrorDomain* _tmp70_;
											ValaErrorDomain* _tmp71_;
											ValaFlowAnalyzerJumpTarget* _tmp72_;
											ValaErrorDomain* _tmp73_;
											ValaErrorDomain* _tmp74_;
											_tmp69_ = error_type;
											_tmp70_ = vala_error_type_get_error_domain (_tmp69_);
											_tmp71_ = _tmp70_;
											_tmp72_ = jump_target;
											_tmp73_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp72_);
											_tmp74_ = _tmp73_;
											if (_tmp71_ == _tmp74_) {
												gboolean _tmp75_ = FALSE;
												ValaErrorType* _tmp76_;
												ValaErrorCode* _tmp77_;
												ValaErrorCode* _tmp78_;
												_tmp76_ = error_type;
												_tmp77_ = vala_error_type_get_error_code (_tmp76_);
												_tmp78_ = _tmp77_;
												if (_tmp78_ == NULL) {
													_tmp75_ = TRUE;
												} else {
													ValaErrorType* _tmp79_;
													ValaErrorCode* _tmp80_;
													ValaErrorCode* _tmp81_;
													ValaFlowAnalyzerJumpTarget* _tmp82_;
													ValaErrorCode* _tmp83_;
													ValaErrorCode* _tmp84_;
													_tmp79_ = error_type;
													_tmp80_ = vala_error_type_get_error_code (_tmp79_);
													_tmp81_ = _tmp80_;
													_tmp82_ = jump_target;
													_tmp83_ = vala_flow_analyzer_jump_target_get_error_code (_tmp82_);
													_tmp84_ = _tmp83_;
													_tmp75_ = _tmp81_ == _tmp84_;
												}
												_tmp68_ = _tmp75_;
											} else {
												_tmp68_ = FALSE;
											}
											_tmp64_ = _tmp68_;
										}
										if (_tmp64_) {
											ValaBasicBlock* _tmp85_;
											ValaFlowAnalyzerJumpTarget* _tmp86_;
											ValaBasicBlock* _tmp87_;
											ValaBasicBlock* _tmp88_;
											_tmp85_ = self->priv->current_block;
											_tmp86_ = jump_target;
											_tmp87_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp86_);
											_tmp88_ = _tmp87_;
											vala_basic_block_connect (_tmp85_, _tmp88_);
										}
									}
								} else {
									ValaFlowAnalyzerJumpTarget* _tmp89_;
									gboolean _tmp90_;
									gboolean _tmp91_;
									_tmp89_ = jump_target;
									_tmp90_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp89_);
									_tmp91_ = _tmp90_;
									if (_tmp91_) {
										ValaBasicBlock* _tmp92_;
										ValaFlowAnalyzerJumpTarget* _tmp93_;
										ValaBasicBlock* _tmp94_;
										ValaBasicBlock* _tmp95_;
										ValaFlowAnalyzerJumpTarget* _tmp96_;
										ValaBasicBlock* _tmp97_;
										ValaBasicBlock* _tmp98_;
										ValaBasicBlock* _tmp99_;
										_tmp92_ = self->priv->current_block;
										_tmp93_ = jump_target;
										_tmp94_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp93_);
										_tmp95_ = _tmp94_;
										vala_basic_block_connect (_tmp92_, _tmp95_);
										_tmp96_ = jump_target;
										_tmp97_ = vala_flow_analyzer_jump_target_get_last_block (_tmp96_);
										_tmp98_ = _tmp97_;
										_tmp99_ = _vala_basic_block_ref0 (_tmp98_);
										_vala_basic_block_unref0 (self->priv->current_block);
										self->priv->current_block = _tmp99_;
									}
								}
							}
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
						}
					}
				}
				_vala_code_node_unref0 (error_type);
				_vala_code_node_unref0 (error_data_type);
			}
			_vala_iterable_unref0 (_error_data_type_list);
		}
		_tmp100_ = always_fail;
		if (!_tmp100_) {
			ValaBasicBlock* _tmp101_;
			ValaBasicBlock* _tmp102_;
			ValaBasicBlock* _tmp103_;
			_tmp101_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp101_;
			_tmp102_ = last_block;
			_tmp103_ = self->priv->current_block;
			vala_basic_block_connect (_tmp102_, _tmp103_);
		}
		_vala_basic_block_unref0 (last_block);
	}
}


static void vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaYieldStatement* _tmp0_;
	gboolean _tmp1_;
	ValaYieldStatement* _tmp2_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp2_, (ValaCodeVisitor*) self);
}


static void vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaThrowStatement* _tmp0_;
	gboolean _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaThrowStatement* _tmp3_;
	ValaThrowStatement* _tmp4_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->current_block;
	_tmp3_ = stmt;
	vala_basic_block_add_node (_tmp2_, (ValaCodeNode*) _tmp3_);
	_tmp4_ = stmt;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, TRUE);
}


static void vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaTryStatement* _tmp0_;
	gboolean _tmp1_;
	ValaBasicBlock* before_try_block = NULL;
	ValaBasicBlock* _tmp2_;
	ValaBasicBlock* _tmp3_;
	ValaBasicBlock* after_try_block = NULL;
	ValaBasicBlock* _tmp4_;
	ValaBasicBlock* finally_block = NULL;
	ValaTryStatement* _tmp5_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	gint finally_jump_stack_size = 0;
	ValaList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	ValaList* catch_clauses = NULL;
	ValaTryStatement* _tmp43_;
	ValaList* _tmp44_;
	ValaBasicBlock* _tmp81_;
	ValaBasicBlock* _tmp82_;
	ValaTryStatement* _tmp83_;
	ValaBlock* _tmp84_;
	ValaBlock* _tmp85_;
	ValaBasicBlock* _tmp86_;
	ValaList* catch_stack = NULL;
	GEqualFunc _tmp94_;
	ValaArrayList* _tmp95_;
	ValaBasicBlock* _tmp183_;
	ValaBasicBlock* _tmp190_;
	ValaList* _tmp191_;
	ValaList* _tmp192_;
	gint _tmp193_;
	gint _tmp194_;
	gboolean _tmp195_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->current_block;
	_tmp3_ = _vala_basic_block_ref0 (_tmp2_);
	before_try_block = _tmp3_;
	_tmp4_ = vala_basic_block_new ();
	after_try_block = _tmp4_;
	finally_block = NULL;
	_tmp5_ = stmt;
	_tmp6_ = vala_try_statement_get_finally_body (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaBasicBlock* _tmp8_;
		ValaBasicBlock* _tmp9_;
		ValaBasicBlock* _tmp10_;
		ValaBasicBlock* invalid_block = NULL;
		ValaBasicBlock* _tmp11_;
		ValaList* _tmp12_;
		ValaBasicBlock* _tmp13_;
		ValaFlowAnalyzerJumpTarget* _tmp14_;
		ValaFlowAnalyzerJumpTarget* _tmp15_;
		ValaTryStatement* _tmp16_;
		ValaBlock* _tmp17_;
		ValaBlock* _tmp18_;
		ValaBasicBlock* _tmp19_;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gboolean _tmp24_;
		ValaList* _tmp29_;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gpointer _tmp33_;
		ValaFlowAnalyzerJumpTarget* _tmp34_;
		ValaList* _tmp35_;
		ValaBasicBlock* _tmp36_;
		ValaBasicBlock* _tmp37_;
		ValaFlowAnalyzerJumpTarget* _tmp38_;
		ValaFlowAnalyzerJumpTarget* _tmp39_;
		_tmp8_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (finally_block);
		finally_block = _tmp8_;
		_tmp9_ = finally_block;
		_tmp10_ = _vala_basic_block_ref0 (_tmp9_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp10_;
		_tmp11_ = vala_basic_block_new ();
		invalid_block = _tmp11_;
		_tmp12_ = self->priv->jump_stack;
		_tmp13_ = invalid_block;
		_tmp14_ = vala_flow_analyzer_jump_target_new_any_target (_tmp13_);
		_tmp15_ = _tmp14_;
		vala_collection_add ((ValaCollection*) _tmp12_, _tmp15_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp15_);
		_tmp16_ = stmt;
		_tmp17_ = vala_try_statement_get_finally_body (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_code_node_accept ((ValaCodeNode*) _tmp18_, (ValaCodeVisitor*) self);
		_tmp19_ = invalid_block;
		_tmp20_ = vala_basic_block_get_predecessors (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_ > 0;
		_vala_iterable_unref0 (_tmp21_);
		if (_tmp24_) {
			ValaTryStatement* _tmp25_;
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaTryStatement* _tmp28_;
			_tmp25_ = stmt;
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "jump out of finally block not permitted");
			_tmp28_ = stmt;
			vala_code_node_set_error ((ValaCodeNode*) _tmp28_, TRUE);
			_vala_basic_block_unref0 (invalid_block);
			_vala_basic_block_unref0 (finally_block);
			_vala_basic_block_unref0 (after_try_block);
			_vala_basic_block_unref0 (before_try_block);
			return;
		}
		_tmp29_ = self->priv->jump_stack;
		_tmp30_ = self->priv->jump_stack;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_list_remove_at (_tmp29_, _tmp32_ - 1);
		_tmp34_ = (ValaFlowAnalyzerJumpTarget*) _tmp33_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp34_);
		_tmp35_ = self->priv->jump_stack;
		_tmp36_ = finally_block;
		_tmp37_ = self->priv->current_block;
		_tmp38_ = vala_flow_analyzer_jump_target_new_finally_clause (_tmp36_, _tmp37_);
		_tmp39_ = _tmp38_;
		vala_collection_add ((ValaCollection*) _tmp35_, _tmp39_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp39_);
		_vala_basic_block_unref0 (invalid_block);
	}
	_tmp40_ = self->priv->jump_stack;
	_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	finally_jump_stack_size = _tmp42_;
	_tmp43_ = stmt;
	_tmp44_ = vala_try_statement_get_catch_clauses (_tmp43_);
	catch_clauses = _tmp44_;
	{
		gint i = 0;
		ValaList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		_tmp45_ = catch_clauses;
		_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		i = _tmp47_ - 1;
		{
			gboolean _tmp48_ = FALSE;
			_tmp48_ = TRUE;
			while (TRUE) {
				gint _tmp50_;
				ValaCatchClause* catch_clause = NULL;
				ValaList* _tmp51_;
				gint _tmp52_;
				gpointer _tmp53_;
				ValaCatchClause* _tmp54_;
				ValaDataType* _tmp55_;
				ValaDataType* _tmp56_;
				if (!_tmp48_) {
					gint _tmp49_;
					_tmp49_ = i;
					i = _tmp49_ - 1;
				}
				_tmp48_ = FALSE;
				_tmp50_ = i;
				if (!(_tmp50_ >= 0)) {
					break;
				}
				_tmp51_ = catch_clauses;
				_tmp52_ = i;
				_tmp53_ = vala_list_get (_tmp51_, _tmp52_);
				catch_clause = (ValaCatchClause*) _tmp53_;
				_tmp54_ = catch_clause;
				_tmp55_ = vala_catch_clause_get_error_type (_tmp54_);
				_tmp56_ = _tmp55_;
				if (_tmp56_ != NULL) {
					ValaErrorType* error_type = NULL;
					ValaCatchClause* _tmp57_;
					ValaDataType* _tmp58_;
					ValaDataType* _tmp59_;
					ValaErrorType* _tmp60_;
					ValaList* _tmp61_;
					ValaBasicBlock* _tmp62_;
					ValaBasicBlock* _tmp63_;
					ValaCatchClause* _tmp64_;
					ValaCatchClause* _tmp65_;
					ValaDataType* _tmp66_;
					ValaDataType* _tmp67_;
					ValaTypeSymbol* _tmp68_;
					ValaTypeSymbol* _tmp69_;
					ValaErrorType* _tmp70_;
					ValaErrorCode* _tmp71_;
					ValaErrorCode* _tmp72_;
					ValaFlowAnalyzerJumpTarget* _tmp73_;
					ValaFlowAnalyzerJumpTarget* _tmp74_;
					_tmp57_ = catch_clause;
					_tmp58_ = vala_catch_clause_get_error_type (_tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					error_type = _tmp60_;
					_tmp61_ = self->priv->jump_stack;
					_tmp62_ = vala_basic_block_new ();
					_tmp63_ = _tmp62_;
					_tmp64_ = catch_clause;
					_tmp65_ = catch_clause;
					_tmp66_ = vala_catch_clause_get_error_type (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = vala_data_type_get_data_type (_tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = error_type;
					_tmp71_ = vala_error_type_get_error_code (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = vala_flow_analyzer_jump_target_new_error_target (_tmp63_, _tmp64_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALA_TYPE_ERROR_DOMAIN) ? ((ValaErrorDomain*) _tmp69_) : NULL, _tmp72_, NULL);
					_tmp74_ = _tmp73_;
					vala_collection_add ((ValaCollection*) _tmp61_, _tmp74_);
					_vala_flow_analyzer_jump_target_unref0 (_tmp74_);
					_vala_basic_block_unref0 (_tmp63_);
					_vala_code_node_unref0 (error_type);
				} else {
					ValaList* _tmp75_;
					ValaBasicBlock* _tmp76_;
					ValaBasicBlock* _tmp77_;
					ValaCatchClause* _tmp78_;
					ValaFlowAnalyzerJumpTarget* _tmp79_;
					ValaFlowAnalyzerJumpTarget* _tmp80_;
					_tmp75_ = self->priv->jump_stack;
					_tmp76_ = vala_basic_block_new ();
					_tmp77_ = _tmp76_;
					_tmp78_ = catch_clause;
					_tmp79_ = vala_flow_analyzer_jump_target_new_error_target (_tmp77_, _tmp78_, NULL, NULL, NULL);
					_tmp80_ = _tmp79_;
					vala_collection_add ((ValaCollection*) _tmp75_, _tmp80_);
					_vala_flow_analyzer_jump_target_unref0 (_tmp80_);
					_vala_basic_block_unref0 (_tmp77_);
				}
				_vala_code_node_unref0 (catch_clause);
			}
		}
	}
	_tmp81_ = before_try_block;
	_tmp82_ = _vala_basic_block_ref0 (_tmp81_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp82_;
	_tmp83_ = stmt;
	_tmp84_ = vala_try_statement_get_body (_tmp83_);
	_tmp85_ = _tmp84_;
	vala_code_node_accept ((ValaCodeNode*) _tmp85_, (ValaCodeVisitor*) self);
	_tmp86_ = self->priv->current_block;
	if (_tmp86_ != NULL) {
		ValaBasicBlock* _tmp87_;
		ValaBasicBlock* _tmp92_;
		ValaBasicBlock* _tmp93_;
		_tmp87_ = finally_block;
		if (_tmp87_ != NULL) {
			ValaBasicBlock* _tmp88_;
			ValaBasicBlock* _tmp89_;
			ValaBasicBlock* _tmp90_;
			ValaBasicBlock* _tmp91_;
			_tmp88_ = self->priv->current_block;
			_tmp89_ = finally_block;
			vala_basic_block_connect (_tmp88_, _tmp89_);
			_tmp90_ = finally_block;
			_tmp91_ = _vala_basic_block_ref0 (_tmp90_);
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp91_;
		}
		_tmp92_ = self->priv->current_block;
		_tmp93_ = after_try_block;
		vala_basic_block_connect (_tmp92_, _tmp93_);
	}
	_tmp94_ = g_direct_equal;
	_tmp95_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp94_);
	catch_stack = (ValaList*) _tmp95_;
	{
		gint i = 0;
		ValaList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		_tmp96_ = self->priv->jump_stack;
		_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		i = _tmp98_ - 1;
		{
			gboolean _tmp99_ = FALSE;
			_tmp99_ = TRUE;
			while (TRUE) {
				gint _tmp101_;
				gint _tmp102_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp103_;
				gint _tmp104_;
				gpointer _tmp105_;
				ValaList* _tmp106_;
				ValaFlowAnalyzerJumpTarget* _tmp107_;
				if (!_tmp99_) {
					gint _tmp100_;
					_tmp100_ = i;
					i = _tmp100_ - 1;
				}
				_tmp99_ = FALSE;
				_tmp101_ = i;
				_tmp102_ = finally_jump_stack_size;
				if (!(_tmp101_ >= _tmp102_)) {
					break;
				}
				_tmp103_ = self->priv->jump_stack;
				_tmp104_ = i;
				_tmp105_ = vala_list_remove_at (_tmp103_, _tmp104_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp105_;
				_tmp106_ = catch_stack;
				_tmp107_ = jump_target;
				vala_collection_add ((ValaCollection*) _tmp106_, _tmp107_);
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	{
		ValaList* _jump_target_list = NULL;
		ValaList* _tmp108_;
		ValaList* _tmp109_;
		gint _jump_target_size = 0;
		ValaList* _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		gint _jump_target_index = 0;
		_tmp108_ = catch_stack;
		_tmp109_ = _vala_iterable_ref0 (_tmp108_);
		_jump_target_list = _tmp109_;
		_tmp110_ = _jump_target_list;
		_tmp111_ = vala_collection_get_size ((ValaCollection*) _tmp110_);
		_tmp112_ = _tmp111_;
		_jump_target_size = _tmp112_;
		_jump_target_index = -1;
		while (TRUE) {
			gint _tmp113_;
			gint _tmp114_;
			gint _tmp115_;
			ValaFlowAnalyzerJumpTarget* jump_target = NULL;
			ValaList* _tmp116_;
			gint _tmp117_;
			gpointer _tmp118_;
			ValaFlowAnalyzerJumpTarget* _tmp149_;
			ValaBasicBlock* _tmp150_;
			ValaBasicBlock* _tmp151_;
			ValaList* _tmp152_;
			ValaList* _tmp153_;
			gint _tmp154_;
			gint _tmp155_;
			gboolean _tmp156_;
			_tmp113_ = _jump_target_index;
			_jump_target_index = _tmp113_ + 1;
			_tmp114_ = _jump_target_index;
			_tmp115_ = _jump_target_size;
			if (!(_tmp114_ < _tmp115_)) {
				break;
			}
			_tmp116_ = _jump_target_list;
			_tmp117_ = _jump_target_index;
			_tmp118_ = vala_list_get (_tmp116_, _tmp117_);
			jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp118_;
			{
				ValaList* _prev_target_list = NULL;
				ValaList* _tmp119_;
				ValaList* _tmp120_;
				gint _prev_target_size = 0;
				ValaList* _tmp121_;
				gint _tmp122_;
				gint _tmp123_;
				gint _prev_target_index = 0;
				_tmp119_ = catch_stack;
				_tmp120_ = _vala_iterable_ref0 (_tmp119_);
				_prev_target_list = _tmp120_;
				_tmp121_ = _prev_target_list;
				_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
				_tmp123_ = _tmp122_;
				_prev_target_size = _tmp123_;
				_prev_target_index = -1;
				while (TRUE) {
					gint _tmp124_;
					gint _tmp125_;
					gint _tmp126_;
					ValaFlowAnalyzerJumpTarget* prev_target = NULL;
					ValaList* _tmp127_;
					gint _tmp128_;
					gpointer _tmp129_;
					ValaFlowAnalyzerJumpTarget* _tmp130_;
					ValaFlowAnalyzerJumpTarget* _tmp131_;
					gboolean _tmp132_ = FALSE;
					ValaFlowAnalyzerJumpTarget* _tmp133_;
					ValaErrorDomain* _tmp134_;
					ValaErrorDomain* _tmp135_;
					ValaFlowAnalyzerJumpTarget* _tmp136_;
					ValaErrorDomain* _tmp137_;
					ValaErrorDomain* _tmp138_;
					_tmp124_ = _prev_target_index;
					_prev_target_index = _tmp124_ + 1;
					_tmp125_ = _prev_target_index;
					_tmp126_ = _prev_target_size;
					if (!(_tmp125_ < _tmp126_)) {
						break;
					}
					_tmp127_ = _prev_target_list;
					_tmp128_ = _prev_target_index;
					_tmp129_ = vala_list_get (_tmp127_, _tmp128_);
					prev_target = (ValaFlowAnalyzerJumpTarget*) _tmp129_;
					_tmp130_ = prev_target;
					_tmp131_ = jump_target;
					if (_tmp130_ == _tmp131_) {
						_vala_flow_analyzer_jump_target_unref0 (prev_target);
						break;
					}
					_tmp133_ = prev_target;
					_tmp134_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp133_);
					_tmp135_ = _tmp134_;
					_tmp136_ = jump_target;
					_tmp137_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp136_);
					_tmp138_ = _tmp137_;
					if (_tmp135_ == _tmp138_) {
						ValaFlowAnalyzerJumpTarget* _tmp139_;
						ValaErrorCode* _tmp140_;
						ValaErrorCode* _tmp141_;
						ValaFlowAnalyzerJumpTarget* _tmp142_;
						ValaErrorCode* _tmp143_;
						ValaErrorCode* _tmp144_;
						_tmp139_ = prev_target;
						_tmp140_ = vala_flow_analyzer_jump_target_get_error_code (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = jump_target;
						_tmp143_ = vala_flow_analyzer_jump_target_get_error_code (_tmp142_);
						_tmp144_ = _tmp143_;
						_tmp132_ = _tmp141_ == _tmp144_;
					} else {
						_tmp132_ = FALSE;
					}
					if (_tmp132_) {
						ValaTryStatement* _tmp145_;
						ValaSourceReference* _tmp146_;
						ValaSourceReference* _tmp147_;
						ValaTryStatement* _tmp148_;
						_tmp145_ = stmt;
						_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp145_);
						_tmp147_ = _tmp146_;
						vala_report_error (_tmp147_, "double catch clause of same error detected");
						_tmp148_ = stmt;
						vala_code_node_set_error ((ValaCodeNode*) _tmp148_, TRUE);
						_vala_flow_analyzer_jump_target_unref0 (prev_target);
						_vala_iterable_unref0 (_prev_target_list);
						_vala_flow_analyzer_jump_target_unref0 (jump_target);
						_vala_iterable_unref0 (_jump_target_list);
						_vala_iterable_unref0 (catch_stack);
						_vala_iterable_unref0 (catch_clauses);
						_vala_basic_block_unref0 (finally_block);
						_vala_basic_block_unref0 (after_try_block);
						_vala_basic_block_unref0 (before_try_block);
						return;
					}
					_vala_flow_analyzer_jump_target_unref0 (prev_target);
				}
				_vala_iterable_unref0 (_prev_target_list);
			}
			_tmp149_ = jump_target;
			_tmp150_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_basic_block_get_predecessors (_tmp151_);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_collection_get_size ((ValaCollection*) _tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = _tmp155_ == 0;
			_vala_iterable_unref0 (_tmp153_);
			if (_tmp156_) {
				ValaFlowAnalyzerJumpTarget* _tmp157_;
				ValaCatchClause* _tmp158_;
				ValaCatchClause* _tmp159_;
				ValaSourceReference* _tmp160_;
				ValaSourceReference* _tmp161_;
				_tmp157_ = jump_target;
				_tmp158_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp159_);
				_tmp161_ = _tmp160_;
				vala_report_warning (_tmp161_, "unreachable catch clause detected");
			} else {
				ValaFlowAnalyzerJumpTarget* _tmp162_;
				ValaBasicBlock* _tmp163_;
				ValaBasicBlock* _tmp164_;
				ValaBasicBlock* _tmp165_;
				ValaBasicBlock* _tmp166_;
				ValaFlowAnalyzerJumpTarget* _tmp167_;
				ValaCatchClause* _tmp168_;
				ValaCatchClause* _tmp169_;
				ValaFlowAnalyzerJumpTarget* _tmp170_;
				ValaCatchClause* _tmp171_;
				ValaCatchClause* _tmp172_;
				ValaBlock* _tmp173_;
				ValaBlock* _tmp174_;
				ValaBasicBlock* _tmp175_;
				_tmp162_ = jump_target;
				_tmp163_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp162_);
				_tmp164_ = _tmp163_;
				_tmp165_ = _vala_basic_block_ref0 (_tmp164_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp165_;
				_tmp166_ = self->priv->current_block;
				_tmp167_ = jump_target;
				_tmp168_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp167_);
				_tmp169_ = _tmp168_;
				vala_basic_block_add_node (_tmp166_, (ValaCodeNode*) _tmp169_);
				_tmp170_ = jump_target;
				_tmp171_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp170_);
				_tmp172_ = _tmp171_;
				_tmp173_ = vala_catch_clause_get_body (_tmp172_);
				_tmp174_ = _tmp173_;
				vala_code_node_accept ((ValaCodeNode*) _tmp174_, (ValaCodeVisitor*) self);
				_tmp175_ = self->priv->current_block;
				if (_tmp175_ != NULL) {
					ValaBasicBlock* _tmp176_;
					ValaBasicBlock* _tmp181_;
					ValaBasicBlock* _tmp182_;
					_tmp176_ = finally_block;
					if (_tmp176_ != NULL) {
						ValaBasicBlock* _tmp177_;
						ValaBasicBlock* _tmp178_;
						ValaBasicBlock* _tmp179_;
						ValaBasicBlock* _tmp180_;
						_tmp177_ = self->priv->current_block;
						_tmp178_ = finally_block;
						vala_basic_block_connect (_tmp177_, _tmp178_);
						_tmp179_ = finally_block;
						_tmp180_ = _vala_basic_block_ref0 (_tmp179_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp180_;
					}
					_tmp181_ = self->priv->current_block;
					_tmp182_ = after_try_block;
					vala_basic_block_connect (_tmp181_, _tmp182_);
				}
			}
			_vala_flow_analyzer_jump_target_unref0 (jump_target);
		}
		_vala_iterable_unref0 (_jump_target_list);
	}
	_tmp183_ = finally_block;
	if (_tmp183_ != NULL) {
		ValaList* _tmp184_;
		ValaList* _tmp185_;
		gint _tmp186_;
		gint _tmp187_;
		gpointer _tmp188_;
		ValaFlowAnalyzerJumpTarget* _tmp189_;
		_tmp184_ = self->priv->jump_stack;
		_tmp185_ = self->priv->jump_stack;
		_tmp186_ = vala_collection_get_size ((ValaCollection*) _tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_list_remove_at (_tmp184_, _tmp187_ - 1);
		_tmp189_ = (ValaFlowAnalyzerJumpTarget*) _tmp188_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp189_);
	}
	_tmp190_ = after_try_block;
	_tmp191_ = vala_basic_block_get_predecessors (_tmp190_);
	_tmp192_ = _tmp191_;
	_tmp193_ = vala_collection_get_size ((ValaCollection*) _tmp192_);
	_tmp194_ = _tmp193_;
	_tmp195_ = _tmp194_ > 0;
	_vala_iterable_unref0 (_tmp192_);
	if (_tmp195_) {
		ValaBasicBlock* _tmp196_;
		ValaBasicBlock* _tmp197_;
		_tmp196_ = after_try_block;
		_tmp197_ = _vala_basic_block_ref0 (_tmp196_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp197_;
	} else {
		ValaTryStatement* _tmp198_;
		_tmp198_ = stmt;
		vala_try_statement_set_after_try_block_reachable (_tmp198_, FALSE);
		vala_flow_analyzer_mark_unreachable (self);
	}
	_vala_iterable_unref0 (catch_stack);
	_vala_iterable_unref0 (catch_clauses);
	_vala_basic_block_unref0 (finally_block);
	_vala_basic_block_unref0 (after_try_block);
	_vala_basic_block_unref0 (before_try_block);
}


static void vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaLockStatement* _tmp0_;
	gboolean _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
}


static void vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base, ValaUnlockStatement* stmt) {
	ValaFlowAnalyzer * self;
	ValaUnlockStatement* _tmp0_;
	gboolean _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = vala_flow_analyzer_unreachable (self, (ValaCodeNode*) _tmp0_);
	if (_tmp1_) {
		return;
	}
}


static void vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base, ValaExpression* expr) {
	ValaFlowAnalyzer * self;
	ValaExpression* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_LAMBDA_EXPRESSION)) {
		ValaExpression* _tmp1_;
		_tmp1_ = expr;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	}
}


static gboolean vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self, ValaCodeNode* node) {
	gboolean result = FALSE;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = self->priv->current_block;
	if (_tmp0_ == NULL) {
		ValaCodeNode* _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = node;
		vala_code_node_set_unreachable (_tmp1_, TRUE);
		_tmp2_ = self->priv->unreachable_reported;
		if (!_tmp2_) {
			ValaCodeNode* _tmp3_;
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp3_ = node;
			_tmp4_ = vala_code_node_get_source_reference (_tmp3_);
			_tmp5_ = _tmp4_;
			vala_report_warning (_tmp5_, "unreachable code detected");
			self->priv->unreachable_reported = TRUE;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self) {
	g_return_if_fail (self != NULL);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = NULL;
	self->priv->unreachable_reported = FALSE;
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_break_target (GType object_type, ValaBasicBlock* basic_block) {
	ValaFlowAnalyzerJumpTarget* self = NULL;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	_tmp0_ = basic_block;
	vala_flow_analyzer_jump_target_set_basic_block (self, _tmp0_);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block) {
	return vala_flow_analyzer_jump_target_construct_break_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_continue_target (GType object_type, ValaBasicBlock* basic_block) {
	ValaFlowAnalyzerJumpTarget* self = NULL;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	_tmp0_ = basic_block;
	vala_flow_analyzer_jump_target_set_basic_block (self, _tmp0_);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block) {
	return vala_flow_analyzer_jump_target_construct_continue_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_return_target (GType object_type, ValaBasicBlock* basic_block) {
	ValaFlowAnalyzerJumpTarget* self = NULL;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	_tmp0_ = basic_block;
	vala_flow_analyzer_jump_target_set_basic_block (self, _tmp0_);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block) {
	return vala_flow_analyzer_jump_target_construct_return_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_exit_target (GType object_type, ValaBasicBlock* basic_block) {
	ValaFlowAnalyzerJumpTarget* self = NULL;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	_tmp0_ = basic_block;
	vala_flow_analyzer_jump_target_set_basic_block (self, _tmp0_);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block) {
	return vala_flow_analyzer_jump_target_construct_exit_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_error_target (GType object_type, ValaBasicBlock* basic_block, ValaCatchClause* catch_clause, ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaClass* error_class) {
	ValaFlowAnalyzerJumpTarget* self = NULL;
	ValaBasicBlock* _tmp0_;
	ValaCatchClause* _tmp1_;
	ValaErrorDomain* _tmp2_;
	ValaErrorCode* _tmp3_;
	ValaClass* _tmp4_;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (catch_clause != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	_tmp0_ = basic_block;
	vala_flow_analyzer_jump_target_set_basic_block (self, _tmp0_);
	_tmp1_ = catch_clause;
	vala_flow_analyzer_jump_target_set_catch_clause (self, _tmp1_);
	_tmp2_ = error_domain;
	vala_flow_analyzer_jump_target_set_error_domain (self, _tmp2_);
	_tmp3_ = error_code;
	vala_flow_analyzer_jump_target_set_error_code (self, _tmp3_);
	_tmp4_ = error_class;
	vala_flow_analyzer_jump_target_set_error_class (self, _tmp4_);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block, ValaCatchClause* catch_clause, ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaClass* error_class) {
	return vala_flow_analyzer_jump_target_construct_error_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, catch_clause, error_domain, error_code, error_class);
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_any_target (GType object_type, ValaBasicBlock* basic_block) {
	ValaFlowAnalyzerJumpTarget* self = NULL;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	_tmp0_ = basic_block;
	vala_flow_analyzer_jump_target_set_basic_block (self, _tmp0_);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block) {
	return vala_flow_analyzer_jump_target_construct_any_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type, ValaBasicBlock* basic_block, ValaBasicBlock* last_block) {
	ValaFlowAnalyzerJumpTarget* self = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (last_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	_tmp0_ = basic_block;
	vala_flow_analyzer_jump_target_set_basic_block (self, _tmp0_);
	_tmp1_ = last_block;
	vala_flow_analyzer_jump_target_set_last_block (self, _tmp1_);
	vala_flow_analyzer_jump_target_set_is_finally_clause (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block, ValaBasicBlock* last_block) {
	return vala_flow_analyzer_jump_target_construct_finally_clause (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, last_block);
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct (GType object_type) {
	ValaFlowAnalyzerJumpTarget* self = NULL;
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	return self;
}


static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new (void) {
	return vala_flow_analyzer_jump_target_construct (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET);
}


static gboolean vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_break_target;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_break_target = _tmp0_;
}


static gboolean vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_continue_target;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_continue_target = _tmp0_;
}


static gboolean vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_return_target;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_return_target = _tmp0_;
}


static gboolean vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_exit_target;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_exit_target = _tmp0_;
}


static gboolean vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_error_target;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_error_target = _tmp0_;
}


static ValaErrorDomain* vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self) {
	ValaErrorDomain* result;
	ValaErrorDomain* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_domain;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self, ValaErrorDomain* value) {
	ValaErrorDomain* _tmp0_;
	ValaErrorDomain* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_error_domain);
	self->priv->_error_domain = _tmp1_;
}


static ValaErrorCode* vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self) {
	ValaErrorCode* result;
	ValaErrorCode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_code;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self, ValaErrorCode* value) {
	ValaErrorCode* _tmp0_;
	ValaErrorCode* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_error_code);
	self->priv->_error_code = _tmp1_;
}


static ValaClass* vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self) {
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_class;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self, ValaClass* value) {
	ValaClass* _tmp0_;
	ValaClass* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_error_class);
	self->priv->_error_class = _tmp1_;
}


static gboolean vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_finally_clause;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_finally_clause = _tmp0_;
}


static ValaBasicBlock* vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self) {
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_basic_block;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self, ValaBasicBlock* value) {
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	self->priv->_basic_block = _tmp1_;
}


static ValaBasicBlock* vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self) {
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_block;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self, ValaBasicBlock* value) {
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	_vala_basic_block_unref0 (self->priv->_last_block);
	self->priv->_last_block = _tmp1_;
}


static ValaCatchClause* vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self) {
	ValaCatchClause* result;
	ValaCatchClause* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_catch_clause;
	result = _tmp0_;
	return result;
}


static void vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self, ValaCatchClause* value) {
	ValaCatchClause* _tmp0_;
	ValaCatchClause* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_catch_clause);
	self->priv->_catch_clause = _tmp1_;
}


static void vala_flow_analyzer_value_jump_target_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_flow_analyzer_value_jump_target_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_flow_analyzer_jump_target_unref (value->data[0].v_pointer);
	}
}


static void vala_flow_analyzer_value_jump_target_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_flow_analyzer_value_jump_target_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_flow_analyzer_value_jump_target_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaFlowAnalyzerJumpTarget * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_flow_analyzer_value_jump_target_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaFlowAnalyzerJumpTarget ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* vala_flow_analyzer_param_spec_jump_target (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaFlowAnalyzerParamSpecJumpTarget* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer vala_flow_analyzer_value_get_jump_target (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	return value->data[0].v_pointer;
}


static void vala_flow_analyzer_value_set_jump_target (GValue* value, gpointer v_object) {
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}


static void vala_flow_analyzer_value_take_jump_target (GValue* value, gpointer v_object) {
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}


static void vala_flow_analyzer_jump_target_class_init (ValaFlowAnalyzerJumpTargetClass * klass) {
	vala_flow_analyzer_jump_target_parent_class = g_type_class_peek_parent (klass);
	((ValaFlowAnalyzerJumpTargetClass *) klass)->finalize = vala_flow_analyzer_jump_target_finalize;
	g_type_class_add_private (klass, sizeof (ValaFlowAnalyzerJumpTargetPrivate));
}


static void vala_flow_analyzer_jump_target_instance_init (ValaFlowAnalyzerJumpTarget * self) {
	self->priv = VALA_FLOW_ANALYZER_JUMP_TARGET_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj) {
	ValaFlowAnalyzerJumpTarget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->priv->_error_domain);
	_vala_code_node_unref0 (self->priv->_error_code);
	_vala_code_node_unref0 (self->priv->_error_class);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	_vala_basic_block_unref0 (self->priv->_last_block);
	_vala_code_node_unref0 (self->priv->_catch_clause);
}


static GType vala_flow_analyzer_jump_target_get_type (void) {
	static volatile gsize vala_flow_analyzer_jump_target_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_jump_target_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_flow_analyzer_value_jump_target_init, vala_flow_analyzer_value_jump_target_free_value, vala_flow_analyzer_value_jump_target_copy_value, vala_flow_analyzer_value_jump_target_peek_pointer, "p", vala_flow_analyzer_value_jump_target_collect_value, "p", vala_flow_analyzer_value_jump_target_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerJumpTargetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_jump_target_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzerJumpTarget), 0, (GInstanceInitFunc) vala_flow_analyzer_jump_target_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_flow_analyzer_jump_target_type_id;
		vala_flow_analyzer_jump_target_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaFlowAnalyzerJumpTarget", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_flow_analyzer_jump_target_type_id__volatile, vala_flow_analyzer_jump_target_type_id);
	}
	return vala_flow_analyzer_jump_target_type_id__volatile;
}


static gpointer vala_flow_analyzer_jump_target_ref (gpointer instance) {
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void vala_flow_analyzer_jump_target_unref (gpointer instance) {
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void vala_flow_analyzer_class_init (ValaFlowAnalyzerClass * klass) {
	vala_flow_analyzer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_flow_analyzer_finalize;
	g_type_class_add_private (klass, sizeof (ValaFlowAnalyzerPrivate));
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor *, ValaSourceFile*)) vala_flow_analyzer_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor *, ValaClass*)) vala_flow_analyzer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor *, ValaStruct*)) vala_flow_analyzer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor *, ValaInterface*)) vala_flow_analyzer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor *, ValaEnum*)) vala_flow_analyzer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor *, ValaErrorDomain*)) vala_flow_analyzer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor *, ValaField*)) vala_flow_analyzer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor *, ValaLambdaExpression*)) vala_flow_analyzer_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor *, ValaMethod*)) vala_flow_analyzer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor *, ValaSignal*)) vala_flow_analyzer_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor *, ValaCreationMethod*)) vala_flow_analyzer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor *, ValaProperty*)) vala_flow_analyzer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_property_accessor = (void (*) (ValaCodeVisitor *, ValaPropertyAccessor*)) vala_flow_analyzer_real_visit_property_accessor;
	((ValaCodeVisitorClass *) klass)->visit_block = (void (*) (ValaCodeVisitor *, ValaBlock*)) vala_flow_analyzer_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_declaration_statement = (void (*) (ValaCodeVisitor *, ValaDeclarationStatement*)) vala_flow_analyzer_real_visit_declaration_statement;
	((ValaCodeVisitorClass *) klass)->visit_local_variable = (void (*) (ValaCodeVisitor *, ValaLocalVariable*)) vala_flow_analyzer_real_visit_local_variable;
	((ValaCodeVisitorClass *) klass)->visit_expression_statement = (void (*) (ValaCodeVisitor *, ValaExpressionStatement*)) vala_flow_analyzer_real_visit_expression_statement;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = (void (*) (ValaCodeVisitor *, ValaIfStatement*)) vala_flow_analyzer_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = (void (*) (ValaCodeVisitor *, ValaSwitchStatement*)) vala_flow_analyzer_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_loop = (void (*) (ValaCodeVisitor *, ValaLoop*)) vala_flow_analyzer_real_visit_loop;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = (void (*) (ValaCodeVisitor *, ValaForeachStatement*)) vala_flow_analyzer_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_break_statement = (void (*) (ValaCodeVisitor *, ValaBreakStatement*)) vala_flow_analyzer_real_visit_break_statement;
	((ValaCodeVisitorClass *) klass)->visit_continue_statement = (void (*) (ValaCodeVisitor *, ValaContinueStatement*)) vala_flow_analyzer_real_visit_continue_statement;
	((ValaCodeVisitorClass *) klass)->visit_return_statement = (void (*) (ValaCodeVisitor *, ValaReturnStatement*)) vala_flow_analyzer_real_visit_return_statement;
	((ValaCodeVisitorClass *) klass)->visit_yield_statement = (void (*) (ValaCodeVisitor *, ValaYieldStatement*)) vala_flow_analyzer_real_visit_yield_statement;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor *, ValaThrowStatement*)) vala_flow_analyzer_real_visit_throw_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor *, ValaTryStatement*)) vala_flow_analyzer_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_lock_statement = (void (*) (ValaCodeVisitor *, ValaLockStatement*)) vala_flow_analyzer_real_visit_lock_statement;
	((ValaCodeVisitorClass *) klass)->visit_unlock_statement = (void (*) (ValaCodeVisitor *, ValaUnlockStatement*)) vala_flow_analyzer_real_visit_unlock_statement;
	((ValaCodeVisitorClass *) klass)->visit_expression = (void (*) (ValaCodeVisitor *, ValaExpression*)) vala_flow_analyzer_real_visit_expression;
}


static void vala_flow_analyzer_instance_init (ValaFlowAnalyzer * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_FLOW_ANALYZER_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp0_);
	self->priv->jump_stack = (ValaList*) _tmp1_;
}


static void vala_flow_analyzer_finalize (ValaCodeVisitor * obj) {
	ValaFlowAnalyzer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzer);
	_vala_code_context_unref0 (self->priv->context);
	_vala_basic_block_unref0 (self->priv->current_block);
	_vala_iterable_unref0 (self->priv->jump_stack);
	_vala_map_unref0 (self->priv->var_map);
	_vala_iterable_unref0 (self->priv->used_vars);
	_vala_map_unref0 (self->priv->phi_functions);
	VALA_CODE_VISITOR_CLASS (vala_flow_analyzer_parent_class)->finalize (obj);
}


/**
 * Code visitor building the control flow graph.
 */
GType vala_flow_analyzer_get_type (void) {
	static volatile gsize vala_flow_analyzer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzer), 0, (GInstanceInitFunc) vala_flow_analyzer_instance_init, NULL };
		GType vala_flow_analyzer_type_id;
		vala_flow_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaFlowAnalyzer", &g_define_type_info, 0);
		g_once_init_leave (&vala_flow_analyzer_type_id__volatile, vala_flow_analyzer_type_id);
	}
	return vala_flow_analyzer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



