/* gtkdocrenderer.c generated by valac, the Vala compiler
 * generated from gtkdocrenderer.vala, do not modify */

/* gtkdocrenderer.vala
 *
 * Copyright (C) 2011 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALADOC_GTKDOC_RENDERER_DUMMY_PROPERTY,
	VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY,
	VALADOC_GTKDOC_RENDERER_LAST_PROPERTY
};
static GParamSpec* valadoc_gtkdoc_renderer_properties[VALADOC_GTKDOC_RENDERER_LAST_PROPERTY];
#define _valadoc_markup_writer_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_markup_writer_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValadocGtkdocRendererPrivate {
	ValadocGtkDocMarkupWriter* writer;
	gboolean separated;
};


static gpointer valadoc_gtkdoc_renderer_parent_class = NULL;

#define VALADOC_GTKDOC_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_GTKDOC_RENDERER, ValadocGtkdocRendererPrivate))
static gchar* valadoc_gtkdoc_renderer_get_cname (ValadocGtkdocRenderer* self, ValadocApiItem* item);
static void valadoc_gtkdoc_renderer_real_render (ValadocContentContentRenderer* base, ValadocContentContentElement* element);
static void valadoc_gtkdoc_renderer_reset (ValadocGtkdocRenderer* self);
static void valadoc_gtkdoc_renderer_real_render_children (ValadocContentContentRenderer* base, ValadocContentContentElement* element);
static void valadoc_gtkdoc_renderer_real_visit_comment (ValadocContentContentVisitor* base, ValadocContentComment* element);
static void valadoc_gtkdoc_renderer_real_visit_embedded (ValadocContentContentVisitor* base, ValadocContentEmbedded* element);
static void valadoc_gtkdoc_renderer_real_visit_headline (ValadocContentContentVisitor* base, ValadocContentHeadline* element);
static void valadoc_gtkdoc_renderer_real_visit_wiki_link (ValadocContentContentVisitor* base, ValadocContentWikiLink* element);
static void valadoc_gtkdoc_renderer_write_string (ValadocGtkdocRenderer* self, const gchar* content);
static void valadoc_gtkdoc_renderer_real_visit_link (ValadocContentContentVisitor* base, ValadocContentLink* element);
static void valadoc_gtkdoc_renderer_real_visit_symbol_link (ValadocContentContentVisitor* base, ValadocContentSymbolLink* element);
static void valadoc_gtkdoc_renderer_real_visit_list (ValadocContentContentVisitor* base, ValadocContentList* element);
static void valadoc_gtkdoc_renderer_real_visit_list_item (ValadocContentContentVisitor* base, ValadocContentListItem* element);
static void valadoc_gtkdoc_renderer_real_visit_page (ValadocContentContentVisitor* base, ValadocContentPage* element);
static void valadoc_gtkdoc_renderer_real_visit_paragraph (ValadocContentContentVisitor* base, ValadocContentParagraph* element);
static void valadoc_gtkdoc_renderer_real_visit_warning (ValadocContentContentVisitor* base, ValadocContentWarning* element);
static void valadoc_gtkdoc_renderer_real_visit_note (ValadocContentContentVisitor* base, ValadocContentNote* element);
static void valadoc_gtkdoc_renderer_real_visit_run (ValadocContentContentVisitor* base, ValadocContentRun* element);
static void valadoc_gtkdoc_renderer_real_visit_source_code (ValadocContentContentVisitor* base, ValadocContentSourceCode* element);
static void valadoc_gtkdoc_renderer_real_visit_table (ValadocContentContentVisitor* base, ValadocContentTable* element);
static void valadoc_gtkdoc_renderer_real_visit_table_cell (ValadocContentContentVisitor* base, ValadocContentTableCell* element);
static void valadoc_gtkdoc_renderer_real_visit_table_row (ValadocContentContentVisitor* base, ValadocContentTableRow* element);
static void valadoc_gtkdoc_renderer_real_visit_text (ValadocContentContentVisitor* base, ValadocContentText* element);
static void valadoc_gtkdoc_renderer_finalize (GObject * obj);
static void _vala_valadoc_gtkdoc_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* valadoc_gtkdoc_renderer_get_cname (ValadocGtkdocRenderer* self, ValadocApiItem* item) {
	gchar* result = NULL;
	ValadocApiItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALADOC_API_TYPE_METHOD)) {
		ValadocApiItem* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = item;
		_tmp2_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
		result = _tmp2_;
		return result;
	} else {
		ValadocApiItem* _tmp3_;
		_tmp3_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_API_TYPE_FORMAL_PARAMETER)) {
			ValadocApiItem* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = item;
			_tmp5_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strdup (_tmp6_);
			result = _tmp7_;
			return result;
		} else {
			ValadocApiItem* _tmp8_;
			_tmp8_ = item;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALADOC_API_TYPE_CONSTANT)) {
				ValadocApiItem* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = item;
				_tmp10_ = valadoc_api_constant_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALADOC_API_TYPE_CONSTANT, ValadocApiConstant));
				result = _tmp10_;
				return result;
			} else {
				ValadocApiItem* _tmp11_;
				_tmp11_ = item;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALADOC_API_TYPE_PROPERTY)) {
					ValadocApiItem* _tmp12_;
					gchar* _tmp13_;
					_tmp12_ = item;
					_tmp13_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
					result = _tmp13_;
					return result;
				} else {
					ValadocApiItem* _tmp14_;
					_tmp14_ = item;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALADOC_API_TYPE_SIGNAL)) {
						gchar* name = NULL;
						ValadocApiItem* _tmp15_;
						gchar* _tmp16_;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						_tmp15_ = item;
						_tmp16_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
						name = _tmp16_;
						_tmp17_ = name;
						_tmp18_ = string_replace (_tmp17_, "_", "-");
						result = _tmp18_;
						_g_free0 (name);
						return result;
					} else {
						ValadocApiItem* _tmp19_;
						_tmp19_ = item;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALADOC_API_TYPE_CLASS)) {
							ValadocApiItem* _tmp20_;
							gchar* _tmp21_;
							_tmp20_ = item;
							_tmp21_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
							result = _tmp21_;
							return result;
						} else {
							ValadocApiItem* _tmp22_;
							_tmp22_ = item;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALADOC_API_TYPE_STRUCT)) {
								ValadocApiItem* _tmp23_;
								gchar* _tmp24_;
								_tmp23_ = item;
								_tmp24_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
								result = _tmp24_;
								return result;
							} else {
								ValadocApiItem* _tmp25_;
								_tmp25_ = item;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALADOC_API_TYPE_INTERFACE)) {
									ValadocApiItem* _tmp26_;
									gchar* _tmp27_;
									_tmp26_ = item;
									_tmp27_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
									result = _tmp27_;
									return result;
								} else {
									ValadocApiItem* _tmp28_;
									_tmp28_ = item;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALADOC_API_TYPE_ERROR_DOMAIN)) {
										ValadocApiItem* _tmp29_;
										gchar* _tmp30_;
										_tmp29_ = item;
										_tmp30_ = valadoc_api_error_domain_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALADOC_API_TYPE_ERROR_DOMAIN, ValadocApiErrorDomain));
										result = _tmp30_;
										return result;
									} else {
										ValadocApiItem* _tmp31_;
										_tmp31_ = item;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALADOC_API_TYPE_ERROR_CODE)) {
											ValadocApiItem* _tmp32_;
											gchar* _tmp33_;
											_tmp32_ = item;
											_tmp33_ = valadoc_api_error_code_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALADOC_API_TYPE_ERROR_CODE, ValadocApiErrorCode));
											result = _tmp33_;
											return result;
										} else {
											ValadocApiItem* _tmp34_;
											_tmp34_ = item;
											if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALADOC_API_TYPE_DELEGATE)) {
												ValadocApiItem* _tmp35_;
												gchar* _tmp36_;
												_tmp35_ = item;
												_tmp36_ = valadoc_api_delegate_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALADOC_API_TYPE_DELEGATE, ValadocApiDelegate));
												result = _tmp36_;
												return result;
											} else {
												ValadocApiItem* _tmp37_;
												_tmp37_ = item;
												if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALADOC_API_TYPE_ENUM)) {
													ValadocApiItem* _tmp38_;
													gchar* _tmp39_;
													_tmp38_ = item;
													_tmp39_ = valadoc_api_enum_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALADOC_API_TYPE_ENUM, ValadocApiEnum));
													result = _tmp39_;
													return result;
												} else {
													ValadocApiItem* _tmp40_;
													_tmp40_ = item;
													if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, VALADOC_API_TYPE_ENUM_VALUE)) {
														ValadocApiItem* _tmp41_;
														gchar* _tmp42_;
														_tmp41_ = item;
														_tmp42_ = valadoc_api_enum_value_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALADOC_API_TYPE_ENUM_VALUE, ValadocApiEnumValue));
														result = _tmp42_;
														return result;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


void valadoc_gtkdoc_renderer_write_docbook_link (ValadocGtkdocRenderer* self, ValadocApiItem* item) {
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocApiItem* _tmp1_;
	ValadocGtkDocMarkupWriter* _tmp92_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp0_, FALSE);
	_tmp1_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALADOC_API_TYPE_METHOD)) {
		ValadocGtkDocMarkupWriter* _tmp2_;
		ValadocMarkupWriter* _tmp3_;
		ValadocMarkupWriter* _tmp4_;
		ValadocApiItem* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		ValadocMarkupWriter* _tmp8_;
		ValadocMarkupWriter* _tmp9_;
		ValadocMarkupWriter* _tmp10_;
		ValadocMarkupWriter* _tmp11_;
		_tmp2_ = self->priv->writer;
		_tmp3_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp2_, "function", NULL, 0);
		_tmp4_ = _tmp3_;
		_tmp5_ = item;
		_tmp6_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
		_tmp7_ = _tmp6_;
		_tmp8_ = valadoc_markup_writer_text (_tmp4_, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = valadoc_markup_writer_end_tag (_tmp9_, "function");
		_tmp11_ = _tmp10_;
		_valadoc_markup_writer_unref0 (_tmp11_);
		_valadoc_markup_writer_unref0 (_tmp9_);
		_g_free0 (_tmp7_);
		_valadoc_markup_writer_unref0 (_tmp4_);
	} else {
		ValadocApiItem* _tmp12_;
		_tmp12_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALADOC_API_TYPE_FORMAL_PARAMETER)) {
			const gchar* _tmp13_ = NULL;
			ValadocApiItem* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			ValadocGtkDocMarkupWriter* _tmp17_;
			ValadocMarkupWriter* _tmp18_;
			ValadocMarkupWriter* _tmp19_;
			ValadocMarkupWriter* _tmp20_;
			ValadocMarkupWriter* _tmp21_;
			ValadocMarkupWriter* _tmp22_;
			ValadocMarkupWriter* _tmp23_;
			_tmp14_ = item;
			_tmp15_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
			_tmp16_ = _tmp15_;
			_tmp13_ = _tmp16_;
			if (_tmp13_ == NULL) {
				_tmp13_ = "...";
			}
			_tmp17_ = self->priv->writer;
			_tmp18_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp17_, "parameter", NULL, 0);
			_tmp19_ = _tmp18_;
			_tmp20_ = valadoc_markup_writer_text (_tmp19_, _tmp13_);
			_tmp21_ = _tmp20_;
			_tmp22_ = valadoc_markup_writer_end_tag (_tmp21_, "parameter");
			_tmp23_ = _tmp22_;
			_valadoc_markup_writer_unref0 (_tmp23_);
			_valadoc_markup_writer_unref0 (_tmp21_);
			_valadoc_markup_writer_unref0 (_tmp19_);
		} else {
			ValadocApiItem* _tmp24_;
			_tmp24_ = item;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALADOC_API_TYPE_CONSTANT)) {
				ValadocGtkDocMarkupWriter* _tmp25_;
				ValadocMarkupWriter* _tmp26_;
				ValadocMarkupWriter* _tmp27_;
				ValadocApiItem* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				ValadocMarkupWriter* _tmp31_;
				ValadocMarkupWriter* _tmp32_;
				ValadocMarkupWriter* _tmp33_;
				ValadocMarkupWriter* _tmp34_;
				_tmp25_ = self->priv->writer;
				_tmp26_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp25_, "constant", NULL, 0);
				_tmp27_ = _tmp26_;
				_tmp28_ = item;
				_tmp29_ = valadoc_api_constant_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALADOC_API_TYPE_CONSTANT, ValadocApiConstant));
				_tmp30_ = _tmp29_;
				_tmp31_ = valadoc_markup_writer_text (_tmp27_, _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = valadoc_markup_writer_end_tag (_tmp32_, "constant");
				_tmp34_ = _tmp33_;
				_valadoc_markup_writer_unref0 (_tmp34_);
				_valadoc_markup_writer_unref0 (_tmp32_);
				_g_free0 (_tmp30_);
				_valadoc_markup_writer_unref0 (_tmp27_);
			} else {
				ValadocApiItem* _tmp35_;
				_tmp35_ = item;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALADOC_API_TYPE_PROPERTY)) {
					ValadocGtkDocMarkupWriter* _tmp36_;
					ValadocMarkupWriter* _tmp37_;
					ValadocMarkupWriter* _tmp38_;
					ValadocApiItem* _tmp39_;
					ValadocApiItem* _tmp40_;
					ValadocApiItem* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					ValadocMarkupWriter* _tmp44_;
					ValadocMarkupWriter* _tmp45_;
					ValadocMarkupWriter* _tmp46_;
					ValadocMarkupWriter* _tmp47_;
					ValadocApiItem* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					ValadocMarkupWriter* _tmp53_;
					ValadocMarkupWriter* _tmp54_;
					_tmp36_ = self->priv->writer;
					_tmp37_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp36_, "#");
					_tmp38_ = _tmp37_;
					_tmp39_ = item;
					_tmp40_ = valadoc_api_item_get_parent (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = valadoc_gtkdoc_renderer_get_cname (self, _tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = valadoc_markup_writer_text (_tmp38_, _tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = valadoc_markup_writer_text (_tmp45_, ":");
					_tmp47_ = _tmp46_;
					_tmp48_ = item;
					_tmp49_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
					_tmp50_ = _tmp49_;
					_tmp51_ = string_replace (_tmp50_, "_", "-");
					_tmp52_ = _tmp51_;
					_tmp53_ = valadoc_markup_writer_text (_tmp47_, _tmp52_);
					_tmp54_ = _tmp53_;
					_valadoc_markup_writer_unref0 (_tmp54_);
					_g_free0 (_tmp52_);
					_g_free0 (_tmp50_);
					_valadoc_markup_writer_unref0 (_tmp47_);
					_valadoc_markup_writer_unref0 (_tmp45_);
					_g_free0 (_tmp43_);
					_valadoc_markup_writer_unref0 (_tmp38_);
				} else {
					ValadocApiItem* _tmp55_;
					_tmp55_ = item;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALADOC_API_TYPE_SIGNAL)) {
						ValadocGtkDocMarkupWriter* _tmp56_;
						ValadocMarkupWriter* _tmp57_;
						ValadocMarkupWriter* _tmp58_;
						ValadocApiItem* _tmp59_;
						ValadocApiItem* _tmp60_;
						ValadocApiItem* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						ValadocMarkupWriter* _tmp64_;
						ValadocMarkupWriter* _tmp65_;
						ValadocMarkupWriter* _tmp66_;
						ValadocMarkupWriter* _tmp67_;
						ValadocApiItem* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						gchar* _tmp71_;
						gchar* _tmp72_;
						ValadocMarkupWriter* _tmp73_;
						ValadocMarkupWriter* _tmp74_;
						_tmp56_ = self->priv->writer;
						_tmp57_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp56_, "#");
						_tmp58_ = _tmp57_;
						_tmp59_ = item;
						_tmp60_ = valadoc_api_item_get_parent (_tmp59_);
						_tmp61_ = _tmp60_;
						_tmp62_ = valadoc_gtkdoc_renderer_get_cname (self, _tmp61_);
						_tmp63_ = _tmp62_;
						_tmp64_ = valadoc_markup_writer_text (_tmp58_, _tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = valadoc_markup_writer_text (_tmp65_, "::");
						_tmp67_ = _tmp66_;
						_tmp68_ = item;
						_tmp69_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
						_tmp70_ = _tmp69_;
						_tmp71_ = string_replace (_tmp70_, "_", "-");
						_tmp72_ = _tmp71_;
						_tmp73_ = valadoc_markup_writer_text (_tmp67_, _tmp72_);
						_tmp74_ = _tmp73_;
						_valadoc_markup_writer_unref0 (_tmp74_);
						_g_free0 (_tmp72_);
						_g_free0 (_tmp70_);
						_valadoc_markup_writer_unref0 (_tmp67_);
						_valadoc_markup_writer_unref0 (_tmp65_);
						_g_free0 (_tmp63_);
						_valadoc_markup_writer_unref0 (_tmp58_);
					} else {
						ValadocApiItem* _tmp75_;
						_tmp75_ = item;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALADOC_API_TYPE_NAMESPACE)) {
							ValadocGtkDocMarkupWriter* _tmp76_;
							ValadocApiItem* _tmp77_;
							gchar* _tmp78_;
							gchar* _tmp79_;
							ValadocMarkupWriter* _tmp80_;
							ValadocMarkupWriter* _tmp81_;
							_tmp76_ = self->priv->writer;
							_tmp77_ = item;
							_tmp78_ = valadoc_api_node_get_full_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALADOC_API_TYPE_NAMESPACE, ValadocApiNamespace));
							_tmp79_ = _tmp78_;
							_tmp80_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp76_, _tmp79_);
							_tmp81_ = _tmp80_;
							_valadoc_markup_writer_unref0 (_tmp81_);
							_g_free0 (_tmp79_);
						} else {
							ValadocGtkDocMarkupWriter* _tmp82_;
							ValadocMarkupWriter* _tmp83_;
							ValadocMarkupWriter* _tmp84_;
							ValadocApiItem* _tmp85_;
							gchar* _tmp86_;
							gchar* _tmp87_;
							ValadocMarkupWriter* _tmp88_;
							ValadocMarkupWriter* _tmp89_;
							ValadocMarkupWriter* _tmp90_;
							ValadocMarkupWriter* _tmp91_;
							_tmp82_ = self->priv->writer;
							_tmp83_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp82_, "type", NULL, 0);
							_tmp84_ = _tmp83_;
							_tmp85_ = item;
							_tmp86_ = valadoc_gtkdoc_renderer_get_cname (self, _tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = valadoc_markup_writer_text (_tmp84_, _tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = valadoc_markup_writer_end_tag (_tmp89_, "type");
							_tmp91_ = _tmp90_;
							_valadoc_markup_writer_unref0 (_tmp91_);
							_valadoc_markup_writer_unref0 (_tmp89_);
							_g_free0 (_tmp87_);
							_valadoc_markup_writer_unref0 (_tmp84_);
						}
					}
				}
			}
		}
	}
	_tmp92_ = self->priv->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp92_, TRUE);
}


ValadocGtkdocRenderer* valadoc_gtkdoc_renderer_construct (GType object_type) {
	ValadocGtkdocRenderer * self = NULL;
	self = (ValadocGtkdocRenderer*) valadoc_content_content_renderer_construct (object_type);
	return self;
}


ValadocGtkdocRenderer* valadoc_gtkdoc_renderer_new (void) {
	return valadoc_gtkdoc_renderer_construct (VALADOC_TYPE_GTKDOC_RENDERER);
}


static void valadoc_gtkdoc_renderer_real_render (ValadocContentContentRenderer* base, ValadocContentContentElement* element) {
	ValadocGtkdocRenderer * self;
	ValadocContentContentElement* _tmp0_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	valadoc_gtkdoc_renderer_reset (self);
	_tmp0_ = element;
	valadoc_content_content_element_accept (_tmp0_, (ValadocContentContentVisitor*) self);
}


void valadoc_gtkdoc_renderer_render_symbol (ValadocGtkdocRenderer* self, ValadocContentComment* documentation) {
	ValadocContentComment* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	ValadocContentComment* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValadocContentComment* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = documentation;
	valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) self, (ValadocContentContentElement*) _tmp0_);
	_tmp1_ = documentation;
	_tmp2_ = valadoc_content_comment_find_taglets (_tmp1_, NULL, VALADOC_TAGLETS_TYPE_THROWS);
	_tmp3_ = _tmp2_;
	valadoc_gtkdoc_renderer_append_exceptions (self, _tmp3_);
	_vala_iterable_unref0 (_tmp3_);
	_tmp4_ = documentation;
	_tmp5_ = valadoc_content_comment_find_taglets (_tmp4_, NULL, VALADOC_TAGLETS_TYPE_SEE);
	_tmp6_ = _tmp5_;
	valadoc_gtkdoc_renderer_append_see (self, _tmp6_);
	_vala_iterable_unref0 (_tmp6_);
	_tmp7_ = documentation;
	_tmp8_ = valadoc_content_comment_find_taglets (_tmp7_, NULL, VALADOC_TAGLETS_TYPE_SINCE);
	_tmp9_ = _tmp8_;
	valadoc_gtkdoc_renderer_append_since (self, _tmp9_);
	_vala_iterable_unref0 (_tmp9_);
}


static void valadoc_gtkdoc_renderer_real_render_children (ValadocContentContentRenderer* base, ValadocContentContentElement* element) {
	ValadocGtkdocRenderer * self;
	ValadocContentContentElement* _tmp0_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	valadoc_gtkdoc_renderer_reset (self);
	_tmp0_ = element;
	valadoc_content_content_element_accept_children (_tmp0_, (ValadocContentContentVisitor*) self);
}


static void valadoc_gtkdoc_renderer_reset (ValadocGtkdocRenderer* self) {
	ValadocGtkDocMarkupWriter* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->separated = FALSE;
	_tmp0_ = self->priv->writer;
	valadoc_gtk_doc_markup_writer_reset (_tmp0_);
}


static void valadoc_gtkdoc_renderer_real_visit_comment (ValadocContentContentVisitor* base, ValadocContentComment* element) {
	ValadocGtkdocRenderer * self;
	ValadocContentComment* _tmp0_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp0_, (ValadocContentContentVisitor*) self);
}


static void valadoc_gtkdoc_renderer_real_visit_embedded (ValadocContentContentVisitor* base, ValadocContentEmbedded* element) {
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocContentEmbedded* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	ValadocGtkDocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocGtkDocMarkupWriter* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	gchar* _tmp22_;
	ValadocContentEmbedded* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	ValadocMarkupWriter* _tmp29_;
	ValadocMarkupWriter* _tmp30_;
	ValadocMarkupWriter* _tmp31_;
	ValadocMarkupWriter* _tmp32_;
	ValadocContentEmbedded* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	ValadocGtkDocMarkupWriter* _tmp50_;
	ValadocMarkupWriter* _tmp51_;
	ValadocMarkupWriter* _tmp52_;
	ValadocGtkDocMarkupWriter* _tmp53_;
	ValadocMarkupWriter* _tmp54_;
	ValadocMarkupWriter* _tmp55_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "figure", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = element;
	_tmp4_ = valadoc_content_embedded_get_caption (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValadocGtkDocMarkupWriter* _tmp6_;
		ValadocMarkupWriter* _tmp7_;
		ValadocMarkupWriter* _tmp8_;
		ValadocContentEmbedded* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValadocMarkupWriter* _tmp12_;
		ValadocMarkupWriter* _tmp13_;
		ValadocMarkupWriter* _tmp14_;
		ValadocMarkupWriter* _tmp15_;
		_tmp6_ = self->priv->writer;
		_tmp7_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp6_, "title", NULL, 0);
		_tmp8_ = _tmp7_;
		_tmp9_ = element;
		_tmp10_ = valadoc_content_embedded_get_caption (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_markup_writer_text (_tmp8_, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = valadoc_markup_writer_end_tag (_tmp13_, "title");
		_tmp15_ = _tmp14_;
		_valadoc_markup_writer_unref0 (_tmp15_);
		_valadoc_markup_writer_unref0 (_tmp13_);
		_valadoc_markup_writer_unref0 (_tmp8_);
	}
	_tmp16_ = self->priv->writer;
	_tmp17_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp16_, "mediaobject", NULL, 0);
	_tmp18_ = _tmp17_;
	_valadoc_markup_writer_unref0 (_tmp18_);
	_tmp19_ = self->priv->writer;
	_tmp20_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp19_, "imageobject", NULL, 0);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup ("fileref");
	_tmp23_ = element;
	_tmp24_ = valadoc_content_embedded_get_url (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strdup (_tmp25_);
	_tmp27_ = g_new0 (gchar*, 2 + 1);
	_tmp27_[0] = _tmp22_;
	_tmp27_[1] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 2;
	_tmp29_ = valadoc_markup_writer_simple_tag (_tmp21_, "imagedata", _tmp28_, 2);
	_tmp30_ = _tmp29_;
	_tmp31_ = valadoc_markup_writer_end_tag (_tmp30_, "imageobject");
	_tmp32_ = _tmp31_;
	_valadoc_markup_writer_unref0 (_tmp32_);
	_valadoc_markup_writer_unref0 (_tmp30_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_valadoc_markup_writer_unref0 (_tmp21_);
	_tmp33_ = element;
	_tmp34_ = valadoc_content_embedded_get_caption (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_ != NULL) {
		ValadocGtkDocMarkupWriter* _tmp36_;
		ValadocMarkupWriter* _tmp37_;
		ValadocMarkupWriter* _tmp38_;
		ValadocMarkupWriter* _tmp39_;
		ValadocMarkupWriter* _tmp40_;
		ValadocContentEmbedded* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		ValadocMarkupWriter* _tmp44_;
		ValadocMarkupWriter* _tmp45_;
		ValadocMarkupWriter* _tmp46_;
		ValadocMarkupWriter* _tmp47_;
		ValadocMarkupWriter* _tmp48_;
		ValadocMarkupWriter* _tmp49_;
		_tmp36_ = self->priv->writer;
		_tmp37_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp36_, "textobject", NULL, 0);
		_tmp38_ = _tmp37_;
		_tmp39_ = valadoc_markup_writer_start_tag (_tmp38_, "phrase", NULL, 0);
		_tmp40_ = _tmp39_;
		_tmp41_ = element;
		_tmp42_ = valadoc_content_embedded_get_caption (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = valadoc_markup_writer_text (_tmp40_, _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = valadoc_markup_writer_end_tag (_tmp45_, "phrase");
		_tmp47_ = _tmp46_;
		_tmp48_ = valadoc_markup_writer_end_tag (_tmp47_, "textobject");
		_tmp49_ = _tmp48_;
		_valadoc_markup_writer_unref0 (_tmp49_);
		_valadoc_markup_writer_unref0 (_tmp47_);
		_valadoc_markup_writer_unref0 (_tmp45_);
		_valadoc_markup_writer_unref0 (_tmp40_);
		_valadoc_markup_writer_unref0 (_tmp38_);
	}
	_tmp50_ = self->priv->writer;
	_tmp51_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp50_, "mediaobject");
	_tmp52_ = _tmp51_;
	_valadoc_markup_writer_unref0 (_tmp52_);
	_tmp53_ = self->priv->writer;
	_tmp54_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp53_, "figure");
	_tmp55_ = _tmp54_;
	_valadoc_markup_writer_unref0 (_tmp55_);
}


static void valadoc_gtkdoc_renderer_real_visit_headline (ValadocContentContentVisitor* base, ValadocContentHeadline* element) {
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	g_assert_not_reached ();
}


static void valadoc_gtkdoc_renderer_real_visit_wiki_link (ValadocContentContentVisitor* base, ValadocContentWikiLink* element) {
	ValadocGtkdocRenderer * self;
	ValadocContentWikiLink* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	_tmp1_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		ValadocContentWikiLink* _tmp5_;
		_tmp5_ = element;
		valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp5_, (ValadocContentContentVisitor*) self);
	} else {
		ValadocContentWikiLink* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = element;
		_tmp7_ = valadoc_content_wiki_link_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		valadoc_gtkdoc_renderer_write_string (self, _tmp8_);
	}
}


static void valadoc_gtkdoc_renderer_real_visit_link (ValadocContentContentVisitor* base, ValadocContentLink* element) {
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	ValadocContentLink* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ValadocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	ValadocContentLink* _tmp10_;
	ValadocGtkDocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = g_strdup ("url");
	_tmp2_ = element;
	_tmp3_ = valadoc_content_link_get_url (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp1_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	_tmp8_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ulink", _tmp7_, 2);
	_tmp9_ = _tmp8_;
	_valadoc_markup_writer_unref0 (_tmp9_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp10_, (ValadocContentContentVisitor*) self);
	_tmp11_ = self->priv->writer;
	_tmp12_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp11_, "ulink");
	_tmp13_ = _tmp12_;
	_valadoc_markup_writer_unref0 (_tmp13_);
}


static void valadoc_gtkdoc_renderer_real_visit_symbol_link (ValadocContentContentVisitor* base, ValadocContentSymbolLink* element) {
	ValadocGtkdocRenderer * self;
	ValadocContentSymbolLink* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	_tmp1_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		ValadocGtkDocMarkupWriter* _tmp5_;
		ValadocMarkupWriter* _tmp6_;
		ValadocMarkupWriter* _tmp7_;
		ValadocContentSymbolLink* _tmp8_;
		ValadocGtkDocMarkupWriter* _tmp9_;
		ValadocMarkupWriter* _tmp10_;
		ValadocMarkupWriter* _tmp11_;
		ValadocContentSymbolLink* _tmp12_;
		ValadocGtkDocMarkupWriter* _tmp13_;
		ValadocMarkupWriter* _tmp14_;
		ValadocMarkupWriter* _tmp15_;
		_tmp5_ = self->priv->writer;
		_tmp6_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp5_, "\"");
		_tmp7_ = _tmp6_;
		_valadoc_markup_writer_unref0 (_tmp7_);
		_tmp8_ = element;
		valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp8_, (ValadocContentContentVisitor*) self);
		_tmp9_ = self->priv->writer;
		_tmp10_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp9_, "\" (");
		_tmp11_ = _tmp10_;
		_valadoc_markup_writer_unref0 (_tmp11_);
		_tmp12_ = element;
		valadoc_content_content_visitor_visit_symbol_link ((ValadocContentContentVisitor*) self, _tmp12_);
		_tmp13_ = self->priv->writer;
		_tmp14_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp13_, ")");
		_tmp15_ = _tmp14_;
		_valadoc_markup_writer_unref0 (_tmp15_);
	} else {
		ValadocContentSymbolLink* _tmp16_;
		_tmp16_ = element;
		valadoc_content_content_visitor_visit_symbol_link ((ValadocContentContentVisitor*) self, _tmp16_);
	}
}


void valadoc_gtkdoc_renderer_write_symbol_link (ValadocGtkdocRenderer* self, ValadocContentSymbolLink* element) {
	ValadocContentSymbolLink* _tmp0_;
	ValadocApiNode* _tmp1_;
	ValadocApiNode* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	_tmp1_ = valadoc_content_symbol_link_get_symbol (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		ValadocGtkDocMarkupWriter* _tmp3_;
		ValadocContentSymbolLink* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ValadocMarkupWriter* _tmp7_;
		ValadocMarkupWriter* _tmp8_;
		_tmp3_ = self->priv->writer;
		_tmp4_ = element;
		_tmp5_ = valadoc_content_symbol_link_get_given_symbol_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp3_, _tmp6_);
		_tmp8_ = _tmp7_;
		_valadoc_markup_writer_unref0 (_tmp8_);
	} else {
		ValadocContentSymbolLink* _tmp9_;
		ValadocApiNode* _tmp10_;
		ValadocApiNode* _tmp11_;
		_tmp9_ = element;
		_tmp10_ = valadoc_content_symbol_link_get_symbol (_tmp9_);
		_tmp11_ = _tmp10_;
		valadoc_gtkdoc_renderer_write_docbook_link (self, (ValadocApiItem*) _tmp11_);
	}
}


static void valadoc_gtkdoc_renderer_real_visit_list (ValadocContentContentVisitor* base, ValadocContentList* element) {
	ValadocGtkdocRenderer * self;
	gchar* tag = NULL;
	gchar* _tmp0_;
	ValadocContentList* _tmp1_;
	ValadocContentListBullet _tmp2_;
	ValadocContentListBullet _tmp3_;
	ValadocContentList* _tmp54_;
	ValadocGtkDocMarkupWriter* _tmp55_;
	const gchar* _tmp56_;
	ValadocMarkupWriter* _tmp57_;
	ValadocMarkupWriter* _tmp58_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = g_strdup ("orderedlist");
	tag = _tmp0_;
	_tmp1_ = element;
	_tmp2_ = valadoc_content_list_get_bullet (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case VALADOC_CONTENT_LIST_BULLET_NONE:
		{
			ValadocGtkDocMarkupWriter* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar** _tmp7_;
			gchar** _tmp8_;
			gint _tmp8__length1;
			ValadocMarkupWriter* _tmp9_;
			ValadocMarkupWriter* _tmp10_;
			gchar* _tmp11_;
			_tmp4_ = self->priv->writer;
			_tmp5_ = g_strdup ("mark");
			_tmp6_ = g_strdup ("none");
			_tmp7_ = g_new0 (gchar*, 2 + 1);
			_tmp7_[0] = _tmp5_;
			_tmp7_[1] = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp8__length1 = 2;
			_tmp9_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp4_, "itemizedlist", _tmp8_, 2);
			_tmp10_ = _tmp9_;
			_valadoc_markup_writer_unref0 (_tmp10_);
			_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
			_tmp11_ = g_strdup ("itemizedlist");
			_g_free0 (tag);
			tag = _tmp11_;
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_UNORDERED:
		{
			ValadocGtkDocMarkupWriter* _tmp12_;
			ValadocMarkupWriter* _tmp13_;
			ValadocMarkupWriter* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = self->priv->writer;
			_tmp13_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp12_, "itemizedlist", NULL, 0);
			_tmp14_ = _tmp13_;
			_valadoc_markup_writer_unref0 (_tmp14_);
			_tmp15_ = g_strdup ("itemizedlist");
			_g_free0 (tag);
			tag = _tmp15_;
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED:
		{
			ValadocGtkDocMarkupWriter* _tmp16_;
			ValadocMarkupWriter* _tmp17_;
			ValadocMarkupWriter* _tmp18_;
			_tmp16_ = self->priv->writer;
			_tmp17_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp16_, "orderedlist", NULL, 0);
			_tmp18_ = _tmp17_;
			_valadoc_markup_writer_unref0 (_tmp18_);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_NUMBER:
		{
			ValadocGtkDocMarkupWriter* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar** _tmp22_;
			gchar** _tmp23_;
			gint _tmp23__length1;
			ValadocMarkupWriter* _tmp24_;
			ValadocMarkupWriter* _tmp25_;
			_tmp19_ = self->priv->writer;
			_tmp20_ = g_strdup ("numeration");
			_tmp21_ = g_strdup ("arabic");
			_tmp22_ = g_new0 (gchar*, 2 + 1);
			_tmp22_[0] = _tmp20_;
			_tmp22_[1] = _tmp21_;
			_tmp23_ = _tmp22_;
			_tmp23__length1 = 2;
			_tmp24_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp19_, "orderedlist", _tmp23_, 2);
			_tmp25_ = _tmp24_;
			_valadoc_markup_writer_unref0 (_tmp25_);
			_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ALPHA:
		{
			ValadocGtkDocMarkupWriter* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar** _tmp29_;
			gchar** _tmp30_;
			gint _tmp30__length1;
			ValadocMarkupWriter* _tmp31_;
			ValadocMarkupWriter* _tmp32_;
			_tmp26_ = self->priv->writer;
			_tmp27_ = g_strdup ("numeration");
			_tmp28_ = g_strdup ("loweralpha");
			_tmp29_ = g_new0 (gchar*, 2 + 1);
			_tmp29_[0] = _tmp27_;
			_tmp29_[1] = _tmp28_;
			_tmp30_ = _tmp29_;
			_tmp30__length1 = 2;
			_tmp31_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp26_, "orderedlist", _tmp30_, 2);
			_tmp32_ = _tmp31_;
			_valadoc_markup_writer_unref0 (_tmp32_);
			_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ALPHA:
		{
			ValadocGtkDocMarkupWriter* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar** _tmp36_;
			gchar** _tmp37_;
			gint _tmp37__length1;
			ValadocMarkupWriter* _tmp38_;
			ValadocMarkupWriter* _tmp39_;
			_tmp33_ = self->priv->writer;
			_tmp34_ = g_strdup ("numeration");
			_tmp35_ = g_strdup ("upperalpha");
			_tmp36_ = g_new0 (gchar*, 2 + 1);
			_tmp36_[0] = _tmp34_;
			_tmp36_[1] = _tmp35_;
			_tmp37_ = _tmp36_;
			_tmp37__length1 = 2;
			_tmp38_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp33_, "orderedlist", _tmp37_, 2);
			_tmp39_ = _tmp38_;
			_valadoc_markup_writer_unref0 (_tmp39_);
			_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ROMAN:
		{
			ValadocGtkDocMarkupWriter* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar** _tmp43_;
			gchar** _tmp44_;
			gint _tmp44__length1;
			ValadocMarkupWriter* _tmp45_;
			ValadocMarkupWriter* _tmp46_;
			_tmp40_ = self->priv->writer;
			_tmp41_ = g_strdup ("numeration");
			_tmp42_ = g_strdup ("lowerroman");
			_tmp43_ = g_new0 (gchar*, 2 + 1);
			_tmp43_[0] = _tmp41_;
			_tmp43_[1] = _tmp42_;
			_tmp44_ = _tmp43_;
			_tmp44__length1 = 2;
			_tmp45_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp40_, "orderedlist", _tmp44_, 2);
			_tmp46_ = _tmp45_;
			_valadoc_markup_writer_unref0 (_tmp46_);
			_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ROMAN:
		{
			ValadocGtkDocMarkupWriter* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar** _tmp50_;
			gchar** _tmp51_;
			gint _tmp51__length1;
			ValadocMarkupWriter* _tmp52_;
			ValadocMarkupWriter* _tmp53_;
			_tmp47_ = self->priv->writer;
			_tmp48_ = g_strdup ("numeration");
			_tmp49_ = g_strdup ("upperroman");
			_tmp50_ = g_new0 (gchar*, 2 + 1);
			_tmp50_[0] = _tmp48_;
			_tmp50_[1] = _tmp49_;
			_tmp51_ = _tmp50_;
			_tmp51__length1 = 2;
			_tmp52_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp47_, "orderedlist", _tmp51_, 2);
			_tmp53_ = _tmp52_;
			_valadoc_markup_writer_unref0 (_tmp53_);
			_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp54_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp54_, (ValadocContentContentVisitor*) self);
	_tmp55_ = self->priv->writer;
	_tmp56_ = tag;
	_tmp57_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp55_, _tmp56_);
	_tmp58_ = _tmp57_;
	_valadoc_markup_writer_unref0 (_tmp58_);
	_g_free0 (tag);
}


static void valadoc_gtkdoc_renderer_real_visit_list_item (ValadocContentContentVisitor* base, ValadocContentListItem* element) {
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocContentListItem* _tmp3_;
	ValadocGtkDocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "listitem", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp3_, (ValadocContentContentVisitor*) self);
	_tmp4_ = self->priv->writer;
	_tmp5_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp4_, "listitem");
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
}


static void valadoc_gtkdoc_renderer_real_visit_page (ValadocContentContentVisitor* base, ValadocContentPage* element) {
	ValadocGtkdocRenderer * self;
	ValadocContentPage* _tmp0_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp0_, (ValadocContentContentVisitor*) self);
}


static void valadoc_gtkdoc_renderer_real_visit_paragraph (ValadocContentContentVisitor* base, ValadocContentParagraph* element) {
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocContentParagraph* _tmp3_;
	ValadocGtkDocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "para", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp3_, (ValadocContentContentVisitor*) self);
	_tmp4_ = self->priv->writer;
	_tmp5_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp4_, "para");
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
}


static void valadoc_gtkdoc_renderer_real_visit_warning (ValadocContentContentVisitor* base, ValadocContentWarning* element) {
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocContentWarning* _tmp3_;
	ValadocGtkDocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "warning", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp3_, (ValadocContentContentVisitor*) self);
	_tmp4_ = self->priv->writer;
	_tmp5_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp4_, "warning");
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
}


static void valadoc_gtkdoc_renderer_real_visit_note (ValadocContentContentVisitor* base, ValadocContentNote* element) {
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocContentNote* _tmp3_;
	ValadocGtkDocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "note", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp3_, (ValadocContentContentVisitor*) self);
	_tmp4_ = self->priv->writer;
	_tmp5_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp4_, "note");
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
}


static void valadoc_gtkdoc_renderer_real_visit_run (ValadocContentContentVisitor* base, ValadocContentRun* element) {
	ValadocGtkdocRenderer * self;
	gchar* tag = NULL;
	ValadocContentRun* _tmp0_;
	ValadocContentRunStyle _tmp1_;
	ValadocContentRunStyle _tmp2_;
	ValadocContentRun* _tmp27_;
	const gchar* _tmp28_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	tag = NULL;
	_tmp0_ = element;
	_tmp1_ = valadoc_content_run_get_style (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case VALADOC_CONTENT_RUN_STYLE_BOLD:
		{
			ValadocGtkDocMarkupWriter* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar** _tmp6_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			ValadocMarkupWriter* _tmp8_;
			ValadocMarkupWriter* _tmp9_;
			gchar* _tmp10_;
			_tmp3_ = self->priv->writer;
			_tmp4_ = g_strdup ("role");
			_tmp5_ = g_strdup ("bold");
			_tmp6_ = g_new0 (gchar*, 2 + 1);
			_tmp6_[0] = _tmp4_;
			_tmp6_[1] = _tmp5_;
			_tmp7_ = _tmp6_;
			_tmp7__length1 = 2;
			_tmp8_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp3_, "emphasis", _tmp7_, 2);
			_tmp9_ = _tmp8_;
			_valadoc_markup_writer_unref0 (_tmp9_);
			_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
			_tmp10_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp10_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_ITALIC:
		{
			ValadocGtkDocMarkupWriter* _tmp11_;
			ValadocMarkupWriter* _tmp12_;
			ValadocMarkupWriter* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = self->priv->writer;
			_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp11_, "emphasis", NULL, 0);
			_tmp13_ = _tmp12_;
			_valadoc_markup_writer_unref0 (_tmp13_);
			_tmp14_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp14_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_UNDERLINED:
		{
			ValadocGtkDocMarkupWriter* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			ValadocMarkupWriter* _tmp20_;
			ValadocMarkupWriter* _tmp21_;
			gchar* _tmp22_;
			_tmp15_ = self->priv->writer;
			_tmp16_ = g_strdup ("role");
			_tmp17_ = g_strdup ("underline");
			_tmp18_ = g_new0 (gchar*, 2 + 1);
			_tmp18_[0] = _tmp16_;
			_tmp18_[1] = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp19__length1 = 2;
			_tmp20_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp15_, "emphasis", _tmp19_, 2);
			_tmp21_ = _tmp20_;
			_valadoc_markup_writer_unref0 (_tmp21_);
			_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
			_tmp22_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp22_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_MONOSPACED:
		{
			ValadocGtkDocMarkupWriter* _tmp23_;
			ValadocMarkupWriter* _tmp24_;
			ValadocMarkupWriter* _tmp25_;
			gchar* _tmp26_;
			_tmp23_ = self->priv->writer;
			_tmp24_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp23_, "blockquote", NULL, 0);
			_tmp25_ = _tmp24_;
			_valadoc_markup_writer_unref0 (_tmp25_);
			_tmp26_ = g_strdup ("blockquote");
			_g_free0 (tag);
			tag = _tmp26_;
			break;
		}
		default:
		break;
	}
	_tmp27_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp27_, (ValadocContentContentVisitor*) self);
	_tmp28_ = tag;
	if (_tmp28_ != NULL) {
		ValadocGtkDocMarkupWriter* _tmp29_;
		const gchar* _tmp30_;
		ValadocMarkupWriter* _tmp31_;
		ValadocMarkupWriter* _tmp32_;
		_tmp29_ = self->priv->writer;
		_tmp30_ = tag;
		_tmp31_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp29_, _tmp30_);
		_tmp32_ = _tmp31_;
		_valadoc_markup_writer_unref0 (_tmp32_);
	}
	_g_free0 (tag);
}


static void valadoc_gtkdoc_renderer_real_visit_source_code (ValadocContentContentVisitor* base, ValadocContentSourceCode* element) {
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocGtkDocMarkupWriter* _tmp5_;
	ValadocContentSourceCode* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	ValadocMarkupWriter* _tmp10_;
	ValadocGtkDocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "example", NULL, 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_markup_writer_start_tag (_tmp2_, "programlisting", NULL, 0);
	_tmp4_ = _tmp3_;
	_valadoc_markup_writer_unref0 (_tmp4_);
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp5_ = self->priv->writer;
	_tmp6_ = element;
	_tmp7_ = valadoc_content_source_code_get_code (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_valadoc_markup_writer_unref0 (_tmp10_);
	_tmp11_ = self->priv->writer;
	_tmp12_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp11_, "programlisting");
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_markup_writer_end_tag (_tmp13_, "example");
	_tmp15_ = _tmp14_;
	_valadoc_markup_writer_unref0 (_tmp15_);
	_valadoc_markup_writer_unref0 (_tmp13_);
}


static void valadoc_gtkdoc_renderer_real_visit_table (ValadocContentContentVisitor* base, ValadocContentTable* element) {
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocContentTable* _tmp7_;
	ValadocGtkDocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	ValadocMarkupWriter* _tmp10_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = g_strdup ("align");
	_tmp2_ = g_strdup ("center");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "table", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp7_, (ValadocContentContentVisitor*) self);
	_tmp8_ = self->priv->writer;
	_tmp9_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp8_, "table");
	_tmp10_ = _tmp9_;
	_valadoc_markup_writer_unref0 (_tmp10_);
}


static void valadoc_gtkdoc_renderer_real_visit_table_cell (ValadocContentContentVisitor* base, ValadocContentTableCell* element) {
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	ValadocContentTableCell* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValadocContentTableCell* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	ValadocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocContentTableCell* _tmp15_;
	ValadocGtkDocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = g_strdup ("colspan");
	_tmp2_ = element;
	_tmp3_ = valadoc_content_table_cell_get_colspan (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%i", _tmp4_);
	_tmp6_ = g_strdup ("rowspan");
	_tmp7_ = element;
	_tmp8_ = valadoc_content_table_cell_get_rowspan (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
	_tmp11_ = g_new0 (gchar*, 4 + 1);
	_tmp11_[0] = _tmp1_;
	_tmp11_[1] = _tmp5_;
	_tmp11_[2] = _tmp6_;
	_tmp11_[3] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 4;
	_tmp13_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "td", _tmp12_, 4);
	_tmp14_ = _tmp13_;
	_valadoc_markup_writer_unref0 (_tmp14_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp15_, (ValadocContentContentVisitor*) self);
	_tmp16_ = self->priv->writer;
	_tmp17_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp16_, "td");
	_tmp18_ = _tmp17_;
	_valadoc_markup_writer_unref0 (_tmp18_);
}


static void valadoc_gtkdoc_renderer_real_visit_table_row (ValadocContentContentVisitor* base, ValadocContentTableRow* element) {
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocContentTableRow* _tmp3_;
	ValadocGtkDocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "tr", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = element;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp3_, (ValadocContentContentVisitor*) self);
	_tmp4_ = self->priv->writer;
	_tmp5_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp4_, "tr");
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
}


static void valadoc_gtkdoc_renderer_real_visit_text (ValadocContentContentVisitor* base, ValadocContentText* element) {
	ValadocGtkdocRenderer * self;
	ValadocContentText* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	_tmp1_ = valadoc_content_text_get_content (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_gtkdoc_renderer_write_string (self, _tmp2_);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void valadoc_gtkdoc_renderer_write_string (ValadocGtkdocRenderer* self, const gchar* content) {
	gunichar chr = 0U;
	const gchar* _tmp0_;
	gchar _tmp1_;
	glong lpos = 0L;
	gint i = 0;
	ValadocGtkDocMarkupWriter* _tmp152_;
	const gchar* _tmp153_;
	glong _tmp154_;
	gint _tmp155_;
	glong _tmp156_;
	gchar* _tmp157_;
	gchar* _tmp158_;
	ValadocMarkupWriter* _tmp159_;
	ValadocMarkupWriter* _tmp160_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	_tmp0_ = content;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	chr = (gunichar) _tmp1_;
	lpos = (glong) 0;
	i = 0;
	{
		gboolean _tmp2_ = FALSE;
		i = 0;
		_tmp2_ = TRUE;
		while (TRUE) {
			gunichar _tmp7_;
			gunichar _tmp8_;
			if (!_tmp2_) {
				gint _tmp3_;
				const gchar* _tmp4_;
				gint _tmp5_;
				gchar _tmp6_;
				_tmp3_ = i;
				i = _tmp3_ + 1;
				_tmp4_ = content;
				_tmp5_ = i;
				_tmp6_ = string_get (_tmp4_, (glong) _tmp5_);
				chr = (gunichar) _tmp6_;
			}
			_tmp2_ = FALSE;
			_tmp7_ = chr;
			if (!(_tmp7_ != ((gunichar) '\0'))) {
				break;
			}
			_tmp8_ = chr;
			switch (_tmp8_) {
				case '<':
				{
					ValadocGtkDocMarkupWriter* _tmp9_;
					const gchar* _tmp10_;
					glong _tmp11_;
					gint _tmp12_;
					glong _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					ValadocMarkupWriter* _tmp16_;
					ValadocMarkupWriter* _tmp17_;
					ValadocGtkDocMarkupWriter* _tmp18_;
					ValadocMarkupWriter* _tmp19_;
					ValadocMarkupWriter* _tmp20_;
					gint _tmp21_;
					_tmp9_ = self->priv->writer;
					_tmp10_ = content;
					_tmp11_ = lpos;
					_tmp12_ = i;
					_tmp13_ = lpos;
					_tmp14_ = string_substring (_tmp10_, _tmp11_, _tmp12_ - _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp9_, _tmp15_);
					_tmp17_ = _tmp16_;
					_valadoc_markup_writer_unref0 (_tmp17_);
					_g_free0 (_tmp15_);
					_tmp18_ = self->priv->writer;
					_tmp19_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp18_, "&lt;");
					_tmp20_ = _tmp19_;
					_valadoc_markup_writer_unref0 (_tmp20_);
					_tmp21_ = i;
					lpos = (glong) (_tmp21_ + 1);
					break;
				}
				case '>':
				{
					ValadocGtkDocMarkupWriter* _tmp22_;
					const gchar* _tmp23_;
					glong _tmp24_;
					gint _tmp25_;
					glong _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					ValadocMarkupWriter* _tmp29_;
					ValadocMarkupWriter* _tmp30_;
					ValadocGtkDocMarkupWriter* _tmp31_;
					ValadocMarkupWriter* _tmp32_;
					ValadocMarkupWriter* _tmp33_;
					gint _tmp34_;
					_tmp22_ = self->priv->writer;
					_tmp23_ = content;
					_tmp24_ = lpos;
					_tmp25_ = i;
					_tmp26_ = lpos;
					_tmp27_ = string_substring (_tmp23_, _tmp24_, _tmp25_ - _tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp22_, _tmp28_);
					_tmp30_ = _tmp29_;
					_valadoc_markup_writer_unref0 (_tmp30_);
					_g_free0 (_tmp28_);
					_tmp31_ = self->priv->writer;
					_tmp32_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp31_, "&gt;");
					_tmp33_ = _tmp32_;
					_valadoc_markup_writer_unref0 (_tmp33_);
					_tmp34_ = i;
					lpos = (glong) (_tmp34_ + 1);
					break;
				}
				case '"':
				{
					ValadocGtkDocMarkupWriter* _tmp35_;
					const gchar* _tmp36_;
					glong _tmp37_;
					gint _tmp38_;
					glong _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					ValadocMarkupWriter* _tmp42_;
					ValadocMarkupWriter* _tmp43_;
					ValadocGtkDocMarkupWriter* _tmp44_;
					ValadocMarkupWriter* _tmp45_;
					ValadocMarkupWriter* _tmp46_;
					gint _tmp47_;
					_tmp35_ = self->priv->writer;
					_tmp36_ = content;
					_tmp37_ = lpos;
					_tmp38_ = i;
					_tmp39_ = lpos;
					_tmp40_ = string_substring (_tmp36_, _tmp37_, _tmp38_ - _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp35_, _tmp41_);
					_tmp43_ = _tmp42_;
					_valadoc_markup_writer_unref0 (_tmp43_);
					_g_free0 (_tmp41_);
					_tmp44_ = self->priv->writer;
					_tmp45_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp44_, "&quot;");
					_tmp46_ = _tmp45_;
					_valadoc_markup_writer_unref0 (_tmp46_);
					_tmp47_ = i;
					lpos = (glong) (_tmp47_ + 1);
					break;
				}
				case '\'':
				{
					ValadocGtkDocMarkupWriter* _tmp48_;
					const gchar* _tmp49_;
					glong _tmp50_;
					gint _tmp51_;
					glong _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					ValadocMarkupWriter* _tmp55_;
					ValadocMarkupWriter* _tmp56_;
					ValadocGtkDocMarkupWriter* _tmp57_;
					ValadocMarkupWriter* _tmp58_;
					ValadocMarkupWriter* _tmp59_;
					gint _tmp60_;
					_tmp48_ = self->priv->writer;
					_tmp49_ = content;
					_tmp50_ = lpos;
					_tmp51_ = i;
					_tmp52_ = lpos;
					_tmp53_ = string_substring (_tmp49_, _tmp50_, _tmp51_ - _tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp48_, _tmp54_);
					_tmp56_ = _tmp55_;
					_valadoc_markup_writer_unref0 (_tmp56_);
					_g_free0 (_tmp54_);
					_tmp57_ = self->priv->writer;
					_tmp58_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp57_, "&apos;");
					_tmp59_ = _tmp58_;
					_valadoc_markup_writer_unref0 (_tmp59_);
					_tmp60_ = i;
					lpos = (glong) (_tmp60_ + 1);
					break;
				}
				case '&':
				{
					ValadocGtkDocMarkupWriter* _tmp61_;
					const gchar* _tmp62_;
					glong _tmp63_;
					gint _tmp64_;
					glong _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					ValadocMarkupWriter* _tmp68_;
					ValadocMarkupWriter* _tmp69_;
					ValadocGtkDocMarkupWriter* _tmp70_;
					ValadocMarkupWriter* _tmp71_;
					ValadocMarkupWriter* _tmp72_;
					gint _tmp73_;
					_tmp61_ = self->priv->writer;
					_tmp62_ = content;
					_tmp63_ = lpos;
					_tmp64_ = i;
					_tmp65_ = lpos;
					_tmp66_ = string_substring (_tmp62_, _tmp63_, _tmp64_ - _tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp61_, _tmp67_);
					_tmp69_ = _tmp68_;
					_valadoc_markup_writer_unref0 (_tmp69_);
					_g_free0 (_tmp67_);
					_tmp70_ = self->priv->writer;
					_tmp71_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp70_, "&amp;");
					_tmp72_ = _tmp71_;
					_valadoc_markup_writer_unref0 (_tmp72_);
					_tmp73_ = i;
					lpos = (glong) (_tmp73_ + 1);
					break;
				}
				case '#':
				{
					ValadocGtkDocMarkupWriter* _tmp74_;
					const gchar* _tmp75_;
					glong _tmp76_;
					gint _tmp77_;
					glong _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					ValadocMarkupWriter* _tmp81_;
					ValadocMarkupWriter* _tmp82_;
					ValadocGtkDocMarkupWriter* _tmp83_;
					ValadocMarkupWriter* _tmp84_;
					ValadocMarkupWriter* _tmp85_;
					gint _tmp86_;
					_tmp74_ = self->priv->writer;
					_tmp75_ = content;
					_tmp76_ = lpos;
					_tmp77_ = i;
					_tmp78_ = lpos;
					_tmp79_ = string_substring (_tmp75_, _tmp76_, _tmp77_ - _tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp74_, _tmp80_);
					_tmp82_ = _tmp81_;
					_valadoc_markup_writer_unref0 (_tmp82_);
					_g_free0 (_tmp80_);
					_tmp83_ = self->priv->writer;
					_tmp84_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp83_, "&num;");
					_tmp85_ = _tmp84_;
					_valadoc_markup_writer_unref0 (_tmp85_);
					_tmp86_ = i;
					lpos = (glong) (_tmp86_ + 1);
					break;
				}
				case '%':
				{
					ValadocGtkDocMarkupWriter* _tmp87_;
					const gchar* _tmp88_;
					glong _tmp89_;
					gint _tmp90_;
					glong _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					ValadocMarkupWriter* _tmp94_;
					ValadocMarkupWriter* _tmp95_;
					ValadocGtkDocMarkupWriter* _tmp96_;
					ValadocMarkupWriter* _tmp97_;
					ValadocMarkupWriter* _tmp98_;
					gint _tmp99_;
					_tmp87_ = self->priv->writer;
					_tmp88_ = content;
					_tmp89_ = lpos;
					_tmp90_ = i;
					_tmp91_ = lpos;
					_tmp92_ = string_substring (_tmp88_, _tmp89_, _tmp90_ - _tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp87_, _tmp93_);
					_tmp95_ = _tmp94_;
					_valadoc_markup_writer_unref0 (_tmp95_);
					_g_free0 (_tmp93_);
					_tmp96_ = self->priv->writer;
					_tmp97_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp96_, "&percnt;");
					_tmp98_ = _tmp97_;
					_valadoc_markup_writer_unref0 (_tmp98_);
					_tmp99_ = i;
					lpos = (glong) (_tmp99_ + 1);
					break;
				}
				case '@':
				{
					ValadocGtkDocMarkupWriter* _tmp100_;
					const gchar* _tmp101_;
					glong _tmp102_;
					gint _tmp103_;
					glong _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					ValadocMarkupWriter* _tmp107_;
					ValadocMarkupWriter* _tmp108_;
					ValadocGtkDocMarkupWriter* _tmp109_;
					ValadocMarkupWriter* _tmp110_;
					ValadocMarkupWriter* _tmp111_;
					gint _tmp112_;
					_tmp100_ = self->priv->writer;
					_tmp101_ = content;
					_tmp102_ = lpos;
					_tmp103_ = i;
					_tmp104_ = lpos;
					_tmp105_ = string_substring (_tmp101_, _tmp102_, _tmp103_ - _tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp100_, _tmp106_);
					_tmp108_ = _tmp107_;
					_valadoc_markup_writer_unref0 (_tmp108_);
					_g_free0 (_tmp106_);
					_tmp109_ = self->priv->writer;
					_tmp110_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp109_, "&commat;");
					_tmp111_ = _tmp110_;
					_valadoc_markup_writer_unref0 (_tmp111_);
					_tmp112_ = i;
					lpos = (glong) (_tmp112_ + 1);
					break;
				}
				case '(':
				{
					ValadocGtkDocMarkupWriter* _tmp113_;
					const gchar* _tmp114_;
					glong _tmp115_;
					gint _tmp116_;
					glong _tmp117_;
					gchar* _tmp118_;
					gchar* _tmp119_;
					ValadocMarkupWriter* _tmp120_;
					ValadocMarkupWriter* _tmp121_;
					ValadocGtkDocMarkupWriter* _tmp122_;
					ValadocMarkupWriter* _tmp123_;
					ValadocMarkupWriter* _tmp124_;
					gint _tmp125_;
					_tmp113_ = self->priv->writer;
					_tmp114_ = content;
					_tmp115_ = lpos;
					_tmp116_ = i;
					_tmp117_ = lpos;
					_tmp118_ = string_substring (_tmp114_, _tmp115_, _tmp116_ - _tmp117_);
					_tmp119_ = _tmp118_;
					_tmp120_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp113_, _tmp119_);
					_tmp121_ = _tmp120_;
					_valadoc_markup_writer_unref0 (_tmp121_);
					_g_free0 (_tmp119_);
					_tmp122_ = self->priv->writer;
					_tmp123_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp122_, "&lpar;");
					_tmp124_ = _tmp123_;
					_valadoc_markup_writer_unref0 (_tmp124_);
					_tmp125_ = i;
					lpos = (glong) (_tmp125_ + 1);
					break;
				}
				case ')':
				{
					ValadocGtkDocMarkupWriter* _tmp126_;
					const gchar* _tmp127_;
					glong _tmp128_;
					gint _tmp129_;
					glong _tmp130_;
					gchar* _tmp131_;
					gchar* _tmp132_;
					ValadocMarkupWriter* _tmp133_;
					ValadocMarkupWriter* _tmp134_;
					ValadocGtkDocMarkupWriter* _tmp135_;
					ValadocMarkupWriter* _tmp136_;
					ValadocMarkupWriter* _tmp137_;
					gint _tmp138_;
					_tmp126_ = self->priv->writer;
					_tmp127_ = content;
					_tmp128_ = lpos;
					_tmp129_ = i;
					_tmp130_ = lpos;
					_tmp131_ = string_substring (_tmp127_, _tmp128_, _tmp129_ - _tmp130_);
					_tmp132_ = _tmp131_;
					_tmp133_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp126_, _tmp132_);
					_tmp134_ = _tmp133_;
					_valadoc_markup_writer_unref0 (_tmp134_);
					_g_free0 (_tmp132_);
					_tmp135_ = self->priv->writer;
					_tmp136_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp135_, "&rpar;");
					_tmp137_ = _tmp136_;
					_valadoc_markup_writer_unref0 (_tmp137_);
					_tmp138_ = i;
					lpos = (glong) (_tmp138_ + 1);
					break;
				}
				case '\n':
				{
					ValadocGtkDocMarkupWriter* _tmp139_;
					const gchar* _tmp140_;
					glong _tmp141_;
					gint _tmp142_;
					glong _tmp143_;
					gchar* _tmp144_;
					gchar* _tmp145_;
					ValadocMarkupWriter* _tmp146_;
					ValadocMarkupWriter* _tmp147_;
					ValadocGtkDocMarkupWriter* _tmp148_;
					ValadocMarkupWriter* _tmp149_;
					ValadocMarkupWriter* _tmp150_;
					gint _tmp151_;
					_tmp139_ = self->priv->writer;
					_tmp140_ = content;
					_tmp141_ = lpos;
					_tmp142_ = i;
					_tmp143_ = lpos;
					_tmp144_ = string_substring (_tmp140_, _tmp141_, _tmp142_ - _tmp143_);
					_tmp145_ = _tmp144_;
					_tmp146_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp139_, _tmp145_);
					_tmp147_ = _tmp146_;
					_valadoc_markup_writer_unref0 (_tmp147_);
					_g_free0 (_tmp145_);
					_tmp148_ = self->priv->writer;
					_tmp149_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp148_, "br", NULL, 0);
					_tmp150_ = _tmp149_;
					_valadoc_markup_writer_unref0 (_tmp150_);
					_tmp151_ = i;
					lpos = (glong) (_tmp151_ + 1);
					break;
				}
				default:
				break;
			}
		}
	}
	_tmp152_ = self->priv->writer;
	_tmp153_ = content;
	_tmp154_ = lpos;
	_tmp155_ = i;
	_tmp156_ = lpos;
	_tmp157_ = string_substring (_tmp153_, _tmp154_, _tmp155_ - _tmp156_);
	_tmp158_ = _tmp157_;
	_tmp159_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp152_, _tmp158_);
	_tmp160_ = _tmp159_;
	_valadoc_markup_writer_unref0 (_tmp160_);
	_g_free0 (_tmp158_);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void valadoc_gtkdoc_renderer_append_since (ValadocGtkdocRenderer* self, ValaList* taglets) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (taglets != NULL);
	{
		ValaList* __taglet_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint __taglet_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint __taglet_index = 0;
		_tmp0_ = taglets;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		__taglet_list = _tmp1_;
		_tmp2_ = __taglet_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		__taglet_size = _tmp4_;
		__taglet_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValadocContentTaglet* _taglet = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValadocTagletsSince* taglet = NULL;
			ValadocContentTaglet* _tmp11_;
			ValadocTagletsSince* _tmp12_;
			gboolean _tmp13_ = FALSE;
			ValadocTagletsSince* _tmp14_;
			gboolean _tmp18_;
			ValadocGtkDocMarkupWriter* _tmp22_;
			ValadocGtkDocMarkupWriter* _tmp23_;
			ValadocMarkupWriter* _tmp24_;
			ValadocMarkupWriter* _tmp25_;
			ValadocTagletsSince* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			ValadocMarkupWriter* _tmp29_;
			ValadocMarkupWriter* _tmp30_;
			ValadocGtkDocMarkupWriter* _tmp31_;
			_tmp5_ = __taglet_index;
			__taglet_index = _tmp5_ + 1;
			_tmp6_ = __taglet_index;
			_tmp7_ = __taglet_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = __taglet_list;
			_tmp9_ = __taglet_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			_taglet = (ValadocContentTaglet*) _tmp10_;
			_tmp11_ = _taglet;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALADOC_TAGLETS_TYPE_SINCE) ? ((ValadocTagletsSince*) _tmp11_) : NULL);
			taglet = _tmp12_;
			_tmp14_ = taglet;
			if (_tmp14_ == NULL) {
				_tmp13_ = TRUE;
			} else {
				ValadocTagletsSince* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = taglet;
				_tmp16_ = valadoc_taglets_since_get_version (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp13_ = _tmp17_ == NULL;
			}
			if (_tmp13_) {
				_g_object_unref0 (taglet);
				_g_object_unref0 (_taglet);
				continue;
			}
			_tmp18_ = self->priv->separated;
			if (_tmp18_ == FALSE) {
				ValadocGtkDocMarkupWriter* _tmp19_;
				ValadocMarkupWriter* _tmp20_;
				ValadocMarkupWriter* _tmp21_;
				_tmp19_ = self->priv->writer;
				_tmp20_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp19_, "\n");
				_tmp21_ = _tmp20_;
				_valadoc_markup_writer_unref0 (_tmp21_);
			}
			_tmp22_ = self->priv->writer;
			valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp22_, FALSE);
			_tmp23_ = self->priv->writer;
			_tmp24_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp23_, "\nSince: ");
			_tmp25_ = _tmp24_;
			_tmp26_ = taglet;
			_tmp27_ = valadoc_taglets_since_get_version (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = valadoc_markup_writer_text (_tmp25_, _tmp28_);
			_tmp30_ = _tmp29_;
			_valadoc_markup_writer_unref0 (_tmp30_);
			_valadoc_markup_writer_unref0 (_tmp25_);
			_tmp31_ = self->priv->writer;
			valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp31_, TRUE);
			self->priv->separated = TRUE;
			_g_object_unref0 (taglet);
			_g_object_unref0 (_taglet);
			_vala_iterable_unref0 (__taglet_list);
			return;
		}
		_vala_iterable_unref0 (__taglet_list);
	}
}


void valadoc_gtkdoc_renderer_append_see (ValadocGtkdocRenderer* self, ValaList* taglets) {
	gboolean first = FALSE;
	gboolean _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (taglets != NULL);
	first = TRUE;
	{
		ValaList* __taglet_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint __taglet_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint __taglet_index = 0;
		_tmp0_ = taglets;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		__taglet_list = _tmp1_;
		_tmp2_ = __taglet_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		__taglet_size = _tmp4_;
		__taglet_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValadocContentTaglet* _taglet = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValadocTagletsSee* taglet = NULL;
			ValadocContentTaglet* _tmp11_;
			ValadocTagletsSee* _tmp12_;
			gboolean _tmp13_ = FALSE;
			ValadocTagletsSee* _tmp14_;
			gboolean _tmp18_;
			ValadocTagletsSee* _tmp27_;
			ValadocApiNode* _tmp28_;
			ValadocApiNode* _tmp29_;
			_tmp5_ = __taglet_index;
			__taglet_index = _tmp5_ + 1;
			_tmp6_ = __taglet_index;
			_tmp7_ = __taglet_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = __taglet_list;
			_tmp9_ = __taglet_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			_taglet = (ValadocContentTaglet*) _tmp10_;
			_tmp11_ = _taglet;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALADOC_TAGLETS_TYPE_SEE) ? ((ValadocTagletsSee*) _tmp11_) : NULL);
			taglet = _tmp12_;
			_tmp14_ = taglet;
			if (_tmp14_ == NULL) {
				_tmp13_ = TRUE;
			} else {
				ValadocTagletsSee* _tmp15_;
				ValadocApiNode* _tmp16_;
				ValadocApiNode* _tmp17_;
				_tmp15_ = taglet;
				_tmp16_ = valadoc_taglets_see_get_symbol (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp13_ = _tmp17_ == NULL;
			}
			if (_tmp13_) {
				_g_object_unref0 (taglet);
				_g_object_unref0 (_taglet);
				continue;
			}
			_tmp18_ = first;
			if (_tmp18_) {
				ValadocGtkDocMarkupWriter* _tmp19_;
				ValadocMarkupWriter* _tmp20_;
				ValadocMarkupWriter* _tmp21_;
				ValadocMarkupWriter* _tmp22_;
				ValadocMarkupWriter* _tmp23_;
				_tmp19_ = self->priv->writer;
				_tmp20_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp19_, "para", NULL, 0);
				_tmp21_ = _tmp20_;
				_tmp22_ = valadoc_markup_writer_text (_tmp21_, "See also: ");
				_tmp23_ = _tmp22_;
				_valadoc_markup_writer_unref0 (_tmp23_);
				_valadoc_markup_writer_unref0 (_tmp21_);
			} else {
				ValadocGtkDocMarkupWriter* _tmp24_;
				ValadocMarkupWriter* _tmp25_;
				ValadocMarkupWriter* _tmp26_;
				_tmp24_ = self->priv->writer;
				_tmp25_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp24_, ", ");
				_tmp26_ = _tmp25_;
				_valadoc_markup_writer_unref0 (_tmp26_);
			}
			_tmp27_ = taglet;
			_tmp28_ = valadoc_taglets_see_get_symbol (_tmp27_);
			_tmp29_ = _tmp28_;
			valadoc_gtkdoc_renderer_write_docbook_link (self, (ValadocApiItem*) _tmp29_);
			first = FALSE;
			_g_object_unref0 (taglet);
			_g_object_unref0 (_taglet);
		}
		_vala_iterable_unref0 (__taglet_list);
	}
	_tmp30_ = first;
	if (_tmp30_ == FALSE) {
		ValadocGtkDocMarkupWriter* _tmp31_;
		ValadocMarkupWriter* _tmp32_;
		ValadocMarkupWriter* _tmp33_;
		_tmp31_ = self->priv->writer;
		_tmp32_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp31_, "para");
		_tmp33_ = _tmp32_;
		_valadoc_markup_writer_unref0 (_tmp33_);
	}
}


void valadoc_gtkdoc_renderer_append_exceptions (ValadocGtkdocRenderer* self, ValaList* taglets) {
	gboolean first = FALSE;
	gboolean _tmp51_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (taglets != NULL);
	first = TRUE;
	{
		ValaList* __taglet_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint __taglet_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint __taglet_index = 0;
		_tmp0_ = taglets;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		__taglet_list = _tmp1_;
		_tmp2_ = __taglet_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		__taglet_size = _tmp4_;
		__taglet_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValadocContentTaglet* _taglet = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValadocTagletsThrows* taglet = NULL;
			ValadocContentTaglet* _tmp11_;
			ValadocTagletsThrows* _tmp12_;
			gboolean _tmp13_ = FALSE;
			ValadocTagletsThrows* _tmp14_;
			gboolean _tmp18_;
			ValadocGtkDocMarkupWriter* _tmp29_;
			ValadocMarkupWriter* _tmp30_;
			ValadocMarkupWriter* _tmp31_;
			ValadocGtkDocMarkupWriter* _tmp32_;
			ValadocMarkupWriter* _tmp33_;
			ValadocMarkupWriter* _tmp34_;
			ValadocTagletsThrows* _tmp35_;
			ValadocApiNode* _tmp36_;
			ValadocApiNode* _tmp37_;
			ValadocGtkDocMarkupWriter* _tmp38_;
			ValadocMarkupWriter* _tmp39_;
			ValadocMarkupWriter* _tmp40_;
			ValadocGtkDocMarkupWriter* _tmp41_;
			ValadocMarkupWriter* _tmp42_;
			ValadocMarkupWriter* _tmp43_;
			ValadocTagletsThrows* _tmp44_;
			ValadocGtkDocMarkupWriter* _tmp45_;
			ValadocMarkupWriter* _tmp46_;
			ValadocMarkupWriter* _tmp47_;
			ValadocGtkDocMarkupWriter* _tmp48_;
			ValadocMarkupWriter* _tmp49_;
			ValadocMarkupWriter* _tmp50_;
			_tmp5_ = __taglet_index;
			__taglet_index = _tmp5_ + 1;
			_tmp6_ = __taglet_index;
			_tmp7_ = __taglet_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = __taglet_list;
			_tmp9_ = __taglet_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			_taglet = (ValadocContentTaglet*) _tmp10_;
			_tmp11_ = _taglet;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALADOC_TAGLETS_TYPE_THROWS) ? ((ValadocTagletsThrows*) _tmp11_) : NULL);
			taglet = _tmp12_;
			_tmp14_ = taglet;
			if (_tmp14_ == NULL) {
				_tmp13_ = TRUE;
			} else {
				ValadocTagletsThrows* _tmp15_;
				ValadocApiNode* _tmp16_;
				ValadocApiNode* _tmp17_;
				_tmp15_ = taglet;
				_tmp16_ = valadoc_taglets_throws_get_error_domain (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp13_ = _tmp17_ == NULL;
			}
			if (_tmp13_) {
				_g_object_unref0 (taglet);
				_g_object_unref0 (_taglet);
				continue;
			}
			_tmp18_ = first;
			if (_tmp18_) {
				ValadocGtkDocMarkupWriter* _tmp19_;
				ValadocMarkupWriter* _tmp20_;
				ValadocMarkupWriter* _tmp21_;
				ValadocMarkupWriter* _tmp22_;
				ValadocMarkupWriter* _tmp23_;
				ValadocMarkupWriter* _tmp24_;
				ValadocMarkupWriter* _tmp25_;
				ValadocGtkDocMarkupWriter* _tmp26_;
				ValadocMarkupWriter* _tmp27_;
				ValadocMarkupWriter* _tmp28_;
				_tmp19_ = self->priv->writer;
				_tmp20_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp19_, "para", NULL, 0);
				_tmp21_ = _tmp20_;
				_tmp22_ = valadoc_markup_writer_text (_tmp21_, "This function may throw:");
				_tmp23_ = _tmp22_;
				_tmp24_ = valadoc_markup_writer_end_tag (_tmp23_, "para");
				_tmp25_ = _tmp24_;
				_valadoc_markup_writer_unref0 (_tmp25_);
				_valadoc_markup_writer_unref0 (_tmp23_);
				_valadoc_markup_writer_unref0 (_tmp21_);
				_tmp26_ = self->priv->writer;
				_tmp27_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp26_, "table", NULL, 0);
				_tmp28_ = _tmp27_;
				_valadoc_markup_writer_unref0 (_tmp28_);
			}
			_tmp29_ = self->priv->writer;
			_tmp30_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp29_, "tr", NULL, 0);
			_tmp31_ = _tmp30_;
			_valadoc_markup_writer_unref0 (_tmp31_);
			_tmp32_ = self->priv->writer;
			_tmp33_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp32_, "td", NULL, 0);
			_tmp34_ = _tmp33_;
			_valadoc_markup_writer_unref0 (_tmp34_);
			_tmp35_ = taglet;
			_tmp36_ = valadoc_taglets_throws_get_error_domain (_tmp35_);
			_tmp37_ = _tmp36_;
			valadoc_gtkdoc_renderer_write_docbook_link (self, (ValadocApiItem*) _tmp37_);
			_tmp38_ = self->priv->writer;
			_tmp39_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp38_, "td");
			_tmp40_ = _tmp39_;
			_valadoc_markup_writer_unref0 (_tmp40_);
			_tmp41_ = self->priv->writer;
			_tmp42_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp41_, "td", NULL, 0);
			_tmp43_ = _tmp42_;
			_valadoc_markup_writer_unref0 (_tmp43_);
			_tmp44_ = taglet;
			valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp44_, (ValadocContentContentVisitor*) self);
			_tmp45_ = self->priv->writer;
			_tmp46_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp45_, "td");
			_tmp47_ = _tmp46_;
			_valadoc_markup_writer_unref0 (_tmp47_);
			_tmp48_ = self->priv->writer;
			_tmp49_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp48_, "tr");
			_tmp50_ = _tmp49_;
			_valadoc_markup_writer_unref0 (_tmp50_);
			first = FALSE;
			_g_object_unref0 (taglet);
			_g_object_unref0 (_taglet);
		}
		_vala_iterable_unref0 (__taglet_list);
	}
	_tmp51_ = first;
	if (_tmp51_ == FALSE) {
		ValadocGtkDocMarkupWriter* _tmp52_;
		ValadocMarkupWriter* _tmp53_;
		ValadocMarkupWriter* _tmp54_;
		_tmp52_ = self->priv->writer;
		_tmp53_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp52_, "table");
		_tmp54_ = _tmp53_;
		_valadoc_markup_writer_unref0 (_tmp54_);
	}
}


const gchar* valadoc_gtkdoc_renderer_get_content (ValadocGtkdocRenderer* self) {
	const gchar* result;
	ValadocGtkDocMarkupWriter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	ValadocGtkDocMarkupWriter* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_gtk_doc_markup_writer_get_content (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_has_prefix (_tmp2_, "\n");
	if (_tmp3_) {
		ValadocGtkDocMarkupWriter* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = self->priv->writer;
		_tmp5_ = valadoc_gtk_doc_markup_writer_get_content (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_utf8_next_char (_tmp6_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = self->priv->writer;
	_tmp9_ = valadoc_gtk_doc_markup_writer_get_content (_tmp8_);
	_tmp10_ = _tmp9_;
	result = _tmp10_;
	return result;
}


static void valadoc_gtkdoc_renderer_class_init (ValadocGtkdocRendererClass * klass) {
	valadoc_gtkdoc_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocGtkdocRendererPrivate));
	((ValadocContentContentRendererClass *) klass)->render = (void (*) (ValadocContentContentRenderer *, ValadocContentContentElement*)) valadoc_gtkdoc_renderer_real_render;
	((ValadocContentContentRendererClass *) klass)->render_children = (void (*) (ValadocContentContentRenderer *, ValadocContentContentElement*)) valadoc_gtkdoc_renderer_real_render_children;
	((ValadocContentContentVisitorClass *) klass)->visit_comment = (void (*) (ValadocContentContentVisitor *, ValadocContentComment*)) valadoc_gtkdoc_renderer_real_visit_comment;
	((ValadocContentContentVisitorClass *) klass)->visit_embedded = (void (*) (ValadocContentContentVisitor *, ValadocContentEmbedded*)) valadoc_gtkdoc_renderer_real_visit_embedded;
	((ValadocContentContentVisitorClass *) klass)->visit_headline = (void (*) (ValadocContentContentVisitor *, ValadocContentHeadline*)) valadoc_gtkdoc_renderer_real_visit_headline;
	((ValadocContentContentVisitorClass *) klass)->visit_wiki_link = (void (*) (ValadocContentContentVisitor *, ValadocContentWikiLink*)) valadoc_gtkdoc_renderer_real_visit_wiki_link;
	((ValadocContentContentVisitorClass *) klass)->visit_link = (void (*) (ValadocContentContentVisitor *, ValadocContentLink*)) valadoc_gtkdoc_renderer_real_visit_link;
	((ValadocContentContentVisitorClass *) klass)->visit_symbol_link = (void (*) (ValadocContentContentVisitor *, ValadocContentSymbolLink*)) valadoc_gtkdoc_renderer_real_visit_symbol_link;
	((ValadocContentContentVisitorClass *) klass)->visit_list = (void (*) (ValadocContentContentVisitor *, ValadocContentList*)) valadoc_gtkdoc_renderer_real_visit_list;
	((ValadocContentContentVisitorClass *) klass)->visit_list_item = (void (*) (ValadocContentContentVisitor *, ValadocContentListItem*)) valadoc_gtkdoc_renderer_real_visit_list_item;
	((ValadocContentContentVisitorClass *) klass)->visit_page = (void (*) (ValadocContentContentVisitor *, ValadocContentPage*)) valadoc_gtkdoc_renderer_real_visit_page;
	((ValadocContentContentVisitorClass *) klass)->visit_paragraph = (void (*) (ValadocContentContentVisitor *, ValadocContentParagraph*)) valadoc_gtkdoc_renderer_real_visit_paragraph;
	((ValadocContentContentVisitorClass *) klass)->visit_warning = (void (*) (ValadocContentContentVisitor *, ValadocContentWarning*)) valadoc_gtkdoc_renderer_real_visit_warning;
	((ValadocContentContentVisitorClass *) klass)->visit_note = (void (*) (ValadocContentContentVisitor *, ValadocContentNote*)) valadoc_gtkdoc_renderer_real_visit_note;
	((ValadocContentContentVisitorClass *) klass)->visit_run = (void (*) (ValadocContentContentVisitor *, ValadocContentRun*)) valadoc_gtkdoc_renderer_real_visit_run;
	((ValadocContentContentVisitorClass *) klass)->visit_source_code = (void (*) (ValadocContentContentVisitor *, ValadocContentSourceCode*)) valadoc_gtkdoc_renderer_real_visit_source_code;
	((ValadocContentContentVisitorClass *) klass)->visit_table = (void (*) (ValadocContentContentVisitor *, ValadocContentTable*)) valadoc_gtkdoc_renderer_real_visit_table;
	((ValadocContentContentVisitorClass *) klass)->visit_table_cell = (void (*) (ValadocContentContentVisitor *, ValadocContentTableCell*)) valadoc_gtkdoc_renderer_real_visit_table_cell;
	((ValadocContentContentVisitorClass *) klass)->visit_table_row = (void (*) (ValadocContentContentVisitor *, ValadocContentTableRow*)) valadoc_gtkdoc_renderer_real_visit_table_row;
	((ValadocContentContentVisitorClass *) klass)->visit_text = (void (*) (ValadocContentContentVisitor *, ValadocContentText*)) valadoc_gtkdoc_renderer_real_visit_text;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_gtkdoc_renderer_get_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_gtkdoc_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY, valadoc_gtkdoc_renderer_properties[VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY] = g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void valadoc_gtkdoc_renderer_instance_init (ValadocGtkdocRenderer * self) {
	ValadocGtkDocMarkupWriter* _tmp0_;
	self->priv = VALADOC_GTKDOC_RENDERER_GET_PRIVATE (self);
	_tmp0_ = valadoc_gtk_doc_markup_writer_new ();
	self->priv->writer = _tmp0_;
}


static void valadoc_gtkdoc_renderer_finalize (GObject * obj) {
	ValadocGtkdocRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_GTKDOC_RENDERER, ValadocGtkdocRenderer);
	_valadoc_markup_writer_unref0 (self->priv->writer);
	_g_object_unref0 (self->settings);
	G_OBJECT_CLASS (valadoc_gtkdoc_renderer_parent_class)->finalize (obj);
}


GType valadoc_gtkdoc_renderer_get_type (void) {
	static volatile gsize valadoc_gtkdoc_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocRenderer), 0, (GInstanceInitFunc) valadoc_gtkdoc_renderer_instance_init, NULL };
		GType valadoc_gtkdoc_renderer_type_id;
		valadoc_gtkdoc_renderer_type_id = g_type_register_static (VALADOC_CONTENT_TYPE_CONTENT_RENDERER, "ValadocGtkdocRenderer", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_gtkdoc_renderer_type_id__volatile, valadoc_gtkdoc_renderer_type_id);
	}
	return valadoc_gtkdoc_renderer_type_id__volatile;
}


static void _vala_valadoc_gtkdoc_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValadocGtkdocRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_GTKDOC_RENDERER, ValadocGtkdocRenderer);
	switch (property_id) {
		case VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY:
		g_value_set_string (value, valadoc_gtkdoc_renderer_get_content (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



