/* valathrowstatement.c generated by valac, the Vala compiler
 * generated from valathrowstatement.vala, do not modify */

/* valathrowstatement.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_THROW_STATEMENT_DUMMY_PROPERTY,
	VALA_THROW_STATEMENT_LAST_PROPERTY
};
static GParamSpec* vala_throw_statement_properties[VALA_THROW_STATEMENT_LAST_PROPERTY];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaThrowStatementPrivate {
	ValaExpression* _error_expression;
};


static gpointer vala_throw_statement_parent_class = NULL;
static ValaStatementIface * vala_throw_statement_vala_statement_parent_iface = NULL;

#define VALA_THROW_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementPrivate))
static void vala_throw_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_throw_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_throw_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_throw_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_throw_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_throw_statement_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_throw_statement_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_throw_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new throw statement.
 *
 * @param error_expression the error expression
 * @param source_reference reference to source code
 * @return                 newly created throw statement
 */
ValaThrowStatement* vala_throw_statement_construct (GType object_type, ValaExpression* error_expression, ValaSourceReference* source_reference) {
	ValaThrowStatement* self = NULL;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (error_expression != NULL, NULL);
	self = (ValaThrowStatement*) vala_code_node_construct (object_type);
	_tmp0_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	_tmp1_ = error_expression;
	vala_throw_statement_set_error_expression (self, _tmp1_);
	return self;
}


ValaThrowStatement* vala_throw_statement_new (ValaExpression* error_expression, ValaSourceReference* source_reference) {
	return vala_throw_statement_construct (VALA_TYPE_THROW_STATEMENT, error_expression, source_reference);
}


static void vala_throw_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaThrowStatement * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_throw_statement (_tmp0_, self);
}


static void vala_throw_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaThrowStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_throw_statement_get_error_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCodeVisitor* _tmp4_;
		ValaCodeVisitor* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp2_ = vala_throw_statement_get_error_expression (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, _tmp4_);
		_tmp5_ = visitor;
		_tmp6_ = vala_throw_statement_get_error_expression (self);
		_tmp7_ = _tmp6_;
		vala_code_visitor_visit_end_full_expression (_tmp5_, _tmp7_);
	}
}


static void vala_throw_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaThrowStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_throw_statement_get_error_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_throw_statement_set_error_expression (self, _tmp3_);
	}
}


static gboolean vala_throw_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaThrowStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaErrorType* _tmp8_;
	ValaErrorType* _tmp9_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	ValaDataType* error_type = NULL;
	ValaExpression* _tmp44_;
	ValaExpression* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaSourceReference* _tmp50_;
	ValaSourceReference* _tmp51_;
	ValaDataType* _tmp52_;
	gboolean _tmp53_;
	gboolean _tmp54_;
	self = (ValaThrowStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_throw_statement_get_error_expression (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_error_type_new (NULL, NULL, _tmp7_);
	_tmp9_ = _tmp8_;
	vala_expression_set_target_type (_tmp5_, (ValaDataType*) _tmp9_);
	_vala_code_node_unref0 (_tmp9_);
	_tmp10_ = vala_throw_statement_get_error_expression (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_expression_get_target_type (_tmp11_);
	_tmp13_ = _tmp12_;
	vala_data_type_set_value_owned (_tmp13_, TRUE);
	_tmp14_ = vala_throw_statement_get_error_expression (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaCodeContext* _tmp18_;
		gboolean _tmp19_;
		ValaExpression* _tmp20_;
		ValaExpression* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		_tmp16_ = vala_throw_statement_get_error_expression (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = context;
		_tmp19_ = vala_code_node_check ((ValaCodeNode*) _tmp17_, _tmp18_);
		if (!_tmp19_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp20_ = vala_throw_statement_get_error_expression (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_expression_get_value_type (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ == NULL) {
			ValaExpression* _tmp24_;
			ValaExpression* _tmp25_;
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			_tmp24_ = vala_throw_statement_get_error_expression (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "invalid error expression");
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp28_ = vala_throw_statement_get_error_expression (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_value_type (_tmp29_);
		_tmp31_ = _tmp30_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_ERROR_TYPE)) {
			ValaExpression* _tmp32_;
			ValaExpression* _tmp33_;
			ValaSourceReference* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			ValaDataType* _tmp38_;
			ValaDataType* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp32_ = vala_throw_statement_get_error_expression (self);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_throw_statement_get_error_expression (self);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_expression_get_value_type (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_code_node_to_string ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strdup_printf ("`%s' is not an error type", _tmp41_);
			_tmp43_ = _tmp42_;
			vala_report_error (_tmp35_, _tmp43_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp44_ = vala_throw_statement_get_error_expression (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_expression_get_value_type (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_data_type_copy (_tmp47_);
	error_type = _tmp48_;
	_tmp49_ = error_type;
	_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp51_ = _tmp50_;
	vala_code_node_set_source_reference ((ValaCodeNode*) _tmp49_, _tmp51_);
	_tmp52_ = error_type;
	vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp52_);
	_tmp53_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp54_ = _tmp53_;
	result = !_tmp54_;
	_vala_code_node_unref0 (error_type);
	return result;
}


static void vala_throw_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaThrowStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeGenerator* _tmp8_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_throw_statement_get_error_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCodeGenerator* _tmp4_;
		ValaCodeGenerator* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp2_ = vala_throw_statement_get_error_expression (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = codegen;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, _tmp4_);
		_tmp5_ = codegen;
		_tmp6_ = vala_throw_statement_get_error_expression (self);
		_tmp7_ = _tmp6_;
		vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) _tmp5_, _tmp7_);
	}
	_tmp8_ = codegen;
	vala_code_visitor_visit_throw_statement ((ValaCodeVisitor*) _tmp8_, self);
}


static void vala_throw_statement_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaThrowStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_throw_statement_get_error_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
}


static void vala_throw_statement_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaThrowStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_throw_statement_get_error_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
}


ValaExpression* vala_throw_statement_get_error_expression (ValaThrowStatement* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_expression;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_throw_statement_set_error_expression (ValaThrowStatement* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_error_expression);
	self->priv->_error_expression = _tmp1_;
	_tmp2_ = self->priv->_error_expression;
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_;
		_tmp3_ = self->priv->_error_expression;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


static void vala_throw_statement_class_init (ValaThrowStatementClass * klass) {
	vala_throw_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_throw_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaThrowStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_throw_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_throw_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_throw_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_throw_statement_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_throw_statement_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_throw_statement_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_throw_statement_real_get_used_variables;
}


static void vala_throw_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_throw_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_throw_statement_instance_init (ValaThrowStatement * self) {
	self->priv = VALA_THROW_STATEMENT_GET_PRIVATE (self);
}


static void vala_throw_statement_finalize (ValaCodeNode * obj) {
	ValaThrowStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_THROW_STATEMENT, ValaThrowStatement);
	_vala_code_node_unref0 (self->priv->_error_expression);
	VALA_CODE_NODE_CLASS (vala_throw_statement_parent_class)->finalize (obj);
}


/**
 * Represents a throw statement in the source code.
 */
GType vala_throw_statement_get_type (void) {
	static volatile gsize vala_throw_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_throw_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaThrowStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_throw_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaThrowStatement), 0, (GInstanceInitFunc) vala_throw_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_throw_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_throw_statement_type_id;
		vala_throw_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaThrowStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_throw_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_throw_statement_type_id__volatile, vala_throw_statement_type_id);
	}
	return vala_throw_statement_type_id__volatile;
}



