/* valaforeachstatement.c generated by valac, the Vala compiler
 * generated from valaforeachstatement.vala, do not modify */

/* valaforeachstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALA_FOREACH_STATEMENT_DUMMY_PROPERTY,
	VALA_FOREACH_STATEMENT_LAST_PROPERTY
};
static GParamSpec* vala_foreach_statement_properties[VALA_FOREACH_STATEMENT_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaForeachStatementPrivate {
	gchar* _variable_name;
	gboolean _use_iterator;
	ValaLocalVariable* _element_variable;
	ValaLocalVariable* _collection_variable;
	ValaLocalVariable* _iterator_variable;
	ValaExpression* _collection;
	ValaBlock* _body;
	ValaDataType* _data_type;
};


static gpointer vala_foreach_statement_parent_class = NULL;

#define VALA_FOREACH_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementPrivate))
static void vala_foreach_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static void vala_foreach_statement_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_foreach_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
static gboolean vala_foreach_statement_check_without_iterator (ValaForeachStatement* self, ValaCodeContext* context, ValaDataType* collection_type, ValaDataType* element_type);
static gboolean vala_foreach_statement_check_with_iterator (ValaForeachStatement* self, ValaCodeContext* context, ValaDataType* collection_type);
static gboolean vala_foreach_statement_check_with_index (ValaForeachStatement* self, ValaCodeContext* context, ValaDataType* collection_type);
static void vala_foreach_statement_set_use_iterator (ValaForeachStatement* self, gboolean value);
static gboolean vala_foreach_statement_analyze_element_type (ValaForeachStatement* self, ValaDataType* element_type);
static void vala_foreach_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_foreach_statement_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_foreach_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new foreach statement.
 *
 * @param type_reference    element type
 * @param variable_name     element variable name
 * @param collection        container
 * @param body              loop body
 * @param source_reference  reference to source code
 * @return                  newly created foreach statement
 */
ValaForeachStatement* vala_foreach_statement_construct (GType object_type, ValaDataType* type_reference, const gchar* variable_name, ValaExpression* collection, ValaBlock* body, ValaSourceReference* source_reference) {
	ValaForeachStatement* self = NULL;
	ValaSourceReference* _tmp0_;
	const gchar* _tmp1_;
	ValaExpression* _tmp2_;
	ValaBlock* _tmp3_;
	ValaDataType* _tmp4_;
	g_return_val_if_fail (variable_name != NULL, NULL);
	g_return_val_if_fail (collection != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	_tmp0_ = source_reference;
	self = (ValaForeachStatement*) vala_block_construct (object_type, _tmp0_);
	_tmp1_ = variable_name;
	vala_foreach_statement_set_variable_name (self, _tmp1_);
	_tmp2_ = collection;
	vala_foreach_statement_set_collection (self, _tmp2_);
	_tmp3_ = body;
	vala_foreach_statement_set_body (self, _tmp3_);
	_tmp4_ = type_reference;
	vala_foreach_statement_set_type_reference (self, _tmp4_);
	return self;
}


ValaForeachStatement* vala_foreach_statement_new (ValaDataType* type_reference, const gchar* variable_name, ValaExpression* collection, ValaBlock* body, ValaSourceReference* source_reference) {
	return vala_foreach_statement_construct (VALA_TYPE_FOREACH_STATEMENT, type_reference, variable_name, collection, body, source_reference);
}


static void vala_foreach_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaForeachStatement * self;
	gboolean _tmp0_;
	ValaCodeVisitor* _tmp2_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_use_iterator;
	if (_tmp0_) {
		ValaCodeVisitor* _tmp1_;
		_tmp1_ = visitor;
		VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->accept ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), _tmp1_);
		return;
	}
	_tmp2_ = visitor;
	vala_code_visitor_visit_foreach_statement (_tmp2_, self);
}


static void vala_foreach_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaForeachStatement * self;
	gboolean _tmp0_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaCodeVisitor* _tmp4_;
	ValaCodeVisitor* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaBlock* _tmp13_;
	ValaBlock* _tmp14_;
	ValaCodeVisitor* _tmp15_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_use_iterator;
	if (_tmp0_) {
		ValaCodeVisitor* _tmp1_;
		_tmp1_ = visitor;
		VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), _tmp1_);
		return;
	}
	_tmp2_ = vala_foreach_statement_get_collection (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, _tmp4_);
	_tmp5_ = visitor;
	_tmp6_ = vala_foreach_statement_get_collection (self);
	_tmp7_ = _tmp6_;
	vala_code_visitor_visit_end_full_expression (_tmp5_, _tmp7_);
	_tmp8_ = vala_foreach_statement_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		ValaCodeVisitor* _tmp12_;
		_tmp10_ = vala_foreach_statement_get_type_reference (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
	}
	_tmp13_ = vala_foreach_statement_get_body (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp14_, _tmp15_);
}


static void vala_foreach_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaForeachStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_foreach_statement_get_collection (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_foreach_statement_set_collection (self, _tmp3_);
	}
}


static void vala_foreach_statement_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaForeachStatement * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_foreach_statement_get_type_reference (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_foreach_statement_set_type_reference (self, _tmp3_);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_foreach_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaForeachStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCodeContext* _tmp6_;
	gboolean _tmp7_;
	ValaDataType* collection_type = NULL;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	gboolean _tmp27_;
	self = (ValaForeachStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_foreach_statement_get_collection (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	if (!_tmp7_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	} else {
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp8_ = vala_foreach_statement_get_collection (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_expression_get_value_type (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			_tmp12_ = vala_foreach_statement_get_collection (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_error (_tmp15_, "invalid collection expression");
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp16_ = vala_foreach_statement_get_collection (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_expression_get_value_type (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_data_type_copy (_tmp19_);
	collection_type = _tmp20_;
	_tmp21_ = vala_foreach_statement_get_collection (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = collection_type;
	_tmp24_ = vala_data_type_copy (_tmp23_);
	_tmp25_ = _tmp24_;
	vala_expression_set_target_type (_tmp22_, _tmp25_);
	_vala_code_node_unref0 (_tmp25_);
	_tmp26_ = collection_type;
	_tmp27_ = vala_data_type_is_array (_tmp26_);
	if (_tmp27_) {
		ValaArrayType* array_type = NULL;
		ValaDataType* _tmp28_;
		ValaArrayType* _tmp29_;
		ValaArrayType* _tmp30_;
		ValaCodeContext* _tmp31_;
		ValaDataType* _tmp32_;
		ValaArrayType* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		gboolean _tmp36_;
		_tmp28_ = collection_type;
		_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp29_;
		_tmp30_ = array_type;
		vala_array_type_set_inline_allocated (_tmp30_, FALSE);
		_tmp31_ = context;
		_tmp32_ = collection_type;
		_tmp33_ = array_type;
		_tmp34_ = vala_array_type_get_element_type (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_foreach_statement_check_without_iterator (self, _tmp31_, _tmp32_, _tmp35_);
		result = _tmp36_;
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (collection_type);
		return result;
	} else {
		gboolean _tmp37_ = FALSE;
		ValaDataType* _tmp38_;
		ValaCodeContext* _tmp39_;
		ValaSemanticAnalyzer* _tmp40_;
		ValaSemanticAnalyzer* _tmp41_;
		ValaDataType* _tmp42_;
		gboolean _tmp43_;
		_tmp38_ = collection_type;
		_tmp39_ = context;
		_tmp40_ = vala_code_context_get_analyzer (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = _tmp41_->glist_type;
		_tmp43_ = vala_data_type_compatible (_tmp38_, _tmp42_);
		if (_tmp43_) {
			_tmp37_ = TRUE;
		} else {
			ValaDataType* _tmp44_;
			ValaCodeContext* _tmp45_;
			ValaSemanticAnalyzer* _tmp46_;
			ValaSemanticAnalyzer* _tmp47_;
			ValaDataType* _tmp48_;
			gboolean _tmp49_;
			_tmp44_ = collection_type;
			_tmp45_ = context;
			_tmp46_ = vala_code_context_get_analyzer (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = _tmp47_->gslist_type;
			_tmp49_ = vala_data_type_compatible (_tmp44_, _tmp48_);
			_tmp37_ = _tmp49_;
		}
		if (_tmp37_) {
			ValaDataType* _tmp50_;
			ValaList* _tmp51_;
			ValaList* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			gboolean _tmp55_;
			ValaCodeContext* _tmp60_;
			ValaDataType* _tmp61_;
			ValaDataType* _tmp62_;
			ValaList* _tmp63_;
			ValaList* _tmp64_;
			gpointer _tmp65_;
			ValaDataType* _tmp66_;
			gboolean _tmp67_;
			gboolean _tmp68_;
			_tmp50_ = collection_type;
			_tmp51_ = vala_data_type_get_type_arguments (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = _tmp54_ != 1;
			_vala_iterable_unref0 (_tmp52_);
			if (_tmp55_) {
				ValaExpression* _tmp56_;
				ValaExpression* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp56_ = vala_foreach_statement_get_collection (self);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				vala_report_error (_tmp59_, "missing type argument for collection");
				result = FALSE;
				_vala_code_node_unref0 (collection_type);
				return result;
			}
			_tmp60_ = context;
			_tmp61_ = collection_type;
			_tmp62_ = collection_type;
			_tmp63_ = vala_data_type_get_type_arguments (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_list_get (_tmp64_, 0);
			_tmp66_ = (ValaDataType*) _tmp65_;
			_tmp67_ = vala_foreach_statement_check_without_iterator (self, _tmp60_, _tmp61_, _tmp66_);
			_tmp68_ = _tmp67_;
			_vala_code_node_unref0 (_tmp66_);
			_vala_iterable_unref0 (_tmp64_);
			result = _tmp68_;
			_vala_code_node_unref0 (collection_type);
			return result;
		} else {
			ValaDataType* _tmp69_;
			ValaCodeContext* _tmp70_;
			ValaSemanticAnalyzer* _tmp71_;
			ValaSemanticAnalyzer* _tmp72_;
			ValaDataType* _tmp73_;
			gboolean _tmp74_;
			_tmp69_ = collection_type;
			_tmp70_ = context;
			_tmp71_ = vala_code_context_get_analyzer (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = _tmp72_->gvaluearray_type;
			_tmp74_ = vala_data_type_compatible (_tmp69_, _tmp73_);
			if (_tmp74_) {
				ValaCodeContext* _tmp75_;
				ValaDataType* _tmp76_;
				ValaCodeContext* _tmp77_;
				ValaSemanticAnalyzer* _tmp78_;
				ValaSemanticAnalyzer* _tmp79_;
				ValaStructValueType* _tmp80_;
				gboolean _tmp81_;
				_tmp75_ = context;
				_tmp76_ = collection_type;
				_tmp77_ = context;
				_tmp78_ = vala_code_context_get_analyzer (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = _tmp79_->gvalue_type;
				_tmp81_ = vala_foreach_statement_check_without_iterator (self, _tmp75_, _tmp76_, (ValaDataType*) _tmp80_);
				result = _tmp81_;
				_vala_code_node_unref0 (collection_type);
				return result;
			} else {
				ValaCodeContext* _tmp82_;
				ValaDataType* _tmp83_;
				gboolean _tmp84_;
				_tmp82_ = context;
				_tmp83_ = collection_type;
				_tmp84_ = vala_foreach_statement_check_with_iterator (self, _tmp82_, _tmp83_);
				result = _tmp84_;
				_vala_code_node_unref0 (collection_type);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (collection_type);
}


static gboolean vala_foreach_statement_check_with_index (ValaForeachStatement* self, ValaCodeContext* context, ValaDataType* collection_type) {
	gboolean result = FALSE;
	ValaMethod* get_method = NULL;
	ValaDataType* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaMethod* _tmp3_;
	ValaMethod* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	ValaProperty* size_property = NULL;
	ValaDataType* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaProperty* _tmp12_;
	ValaProperty* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	ValaExpression* _tmp17_;
	ValaExpression* _tmp18_;
	ValaSourceReference* _tmp19_;
	ValaSourceReference* _tmp20_;
	ValaLocalVariable* _tmp21_;
	ValaLocalVariable* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaSourceReference* _tmp24_;
	ValaDeclarationStatement* _tmp25_;
	ValaDeclarationStatement* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaMemberAccess* _tmp35_;
	ValaMemberAccess* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaSourceReference* _tmp38_;
	ValaMemberAccess* _tmp39_;
	ValaMemberAccess* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaLocalVariable* _tmp43_;
	ValaLocalVariable* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaSourceReference* _tmp46_;
	ValaDeclarationStatement* _tmp47_;
	ValaDeclarationStatement* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	ValaSourceReference* _tmp52_;
	ValaSourceReference* _tmp53_;
	ValaIntegerLiteral* _tmp54_;
	ValaIntegerLiteral* _tmp55_;
	ValaSourceReference* _tmp56_;
	ValaSourceReference* _tmp57_;
	ValaUnaryExpression* _tmp58_;
	ValaUnaryExpression* _tmp59_;
	ValaSourceReference* _tmp60_;
	ValaSourceReference* _tmp61_;
	ValaLocalVariable* _tmp62_;
	ValaLocalVariable* _tmp63_;
	ValaSourceReference* _tmp64_;
	ValaSourceReference* _tmp65_;
	ValaDeclarationStatement* _tmp66_;
	ValaDeclarationStatement* _tmp67_;
	ValaUnaryExpression* next = NULL;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	ValaSourceReference* _tmp71_;
	ValaSourceReference* _tmp72_;
	ValaMemberAccess* _tmp73_;
	ValaMemberAccess* _tmp74_;
	ValaSourceReference* _tmp75_;
	ValaSourceReference* _tmp76_;
	ValaUnaryExpression* _tmp77_;
	ValaUnaryExpression* _tmp78_;
	ValaBinaryExpression* conditional = NULL;
	ValaUnaryExpression* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	ValaSourceReference* _tmp83_;
	ValaSourceReference* _tmp84_;
	ValaMemberAccess* _tmp85_;
	ValaMemberAccess* _tmp86_;
	ValaSourceReference* _tmp87_;
	ValaSourceReference* _tmp88_;
	ValaBinaryExpression* _tmp89_;
	ValaBinaryExpression* _tmp90_;
	ValaWhileStatement* loop = NULL;
	ValaBinaryExpression* _tmp91_;
	ValaBlock* _tmp92_;
	ValaBlock* _tmp93_;
	ValaSourceReference* _tmp94_;
	ValaSourceReference* _tmp95_;
	ValaWhileStatement* _tmp96_;
	ValaWhileStatement* _tmp97_;
	ValaMethodCall* get_call = NULL;
	const gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	ValaSourceReference* _tmp101_;
	ValaSourceReference* _tmp102_;
	ValaMemberAccess* _tmp103_;
	ValaMemberAccess* _tmp104_;
	ValaSourceReference* _tmp105_;
	ValaSourceReference* _tmp106_;
	ValaMemberAccess* _tmp107_;
	ValaMemberAccess* _tmp108_;
	ValaSourceReference* _tmp109_;
	ValaSourceReference* _tmp110_;
	ValaMethodCall* _tmp111_;
	ValaMethodCall* _tmp112_;
	ValaMethodCall* _tmp113_;
	const gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	ValaSourceReference* _tmp117_;
	ValaSourceReference* _tmp118_;
	ValaMemberAccess* _tmp119_;
	ValaMemberAccess* _tmp120_;
	ValaBlock* _tmp121_;
	ValaBlock* _tmp122_;
	ValaDataType* _tmp123_;
	ValaDataType* _tmp124_;
	const gchar* _tmp125_;
	ValaMethodCall* _tmp126_;
	ValaSourceReference* _tmp127_;
	ValaSourceReference* _tmp128_;
	ValaLocalVariable* _tmp129_;
	ValaLocalVariable* _tmp130_;
	ValaSourceReference* _tmp131_;
	ValaSourceReference* _tmp132_;
	ValaDeclarationStatement* _tmp133_;
	ValaDeclarationStatement* _tmp134_;
	ValaCodeContext* _tmp135_;
	gboolean _tmp136_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (collection_type != NULL, FALSE);
	_tmp0_ = collection_type;
	_tmp1_ = vala_data_type_get_member (_tmp0_, "get");
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_vala_code_node_unref0 (_tmp1_);
	}
	get_method = _tmp2_;
	_tmp3_ = get_method;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (get_method);
		return result;
	}
	_tmp4_ = get_method;
	_tmp5_ = vala_callable_get_parameters ((ValaCallable*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != 1;
	_vala_iterable_unref0 (_tmp6_);
	if (_tmp9_) {
		result = FALSE;
		_vala_code_node_unref0 (get_method);
		return result;
	}
	_tmp10_ = collection_type;
	_tmp11_ = vala_data_type_get_member (_tmp10_, "size");
	_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp11_) : NULL;
	if (_tmp12_ == NULL) {
		_vala_code_node_unref0 (_tmp11_);
	}
	size_property = _tmp12_;
	_tmp13_ = size_property;
	if (_tmp13_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (size_property);
		_vala_code_node_unref0 (get_method);
		return result;
	}
	_tmp14_ = self->priv->_variable_name;
	_tmp15_ = g_strdup_printf ("_%s_list", _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_foreach_statement_get_collection (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_local_variable_new (NULL, _tmp16_, _tmp18_, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_declaration_statement_new ((ValaSymbol*) _tmp22_, _tmp24_);
	_tmp26_ = _tmp25_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp26_);
	_vala_code_node_unref0 (_tmp26_);
	_vala_code_node_unref0 (_tmp22_);
	_g_free0 (_tmp16_);
	_tmp27_ = self->priv->_variable_name;
	_tmp28_ = g_strdup_printf ("_%s_size", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->_variable_name;
	_tmp31_ = g_strdup_printf ("_%s_list", _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_member_access_new_simple (_tmp32_, _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_member_access_new ((ValaExpression*) _tmp36_, "size", _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_local_variable_new (NULL, _tmp29_, (ValaExpression*) _tmp40_, _tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_declaration_statement_new ((ValaSymbol*) _tmp44_, _tmp46_);
	_tmp48_ = _tmp47_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp48_);
	_vala_code_node_unref0 (_tmp48_);
	_vala_code_node_unref0 (_tmp44_);
	_vala_code_node_unref0 (_tmp40_);
	_vala_code_node_unref0 (_tmp36_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp29_);
	_tmp49_ = self->priv->_variable_name;
	_tmp50_ = g_strdup_printf ("_%s_index", _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_integer_literal_new ("1", _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_MINUS, (ValaExpression*) _tmp55_, _tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_local_variable_new (NULL, _tmp51_, (ValaExpression*) _tmp59_, _tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_declaration_statement_new ((ValaSymbol*) _tmp63_, _tmp65_);
	_tmp67_ = _tmp66_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp67_);
	_vala_code_node_unref0 (_tmp67_);
	_vala_code_node_unref0 (_tmp63_);
	_vala_code_node_unref0 (_tmp59_);
	_vala_code_node_unref0 (_tmp55_);
	_g_free0 (_tmp51_);
	_tmp68_ = self->priv->_variable_name;
	_tmp69_ = g_strdup_printf ("_%s_index", _tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp72_ = _tmp71_;
	_tmp73_ = vala_member_access_new_simple (_tmp70_, _tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp76_ = _tmp75_;
	_tmp77_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_INCREMENT, (ValaExpression*) _tmp74_, _tmp76_);
	_tmp78_ = _tmp77_;
	_vala_code_node_unref0 (_tmp74_);
	_g_free0 (_tmp70_);
	next = _tmp78_;
	_tmp79_ = next;
	_tmp80_ = self->priv->_variable_name;
	_tmp81_ = g_strdup_printf ("_%s_size", _tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp84_ = _tmp83_;
	_tmp85_ = vala_member_access_new_simple (_tmp82_, _tmp84_);
	_tmp86_ = _tmp85_;
	_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp88_ = _tmp87_;
	_tmp89_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_LESS_THAN, (ValaExpression*) _tmp79_, (ValaExpression*) _tmp86_, _tmp88_);
	_tmp90_ = _tmp89_;
	_vala_code_node_unref0 (_tmp86_);
	_g_free0 (_tmp82_);
	conditional = _tmp90_;
	_tmp91_ = conditional;
	_tmp92_ = vala_foreach_statement_get_body (self);
	_tmp93_ = _tmp92_;
	_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp95_ = _tmp94_;
	_tmp96_ = vala_while_statement_new ((ValaExpression*) _tmp91_, _tmp93_, _tmp95_);
	loop = _tmp96_;
	_tmp97_ = loop;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp97_);
	_tmp98_ = self->priv->_variable_name;
	_tmp99_ = g_strdup_printf ("_%s_list", _tmp98_);
	_tmp100_ = _tmp99_;
	_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_member_access_new_simple (_tmp100_, _tmp102_);
	_tmp104_ = _tmp103_;
	_tmp105_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp106_ = _tmp105_;
	_tmp107_ = vala_member_access_new ((ValaExpression*) _tmp104_, "get", _tmp106_);
	_tmp108_ = _tmp107_;
	_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_method_call_new ((ValaExpression*) _tmp108_, _tmp110_);
	_tmp112_ = _tmp111_;
	_vala_code_node_unref0 (_tmp108_);
	_vala_code_node_unref0 (_tmp104_);
	_g_free0 (_tmp100_);
	get_call = _tmp112_;
	_tmp113_ = get_call;
	_tmp114_ = self->priv->_variable_name;
	_tmp115_ = g_strdup_printf ("_%s_index", _tmp114_);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp118_ = _tmp117_;
	_tmp119_ = vala_member_access_new_simple (_tmp116_, _tmp118_);
	_tmp120_ = _tmp119_;
	vala_method_call_add_argument (_tmp113_, (ValaExpression*) _tmp120_);
	_vala_code_node_unref0 (_tmp120_);
	_g_free0 (_tmp116_);
	_tmp121_ = vala_foreach_statement_get_body (self);
	_tmp122_ = _tmp121_;
	_tmp123_ = vala_foreach_statement_get_type_reference (self);
	_tmp124_ = _tmp123_;
	_tmp125_ = self->priv->_variable_name;
	_tmp126_ = get_call;
	_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_local_variable_new (_tmp124_, _tmp125_, (ValaExpression*) _tmp126_, _tmp128_);
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_declaration_statement_new ((ValaSymbol*) _tmp130_, _tmp132_);
	_tmp134_ = _tmp133_;
	vala_block_insert_statement (_tmp122_, 0, (ValaStatement*) _tmp134_);
	_vala_code_node_unref0 (_tmp134_);
	_vala_code_node_unref0 (_tmp130_);
	vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
	_tmp135_ = context;
	_tmp136_ = VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), _tmp135_);
	result = _tmp136_;
	_vala_code_node_unref0 (get_call);
	_vala_code_node_unref0 (loop);
	_vala_code_node_unref0 (conditional);
	_vala_code_node_unref0 (next);
	_vala_code_node_unref0 (size_property);
	_vala_code_node_unref0 (get_method);
	return result;
}


static gboolean vala_foreach_statement_check_with_iterator (ValaForeachStatement* self, ValaCodeContext* context, ValaDataType* collection_type) {
	gboolean result = FALSE;
	ValaCodeContext* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean _tmp2_;
	ValaMethod* iterator_method = NULL;
	ValaDataType* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaMethod* _tmp5_;
	ValaMethod* _tmp6_;
	ValaMethod* _tmp16_;
	ValaList* _tmp17_;
	ValaList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gboolean _tmp21_;
	ValaDataType* iterator_type = NULL;
	ValaMethod* _tmp31_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	ValaDataType* _tmp34_;
	ValaDataType* _tmp35_;
	ValaDataType* _tmp36_;
	ValaMethodCall* iterator_call = NULL;
	ValaExpression* _tmp46_;
	ValaExpression* _tmp47_;
	ValaSourceReference* _tmp48_;
	ValaSourceReference* _tmp49_;
	ValaMemberAccess* _tmp50_;
	ValaMemberAccess* _tmp51_;
	ValaSourceReference* _tmp52_;
	ValaSourceReference* _tmp53_;
	ValaMethodCall* _tmp54_;
	ValaMethodCall* _tmp55_;
	ValaDataType* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	ValaMethodCall* _tmp60_;
	ValaSourceReference* _tmp61_;
	ValaSourceReference* _tmp62_;
	ValaLocalVariable* _tmp63_;
	ValaLocalVariable* _tmp64_;
	ValaSourceReference* _tmp65_;
	ValaSourceReference* _tmp66_;
	ValaDeclarationStatement* _tmp67_;
	ValaDeclarationStatement* _tmp68_;
	ValaMethod* next_value_method = NULL;
	ValaDataType* _tmp69_;
	ValaSymbol* _tmp70_;
	ValaMethod* _tmp71_;
	ValaMethod* next_method = NULL;
	ValaDataType* _tmp72_;
	ValaSymbol* _tmp73_;
	ValaMethod* _tmp74_;
	ValaMethod* _tmp75_;
	ValaCodeContext* _tmp300_;
	gboolean _tmp301_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (collection_type != NULL, FALSE);
	vala_foreach_statement_set_use_iterator (self, TRUE);
	_tmp0_ = context;
	_tmp1_ = collection_type;
	_tmp2_ = vala_foreach_statement_check_with_index (self, _tmp0_, _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = collection_type;
	_tmp4_ = vala_data_type_get_member (_tmp3_, "iterator");
	_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp4_) : NULL;
	if (_tmp5_ == NULL) {
		_vala_code_node_unref0 (_tmp4_);
	}
	iterator_method = _tmp5_;
	_tmp6_ = iterator_method;
	if (_tmp6_ == NULL) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaDataType* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp7_ = vala_foreach_statement_get_collection (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = collection_type;
		_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("`%s' does not have an `iterator' method", _tmp13_);
		_tmp15_ = _tmp14_;
		vala_report_error (_tmp10_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (iterator_method);
		return result;
	}
	_tmp16_ = iterator_method;
	_tmp17_ = vala_callable_get_parameters ((ValaCallable*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_ != 0;
	_vala_iterable_unref0 (_tmp18_);
	if (_tmp21_) {
		ValaExpression* _tmp22_;
		ValaExpression* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaMethod* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp22_ = vala_foreach_statement_get_collection (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = iterator_method;
		_tmp27_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strdup_printf ("`%s' must not have any parameters", _tmp28_);
		_tmp30_ = _tmp29_;
		vala_report_error (_tmp25_, _tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (iterator_method);
		return result;
	}
	_tmp31_ = iterator_method;
	_tmp32_ = vala_callable_get_return_type ((ValaCallable*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = collection_type;
	_tmp35_ = vala_data_type_get_actual_type (_tmp33_, _tmp34_, NULL, (ValaCodeNode*) self);
	iterator_type = _tmp35_;
	_tmp36_ = iterator_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_VOID_TYPE)) {
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaSourceReference* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaMethod* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp37_ = vala_foreach_statement_get_collection (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = iterator_method;
		_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strdup_printf ("`%s' must return an iterator", _tmp43_);
		_tmp45_ = _tmp44_;
		vala_report_error (_tmp40_, _tmp45_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (iterator_type);
		_vala_code_node_unref0 (iterator_method);
		return result;
	}
	_tmp46_ = vala_foreach_statement_get_collection (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_member_access_new (_tmp47_, "iterator", _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_method_call_new ((ValaExpression*) _tmp51_, _tmp53_);
	_tmp55_ = _tmp54_;
	_vala_code_node_unref0 (_tmp51_);
	iterator_call = _tmp55_;
	_tmp56_ = iterator_type;
	_tmp57_ = self->priv->_variable_name;
	_tmp58_ = g_strdup_printf ("_%s_it", _tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = iterator_call;
	_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp62_ = _tmp61_;
	_tmp63_ = vala_local_variable_new (_tmp56_, _tmp59_, (ValaExpression*) _tmp60_, _tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp66_ = _tmp65_;
	_tmp67_ = vala_declaration_statement_new ((ValaSymbol*) _tmp64_, _tmp66_);
	_tmp68_ = _tmp67_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp68_);
	_vala_code_node_unref0 (_tmp68_);
	_vala_code_node_unref0 (_tmp64_);
	_g_free0 (_tmp59_);
	_tmp69_ = iterator_type;
	_tmp70_ = vala_data_type_get_member (_tmp69_, "next_value");
	_tmp71_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp70_) : NULL;
	if (_tmp71_ == NULL) {
		_vala_code_node_unref0 (_tmp70_);
	}
	next_value_method = _tmp71_;
	_tmp72_ = iterator_type;
	_tmp73_ = vala_data_type_get_member (_tmp72_, "next");
	_tmp74_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp73_) : NULL;
	if (_tmp74_ == NULL) {
		_vala_code_node_unref0 (_tmp73_);
	}
	next_method = _tmp74_;
	_tmp75_ = next_value_method;
	if (_tmp75_ != NULL) {
		ValaMethod* _tmp76_;
		ValaList* _tmp77_;
		ValaList* _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		gboolean _tmp81_;
		ValaDataType* element_type = NULL;
		ValaMethod* _tmp91_;
		ValaDataType* _tmp92_;
		ValaDataType* _tmp93_;
		ValaDataType* _tmp94_;
		ValaDataType* _tmp95_;
		ValaDataType* _tmp96_;
		gboolean _tmp97_;
		gboolean _tmp98_;
		ValaDataType* _tmp108_;
		gboolean _tmp109_;
		ValaDataType* _tmp110_;
		ValaDataType* _tmp111_;
		const gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaLocalVariable* _tmp115_;
		ValaLocalVariable* _tmp116_;
		ValaSourceReference* _tmp117_;
		ValaSourceReference* _tmp118_;
		ValaDeclarationStatement* _tmp119_;
		ValaDeclarationStatement* _tmp120_;
		ValaMethodCall* next_value_call = NULL;
		const gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		ValaMemberAccess* _tmp126_;
		ValaMemberAccess* _tmp127_;
		ValaSourceReference* _tmp128_;
		ValaSourceReference* _tmp129_;
		ValaMemberAccess* _tmp130_;
		ValaMemberAccess* _tmp131_;
		ValaSourceReference* _tmp132_;
		ValaSourceReference* _tmp133_;
		ValaMethodCall* _tmp134_;
		ValaMethodCall* _tmp135_;
		ValaAssignment* assignment = NULL;
		const gchar* _tmp136_;
		ValaSourceReference* _tmp137_;
		ValaSourceReference* _tmp138_;
		ValaMemberAccess* _tmp139_;
		ValaMemberAccess* _tmp140_;
		ValaMethodCall* _tmp141_;
		ValaSourceReference* _tmp142_;
		ValaSourceReference* _tmp143_;
		ValaAssignment* _tmp144_;
		ValaAssignment* _tmp145_;
		ValaBinaryExpression* conditional = NULL;
		ValaAssignment* _tmp146_;
		ValaSourceReference* _tmp147_;
		ValaSourceReference* _tmp148_;
		ValaNullLiteral* _tmp149_;
		ValaNullLiteral* _tmp150_;
		ValaSourceReference* _tmp151_;
		ValaSourceReference* _tmp152_;
		ValaBinaryExpression* _tmp153_;
		ValaBinaryExpression* _tmp154_;
		ValaWhileStatement* loop = NULL;
		ValaBinaryExpression* _tmp155_;
		ValaBlock* _tmp156_;
		ValaBlock* _tmp157_;
		ValaSourceReference* _tmp158_;
		ValaSourceReference* _tmp159_;
		ValaWhileStatement* _tmp160_;
		ValaWhileStatement* _tmp161_;
		_tmp76_ = next_value_method;
		_tmp77_ = vala_callable_get_parameters ((ValaCallable*) _tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = _tmp80_ != 0;
		_vala_iterable_unref0 (_tmp78_);
		if (_tmp81_) {
			ValaExpression* _tmp82_;
			ValaExpression* _tmp83_;
			ValaSourceReference* _tmp84_;
			ValaSourceReference* _tmp85_;
			ValaMethod* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			_tmp82_ = vala_foreach_statement_get_collection (self);
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = next_value_method;
			_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = g_strdup_printf ("`%s' must not have any parameters", _tmp88_);
			_tmp90_ = _tmp89_;
			vala_report_error (_tmp85_, _tmp90_);
			_g_free0 (_tmp90_);
			_g_free0 (_tmp88_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
		_tmp91_ = next_value_method;
		_tmp92_ = vala_callable_get_return_type ((ValaCallable*) _tmp91_);
		_tmp93_ = _tmp92_;
		_tmp94_ = iterator_type;
		_tmp95_ = vala_data_type_get_actual_type (_tmp93_, _tmp94_, NULL, (ValaCodeNode*) self);
		element_type = _tmp95_;
		_tmp96_ = element_type;
		_tmp97_ = vala_data_type_get_nullable (_tmp96_);
		_tmp98_ = _tmp97_;
		if (!_tmp98_) {
			ValaExpression* _tmp99_;
			ValaExpression* _tmp100_;
			ValaSourceReference* _tmp101_;
			ValaSourceReference* _tmp102_;
			ValaMethod* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			_tmp99_ = vala_foreach_statement_get_collection (self);
			_tmp100_ = _tmp99_;
			_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp100_);
			_tmp102_ = _tmp101_;
			_tmp103_ = next_value_method;
			_tmp104_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp103_);
			_tmp105_ = _tmp104_;
			_tmp106_ = g_strdup_printf ("return type of `%s' must be nullable", _tmp105_);
			_tmp107_ = _tmp106_;
			vala_report_error (_tmp102_, _tmp107_);
			_g_free0 (_tmp107_);
			_g_free0 (_tmp105_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
		_tmp108_ = element_type;
		_tmp109_ = vala_foreach_statement_analyze_element_type (self, _tmp108_);
		if (!_tmp109_) {
			result = FALSE;
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
		_tmp110_ = vala_foreach_statement_get_type_reference (self);
		_tmp111_ = _tmp110_;
		_tmp112_ = self->priv->_variable_name;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_local_variable_new (_tmp111_, _tmp112_, NULL, _tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_declaration_statement_new ((ValaSymbol*) _tmp116_, _tmp118_);
		_tmp120_ = _tmp119_;
		vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp120_);
		_vala_code_node_unref0 (_tmp120_);
		_vala_code_node_unref0 (_tmp116_);
		_tmp121_ = self->priv->_variable_name;
		_tmp122_ = g_strdup_printf ("_%s_it", _tmp121_);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_member_access_new_simple (_tmp123_, _tmp125_);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp129_ = _tmp128_;
		_tmp130_ = vala_member_access_new ((ValaExpression*) _tmp127_, "next_value", _tmp129_);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_method_call_new ((ValaExpression*) _tmp131_, _tmp133_);
		_tmp135_ = _tmp134_;
		_vala_code_node_unref0 (_tmp131_);
		_vala_code_node_unref0 (_tmp127_);
		_g_free0 (_tmp123_);
		next_value_call = _tmp135_;
		_tmp136_ = self->priv->_variable_name;
		_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp138_ = _tmp137_;
		_tmp139_ = vala_member_access_new (NULL, _tmp136_, _tmp138_);
		_tmp140_ = _tmp139_;
		_tmp141_ = next_value_call;
		_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_assignment_new ((ValaExpression*) _tmp140_, (ValaExpression*) _tmp141_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp143_);
		_tmp145_ = _tmp144_;
		_vala_code_node_unref0 (_tmp140_);
		assignment = _tmp145_;
		_tmp146_ = assignment;
		_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_null_literal_new (_tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp152_ = _tmp151_;
		_tmp153_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_INEQUALITY, (ValaExpression*) _tmp146_, (ValaExpression*) _tmp150_, _tmp152_);
		_tmp154_ = _tmp153_;
		_vala_code_node_unref0 (_tmp150_);
		conditional = _tmp154_;
		_tmp155_ = conditional;
		_tmp156_ = vala_foreach_statement_get_body (self);
		_tmp157_ = _tmp156_;
		_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_while_statement_new ((ValaExpression*) _tmp155_, _tmp157_, _tmp159_);
		loop = _tmp160_;
		_tmp161_ = loop;
		vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp161_);
		_vala_code_node_unref0 (loop);
		_vala_code_node_unref0 (conditional);
		_vala_code_node_unref0 (assignment);
		_vala_code_node_unref0 (next_value_call);
		_vala_code_node_unref0 (element_type);
	} else {
		ValaMethod* _tmp162_;
		_tmp162_ = next_method;
		if (_tmp162_ != NULL) {
			ValaMethod* _tmp163_;
			ValaList* _tmp164_;
			ValaList* _tmp165_;
			gint _tmp166_;
			gint _tmp167_;
			gboolean _tmp168_;
			ValaMethod* _tmp178_;
			ValaDataType* _tmp179_;
			ValaDataType* _tmp180_;
			ValaCodeContext* _tmp181_;
			ValaSemanticAnalyzer* _tmp182_;
			ValaSemanticAnalyzer* _tmp183_;
			ValaDataType* _tmp184_;
			gboolean _tmp185_;
			ValaMethod* get_method = NULL;
			ValaDataType* _tmp195_;
			ValaSymbol* _tmp196_;
			ValaMethod* _tmp197_;
			ValaMethod* _tmp198_;
			ValaMethod* _tmp208_;
			ValaList* _tmp209_;
			ValaList* _tmp210_;
			gint _tmp211_;
			gint _tmp212_;
			gboolean _tmp213_;
			ValaDataType* element_type = NULL;
			ValaMethod* _tmp223_;
			ValaDataType* _tmp224_;
			ValaDataType* _tmp225_;
			ValaDataType* _tmp226_;
			ValaDataType* _tmp227_;
			ValaDataType* _tmp228_;
			ValaDataType* _tmp238_;
			gboolean _tmp239_;
			ValaMethodCall* next_call = NULL;
			const gchar* _tmp240_;
			gchar* _tmp241_;
			gchar* _tmp242_;
			ValaSourceReference* _tmp243_;
			ValaSourceReference* _tmp244_;
			ValaMemberAccess* _tmp245_;
			ValaMemberAccess* _tmp246_;
			ValaSourceReference* _tmp247_;
			ValaSourceReference* _tmp248_;
			ValaMemberAccess* _tmp249_;
			ValaMemberAccess* _tmp250_;
			ValaSourceReference* _tmp251_;
			ValaSourceReference* _tmp252_;
			ValaMethodCall* _tmp253_;
			ValaMethodCall* _tmp254_;
			ValaWhileStatement* loop = NULL;
			ValaMethodCall* _tmp255_;
			ValaBlock* _tmp256_;
			ValaBlock* _tmp257_;
			ValaSourceReference* _tmp258_;
			ValaSourceReference* _tmp259_;
			ValaWhileStatement* _tmp260_;
			ValaWhileStatement* _tmp261_;
			ValaMethodCall* get_call = NULL;
			const gchar* _tmp262_;
			gchar* _tmp263_;
			gchar* _tmp264_;
			ValaSourceReference* _tmp265_;
			ValaSourceReference* _tmp266_;
			ValaMemberAccess* _tmp267_;
			ValaMemberAccess* _tmp268_;
			ValaSourceReference* _tmp269_;
			ValaSourceReference* _tmp270_;
			ValaMemberAccess* _tmp271_;
			ValaMemberAccess* _tmp272_;
			ValaSourceReference* _tmp273_;
			ValaSourceReference* _tmp274_;
			ValaMethodCall* _tmp275_;
			ValaMethodCall* _tmp276_;
			ValaBlock* _tmp277_;
			ValaBlock* _tmp278_;
			ValaDataType* _tmp279_;
			ValaDataType* _tmp280_;
			const gchar* _tmp281_;
			ValaMethodCall* _tmp282_;
			ValaSourceReference* _tmp283_;
			ValaSourceReference* _tmp284_;
			ValaLocalVariable* _tmp285_;
			ValaLocalVariable* _tmp286_;
			ValaSourceReference* _tmp287_;
			ValaSourceReference* _tmp288_;
			ValaDeclarationStatement* _tmp289_;
			ValaDeclarationStatement* _tmp290_;
			_tmp163_ = next_method;
			_tmp164_ = vala_callable_get_parameters ((ValaCallable*) _tmp163_);
			_tmp165_ = _tmp164_;
			_tmp166_ = vala_collection_get_size ((ValaCollection*) _tmp165_);
			_tmp167_ = _tmp166_;
			_tmp168_ = _tmp167_ != 0;
			_vala_iterable_unref0 (_tmp165_);
			if (_tmp168_) {
				ValaExpression* _tmp169_;
				ValaExpression* _tmp170_;
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				ValaMethod* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				_tmp169_ = vala_foreach_statement_get_collection (self);
				_tmp170_ = _tmp169_;
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp170_);
				_tmp172_ = _tmp171_;
				_tmp173_ = next_method;
				_tmp174_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = g_strdup_printf ("`%s' must not have any parameters", _tmp175_);
				_tmp177_ = _tmp176_;
				vala_report_error (_tmp172_, _tmp177_);
				_g_free0 (_tmp177_);
				_g_free0 (_tmp175_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp178_ = next_method;
			_tmp179_ = vala_callable_get_return_type ((ValaCallable*) _tmp178_);
			_tmp180_ = _tmp179_;
			_tmp181_ = context;
			_tmp182_ = vala_code_context_get_analyzer (_tmp181_);
			_tmp183_ = _tmp182_;
			_tmp184_ = _tmp183_->bool_type;
			_tmp185_ = vala_data_type_compatible (_tmp180_, _tmp184_);
			if (!_tmp185_) {
				ValaExpression* _tmp186_;
				ValaExpression* _tmp187_;
				ValaSourceReference* _tmp188_;
				ValaSourceReference* _tmp189_;
				ValaMethod* _tmp190_;
				gchar* _tmp191_;
				gchar* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				_tmp186_ = vala_foreach_statement_get_collection (self);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp187_);
				_tmp189_ = _tmp188_;
				_tmp190_ = next_method;
				_tmp191_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp190_);
				_tmp192_ = _tmp191_;
				_tmp193_ = g_strdup_printf ("`%s' must return a boolean value", _tmp192_);
				_tmp194_ = _tmp193_;
				vala_report_error (_tmp189_, _tmp194_);
				_g_free0 (_tmp194_);
				_g_free0 (_tmp192_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp195_ = iterator_type;
			_tmp196_ = vala_data_type_get_member (_tmp195_, "get");
			_tmp197_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp196_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp196_) : NULL;
			if (_tmp197_ == NULL) {
				_vala_code_node_unref0 (_tmp196_);
			}
			get_method = _tmp197_;
			_tmp198_ = get_method;
			if (_tmp198_ == NULL) {
				ValaExpression* _tmp199_;
				ValaExpression* _tmp200_;
				ValaSourceReference* _tmp201_;
				ValaSourceReference* _tmp202_;
				ValaDataType* _tmp203_;
				gchar* _tmp204_;
				gchar* _tmp205_;
				gchar* _tmp206_;
				gchar* _tmp207_;
				_tmp199_ = vala_foreach_statement_get_collection (self);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = iterator_type;
				_tmp204_ = vala_code_node_to_string ((ValaCodeNode*) _tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = g_strdup_printf ("`%s' does not have a `get' method", _tmp205_);
				_tmp207_ = _tmp206_;
				vala_report_error (_tmp202_, _tmp207_);
				_g_free0 (_tmp207_);
				_g_free0 (_tmp205_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp208_ = get_method;
			_tmp209_ = vala_callable_get_parameters ((ValaCallable*) _tmp208_);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
			_tmp212_ = _tmp211_;
			_tmp213_ = _tmp212_ != 0;
			_vala_iterable_unref0 (_tmp210_);
			if (_tmp213_) {
				ValaExpression* _tmp214_;
				ValaExpression* _tmp215_;
				ValaSourceReference* _tmp216_;
				ValaSourceReference* _tmp217_;
				ValaMethod* _tmp218_;
				gchar* _tmp219_;
				gchar* _tmp220_;
				gchar* _tmp221_;
				gchar* _tmp222_;
				_tmp214_ = vala_foreach_statement_get_collection (self);
				_tmp215_ = _tmp214_;
				_tmp216_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp215_);
				_tmp217_ = _tmp216_;
				_tmp218_ = get_method;
				_tmp219_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp218_);
				_tmp220_ = _tmp219_;
				_tmp221_ = g_strdup_printf ("`%s' must not have any parameters", _tmp220_);
				_tmp222_ = _tmp221_;
				vala_report_error (_tmp217_, _tmp222_);
				_g_free0 (_tmp222_);
				_g_free0 (_tmp220_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp223_ = get_method;
			_tmp224_ = vala_callable_get_return_type ((ValaCallable*) _tmp223_);
			_tmp225_ = _tmp224_;
			_tmp226_ = iterator_type;
			_tmp227_ = vala_data_type_get_actual_type (_tmp225_, _tmp226_, NULL, (ValaCodeNode*) self);
			element_type = _tmp227_;
			_tmp228_ = element_type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp228_, VALA_TYPE_VOID_TYPE)) {
				ValaExpression* _tmp229_;
				ValaExpression* _tmp230_;
				ValaSourceReference* _tmp231_;
				ValaSourceReference* _tmp232_;
				ValaMethod* _tmp233_;
				gchar* _tmp234_;
				gchar* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				_tmp229_ = vala_foreach_statement_get_collection (self);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp230_);
				_tmp232_ = _tmp231_;
				_tmp233_ = get_method;
				_tmp234_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp233_);
				_tmp235_ = _tmp234_;
				_tmp236_ = g_strdup_printf ("`%s' must return an element", _tmp235_);
				_tmp237_ = _tmp236_;
				vala_report_error (_tmp232_, _tmp237_);
				_g_free0 (_tmp237_);
				_g_free0 (_tmp235_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (element_type);
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp238_ = element_type;
			_tmp239_ = vala_foreach_statement_analyze_element_type (self, _tmp238_);
			if (!_tmp239_) {
				result = FALSE;
				_vala_code_node_unref0 (element_type);
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp240_ = self->priv->_variable_name;
			_tmp241_ = g_strdup_printf ("_%s_it", _tmp240_);
			_tmp242_ = _tmp241_;
			_tmp243_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp244_ = _tmp243_;
			_tmp245_ = vala_member_access_new_simple (_tmp242_, _tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp248_ = _tmp247_;
			_tmp249_ = vala_member_access_new ((ValaExpression*) _tmp246_, "next", _tmp248_);
			_tmp250_ = _tmp249_;
			_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp252_ = _tmp251_;
			_tmp253_ = vala_method_call_new ((ValaExpression*) _tmp250_, _tmp252_);
			_tmp254_ = _tmp253_;
			_vala_code_node_unref0 (_tmp250_);
			_vala_code_node_unref0 (_tmp246_);
			_g_free0 (_tmp242_);
			next_call = _tmp254_;
			_tmp255_ = next_call;
			_tmp256_ = vala_foreach_statement_get_body (self);
			_tmp257_ = _tmp256_;
			_tmp258_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp259_ = _tmp258_;
			_tmp260_ = vala_while_statement_new ((ValaExpression*) _tmp255_, _tmp257_, _tmp259_);
			loop = _tmp260_;
			_tmp261_ = loop;
			vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp261_);
			_tmp262_ = self->priv->_variable_name;
			_tmp263_ = g_strdup_printf ("_%s_it", _tmp262_);
			_tmp264_ = _tmp263_;
			_tmp265_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp266_ = _tmp265_;
			_tmp267_ = vala_member_access_new_simple (_tmp264_, _tmp266_);
			_tmp268_ = _tmp267_;
			_tmp269_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp270_ = _tmp269_;
			_tmp271_ = vala_member_access_new ((ValaExpression*) _tmp268_, "get", _tmp270_);
			_tmp272_ = _tmp271_;
			_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp274_ = _tmp273_;
			_tmp275_ = vala_method_call_new ((ValaExpression*) _tmp272_, _tmp274_);
			_tmp276_ = _tmp275_;
			_vala_code_node_unref0 (_tmp272_);
			_vala_code_node_unref0 (_tmp268_);
			_g_free0 (_tmp264_);
			get_call = _tmp276_;
			_tmp277_ = vala_foreach_statement_get_body (self);
			_tmp278_ = _tmp277_;
			_tmp279_ = vala_foreach_statement_get_type_reference (self);
			_tmp280_ = _tmp279_;
			_tmp281_ = self->priv->_variable_name;
			_tmp282_ = get_call;
			_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp284_ = _tmp283_;
			_tmp285_ = vala_local_variable_new (_tmp280_, _tmp281_, (ValaExpression*) _tmp282_, _tmp284_);
			_tmp286_ = _tmp285_;
			_tmp287_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp288_ = _tmp287_;
			_tmp289_ = vala_declaration_statement_new ((ValaSymbol*) _tmp286_, _tmp288_);
			_tmp290_ = _tmp289_;
			vala_block_insert_statement (_tmp278_, 0, (ValaStatement*) _tmp290_);
			_vala_code_node_unref0 (_tmp290_);
			_vala_code_node_unref0 (_tmp286_);
			_vala_code_node_unref0 (get_call);
			_vala_code_node_unref0 (loop);
			_vala_code_node_unref0 (next_call);
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (get_method);
		} else {
			ValaExpression* _tmp291_;
			ValaExpression* _tmp292_;
			ValaSourceReference* _tmp293_;
			ValaSourceReference* _tmp294_;
			ValaDataType* _tmp295_;
			gchar* _tmp296_;
			gchar* _tmp297_;
			gchar* _tmp298_;
			gchar* _tmp299_;
			_tmp291_ = vala_foreach_statement_get_collection (self);
			_tmp292_ = _tmp291_;
			_tmp293_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp292_);
			_tmp294_ = _tmp293_;
			_tmp295_ = iterator_type;
			_tmp296_ = vala_code_node_to_string ((ValaCodeNode*) _tmp295_);
			_tmp297_ = _tmp296_;
			_tmp298_ = g_strdup_printf ("`%s' does not have a `next_value' or `next' method", _tmp297_);
			_tmp299_ = _tmp298_;
			vala_report_error (_tmp294_, _tmp299_);
			_g_free0 (_tmp299_);
			_g_free0 (_tmp297_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
	_tmp300_ = context;
	_tmp301_ = VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), _tmp300_);
	result = _tmp301_;
	_vala_code_node_unref0 (next_method);
	_vala_code_node_unref0 (next_value_method);
	_vala_code_node_unref0 (iterator_call);
	_vala_code_node_unref0 (iterator_type);
	_vala_code_node_unref0 (iterator_method);
	return result;
}


static gboolean vala_foreach_statement_analyze_element_type (ValaForeachStatement* self, ValaDataType* element_type) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (element_type != NULL, FALSE);
	_tmp0_ = vala_foreach_statement_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp2_ = element_type;
		_tmp3_ = vala_data_type_copy (_tmp2_);
		_tmp4_ = _tmp3_;
		vala_foreach_statement_set_type_reference (self, _tmp4_);
		_vala_code_node_unref0 (_tmp4_);
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = element_type;
		_tmp6_ = vala_foreach_statement_get_type_reference (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_data_type_compatible (_tmp5_, _tmp7_);
		if (!_tmp8_) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaDataType* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			ValaDataType* _tmp14_;
			ValaDataType* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = element_type;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_foreach_statement_get_type_reference (self);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_code_node_to_string ((ValaCodeNode*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf ("Foreach: Cannot convert from `%s' to `%s'", _tmp13_, _tmp17_);
			_tmp19_ = _tmp18_;
			vala_report_error (_tmp10_, _tmp19_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			result = FALSE;
			return result;
		} else {
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			ValaDataType* _tmp22_;
			gboolean _tmp23_;
			_tmp22_ = element_type;
			_tmp23_ = vala_data_type_is_disposable (_tmp22_);
			if (_tmp23_) {
				ValaDataType* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp24_ = element_type;
				_tmp25_ = vala_data_type_get_value_owned (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp21_ = _tmp26_;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				ValaDataType* _tmp27_;
				ValaDataType* _tmp28_;
				gboolean _tmp29_;
				gboolean _tmp30_;
				_tmp27_ = vala_foreach_statement_get_type_reference (self);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_data_type_get_value_owned (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp20_ = !_tmp30_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp32_, "Foreach: Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean vala_foreach_statement_check_without_iterator (ValaForeachStatement* self, ValaCodeContext* context, ValaDataType* collection_type, ValaDataType* element_type) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp20_;
	ValaDataType* _tmp21_;
	const gchar* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaSourceReference* _tmp24_;
	ValaLocalVariable* _tmp25_;
	ValaLocalVariable* _tmp26_;
	ValaBlock* _tmp27_;
	ValaBlock* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	const gchar* _tmp31_;
	ValaLocalVariable* _tmp32_;
	ValaBlock* _tmp33_;
	ValaBlock* _tmp34_;
	ValaLocalVariable* _tmp35_;
	ValaLocalVariable* _tmp36_;
	ValaLocalVariable* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaSemanticAnalyzer* _tmp39_;
	ValaSemanticAnalyzer* _tmp40_;
	ValaSymbol* _tmp41_;
	ValaSymbol* _tmp42_;
	ValaScope* _tmp43_;
	ValaScope* _tmp44_;
	ValaCodeContext* _tmp45_;
	ValaSemanticAnalyzer* _tmp46_;
	ValaSemanticAnalyzer* _tmp47_;
	ValaLocalVariable* _tmp48_;
	ValaLocalVariable* _tmp49_;
	ValaBlock* _tmp50_;
	ValaBlock* _tmp51_;
	ValaCodeContext* _tmp52_;
	ValaCodeContext* _tmp64_;
	ValaSemanticAnalyzer* _tmp65_;
	ValaSemanticAnalyzer* _tmp66_;
	ValaCodeContext* _tmp67_;
	ValaSemanticAnalyzer* _tmp68_;
	ValaSemanticAnalyzer* _tmp69_;
	ValaSymbol* _tmp70_;
	ValaSymbol* _tmp71_;
	ValaSymbol* _tmp72_;
	ValaSymbol* _tmp73_;
	ValaDataType* _tmp74_;
	ValaDataType* _tmp75_;
	ValaDataType* _tmp76_;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	ValaLocalVariable* _tmp80_;
	ValaLocalVariable* _tmp81_;
	ValaLocalVariable* _tmp82_;
	ValaLocalVariable* _tmp83_;
	ValaExpression* _tmp84_;
	ValaExpression* _tmp85_;
	ValaList* _tmp86_;
	ValaList* _tmp87_;
	ValaBlock* _tmp88_;
	ValaBlock* _tmp89_;
	ValaList* _tmp90_;
	ValaList* _tmp91_;
	gboolean _tmp92_;
	gboolean _tmp93_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (collection_type != NULL, FALSE);
	g_return_val_if_fail (element_type != NULL, FALSE);
	_tmp0_ = vala_foreach_statement_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp2_ = element_type;
		_tmp3_ = vala_data_type_copy (_tmp2_);
		_tmp4_ = _tmp3_;
		vala_foreach_statement_set_type_reference (self, _tmp4_);
		_vala_code_node_unref0 (_tmp4_);
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = element_type;
		_tmp6_ = vala_foreach_statement_get_type_reference (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_data_type_compatible (_tmp5_, _tmp7_);
		if (!_tmp8_) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaDataType* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			ValaDataType* _tmp14_;
			ValaDataType* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = element_type;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_foreach_statement_get_type_reference (self);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_code_node_to_string ((ValaCodeNode*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf ("Foreach: Cannot convert from `%s' to `%s'", _tmp13_, _tmp17_);
			_tmp19_ = _tmp18_;
			vala_report_error (_tmp10_, _tmp19_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			result = FALSE;
			return result;
		}
	}
	_tmp20_ = vala_foreach_statement_get_type_reference (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->_variable_name;
	_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_local_variable_new (_tmp21_, _tmp22_, NULL, _tmp24_);
	_tmp26_ = _tmp25_;
	vala_foreach_statement_set_element_variable (self, _tmp26_);
	_vala_code_node_unref0 (_tmp26_);
	_tmp27_ = vala_foreach_statement_get_body (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_symbol_get_scope ((ValaSymbol*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->_variable_name;
	_tmp32_ = self->priv->_element_variable;
	vala_scope_add (_tmp30_, _tmp31_, (ValaSymbol*) _tmp32_);
	_tmp33_ = vala_foreach_statement_get_body (self);
	_tmp34_ = _tmp33_;
	_tmp35_ = self->priv->_element_variable;
	vala_block_add_local_variable (_tmp34_, _tmp35_);
	_tmp36_ = self->priv->_element_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp36_, TRUE);
	_tmp37_ = self->priv->_element_variable;
	vala_code_node_set_checked ((ValaCodeNode*) _tmp37_, TRUE);
	_tmp38_ = context;
	_tmp39_ = vala_code_context_get_analyzer (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_semantic_analyzer_get_current_symbol (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_symbol_get_scope (_tmp42_);
	_tmp44_ = _tmp43_;
	vala_symbol_set_owner ((ValaSymbol*) self, _tmp44_);
	_tmp45_ = context;
	_tmp46_ = vala_code_context_get_analyzer (_tmp45_);
	_tmp47_ = _tmp46_;
	vala_semantic_analyzer_set_current_symbol (_tmp47_, (ValaSymbol*) self);
	_tmp48_ = self->priv->_element_variable;
	vala_block_add_local_variable ((ValaBlock*) self, _tmp48_);
	_tmp49_ = self->priv->_element_variable;
	vala_block_remove_local_variable ((ValaBlock*) self, _tmp49_);
	_tmp50_ = vala_foreach_statement_get_body (self);
	_tmp51_ = _tmp50_;
	_tmp52_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp51_, _tmp52_);
	{
		ValaList* _local_list = NULL;
		ValaList* _tmp53_;
		gint _local_size = 0;
		ValaList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		gint _local_index = 0;
		_tmp53_ = vala_block_get_local_variables ((ValaBlock*) self);
		_local_list = _tmp53_;
		_tmp54_ = _local_list;
		_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
		_tmp56_ = _tmp55_;
		_local_size = _tmp56_;
		_local_index = -1;
		while (TRUE) {
			gint _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			ValaLocalVariable* local = NULL;
			ValaList* _tmp60_;
			gint _tmp61_;
			gpointer _tmp62_;
			ValaLocalVariable* _tmp63_;
			_tmp57_ = _local_index;
			_local_index = _tmp57_ + 1;
			_tmp58_ = _local_index;
			_tmp59_ = _local_size;
			if (!(_tmp58_ < _tmp59_)) {
				break;
			}
			_tmp60_ = _local_list;
			_tmp61_ = _local_index;
			_tmp62_ = vala_list_get (_tmp60_, _tmp61_);
			local = (ValaLocalVariable*) _tmp62_;
			_tmp63_ = local;
			vala_symbol_set_active ((ValaSymbol*) _tmp63_, FALSE);
			_vala_code_node_unref0 (local);
		}
		_vala_iterable_unref0 (_local_list);
	}
	_tmp64_ = context;
	_tmp65_ = vala_code_context_get_analyzer (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = context;
	_tmp68_ = vala_code_context_get_analyzer (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = vala_semantic_analyzer_get_current_symbol (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_symbol_get_parent_symbol (_tmp71_);
	_tmp73_ = _tmp72_;
	vala_semantic_analyzer_set_current_symbol (_tmp66_, _tmp73_);
	_tmp74_ = collection_type;
	_tmp75_ = vala_data_type_copy (_tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = self->priv->_variable_name;
	_tmp78_ = g_strdup_printf ("%s_collection", _tmp77_);
	_tmp79_ = _tmp78_;
	_tmp80_ = vala_local_variable_new (_tmp76_, _tmp79_, NULL, NULL);
	_tmp81_ = _tmp80_;
	vala_foreach_statement_set_collection_variable (self, _tmp81_);
	_vala_code_node_unref0 (_tmp81_);
	_g_free0 (_tmp79_);
	_vala_code_node_unref0 (_tmp76_);
	_tmp82_ = self->priv->_collection_variable;
	vala_block_add_local_variable ((ValaBlock*) self, _tmp82_);
	_tmp83_ = self->priv->_collection_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp83_, TRUE);
	_tmp84_ = vala_foreach_statement_get_collection (self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp85_);
	_tmp87_ = _tmp86_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp87_);
	_vala_iterable_unref0 (_tmp87_);
	_tmp88_ = vala_foreach_statement_get_body (self);
	_tmp89_ = _tmp88_;
	_tmp90_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp89_);
	_tmp91_ = _tmp90_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp91_);
	_vala_iterable_unref0 (_tmp91_);
	_tmp92_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp93_ = _tmp92_;
	result = !_tmp93_;
	return result;
}


static void vala_foreach_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaForeachStatement * self;
	gboolean _tmp0_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaCodeGenerator* _tmp4_;
	ValaCodeGenerator* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaLocalVariable* _tmp9_;
	ValaLocalVariable* _tmp10_;
	ValaCodeGenerator* _tmp12_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = self->priv->_use_iterator;
	if (_tmp0_) {
		ValaCodeGenerator* _tmp1_;
		_tmp1_ = codegen;
		VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->emit ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), _tmp1_);
		return;
	}
	_tmp2_ = vala_foreach_statement_get_collection (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = codegen;
	vala_code_node_emit ((ValaCodeNode*) _tmp3_, _tmp4_);
	_tmp5_ = codegen;
	_tmp6_ = vala_foreach_statement_get_collection (self);
	_tmp7_ = _tmp6_;
	vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) _tmp5_, _tmp7_);
	_tmp8_ = self->priv->_element_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp8_, TRUE);
	_tmp9_ = self->priv->_collection_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp9_, TRUE);
	_tmp10_ = self->priv->_iterator_variable;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = self->priv->_iterator_variable;
		vala_symbol_set_active ((ValaSymbol*) _tmp11_, TRUE);
	}
	_tmp12_ = codegen;
	vala_code_visitor_visit_foreach_statement ((ValaCodeVisitor*) _tmp12_, self);
}


static void vala_foreach_statement_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaForeachStatement * self;
	ValaCollection* _tmp0_;
	ValaLocalVariable* _tmp1_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = collection;
	_tmp1_ = self->priv->_element_variable;
	vala_collection_add (_tmp0_, (ValaVariable*) _tmp1_);
}


ValaDataType* vala_foreach_statement_get_type_reference (ValaForeachStatement* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void vala_foreach_statement_set_type_reference (ValaForeachStatement* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp1_;
	_tmp2_ = self->priv->_data_type;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		_tmp3_ = self->priv->_data_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


const gchar* vala_foreach_statement_get_variable_name (ValaForeachStatement* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_variable_name;
	result = _tmp0_;
	return result;
}


void vala_foreach_statement_set_variable_name (ValaForeachStatement* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_variable_name);
	self->priv->_variable_name = _tmp1_;
}


ValaExpression* vala_foreach_statement_get_collection (ValaForeachStatement* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_collection;
	result = _tmp0_;
	return result;
}


void vala_foreach_statement_set_collection (ValaForeachStatement* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_collection);
	self->priv->_collection = _tmp1_;
	_tmp2_ = self->priv->_collection;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaBlock* vala_foreach_statement_get_body (ValaForeachStatement* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void vala_foreach_statement_set_body (ValaForeachStatement* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp1_;
	_tmp2_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


gboolean vala_foreach_statement_get_use_iterator (ValaForeachStatement* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_use_iterator;
	result = _tmp0_;
	return result;
}


static void vala_foreach_statement_set_use_iterator (ValaForeachStatement* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_use_iterator = _tmp0_;
}


ValaLocalVariable* vala_foreach_statement_get_element_variable (ValaForeachStatement* self) {
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_variable;
	result = _tmp0_;
	return result;
}


void vala_foreach_statement_set_element_variable (ValaForeachStatement* self, ValaLocalVariable* value) {
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_element_variable);
	self->priv->_element_variable = _tmp1_;
}


ValaLocalVariable* vala_foreach_statement_get_collection_variable (ValaForeachStatement* self) {
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_collection_variable;
	result = _tmp0_;
	return result;
}


void vala_foreach_statement_set_collection_variable (ValaForeachStatement* self, ValaLocalVariable* value) {
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_collection_variable);
	self->priv->_collection_variable = _tmp1_;
}


ValaLocalVariable* vala_foreach_statement_get_iterator_variable (ValaForeachStatement* self) {
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_iterator_variable;
	result = _tmp0_;
	return result;
}


void vala_foreach_statement_set_iterator_variable (ValaForeachStatement* self, ValaLocalVariable* value) {
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_iterator_variable);
	self->priv->_iterator_variable = _tmp1_;
}


static void vala_foreach_statement_class_init (ValaForeachStatementClass * klass) {
	vala_foreach_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_foreach_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaForeachStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_foreach_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_foreach_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_foreach_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_foreach_statement_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_foreach_statement_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_foreach_statement_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_foreach_statement_real_get_defined_variables;
}


static void vala_foreach_statement_instance_init (ValaForeachStatement * self) {
	self->priv = VALA_FOREACH_STATEMENT_GET_PRIVATE (self);
}


static void vala_foreach_statement_finalize (ValaCodeNode * obj) {
	ValaForeachStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement);
	_g_free0 (self->priv->_variable_name);
	_vala_code_node_unref0 (self->priv->_element_variable);
	_vala_code_node_unref0 (self->priv->_collection_variable);
	_vala_code_node_unref0 (self->priv->_iterator_variable);
	_vala_code_node_unref0 (self->priv->_collection);
	_vala_code_node_unref0 (self->priv->_body);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->finalize (obj);
}


/**
 * Represents a foreach statement in the source code. Foreach statements iterate
 * over the elements of a collection.
 */
GType vala_foreach_statement_get_type (void) {
	static volatile gsize vala_foreach_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_foreach_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaForeachStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_foreach_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForeachStatement), 0, (GInstanceInitFunc) vala_foreach_statement_instance_init, NULL };
		GType vala_foreach_statement_type_id;
		vala_foreach_statement_type_id = g_type_register_static (VALA_TYPE_BLOCK, "ValaForeachStatement", &g_define_type_info, 0);
		g_once_init_leave (&vala_foreach_statement_type_id__volatile, vala_foreach_statement_type_id);
	}
	return vala_foreach_statement_type_id__volatile;
}



