/* basicdoclet.c generated by valac, the Vala compiler
 * generated from basicdoclet.vala, do not modify */

/* basicdoclet.vala
 *
 * Copyright (C) 2008-2012 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <stdio.h>

enum  {
	VALADOC_HTML_BASIC_DOCLET_DUMMY_PROPERTY,
	VALADOC_HTML_BASIC_DOCLET_LINKER,
	VALADOC_HTML_BASIC_DOCLET_SETTINGS,
	VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME,
	VALADOC_HTML_BASIC_DOCLET_LAST_PROPERTY
};
static GParamSpec* valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _valadoc_markup_writer_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_markup_writer_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocHtmlBasicDocletPrivate {
	ValadocHtmlLinkHelper* _linker;
	ValadocSettings* _settings;
	gchar* _wiki_index_name;
	guint html_id_counter;
};


static gpointer valadoc_html_basic_doclet_parent_class = NULL;
static ValadocApiNodeType* valadoc_html_basic_doclet_inheritable_members;
static gint valadoc_html_basic_doclet_inheritable_members_length1;
static ValadocApiNodeType* valadoc_html_basic_doclet_inheritable_members = NULL;
static gint valadoc_html_basic_doclet_inheritable_members_length1 = 0;
static gint _valadoc_html_basic_doclet_inheritable_members_size_ = 0;
static ValadocDocletIface * valadoc_html_basic_doclet_valadoc_doclet_parent_iface = NULL;

#define VALADOC_HTML_BASIC_DOCLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDocletPrivate))
#define VALADOC_HTML_BASIC_DOCLET_css_inline_navigation "navi_inline"
#define VALADOC_HTML_BASIC_DOCLET_css_package_index "package_index"
#define VALADOC_HTML_BASIC_DOCLET_css_brief_description "brief_description"
#define VALADOC_HTML_BASIC_DOCLET_css_description "description"
#define VALADOC_HTML_BASIC_DOCLET_css_known_list "known_nodes"
#define VALADOC_HTML_BASIC_DOCLET_css_leaf_brief_description "leaf_brief_description"
#define VALADOC_HTML_BASIC_DOCLET_css_leaf_code_definition "leaf_code_definition"
#define VALADOC_HTML_BASIC_DOCLET_css_box_headline_text "text"
#define VALADOC_HTML_BASIC_DOCLET_css_box_headline_toggle "toggle"
#define VALADOC_HTML_BASIC_DOCLET_css_box_headline "headline"
#define VALADOC_HTML_BASIC_DOCLET_css_box_content "content"
#define VALADOC_HTML_BASIC_DOCLET_css_box_column "column"
#define VALADOC_HTML_BASIC_DOCLET_css_box "box"
#define VALADOC_HTML_BASIC_DOCLET_css_namespace_note "namespace_note"
#define VALADOC_HTML_BASIC_DOCLET_css_package_note "package_note"
#define VALADOC_HTML_BASIC_DOCLET_css_site_header "site_header"
#define VALADOC_HTML_BASIC_DOCLET_css_navi "navi_main"
#define VALADOC_HTML_BASIC_DOCLET_css_navi_hr "navi_hr"
#define VALADOC_HTML_BASIC_DOCLET_css_errordomain_table_name "main_errordomain_table_name"
#define VALADOC_HTML_BASIC_DOCLET_css_errordomain_table_text "main_errordomain_table_text"
#define VALADOC_HTML_BASIC_DOCLET_css_errordomain_table "main_errordomain_table"
#define VALADOC_HTML_BASIC_DOCLET_css_enum_table_name "main_enum_table_name"
#define VALADOC_HTML_BASIC_DOCLET_css_enum_table_text "main_enum_table_text"
#define VALADOC_HTML_BASIC_DOCLET_css_enum_table "main_enum_table"
#define VALADOC_HTML_BASIC_DOCLET_css_diagram "main_diagram"
#define VALADOC_HTML_BASIC_DOCLET_css_see_list "main_see_list"
#define VALADOC_HTML_BASIC_DOCLET_css_wiki_table "main_table"
#define VALADOC_HTML_BASIC_DOCLET_css_notification_area "main_notification"
#define VALADOC_HTML_BASIC_DOCLET_css_source_sample "main_sourcesample"
#define VALADOC_HTML_BASIC_DOCLET_css_exception_table "main_parameter_table"
#define VALADOC_HTML_BASIC_DOCLET_css_parameter_table_text "main_parameter_table_text"
#define VALADOC_HTML_BASIC_DOCLET_css_parameter_table_name "main_parameter_table_name"
#define VALADOC_HTML_BASIC_DOCLET_css_parameter_table "main_parameter_table"
#define VALADOC_HTML_BASIC_DOCLET_css_title "main_title"
#define VALADOC_HTML_BASIC_DOCLET_css_other_type "main_other_type"
#define VALADOC_HTML_BASIC_DOCLET_css_basic_type "main_basic_type"
#define VALADOC_HTML_BASIC_DOCLET_css_keyword "main_keyword"
#define VALADOC_HTML_BASIC_DOCLET_css_optional_parameter "main_optional_parameter"
#define VALADOC_HTML_BASIC_DOCLET_css_code_definition "main_code_definition"
#define VALADOC_HTML_BASIC_DOCLET_css_headline_hr "main_hr"
#define VALADOC_HTML_BASIC_DOCLET_css_hr "main_hr"
#define VALADOC_HTML_BASIC_DOCLET_css_list_errdom "main_list_errdom"
#define VALADOC_HTML_BASIC_DOCLET_css_list_en "main_list_en"
#define VALADOC_HTML_BASIC_DOCLET_css_list_ns "main_list_ns"
#define VALADOC_HTML_BASIC_DOCLET_css_list_cl "main_list_cl"
#define VALADOC_HTML_BASIC_DOCLET_css_list_iface "main_list_iface"
#define VALADOC_HTML_BASIC_DOCLET_css_list_stru "main_list_stru"
#define VALADOC_HTML_BASIC_DOCLET_css_list_field "main_list_field"
#define VALADOC_HTML_BASIC_DOCLET_css_list_prop "main_list_prop"
#define VALADOC_HTML_BASIC_DOCLET_css_list_del "main_list_del"
#define VALADOC_HTML_BASIC_DOCLET_css_list_sig "main_list_sig"
#define VALADOC_HTML_BASIC_DOCLET_css_list_m "main_list_m"
#define VALADOC_HTML_BASIC_DOCLET_css_style_navigation "site_navigation"
#define VALADOC_HTML_BASIC_DOCLET_css_style_content "site_content"
#define VALADOC_HTML_BASIC_DOCLET_css_style_body "site_body"
#define VALADOC_HTML_BASIC_DOCLET_css_deprecated "deprecated"
static void valadoc_html_basic_doclet_real_process (ValadocHtmlBasicDoclet* self, ValadocSettings* settings, ValadocApiTree* tree, ValadocErrorReporter* reporter);
static gchar* valadoc_html_basic_doclet_real_get_img_path_html (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, const gchar* type);
static gchar* valadoc_html_basic_doclet_real_get_img_path (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, const gchar* type);
static gchar* valadoc_html_basic_doclet_real_get_icon_directory (ValadocHtmlBasicDoclet* self);
static ValadocApiTypeSymbol* valadoc_html_basic_doclet_unpack_type_reference (ValadocHtmlBasicDoclet* self, ValadocApiTypeReference* type_reference);
static void valadoc_html_basic_doclet_real_write_wiki_page (ValadocHtmlBasicDoclet* self, ValadocWikiPage* page, const gchar* contentp, const gchar* css_path, const gchar* js_path, const gchar* pkg_name);
static gboolean valadoc_html_basic_doclet_has_brief_description (ValadocHtmlBasicDoclet* self, ValadocApiNode* element);
static void valadoc_html_basic_doclet_write_brief_description (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, ValadocApiNode* pos);
static void valadoc_html_basic_doclet_write_documentation (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, ValadocApiNode* pos);
static void valadoc_html_basic_doclet_write_attributes (ValadocHtmlBasicDoclet* self, ValadocApiSymbol* element, ValadocApiNode* pos);
static void valadoc_html_basic_doclet_write_signature (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, ValadocApiNode* pos);
static inline ValaCollection* valadoc_html_basic_doclet_get_accessible_nodes_from_list (ValadocHtmlBasicDoclet* self, ValaCollection* nodes);
static void valadoc_html_basic_doclet_write_known_symbols_note (ValadocHtmlBasicDoclet* self, ValaCollection* nodes2, ValadocApiNode* container, const gchar* headline);
static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_class (ValadocHtmlBasicDoclet* self, ValadocApiClass* cl, ValadocApiNode* container);
static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_interface (ValadocHtmlBasicDoclet* self, ValadocApiInterface* iface, ValadocApiNode* container);
static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_struct (ValadocHtmlBasicDoclet* self, ValadocApiStruct* str, ValadocApiNode* container);
static inline gboolean valadoc_html_basic_doclet_has_visible_inheritable_children (ValadocHtmlBasicDoclet* self, ValadocApiTypeSymbol* symbol);
static void valadoc_html_basic_doclet_write_inherited_members_headline (ValadocHtmlBasicDoclet* self);
static void valadoc_html_basic_doclet_write_inherited_symbols_note (ValadocHtmlBasicDoclet* self, ValadocApiTypeSymbol* symbol, const gchar* type, ValadocApiNode* container);
static void valadoc_html_basic_doclet_finalize (GObject * obj);
static void _vala_valadoc_html_basic_doclet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_valadoc_html_basic_doclet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _valadoc_api_tree_ref0 (gpointer self) {
	return self ? valadoc_api_tree_ref (self) : NULL;
}


static void valadoc_html_basic_doclet_real_process (ValadocHtmlBasicDoclet* self, ValadocSettings* settings, ValadocApiTree* tree, ValadocErrorReporter* reporter) {
	ValadocErrorReporter* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	ValadocSettings* _tmp2_;
	ValadocApiTree* _tmp3_;
	ValadocApiTree* _tmp4_;
	ValadocHtmlCssClassResolver* _tmp5_;
	ValadocHtmlLinkHelper* _tmp6_;
	ValadocHtmlLinkHelper* _tmp7_;
	ValadocSettings* _tmp8_;
	ValadocHtmlLinkHelper* _tmp9_;
	ValadocHtmlCssClassResolver* _tmp10_;
	ValadocHtmlHtmlRenderer* _tmp11_;
	ValadocSettings* _tmp12_;
	ValadocHtmlLinkHelper* _tmp13_;
	ValadocHtmlSimpleChartFactory* _tmp14_;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (tree != NULL);
	g_return_if_fail (reporter != NULL);
	_tmp0_ = reporter;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->reporter);
	self->reporter = _tmp1_;
	_tmp2_ = settings;
	valadoc_html_basic_doclet_set_settings (self, _tmp2_);
	_tmp3_ = tree;
	_tmp4_ = _valadoc_api_tree_ref0 (_tmp3_);
	_valadoc_api_tree_unref0 (self->tree);
	self->tree = _tmp4_;
	_tmp5_ = valadoc_html_css_class_resolver_new ();
	_g_object_unref0 (self->cssresolver);
	self->cssresolver = _tmp5_;
	_tmp6_ = valadoc_html_link_helper_new ();
	_tmp7_ = _tmp6_;
	valadoc_html_basic_doclet_set_linker (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = settings;
	_tmp9_ = self->priv->_linker;
	_tmp10_ = self->cssresolver;
	_tmp11_ = valadoc_html_html_renderer_new (_tmp8_, _tmp9_, _tmp10_);
	_g_object_unref0 (self->_renderer);
	self->_renderer = _tmp11_;
	_tmp12_ = settings;
	_tmp13_ = self->priv->_linker;
	_tmp14_ = valadoc_html_simple_chart_factory_new (_tmp12_, _tmp13_);
	_g_object_unref0 (self->image_factory);
	self->image_factory = (ValadocChartsFactory*) _tmp14_;
}


void valadoc_html_basic_doclet_process (ValadocHtmlBasicDoclet* self, ValadocSettings* settings, ValadocApiTree* tree, ValadocErrorReporter* reporter) {
	g_return_if_fail (self != NULL);
	VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self)->process (self, settings, tree, reporter);
}


gchar* valadoc_html_basic_doclet_get_link (ValadocHtmlBasicDoclet* self, ValadocApiNode* to, ValadocApiNode* from) {
	gchar* result = NULL;
	ValadocHtmlLinkHelper* _tmp0_;
	ValadocApiNode* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValadocSettings* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	g_return_val_if_fail (from != NULL, NULL);
	_tmp0_ = self->priv->_linker;
	_tmp1_ = from;
	_tmp2_ = to;
	_tmp3_ = self->priv->_settings;
	_tmp4_ = valadoc_html_link_helper_get_relative_link (_tmp0_, (ValadocDocumentation*) _tmp1_, (ValadocDocumentation*) _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


static gchar* valadoc_html_basic_doclet_real_get_img_path_html (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, const gchar* type) {
	gchar* result = NULL;
	ValadocApiNode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = element;
	_tmp1_ = valadoc_api_node_get_full_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ".", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = type;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_build_filename ("img", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}


gchar* valadoc_html_basic_doclet_get_img_path_html (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, const gchar* type) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self)->get_img_path_html (self, element, type);
}


static gchar* valadoc_html_basic_doclet_real_get_img_path (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, const gchar* type) {
	gchar* result = NULL;
	ValadocSettings* _tmp0_;
	const gchar* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValadocApiPackage* _tmp3_;
	ValadocApiPackage* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValadocApiNode* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = _tmp0_->path;
	_tmp2_ = element;
	_tmp3_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = element;
	_tmp8_ = valadoc_api_node_get_full_name (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, ".", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = type;
	_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_build_filename (_tmp1_, _tmp6_, "img", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	result = _tmp16_;
	return result;
}


gchar* valadoc_html_basic_doclet_get_img_path (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, const gchar* type) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self)->get_img_path (self, element, type);
}


static gchar* valadoc_html_basic_doclet_real_get_icon_directory (ValadocHtmlBasicDoclet* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("..");
	result = _tmp0_;
	return result;
}


gchar* valadoc_html_basic_doclet_get_icon_directory (ValadocHtmlBasicDoclet* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self)->get_icon_directory (self);
}


static ValadocApiTypeSymbol* valadoc_html_basic_doclet_unpack_type_reference (ValadocHtmlBasicDoclet* self, ValadocApiTypeReference* type_reference) {
	ValadocApiTypeSymbol* result = NULL;
	ValadocApiItem* pos = NULL;
	ValadocApiTypeReference* _tmp0_;
	ValadocApiItem* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = type_reference;
	_tmp1_ = _g_object_ref0 ((ValadocApiItem*) _tmp0_);
	pos = _tmp1_;
	while (TRUE) {
		ValadocApiItem* _tmp2_;
		ValadocApiItem* _tmp3_;
		_tmp2_ = pos;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = pos;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_API_TYPE_TYPEREFERENCE)) {
			ValadocApiItem* _tmp4_;
			ValadocApiItem* _tmp5_;
			ValadocApiItem* _tmp6_;
			ValadocApiItem* _tmp7_;
			_tmp4_ = pos;
			_tmp5_ = valadoc_api_typereference_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference));
			_tmp6_ = _tmp5_;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_g_object_unref0 (pos);
			pos = _tmp7_;
		} else {
			ValadocApiItem* _tmp8_;
			_tmp8_ = pos;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALADOC_API_TYPE_ARRAY)) {
				ValadocApiItem* _tmp9_;
				ValadocApiItem* _tmp10_;
				ValadocApiItem* _tmp11_;
				ValadocApiItem* _tmp12_;
				_tmp9_ = pos;
				_tmp10_ = valadoc_api_array_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALADOC_API_TYPE_ARRAY, ValadocApiArray));
				_tmp11_ = _tmp10_;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				_g_object_unref0 (pos);
				pos = _tmp12_;
			} else {
				ValadocApiItem* _tmp13_;
				_tmp13_ = pos;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALADOC_API_TYPE_POINTER)) {
					ValadocApiItem* _tmp14_;
					ValadocApiItem* _tmp15_;
					ValadocApiItem* _tmp16_;
					ValadocApiItem* _tmp17_;
					_tmp14_ = pos;
					_tmp15_ = valadoc_api_pointer_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALADOC_API_TYPE_POINTER, ValadocApiPointer));
					_tmp16_ = _tmp15_;
					_tmp17_ = _g_object_ref0 (_tmp16_);
					_g_object_unref0 (pos);
					pos = _tmp17_;
				} else {
					ValadocApiItem* _tmp18_;
					ValadocApiItem* _tmp19_;
					ValadocApiTypeSymbol* _tmp20_;
					_tmp18_ = pos;
					_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALADOC_API_TYPE_TYPESYMBOL), "pos is TypeSymbol");
					_tmp19_ = pos;
					_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALADOC_API_TYPE_TYPESYMBOL, ValadocApiTypeSymbol));
					result = _tmp20_;
					_g_object_unref0 (pos);
					return result;
				}
			}
		}
	}
	result = NULL;
	_g_object_unref0 (pos);
	return result;
}


void valadoc_html_basic_doclet_write_navi_entry_html_template (ValadocHtmlBasicDoclet* self, const gchar* style, const gchar* content, gboolean is_deprecated) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	ValadocMarkupWriter* _tmp6_;
	ValadocMarkupWriter* _tmp7_;
	gboolean _tmp8_;
	ValadocHtmlMarkupWriter* _tmp27_;
	ValadocMarkupWriter* _tmp28_;
	ValadocMarkupWriter* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (style != NULL);
	g_return_if_fail (content != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = style;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "li", _tmp5_, 2);
	_tmp7_ = _tmp6_;
	_valadoc_markup_writer_unref0 (_tmp7_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp8_ = is_deprecated;
	if (_tmp8_) {
		ValadocHtmlMarkupWriter* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		ValadocMarkupWriter* _tmp14_;
		ValadocMarkupWriter* _tmp15_;
		ValadocHtmlMarkupWriter* _tmp16_;
		const gchar* _tmp17_;
		ValadocMarkupWriter* _tmp18_;
		ValadocMarkupWriter* _tmp19_;
		ValadocHtmlMarkupWriter* _tmp20_;
		ValadocMarkupWriter* _tmp21_;
		ValadocMarkupWriter* _tmp22_;
		_tmp9_ = self->writer;
		_tmp10_ = g_strdup ("class");
		_tmp11_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
		_tmp12_ = g_new0 (gchar*, 2 + 1);
		_tmp12_[0] = _tmp10_;
		_tmp12_[1] = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 2;
		_tmp14_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp9_, "span", _tmp13_, 2);
		_tmp15_ = _tmp14_;
		_valadoc_markup_writer_unref0 (_tmp15_);
		_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
		_tmp16_ = self->writer;
		_tmp17_ = content;
		_tmp18_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp16_, _tmp17_);
		_tmp19_ = _tmp18_;
		_valadoc_markup_writer_unref0 (_tmp19_);
		_tmp20_ = self->writer;
		_tmp21_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp20_, "span");
		_tmp22_ = _tmp21_;
		_valadoc_markup_writer_unref0 (_tmp22_);
	} else {
		ValadocHtmlMarkupWriter* _tmp23_;
		const gchar* _tmp24_;
		ValadocMarkupWriter* _tmp25_;
		ValadocMarkupWriter* _tmp26_;
		_tmp23_ = self->writer;
		_tmp24_ = content;
		_tmp25_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		_valadoc_markup_writer_unref0 (_tmp26_);
	}
	_tmp27_ = self->writer;
	_tmp28_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp27_, "li");
	_tmp29_ = _tmp28_;
	_valadoc_markup_writer_unref0 (_tmp29_);
}


void valadoc_html_basic_doclet_write_navi_entry_html_template_with_link (ValadocHtmlBasicDoclet* self, const gchar* style, const gchar* link, const gchar* content, gboolean is_deprecated) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	ValadocMarkupWriter* _tmp6_;
	ValadocMarkupWriter* _tmp7_;
	gboolean _tmp8_;
	ValadocHtmlMarkupWriter* _tmp29_;
	ValadocMarkupWriter* _tmp30_;
	ValadocMarkupWriter* _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (style != NULL);
	g_return_if_fail (link != NULL);
	g_return_if_fail (content != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = style;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "li", _tmp5_, 2);
	_tmp7_ = _tmp6_;
	_valadoc_markup_writer_unref0 (_tmp7_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp8_ = is_deprecated;
	if (_tmp8_) {
		ValadocHtmlMarkupWriter* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		ValadocMarkupWriter* _tmp14_;
		ValadocMarkupWriter* _tmp15_;
		ValadocHtmlMarkupWriter* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		ValadocHtmlMarkupWriter* _tmp19_;
		ValadocHtmlMarkupWriter* _tmp20_;
		ValadocHtmlMarkupWriter* _tmp21_;
		ValadocMarkupWriter* _tmp22_;
		ValadocMarkupWriter* _tmp23_;
		_tmp9_ = self->writer;
		_tmp10_ = g_strdup ("class");
		_tmp11_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
		_tmp12_ = g_new0 (gchar*, 2 + 1);
		_tmp12_[0] = _tmp10_;
		_tmp12_[1] = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 2;
		_tmp14_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp9_, "span", _tmp13_, 2);
		_tmp15_ = _tmp14_;
		_valadoc_markup_writer_unref0 (_tmp15_);
		_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
		_tmp16_ = self->writer;
		_tmp17_ = link;
		_tmp18_ = content;
		_tmp19_ = valadoc_html_markup_writer_link (_tmp16_, _tmp17_, _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_valadoc_markup_writer_unref0 (_tmp20_);
		_tmp21_ = self->writer;
		_tmp22_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp21_, "span");
		_tmp23_ = _tmp22_;
		_valadoc_markup_writer_unref0 (_tmp23_);
	} else {
		ValadocHtmlMarkupWriter* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		ValadocHtmlMarkupWriter* _tmp27_;
		ValadocHtmlMarkupWriter* _tmp28_;
		_tmp24_ = self->writer;
		_tmp25_ = link;
		_tmp26_ = content;
		_tmp27_ = valadoc_html_markup_writer_link (_tmp24_, _tmp25_, _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_valadoc_markup_writer_unref0 (_tmp28_);
	}
	_tmp29_ = self->writer;
	_tmp30_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp29_, "li");
	_tmp31_ = _tmp30_;
	_valadoc_markup_writer_unref0 (_tmp31_);
}


void valadoc_html_basic_doclet_write_navi_entry (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, ValadocApiNode* pos, const gchar* style, gboolean link, gboolean full_name) {
	gchar* name = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp17_ = FALSE;
	ValadocApiNode* _tmp18_;
	gboolean is_deprecated = FALSE;
	gboolean _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	g_return_if_fail (style != NULL);
	_tmp1_ = full_name;
	if (_tmp1_ == TRUE) {
		ValadocApiNode* _tmp2_;
		_tmp2_ = element;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALADOC_API_TYPE_NAMESPACE);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* tmp = NULL;
		ValadocApiNode* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		gchar* _tmp8_;
		_tmp3_ = element;
		_tmp4_ = valadoc_api_node_get_full_name (_tmp3_);
		tmp = _tmp4_;
		_tmp6_ = tmp;
		if (_tmp6_ == NULL) {
			_tmp5_ = "Global Namespace";
		} else {
			const gchar* _tmp7_;
			_tmp7_ = tmp;
			_tmp5_ = _tmp7_;
		}
		_tmp8_ = g_strdup (_tmp5_);
		_g_free0 (name);
		name = _tmp8_;
		_g_free0 (tmp);
	} else {
		gchar* tmp = NULL;
		ValadocApiNode* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		gchar* _tmp16_;
		_tmp9_ = element;
		_tmp10_ = valadoc_api_node_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup (_tmp11_);
		tmp = _tmp12_;
		_tmp14_ = tmp;
		if (_tmp14_ == NULL) {
			_tmp13_ = "Global Namespace";
		} else {
			const gchar* _tmp15_;
			_tmp15_ = tmp;
			_tmp13_ = _tmp15_;
		}
		_tmp16_ = g_strdup (_tmp13_);
		_g_free0 (name);
		name = _tmp16_;
		_g_free0 (tmp);
	}
	_tmp18_ = element;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALADOC_API_TYPE_SYMBOL)) {
		ValadocApiNode* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp19_ = element;
		_tmp20_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
		_tmp21_ = _tmp20_;
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	is_deprecated = _tmp17_;
	_tmp22_ = link;
	if (_tmp22_ == TRUE) {
		const gchar* _tmp23_;
		ValadocApiNode* _tmp24_;
		ValadocApiNode* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		gboolean _tmp29_;
		_tmp23_ = style;
		_tmp24_ = element;
		_tmp25_ = pos;
		_tmp26_ = valadoc_html_basic_doclet_get_link (self, _tmp24_, _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = name;
		_tmp29_ = is_deprecated;
		valadoc_html_basic_doclet_write_navi_entry_html_template_with_link (self, _tmp23_, _tmp27_, _tmp28_, _tmp29_);
		_g_free0 (_tmp27_);
	} else {
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gboolean _tmp32_;
		_tmp30_ = style;
		_tmp31_ = name;
		_tmp32_ = is_deprecated;
		valadoc_html_basic_doclet_write_navi_entry_html_template (self, _tmp30_, _tmp31_, _tmp32_);
	}
	_g_free0 (name);
}


void valadoc_html_basic_doclet_write_wiki_pages (ValadocHtmlBasicDoclet* self, ValadocApiTree* tree, const gchar* css_path_wiki, const gchar* js_path_wiki, const gchar* contentp) {
	ValadocApiTree* _tmp0_;
	ValadocWikiPageTree* _tmp1_;
	ValadocWikiPageTree* _tmp2_;
	ValadocApiTree* _tmp3_;
	ValadocWikiPageTree* _tmp4_;
	ValadocWikiPageTree* _tmp5_;
	ValaCollection* pages = NULL;
	ValadocApiTree* _tmp6_;
	ValadocWikiPageTree* _tmp7_;
	ValadocWikiPageTree* _tmp8_;
	ValaCollection* _tmp9_;
	ValaCollection* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	g_return_if_fail (css_path_wiki != NULL);
	g_return_if_fail (js_path_wiki != NULL);
	g_return_if_fail (contentp != NULL);
	_tmp0_ = tree;
	_tmp1_ = valadoc_api_tree_get_wikitree (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = tree;
	_tmp4_ = valadoc_api_tree_get_wikitree (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		return;
	}
	_tmp6_ = tree;
	_tmp7_ = valadoc_api_tree_get_wikitree (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_wiki_page_tree_get_pages (_tmp8_);
	pages = _tmp9_;
	_tmp10_ = pages;
	_tmp11_ = vala_collection_get_size (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 0) {
		_vala_iterable_unref0 (pages);
		return;
	}
	_tmp13_ = contentp;
	g_mkdir (_tmp13_, 0777);
	_tmp14_ = contentp;
	_tmp15_ = g_build_filename (_tmp14_, "img", NULL);
	_tmp16_ = _tmp15_;
	g_mkdir (_tmp16_, 0777);
	_g_free0 (_tmp16_);
	{
		ValaIterator* _page_it = NULL;
		ValaCollection* _tmp17_;
		ValaIterator* _tmp18_;
		_tmp17_ = pages;
		_tmp18_ = vala_iterable_iterator ((ValaIterable*) _tmp17_);
		_page_it = _tmp18_;
		while (TRUE) {
			ValaIterator* _tmp19_;
			gboolean _tmp20_;
			ValadocWikiPage* page = NULL;
			ValaIterator* _tmp21_;
			gpointer _tmp22_;
			ValadocWikiPage* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			_tmp19_ = _page_it;
			_tmp20_ = vala_iterator_next (_tmp19_);
			if (!_tmp20_) {
				break;
			}
			_tmp21_ = _page_it;
			_tmp22_ = vala_iterator_get (_tmp21_);
			page = (ValadocWikiPage*) _tmp22_;
			_tmp23_ = page;
			_tmp24_ = valadoc_wiki_page_get_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->_wiki_index_name;
			if (g_strcmp0 (_tmp25_, _tmp26_) != 0) {
				ValadocWikiPage* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				ValadocSettings* _tmp31_;
				const gchar* _tmp32_;
				_tmp27_ = page;
				_tmp28_ = contentp;
				_tmp29_ = css_path_wiki;
				_tmp30_ = js_path_wiki;
				_tmp31_ = self->priv->_settings;
				_tmp32_ = _tmp31_->pkg_name;
				valadoc_html_basic_doclet_write_wiki_page (self, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp32_);
			}
			_g_object_unref0 (page);
		}
		_vala_iterator_unref0 (_page_it);
	}
	_vala_iterable_unref0 (pages);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch22_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch22_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally22;
	__catch22_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally22:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void valadoc_html_basic_doclet_real_write_wiki_page (ValadocHtmlBasicDoclet* self, ValadocWikiPage* page, const gchar* contentp, const gchar* css_path, const gchar* js_path, const gchar* pkg_name) {
	FILE* file = NULL;
	const gchar* _tmp0_;
	ValadocWikiPage* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValadocWikiPage* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	FILE* _tmp17_;
	FILE* _tmp18_;
	ValadocHtmlMarkupWriter* _tmp19_;
	ValadocHtmlHtmlRenderer* _tmp20_;
	ValadocHtmlMarkupWriter* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	ValadocHtmlHtmlRenderer* _tmp25_;
	ValadocWikiPage* _tmp26_;
	ValadocHtmlHtmlRenderer* _tmp27_;
	ValadocWikiPage* _tmp28_;
	ValadocContentPage* _tmp29_;
	ValadocContentPage* _tmp30_;
	g_return_if_fail (page != NULL);
	g_return_if_fail (contentp != NULL);
	g_return_if_fail (css_path != NULL);
	g_return_if_fail (js_path != NULL);
	g_return_if_fail (pkg_name != NULL);
	_tmp0_ = contentp;
	_tmp1_ = page;
	_tmp2_ = valadoc_wiki_page_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = page;
	_tmp5_ = valadoc_wiki_page_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_substring (_tmp3_, (glong) 0, (glong) (_tmp8_ - 7));
	_tmp10_ = _tmp9_;
	_tmp11_ = string_replace (_tmp10_, "/", ".");
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, "htm", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_build_filename (_tmp0_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_fopen (_tmp16_, "w");
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	file = _tmp18_;
	_tmp19_ = valadoc_html_markup_writer_new (file, TRUE);
	_valadoc_markup_writer_unref0 (self->writer);
	self->writer = _tmp19_;
	_tmp20_ = self->_renderer;
	_tmp21_ = self->writer;
	valadoc_html_html_renderer_set_writer (_tmp20_, _tmp21_);
	_tmp22_ = css_path;
	_tmp23_ = js_path;
	_tmp24_ = pkg_name;
	valadoc_html_basic_doclet_write_file_header (self, _tmp22_, _tmp23_, _tmp24_);
	_tmp25_ = self->_renderer;
	_tmp26_ = page;
	valadoc_html_html_renderer_set_container (_tmp25_, (ValadocDocumentation*) _tmp26_);
	_tmp27_ = self->_renderer;
	_tmp28_ = page;
	_tmp29_ = valadoc_wiki_page_get_documentation (_tmp28_);
	_tmp30_ = _tmp29_;
	valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp27_, (ValadocContentContentElement*) _tmp30_);
	valadoc_html_basic_doclet_write_file_footer (self);
	_fclose0 (file);
}


void valadoc_html_basic_doclet_write_wiki_page (ValadocHtmlBasicDoclet* self, ValadocWikiPage* page, const gchar* contentp, const gchar* css_path, const gchar* js_path, const gchar* pkg_name) {
	g_return_if_fail (self != NULL);
	VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self)->write_wiki_page (self, page, contentp, css_path, js_path, pkg_name);
}


void valadoc_html_basic_doclet_write_navi_top_entry (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, ValadocApiNode* parent) {
	gchar* style = NULL;
	ValadocHtmlCssClassResolver* _tmp0_;
	ValadocApiNode* _tmp1_;
	gchar* _tmp2_;
	ValadocHtmlMarkupWriter* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ValadocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	gboolean _tmp10_ = FALSE;
	ValadocApiNode* _tmp11_;
	ValadocApiNode* _tmp12_;
	ValadocHtmlMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocHtmlMarkupWriter* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	ValadocMarkupWriter* _tmp28_;
	ValadocMarkupWriter* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->cssresolver;
	_tmp1_ = element;
	_tmp2_ = valadoc_html_css_class_resolver_resolve (_tmp0_, _tmp1_);
	style = _tmp2_;
	_tmp3_ = self->writer;
	_tmp4_ = g_strdup ("class");
	_tmp5_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	_tmp8_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp3_, "ul", _tmp7_, 2);
	_tmp9_ = _tmp8_;
	_valadoc_markup_writer_unref0 (_tmp9_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = element;
	_tmp12_ = parent;
	if (_tmp11_ == _tmp12_) {
		_tmp10_ = TRUE;
	} else {
		ValadocApiNode* _tmp13_;
		_tmp13_ = parent;
		_tmp10_ = _tmp13_ == NULL;
	}
	if (_tmp10_) {
		ValadocApiNode* _tmp14_;
		ValadocApiNode* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = element;
		_tmp15_ = parent;
		_tmp16_ = style;
		valadoc_html_basic_doclet_write_navi_entry (self, _tmp14_, _tmp15_, _tmp16_, FALSE, FALSE);
	} else {
		ValadocApiNode* _tmp17_;
		ValadocApiNode* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = element;
		_tmp18_ = parent;
		_tmp19_ = style;
		valadoc_html_basic_doclet_write_navi_entry (self, _tmp17_, _tmp18_, _tmp19_, TRUE, FALSE);
	}
	_tmp20_ = self->writer;
	_tmp21_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp20_, "ul");
	_tmp22_ = _tmp21_;
	_valadoc_markup_writer_unref0 (_tmp22_);
	_tmp23_ = self->writer;
	_tmp24_ = g_strdup ("class");
	_tmp25_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi_hr);
	_tmp26_ = g_new0 (gchar*, 2 + 1);
	_tmp26_[0] = _tmp24_;
	_tmp26_[1] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 2;
	_tmp28_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp23_, "hr", _tmp27_, 2);
	_tmp29_ = _tmp28_;
	_valadoc_markup_writer_unref0 (_tmp29_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (style);
}


void valadoc_html_basic_doclet_write_top_element_template (ValadocHtmlBasicDoclet* self, const gchar* link) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocHtmlMarkupWriter* _tmp14_;
	const gchar* _tmp15_;
	ValadocHtmlMarkupWriter* _tmp16_;
	ValadocHtmlMarkupWriter* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocHtmlMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocMarkupWriter* _tmp23_;
	ValadocHtmlMarkupWriter* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	ValadocMarkupWriter* _tmp29_;
	ValadocMarkupWriter* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (link != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ul", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_package_index);
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "li", _tmp11_, 2);
	_tmp13_ = _tmp12_;
	_valadoc_markup_writer_unref0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = self->writer;
	_tmp15_ = link;
	_tmp16_ = valadoc_html_markup_writer_link (_tmp14_, _tmp15_, "Packages", NULL);
	_tmp17_ = _tmp16_;
	_valadoc_markup_writer_unref0 (_tmp17_);
	_tmp18_ = self->writer;
	_tmp19_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp18_, "li");
	_tmp20_ = _tmp19_;
	_valadoc_markup_writer_unref0 (_tmp20_);
	_tmp21_ = self->writer;
	_tmp22_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp21_, "ul");
	_tmp23_ = _tmp22_;
	_valadoc_markup_writer_unref0 (_tmp23_);
	_tmp24_ = self->writer;
	_tmp25_ = g_strdup ("class");
	_tmp26_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi_hr);
	_tmp27_ = g_new0 (gchar*, 2 + 1);
	_tmp27_[0] = _tmp25_;
	_tmp27_[1] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 2;
	_tmp29_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp24_, "hr", _tmp28_, 2);
	_tmp30_ = _tmp29_;
	_valadoc_markup_writer_unref0 (_tmp30_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
}


void valadoc_html_basic_doclet_write_top_elements (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, ValadocApiNode* parent) {
	ValaArrayList* lst = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValadocApiNode* pos = NULL;
	ValadocApiNode* _tmp2_;
	ValadocApiNode* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	lst = _tmp1_;
	_tmp2_ = element;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	pos = _tmp3_;
	_tmp4_ = self->package_list_link;
	valadoc_html_basic_doclet_write_top_element_template (self, _tmp4_);
	while (TRUE) {
		ValadocApiNode* _tmp5_;
		ValaArrayList* _tmp6_;
		ValadocApiNode* _tmp7_;
		ValadocApiNode* _tmp8_;
		ValadocApiItem* _tmp9_;
		ValadocApiItem* _tmp10_;
		ValadocApiNode* _tmp11_;
		_tmp5_ = pos;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = lst;
		_tmp7_ = pos;
		vala_collection_add ((ValaCollection*) _tmp6_, _tmp7_);
		_tmp8_ = pos;
		_tmp9_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALADOC_API_TYPE_NODE, ValadocApiNode));
		_g_object_unref0 (pos);
		pos = _tmp11_;
	}
	{
		gint i = 0;
		ValaArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = lst;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		i = _tmp14_ - 1;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_;
				ValadocApiNode* el = NULL;
				ValaArrayList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_;
				ValadocApiNode* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ - 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				if (!(_tmp17_ >= 0)) {
					break;
				}
				_tmp18_ = lst;
				_tmp19_ = i;
				_tmp20_ = vala_list_get ((ValaList*) _tmp18_, _tmp19_);
				el = (ValadocApiNode*) _tmp20_;
				_tmp21_ = el;
				_tmp22_ = valadoc_api_node_get_name (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_ != NULL) {
					ValadocApiNode* _tmp24_;
					ValadocApiNode* _tmp25_;
					_tmp24_ = el;
					_tmp25_ = parent;
					valadoc_html_basic_doclet_write_navi_top_entry (self, _tmp24_, _tmp25_);
				}
				_g_object_unref0 (el);
			}
		}
	}
	_g_object_unref0 (pos);
	_vala_iterable_unref0 (lst);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void valadoc_html_basic_doclet_fetch_subnamespace_names (ValadocHtmlBasicDoclet* self, ValadocApiNode* node, ValaArrayList* namespaces) {
	ValaArrayList* sorted_list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* _tmp2_;
	ValadocApiNode* _tmp3_;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	ValaArrayList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (namespaces != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	sorted_list = _tmp1_;
	_tmp2_ = sorted_list;
	_tmp3_ = node;
	_tmp4_ = valadoc_api_node_get_children_by_type (_tmp3_, VALADOC_API_NODE_TYPE_NAMESPACE, TRUE);
	_tmp5_ = _tmp4_;
	vala_collection_add_all ((ValaCollection*) _tmp2_, (ValaCollection*) _tmp5_);
	_vala_iterable_unref0 (_tmp5_);
	_tmp6_ = sorted_list;
	vala_list_sort ((ValaList*) _tmp6_, (GCompareDataFunc) valadoc_api_node_compare_to, NULL, NULL);
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp7_;
		ValaArrayList* _tmp8_;
		gint _child_size = 0;
		ValaArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _child_index = 0;
		_tmp7_ = sorted_list;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_child_list = _tmp8_;
		_tmp9_ = _child_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_child_size = _tmp11_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			ValadocApiNode* child = NULL;
			ValaArrayList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaArrayList* _tmp18_;
			ValadocApiNode* _tmp19_;
			ValadocApiNode* _tmp20_;
			ValaArrayList* _tmp21_;
			_tmp12_ = _child_index;
			_child_index = _tmp12_ + 1;
			_tmp13_ = _child_index;
			_tmp14_ = _child_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _child_list;
			_tmp16_ = _child_index;
			_tmp17_ = vala_list_get ((ValaList*) _tmp15_, _tmp16_);
			child = (ValadocApiNode*) _tmp17_;
			_tmp18_ = namespaces;
			_tmp19_ = child;
			vala_collection_add ((ValaCollection*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALADOC_API_TYPE_NAMESPACE, ValadocApiNamespace));
			_tmp20_ = child;
			_tmp21_ = namespaces;
			valadoc_html_basic_doclet_fetch_subnamespace_names (self, _tmp20_, _tmp21_);
			_g_object_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	_vala_iterable_unref0 (sorted_list);
}


void valadoc_html_basic_doclet_write_navi_package (ValadocHtmlBasicDoclet* self, ValadocApiPackage* package) {
	ValaArrayList* ns_list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValadocApiPackage* _tmp2_;
	ValaArrayList* _tmp3_;
	ValadocHtmlMarkupWriter* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	ValadocMarkupWriter* _tmp9_;
	ValadocMarkupWriter* _tmp10_;
	ValadocApiPackage* _tmp11_;
	ValadocApiPackage* _tmp12_;
	ValadocHtmlMarkupWriter* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	ValadocMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	ValadocApiNamespace* globals = NULL;
	ValadocApiNamespace* _tmp42_;
	ValadocHtmlMarkupWriter* _tmp71_;
	ValadocMarkupWriter* _tmp72_;
	ValadocMarkupWriter* _tmp73_;
	ValadocHtmlMarkupWriter* _tmp74_;
	ValadocMarkupWriter* _tmp75_;
	ValadocMarkupWriter* _tmp76_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NAMESPACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	ns_list = _tmp1_;
	_tmp2_ = package;
	_tmp3_ = ns_list;
	valadoc_html_basic_doclet_fetch_subnamespace_names (self, (ValadocApiNode*) _tmp2_, _tmp3_);
	_tmp4_ = self->writer;
	_tmp5_ = g_strdup ("class");
	_tmp6_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp5_;
	_tmp7_[1] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 2;
	_tmp9_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp4_, "div", _tmp8_, 2);
	_tmp10_ = _tmp9_;
	_valadoc_markup_writer_unref0 (_tmp10_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = package;
	_tmp12_ = package;
	valadoc_html_basic_doclet_write_top_elements (self, (ValadocApiNode*) _tmp11_, (ValadocApiNode*) _tmp12_);
	_tmp13_ = self->writer;
	_tmp14_ = g_strdup ("class");
	_tmp15_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp16_ = g_new0 (gchar*, 2 + 1);
	_tmp16_[0] = _tmp14_;
	_tmp16_[1] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 2;
	_tmp18_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp13_, "ul", _tmp17_, 2);
	_tmp19_ = _tmp18_;
	_valadoc_markup_writer_unref0 (_tmp19_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	globals = NULL;
	{
		ValaArrayList* _ns_list = NULL;
		ValaArrayList* _tmp20_;
		ValaArrayList* _tmp21_;
		gint _ns_size = 0;
		ValaArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _ns_index = 0;
		_tmp20_ = ns_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_ns_list = _tmp21_;
		_tmp22_ = _ns_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_ns_size = _tmp24_;
		_ns_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			ValadocApiNamespace* ns = NULL;
			ValaArrayList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			ValadocApiNamespace* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp25_ = _ns_index;
			_ns_index = _tmp25_ + 1;
			_tmp26_ = _ns_index;
			_tmp27_ = _ns_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _ns_list;
			_tmp29_ = _ns_index;
			_tmp30_ = vala_list_get ((ValaList*) _tmp28_, _tmp29_);
			ns = (ValadocApiNamespace*) _tmp30_;
			_tmp31_ = ns;
			_tmp32_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp31_);
			_tmp33_ = _tmp32_;
			if (_tmp33_ == NULL) {
				ValadocApiNamespace* _tmp34_;
				ValadocApiNamespace* _tmp35_;
				_tmp34_ = ns;
				_tmp35_ = _g_object_ref0 (_tmp34_);
				_g_object_unref0 (globals);
				globals = _tmp35_;
			} else {
				ValadocApiNamespace* _tmp36_;
				ValadocApiPackage* _tmp37_;
				ValadocHtmlCssClassResolver* _tmp38_;
				ValadocApiNamespace* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp36_ = ns;
				_tmp37_ = package;
				_tmp38_ = self->cssresolver;
				_tmp39_ = ns;
				_tmp40_ = valadoc_html_css_class_resolver_resolve (_tmp38_, (ValadocApiNode*) _tmp39_);
				_tmp41_ = _tmp40_;
				valadoc_html_basic_doclet_write_navi_entry (self, (ValadocApiNode*) _tmp36_, (ValadocApiNode*) _tmp37_, _tmp41_, TRUE, TRUE);
				_g_free0 (_tmp41_);
			}
			_g_object_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	_tmp42_ = globals;
	if (_tmp42_ != NULL) {
		ValadocApiNamespace* _tmp43_;
		ValadocApiPackage* _tmp44_;
		ValadocApiNamespace* _tmp45_;
		ValadocApiPackage* _tmp46_;
		ValadocApiNamespace* _tmp47_;
		ValadocApiPackage* _tmp48_;
		ValadocApiNamespace* _tmp49_;
		ValadocApiPackage* _tmp50_;
		ValadocApiNamespace* _tmp51_;
		ValadocApiPackage* _tmp52_;
		ValadocApiNamespace* _tmp53_;
		ValadocApiPackage* _tmp54_;
		ValadocApiNamespace* _tmp55_;
		ValadocApiPackage* _tmp56_;
		ValadocApiNamespace* _tmp57_;
		ValadocApiPackage* _tmp58_;
		ValadocApiNamespace* _tmp59_;
		ValadocApiPackage* _tmp60_;
		ValadocApiNamespace* _tmp61_;
		ValadocApiPackage* _tmp62_;
		ValadocApiNamespace* _tmp63_;
		ValadocApiPackage* _tmp64_;
		ValadocApiNamespace* _tmp65_;
		ValadocApiPackage* _tmp66_;
		ValadocApiNamespace* _tmp67_;
		ValadocApiPackage* _tmp68_;
		ValadocApiNamespace* _tmp69_;
		ValadocApiPackage* _tmp70_;
		_tmp43_ = globals;
		_tmp44_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp43_, VALADOC_API_NODE_TYPE_ERROR_CODE, (ValadocApiNode*) _tmp44_);
		_tmp45_ = globals;
		_tmp46_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp45_, VALADOC_API_NODE_TYPE_ENUM_VALUE, (ValadocApiNode*) _tmp46_);
		_tmp47_ = globals;
		_tmp48_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp47_, VALADOC_API_NODE_TYPE_ENUM, (ValadocApiNode*) _tmp48_);
		_tmp49_ = globals;
		_tmp50_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp49_, VALADOC_API_NODE_TYPE_INTERFACE, (ValadocApiNode*) _tmp50_);
		_tmp51_ = globals;
		_tmp52_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp51_, VALADOC_API_NODE_TYPE_CLASS, (ValadocApiNode*) _tmp52_);
		_tmp53_ = globals;
		_tmp54_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp53_, VALADOC_API_NODE_TYPE_STRUCT, (ValadocApiNode*) _tmp54_);
		_tmp55_ = globals;
		_tmp56_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp55_, VALADOC_API_NODE_TYPE_CONSTANT, (ValadocApiNode*) _tmp56_);
		_tmp57_ = globals;
		_tmp58_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp57_, VALADOC_API_NODE_TYPE_PROPERTY, (ValadocApiNode*) _tmp58_);
		_tmp59_ = globals;
		_tmp60_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp59_, VALADOC_API_NODE_TYPE_DELEGATE, (ValadocApiNode*) _tmp60_);
		_tmp61_ = globals;
		_tmp62_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp61_, VALADOC_API_NODE_TYPE_STATIC_METHOD, (ValadocApiNode*) _tmp62_);
		_tmp63_ = globals;
		_tmp64_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp63_, VALADOC_API_NODE_TYPE_CREATION_METHOD, (ValadocApiNode*) _tmp64_);
		_tmp65_ = globals;
		_tmp66_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp65_, VALADOC_API_NODE_TYPE_METHOD, (ValadocApiNode*) _tmp66_);
		_tmp67_ = globals;
		_tmp68_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp67_, VALADOC_API_NODE_TYPE_SIGNAL, (ValadocApiNode*) _tmp68_);
		_tmp69_ = globals;
		_tmp70_ = package;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp69_, VALADOC_API_NODE_TYPE_FIELD, (ValadocApiNode*) _tmp70_);
	}
	_tmp71_ = self->writer;
	_tmp72_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp71_, "ul");
	_tmp73_ = _tmp72_;
	_valadoc_markup_writer_unref0 (_tmp73_);
	_tmp74_ = self->writer;
	_tmp75_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp74_, "div");
	_tmp76_ = _tmp75_;
	_valadoc_markup_writer_unref0 (_tmp76_);
	_g_object_unref0 (globals);
	_vala_iterable_unref0 (ns_list);
}


void valadoc_html_basic_doclet_write_navi_symbol (ValadocHtmlBasicDoclet* self, ValadocApiNode* node) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocApiNode* _tmp7_;
	ValadocApiNode* _tmp8_;
	ValadocApiNode* _tmp9_;
	ValadocApiNode* _tmp10_;
	ValadocHtmlMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = node;
	_tmp8_ = node;
	valadoc_html_basic_doclet_write_top_elements (self, _tmp7_, _tmp8_);
	_tmp9_ = node;
	_tmp10_ = node;
	valadoc_html_basic_doclet_write_navi_symbol_inline (self, _tmp9_, _tmp10_);
	_tmp11_ = self->writer;
	_tmp12_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp11_, "div");
	_tmp13_ = _tmp12_;
	_valadoc_markup_writer_unref0 (_tmp13_);
}


void valadoc_html_basic_doclet_write_navi_leaf_symbol (ValadocHtmlBasicDoclet* self, ValadocApiNode* node) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocApiNode* _tmp7_;
	ValadocApiItem* _tmp8_;
	ValadocApiItem* _tmp9_;
	ValadocApiNode* _tmp10_;
	ValadocApiNode* _tmp11_;
	ValadocApiItem* _tmp12_;
	ValadocApiItem* _tmp13_;
	ValadocApiNode* _tmp14_;
	ValadocHtmlMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = node;
	_tmp8_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = node;
	valadoc_html_basic_doclet_write_top_elements (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALADOC_API_TYPE_NODE, ValadocApiNode), _tmp10_);
	_tmp11_ = node;
	_tmp12_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = node;
	valadoc_html_basic_doclet_write_navi_symbol_inline (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALADOC_API_TYPE_NODE, ValadocApiNode), _tmp14_);
	_tmp15_ = self->writer;
	_tmp16_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp15_, "div");
	_tmp17_ = _tmp16_;
	_valadoc_markup_writer_unref0 (_tmp17_);
}


void valadoc_html_basic_doclet_write_navi_symbol_inline (ValadocHtmlBasicDoclet* self, ValadocApiNode* node, ValadocApiNode* parent) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocApiNode* _tmp7_;
	ValadocApiNode* _tmp8_;
	ValadocApiNode* _tmp9_;
	ValadocApiNode* _tmp10_;
	ValadocApiNode* _tmp11_;
	ValadocApiNode* _tmp12_;
	ValadocApiNode* _tmp13_;
	ValadocApiNode* _tmp14_;
	ValadocApiNode* _tmp15_;
	ValadocApiNode* _tmp16_;
	ValadocApiNode* _tmp17_;
	ValadocApiNode* _tmp18_;
	ValadocApiNode* _tmp19_;
	ValadocApiNode* _tmp20_;
	ValadocApiNode* _tmp21_;
	ValadocApiNode* _tmp22_;
	ValadocApiNode* _tmp23_;
	ValadocApiNode* _tmp24_;
	ValadocApiNode* _tmp25_;
	ValadocApiNode* _tmp26_;
	ValadocApiNode* _tmp27_;
	ValadocApiNode* _tmp28_;
	ValadocApiNode* _tmp29_;
	ValadocApiNode* _tmp30_;
	ValadocApiNode* _tmp31_;
	ValadocApiNode* _tmp32_;
	ValadocApiNode* _tmp33_;
	ValadocApiNode* _tmp34_;
	ValadocApiNode* _tmp35_;
	ValadocApiNode* _tmp36_;
	ValadocHtmlMarkupWriter* _tmp37_;
	ValadocMarkupWriter* _tmp38_;
	ValadocMarkupWriter* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ul", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = node;
	_tmp8_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp7_, VALADOC_API_NODE_TYPE_NAMESPACE, _tmp8_);
	_tmp9_ = node;
	_tmp10_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp9_, VALADOC_API_NODE_TYPE_ERROR_CODE, _tmp10_);
	_tmp11_ = node;
	_tmp12_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp11_, VALADOC_API_NODE_TYPE_ENUM_VALUE, _tmp12_);
	_tmp13_ = node;
	_tmp14_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp13_, VALADOC_API_NODE_TYPE_ENUM, _tmp14_);
	_tmp15_ = node;
	_tmp16_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp15_, VALADOC_API_NODE_TYPE_INTERFACE, _tmp16_);
	_tmp17_ = node;
	_tmp18_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp17_, VALADOC_API_NODE_TYPE_CLASS, _tmp18_);
	_tmp19_ = node;
	_tmp20_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp19_, VALADOC_API_NODE_TYPE_STRUCT, _tmp20_);
	_tmp21_ = node;
	_tmp22_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp21_, VALADOC_API_NODE_TYPE_CONSTANT, _tmp22_);
	_tmp23_ = node;
	_tmp24_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp23_, VALADOC_API_NODE_TYPE_PROPERTY, _tmp24_);
	_tmp25_ = node;
	_tmp26_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp25_, VALADOC_API_NODE_TYPE_DELEGATE, _tmp26_);
	_tmp27_ = node;
	_tmp28_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp27_, VALADOC_API_NODE_TYPE_STATIC_METHOD, _tmp28_);
	_tmp29_ = node;
	_tmp30_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp29_, VALADOC_API_NODE_TYPE_CREATION_METHOD, _tmp30_);
	_tmp31_ = node;
	_tmp32_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp31_, VALADOC_API_NODE_TYPE_METHOD, _tmp32_);
	_tmp33_ = node;
	_tmp34_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp33_, VALADOC_API_NODE_TYPE_SIGNAL, _tmp34_);
	_tmp35_ = node;
	_tmp36_ = parent;
	valadoc_html_basic_doclet_write_navi_children (self, _tmp35_, VALADOC_API_NODE_TYPE_FIELD, _tmp36_);
	_tmp37_ = self->writer;
	_tmp38_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp37_, "ul");
	_tmp39_ = _tmp38_;
	_valadoc_markup_writer_unref0 (_tmp39_);
}


void valadoc_html_basic_doclet_write_navi_children (ValadocHtmlBasicDoclet* self, ValadocApiNode* node, ValadocApiNodeType type, ValadocApiNode* parent) {
	ValaList* children = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiNodeType _tmp1_;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = type;
	_tmp2_ = valadoc_api_node_get_children_by_type (_tmp0_, _tmp1_, TRUE);
	children = _tmp2_;
	_tmp3_ = children;
	vala_list_sort (_tmp3_, (GCompareDataFunc) valadoc_api_node_compare_to, NULL, NULL);
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _child_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _child_index = 0;
		_tmp4_ = children;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_child_list = _tmp5_;
		_tmp6_ = _child_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_child_size = _tmp8_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValadocApiNode* child = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValadocApiNode* _tmp15_;
			ValadocApiNode* _tmp16_;
			ValadocHtmlCssClassResolver* _tmp17_;
			ValadocApiNode* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			ValadocApiNode* _tmp21_;
			ValadocApiNode* _tmp22_;
			_tmp9_ = _child_index;
			_child_index = _tmp9_ + 1;
			_tmp10_ = _child_index;
			_tmp11_ = _child_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _child_list;
			_tmp13_ = _child_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			child = (ValadocApiNode*) _tmp14_;
			_tmp15_ = child;
			_tmp16_ = parent;
			_tmp17_ = self->cssresolver;
			_tmp18_ = child;
			_tmp19_ = valadoc_html_css_class_resolver_resolve (_tmp17_, _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = child;
			_tmp22_ = parent;
			valadoc_html_basic_doclet_write_navi_entry (self, _tmp15_, _tmp16_, _tmp20_, _tmp21_ != _tmp22_, FALSE);
			_g_free0 (_tmp20_);
			_g_object_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	_vala_iterable_unref0 (children);
}


void valadoc_html_basic_doclet_write_package_note (ValadocHtmlBasicDoclet* self, ValadocApiNode* element) {
	gchar* package = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiPackage* _tmp1_;
	ValadocApiPackage* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocHtmlMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocHtmlMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocMarkupWriter* _tmp23_;
	gchar* _tmp24_;
	ValadocApiNode* _tmp25_;
	ValadocApiPackage* _tmp26_;
	ValadocApiPackage* _tmp27_;
	ValadocApiNode* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	ValadocMarkupWriter* _tmp32_;
	ValadocMarkupWriter* _tmp33_;
	const gchar* _tmp34_;
	ValadocMarkupWriter* _tmp35_;
	ValadocMarkupWriter* _tmp36_;
	ValadocMarkupWriter* _tmp37_;
	ValadocMarkupWriter* _tmp38_;
	ValadocHtmlMarkupWriter* _tmp39_;
	ValadocMarkupWriter* _tmp40_;
	ValadocMarkupWriter* _tmp41_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	_tmp1_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	package = _tmp5_;
	_tmp6_ = package;
	if (_tmp6_ == NULL) {
		_g_free0 (package);
		return;
	}
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_package_note);
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "div", _tmp11_, 2);
	_tmp13_ = _tmp12_;
	_valadoc_markup_writer_unref0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = self->writer;
	_tmp15_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp14_, "b", NULL, 0);
	_tmp16_ = _tmp15_;
	_tmp17_ = valadoc_markup_writer_text (_tmp16_, "Package:");
	_tmp18_ = _tmp17_;
	_tmp19_ = valadoc_markup_writer_end_tag (_tmp18_, "b");
	_tmp20_ = _tmp19_;
	_valadoc_markup_writer_unref0 (_tmp20_);
	_valadoc_markup_writer_unref0 (_tmp18_);
	_valadoc_markup_writer_unref0 (_tmp16_);
	_tmp21_ = self->writer;
	_tmp22_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp21_, " ");
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup ("href");
	_tmp25_ = element;
	_tmp26_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = element;
	_tmp29_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp27_, _tmp28_);
	_tmp30_ = g_new0 (gchar*, 2 + 1);
	_tmp30_[0] = _tmp24_;
	_tmp30_[1] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 2;
	_tmp32_ = valadoc_markup_writer_start_tag (_tmp23_, "a", _tmp31_, 2);
	_tmp33_ = _tmp32_;
	_tmp34_ = package;
	_tmp35_ = valadoc_markup_writer_text (_tmp33_, _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = valadoc_markup_writer_end_tag (_tmp36_, "a");
	_tmp38_ = _tmp37_;
	_valadoc_markup_writer_unref0 (_tmp38_);
	_valadoc_markup_writer_unref0 (_tmp36_);
	_valadoc_markup_writer_unref0 (_tmp33_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_valadoc_markup_writer_unref0 (_tmp23_);
	_tmp39_ = self->writer;
	_tmp40_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp39_, "div");
	_tmp41_ = _tmp40_;
	_valadoc_markup_writer_unref0 (_tmp41_);
	_g_free0 (package);
}


void valadoc_html_basic_doclet_write_namespace_note (ValadocHtmlBasicDoclet* self, ValadocApiNode* element) {
	ValadocApiNamespace* ns = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiNamespace* _tmp1_;
	ValadocApiNamespace* _tmp2_;
	ValadocApiNamespace* _tmp3_;
	ValadocApiNamespace* _tmp4_;
	ValadocApiNamespace* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ValadocHtmlMarkupWriter* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	ValadocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocHtmlMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	ValadocHtmlMarkupWriter* _tmp22_;
	ValadocMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	gchar* _tmp25_;
	ValadocApiNamespace* _tmp26_;
	ValadocApiNode* _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	ValadocMarkupWriter* _tmp31_;
	ValadocMarkupWriter* _tmp32_;
	ValadocApiNamespace* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	ValadocMarkupWriter* _tmp36_;
	ValadocMarkupWriter* _tmp37_;
	ValadocMarkupWriter* _tmp38_;
	ValadocMarkupWriter* _tmp39_;
	ValadocHtmlMarkupWriter* _tmp40_;
	ValadocMarkupWriter* _tmp41_;
	ValadocMarkupWriter* _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	_tmp1_ = valadoc_api_node_get_nspace (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	ns = _tmp3_;
	_tmp4_ = ns;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (ns);
		return;
	}
	_tmp5_ = ns;
	_tmp6_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (ns);
		return;
	}
	_tmp8_ = self->writer;
	_tmp9_ = g_strdup ("class");
	_tmp10_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_namespace_note);
	_tmp11_ = g_new0 (gchar*, 2 + 1);
	_tmp11_[0] = _tmp9_;
	_tmp11_[1] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 2;
	_tmp13_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp8_, "div", _tmp12_, 2);
	_tmp14_ = _tmp13_;
	_valadoc_markup_writer_unref0 (_tmp14_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = self->writer;
	_tmp16_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp15_, "b", NULL, 0);
	_tmp17_ = _tmp16_;
	_tmp18_ = valadoc_markup_writer_text (_tmp17_, "Namespace:");
	_tmp19_ = _tmp18_;
	_tmp20_ = valadoc_markup_writer_end_tag (_tmp19_, "b");
	_tmp21_ = _tmp20_;
	_valadoc_markup_writer_unref0 (_tmp21_);
	_valadoc_markup_writer_unref0 (_tmp19_);
	_valadoc_markup_writer_unref0 (_tmp17_);
	_tmp22_ = self->writer;
	_tmp23_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp22_, " ");
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup ("href");
	_tmp26_ = ns;
	_tmp27_ = element;
	_tmp28_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp26_, _tmp27_);
	_tmp29_ = g_new0 (gchar*, 2 + 1);
	_tmp29_[0] = _tmp25_;
	_tmp29_[1] = _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = 2;
	_tmp31_ = valadoc_markup_writer_start_tag (_tmp24_, "a", _tmp30_, 2);
	_tmp32_ = _tmp31_;
	_tmp33_ = ns;
	_tmp34_ = valadoc_api_node_get_full_name ((ValadocApiNode*) _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = valadoc_markup_writer_text (_tmp32_, _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = valadoc_markup_writer_end_tag (_tmp37_, "a");
	_tmp39_ = _tmp38_;
	_valadoc_markup_writer_unref0 (_tmp39_);
	_valadoc_markup_writer_unref0 (_tmp37_);
	_g_free0 (_tmp35_);
	_valadoc_markup_writer_unref0 (_tmp32_);
	_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
	_valadoc_markup_writer_unref0 (_tmp24_);
	_tmp40_ = self->writer;
	_tmp41_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp40_, "div");
	_tmp42_ = _tmp41_;
	_valadoc_markup_writer_unref0 (_tmp42_);
	_g_object_unref0 (ns);
}


static gboolean valadoc_html_basic_doclet_has_brief_description (ValadocHtmlBasicDoclet* self, ValadocApiNode* element) {
	gboolean result = FALSE;
	ValadocApiNode* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (element != NULL, FALSE);
	_tmp0_ = element;
	_tmp1_ = valadoc_api_node_get_documentation (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ != NULL;
	return result;
}


static void valadoc_html_basic_doclet_write_brief_description (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, ValadocApiNode* pos) {
	ValadocContentComment* doctree = NULL;
	ValadocApiNode* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp2_;
	ValadocContentComment* _tmp3_;
	ValadocContentComment* _tmp4_;
	ValaList* description = NULL;
	ValadocContentComment* _tmp5_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	_tmp1_ = valadoc_api_node_get_documentation (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	doctree = _tmp3_;
	_tmp4_ = doctree;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (doctree);
		return;
	}
	_tmp5_ = doctree;
	_tmp6_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_iterable_ref0 (_tmp7_);
	description = _tmp8_;
	_tmp9_ = description;
	_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > 0) {
		ValadocHtmlMarkupWriter* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar** _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		ValadocMarkupWriter* _tmp17_;
		ValadocMarkupWriter* _tmp18_;
		ValadocHtmlHtmlRenderer* _tmp19_;
		ValadocApiNode* _tmp20_;
		ValadocHtmlHtmlRenderer* _tmp21_;
		ValadocApiNode* _tmp22_;
		ValadocHtmlHtmlRenderer* _tmp23_;
		ValaList* _tmp24_;
		gpointer _tmp25_;
		ValadocContentBlock* _tmp26_;
		ValadocHtmlHtmlRenderer* _tmp27_;
		ValadocHtmlMarkupWriter* _tmp28_;
		ValadocMarkupWriter* _tmp29_;
		ValadocMarkupWriter* _tmp30_;
		_tmp12_ = self->writer;
		_tmp13_ = g_strdup ("class");
		_tmp14_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_brief_description);
		_tmp15_ = g_new0 (gchar*, 2 + 1);
		_tmp15_[0] = _tmp13_;
		_tmp15_[1] = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp16__length1 = 2;
		_tmp17_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp12_, "span", _tmp16_, 2);
		_tmp18_ = _tmp17_;
		_valadoc_markup_writer_unref0 (_tmp18_);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
		_tmp19_ = self->_renderer;
		_tmp20_ = pos;
		valadoc_html_html_renderer_set_container (_tmp19_, (ValadocDocumentation*) _tmp20_);
		_tmp21_ = self->_renderer;
		_tmp22_ = element;
		valadoc_html_html_renderer_set_owner (_tmp21_, (ValadocDocumentation*) _tmp22_);
		_tmp23_ = self->_renderer;
		_tmp24_ = description;
		_tmp25_ = vala_list_get (_tmp24_, 0);
		_tmp26_ = (ValadocContentBlock*) _tmp25_;
		valadoc_content_content_renderer_render_children ((ValadocContentContentRenderer*) _tmp23_, (ValadocContentContentElement*) _tmp26_);
		_g_object_unref0 (_tmp26_);
		_tmp27_ = self->_renderer;
		valadoc_html_html_renderer_set_owner (_tmp27_, NULL);
		_tmp28_ = self->writer;
		_tmp29_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp28_, "span");
		_tmp30_ = _tmp29_;
		_valadoc_markup_writer_unref0 (_tmp30_);
	}
	_vala_iterable_unref0 (description);
	_g_object_unref0 (doctree);
}


static void valadoc_html_basic_doclet_write_documentation (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, ValadocApiNode* pos) {
	ValadocContentComment* doctree = NULL;
	ValadocApiNode* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp2_;
	ValadocContentComment* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValadocApiNode* _tmp5_;
	gboolean is_deprecated = FALSE;
	gboolean _tmp9_ = FALSE;
	ValadocContentComment* _tmp10_;
	ValadocHtmlMarkupWriter* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocHtmlHtmlRenderer* _tmp19_;
	ValadocApiNode* _tmp20_;
	gboolean _tmp21_;
	ValadocContentComment* _tmp122_;
	ValadocHtmlHtmlRenderer* _tmp127_;
	ValadocHtmlMarkupWriter* _tmp128_;
	ValadocMarkupWriter* _tmp129_;
	ValadocMarkupWriter* _tmp130_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	_tmp1_ = valadoc_api_node_get_documentation (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	doctree = _tmp3_;
	_tmp5_ = element;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALADOC_API_TYPE_SYMBOL)) {
		ValadocApiNode* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = element;
		_tmp7_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	is_deprecated = _tmp4_;
	_tmp10_ = doctree;
	if (_tmp10_ == NULL) {
		gboolean _tmp11_;
		_tmp11_ = is_deprecated;
		_tmp9_ = !_tmp11_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_g_object_unref0 (doctree);
		return;
	}
	_tmp12_ = self->writer;
	_tmp13_ = g_strdup ("class");
	_tmp14_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_description);
	_tmp15_ = g_new0 (gchar*, 2 + 1);
	_tmp15_[0] = _tmp13_;
	_tmp15_[1] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 2;
	_tmp17_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp12_, "div", _tmp16_, 2);
	_tmp18_ = _tmp17_;
	_valadoc_markup_writer_unref0 (_tmp18_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_tmp19_ = self->_renderer;
	_tmp20_ = element;
	valadoc_html_html_renderer_set_owner (_tmp19_, (ValadocDocumentation*) _tmp20_);
	_tmp21_ = is_deprecated;
	if (_tmp21_) {
		ValadocApiSymbol* symbol = NULL;
		ValadocApiNode* _tmp22_;
		ValadocApiSymbol* _tmp23_;
		ValadocApiAttribute* version = NULL;
		ValadocApiAttribute* deprecated = NULL;
		ValadocApiAttributeArgument* replacement = NULL;
		ValadocApiAttributeArgument* since = NULL;
		ValadocApiSymbol* _tmp24_;
		ValadocApiAttribute* _tmp25_;
		ValadocApiAttribute* _tmp26_;
		ValadocHtmlMarkupWriter* _tmp38_;
		ValadocMarkupWriter* _tmp39_;
		ValadocMarkupWriter* _tmp40_;
		ValadocHtmlMarkupWriter* _tmp41_;
		ValadocMarkupWriter* _tmp42_;
		ValadocMarkupWriter* _tmp43_;
		ValadocHtmlMarkupWriter* _tmp44_;
		ValadocMarkupWriter* _tmp45_;
		ValadocMarkupWriter* _tmp46_;
		ValadocHtmlMarkupWriter* _tmp47_;
		ValadocMarkupWriter* _tmp48_;
		ValadocMarkupWriter* _tmp49_;
		ValadocHtmlMarkupWriter* _tmp50_;
		ValadocApiNode* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		ValadocMarkupWriter* _tmp56_;
		ValadocMarkupWriter* _tmp57_;
		ValadocApiAttributeArgument* _tmp58_;
		ValadocHtmlMarkupWriter* _tmp67_;
		ValadocMarkupWriter* _tmp68_;
		ValadocMarkupWriter* _tmp69_;
		ValadocApiAttributeArgument* _tmp70_;
		ValadocHtmlMarkupWriter* _tmp119_;
		ValadocMarkupWriter* _tmp120_;
		ValadocMarkupWriter* _tmp121_;
		_tmp22_ = element;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
		symbol = _tmp23_;
		_tmp24_ = symbol;
		_tmp25_ = valadoc_api_symbol_get_attribute (_tmp24_, "Version");
		_g_object_unref0 (version);
		version = _tmp25_;
		_tmp26_ = version;
		if (_tmp26_ != NULL) {
			ValadocApiAttribute* _tmp27_;
			ValadocApiAttributeArgument* _tmp28_;
			ValadocApiAttribute* _tmp29_;
			ValadocApiAttributeArgument* _tmp30_;
			_tmp27_ = version;
			_tmp28_ = valadoc_api_attribute_get_argument (_tmp27_, "replacement");
			_g_object_unref0 (replacement);
			replacement = _tmp28_;
			_tmp29_ = version;
			_tmp30_ = valadoc_api_attribute_get_argument (_tmp29_, "deprecated_since");
			_g_object_unref0 (since);
			since = _tmp30_;
		} else {
			ValadocApiSymbol* _tmp31_;
			ValadocApiAttribute* _tmp32_;
			ValadocApiAttribute* _tmp33_;
			_tmp31_ = symbol;
			_tmp32_ = valadoc_api_symbol_get_attribute (_tmp31_, "Deprecated");
			_g_object_unref0 (deprecated);
			deprecated = _tmp32_;
			_tmp33_ = deprecated;
			if (_tmp33_ != NULL) {
				ValadocApiAttribute* _tmp34_;
				ValadocApiAttributeArgument* _tmp35_;
				ValadocApiAttribute* _tmp36_;
				ValadocApiAttributeArgument* _tmp37_;
				_tmp34_ = deprecated;
				_tmp35_ = valadoc_api_attribute_get_argument (_tmp34_, "replacement");
				_g_object_unref0 (replacement);
				replacement = _tmp35_;
				_tmp36_ = deprecated;
				_tmp37_ = valadoc_api_attribute_get_argument (_tmp36_, "version");
				_g_object_unref0 (since);
				since = _tmp37_;
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp38_ = self->writer;
		_tmp39_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp38_, "p", NULL, 0);
		_tmp40_ = _tmp39_;
		_valadoc_markup_writer_unref0 (_tmp40_);
		_tmp41_ = self->writer;
		_tmp42_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp41_, "b", NULL, 0);
		_tmp43_ = _tmp42_;
		_valadoc_markup_writer_unref0 (_tmp43_);
		_tmp44_ = self->writer;
		_tmp45_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp44_, "Warning:");
		_tmp46_ = _tmp45_;
		_valadoc_markup_writer_unref0 (_tmp46_);
		_tmp47_ = self->writer;
		_tmp48_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp47_, "b");
		_tmp49_ = _tmp48_;
		_valadoc_markup_writer_unref0 (_tmp49_);
		_tmp50_ = self->writer;
		_tmp51_ = element;
		_tmp52_ = valadoc_api_node_get_name (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strdup_printf (" %s is deprecated", _tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp50_, _tmp55_);
		_tmp57_ = _tmp56_;
		_valadoc_markup_writer_unref0 (_tmp57_);
		_g_free0 (_tmp55_);
		_tmp58_ = since;
		if (_tmp58_ != NULL) {
			ValadocHtmlMarkupWriter* _tmp59_;
			ValadocApiAttributeArgument* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			ValadocMarkupWriter* _tmp65_;
			ValadocMarkupWriter* _tmp66_;
			_tmp59_ = self->writer;
			_tmp60_ = since;
			_tmp61_ = valadoc_api_attribute_argument_get_value_as_string (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = g_strdup_printf (" since %s", _tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp59_, _tmp64_);
			_tmp66_ = _tmp65_;
			_valadoc_markup_writer_unref0 (_tmp66_);
			_g_free0 (_tmp64_);
			_g_free0 (_tmp62_);
		}
		_tmp67_ = self->writer;
		_tmp68_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp67_, ".");
		_tmp69_ = _tmp68_;
		_valadoc_markup_writer_unref0 (_tmp69_);
		_tmp70_ = replacement;
		if (_tmp70_ != NULL) {
			gchar* replacement_name = NULL;
			ValadocApiAttributeArgument* _tmp71_;
			gchar* _tmp72_;
			ValadocApiNode* replacement_node = NULL;
			ValadocApiTree* _tmp73_;
			ValadocApiNode* _tmp74_;
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			ValadocApiNode* _tmp81_;
			ValadocApiNode* _tmp82_;
			ValadocHtmlMarkupWriter* _tmp83_;
			ValadocMarkupWriter* _tmp84_;
			ValadocMarkupWriter* _tmp85_;
			ValadocApiNode* _tmp86_;
			ValadocHtmlMarkupWriter* _tmp116_;
			ValadocMarkupWriter* _tmp117_;
			ValadocMarkupWriter* _tmp118_;
			_tmp71_ = replacement;
			_tmp72_ = valadoc_api_attribute_argument_get_value_as_string (_tmp71_);
			replacement_name = _tmp72_;
			_tmp73_ = self->tree;
			_tmp74_ = pos;
			_tmp75_ = replacement_name;
			_tmp76_ = replacement_name;
			_tmp77_ = strlen (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = string_substring (_tmp75_, (glong) 1, (glong) (_tmp78_ - 2));
			_tmp80_ = _tmp79_;
			_tmp81_ = valadoc_api_tree_search_symbol_str (_tmp73_, _tmp74_, _tmp80_);
			_tmp82_ = _tmp81_;
			_g_free0 (_tmp80_);
			replacement_node = _tmp82_;
			_tmp83_ = self->writer;
			_tmp84_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp83_, " Use ");
			_tmp85_ = _tmp84_;
			_valadoc_markup_writer_unref0 (_tmp85_);
			_tmp86_ = replacement_node;
			if (_tmp86_ == NULL) {
				ValadocHtmlMarkupWriter* _tmp87_;
				const gchar* _tmp88_;
				ValadocMarkupWriter* _tmp89_;
				ValadocMarkupWriter* _tmp90_;
				_tmp87_ = self->writer;
				_tmp88_ = replacement_name;
				_tmp89_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp87_, _tmp88_);
				_tmp90_ = _tmp89_;
				_valadoc_markup_writer_unref0 (_tmp90_);
			} else {
				gchar* link = NULL;
				ValadocApiNode* _tmp91_;
				ValadocApiNode* _tmp92_;
				gchar* _tmp93_;
				const gchar* _tmp94_;
				_tmp91_ = replacement_node;
				_tmp92_ = pos;
				_tmp93_ = valadoc_html_basic_doclet_get_link (self, _tmp91_, _tmp92_);
				link = _tmp93_;
				_tmp94_ = link;
				if (_tmp94_ != NULL) {
					gchar* css = NULL;
					ValadocHtmlCssClassResolver* _tmp95_;
					ValadocApiNode* _tmp96_;
					gchar* _tmp97_;
					ValadocHtmlMarkupWriter* _tmp98_;
					const gchar* _tmp99_;
					ValadocApiNode* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					const gchar* _tmp103_;
					ValadocHtmlMarkupWriter* _tmp104_;
					ValadocHtmlMarkupWriter* _tmp105_;
					_tmp95_ = self->cssresolver;
					_tmp96_ = replacement_node;
					_tmp97_ = valadoc_html_css_class_resolver_resolve (_tmp95_, _tmp96_);
					css = _tmp97_;
					_tmp98_ = self->writer;
					_tmp99_ = link;
					_tmp100_ = replacement_node;
					_tmp101_ = valadoc_api_node_get_full_name (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = css;
					_tmp104_ = valadoc_html_markup_writer_link (_tmp98_, _tmp99_, _tmp102_, _tmp103_);
					_tmp105_ = _tmp104_;
					_valadoc_markup_writer_unref0 (_tmp105_);
					_g_free0 (_tmp102_);
					_g_free0 (css);
				} else {
					ValadocHtmlMarkupWriter* _tmp106_;
					ValadocMarkupWriter* _tmp107_;
					ValadocMarkupWriter* _tmp108_;
					ValadocApiNode* _tmp109_;
					gchar* _tmp110_;
					gchar* _tmp111_;
					ValadocMarkupWriter* _tmp112_;
					ValadocMarkupWriter* _tmp113_;
					ValadocMarkupWriter* _tmp114_;
					ValadocMarkupWriter* _tmp115_;
					_tmp106_ = self->writer;
					_tmp107_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp106_, "code", NULL, 0);
					_tmp108_ = _tmp107_;
					_tmp109_ = replacement_node;
					_tmp110_ = valadoc_api_node_get_full_name (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = valadoc_markup_writer_text (_tmp108_, _tmp111_);
					_tmp113_ = _tmp112_;
					_tmp114_ = valadoc_markup_writer_end_tag (_tmp113_, "code");
					_tmp115_ = _tmp114_;
					_valadoc_markup_writer_unref0 (_tmp115_);
					_valadoc_markup_writer_unref0 (_tmp113_);
					_g_free0 (_tmp111_);
					_valadoc_markup_writer_unref0 (_tmp108_);
				}
				_g_free0 (link);
			}
			_tmp116_ = self->writer;
			_tmp117_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp116_, ".");
			_tmp118_ = _tmp117_;
			_valadoc_markup_writer_unref0 (_tmp118_);
			_g_object_unref0 (replacement_node);
			_g_free0 (replacement_name);
		}
		_tmp119_ = self->writer;
		_tmp120_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp119_, "p");
		_tmp121_ = _tmp120_;
		_valadoc_markup_writer_unref0 (_tmp121_);
		_g_object_unref0 (since);
		_g_object_unref0 (replacement);
		_g_object_unref0 (deprecated);
		_g_object_unref0 (version);
		_g_object_unref0 (symbol);
	}
	_tmp122_ = doctree;
	if (_tmp122_ != NULL) {
		ValadocHtmlHtmlRenderer* _tmp123_;
		ValadocApiNode* _tmp124_;
		ValadocHtmlHtmlRenderer* _tmp125_;
		ValadocContentComment* _tmp126_;
		_tmp123_ = self->_renderer;
		_tmp124_ = pos;
		valadoc_html_html_renderer_set_container (_tmp123_, (ValadocDocumentation*) _tmp124_);
		_tmp125_ = self->_renderer;
		_tmp126_ = doctree;
		valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp125_, (ValadocContentContentElement*) _tmp126_);
	}
	_tmp127_ = self->_renderer;
	valadoc_html_html_renderer_set_owner (_tmp127_, NULL);
	_tmp128_ = self->writer;
	_tmp129_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp128_, "div");
	_tmp130_ = _tmp129_;
	_valadoc_markup_writer_unref0 (_tmp130_);
	_g_object_unref0 (doctree);
}


static void valadoc_html_basic_doclet_write_attributes (ValadocHtmlBasicDoclet* self, ValadocApiSymbol* element, ValadocApiNode* pos) {
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocHtmlHtmlRenderer* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValadocHtmlMarkupWriter* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp0_, FALSE);
	_tmp1_ = self->_renderer;
	_tmp2_ = pos;
	valadoc_html_html_renderer_set_container (_tmp1_, (ValadocDocumentation*) _tmp2_);
	{
		ValaIterator* _att_it = NULL;
		ValadocApiSymbol* _tmp3_;
		ValaCollection* _tmp4_;
		ValaCollection* _tmp5_;
		ValaIterator* _tmp6_;
		ValaIterator* _tmp7_;
		_tmp3_ = element;
		_tmp4_ = valadoc_api_symbol_get_attributes (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_iterable_iterator ((ValaIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_vala_iterable_unref0 (_tmp5_);
		_att_it = _tmp7_;
		while (TRUE) {
			ValaIterator* _tmp8_;
			gboolean _tmp9_;
			ValadocApiAttribute* att = NULL;
			ValaIterator* _tmp10_;
			gpointer _tmp11_;
			ValadocHtmlHtmlRenderer* _tmp12_;
			ValadocApiAttribute* _tmp13_;
			ValadocContentInline* _tmp14_;
			ValadocContentInline* _tmp15_;
			ValadocHtmlMarkupWriter* _tmp16_;
			ValadocMarkupWriter* _tmp17_;
			ValadocMarkupWriter* _tmp18_;
			_tmp8_ = _att_it;
			_tmp9_ = vala_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _att_it;
			_tmp11_ = vala_iterator_get (_tmp10_);
			att = (ValadocApiAttribute*) _tmp11_;
			_tmp12_ = self->_renderer;
			_tmp13_ = att;
			_tmp14_ = valadoc_api_item_get_signature ((ValadocApiItem*) _tmp13_);
			_tmp15_ = _tmp14_;
			valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp12_, (ValadocContentContentElement*) _tmp15_);
			_tmp16_ = self->writer;
			_tmp17_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp16_, "br", NULL, 0);
			_tmp18_ = _tmp17_;
			_valadoc_markup_writer_unref0 (_tmp18_);
			_g_object_unref0 (att);
		}
		_vala_iterator_unref0 (_att_it);
	}
	_tmp19_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp19_, TRUE);
}


static void valadoc_html_basic_doclet_write_signature (ValadocHtmlBasicDoclet* self, ValadocApiNode* element, ValadocApiNode* pos) {
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocHtmlHtmlRenderer* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValadocHtmlHtmlRenderer* _tmp3_;
	ValadocApiNode* _tmp4_;
	ValadocContentInline* _tmp5_;
	ValadocContentInline* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp0_, FALSE);
	_tmp1_ = self->_renderer;
	_tmp2_ = pos;
	valadoc_html_html_renderer_set_container (_tmp1_, (ValadocDocumentation*) _tmp2_);
	_tmp3_ = self->_renderer;
	_tmp4_ = element;
	_tmp5_ = valadoc_api_item_get_signature ((ValadocApiItem*) _tmp4_);
	_tmp6_ = _tmp5_;
	valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp3_, (ValadocContentContentElement*) _tmp6_);
	_tmp7_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp7_, TRUE);
}


gboolean valadoc_html_basic_doclet_is_internal_node (ValadocHtmlBasicDoclet* self, ValadocApiNode* node) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	ValadocApiNode* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp8_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALADOC_API_TYPE_PACKAGE)) {
		_tmp7_ = TRUE;
	} else {
		ValadocApiNode* _tmp9_;
		_tmp9_ = node;
		_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALADOC_API_TYPE_NAMESPACE);
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		ValadocApiNode* _tmp10_;
		_tmp10_ = node;
		_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALADOC_API_TYPE_INTERFACE);
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		ValadocApiNode* _tmp11_;
		_tmp11_ = node;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALADOC_API_TYPE_CLASS);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		ValadocApiNode* _tmp12_;
		_tmp12_ = node;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALADOC_API_TYPE_STRUCT);
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		ValadocApiNode* _tmp13_;
		_tmp13_ = node;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALADOC_API_TYPE_ENUM);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		ValadocApiNode* _tmp14_;
		_tmp14_ = node;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALADOC_API_TYPE_ENUM_VALUE);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		ValadocApiNode* _tmp15_;
		_tmp15_ = node;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALADOC_API_TYPE_ERROR_DOMAIN);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValadocApiNode* _tmp16_;
		_tmp16_ = node;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALADOC_API_TYPE_ERROR_CODE);
	}
	result = _tmp0_;
	return result;
}


void valadoc_html_basic_doclet_write_navi_packages_inline (ValadocHtmlBasicDoclet* self, ValadocApiTree* tree) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp60_;
	ValadocMarkupWriter* _tmp61_;
	ValadocMarkupWriter* _tmp62_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ul", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	{
		ValaIterator* _pkg_it = NULL;
		ValadocApiTree* _tmp7_;
		ValaCollection* _tmp8_;
		ValaCollection* _tmp9_;
		ValaIterator* _tmp10_;
		ValaIterator* _tmp11_;
		_tmp7_ = tree;
		_tmp8_ = valadoc_api_tree_get_package_list (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_iterable_iterator ((ValaIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_vala_iterable_unref0 (_tmp9_);
		_pkg_it = _tmp11_;
		while (TRUE) {
			ValaIterator* _tmp12_;
			gboolean _tmp13_;
			ValadocApiPackage* pkg = NULL;
			ValaIterator* _tmp14_;
			gpointer _tmp15_;
			ValadocApiPackage* _tmp16_;
			ValadocSettings* _tmp17_;
			gboolean _tmp18_;
			_tmp12_ = _pkg_it;
			_tmp13_ = vala_iterator_next (_tmp12_);
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = _pkg_it;
			_tmp15_ = vala_iterator_get (_tmp14_);
			pkg = (ValadocApiPackage*) _tmp15_;
			_tmp16_ = pkg;
			_tmp17_ = self->priv->_settings;
			_tmp18_ = valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp16_, _tmp17_);
			if (_tmp18_) {
				ValadocHtmlMarkupWriter* _tmp19_;
				gchar* _tmp20_;
				ValadocHtmlCssClassResolver* _tmp21_;
				ValadocApiPackage* _tmp22_;
				gchar* _tmp23_;
				gchar** _tmp24_;
				gchar** _tmp25_;
				gint _tmp25__length1;
				ValadocMarkupWriter* _tmp26_;
				ValadocMarkupWriter* _tmp27_;
				ValadocHtmlMarkupWriter* _tmp28_;
				ValadocHtmlLinkHelper* _tmp29_;
				ValadocApiPackage* _tmp30_;
				ValadocSettings* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				ValadocApiPackage* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				ValadocHtmlMarkupWriter* _tmp37_;
				ValadocHtmlMarkupWriter* _tmp38_;
				ValadocHtmlMarkupWriter* _tmp39_;
				ValadocMarkupWriter* _tmp40_;
				ValadocMarkupWriter* _tmp41_;
				_tmp19_ = self->writer;
				_tmp20_ = g_strdup ("class");
				_tmp21_ = self->cssresolver;
				_tmp22_ = pkg;
				_tmp23_ = valadoc_html_css_class_resolver_resolve (_tmp21_, (ValadocApiNode*) _tmp22_);
				_tmp24_ = g_new0 (gchar*, 2 + 1);
				_tmp24_[0] = _tmp20_;
				_tmp24_[1] = _tmp23_;
				_tmp25_ = _tmp24_;
				_tmp25__length1 = 2;
				_tmp26_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp19_, "li", _tmp25_, 2);
				_tmp27_ = _tmp26_;
				_valadoc_markup_writer_unref0 (_tmp27_);
				_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
				_tmp28_ = self->writer;
				_tmp29_ = self->priv->_linker;
				_tmp30_ = pkg;
				_tmp31_ = self->priv->_settings;
				_tmp32_ = valadoc_html_link_helper_get_package_link (_tmp29_, _tmp30_, _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = pkg;
				_tmp35_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = valadoc_html_markup_writer_link (_tmp28_, _tmp33_, _tmp36_, NULL);
				_tmp38_ = _tmp37_;
				_valadoc_markup_writer_unref0 (_tmp38_);
				_g_free0 (_tmp33_);
				_tmp39_ = self->writer;
				_tmp40_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp39_, "li");
				_tmp41_ = _tmp40_;
				_valadoc_markup_writer_unref0 (_tmp41_);
			} else {
				ValadocHtmlMarkupWriter* _tmp42_;
				gchar* _tmp43_;
				ValadocHtmlCssClassResolver* _tmp44_;
				ValadocApiPackage* _tmp45_;
				gchar* _tmp46_;
				gchar** _tmp47_;
				gchar** _tmp48_;
				gint _tmp48__length1;
				ValadocMarkupWriter* _tmp49_;
				ValadocMarkupWriter* _tmp50_;
				ValadocHtmlMarkupWriter* _tmp51_;
				ValadocApiPackage* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				ValadocMarkupWriter* _tmp55_;
				ValadocMarkupWriter* _tmp56_;
				ValadocHtmlMarkupWriter* _tmp57_;
				ValadocMarkupWriter* _tmp58_;
				ValadocMarkupWriter* _tmp59_;
				_tmp42_ = self->writer;
				_tmp43_ = g_strdup ("class");
				_tmp44_ = self->cssresolver;
				_tmp45_ = pkg;
				_tmp46_ = valadoc_html_css_class_resolver_resolve (_tmp44_, (ValadocApiNode*) _tmp45_);
				_tmp47_ = g_new0 (gchar*, 2 + 1);
				_tmp47_[0] = _tmp43_;
				_tmp47_[1] = _tmp46_;
				_tmp48_ = _tmp47_;
				_tmp48__length1 = 2;
				_tmp49_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp42_, "li", _tmp48_, 2);
				_tmp50_ = _tmp49_;
				_valadoc_markup_writer_unref0 (_tmp50_);
				_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
				_tmp51_ = self->writer;
				_tmp52_ = pkg;
				_tmp53_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp51_, _tmp54_);
				_tmp56_ = _tmp55_;
				_valadoc_markup_writer_unref0 (_tmp56_);
				_tmp57_ = self->writer;
				_tmp58_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp57_, "li");
				_tmp59_ = _tmp58_;
				_valadoc_markup_writer_unref0 (_tmp59_);
			}
			_g_object_unref0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	_tmp60_ = self->writer;
	_tmp61_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp60_, "ul");
	_tmp62_ = _tmp61_;
	_valadoc_markup_writer_unref0 (_tmp62_);
}


void valadoc_html_basic_doclet_write_navi_packages (ValadocHtmlBasicDoclet* self, ValadocApiTree* tree) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocApiTree* _tmp7_;
	ValadocHtmlMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	ValadocMarkupWriter* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = tree;
	valadoc_html_basic_doclet_write_navi_packages_inline (self, _tmp7_);
	_tmp8_ = self->writer;
	_tmp9_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp8_, "div");
	_tmp10_ = _tmp9_;
	_valadoc_markup_writer_unref0 (_tmp10_);
}


void valadoc_html_basic_doclet_write_package_index_content (ValadocHtmlBasicDoclet* self, ValadocApiTree* tree) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	ValadocMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	ValadocWikiPage* _tmp25_ = NULL;
	ValadocApiTree* _tmp26_;
	ValadocWikiPageTree* _tmp27_;
	ValadocWikiPageTree* _tmp28_;
	ValadocWikiPage* wikiindex = NULL;
	ValadocWikiPage* _tmp34_;
	ValadocWikiPage* _tmp35_;
	ValadocHtmlMarkupWriter* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar** _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	ValadocMarkupWriter* _tmp47_;
	ValadocMarkupWriter* _tmp48_;
	ValadocMarkupWriter* _tmp49_;
	ValadocMarkupWriter* _tmp50_;
	ValadocMarkupWriter* _tmp51_;
	ValadocMarkupWriter* _tmp52_;
	ValadocHtmlMarkupWriter* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar** _tmp56_;
	gchar** _tmp57_;
	gint _tmp57__length1;
	ValadocMarkupWriter* _tmp58_;
	ValadocMarkupWriter* _tmp59_;
	ValadocMarkupWriter* _tmp60_;
	ValadocMarkupWriter* _tmp61_;
	ValadocMarkupWriter* _tmp62_;
	ValadocMarkupWriter* _tmp63_;
	ValadocApiTree* _tmp64_;
	ValadocHtmlMarkupWriter* _tmp65_;
	ValadocMarkupWriter* _tmp66_;
	ValadocMarkupWriter* _tmp67_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "h1", _tmp11_, 2);
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_markup_writer_text (_tmp13_, "Packages:");
	_tmp15_ = _tmp14_;
	_tmp16_ = valadoc_markup_writer_end_tag (_tmp15_, "h1");
	_tmp17_ = _tmp16_;
	_valadoc_markup_writer_unref0 (_tmp17_);
	_valadoc_markup_writer_unref0 (_tmp15_);
	_valadoc_markup_writer_unref0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = self->writer;
	_tmp19_ = g_strdup ("class");
	_tmp20_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_headline_hr);
	_tmp21_ = g_new0 (gchar*, 2 + 1);
	_tmp21_[0] = _tmp19_;
	_tmp21_[1] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 2;
	_tmp23_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp18_, "hr", _tmp22_, 2);
	_tmp24_ = _tmp23_;
	_valadoc_markup_writer_unref0 (_tmp24_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = tree;
	_tmp27_ = valadoc_api_tree_get_wikitree (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == NULL) {
		_g_object_unref0 (_tmp25_);
		_tmp25_ = NULL;
	} else {
		ValadocApiTree* _tmp29_;
		ValadocWikiPageTree* _tmp30_;
		ValadocWikiPageTree* _tmp31_;
		const gchar* _tmp32_;
		ValadocWikiPage* _tmp33_;
		_tmp29_ = tree;
		_tmp30_ = valadoc_api_tree_get_wikitree (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = self->priv->_wiki_index_name;
		_tmp33_ = valadoc_wiki_page_tree_search (_tmp31_, _tmp32_);
		_g_object_unref0 (_tmp25_);
		_tmp25_ = _tmp33_;
	}
	_tmp34_ = _g_object_ref0 (_tmp25_);
	wikiindex = _tmp34_;
	_tmp35_ = wikiindex;
	if (_tmp35_ != NULL) {
		ValadocHtmlHtmlRenderer* _tmp36_;
		ValadocWikiPage* _tmp37_;
		ValadocHtmlHtmlRenderer* _tmp38_;
		ValadocWikiPage* _tmp39_;
		ValadocContentPage* _tmp40_;
		ValadocContentPage* _tmp41_;
		_tmp36_ = self->_renderer;
		_tmp37_ = wikiindex;
		valadoc_html_html_renderer_set_container (_tmp36_, (ValadocDocumentation*) _tmp37_);
		_tmp38_ = self->_renderer;
		_tmp39_ = wikiindex;
		_tmp40_ = valadoc_wiki_page_get_documentation (_tmp39_);
		_tmp41_ = _tmp40_;
		valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp38_, (ValadocContentContentElement*) _tmp41_);
	}
	_tmp42_ = self->writer;
	_tmp43_ = g_strdup ("class");
	_tmp44_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp45_ = g_new0 (gchar*, 2 + 1);
	_tmp45_[0] = _tmp43_;
	_tmp45_[1] = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp46__length1 = 2;
	_tmp47_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp42_, "h2", _tmp46_, 2);
	_tmp48_ = _tmp47_;
	_tmp49_ = valadoc_markup_writer_text (_tmp48_, "Content:");
	_tmp50_ = _tmp49_;
	_tmp51_ = valadoc_markup_writer_end_tag (_tmp50_, "h2");
	_tmp52_ = _tmp51_;
	_valadoc_markup_writer_unref0 (_tmp52_);
	_valadoc_markup_writer_unref0 (_tmp50_);
	_valadoc_markup_writer_unref0 (_tmp48_);
	_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = self->writer;
	_tmp54_ = g_strdup ("class");
	_tmp55_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp56_ = g_new0 (gchar*, 2 + 1);
	_tmp56_[0] = _tmp54_;
	_tmp56_[1] = _tmp55_;
	_tmp57_ = _tmp56_;
	_tmp57__length1 = 2;
	_tmp58_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp53_, "h3", _tmp57_, 2);
	_tmp59_ = _tmp58_;
	_tmp60_ = valadoc_markup_writer_text (_tmp59_, "Packages:");
	_tmp61_ = _tmp60_;
	_tmp62_ = valadoc_markup_writer_end_tag (_tmp61_, "h3");
	_tmp63_ = _tmp62_;
	_valadoc_markup_writer_unref0 (_tmp63_);
	_valadoc_markup_writer_unref0 (_tmp61_);
	_valadoc_markup_writer_unref0 (_tmp59_);
	_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
	_tmp64_ = tree;
	valadoc_html_basic_doclet_write_navi_packages_inline (self, _tmp64_);
	_tmp65_ = self->writer;
	_tmp66_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp65_, "div");
	_tmp67_ = _tmp66_;
	_valadoc_markup_writer_unref0 (_tmp67_);
	_g_object_unref0 (wikiindex);
	_g_object_unref0 (_tmp25_);
}


static inline ValaCollection* valadoc_html_basic_doclet_get_accessible_nodes_from_list (ValadocHtmlBasicDoclet* self, ValaCollection* nodes) {
	ValaCollection* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nodes != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	list = _tmp1_;
	{
		ValaIterator* _node_it = NULL;
		ValaCollection* _tmp2_;
		ValaIterator* _tmp3_;
		_tmp2_ = nodes;
		_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
		_node_it = _tmp3_;
		while (TRUE) {
			ValaIterator* _tmp4_;
			gboolean _tmp5_;
			ValadocApiNode* node = NULL;
			ValaIterator* _tmp6_;
			gpointer _tmp7_;
			ValadocApiNode* _tmp8_;
			ValadocSettings* _tmp9_;
			gboolean _tmp10_;
			_tmp4_ = _node_it;
			_tmp5_ = vala_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _node_it;
			_tmp7_ = vala_iterator_get (_tmp6_);
			node = (ValadocApiNode*) _tmp7_;
			_tmp8_ = node;
			_tmp9_ = self->priv->_settings;
			_tmp10_ = valadoc_api_node_is_browsable (_tmp8_, _tmp9_);
			if (_tmp10_) {
				ValaArrayList* _tmp11_;
				ValadocApiNode* _tmp12_;
				_tmp11_ = list;
				_tmp12_ = node;
				vala_collection_add ((ValaCollection*) _tmp11_, _tmp12_);
			}
			_g_object_unref0 (node);
		}
		_vala_iterator_unref0 (_node_it);
	}
	result = (ValaCollection*) list;
	return result;
}


static void valadoc_html_basic_doclet_write_known_symbols_note (ValadocHtmlBasicDoclet* self, ValaCollection* nodes2, ValadocApiNode* container, const gchar* headline) {
	ValaCollection* nodes = NULL;
	ValaCollection* _tmp0_;
	ValaCollection* _tmp1_;
	ValaCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* html_id = NULL;
	guint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	guint _tmp10_;
	ValadocHtmlMarkupWriter* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	ValadocMarkupWriter* _tmp26_;
	ValadocMarkupWriter* _tmp27_;
	const gchar* _tmp28_;
	ValadocMarkupWriter* _tmp29_;
	ValadocMarkupWriter* _tmp30_;
	ValadocMarkupWriter* _tmp31_;
	ValadocMarkupWriter* _tmp32_;
	gint* list_sizes = NULL;
	gint* _tmp33_;
	gint list_sizes_length1;
	gint _list_sizes_size_;
	gint* _tmp34_;
	gint _tmp34__length1;
	ValaCollection* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint* _tmp39_;
	gint _tmp39__length1;
	gint* _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_;
	gint _tmp42_;
	gint* _tmp43_;
	gint _tmp43__length1;
	gint* _tmp44_;
	gint _tmp44__length1;
	gint _tmp45_;
	gint _tmp46_;
	gint* _tmp47_;
	gint _tmp47__length1;
	gint* _tmp48_;
	gint _tmp48__length1;
	gint _tmp49_;
	gint _tmp50_;
	gint* _tmp51_;
	gint _tmp51__length1;
	gint* _tmp52_;
	gint _tmp52__length1;
	gint _tmp53_;
	gint _tmp54_;
	ValadocHtmlMarkupWriter* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gchar** _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	ValadocMarkupWriter* _tmp63_;
	ValadocMarkupWriter* _tmp64_;
	ValaIterator* iter = NULL;
	ValaCollection* _tmp65_;
	ValaIterator* _tmp66_;
	ValadocHtmlMarkupWriter* _tmp131_;
	ValadocMarkupWriter* _tmp132_;
	ValadocMarkupWriter* _tmp133_;
	ValadocHtmlMarkupWriter* _tmp134_;
	ValadocMarkupWriter* _tmp135_;
	ValadocMarkupWriter* _tmp136_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nodes2 != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (headline != NULL);
	_tmp0_ = nodes2;
	_tmp1_ = valadoc_html_basic_doclet_get_accessible_nodes_from_list (self, _tmp0_);
	nodes = _tmp1_;
	_tmp2_ = nodes;
	_tmp3_ = vala_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		_vala_iterable_unref0 (nodes);
		return;
	}
	_tmp5_ = self->priv->html_id_counter;
	_tmp6_ = g_strdup_printf ("%u", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("box-content-", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	html_id = _tmp9_;
	_tmp10_ = self->priv->html_id_counter;
	self->priv->html_id_counter = _tmp10_ + 1;
	_tmp11_ = self->writer;
	_tmp12_ = g_strdup ("class");
	_tmp13_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box);
	_tmp14_ = g_new0 (gchar*, 2 + 1);
	_tmp14_[0] = _tmp12_;
	_tmp14_[1] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 2;
	_tmp16_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp11_, "div", _tmp15_, 2);
	_tmp17_ = _tmp16_;
	_valadoc_markup_writer_unref0 (_tmp17_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = self->writer;
	_tmp19_ = g_strdup ("class");
	_tmp20_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box_headline);
	_tmp21_ = g_strdup ("onclick");
	_tmp22_ = html_id;
	_tmp23_ = g_strdup_printf ("toggle_box (this, '%s')", _tmp22_);
	_tmp24_ = g_new0 (gchar*, 4 + 1);
	_tmp24_[0] = _tmp19_;
	_tmp24_[1] = _tmp20_;
	_tmp24_[2] = _tmp21_;
	_tmp24_[3] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 4;
	_tmp26_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp18_, "div", _tmp25_, 4);
	_tmp27_ = _tmp26_;
	_tmp28_ = headline;
	_tmp29_ = valadoc_markup_writer_text (_tmp27_, _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = valadoc_markup_writer_end_tag (_tmp30_, "div");
	_tmp32_ = _tmp31_;
	_valadoc_markup_writer_unref0 (_tmp32_);
	_valadoc_markup_writer_unref0 (_tmp30_);
	_valadoc_markup_writer_unref0 (_tmp27_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp33_ = g_new0 (gint, 3);
	_tmp33_[0] = 0;
	_tmp33_[1] = 0;
	_tmp33_[2] = 0;
	list_sizes = _tmp33_;
	list_sizes_length1 = 3;
	_list_sizes_size_ = list_sizes_length1;
	_tmp34_ = list_sizes;
	_tmp34__length1 = list_sizes_length1;
	_tmp35_ = nodes;
	_tmp36_ = vala_collection_get_size (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp34_[0] = _tmp37_;
	_tmp38_ = _tmp34_[0];
	_tmp39_ = list_sizes;
	_tmp39__length1 = list_sizes_length1;
	_tmp40_ = list_sizes;
	_tmp40__length1 = list_sizes_length1;
	_tmp41_ = _tmp40_[0];
	_tmp39_[2] = _tmp41_ / 3;
	_tmp42_ = _tmp39_[2];
	_tmp43_ = list_sizes;
	_tmp43__length1 = list_sizes_length1;
	_tmp44_ = list_sizes;
	_tmp44__length1 = list_sizes_length1;
	_tmp45_ = _tmp44_[2];
	_tmp43_[0] -= _tmp45_;
	_tmp46_ = _tmp43_[0];
	_tmp47_ = list_sizes;
	_tmp47__length1 = list_sizes_length1;
	_tmp48_ = list_sizes;
	_tmp48__length1 = list_sizes_length1;
	_tmp49_ = _tmp48_[0];
	_tmp47_[1] = _tmp49_ / 2;
	_tmp50_ = _tmp47_[1];
	_tmp51_ = list_sizes;
	_tmp51__length1 = list_sizes_length1;
	_tmp52_ = list_sizes;
	_tmp52__length1 = list_sizes_length1;
	_tmp53_ = _tmp52_[1];
	_tmp51_[0] -= _tmp53_;
	_tmp54_ = _tmp51_[0];
	_tmp55_ = self->writer;
	_tmp56_ = g_strdup ("class");
	_tmp57_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box_content);
	_tmp58_ = g_strdup ("id");
	_tmp59_ = html_id;
	_tmp60_ = g_strdup (_tmp59_);
	_tmp61_ = g_new0 (gchar*, 4 + 1);
	_tmp61_[0] = _tmp56_;
	_tmp61_[1] = _tmp57_;
	_tmp61_[2] = _tmp58_;
	_tmp61_[3] = _tmp60_;
	_tmp62_ = _tmp61_;
	_tmp62__length1 = 4;
	_tmp63_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp55_, "div", _tmp62_, 4);
	_tmp64_ = _tmp63_;
	_valadoc_markup_writer_unref0 (_tmp64_);
	_tmp62_ = (_vala_array_free (_tmp62_, _tmp62__length1, (GDestroyNotify) g_free), NULL);
	_tmp65_ = nodes;
	_tmp66_ = vala_iterable_iterator ((ValaIterable*) _tmp65_);
	iter = _tmp66_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp67_ = FALSE;
			_tmp67_ = TRUE;
			while (TRUE) {
				gint _tmp69_;
				gint* _tmp70_;
				gint _tmp70__length1;
				ValadocHtmlMarkupWriter* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar** _tmp74_;
				gchar** _tmp75_;
				gint _tmp75__length1;
				ValadocMarkupWriter* _tmp76_;
				ValadocMarkupWriter* _tmp77_;
				ValadocHtmlMarkupWriter* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar** _tmp81_;
				gchar** _tmp82_;
				gint _tmp82__length1;
				ValadocMarkupWriter* _tmp83_;
				ValadocMarkupWriter* _tmp84_;
				ValadocHtmlMarkupWriter* _tmp125_;
				ValadocMarkupWriter* _tmp126_;
				ValadocMarkupWriter* _tmp127_;
				ValadocHtmlMarkupWriter* _tmp128_;
				ValadocMarkupWriter* _tmp129_;
				ValadocMarkupWriter* _tmp130_;
				if (!_tmp67_) {
					gint _tmp68_;
					_tmp68_ = i;
					i = _tmp68_ + 1;
				}
				_tmp67_ = FALSE;
				_tmp69_ = i;
				_tmp70_ = list_sizes;
				_tmp70__length1 = list_sizes_length1;
				if (!(_tmp69_ < _tmp70__length1)) {
					break;
				}
				_tmp71_ = self->writer;
				_tmp72_ = g_strdup ("class");
				_tmp73_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box_column);
				_tmp74_ = g_new0 (gchar*, 2 + 1);
				_tmp74_[0] = _tmp72_;
				_tmp74_[1] = _tmp73_;
				_tmp75_ = _tmp74_;
				_tmp75__length1 = 2;
				_tmp76_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp71_, "div", _tmp75_, 2);
				_tmp77_ = _tmp76_;
				_valadoc_markup_writer_unref0 (_tmp77_);
				_tmp75_ = (_vala_array_free (_tmp75_, _tmp75__length1, (GDestroyNotify) g_free), NULL);
				_tmp78_ = self->writer;
				_tmp79_ = g_strdup ("class");
				_tmp80_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
				_tmp81_ = g_new0 (gchar*, 2 + 1);
				_tmp81_[0] = _tmp79_;
				_tmp81_[1] = _tmp80_;
				_tmp82_ = _tmp81_;
				_tmp82__length1 = 2;
				_tmp83_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp78_, "ul", _tmp82_, 2);
				_tmp84_ = _tmp83_;
				_valadoc_markup_writer_unref0 (_tmp84_);
				_tmp82_ = (_vala_array_free (_tmp82_, _tmp82__length1, (GDestroyNotify) g_free), NULL);
				{
					gint p = 0;
					p = 0;
					{
						gboolean _tmp85_ = FALSE;
						_tmp85_ = TRUE;
						while (TRUE) {
							gboolean _tmp87_ = FALSE;
							gint _tmp88_;
							gint* _tmp89_;
							gint _tmp89__length1;
							gint _tmp90_;
							gint _tmp91_;
							ValadocApiNode* node = NULL;
							ValaIterator* _tmp94_;
							gpointer _tmp95_;
							ValadocHtmlMarkupWriter* _tmp96_;
							gchar* _tmp97_;
							ValadocHtmlCssClassResolver* _tmp98_;
							ValadocApiNode* _tmp99_;
							gchar* _tmp100_;
							gchar** _tmp101_;
							gchar** _tmp102_;
							gint _tmp102__length1;
							ValadocMarkupWriter* _tmp103_;
							ValadocMarkupWriter* _tmp104_;
							gchar* link = NULL;
							ValadocApiNode* _tmp105_;
							ValadocApiNode* _tmp106_;
							gchar* _tmp107_;
							const gchar* _tmp108_;
							ValadocHtmlMarkupWriter* _tmp122_;
							ValadocMarkupWriter* _tmp123_;
							ValadocMarkupWriter* _tmp124_;
							if (!_tmp85_) {
								gint _tmp86_;
								_tmp86_ = p;
								p = _tmp86_ + 1;
							}
							_tmp85_ = FALSE;
							_tmp88_ = p;
							_tmp89_ = list_sizes;
							_tmp89__length1 = list_sizes_length1;
							_tmp90_ = i;
							_tmp91_ = _tmp89_[_tmp90_];
							if (_tmp88_ < _tmp91_) {
								ValaIterator* _tmp92_;
								gboolean _tmp93_;
								_tmp92_ = iter;
								_tmp93_ = vala_iterator_next (_tmp92_);
								_tmp87_ = _tmp93_;
							} else {
								_tmp87_ = FALSE;
							}
							if (!_tmp87_) {
								break;
							}
							_tmp94_ = iter;
							_tmp95_ = vala_iterator_get (_tmp94_);
							node = (ValadocApiNode*) _tmp95_;
							_tmp96_ = self->writer;
							_tmp97_ = g_strdup ("class");
							_tmp98_ = self->cssresolver;
							_tmp99_ = node;
							_tmp100_ = valadoc_html_css_class_resolver_resolve (_tmp98_, _tmp99_);
							_tmp101_ = g_new0 (gchar*, 2 + 1);
							_tmp101_[0] = _tmp97_;
							_tmp101_[1] = _tmp100_;
							_tmp102_ = _tmp101_;
							_tmp102__length1 = 2;
							_tmp103_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp96_, "li", _tmp102_, 2);
							_tmp104_ = _tmp103_;
							_valadoc_markup_writer_unref0 (_tmp104_);
							_tmp102_ = (_vala_array_free (_tmp102_, _tmp102__length1, (GDestroyNotify) g_free), NULL);
							_tmp105_ = node;
							_tmp106_ = container;
							_tmp107_ = valadoc_html_basic_doclet_get_link (self, _tmp105_, _tmp106_);
							link = _tmp107_;
							_tmp108_ = link;
							if (_tmp108_ == NULL) {
								ValadocHtmlMarkupWriter* _tmp109_;
								ValadocApiNode* _tmp110_;
								const gchar* _tmp111_;
								const gchar* _tmp112_;
								ValadocMarkupWriter* _tmp113_;
								ValadocMarkupWriter* _tmp114_;
								_tmp109_ = self->writer;
								_tmp110_ = node;
								_tmp111_ = valadoc_api_node_get_name (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp113_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp109_, _tmp112_);
								_tmp114_ = _tmp113_;
								_valadoc_markup_writer_unref0 (_tmp114_);
							} else {
								ValadocHtmlMarkupWriter* _tmp115_;
								const gchar* _tmp116_;
								ValadocApiNode* _tmp117_;
								const gchar* _tmp118_;
								const gchar* _tmp119_;
								ValadocHtmlMarkupWriter* _tmp120_;
								ValadocHtmlMarkupWriter* _tmp121_;
								_tmp115_ = self->writer;
								_tmp116_ = link;
								_tmp117_ = node;
								_tmp118_ = valadoc_api_node_get_name (_tmp117_);
								_tmp119_ = _tmp118_;
								_tmp120_ = valadoc_html_markup_writer_link (_tmp115_, _tmp116_, _tmp119_, NULL);
								_tmp121_ = _tmp120_;
								_valadoc_markup_writer_unref0 (_tmp121_);
							}
							_tmp122_ = self->writer;
							_tmp123_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp122_, "li");
							_tmp124_ = _tmp123_;
							_valadoc_markup_writer_unref0 (_tmp124_);
							_g_free0 (link);
							_g_object_unref0 (node);
						}
					}
				}
				_tmp125_ = self->writer;
				_tmp126_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp125_, "ul");
				_tmp127_ = _tmp126_;
				_valadoc_markup_writer_unref0 (_tmp127_);
				_tmp128_ = self->writer;
				_tmp129_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp128_, "div");
				_tmp130_ = _tmp129_;
				_valadoc_markup_writer_unref0 (_tmp130_);
			}
		}
	}
	_tmp131_ = self->writer;
	_tmp132_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp131_, "div");
	_tmp133_ = _tmp132_;
	_valadoc_markup_writer_unref0 (_tmp133_);
	_tmp134_ = self->writer;
	_tmp135_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp134_, "div");
	_tmp136_ = _tmp135_;
	_valadoc_markup_writer_unref0 (_tmp136_);
	_vala_iterator_unref0 (iter);
	list_sizes = (g_free (list_sizes), NULL);
	_g_free0 (html_id);
	_vala_iterable_unref0 (nodes);
}


void valadoc_html_basic_doclet_write_symbol_content (ValadocHtmlBasicDoclet* self, ValadocApiNode* node) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocApiNode* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocHtmlMarkupWriter* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	ValadocMarkupWriter* _tmp26_;
	ValadocMarkupWriter* _tmp27_;
	ValadocApiNode* _tmp28_;
	ValadocHtmlMarkupWriter* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	ValadocMarkupWriter* _tmp34_;
	ValadocMarkupWriter* _tmp35_;
	ValadocMarkupWriter* _tmp36_;
	ValadocMarkupWriter* _tmp37_;
	ValadocMarkupWriter* _tmp38_;
	ValadocMarkupWriter* _tmp39_;
	ValadocHtmlMarkupWriter* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar** _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	ValadocMarkupWriter* _tmp45_;
	ValadocMarkupWriter* _tmp46_;
	ValadocApiNode* _tmp47_;
	ValadocApiNode* _tmp50_;
	ValadocApiNode* _tmp51_;
	ValadocHtmlMarkupWriter* _tmp52_;
	ValadocMarkupWriter* _tmp53_;
	ValadocMarkupWriter* _tmp54_;
	ValadocApiNode* _tmp55_;
	ValadocApiNode* _tmp56_;
	ValadocApiNode* _tmp57_;
	ValadocApiNode* _tmp86_;
	ValadocApiItem* _tmp87_;
	ValadocApiItem* _tmp88_;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_ = FALSE;
	ValadocApiNode* _tmp96_;
	ValadocApiNode* _tmp141_;
	ValadocHtmlMarkupWriter* _tmp150_;
	ValadocMarkupWriter* _tmp151_;
	ValadocMarkupWriter* _tmp152_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "h1", _tmp11_, 2);
	_tmp13_ = _tmp12_;
	_tmp14_ = node;
	_tmp15_ = valadoc_api_node_get_name (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = valadoc_markup_writer_text (_tmp13_, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = valadoc_markup_writer_end_tag (_tmp18_, "h1");
	_tmp20_ = _tmp19_;
	_valadoc_markup_writer_unref0 (_tmp20_);
	_valadoc_markup_writer_unref0 (_tmp18_);
	_valadoc_markup_writer_unref0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp21_ = self->writer;
	_tmp22_ = g_strdup ("class");
	_tmp23_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_headline_hr);
	_tmp24_ = g_new0 (gchar*, 2 + 1);
	_tmp24_[0] = _tmp22_;
	_tmp24_[1] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 2;
	_tmp26_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp21_, "hr", _tmp25_, 2);
	_tmp27_ = _tmp26_;
	_valadoc_markup_writer_unref0 (_tmp27_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp28_ = node;
	valadoc_html_basic_doclet_write_image_block (self, _tmp28_);
	_tmp29_ = self->writer;
	_tmp30_ = g_strdup ("class");
	_tmp31_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp32_ = g_new0 (gchar*, 2 + 1);
	_tmp32_[0] = _tmp30_;
	_tmp32_[1] = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp33__length1 = 2;
	_tmp34_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp29_, "h2", _tmp33_, 2);
	_tmp35_ = _tmp34_;
	_tmp36_ = valadoc_markup_writer_text (_tmp35_, "Description:");
	_tmp37_ = _tmp36_;
	_tmp38_ = valadoc_markup_writer_end_tag (_tmp37_, "h2");
	_tmp39_ = _tmp38_;
	_valadoc_markup_writer_unref0 (_tmp39_);
	_valadoc_markup_writer_unref0 (_tmp37_);
	_valadoc_markup_writer_unref0 (_tmp35_);
	_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
	_tmp40_ = self->writer;
	_tmp41_ = g_strdup ("class");
	_tmp42_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_code_definition);
	_tmp43_ = g_new0 (gchar*, 2 + 1);
	_tmp43_[0] = _tmp41_;
	_tmp43_[1] = _tmp42_;
	_tmp44_ = _tmp43_;
	_tmp44__length1 = 2;
	_tmp45_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp40_, "div", _tmp44_, 2);
	_tmp46_ = _tmp45_;
	_valadoc_markup_writer_unref0 (_tmp46_);
	_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
	_tmp47_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALADOC_API_TYPE_SYMBOL)) {
		ValadocApiNode* _tmp48_;
		ValadocApiNode* _tmp49_;
		_tmp48_ = node;
		_tmp49_ = node;
		valadoc_html_basic_doclet_write_attributes (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol), _tmp49_);
	}
	_tmp50_ = node;
	_tmp51_ = node;
	valadoc_html_basic_doclet_write_signature (self, _tmp50_, _tmp51_);
	_tmp52_ = self->writer;
	_tmp53_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp52_, "div");
	_tmp54_ = _tmp53_;
	_valadoc_markup_writer_unref0 (_tmp54_);
	_tmp55_ = node;
	_tmp56_ = node;
	valadoc_html_basic_doclet_write_documentation (self, _tmp55_, _tmp56_);
	_tmp57_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALADOC_API_TYPE_CLASS)) {
		ValadocApiClass* cl = NULL;
		ValadocApiNode* _tmp58_;
		ValadocApiClass* _tmp59_;
		ValadocApiClass* _tmp60_;
		ValaCollection* _tmp61_;
		ValaCollection* _tmp62_;
		ValadocApiClass* _tmp63_;
		ValadocApiClass* _tmp64_;
		ValaCollection* _tmp65_;
		ValaCollection* _tmp66_;
		ValadocApiClass* _tmp67_;
		_tmp58_ = node;
		_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, VALADOC_API_TYPE_CLASS) ? ((ValadocApiClass*) _tmp58_) : NULL);
		cl = _tmp59_;
		_tmp60_ = cl;
		_tmp61_ = valadoc_api_class_get_known_child_classes (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = cl;
		valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp62_, (ValadocApiNode*) _tmp63_, "All known sub-classes:");
		_vala_iterable_unref0 (_tmp62_);
		_tmp64_ = cl;
		_tmp65_ = valadoc_api_class_get_known_derived_interfaces (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = cl;
		valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp66_, (ValadocApiNode*) _tmp67_, "Required by:");
		_vala_iterable_unref0 (_tmp66_);
		_g_object_unref0 (cl);
	} else {
		ValadocApiNode* _tmp68_;
		_tmp68_ = node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALADOC_API_TYPE_INTERFACE)) {
			ValadocApiInterface* iface = NULL;
			ValadocApiNode* _tmp69_;
			ValadocApiInterface* _tmp70_;
			ValadocApiInterface* _tmp71_;
			ValaCollection* _tmp72_;
			ValaCollection* _tmp73_;
			ValadocApiInterface* _tmp74_;
			ValadocApiInterface* _tmp75_;
			ValaCollection* _tmp76_;
			ValaCollection* _tmp77_;
			ValadocApiInterface* _tmp78_;
			_tmp69_ = node;
			_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALADOC_API_TYPE_INTERFACE) ? ((ValadocApiInterface*) _tmp69_) : NULL);
			iface = _tmp70_;
			_tmp71_ = iface;
			_tmp72_ = valadoc_api_interface_get_known_implementations (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = iface;
			valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp73_, (ValadocApiNode*) _tmp74_, "All known implementing classes:");
			_vala_iterable_unref0 (_tmp73_);
			_tmp75_ = iface;
			_tmp76_ = valadoc_api_interface_get_known_related_interfaces (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = iface;
			valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp77_, (ValadocApiNode*) _tmp78_, "All known sub-interfaces:");
			_vala_iterable_unref0 (_tmp77_);
			_g_object_unref0 (iface);
		} else {
			ValadocApiNode* _tmp79_;
			_tmp79_ = node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp79_, VALADOC_API_TYPE_STRUCT)) {
				ValadocApiStruct* stru = NULL;
				ValadocApiNode* _tmp80_;
				ValadocApiStruct* _tmp81_;
				ValadocApiStruct* _tmp82_;
				ValaCollection* _tmp83_;
				ValaCollection* _tmp84_;
				ValadocApiStruct* _tmp85_;
				_tmp80_ = node;
				_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, VALADOC_API_TYPE_STRUCT) ? ((ValadocApiStruct*) _tmp80_) : NULL);
				stru = _tmp81_;
				_tmp82_ = stru;
				_tmp83_ = valadoc_api_struct_get_known_child_structs (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = stru;
				valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp84_, (ValadocApiNode*) _tmp85_, "All known sub-structs:");
				_vala_iterable_unref0 (_tmp84_);
				_g_object_unref0 (stru);
			}
		}
	}
	_tmp86_ = node;
	_tmp87_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp86_);
	_tmp88_ = _tmp87_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, VALADOC_API_TYPE_NAMESPACE)) {
		ValadocHtmlMarkupWriter* _tmp89_;
		ValadocMarkupWriter* _tmp90_;
		ValadocMarkupWriter* _tmp91_;
		ValadocApiNode* _tmp92_;
		ValadocApiNode* _tmp93_;
		_tmp89_ = self->writer;
		_tmp90_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp89_, "br", NULL, 0);
		_tmp91_ = _tmp90_;
		_valadoc_markup_writer_unref0 (_tmp91_);
		_tmp92_ = node;
		valadoc_html_basic_doclet_write_namespace_note (self, _tmp92_);
		_tmp93_ = node;
		valadoc_html_basic_doclet_write_package_note (self, _tmp93_);
	}
	_tmp96_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp96_, VALADOC_API_TYPE_METHOD)) {
		_tmp95_ = TRUE;
	} else {
		ValadocApiNode* _tmp97_;
		_tmp97_ = node;
		_tmp95_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALADOC_API_TYPE_DELEGATE);
	}
	if (_tmp95_) {
		_tmp94_ = TRUE;
	} else {
		ValadocApiNode* _tmp98_;
		_tmp98_ = node;
		_tmp94_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALADOC_API_TYPE_SIGNAL);
	}
	if (!_tmp94_) {
		ValadocApiNode* _tmp99_;
		ValadocApiNodeType* _tmp100_;
		ValadocApiNodeType* _tmp101_;
		gint _tmp101__length1;
		gboolean _tmp102_;
		gboolean _tmp103_;
		_tmp99_ = node;
		_tmp100_ = g_new0 (ValadocApiNodeType, 13);
		_tmp100_[0] = VALADOC_API_NODE_TYPE_ERROR_CODE;
		_tmp100_[1] = VALADOC_API_NODE_TYPE_ENUM_VALUE;
		_tmp100_[2] = VALADOC_API_NODE_TYPE_CREATION_METHOD;
		_tmp100_[3] = VALADOC_API_NODE_TYPE_STATIC_METHOD;
		_tmp100_[4] = VALADOC_API_NODE_TYPE_CLASS;
		_tmp100_[5] = VALADOC_API_NODE_TYPE_STRUCT;
		_tmp100_[6] = VALADOC_API_NODE_TYPE_ENUM;
		_tmp100_[7] = VALADOC_API_NODE_TYPE_DELEGATE;
		_tmp100_[8] = VALADOC_API_NODE_TYPE_METHOD;
		_tmp100_[9] = VALADOC_API_NODE_TYPE_SIGNAL;
		_tmp100_[10] = VALADOC_API_NODE_TYPE_PROPERTY;
		_tmp100_[11] = VALADOC_API_NODE_TYPE_FIELD;
		_tmp100_[12] = VALADOC_API_NODE_TYPE_CONSTANT;
		_tmp101_ = _tmp100_;
		_tmp101__length1 = 13;
		_tmp102_ = valadoc_api_node_has_children (_tmp99_, _tmp101_, 13);
		_tmp103_ = _tmp102_;
		_tmp101_ = (g_free (_tmp101_), NULL);
		if (_tmp103_) {
			ValadocHtmlMarkupWriter* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar** _tmp107_;
			gchar** _tmp108_;
			gint _tmp108__length1;
			ValadocMarkupWriter* _tmp109_;
			ValadocMarkupWriter* _tmp110_;
			ValadocMarkupWriter* _tmp111_;
			ValadocMarkupWriter* _tmp112_;
			ValadocMarkupWriter* _tmp113_;
			ValadocMarkupWriter* _tmp114_;
			ValadocApiNode* _tmp115_;
			ValadocApiNode* _tmp116_;
			ValadocApiNode* _tmp117_;
			ValadocApiNode* _tmp118_;
			ValadocApiNode* _tmp119_;
			ValadocApiNode* _tmp120_;
			ValadocApiNode* _tmp121_;
			ValadocApiNode* _tmp122_;
			ValadocApiNode* _tmp123_;
			ValadocApiNode* _tmp124_;
			ValadocApiNode* _tmp125_;
			ValadocApiNode* _tmp126_;
			ValadocApiNode* _tmp127_;
			ValadocApiNode* _tmp128_;
			ValadocApiNode* _tmp129_;
			ValadocApiNode* _tmp130_;
			ValadocApiNode* _tmp131_;
			ValadocApiNode* _tmp132_;
			ValadocApiNode* _tmp133_;
			ValadocApiNode* _tmp134_;
			ValadocApiNode* _tmp135_;
			ValadocApiNode* _tmp136_;
			ValadocApiNode* _tmp137_;
			ValadocApiNode* _tmp138_;
			ValadocApiNode* _tmp139_;
			ValadocApiNode* _tmp140_;
			_tmp104_ = self->writer;
			_tmp105_ = g_strdup ("class");
			_tmp106_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
			_tmp107_ = g_new0 (gchar*, 2 + 1);
			_tmp107_[0] = _tmp105_;
			_tmp107_[1] = _tmp106_;
			_tmp108_ = _tmp107_;
			_tmp108__length1 = 2;
			_tmp109_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp104_, "h2", _tmp108_, 2);
			_tmp110_ = _tmp109_;
			_tmp111_ = valadoc_markup_writer_text (_tmp110_, "Content:");
			_tmp112_ = _tmp111_;
			_tmp113_ = valadoc_markup_writer_end_tag (_tmp112_, "h2");
			_tmp114_ = _tmp113_;
			_valadoc_markup_writer_unref0 (_tmp114_);
			_valadoc_markup_writer_unref0 (_tmp112_);
			_valadoc_markup_writer_unref0 (_tmp110_);
			_tmp108_ = (_vala_array_free (_tmp108_, _tmp108__length1, (GDestroyNotify) g_free), NULL);
			_tmp115_ = node;
			_tmp116_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp115_, VALADOC_API_NODE_TYPE_ERROR_CODE, "Error codes", _tmp116_);
			_tmp117_ = node;
			_tmp118_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp117_, VALADOC_API_NODE_TYPE_ENUM_VALUE, "Enum values", _tmp118_);
			_tmp119_ = node;
			_tmp120_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp119_, VALADOC_API_NODE_TYPE_CLASS, "Classes", _tmp120_);
			_tmp121_ = node;
			_tmp122_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp121_, VALADOC_API_NODE_TYPE_STRUCT, "Structs", _tmp122_);
			_tmp123_ = node;
			_tmp124_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp123_, VALADOC_API_NODE_TYPE_ENUM, "Enums", _tmp124_);
			_tmp125_ = node;
			_tmp126_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp125_, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", _tmp126_);
			_tmp127_ = node;
			_tmp128_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp127_, VALADOC_API_NODE_TYPE_PROPERTY, "Properties", _tmp128_);
			_tmp129_ = node;
			_tmp130_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp129_, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", _tmp130_);
			_tmp131_ = node;
			_tmp132_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp131_, VALADOC_API_NODE_TYPE_STATIC_METHOD, "Static methods", _tmp132_);
			_tmp133_ = node;
			_tmp134_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp133_, VALADOC_API_NODE_TYPE_CREATION_METHOD, "Creation methods", _tmp134_);
			_tmp135_ = node;
			_tmp136_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp135_, VALADOC_API_NODE_TYPE_METHOD, "Methods", _tmp136_);
			_tmp137_ = node;
			_tmp138_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp137_, VALADOC_API_NODE_TYPE_SIGNAL, "Signals", _tmp138_);
			_tmp139_ = node;
			_tmp140_ = node;
			valadoc_html_basic_doclet_write_children (self, _tmp139_, VALADOC_API_NODE_TYPE_FIELD, "Fields", _tmp140_);
		}
	}
	_tmp141_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp141_, VALADOC_API_TYPE_CLASS)) {
		ValadocApiNode* _tmp142_;
		ValadocApiNode* _tmp143_;
		_tmp142_ = node;
		_tmp143_ = node;
		valadoc_html_basic_doclet_write_inherited_symbols_note_for_class (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp142_, VALADOC_API_TYPE_CLASS, ValadocApiClass), _tmp143_);
	} else {
		ValadocApiNode* _tmp144_;
		_tmp144_ = node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALADOC_API_TYPE_INTERFACE)) {
			ValadocApiNode* _tmp145_;
			ValadocApiNode* _tmp146_;
			_tmp145_ = node;
			_tmp146_ = node;
			valadoc_html_basic_doclet_write_inherited_symbols_note_for_interface (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface), _tmp146_);
		} else {
			ValadocApiNode* _tmp147_;
			_tmp147_ = node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp147_, VALADOC_API_TYPE_STRUCT)) {
				ValadocApiNode* _tmp148_;
				ValadocApiNode* _tmp149_;
				_tmp148_ = node;
				_tmp149_ = node;
				valadoc_html_basic_doclet_write_inherited_symbols_note_for_struct (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, VALADOC_API_TYPE_STRUCT, ValadocApiStruct), _tmp149_);
			}
		}
	}
	_tmp150_ = self->writer;
	_tmp151_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp150_, "div");
	_tmp152_ = _tmp151_;
	_valadoc_markup_writer_unref0 (_tmp152_);
}


static inline gboolean valadoc_html_basic_doclet_has_visible_inheritable_children (ValadocHtmlBasicDoclet* self, ValadocApiTypeSymbol* symbol) {
	gboolean result = FALSE;
	ValadocApiTypeSymbol* _tmp0_;
	ValadocApiNodeType* _tmp1_;
	gint _tmp1__length1;
	ValadocSettings* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	_tmp0_ = symbol;
	_tmp1_ = valadoc_html_basic_doclet_inheritable_members;
	_tmp1__length1 = valadoc_html_basic_doclet_inheritable_members_length1;
	_tmp2_ = self->priv->_settings;
	_tmp3_ = valadoc_api_node_has_visible_children_by_types ((ValadocApiNode*) _tmp0_, _tmp1_, _tmp1__length1, _tmp2_);
	result = _tmp3_;
	return result;
}


static void valadoc_html_basic_doclet_write_inherited_members_headline (ValadocHtmlBasicDoclet* self) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocMarkupWriter* _tmp7_;
	ValadocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	ValadocMarkupWriter* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "h3", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_markup_writer_text (_tmp6_, "Inherited Members:");
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_markup_writer_end_tag (_tmp8_, "h3");
	_tmp10_ = _tmp9_;
	_valadoc_markup_writer_unref0 (_tmp10_);
	_valadoc_markup_writer_unref0 (_tmp8_);
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
}


static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_class (ValadocHtmlBasicDoclet* self, ValadocApiClass* cl, ValadocApiNode* container) {
	gboolean headline_printed = FALSE;
	ValadocApiClass* base_class = NULL;
	ValadocApiClass* _tmp0_;
	ValadocApiTypeReference* _tmp1_;
	ValadocApiTypeReference* _tmp2_;
	ValadocApiTypeSymbol* _tmp3_;
	ValadocApiClass* _tmp4_;
	ValaCollection* printed_interfaces = NULL;
	GEqualFunc _tmp17_;
	ValaArrayList* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	g_return_if_fail (container != NULL);
	headline_printed = FALSE;
	_tmp0_ = cl;
	_tmp1_ = valadoc_api_class_get_base_type (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_API_TYPE_CLASS) ? ((ValadocApiClass*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	base_class = _tmp4_;
	while (TRUE) {
		ValadocApiClass* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		ValadocApiClass* _tmp10_;
		ValadocApiNode* _tmp11_;
		ValadocApiClass* _tmp12_;
		ValadocApiTypeReference* _tmp13_;
		ValadocApiTypeReference* _tmp14_;
		ValadocApiTypeSymbol* _tmp15_;
		ValadocApiClass* _tmp16_;
		_tmp5_ = base_class;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp7_ = headline_printed;
		if (!_tmp7_) {
			ValadocApiClass* _tmp8_;
			gboolean _tmp9_;
			_tmp8_ = base_class;
			_tmp9_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp8_);
			_tmp6_ = _tmp9_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			valadoc_html_basic_doclet_write_inherited_members_headline (self);
			headline_printed = TRUE;
		}
		_tmp10_ = base_class;
		_tmp11_ = container;
		valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp10_, "class", _tmp11_);
		_tmp12_ = base_class;
		_tmp13_ = valadoc_api_class_get_base_type (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp14_);
		_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALADOC_API_TYPE_CLASS) ? ((ValadocApiClass*) _tmp15_) : NULL;
		if (_tmp16_ == NULL) {
			_g_object_unref0 (_tmp15_);
		}
		_g_object_unref0 (base_class);
		base_class = _tmp16_;
	}
	_tmp17_ = g_direct_equal;
	_tmp18_ = vala_array_list_new (VALADOC_API_TYPE_INTERFACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp17_);
	printed_interfaces = (ValaCollection*) _tmp18_;
	{
		ValaIterator* _iface_ref_it = NULL;
		ValadocApiClass* _tmp19_;
		ValaCollection* _tmp20_;
		ValaCollection* _tmp21_;
		ValaIterator* _tmp22_;
		ValaIterator* _tmp23_;
		_tmp19_ = cl;
		_tmp20_ = valadoc_api_class_get_full_implemented_interface_list (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_iterable_iterator ((ValaIterable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_vala_iterable_unref0 (_tmp21_);
		_iface_ref_it = _tmp23_;
		while (TRUE) {
			ValaIterator* _tmp24_;
			gboolean _tmp25_;
			ValadocApiTypeReference* iface_ref = NULL;
			ValaIterator* _tmp26_;
			gpointer _tmp27_;
			ValadocApiInterface* iface = NULL;
			ValadocApiTypeReference* _tmp28_;
			ValadocApiTypeSymbol* _tmp29_;
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_;
			ValadocApiInterface* _tmp37_;
			ValadocApiNode* _tmp38_;
			ValaCollection* _tmp39_;
			ValadocApiInterface* _tmp40_;
			_tmp24_ = _iface_ref_it;
			_tmp25_ = vala_iterator_next (_tmp24_);
			if (!_tmp25_) {
				break;
			}
			_tmp26_ = _iface_ref_it;
			_tmp27_ = vala_iterator_get (_tmp26_);
			iface_ref = (ValadocApiTypeReference*) _tmp27_;
			_tmp28_ = iface_ref;
			_tmp29_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp28_);
			iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface);
			_tmp31_ = headline_printed;
			if (!_tmp31_) {
				ValadocApiInterface* _tmp32_;
				gboolean _tmp33_;
				_tmp32_ = iface;
				_tmp33_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp32_);
				_tmp30_ = _tmp33_;
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				valadoc_html_basic_doclet_write_inherited_members_headline (self);
				headline_printed = TRUE;
			} else {
				ValaCollection* _tmp34_;
				ValadocApiInterface* _tmp35_;
				gboolean _tmp36_;
				_tmp34_ = printed_interfaces;
				_tmp35_ = iface;
				_tmp36_ = vala_collection_contains (_tmp34_, _tmp35_);
				if (_tmp36_) {
					_g_object_unref0 (iface);
					_g_object_unref0 (iface_ref);
					continue;
				}
			}
			_tmp37_ = iface;
			_tmp38_ = container;
			valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp37_, "interface", _tmp38_);
			_tmp39_ = printed_interfaces;
			_tmp40_ = iface;
			vala_collection_add (_tmp39_, _tmp40_);
			_g_object_unref0 (iface);
			_g_object_unref0 (iface_ref);
		}
		_vala_iterator_unref0 (_iface_ref_it);
	}
	_vala_iterable_unref0 (printed_interfaces);
	_g_object_unref0 (base_class);
}


static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_interface (ValadocHtmlBasicDoclet* self, ValadocApiInterface* iface, ValadocApiNode* container) {
	gboolean headline_printed = FALSE;
	ValadocApiClass* base_class = NULL;
	ValadocApiInterface* _tmp0_;
	ValadocApiTypeReference* _tmp1_;
	ValadocApiTypeReference* _tmp2_;
	ValadocApiTypeSymbol* _tmp3_;
	ValadocApiClass* _tmp4_;
	ValaCollection* printed_interfaces = NULL;
	GEqualFunc _tmp17_;
	ValaArrayList* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (container != NULL);
	headline_printed = FALSE;
	_tmp0_ = iface;
	_tmp1_ = valadoc_api_interface_get_base_type (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_API_TYPE_CLASS) ? ((ValadocApiClass*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	base_class = _tmp4_;
	while (TRUE) {
		ValadocApiClass* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		ValadocApiClass* _tmp10_;
		ValadocApiNode* _tmp11_;
		ValadocApiClass* _tmp12_;
		ValadocApiTypeReference* _tmp13_;
		ValadocApiTypeReference* _tmp14_;
		ValadocApiTypeSymbol* _tmp15_;
		ValadocApiClass* _tmp16_;
		_tmp5_ = base_class;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp7_ = headline_printed;
		if (!_tmp7_) {
			ValadocApiClass* _tmp8_;
			gboolean _tmp9_;
			_tmp8_ = base_class;
			_tmp9_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp8_);
			_tmp6_ = _tmp9_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			valadoc_html_basic_doclet_write_inherited_members_headline (self);
			headline_printed = TRUE;
		}
		_tmp10_ = base_class;
		_tmp11_ = container;
		valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp10_, "class", _tmp11_);
		_tmp12_ = base_class;
		_tmp13_ = valadoc_api_class_get_base_type (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp14_);
		_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALADOC_API_TYPE_CLASS) ? ((ValadocApiClass*) _tmp15_) : NULL;
		if (_tmp16_ == NULL) {
			_g_object_unref0 (_tmp15_);
		}
		_g_object_unref0 (base_class);
		base_class = _tmp16_;
	}
	_tmp17_ = g_direct_equal;
	_tmp18_ = vala_array_list_new (VALADOC_API_TYPE_INTERFACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp17_);
	printed_interfaces = (ValaCollection*) _tmp18_;
	{
		ValaIterator* _pre_ref_it = NULL;
		ValadocApiInterface* _tmp19_;
		ValaCollection* _tmp20_;
		ValaCollection* _tmp21_;
		ValaIterator* _tmp22_;
		ValaIterator* _tmp23_;
		_tmp19_ = iface;
		_tmp20_ = valadoc_api_interface_get_full_implemented_interface_list (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_iterable_iterator ((ValaIterable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_vala_iterable_unref0 (_tmp21_);
		_pre_ref_it = _tmp23_;
		while (TRUE) {
			ValaIterator* _tmp24_;
			gboolean _tmp25_;
			ValadocApiTypeReference* pre_ref = NULL;
			ValaIterator* _tmp26_;
			gpointer _tmp27_;
			ValadocApiInterface* pre = NULL;
			ValadocApiTypeReference* _tmp28_;
			ValadocApiTypeSymbol* _tmp29_;
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_;
			ValadocApiInterface* _tmp37_;
			ValadocApiNode* _tmp38_;
			ValaCollection* _tmp39_;
			ValadocApiInterface* _tmp40_;
			_tmp24_ = _pre_ref_it;
			_tmp25_ = vala_iterator_next (_tmp24_);
			if (!_tmp25_) {
				break;
			}
			_tmp26_ = _pre_ref_it;
			_tmp27_ = vala_iterator_get (_tmp26_);
			pre_ref = (ValadocApiTypeReference*) _tmp27_;
			_tmp28_ = pre_ref;
			_tmp29_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp28_);
			pre = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface);
			_tmp31_ = headline_printed;
			if (!_tmp31_) {
				ValadocApiInterface* _tmp32_;
				gboolean _tmp33_;
				_tmp32_ = pre;
				_tmp33_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp32_);
				_tmp30_ = _tmp33_;
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				valadoc_html_basic_doclet_write_inherited_members_headline (self);
				headline_printed = TRUE;
			} else {
				ValaCollection* _tmp34_;
				ValadocApiInterface* _tmp35_;
				gboolean _tmp36_;
				_tmp34_ = printed_interfaces;
				_tmp35_ = pre;
				_tmp36_ = vala_collection_contains (_tmp34_, _tmp35_);
				if (_tmp36_) {
					_g_object_unref0 (pre);
					_g_object_unref0 (pre_ref);
					continue;
				}
			}
			_tmp37_ = pre;
			_tmp38_ = container;
			valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp37_, "interface", _tmp38_);
			_tmp39_ = printed_interfaces;
			_tmp40_ = pre;
			vala_collection_add (_tmp39_, _tmp40_);
			_g_object_unref0 (pre);
			_g_object_unref0 (pre_ref);
		}
		_vala_iterator_unref0 (_pre_ref_it);
	}
	_vala_iterable_unref0 (printed_interfaces);
	_g_object_unref0 (base_class);
}


static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_struct (ValadocHtmlBasicDoclet* self, ValadocApiStruct* str, ValadocApiNode* container) {
	ValadocApiStruct* base_struct = NULL;
	ValadocApiStruct* _tmp0_;
	ValadocApiTypeReference* _tmp1_;
	ValadocApiTypeReference* _tmp2_;
	ValadocApiTypeSymbol* _tmp3_;
	ValadocApiStruct* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValadocApiStruct* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = str;
	_tmp1_ = valadoc_api_struct_get_base_type (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_API_TYPE_STRUCT) ? ((ValadocApiStruct*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	base_struct = _tmp4_;
	_tmp6_ = base_struct;
	if (_tmp6_ != NULL) {
		ValadocApiStruct* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = base_struct;
		_tmp8_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp7_);
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValadocApiStruct* _tmp9_;
		ValadocApiNode* _tmp10_;
		valadoc_html_basic_doclet_write_inherited_members_headline (self);
		_tmp9_ = base_struct;
		_tmp10_ = container;
		valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp9_, "struct", _tmp10_);
	}
	_g_object_unref0 (base_struct);
}


static void valadoc_html_basic_doclet_write_inherited_symbols_note (ValadocHtmlBasicDoclet* self, ValadocApiTypeSymbol* symbol, const gchar* type, ValadocApiNode* container) {
	ValadocApiTypeSymbol* _tmp0_;
	ValadocApiNodeType* _tmp1_;
	gint _tmp1__length1;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	ValadocApiNode* _tmp4_;
	const gchar* _tmp5_;
	ValadocApiTypeSymbol* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = symbol;
	_tmp1_ = valadoc_html_basic_doclet_inheritable_members;
	_tmp1__length1 = valadoc_html_basic_doclet_inheritable_members_length1;
	_tmp2_ = valadoc_api_node_get_children_by_types ((ValadocApiNode*) _tmp0_, _tmp1_, _tmp1__length1, FALSE);
	_tmp3_ = _tmp2_;
	_tmp4_ = container;
	_tmp5_ = type;
	_tmp6_ = symbol;
	_tmp7_ = valadoc_api_node_get_full_name ((ValadocApiNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("All known members inherited from %s %s", _tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	valadoc_html_basic_doclet_write_known_symbols_note (self, (ValaCollection*) _tmp3_, _tmp4_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_vala_iterable_unref0 (_tmp3_);
}


void valadoc_html_basic_doclet_write_child_namespaces (ValadocHtmlBasicDoclet* self, ValadocApiNode* node, ValadocApiNode* parent) {
	ValaArrayList* namespaces = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ValaArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp16_ = FALSE;
	ValadocApiNode* _tmp17_;
	gboolean with_childs = FALSE;
	ValadocHtmlMarkupWriter* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	ValadocMarkupWriter* _tmp24_;
	ValadocMarkupWriter* _tmp25_;
	ValadocMarkupWriter* _tmp26_;
	ValadocMarkupWriter* _tmp27_;
	ValadocMarkupWriter* _tmp28_;
	ValadocMarkupWriter* _tmp29_;
	ValadocHtmlMarkupWriter* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	ValadocMarkupWriter* _tmp35_;
	ValadocMarkupWriter* _tmp36_;
	ValadocHtmlMarkupWriter* _tmp99_;
	ValadocMarkupWriter* _tmp100_;
	ValadocMarkupWriter* _tmp101_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NAMESPACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	namespaces = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = namespaces;
	valadoc_html_basic_doclet_fetch_subnamespace_names (self, _tmp2_, _tmp3_);
	_tmp4_ = namespaces;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		_vala_iterable_unref0 (namespaces);
		return;
	}
	_tmp7_ = namespaces;
	_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == 1) {
		ValaArrayList* _tmp10_;
		gpointer _tmp11_;
		ValadocApiNamespace* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp10_ = namespaces;
		_tmp11_ = vala_list_get ((ValaList*) _tmp10_, 0);
		_tmp12_ = (ValadocApiNamespace*) _tmp11_;
		_tmp13_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_ == NULL;
		_g_object_unref0 (_tmp12_);
		if (_tmp15_) {
			_vala_iterable_unref0 (namespaces);
			return;
		}
	}
	_tmp17_ = parent;
	if (_tmp17_ != NULL) {
		ValadocApiNode* _tmp18_;
		_tmp18_ = parent;
		_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALADOC_API_TYPE_PACKAGE);
	} else {
		_tmp16_ = FALSE;
	}
	with_childs = _tmp16_;
	_tmp19_ = self->writer;
	_tmp20_ = g_strdup ("class");
	_tmp21_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp22_ = g_new0 (gchar*, 2 + 1);
	_tmp22_[0] = _tmp20_;
	_tmp22_[1] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 2;
	_tmp24_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp19_, "h3", _tmp23_, 2);
	_tmp25_ = _tmp24_;
	_tmp26_ = valadoc_markup_writer_text (_tmp25_, "Namespaces:");
	_tmp27_ = _tmp26_;
	_tmp28_ = valadoc_markup_writer_end_tag (_tmp27_, "h3");
	_tmp29_ = _tmp28_;
	_valadoc_markup_writer_unref0 (_tmp29_);
	_valadoc_markup_writer_unref0 (_tmp27_);
	_valadoc_markup_writer_unref0 (_tmp25_);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp30_ = self->writer;
	_tmp31_ = g_strdup ("class");
	_tmp32_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
	_tmp33_ = g_new0 (gchar*, 2 + 1);
	_tmp33_[0] = _tmp31_;
	_tmp33_[1] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 2;
	_tmp35_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp30_, "ul", _tmp34_, 2);
	_tmp36_ = _tmp35_;
	_valadoc_markup_writer_unref0 (_tmp36_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp37_;
		ValaArrayList* _tmp38_;
		gint _child_size = 0;
		ValaArrayList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _child_index = 0;
		_tmp37_ = namespaces;
		_tmp38_ = _vala_iterable_ref0 (_tmp37_);
		_child_list = _tmp38_;
		_tmp39_ = _child_list;
		_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_child_size = _tmp41_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			ValadocApiNamespace* child = NULL;
			ValaArrayList* _tmp45_;
			gint _tmp46_;
			gpointer _tmp47_;
			ValadocApiNamespace* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			_tmp42_ = _child_index;
			_child_index = _tmp42_ + 1;
			_tmp43_ = _child_index;
			_tmp44_ = _child_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _child_list;
			_tmp46_ = _child_index;
			_tmp47_ = vala_list_get ((ValaList*) _tmp45_, _tmp46_);
			child = (ValadocApiNamespace*) _tmp47_;
			_tmp48_ = child;
			_tmp49_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp48_);
			_tmp50_ = _tmp49_;
			if (_tmp50_ != NULL) {
				ValadocHtmlMarkupWriter* _tmp51_;
				gchar* _tmp52_;
				ValadocHtmlCssClassResolver* _tmp53_;
				ValadocApiNamespace* _tmp54_;
				gchar* _tmp55_;
				gchar** _tmp56_;
				gchar** _tmp57_;
				gint _tmp57__length1;
				ValadocMarkupWriter* _tmp58_;
				ValadocMarkupWriter* _tmp59_;
				ValadocHtmlMarkupWriter* _tmp60_;
				ValadocApiNamespace* _tmp61_;
				ValadocApiNode* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				ValadocApiNamespace* _tmp65_;
				const gchar* _tmp66_;
				const gchar* _tmp67_;
				ValadocHtmlMarkupWriter* _tmp68_;
				ValadocHtmlMarkupWriter* _tmp69_;
				ValadocApiNamespace* _tmp70_;
				gboolean _tmp71_;
				ValadocHtmlMarkupWriter* _tmp77_;
				ValadocMarkupWriter* _tmp78_;
				ValadocMarkupWriter* _tmp79_;
				gboolean _tmp80_;
				_tmp51_ = self->writer;
				_tmp52_ = g_strdup ("class");
				_tmp53_ = self->cssresolver;
				_tmp54_ = child;
				_tmp55_ = valadoc_html_css_class_resolver_resolve (_tmp53_, (ValadocApiNode*) _tmp54_);
				_tmp56_ = g_new0 (gchar*, 2 + 1);
				_tmp56_[0] = _tmp52_;
				_tmp56_[1] = _tmp55_;
				_tmp57_ = _tmp56_;
				_tmp57__length1 = 2;
				_tmp58_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp51_, "li", _tmp57_, 2);
				_tmp59_ = _tmp58_;
				_valadoc_markup_writer_unref0 (_tmp59_);
				_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
				_tmp60_ = self->writer;
				_tmp61_ = child;
				_tmp62_ = parent;
				_tmp63_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp61_, _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = child;
				_tmp66_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = valadoc_html_markup_writer_link (_tmp60_, _tmp64_, _tmp67_, NULL);
				_tmp69_ = _tmp68_;
				_valadoc_markup_writer_unref0 (_tmp69_);
				_g_free0 (_tmp64_);
				_tmp70_ = child;
				_tmp71_ = valadoc_html_basic_doclet_has_brief_description (self, (ValadocApiNode*) _tmp70_);
				if (_tmp71_) {
					ValadocHtmlMarkupWriter* _tmp72_;
					ValadocMarkupWriter* _tmp73_;
					ValadocMarkupWriter* _tmp74_;
					ValadocApiNamespace* _tmp75_;
					ValadocApiNode* _tmp76_;
					_tmp72_ = self->writer;
					_tmp73_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp72_, " - ");
					_tmp74_ = _tmp73_;
					_valadoc_markup_writer_unref0 (_tmp74_);
					_tmp75_ = child;
					_tmp76_ = parent;
					valadoc_html_basic_doclet_write_brief_description (self, (ValadocApiNode*) _tmp75_, _tmp76_);
				}
				_tmp77_ = self->writer;
				_tmp78_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp77_, "li");
				_tmp79_ = _tmp78_;
				_valadoc_markup_writer_unref0 (_tmp79_);
				_tmp80_ = with_childs;
				if (_tmp80_ == TRUE) {
					ValadocApiNamespace* _tmp81_;
					ValadocApiNode* _tmp82_;
					ValadocApiNamespace* _tmp83_;
					ValadocApiNode* _tmp84_;
					ValadocApiNamespace* _tmp85_;
					ValadocApiNode* _tmp86_;
					ValadocApiNamespace* _tmp87_;
					ValadocApiNode* _tmp88_;
					ValadocApiNamespace* _tmp89_;
					ValadocApiNode* _tmp90_;
					ValadocApiNamespace* _tmp91_;
					ValadocApiNode* _tmp92_;
					ValadocApiNamespace* _tmp93_;
					ValadocApiNode* _tmp94_;
					ValadocApiNamespace* _tmp95_;
					ValadocApiNode* _tmp96_;
					ValadocApiNamespace* _tmp97_;
					ValadocApiNode* _tmp98_;
					_tmp81_ = child;
					_tmp82_ = parent;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp81_, VALADOC_API_NODE_TYPE_INTERFACE, "Interfaces", _tmp82_);
					_tmp83_ = child;
					_tmp84_ = parent;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp83_, VALADOC_API_NODE_TYPE_CLASS, "Classes", _tmp84_);
					_tmp85_ = child;
					_tmp86_ = parent;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp85_, VALADOC_API_NODE_TYPE_STRUCT, "Structs", _tmp86_);
					_tmp87_ = child;
					_tmp88_ = parent;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp87_, VALADOC_API_NODE_TYPE_ENUM, "Enums", _tmp88_);
					_tmp89_ = child;
					_tmp90_ = parent;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp89_, VALADOC_API_NODE_TYPE_ERROR_DOMAIN, "Error domains", _tmp90_);
					_tmp91_ = child;
					_tmp92_ = parent;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp91_, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", _tmp92_);
					_tmp93_ = child;
					_tmp94_ = parent;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp93_, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", _tmp94_);
					_tmp95_ = child;
					_tmp96_ = parent;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp95_, VALADOC_API_NODE_TYPE_METHOD, "Methods", _tmp96_);
					_tmp97_ = child;
					_tmp98_ = parent;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp97_, VALADOC_API_NODE_TYPE_FIELD, "Fields", _tmp98_);
				}
			}
			_g_object_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	_tmp99_ = self->writer;
	_tmp100_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp99_, "ul");
	_tmp101_ = _tmp100_;
	_valadoc_markup_writer_unref0 (_tmp101_);
	_vala_iterable_unref0 (namespaces);
}


void valadoc_html_basic_doclet_write_child_dependencies (ValadocHtmlBasicDoclet* self, ValadocApiPackage* package, ValadocApiNode* parent) {
	ValaCollection* deps = NULL;
	ValadocApiPackage* _tmp0_;
	ValaCollection* _tmp1_;
	ValaCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValadocHtmlMarkupWriter* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	ValadocMarkupWriter* _tmp10_;
	ValadocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	ValadocHtmlMarkupWriter* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	ValadocMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocHtmlMarkupWriter* _tmp76_;
	ValadocMarkupWriter* _tmp77_;
	ValadocMarkupWriter* _tmp78_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = package;
	_tmp1_ = valadoc_api_package_get_full_dependency_list (_tmp0_);
	deps = _tmp1_;
	_tmp2_ = deps;
	_tmp3_ = vala_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		_vala_iterable_unref0 (deps);
		return;
	}
	_tmp5_ = self->writer;
	_tmp6_ = g_strdup ("class");
	_tmp7_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp8_ = g_new0 (gchar*, 2 + 1);
	_tmp8_[0] = _tmp6_;
	_tmp8_[1] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 2;
	_tmp10_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp5_, "h2", _tmp9_, 2);
	_tmp11_ = _tmp10_;
	_tmp12_ = valadoc_markup_writer_text (_tmp11_, "Dependencies:");
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_markup_writer_end_tag (_tmp13_, "h2");
	_tmp15_ = _tmp14_;
	_valadoc_markup_writer_unref0 (_tmp15_);
	_valadoc_markup_writer_unref0 (_tmp13_);
	_valadoc_markup_writer_unref0 (_tmp11_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp16_ = self->writer;
	_tmp17_ = g_strdup ("class");
	_tmp18_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
	_tmp19_ = g_new0 (gchar*, 2 + 1);
	_tmp19_[0] = _tmp17_;
	_tmp19_[1] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 2;
	_tmp21_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp16_, "ul", _tmp20_, 2);
	_tmp22_ = _tmp21_;
	_valadoc_markup_writer_unref0 (_tmp22_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	{
		ValaIterator* _p_it = NULL;
		ValaCollection* _tmp23_;
		ValaIterator* _tmp24_;
		_tmp23_ = deps;
		_tmp24_ = vala_iterable_iterator ((ValaIterable*) _tmp23_);
		_p_it = _tmp24_;
		while (TRUE) {
			ValaIterator* _tmp25_;
			gboolean _tmp26_;
			ValadocApiPackage* p = NULL;
			ValaIterator* _tmp27_;
			gpointer _tmp28_;
			gchar* link = NULL;
			ValadocApiPackage* _tmp29_;
			ValadocApiNode* _tmp30_;
			gchar* _tmp31_;
			const gchar* _tmp32_;
			_tmp25_ = _p_it;
			_tmp26_ = vala_iterator_next (_tmp25_);
			if (!_tmp26_) {
				break;
			}
			_tmp27_ = _p_it;
			_tmp28_ = vala_iterator_get (_tmp27_);
			p = (ValadocApiPackage*) _tmp28_;
			_tmp29_ = p;
			_tmp30_ = parent;
			_tmp31_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp29_, _tmp30_);
			link = _tmp31_;
			_tmp32_ = link;
			if (_tmp32_ == NULL) {
				ValadocHtmlMarkupWriter* _tmp33_;
				gchar* _tmp34_;
				ValadocHtmlCssClassResolver* _tmp35_;
				ValadocApiPackage* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				ValadocApiPackage* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar** _tmp43_;
				gchar** _tmp44_;
				gint _tmp44__length1;
				ValadocMarkupWriter* _tmp45_;
				ValadocMarkupWriter* _tmp46_;
				ValadocApiPackage* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				ValadocMarkupWriter* _tmp50_;
				ValadocMarkupWriter* _tmp51_;
				ValadocMarkupWriter* _tmp52_;
				ValadocMarkupWriter* _tmp53_;
				_tmp33_ = self->writer;
				_tmp34_ = g_strdup ("class");
				_tmp35_ = self->cssresolver;
				_tmp36_ = p;
				_tmp37_ = valadoc_html_css_class_resolver_resolve (_tmp35_, (ValadocApiNode*) _tmp36_);
				_tmp38_ = g_strdup ("id");
				_tmp39_ = p;
				_tmp40_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strdup (_tmp41_);
				_tmp43_ = g_new0 (gchar*, 4 + 1);
				_tmp43_[0] = _tmp34_;
				_tmp43_[1] = _tmp37_;
				_tmp43_[2] = _tmp38_;
				_tmp43_[3] = _tmp42_;
				_tmp44_ = _tmp43_;
				_tmp44__length1 = 4;
				_tmp45_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp33_, "li", _tmp44_, 4);
				_tmp46_ = _tmp45_;
				_tmp47_ = p;
				_tmp48_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = valadoc_markup_writer_text (_tmp46_, _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = valadoc_markup_writer_end_tag (_tmp51_, "li");
				_tmp53_ = _tmp52_;
				_valadoc_markup_writer_unref0 (_tmp53_);
				_valadoc_markup_writer_unref0 (_tmp51_);
				_valadoc_markup_writer_unref0 (_tmp46_);
				_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
			} else {
				ValadocHtmlMarkupWriter* _tmp54_;
				gchar* _tmp55_;
				ValadocHtmlCssClassResolver* _tmp56_;
				ValadocApiPackage* _tmp57_;
				gchar* _tmp58_;
				gchar** _tmp59_;
				gchar** _tmp60_;
				gint _tmp60__length1;
				ValadocMarkupWriter* _tmp61_;
				ValadocMarkupWriter* _tmp62_;
				ValadocHtmlMarkupWriter* _tmp63_;
				ValadocApiPackage* _tmp64_;
				ValadocApiNode* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				ValadocApiPackage* _tmp68_;
				const gchar* _tmp69_;
				const gchar* _tmp70_;
				ValadocHtmlMarkupWriter* _tmp71_;
				ValadocHtmlMarkupWriter* _tmp72_;
				ValadocHtmlMarkupWriter* _tmp73_;
				ValadocMarkupWriter* _tmp74_;
				ValadocMarkupWriter* _tmp75_;
				_tmp54_ = self->writer;
				_tmp55_ = g_strdup ("class");
				_tmp56_ = self->cssresolver;
				_tmp57_ = p;
				_tmp58_ = valadoc_html_css_class_resolver_resolve (_tmp56_, (ValadocApiNode*) _tmp57_);
				_tmp59_ = g_new0 (gchar*, 2 + 1);
				_tmp59_[0] = _tmp55_;
				_tmp59_[1] = _tmp58_;
				_tmp60_ = _tmp59_;
				_tmp60__length1 = 2;
				_tmp61_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp54_, "li", _tmp60_, 2);
				_tmp62_ = _tmp61_;
				_valadoc_markup_writer_unref0 (_tmp62_);
				_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
				_tmp63_ = self->writer;
				_tmp64_ = p;
				_tmp65_ = parent;
				_tmp66_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp64_, _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = p;
				_tmp69_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = valadoc_html_markup_writer_link (_tmp63_, _tmp67_, _tmp70_, NULL);
				_tmp72_ = _tmp71_;
				_valadoc_markup_writer_unref0 (_tmp72_);
				_g_free0 (_tmp67_);
				_tmp73_ = self->writer;
				_tmp74_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp73_, "li");
				_tmp75_ = _tmp74_;
				_valadoc_markup_writer_unref0 (_tmp75_);
			}
			_g_free0 (link);
			_g_object_unref0 (p);
		}
		_vala_iterator_unref0 (_p_it);
	}
	_tmp76_ = self->writer;
	_tmp77_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp76_, "ul");
	_tmp78_ = _tmp77_;
	_valadoc_markup_writer_unref0 (_tmp78_);
	_vala_iterable_unref0 (deps);
}


void valadoc_html_basic_doclet_write_children (ValadocHtmlBasicDoclet* self, ValadocApiNode* node, ValadocApiNodeType type, const gchar* type_string, ValadocApiNode* container) {
	ValaList* children = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiNodeType _tmp1_;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (type_string != NULL);
	_tmp0_ = node;
	_tmp1_ = type;
	_tmp2_ = valadoc_api_node_get_children_by_type (_tmp0_, _tmp1_, TRUE);
	children = _tmp2_;
	_tmp3_ = children;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		ValadocHtmlMarkupWriter* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		ValadocMarkupWriter* _tmp11_;
		ValadocMarkupWriter* _tmp12_;
		const gchar* _tmp13_;
		ValadocMarkupWriter* _tmp14_;
		ValadocMarkupWriter* _tmp15_;
		ValadocMarkupWriter* _tmp16_;
		ValadocMarkupWriter* _tmp17_;
		ValadocMarkupWriter* _tmp18_;
		ValadocMarkupWriter* _tmp19_;
		ValadocHtmlMarkupWriter* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar** _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		ValadocMarkupWriter* _tmp25_;
		ValadocMarkupWriter* _tmp26_;
		ValadocHtmlMarkupWriter* _tmp135_;
		ValadocMarkupWriter* _tmp136_;
		ValadocMarkupWriter* _tmp137_;
		_tmp6_ = self->writer;
		_tmp7_ = g_strdup ("class");
		_tmp8_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
		_tmp9_ = g_new0 (gchar*, 2 + 1);
		_tmp9_[0] = _tmp7_;
		_tmp9_[1] = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp10__length1 = 2;
		_tmp11_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp6_, "h3", _tmp10_, 2);
		_tmp12_ = _tmp11_;
		_tmp13_ = type_string;
		_tmp14_ = valadoc_markup_writer_text (_tmp12_, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = valadoc_markup_writer_text (_tmp15_, ":");
		_tmp17_ = _tmp16_;
		_tmp18_ = valadoc_markup_writer_end_tag (_tmp17_, "h3");
		_tmp19_ = _tmp18_;
		_valadoc_markup_writer_unref0 (_tmp19_);
		_valadoc_markup_writer_unref0 (_tmp17_);
		_valadoc_markup_writer_unref0 (_tmp15_);
		_valadoc_markup_writer_unref0 (_tmp12_);
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_tmp20_ = self->writer;
		_tmp21_ = g_strdup ("class");
		_tmp22_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
		_tmp23_ = g_new0 (gchar*, 2 + 1);
		_tmp23_[0] = _tmp21_;
		_tmp23_[1] = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp24__length1 = 2;
		_tmp25_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp20_, "ul", _tmp24_, 2);
		_tmp26_ = _tmp25_;
		_valadoc_markup_writer_unref0 (_tmp26_);
		_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
		{
			ValaList* _child_list = NULL;
			ValaList* _tmp27_;
			ValaList* _tmp28_;
			gint _child_size = 0;
			ValaList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _child_index = 0;
			_tmp27_ = children;
			_tmp28_ = _vala_iterable_ref0 (_tmp27_);
			_child_list = _tmp28_;
			_tmp29_ = _child_list;
			_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_child_size = _tmp31_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				ValadocApiNode* child = NULL;
				ValaList* _tmp35_;
				gint _tmp36_;
				gpointer _tmp37_;
				ValadocHtmlMarkupWriter* _tmp38_;
				gchar* _tmp39_;
				ValadocHtmlCssClassResolver* _tmp40_;
				ValadocApiNode* _tmp41_;
				gchar* _tmp42_;
				gchar** _tmp43_;
				gchar** _tmp44_;
				gint _tmp44__length1;
				ValadocMarkupWriter* _tmp45_;
				ValadocMarkupWriter* _tmp46_;
				ValadocApiNode* _tmp47_;
				gboolean _tmp48_;
				ValadocHtmlMarkupWriter* _tmp132_;
				ValadocMarkupWriter* _tmp133_;
				ValadocMarkupWriter* _tmp134_;
				_tmp32_ = _child_index;
				_child_index = _tmp32_ + 1;
				_tmp33_ = _child_index;
				_tmp34_ = _child_size;
				if (!(_tmp33_ < _tmp34_)) {
					break;
				}
				_tmp35_ = _child_list;
				_tmp36_ = _child_index;
				_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
				child = (ValadocApiNode*) _tmp37_;
				_tmp38_ = self->writer;
				_tmp39_ = g_strdup ("class");
				_tmp40_ = self->cssresolver;
				_tmp41_ = child;
				_tmp42_ = valadoc_html_css_class_resolver_resolve (_tmp40_, _tmp41_);
				_tmp43_ = g_new0 (gchar*, 2 + 1);
				_tmp43_[0] = _tmp39_;
				_tmp43_[1] = _tmp42_;
				_tmp44_ = _tmp43_;
				_tmp44__length1 = 2;
				_tmp45_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp38_, "li", _tmp44_, 2);
				_tmp46_ = _tmp45_;
				_valadoc_markup_writer_unref0 (_tmp46_);
				_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
				_tmp47_ = child;
				_tmp48_ = valadoc_html_basic_doclet_is_internal_node (self, _tmp47_);
				if (_tmp48_) {
					gboolean _tmp49_ = FALSE;
					ValadocApiNode* _tmp50_;
					ValadocApiNode* _tmp84_;
					gboolean _tmp85_;
					_tmp50_ = child;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, VALADOC_API_TYPE_SYMBOL)) {
						ValadocApiNode* _tmp51_;
						gboolean _tmp52_;
						gboolean _tmp53_;
						_tmp51_ = child;
						_tmp52_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
						_tmp53_ = _tmp52_;
						_tmp49_ = _tmp53_;
					} else {
						_tmp49_ = FALSE;
					}
					if (_tmp49_) {
						ValadocHtmlMarkupWriter* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						gchar** _tmp57_;
						gchar** _tmp58_;
						gint _tmp58__length1;
						ValadocMarkupWriter* _tmp59_;
						ValadocMarkupWriter* _tmp60_;
						ValadocHtmlMarkupWriter* _tmp61_;
						ValadocApiNode* _tmp62_;
						ValadocApiNode* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
						ValadocApiNode* _tmp66_;
						const gchar* _tmp67_;
						const gchar* _tmp68_;
						ValadocHtmlMarkupWriter* _tmp69_;
						ValadocHtmlMarkupWriter* _tmp70_;
						ValadocHtmlMarkupWriter* _tmp71_;
						ValadocMarkupWriter* _tmp72_;
						ValadocMarkupWriter* _tmp73_;
						_tmp54_ = self->writer;
						_tmp55_ = g_strdup ("class");
						_tmp56_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
						_tmp57_ = g_new0 (gchar*, 2 + 1);
						_tmp57_[0] = _tmp55_;
						_tmp57_[1] = _tmp56_;
						_tmp58_ = _tmp57_;
						_tmp58__length1 = 2;
						_tmp59_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp54_, "span", _tmp58_, 2);
						_tmp60_ = _tmp59_;
						_valadoc_markup_writer_unref0 (_tmp60_);
						_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
						_tmp61_ = self->writer;
						_tmp62_ = child;
						_tmp63_ = container;
						_tmp64_ = valadoc_html_basic_doclet_get_link (self, _tmp62_, _tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = child;
						_tmp67_ = valadoc_api_node_get_name (_tmp66_);
						_tmp68_ = _tmp67_;
						_tmp69_ = valadoc_html_markup_writer_link (_tmp61_, _tmp65_, _tmp68_, NULL);
						_tmp70_ = _tmp69_;
						_valadoc_markup_writer_unref0 (_tmp70_);
						_g_free0 (_tmp65_);
						_tmp71_ = self->writer;
						_tmp72_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp71_, "span");
						_tmp73_ = _tmp72_;
						_valadoc_markup_writer_unref0 (_tmp73_);
					} else {
						ValadocHtmlMarkupWriter* _tmp74_;
						ValadocApiNode* _tmp75_;
						ValadocApiNode* _tmp76_;
						gchar* _tmp77_;
						gchar* _tmp78_;
						ValadocApiNode* _tmp79_;
						const gchar* _tmp80_;
						const gchar* _tmp81_;
						ValadocHtmlMarkupWriter* _tmp82_;
						ValadocHtmlMarkupWriter* _tmp83_;
						_tmp74_ = self->writer;
						_tmp75_ = child;
						_tmp76_ = container;
						_tmp77_ = valadoc_html_basic_doclet_get_link (self, _tmp75_, _tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = child;
						_tmp80_ = valadoc_api_node_get_name (_tmp79_);
						_tmp81_ = _tmp80_;
						_tmp82_ = valadoc_html_markup_writer_link (_tmp74_, _tmp78_, _tmp81_, NULL);
						_tmp83_ = _tmp82_;
						_valadoc_markup_writer_unref0 (_tmp83_);
						_g_free0 (_tmp78_);
					}
					_tmp84_ = child;
					_tmp85_ = valadoc_html_basic_doclet_has_brief_description (self, _tmp84_);
					if (_tmp85_) {
						ValadocHtmlMarkupWriter* _tmp86_;
						ValadocMarkupWriter* _tmp87_;
						ValadocMarkupWriter* _tmp88_;
						ValadocApiNode* _tmp89_;
						ValadocApiNode* _tmp90_;
						_tmp86_ = self->writer;
						_tmp87_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp86_, " - ");
						_tmp88_ = _tmp87_;
						_valadoc_markup_writer_unref0 (_tmp88_);
						_tmp89_ = child;
						_tmp90_ = container;
						valadoc_html_basic_doclet_write_brief_description (self, _tmp89_, _tmp90_);
					}
				} else {
					ValadocHtmlMarkupWriter* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					gchar** _tmp94_;
					gchar** _tmp95_;
					gint _tmp95__length1;
					ValadocMarkupWriter* _tmp96_;
					ValadocMarkupWriter* _tmp97_;
					gboolean _tmp98_ = FALSE;
					ValadocApiNode* _tmp99_;
					ValadocHtmlMarkupWriter* _tmp117_;
					ValadocMarkupWriter* _tmp118_;
					ValadocMarkupWriter* _tmp119_;
					ValadocHtmlMarkupWriter* _tmp120_;
					gchar* _tmp121_;
					gchar* _tmp122_;
					gchar** _tmp123_;
					gchar** _tmp124_;
					gint _tmp124__length1;
					ValadocMarkupWriter* _tmp125_;
					ValadocMarkupWriter* _tmp126_;
					ValadocApiNode* _tmp127_;
					ValadocApiNode* _tmp128_;
					ValadocHtmlMarkupWriter* _tmp129_;
					ValadocMarkupWriter* _tmp130_;
					ValadocMarkupWriter* _tmp131_;
					_tmp91_ = self->writer;
					_tmp92_ = g_strdup ("class");
					_tmp93_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_leaf_code_definition);
					_tmp94_ = g_new0 (gchar*, 2 + 1);
					_tmp94_[0] = _tmp92_;
					_tmp94_[1] = _tmp93_;
					_tmp95_ = _tmp94_;
					_tmp95__length1 = 2;
					_tmp96_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp91_, "span", _tmp95_, 2);
					_tmp97_ = _tmp96_;
					_valadoc_markup_writer_unref0 (_tmp97_);
					_tmp95_ = (_vala_array_free (_tmp95_, _tmp95__length1, (GDestroyNotify) g_free), NULL);
					_tmp99_ = child;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALADOC_API_TYPE_SYMBOL)) {
						ValadocApiNode* _tmp100_;
						gboolean _tmp101_;
						gboolean _tmp102_;
						_tmp100_ = child;
						_tmp101_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
						_tmp102_ = _tmp101_;
						_tmp98_ = _tmp102_;
					} else {
						_tmp98_ = FALSE;
					}
					if (_tmp98_) {
						ValadocHtmlMarkupWriter* _tmp103_;
						gchar* _tmp104_;
						gchar* _tmp105_;
						gchar** _tmp106_;
						gchar** _tmp107_;
						gint _tmp107__length1;
						ValadocMarkupWriter* _tmp108_;
						ValadocMarkupWriter* _tmp109_;
						ValadocApiNode* _tmp110_;
						ValadocApiNode* _tmp111_;
						ValadocHtmlMarkupWriter* _tmp112_;
						ValadocMarkupWriter* _tmp113_;
						ValadocMarkupWriter* _tmp114_;
						_tmp103_ = self->writer;
						_tmp104_ = g_strdup ("class");
						_tmp105_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
						_tmp106_ = g_new0 (gchar*, 2 + 1);
						_tmp106_[0] = _tmp104_;
						_tmp106_[1] = _tmp105_;
						_tmp107_ = _tmp106_;
						_tmp107__length1 = 2;
						_tmp108_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp103_, "span", _tmp107_, 2);
						_tmp109_ = _tmp108_;
						_valadoc_markup_writer_unref0 (_tmp109_);
						_tmp107_ = (_vala_array_free (_tmp107_, _tmp107__length1, (GDestroyNotify) g_free), NULL);
						_tmp110_ = child;
						_tmp111_ = container;
						valadoc_html_basic_doclet_write_signature (self, _tmp110_, _tmp111_);
						_tmp112_ = self->writer;
						_tmp113_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp112_, "span");
						_tmp114_ = _tmp113_;
						_valadoc_markup_writer_unref0 (_tmp114_);
					} else {
						ValadocApiNode* _tmp115_;
						ValadocApiNode* _tmp116_;
						_tmp115_ = child;
						_tmp116_ = container;
						valadoc_html_basic_doclet_write_signature (self, _tmp115_, _tmp116_);
					}
					_tmp117_ = self->writer;
					_tmp118_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp117_, "span");
					_tmp119_ = _tmp118_;
					_valadoc_markup_writer_unref0 (_tmp119_);
					_tmp120_ = self->writer;
					_tmp121_ = g_strdup ("class");
					_tmp122_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_leaf_brief_description);
					_tmp123_ = g_new0 (gchar*, 2 + 1);
					_tmp123_[0] = _tmp121_;
					_tmp123_[1] = _tmp122_;
					_tmp124_ = _tmp123_;
					_tmp124__length1 = 2;
					_tmp125_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp120_, "div", _tmp124_, 2);
					_tmp126_ = _tmp125_;
					_valadoc_markup_writer_unref0 (_tmp126_);
					_tmp124_ = (_vala_array_free (_tmp124_, _tmp124__length1, (GDestroyNotify) g_free), NULL);
					_tmp127_ = child;
					_tmp128_ = container;
					valadoc_html_basic_doclet_write_brief_description (self, _tmp127_, _tmp128_);
					_tmp129_ = self->writer;
					_tmp130_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp129_, "div");
					_tmp131_ = _tmp130_;
					_valadoc_markup_writer_unref0 (_tmp131_);
				}
				_tmp132_ = self->writer;
				_tmp133_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp132_, "li");
				_tmp134_ = _tmp133_;
				_valadoc_markup_writer_unref0 (_tmp134_);
				_g_object_unref0 (child);
			}
			_vala_iterable_unref0 (_child_list);
		}
		_tmp135_ = self->writer;
		_tmp136_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp135_, "ul");
		_tmp137_ = _tmp136_;
		_valadoc_markup_writer_unref0 (_tmp137_);
	}
	_vala_iterable_unref0 (children);
}


void valadoc_html_basic_doclet_write_image_block (ValadocHtmlBasicDoclet* self, ValadocApiNode* element) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValadocApiNode* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp2_ = element;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALADOC_API_TYPE_CLASS)) {
		_tmp1_ = TRUE;
	} else {
		ValadocApiNode* _tmp3_;
		_tmp3_ = element;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_API_TYPE_INTERFACE);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValadocApiNode* _tmp4_;
		_tmp4_ = element;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALADOC_API_TYPE_STRUCT);
	}
	if (_tmp0_) {
		const gchar* _tmp5_ = NULL;
		ValadocSettings* _tmp6_;
		gboolean _tmp7_;
		const gchar* format = NULL;
		ValadocChartsHierarchy* chart = NULL;
		ValadocChartsFactory* _tmp8_;
		ValadocApiNode* _tmp9_;
		ValadocChartsHierarchy* _tmp10_;
		ValadocChartsHierarchy* _tmp11_;
		ValadocApiNode* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		ValadocHtmlMarkupWriter* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		ValadocMarkupWriter* _tmp22_;
		ValadocMarkupWriter* _tmp23_;
		ValadocMarkupWriter* _tmp24_;
		ValadocMarkupWriter* _tmp25_;
		ValadocMarkupWriter* _tmp26_;
		ValadocMarkupWriter* _tmp27_;
		ValadocHtmlMarkupWriter* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		ValadocApiNode* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		ValadocApiNode* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		ValadocApiNode* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar** _tmp45_;
		gchar** _tmp46_;
		gint _tmp46__length1;
		ValadocMarkupWriter* _tmp47_;
		ValadocMarkupWriter* _tmp48_;
		ValadocHtmlMarkupWriter* _tmp49_;
		ValadocChartsHierarchy* _tmp50_;
		ValadocHtmlMarkupWriter* _tmp51_;
		ValadocHtmlMarkupWriter* _tmp52_;
		_tmp6_ = self->priv->_settings;
		_tmp7_ = _tmp6_->use_svg_images;
		if (_tmp7_) {
			_tmp5_ = "svg";
		} else {
			_tmp5_ = "png";
		}
		format = _tmp5_;
		_tmp8_ = self->image_factory;
		_tmp9_ = element;
		_tmp10_ = valadoc_charts_hierarchy_new (_tmp8_, _tmp9_);
		chart = _tmp10_;
		_tmp11_ = chart;
		_tmp12_ = element;
		_tmp13_ = format;
		_tmp14_ = valadoc_html_basic_doclet_get_img_path (self, _tmp12_, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = format;
		valadoc_charts_chart_save ((ValadocChartsChart*) _tmp11_, _tmp15_, _tmp16_);
		_g_free0 (_tmp15_);
		_tmp17_ = self->writer;
		_tmp18_ = g_strdup ("class");
		_tmp19_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
		_tmp20_ = g_new0 (gchar*, 2 + 1);
		_tmp20_[0] = _tmp18_;
		_tmp20_[1] = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp21__length1 = 2;
		_tmp22_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp17_, "h2", _tmp21_, 2);
		_tmp23_ = _tmp22_;
		_tmp24_ = valadoc_markup_writer_text (_tmp23_, "Object Hierarchy:");
		_tmp25_ = _tmp24_;
		_tmp26_ = valadoc_markup_writer_end_tag (_tmp25_, "h2");
		_tmp27_ = _tmp26_;
		_valadoc_markup_writer_unref0 (_tmp27_);
		_valadoc_markup_writer_unref0 (_tmp25_);
		_valadoc_markup_writer_unref0 (_tmp23_);
		_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
		_tmp28_ = self->writer;
		_tmp29_ = g_strdup ("class");
		_tmp30_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_diagram);
		_tmp31_ = g_strdup ("usemap");
		_tmp32_ = element;
		_tmp33_ = valadoc_api_node_get_full_name (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat ("#", _tmp34_, NULL);
		_tmp36_ = g_strdup ("alt");
		_tmp37_ = element;
		_tmp38_ = valadoc_api_node_get_name (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strdup_printf ("Object hierarchy for %s", _tmp39_);
		_tmp41_ = g_strdup ("src");
		_tmp42_ = element;
		_tmp43_ = format;
		_tmp44_ = valadoc_html_basic_doclet_get_img_path_html (self, _tmp42_, _tmp43_);
		_tmp45_ = g_new0 (gchar*, 8 + 1);
		_tmp45_[0] = _tmp29_;
		_tmp45_[1] = _tmp30_;
		_tmp45_[2] = _tmp31_;
		_tmp45_[3] = _tmp35_;
		_tmp45_[4] = _tmp36_;
		_tmp45_[5] = _tmp40_;
		_tmp45_[6] = _tmp41_;
		_tmp45_[7] = _tmp44_;
		_tmp46_ = _tmp45_;
		_tmp46__length1 = 8;
		_tmp47_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp28_, "img", _tmp46_, 8);
		_tmp48_ = _tmp47_;
		_valadoc_markup_writer_unref0 (_tmp48_);
		_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp34_);
		_tmp49_ = self->writer;
		_tmp50_ = chart;
		_tmp51_ = valadoc_html_markup_writer_add_usemap (_tmp49_, (ValadocChartsChart*) _tmp50_);
		_tmp52_ = _tmp51_;
		_valadoc_markup_writer_unref0 (_tmp52_);
		_g_object_unref0 (chart);
	}
}


void valadoc_html_basic_doclet_write_namespace_content (ValadocHtmlBasicDoclet* self, ValadocApiNamespace* node, ValadocApiNode* parent) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	gchar* _tmp7_ = NULL;
	ValadocApiNamespace* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	ValadocHtmlMarkupWriter* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	ValadocMarkupWriter* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	ValadocHtmlMarkupWriter* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	ValadocMarkupWriter* _tmp30_;
	ValadocMarkupWriter* _tmp31_;
	ValadocHtmlMarkupWriter* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar** _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	ValadocMarkupWriter* _tmp37_;
	ValadocMarkupWriter* _tmp38_;
	ValadocMarkupWriter* _tmp39_;
	ValadocMarkupWriter* _tmp40_;
	ValadocMarkupWriter* _tmp41_;
	ValadocMarkupWriter* _tmp42_;
	ValadocApiNamespace* _tmp43_;
	ValadocApiNode* _tmp44_;
	ValadocHtmlMarkupWriter* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	ValadocMarkupWriter* _tmp50_;
	ValadocMarkupWriter* _tmp51_;
	ValadocMarkupWriter* _tmp52_;
	ValadocMarkupWriter* _tmp53_;
	ValadocMarkupWriter* _tmp54_;
	ValadocMarkupWriter* _tmp55_;
	ValadocApiNamespace* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	ValadocApiNamespace* _tmp65_;
	ValadocApiNode* _tmp66_;
	ValadocApiNamespace* _tmp67_;
	ValadocApiNode* _tmp68_;
	ValadocApiNamespace* _tmp69_;
	ValadocApiNode* _tmp70_;
	ValadocApiNamespace* _tmp71_;
	ValadocApiNode* _tmp72_;
	ValadocApiNamespace* _tmp73_;
	ValadocApiNode* _tmp74_;
	ValadocApiNamespace* _tmp75_;
	ValadocApiNode* _tmp76_;
	ValadocApiNamespace* _tmp77_;
	ValadocApiNode* _tmp78_;
	ValadocApiNamespace* _tmp79_;
	ValadocApiNode* _tmp80_;
	ValadocApiNamespace* _tmp81_;
	ValadocApiNode* _tmp82_;
	ValadocHtmlMarkupWriter* _tmp83_;
	ValadocMarkupWriter* _tmp84_;
	ValadocMarkupWriter* _tmp85_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp8_ = node;
	_tmp9_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == NULL) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("Global Namespace");
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp11_;
	} else {
		ValadocApiNamespace* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = node;
		_tmp13_ = valadoc_api_node_get_full_name ((ValadocApiNode*) _tmp12_);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp13_;
	}
	_tmp14_ = self->writer;
	_tmp15_ = g_strdup ("class");
	_tmp16_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp17_ = g_new0 (gchar*, 2 + 1);
	_tmp17_[0] = _tmp15_;
	_tmp17_[1] = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 2;
	_tmp19_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp14_, "h1", _tmp18_, 2);
	_tmp20_ = _tmp19_;
	_tmp21_ = valadoc_markup_writer_text (_tmp20_, _tmp7_);
	_tmp22_ = _tmp21_;
	_tmp23_ = valadoc_markup_writer_end_tag (_tmp22_, "h1");
	_tmp24_ = _tmp23_;
	_valadoc_markup_writer_unref0 (_tmp24_);
	_valadoc_markup_writer_unref0 (_tmp22_);
	_valadoc_markup_writer_unref0 (_tmp20_);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = self->writer;
	_tmp26_ = g_strdup ("class");
	_tmp27_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_hr);
	_tmp28_ = g_new0 (gchar*, 2 + 1);
	_tmp28_[0] = _tmp26_;
	_tmp28_[1] = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp29__length1 = 2;
	_tmp30_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp25_, "hr", _tmp29_, 2);
	_tmp31_ = _tmp30_;
	_valadoc_markup_writer_unref0 (_tmp31_);
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = self->writer;
	_tmp33_ = g_strdup ("class");
	_tmp34_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp35_ = g_new0 (gchar*, 2 + 1);
	_tmp35_[0] = _tmp33_;
	_tmp35_[1] = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp36__length1 = 2;
	_tmp37_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp32_, "h2", _tmp36_, 2);
	_tmp38_ = _tmp37_;
	_tmp39_ = valadoc_markup_writer_text (_tmp38_, "Description:");
	_tmp40_ = _tmp39_;
	_tmp41_ = valadoc_markup_writer_end_tag (_tmp40_, "h2");
	_tmp42_ = _tmp41_;
	_valadoc_markup_writer_unref0 (_tmp42_);
	_valadoc_markup_writer_unref0 (_tmp40_);
	_valadoc_markup_writer_unref0 (_tmp38_);
	_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
	_tmp43_ = node;
	_tmp44_ = parent;
	valadoc_html_basic_doclet_write_documentation (self, (ValadocApiNode*) _tmp43_, _tmp44_);
	_tmp45_ = self->writer;
	_tmp46_ = g_strdup ("class");
	_tmp47_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp48_ = g_new0 (gchar*, 2 + 1);
	_tmp48_[0] = _tmp46_;
	_tmp48_[1] = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp49__length1 = 2;
	_tmp50_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp45_, "h2", _tmp49_, 2);
	_tmp51_ = _tmp50_;
	_tmp52_ = valadoc_markup_writer_text (_tmp51_, "Content:");
	_tmp53_ = _tmp52_;
	_tmp54_ = valadoc_markup_writer_end_tag (_tmp53_, "h2");
	_tmp55_ = _tmp54_;
	_valadoc_markup_writer_unref0 (_tmp55_);
	_valadoc_markup_writer_unref0 (_tmp53_);
	_valadoc_markup_writer_unref0 (_tmp51_);
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
	_tmp56_ = node;
	_tmp57_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp56_);
	_tmp58_ = _tmp57_;
	if (_tmp58_ == NULL) {
		ValadocApiNamespace* _tmp59_;
		ValadocApiItem* _tmp60_;
		ValadocApiItem* _tmp61_;
		ValadocApiNode* _tmp62_;
		_tmp59_ = node;
		_tmp60_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = parent;
		valadoc_html_basic_doclet_write_child_namespaces (self, (ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage), _tmp62_);
	} else {
		ValadocApiNamespace* _tmp63_;
		ValadocApiNode* _tmp64_;
		_tmp63_ = node;
		_tmp64_ = parent;
		valadoc_html_basic_doclet_write_child_namespaces (self, (ValadocApiNode*) _tmp63_, _tmp64_);
	}
	_tmp65_ = node;
	_tmp66_ = parent;
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp65_, VALADOC_API_NODE_TYPE_INTERFACE, "Interfaces", _tmp66_);
	_tmp67_ = node;
	_tmp68_ = parent;
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp67_, VALADOC_API_NODE_TYPE_CLASS, "Classes", _tmp68_);
	_tmp69_ = node;
	_tmp70_ = parent;
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp69_, VALADOC_API_NODE_TYPE_STRUCT, "Structs", _tmp70_);
	_tmp71_ = node;
	_tmp72_ = parent;
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp71_, VALADOC_API_NODE_TYPE_ENUM, "Enums", _tmp72_);
	_tmp73_ = node;
	_tmp74_ = parent;
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp73_, VALADOC_API_NODE_TYPE_ERROR_DOMAIN, "Error domains", _tmp74_);
	_tmp75_ = node;
	_tmp76_ = parent;
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp75_, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", _tmp76_);
	_tmp77_ = node;
	_tmp78_ = parent;
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp77_, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", _tmp78_);
	_tmp79_ = node;
	_tmp80_ = parent;
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp79_, VALADOC_API_NODE_TYPE_METHOD, "Functions", _tmp80_);
	_tmp81_ = node;
	_tmp82_ = parent;
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp81_, VALADOC_API_NODE_TYPE_FIELD, "Fields", _tmp82_);
	_tmp83_ = self->writer;
	_tmp84_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp83_, "div");
	_tmp85_ = _tmp84_;
	_valadoc_markup_writer_unref0 (_tmp85_);
	_g_free0 (_tmp7_);
}


void valadoc_html_basic_doclet_write_package_content (ValadocHtmlBasicDoclet* self, ValadocApiPackage* node, ValadocApiNode* parent) {
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValadocApiPackage* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocApiPackage* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	ValadocMarkupWriter* _tmp25_;
	ValadocHtmlMarkupWriter* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	ValadocMarkupWriter* _tmp31_;
	ValadocMarkupWriter* _tmp32_;
	ValadocHtmlMarkupWriter* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	ValadocMarkupWriter* _tmp38_;
	ValadocMarkupWriter* _tmp39_;
	ValadocMarkupWriter* _tmp40_;
	ValadocMarkupWriter* _tmp41_;
	ValadocMarkupWriter* _tmp42_;
	ValadocMarkupWriter* _tmp43_;
	ValadocWikiPage* _tmp44_ = NULL;
	ValadocApiTree* _tmp45_;
	ValadocWikiPageTree* _tmp46_;
	ValadocWikiPageTree* _tmp47_;
	ValadocWikiPage* wikipage = NULL;
	ValadocWikiPage* _tmp53_;
	ValadocWikiPage* _tmp54_;
	ValadocHtmlMarkupWriter* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar** _tmp64_;
	gchar** _tmp65_;
	gint _tmp65__length1;
	ValadocMarkupWriter* _tmp66_;
	ValadocMarkupWriter* _tmp67_;
	ValadocMarkupWriter* _tmp68_;
	ValadocMarkupWriter* _tmp69_;
	ValadocMarkupWriter* _tmp70_;
	ValadocMarkupWriter* _tmp71_;
	ValadocApiPackage* _tmp72_;
	ValadocApiNode* _tmp73_;
	ValadocApiPackage* _tmp106_;
	ValadocApiNode* _tmp107_;
	ValadocHtmlMarkupWriter* _tmp108_;
	ValadocMarkupWriter* _tmp109_;
	ValadocMarkupWriter* _tmp110_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp10_ = g_strdup ("id");
	_tmp11_ = node;
	_tmp12_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup (_tmp13_);
	_tmp15_ = g_new0 (gchar*, 4 + 1);
	_tmp15_[0] = _tmp8_;
	_tmp15_[1] = _tmp9_;
	_tmp15_[2] = _tmp10_;
	_tmp15_[3] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 4;
	_tmp17_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "h1", _tmp16_, 4);
	_tmp18_ = _tmp17_;
	_tmp19_ = node;
	_tmp20_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = valadoc_markup_writer_text (_tmp18_, _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = valadoc_markup_writer_end_tag (_tmp23_, "h1");
	_tmp25_ = _tmp24_;
	_valadoc_markup_writer_unref0 (_tmp25_);
	_valadoc_markup_writer_unref0 (_tmp23_);
	_valadoc_markup_writer_unref0 (_tmp18_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = self->writer;
	_tmp27_ = g_strdup ("class");
	_tmp28_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_headline_hr);
	_tmp29_ = g_new0 (gchar*, 2 + 1);
	_tmp29_[0] = _tmp27_;
	_tmp29_[1] = _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = 2;
	_tmp31_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp26_, "hr", _tmp30_, 2);
	_tmp32_ = _tmp31_;
	_valadoc_markup_writer_unref0 (_tmp32_);
	_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
	_tmp33_ = self->writer;
	_tmp34_ = g_strdup ("class");
	_tmp35_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp36_ = g_new0 (gchar*, 2 + 1);
	_tmp36_[0] = _tmp34_;
	_tmp36_[1] = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 2;
	_tmp38_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp33_, "h2", _tmp37_, 2);
	_tmp39_ = _tmp38_;
	_tmp40_ = valadoc_markup_writer_text (_tmp39_, "Description:");
	_tmp41_ = _tmp40_;
	_tmp42_ = valadoc_markup_writer_end_tag (_tmp41_, "h2");
	_tmp43_ = _tmp42_;
	_valadoc_markup_writer_unref0 (_tmp43_);
	_valadoc_markup_writer_unref0 (_tmp41_);
	_valadoc_markup_writer_unref0 (_tmp39_);
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	_tmp45_ = self->tree;
	_tmp46_ = valadoc_api_tree_get_wikitree (_tmp45_);
	_tmp47_ = _tmp46_;
	if (_tmp47_ == NULL) {
		_g_object_unref0 (_tmp44_);
		_tmp44_ = NULL;
	} else {
		ValadocApiTree* _tmp48_;
		ValadocWikiPageTree* _tmp49_;
		ValadocWikiPageTree* _tmp50_;
		const gchar* _tmp51_;
		ValadocWikiPage* _tmp52_;
		_tmp48_ = self->tree;
		_tmp49_ = valadoc_api_tree_get_wikitree (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = self->priv->_wiki_index_name;
		_tmp52_ = valadoc_wiki_page_tree_search (_tmp50_, _tmp51_);
		_g_object_unref0 (_tmp44_);
		_tmp44_ = _tmp52_;
	}
	_tmp53_ = _g_object_ref0 (_tmp44_);
	wikipage = _tmp53_;
	_tmp54_ = wikipage;
	if (_tmp54_ != NULL) {
		ValadocHtmlHtmlRenderer* _tmp55_;
		ValadocApiNode* _tmp56_;
		ValadocHtmlHtmlRenderer* _tmp57_;
		ValadocWikiPage* _tmp58_;
		ValadocContentPage* _tmp59_;
		ValadocContentPage* _tmp60_;
		_tmp55_ = self->_renderer;
		_tmp56_ = parent;
		valadoc_html_html_renderer_set_container (_tmp55_, (ValadocDocumentation*) _tmp56_);
		_tmp57_ = self->_renderer;
		_tmp58_ = wikipage;
		_tmp59_ = valadoc_wiki_page_get_documentation (_tmp58_);
		_tmp60_ = _tmp59_;
		valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp57_, (ValadocContentContentElement*) _tmp60_);
	}
	_tmp61_ = self->writer;
	_tmp62_ = g_strdup ("class");
	_tmp63_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp64_ = g_new0 (gchar*, 2 + 1);
	_tmp64_[0] = _tmp62_;
	_tmp64_[1] = _tmp63_;
	_tmp65_ = _tmp64_;
	_tmp65__length1 = 2;
	_tmp66_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp61_, "h2", _tmp65_, 2);
	_tmp67_ = _tmp66_;
	_tmp68_ = valadoc_markup_writer_text (_tmp67_, "Content:");
	_tmp69_ = _tmp68_;
	_tmp70_ = valadoc_markup_writer_end_tag (_tmp69_, "h2");
	_tmp71_ = _tmp70_;
	_valadoc_markup_writer_unref0 (_tmp71_);
	_valadoc_markup_writer_unref0 (_tmp69_);
	_valadoc_markup_writer_unref0 (_tmp67_);
	_tmp65_ = (_vala_array_free (_tmp65_, _tmp65__length1, (GDestroyNotify) g_free), NULL);
	_tmp72_ = node;
	_tmp73_ = parent;
	valadoc_html_basic_doclet_write_child_namespaces (self, (ValadocApiNode*) _tmp72_, _tmp73_);
	{
		ValaList* _child_list = NULL;
		ValadocApiPackage* _tmp74_;
		ValaList* _tmp75_;
		gint _child_size = 0;
		ValaList* _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		gint _child_index = 0;
		_tmp74_ = node;
		_tmp75_ = valadoc_api_node_get_children_by_type ((ValadocApiNode*) _tmp74_, VALADOC_API_NODE_TYPE_NAMESPACE, TRUE);
		_child_list = _tmp75_;
		_tmp76_ = _child_list;
		_tmp77_ = vala_collection_get_size ((ValaCollection*) _tmp76_);
		_tmp78_ = _tmp77_;
		_child_size = _tmp78_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			ValadocApiNode* child = NULL;
			ValaList* _tmp82_;
			gint _tmp83_;
			gpointer _tmp84_;
			ValadocApiNode* _tmp85_;
			const gchar* _tmp86_;
			const gchar* _tmp87_;
			_tmp79_ = _child_index;
			_child_index = _tmp79_ + 1;
			_tmp80_ = _child_index;
			_tmp81_ = _child_size;
			if (!(_tmp80_ < _tmp81_)) {
				break;
			}
			_tmp82_ = _child_list;
			_tmp83_ = _child_index;
			_tmp84_ = vala_list_get (_tmp82_, _tmp83_);
			child = (ValadocApiNode*) _tmp84_;
			_tmp85_ = child;
			_tmp86_ = valadoc_api_node_get_name (_tmp85_);
			_tmp87_ = _tmp86_;
			if (_tmp87_ == NULL) {
				ValadocApiNode* _tmp88_;
				ValadocApiNode* _tmp89_;
				ValadocApiNode* _tmp90_;
				ValadocApiNode* _tmp91_;
				ValadocApiNode* _tmp92_;
				ValadocApiNode* _tmp93_;
				ValadocApiNode* _tmp94_;
				ValadocApiNode* _tmp95_;
				ValadocApiNode* _tmp96_;
				ValadocApiNode* _tmp97_;
				ValadocApiNode* _tmp98_;
				ValadocApiNode* _tmp99_;
				ValadocApiNode* _tmp100_;
				ValadocApiNode* _tmp101_;
				ValadocApiNode* _tmp102_;
				ValadocApiNode* _tmp103_;
				ValadocApiNode* _tmp104_;
				ValadocApiNode* _tmp105_;
				_tmp88_ = child;
				_tmp89_ = parent;
				valadoc_html_basic_doclet_write_children (self, _tmp88_, VALADOC_API_NODE_TYPE_INTERFACE, "Interfaces", _tmp89_);
				_tmp90_ = child;
				_tmp91_ = parent;
				valadoc_html_basic_doclet_write_children (self, _tmp90_, VALADOC_API_NODE_TYPE_CLASS, "Classes", _tmp91_);
				_tmp92_ = child;
				_tmp93_ = parent;
				valadoc_html_basic_doclet_write_children (self, _tmp92_, VALADOC_API_NODE_TYPE_STRUCT, "Structs", _tmp93_);
				_tmp94_ = child;
				_tmp95_ = parent;
				valadoc_html_basic_doclet_write_children (self, _tmp94_, VALADOC_API_NODE_TYPE_ENUM, "Enums", _tmp95_);
				_tmp96_ = child;
				_tmp97_ = parent;
				valadoc_html_basic_doclet_write_children (self, _tmp96_, VALADOC_API_NODE_TYPE_ERROR_DOMAIN, "Error domains", _tmp97_);
				_tmp98_ = child;
				_tmp99_ = parent;
				valadoc_html_basic_doclet_write_children (self, _tmp98_, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", _tmp99_);
				_tmp100_ = child;
				_tmp101_ = parent;
				valadoc_html_basic_doclet_write_children (self, _tmp100_, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", _tmp101_);
				_tmp102_ = child;
				_tmp103_ = parent;
				valadoc_html_basic_doclet_write_children (self, _tmp102_, VALADOC_API_NODE_TYPE_METHOD, "Functions", _tmp103_);
				_tmp104_ = child;
				_tmp105_ = parent;
				valadoc_html_basic_doclet_write_children (self, _tmp104_, VALADOC_API_NODE_TYPE_FIELD, "Fields", _tmp105_);
			}
			_g_object_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	_tmp106_ = node;
	_tmp107_ = parent;
	valadoc_html_basic_doclet_write_child_dependencies (self, _tmp106_, _tmp107_);
	_tmp108_ = self->writer;
	_tmp109_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp108_, "div");
	_tmp110_ = _tmp109_;
	_valadoc_markup_writer_unref0 (_tmp110_);
	_g_object_unref0 (wikipage);
	_g_object_unref0 (_tmp44_);
}


void valadoc_html_basic_doclet_write_file_header (ValadocHtmlBasicDoclet* self, const gchar* css, const gchar* js, const gchar* title) {
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocHtmlMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	ValadocHtmlMarkupWriter* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValadocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	const gchar* _tmp13_;
	ValadocHtmlMarkupWriter* _tmp31_;
	const gchar* _tmp32_;
	ValadocHtmlMarkupWriter* _tmp33_;
	ValadocHtmlMarkupWriter* _tmp34_;
	ValadocHtmlMarkupWriter* _tmp35_;
	const gchar* _tmp36_;
	ValadocHtmlMarkupWriter* _tmp37_;
	ValadocHtmlMarkupWriter* _tmp38_;
	ValadocHtmlMarkupWriter* _tmp39_;
	ValadocMarkupWriter* _tmp40_;
	ValadocMarkupWriter* _tmp41_;
	ValadocHtmlMarkupWriter* _tmp42_;
	ValadocMarkupWriter* _tmp43_;
	ValadocMarkupWriter* _tmp44_;
	ValadocHtmlMarkupWriter* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	ValadocMarkupWriter* _tmp50_;
	ValadocMarkupWriter* _tmp51_;
	const gchar* _tmp52_ = NULL;
	const gchar* _tmp53_;
	ValadocHtmlMarkupWriter* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	ValadocMarkupWriter* _tmp58_;
	ValadocMarkupWriter* _tmp59_;
	ValadocHtmlMarkupWriter* _tmp60_;
	ValadocMarkupWriter* _tmp61_;
	ValadocMarkupWriter* _tmp62_;
	ValadocHtmlMarkupWriter* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar** _tmp66_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	ValadocMarkupWriter* _tmp68_;
	ValadocMarkupWriter* _tmp69_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (css != NULL);
	g_return_if_fail (js != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "html", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = self->writer;
	_tmp4_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp3_, "head", NULL, 0);
	_tmp5_ = _tmp4_;
	_valadoc_markup_writer_unref0 (_tmp5_);
	_tmp6_ = self->writer;
	_tmp7_ = g_strdup ("charset");
	_tmp8_ = g_strdup ("UTF-8");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp6_, "meta", _tmp10_, 2);
	_tmp12_ = _tmp11_;
	_valadoc_markup_writer_unref0 (_tmp12_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = title;
	if (_tmp13_ == NULL) {
		ValadocHtmlMarkupWriter* _tmp14_;
		ValadocMarkupWriter* _tmp15_;
		ValadocMarkupWriter* _tmp16_;
		ValadocMarkupWriter* _tmp17_;
		ValadocMarkupWriter* _tmp18_;
		ValadocMarkupWriter* _tmp19_;
		ValadocMarkupWriter* _tmp20_;
		_tmp14_ = self->writer;
		_tmp15_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp14_, "title", NULL, 0);
		_tmp16_ = _tmp15_;
		_tmp17_ = valadoc_markup_writer_text (_tmp16_, "Vala Binding Reference");
		_tmp18_ = _tmp17_;
		_tmp19_ = valadoc_markup_writer_end_tag (_tmp18_, "title");
		_tmp20_ = _tmp19_;
		_valadoc_markup_writer_unref0 (_tmp20_);
		_valadoc_markup_writer_unref0 (_tmp18_);
		_valadoc_markup_writer_unref0 (_tmp16_);
	} else {
		ValadocHtmlMarkupWriter* _tmp21_;
		ValadocMarkupWriter* _tmp22_;
		ValadocMarkupWriter* _tmp23_;
		const gchar* _tmp24_;
		ValadocMarkupWriter* _tmp25_;
		ValadocMarkupWriter* _tmp26_;
		ValadocMarkupWriter* _tmp27_;
		ValadocMarkupWriter* _tmp28_;
		ValadocMarkupWriter* _tmp29_;
		ValadocMarkupWriter* _tmp30_;
		_tmp21_ = self->writer;
		_tmp22_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp21_, "title", NULL, 0);
		_tmp23_ = _tmp22_;
		_tmp24_ = title;
		_tmp25_ = valadoc_markup_writer_text (_tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = valadoc_markup_writer_text (_tmp26_, " &ndash; Vala Binding Reference");
		_tmp28_ = _tmp27_;
		_tmp29_ = valadoc_markup_writer_end_tag (_tmp28_, "title");
		_tmp30_ = _tmp29_;
		_valadoc_markup_writer_unref0 (_tmp30_);
		_valadoc_markup_writer_unref0 (_tmp28_);
		_valadoc_markup_writer_unref0 (_tmp26_);
		_valadoc_markup_writer_unref0 (_tmp23_);
	}
	_tmp31_ = self->writer;
	_tmp32_ = css;
	_tmp33_ = valadoc_html_markup_writer_stylesheet_link (_tmp31_, _tmp32_);
	_tmp34_ = _tmp33_;
	_valadoc_markup_writer_unref0 (_tmp34_);
	_tmp35_ = self->writer;
	_tmp36_ = js;
	_tmp37_ = valadoc_html_markup_writer_javascript_link (_tmp35_, _tmp36_);
	_tmp38_ = _tmp37_;
	_valadoc_markup_writer_unref0 (_tmp38_);
	_tmp39_ = self->writer;
	_tmp40_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp39_, "head");
	_tmp41_ = _tmp40_;
	_valadoc_markup_writer_unref0 (_tmp41_);
	_tmp42_ = self->writer;
	_tmp43_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp42_, "body", NULL, 0);
	_tmp44_ = _tmp43_;
	_valadoc_markup_writer_unref0 (_tmp44_);
	_tmp45_ = self->writer;
	_tmp46_ = g_strdup ("class");
	_tmp47_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_site_header);
	_tmp48_ = g_new0 (gchar*, 2 + 1);
	_tmp48_[0] = _tmp46_;
	_tmp48_[1] = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp49__length1 = 2;
	_tmp50_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp45_, "div", _tmp49_, 2);
	_tmp51_ = _tmp50_;
	_valadoc_markup_writer_unref0 (_tmp51_);
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = title;
	if (_tmp53_ == NULL) {
		_tmp52_ = "";
	} else {
		const gchar* _tmp54_;
		_tmp54_ = title;
		_tmp52_ = _tmp54_;
	}
	_tmp55_ = self->writer;
	_tmp56_ = g_strdup_printf ("%s Reference Manual", _tmp52_);
	_tmp57_ = _tmp56_;
	_tmp58_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp55_, _tmp57_);
	_tmp59_ = _tmp58_;
	_valadoc_markup_writer_unref0 (_tmp59_);
	_g_free0 (_tmp57_);
	_tmp60_ = self->writer;
	_tmp61_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp60_, "div");
	_tmp62_ = _tmp61_;
	_valadoc_markup_writer_unref0 (_tmp62_);
	_tmp63_ = self->writer;
	_tmp64_ = g_strdup ("class");
	_tmp65_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_body);
	_tmp66_ = g_new0 (gchar*, 2 + 1);
	_tmp66_[0] = _tmp64_;
	_tmp66_[1] = _tmp65_;
	_tmp67_ = _tmp66_;
	_tmp67__length1 = 2;
	_tmp68_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp63_, "div", _tmp67_, 2);
	_tmp69_ = _tmp68_;
	_valadoc_markup_writer_unref0 (_tmp69_);
	_tmp67_ = (_vala_array_free (_tmp67_, _tmp67__length1, (GDestroyNotify) g_free), NULL);
}


void valadoc_html_basic_doclet_write_file_footer (ValadocHtmlBasicDoclet* self) {
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocHtmlMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	ValadocHtmlMarkupWriter* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValadocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocHtmlMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	ValadocHtmlMarkupWriter* _tmp16_;
	ValadocHtmlMarkupWriter* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	ValadocHtmlMarkupWriter* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	ValadocHtmlMarkupWriter* _tmp22_;
	ValadocMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	ValadocHtmlMarkupWriter* _tmp25_;
	ValadocMarkupWriter* _tmp26_;
	ValadocMarkupWriter* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp0_, "div");
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = self->writer;
	_tmp4_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp3_, "br", NULL, 0);
	_tmp5_ = _tmp4_;
	_valadoc_markup_writer_unref0 (_tmp5_);
	_tmp6_ = self->writer;
	_tmp7_ = g_strdup ("class");
	_tmp8_ = g_strdup ("site_footer");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp6_, "div", _tmp10_, 2);
	_tmp12_ = _tmp11_;
	_valadoc_markup_writer_unref0 (_tmp12_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = self->writer;
	_tmp14_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp13_, "Generated by ");
	_tmp15_ = _tmp14_;
	_valadoc_markup_writer_unref0 (_tmp15_);
	_tmp16_ = self->writer;
	_tmp17_ = valadoc_html_markup_writer_link (_tmp16_, "http://www.valadoc.org/", "Valadoc", NULL);
	_tmp18_ = _tmp17_;
	_valadoc_markup_writer_unref0 (_tmp18_);
	_tmp19_ = self->writer;
	_tmp20_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp19_, "div");
	_tmp21_ = _tmp20_;
	_valadoc_markup_writer_unref0 (_tmp21_);
	_tmp22_ = self->writer;
	_tmp23_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp22_, "body");
	_tmp24_ = _tmp23_;
	_valadoc_markup_writer_unref0 (_tmp24_);
	_tmp25_ = self->writer;
	_tmp26_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp25_, "html");
	_tmp27_ = _tmp26_;
	_valadoc_markup_writer_unref0 (_tmp27_);
}


ValadocHtmlBasicDoclet* valadoc_html_basic_doclet_construct (GType object_type) {
	ValadocHtmlBasicDoclet * self = NULL;
	self = (ValadocHtmlBasicDoclet*) valadoc_api_visitor_construct (object_type);
	return self;
}


ValadocHtmlLinkHelper* valadoc_html_basic_doclet_get_linker (ValadocHtmlBasicDoclet* self) {
	ValadocHtmlLinkHelper* result;
	ValadocHtmlLinkHelper* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_linker;
	result = _tmp0_;
	return result;
}


void valadoc_html_basic_doclet_set_linker (ValadocHtmlBasicDoclet* self, ValadocHtmlLinkHelper* value) {
	g_return_if_fail (self != NULL);
	if (valadoc_html_basic_doclet_get_linker (self) != value) {
		ValadocHtmlLinkHelper* _tmp0_;
		ValadocHtmlLinkHelper* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_linker);
		self->priv->_linker = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_LINKER]);
	}
}


ValadocSettings* valadoc_html_basic_doclet_get_settings (ValadocHtmlBasicDoclet* self) {
	ValadocSettings* result;
	ValadocSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}


void valadoc_html_basic_doclet_set_settings (ValadocHtmlBasicDoclet* self, ValadocSettings* value) {
	g_return_if_fail (self != NULL);
	if (valadoc_html_basic_doclet_get_settings (self) != value) {
		ValadocSettings* _tmp0_;
		ValadocSettings* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_SETTINGS]);
	}
}


const gchar* valadoc_html_basic_doclet_get_wiki_index_name (ValadocHtmlBasicDoclet* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wiki_index_name;
	result = _tmp0_;
	return result;
}


void valadoc_html_basic_doclet_set_wiki_index_name (ValadocHtmlBasicDoclet* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_html_basic_doclet_get_wiki_index_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_wiki_index_name);
		self->priv->_wiki_index_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME]);
	}
}


static void valadoc_html_basic_doclet_class_init (ValadocHtmlBasicDocletClass * klass) {
	ValadocApiNodeType* _tmp0_;
	valadoc_html_basic_doclet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocHtmlBasicDocletPrivate));
	((ValadocHtmlBasicDocletClass *) klass)->process = (void (*) (ValadocHtmlBasicDoclet *, ValadocSettings*, ValadocApiTree*, ValadocErrorReporter*)) valadoc_html_basic_doclet_real_process;
	((ValadocHtmlBasicDocletClass *) klass)->get_img_path_html = (gchar* (*) (ValadocHtmlBasicDoclet *, ValadocApiNode*, const gchar*)) valadoc_html_basic_doclet_real_get_img_path_html;
	((ValadocHtmlBasicDocletClass *) klass)->get_img_path = (gchar* (*) (ValadocHtmlBasicDoclet *, ValadocApiNode*, const gchar*)) valadoc_html_basic_doclet_real_get_img_path;
	((ValadocHtmlBasicDocletClass *) klass)->get_icon_directory = (gchar* (*) (ValadocHtmlBasicDoclet *)) valadoc_html_basic_doclet_real_get_icon_directory;
	((ValadocHtmlBasicDocletClass *) klass)->write_wiki_page = (void (*) (ValadocHtmlBasicDoclet *, ValadocWikiPage*, const gchar*, const gchar*, const gchar*, const gchar*)) valadoc_html_basic_doclet_real_write_wiki_page;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_html_basic_doclet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_html_basic_doclet_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_html_basic_doclet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_BASIC_DOCLET_LINKER, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_LINKER] = g_param_spec_object ("linker", "linker", "linker", VALADOC_HTML_TYPE_LINK_HELPER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_BASIC_DOCLET_SETTINGS, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_SETTINGS] = g_param_spec_object ("settings", "settings", "settings", VALADOC_TYPE_SETTINGS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME] = g_param_spec_string ("wiki-index-name", "wiki-index-name", "wiki-index-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_new0 (ValadocApiNodeType, 7);
	_tmp0_[0] = VALADOC_API_NODE_TYPE_CONSTANT;
	_tmp0_[1] = VALADOC_API_NODE_TYPE_PROPERTY;
	_tmp0_[2] = VALADOC_API_NODE_TYPE_DELEGATE;
	_tmp0_[3] = VALADOC_API_NODE_TYPE_STATIC_METHOD;
	_tmp0_[4] = VALADOC_API_NODE_TYPE_METHOD;
	_tmp0_[5] = VALADOC_API_NODE_TYPE_SIGNAL;
	_tmp0_[6] = VALADOC_API_NODE_TYPE_FIELD;
	valadoc_html_basic_doclet_inheritable_members = _tmp0_;
	valadoc_html_basic_doclet_inheritable_members_length1 = 7;
}


static void valadoc_html_basic_doclet_valadoc_doclet_interface_init (ValadocDocletIface * iface) {
	valadoc_html_basic_doclet_valadoc_doclet_parent_iface = g_type_interface_peek_parent (iface);
	iface->process = (void (*) (ValadocDoclet *, ValadocSettings*, ValadocApiTree*, ValadocErrorReporter*)) valadoc_html_basic_doclet_process;
}


static void valadoc_html_basic_doclet_instance_init (ValadocHtmlBasicDoclet * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = VALADOC_HTML_BASIC_DOCLET_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("index.valadoc");
	self->priv->_wiki_index_name = _tmp0_;
	_tmp1_ = g_strdup ("../index.html");
	self->package_list_link = _tmp1_;
	self->priv->html_id_counter = (guint) 0;
}


static void valadoc_html_basic_doclet_finalize (GObject * obj) {
	ValadocHtmlBasicDoclet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDoclet);
	_g_object_unref0 (self->priv->_linker);
	_g_object_unref0 (self->priv->_settings);
	_g_free0 (self->priv->_wiki_index_name);
	_valadoc_api_tree_unref0 (self->tree);
	_g_object_unref0 (self->_renderer);
	_valadoc_markup_writer_unref0 (self->writer);
	_g_object_unref0 (self->cssresolver);
	_g_object_unref0 (self->image_factory);
	_g_object_unref0 (self->reporter);
	_g_free0 (self->package_list_link);
	G_OBJECT_CLASS (valadoc_html_basic_doclet_parent_class)->finalize (obj);
}


GType valadoc_html_basic_doclet_get_type (void) {
	static volatile gsize valadoc_html_basic_doclet_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_html_basic_doclet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocHtmlBasicDocletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_html_basic_doclet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocHtmlBasicDoclet), 0, (GInstanceInitFunc) valadoc_html_basic_doclet_instance_init, NULL };
		static const GInterfaceInfo valadoc_doclet_info = { (GInterfaceInitFunc) valadoc_html_basic_doclet_valadoc_doclet_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_html_basic_doclet_type_id;
		valadoc_html_basic_doclet_type_id = g_type_register_static (VALADOC_API_TYPE_VISITOR, "ValadocHtmlBasicDoclet", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (valadoc_html_basic_doclet_type_id, VALADOC_TYPE_DOCLET, &valadoc_doclet_info);
		g_once_init_leave (&valadoc_html_basic_doclet_type_id__volatile, valadoc_html_basic_doclet_type_id);
	}
	return valadoc_html_basic_doclet_type_id__volatile;
}


static void _vala_valadoc_html_basic_doclet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValadocHtmlBasicDoclet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDoclet);
	switch (property_id) {
		case VALADOC_HTML_BASIC_DOCLET_LINKER:
		g_value_set_object (value, valadoc_html_basic_doclet_get_linker (self));
		break;
		case VALADOC_HTML_BASIC_DOCLET_SETTINGS:
		g_value_set_object (value, valadoc_html_basic_doclet_get_settings (self));
		break;
		case VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME:
		g_value_set_string (value, valadoc_html_basic_doclet_get_wiki_index_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_valadoc_html_basic_doclet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValadocHtmlBasicDoclet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDoclet);
	switch (property_id) {
		case VALADOC_HTML_BASIC_DOCLET_LINKER:
		valadoc_html_basic_doclet_set_linker (self, g_value_get_object (value));
		break;
		case VALADOC_HTML_BASIC_DOCLET_SETTINGS:
		valadoc_html_basic_doclet_set_settings (self, g_value_get_object (value));
		break;
		case VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME:
		valadoc_html_basic_doclet_set_wiki_index_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



