/* gtkdocmarkdownscanner.c generated by valac, the Vala compiler
 * generated from gtkdocmarkdownscanner.vala, do not modify */

/* gtkdocmarkdownscanner.vala
 *
 * Copyright (C) 2014 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *  Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALADOC_GTKDOC_MARKDOWN_SCANNER_TYPE_STATE (valadoc_gtkdoc_markdown_scanner_state_get_type ())
enum  {
	VALADOC_GTKDOC_MARKDOWN_SCANNER_DUMMY_PROPERTY,
	VALADOC_GTKDOC_MARKDOWN_SCANNER_LAST_PROPERTY
};
static GParamSpec* valadoc_gtkdoc_markdown_scanner_properties[VALADOC_GTKDOC_MARKDOWN_SCANNER_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_parser_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_parser_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_NORMAL,
	VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST,
	VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST,
	VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK
} ValadocGtkdocMarkdownScannerState;

struct _ValadocGtkdocMarkdownScannerPrivate {
	ValadocSettings* _settings;
	ValadocParser* parser;
	const gchar* _content;
	gint _skip;
	GString* _current_string;
	const gchar* _index;
	gboolean contains_at;
	gint _line;
	gint _column;
	gint _last_line;
	gint _last_column;
	gboolean _stop;
	gchar* headline_end;
	GRegex* regex_mail;
	ValaList* states;
};


static gpointer valadoc_gtkdoc_markdown_scanner_parent_class = NULL;
static ValadocScannerIface * valadoc_gtkdoc_markdown_scanner_valadoc_scanner_parent_iface = NULL;

static GType valadoc_gtkdoc_markdown_scanner_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALADOC_GTKDOC_MARKDOWN_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_GTKDOC_TYPE_MARKDOWN_SCANNER, ValadocGtkdocMarkdownScannerPrivate))
static inline void valadoc_gtkdoc_markdown_scanner_push_state (ValadocGtkdocMarkdownScanner* self, ValadocGtkdocMarkdownScannerState state);
static inline ValadocGtkdocMarkdownScannerState valadoc_gtkdoc_markdown_scanner_pop_state (ValadocGtkdocMarkdownScanner* self);
static inline ValadocGtkdocMarkdownScannerState valadoc_gtkdoc_markdown_scanner_peek_state (ValadocGtkdocMarkdownScanner* self);
static void valadoc_gtkdoc_markdown_scanner_real_set_parser (ValadocScanner* base, ValadocParser* parser);
static void valadoc_gtkdoc_markdown_scanner_real_reset (ValadocScanner* base);
static void valadoc_gtkdoc_markdown_scanner_real_scan (ValadocScanner* base, const gchar* content, GError** error);
static gboolean valadoc_gtkdoc_markdown_scanner_handle_newline (ValadocGtkdocMarkdownScanner* self, const gchar* _iter, gboolean is_paragraph, GError** error);
static void valadoc_gtkdoc_markdown_scanner_emit_token (ValadocGtkdocMarkdownScanner* self, ValadocTokenType* type, const gchar* value, GError** error);
static void valadoc_gtkdoc_markdown_scanner_accept (ValadocGtkdocMarkdownScanner* self, gunichar c, GError** error);
static gboolean valadoc_gtkdoc_markdown_scanner_close_block (ValadocGtkdocMarkdownScanner* self, GError** error);
static gboolean valadoc_gtkdoc_markdown_scanner_is_headline_end (ValadocGtkdocMarkdownScanner* self, const gchar* * iter, const gchar* separator, gchar* * hash);
static gunichar valadoc_gtkdoc_markdown_scanner_get_next_char (ValadocGtkdocMarkdownScanner* self, gint offset);
static void valadoc_gtkdoc_markdown_scanner_append_char (ValadocGtkdocMarkdownScanner* self, gunichar c);
static gboolean valadoc_gtkdoc_markdown_scanner_is_id (ValadocGtkdocMarkdownScanner* self);
static inline gint valadoc_gtkdoc_markdown_scanner_skip_spaces (ValadocGtkdocMarkdownScanner* self, const gchar* * _iter);
static gboolean valadoc_gtkdoc_markdown_scanner_is_ordered_list (ValadocGtkdocMarkdownScanner* self, const gchar* iter, gint* numeric_prefix_count);
static void valadoc_gtkdoc_markdown_scanner_real_end (ValadocScanner* base, GError** error);
static void valadoc_gtkdoc_markdown_scanner_real_stop (ValadocScanner* base);
static gchar* valadoc_gtkdoc_markdown_scanner_real_get_line_content (ValadocScanner* base);
static void valadoc_gtkdoc_markdown_scanner_emit_current_word (ValadocGtkdocMarkdownScanner* self, GError** error);
static void valadoc_gtkdoc_markdown_scanner_get_begin (ValadocGtkdocMarkdownScanner* self, ValadocSourceLocation* result);
static void valadoc_gtkdoc_markdown_scanner_get_end (ValadocGtkdocMarkdownScanner* self, gint offset, ValadocSourceLocation* result);
static inline gboolean valadoc_gtkdoc_markdown_scanner_is_mail (ValadocGtkdocMarkdownScanner* self);
static void valadoc_gtkdoc_markdown_scanner_finalize (GObject * obj);


static GType valadoc_gtkdoc_markdown_scanner_state_get_type (void) {
	static volatile gsize valadoc_gtkdoc_markdown_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_markdown_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_NORMAL, "VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_NORMAL", "normal"}, {VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST, "VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST", "unordered-list"}, {VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST, "VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST", "ordered-list"}, {VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK, "VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK", "block"}, {0, NULL, NULL}};
		GType valadoc_gtkdoc_markdown_scanner_state_type_id;
		valadoc_gtkdoc_markdown_scanner_state_type_id = g_enum_register_static ("ValadocGtkdocMarkdownScannerState", values);
		g_once_init_leave (&valadoc_gtkdoc_markdown_scanner_state_type_id__volatile, valadoc_gtkdoc_markdown_scanner_state_type_id);
	}
	return valadoc_gtkdoc_markdown_scanner_state_type_id__volatile;
}


static inline void valadoc_gtkdoc_markdown_scanner_push_state (ValadocGtkdocMarkdownScanner* self, ValadocGtkdocMarkdownScannerState state) {
	ValaList* _tmp0_;
	ValadocGtkdocMarkdownScannerState _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->states;
	_tmp1_ = state;
	vala_list_insert (_tmp0_, 0, (gpointer) ((gintptr) _tmp1_));
}


static inline ValadocGtkdocMarkdownScannerState valadoc_gtkdoc_markdown_scanner_pop_state (ValadocGtkdocMarkdownScanner* self) {
	ValadocGtkdocMarkdownScannerState result = 0;
	ValaList* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->states;
	_tmp1_ = vala_list_remove_at (_tmp0_, 0);
	result = (ValadocGtkdocMarkdownScannerState) ((gintptr) _tmp1_);
	return result;
}


static inline ValadocGtkdocMarkdownScannerState valadoc_gtkdoc_markdown_scanner_peek_state (ValadocGtkdocMarkdownScanner* self) {
	ValadocGtkdocMarkdownScannerState result = 0;
	ValaList* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->states;
	_tmp1_ = vala_list_get (_tmp0_, 0);
	result = (ValadocGtkdocMarkdownScannerState) ((gintptr) _tmp1_);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ValadocGtkdocMarkdownScanner* valadoc_gtkdoc_markdown_scanner_construct (GType object_type, ValadocSettings* settings) {
	ValadocGtkdocMarkdownScanner * self = NULL;
	ValadocSettings* _tmp0_;
	ValadocSettings* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (ValadocGtkdocMarkdownScanner*) g_object_new (object_type, NULL);
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp1_;
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		_tmp3_ = g_regex_new ("^[A-Za-z0-9._-]+@[A-Za-z0-9._-]+$", 0, 0, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch15_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_regex_unref0 (self->priv->regex_mail);
		self->priv->regex_mail = _tmp4_;
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


ValadocGtkdocMarkdownScanner* valadoc_gtkdoc_markdown_scanner_new (ValadocSettings* settings) {
	return valadoc_gtkdoc_markdown_scanner_construct (VALADOC_GTKDOC_TYPE_MARKDOWN_SCANNER, settings);
}


static gpointer _valadoc_parser_ref0 (gpointer self) {
	return self ? valadoc_parser_ref (self) : NULL;
}


static void valadoc_gtkdoc_markdown_scanner_real_set_parser (ValadocScanner* base, ValadocParser* parser) {
	ValadocGtkdocMarkdownScanner * self;
	ValadocParser* _tmp0_;
	ValadocParser* _tmp1_;
	self = (ValadocGtkdocMarkdownScanner*) base;
	g_return_if_fail (parser != NULL);
	_tmp0_ = parser;
	_tmp1_ = _valadoc_parser_ref0 (_tmp0_);
	_valadoc_parser_unref0 (self->priv->parser);
	self->priv->parser = _tmp1_;
}


static void valadoc_gtkdoc_markdown_scanner_real_reset (ValadocScanner* base) {
	ValadocGtkdocMarkdownScanner * self;
	GString* _tmp0_;
	ValaList* _tmp1_;
	self = (ValadocGtkdocMarkdownScanner*) base;
	self->priv->_stop = FALSE;
	self->priv->_last_line = 0;
	self->priv->_last_column = 0;
	self->priv->_line = 0;
	self->priv->_column = 0;
	self->priv->_skip = 0;
	_tmp0_ = self->priv->_current_string;
	g_string_erase (_tmp0_, (gssize) 0, (gssize) -1);
	self->priv->contains_at = FALSE;
	_tmp1_ = self->priv->states;
	vala_collection_clear ((ValaCollection*) _tmp1_);
	valadoc_gtkdoc_markdown_scanner_push_state (self, VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_NORMAL);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static void valadoc_gtkdoc_markdown_scanner_real_scan (ValadocScanner* base, const gchar* content, GError** error) {
	ValadocGtkdocMarkdownScanner * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	ValadocTokenType* _tmp20_;
	GError * _inner_error_ = NULL;
	self = (ValadocGtkdocMarkdownScanner*) base;
	g_return_if_fail (content != NULL);
	_tmp0_ = content;
	self->priv->_content = _tmp0_;
	_tmp1_ = self->priv->_content;
	self->priv->_index = _tmp1_;
	_tmp3_ = self->priv->_index;
	_tmp4_ = valadoc_gtkdoc_markdown_scanner_handle_newline (self, _tmp3_, TRUE, &_inner_error_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->priv->_index;
		_tmp6_ = g_utf8_next_char (_tmp5_);
		self->priv->_index = _tmp6_;
	} else {
		ValadocTokenType* _tmp7_;
		_tmp7_ = valadoc_token_type_MARKDOWN_PARAGRAPH;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp7_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		gunichar c = 0U;
		const gchar* _tmp12_;
		gunichar _tmp13_;
		gunichar _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp9_ = self->priv->_stop;
		if (!_tmp9_) {
			const gchar* _tmp10_;
			gunichar _tmp11_;
			_tmp10_ = self->priv->_index;
			_tmp11_ = string_get_char (_tmp10_, (glong) 0);
			_tmp8_ = _tmp11_ != ((gunichar) 0);
		} else {
			_tmp8_ = FALSE;
		}
		if (!_tmp8_) {
			break;
		}
		_tmp12_ = self->priv->_index;
		_tmp13_ = string_get_char (_tmp12_, (glong) 0);
		c = _tmp13_;
		_tmp14_ = c;
		valadoc_gtkdoc_markdown_scanner_accept (self, _tmp14_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp15_ = self->priv->_index;
		_tmp16_ = g_utf8_next_char (_tmp15_);
		self->priv->_index = _tmp16_;
	}
	while (TRUE) {
		ValadocGtkdocMarkdownScannerState _tmp17_;
		ValadocGtkdocMarkdownScannerState _tmp18_;
		_tmp17_ = valadoc_gtkdoc_markdown_scanner_peek_state (self);
		if (!(_tmp17_ != VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_NORMAL)) {
			break;
		}
		_tmp18_ = valadoc_gtkdoc_markdown_scanner_peek_state (self);
		if (_tmp18_ == VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK) {
			ValadocTokenType* _tmp19_;
			_tmp19_ = valadoc_token_type_MARKDOWN_BLOCK_END;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp19_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			valadoc_gtkdoc_markdown_scanner_pop_state (self);
		} else {
			valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	_tmp20_ = valadoc_token_type_MARKDOWN_EOC;
	valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp20_, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void valadoc_gtkdoc_markdown_scanner_accept (ValadocGtkdocMarkdownScanner* self, gunichar c, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	gchar* hash = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gunichar _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_column;
	self->priv->_column = _tmp0_ + 1;
	_tmp1_ = self->priv->_skip;
	if (_tmp1_ > 0) {
		gint _tmp2_;
		_tmp2_ = self->priv->_skip;
		self->priv->_skip = _tmp2_ - 1;
		return;
	}
	hash = NULL;
	_tmp4_ = self->priv->headline_end;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_;
		_tmp5_ = self->priv->headline_end;
		_tmp7_ = valadoc_gtkdoc_markdown_scanner_is_headline_end (self, &self->priv->_index, _tmp5_, &_tmp6_);
		_g_free0 (hash);
		hash = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp8_;
		ValadocTokenType* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = hash;
		if (_tmp8_ != NULL) {
			ValadocTokenType* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = valadoc_token_type_MARKDOWN_HEADLINE_HASH;
			_tmp10_ = hash;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp9_, _tmp10_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		_tmp11_ = valadoc_token_type_MARKDOWN_HEADLINE_END;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp11_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (hash);
				return;
			} else {
				_g_free0 (hash);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_free0 (self->priv->headline_end);
		self->priv->headline_end = NULL;
		_tmp12_ = self->priv->_index;
		valadoc_gtkdoc_markdown_scanner_handle_newline (self, _tmp12_, TRUE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (hash);
				return;
			} else {
				_g_free0 (hash);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_free0 (hash);
		return;
	}
	_tmp13_ = c;
	switch (_tmp13_) {
		case '\\':
		{
			gunichar _tmp14_;
			_tmp14_ = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1);
			switch (_tmp14_) {
				case '(':
				{
					gunichar _tmp15_;
					GString* _tmp18_;
					gint _tmp19_;
					_tmp15_ = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 2);
					if (_tmp15_ == ((gunichar) ')')) {
						GString* _tmp16_;
						gint _tmp17_;
						_tmp16_ = self->priv->_current_string;
						g_string_append (_tmp16_, "()");
						_tmp17_ = self->priv->_skip;
						self->priv->_skip = _tmp17_ + 2;
						break;
					}
					_tmp18_ = self->priv->_current_string;
					g_string_append (_tmp18_, "\\(");
					_tmp19_ = self->priv->_skip;
					self->priv->_skip = _tmp19_ + 1;
					break;
				}
				case '<':
				{
					gint _tmp20_;
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '<');
					_tmp20_ = self->priv->_skip;
					self->priv->_skip = _tmp20_ + 1;
					break;
				}
				case '>':
				{
					gint _tmp21_;
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '>');
					_tmp21_ = self->priv->_skip;
					self->priv->_skip = _tmp21_ + 1;
					break;
				}
				case '@':
				{
					gint _tmp22_;
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '@');
					_tmp22_ = self->priv->_skip;
					self->priv->_skip = _tmp22_ + 1;
					break;
				}
				case '%':
				{
					gint _tmp23_;
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '%');
					_tmp23_ = self->priv->_skip;
					self->priv->_skip = _tmp23_ + 1;
					break;
				}
				case '#':
				{
					gint _tmp24_;
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '#');
					_tmp24_ = self->priv->_skip;
					self->priv->_skip = _tmp24_ + 1;
					break;
				}
				default:
				{
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '\\');
					break;
				}
			}
			break;
		}
		case ':':
		{
			gunichar next_char = 0U;
			gunichar _tmp25_;
			gunichar next2_char = 0U;
			gunichar _tmp26_;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			GString* _tmp29_;
			gssize _tmp30_;
			gunichar _tmp71_;
			_tmp25_ = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1);
			next_char = _tmp25_;
			_tmp26_ = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 2);
			next2_char = _tmp26_;
			_tmp29_ = self->priv->_current_string;
			_tmp30_ = _tmp29_->len;
			if (_tmp30_ == ((gssize) 0)) {
				_tmp28_ = TRUE;
			} else {
				GString* _tmp31_;
				const gchar* _tmp32_;
				GString* _tmp33_;
				gssize _tmp34_;
				gchar _tmp35_;
				gboolean _tmp36_;
				_tmp31_ = self->priv->_current_string;
				_tmp32_ = _tmp31_->str;
				_tmp33_ = self->priv->_current_string;
				_tmp34_ = _tmp33_->len;
				_tmp35_ = string_get (_tmp32_, (glong) (_tmp34_ - 1));
				_tmp36_ = g_ascii_isalpha (_tmp35_);
				_tmp28_ = !_tmp36_;
			}
			if (_tmp28_) {
				gboolean _tmp37_ = FALSE;
				gunichar _tmp38_;
				gboolean _tmp39_;
				_tmp38_ = next_char;
				_tmp39_ = g_unichar_isalpha (_tmp38_);
				if (_tmp39_) {
					_tmp37_ = TRUE;
				} else {
					gboolean _tmp40_ = FALSE;
					gunichar _tmp41_;
					_tmp41_ = next_char;
					if (_tmp41_ == ((gunichar) ':')) {
						gunichar _tmp42_;
						gboolean _tmp43_;
						_tmp42_ = next2_char;
						_tmp43_ = g_unichar_isalpha (_tmp42_);
						_tmp40_ = _tmp43_;
					} else {
						_tmp40_ = FALSE;
					}
					_tmp37_ = _tmp40_;
				}
				_tmp27_ = _tmp37_;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				const gchar* _iter = NULL;
				gunichar _tmp44_;
				ValadocTokenType* _tmp66_;
				const gchar* _tmp67_;
				gint _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				_tmp44_ = next_char;
				if (_tmp44_ == ((gunichar) ':')) {
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gint _tmp47_;
					_tmp45_ = self->priv->_index;
					_tmp46_ = string_offset (_tmp45_, (glong) 2);
					_iter = _tmp46_;
					_tmp47_ = self->priv->_skip;
					self->priv->_skip = _tmp47_ + 1;
				} else {
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					_tmp48_ = self->priv->_index;
					_tmp49_ = string_offset (_tmp48_, (glong) 1);
					_iter = _tmp49_;
				}
				while (TRUE) {
					gboolean _tmp50_ = FALSE;
					gboolean _tmp51_ = FALSE;
					const gchar* _tmp52_;
					gchar _tmp53_;
					gboolean _tmp54_;
					const gchar* _tmp63_;
					const gchar* _tmp64_;
					gint _tmp65_;
					_tmp52_ = _iter;
					_tmp53_ = string_get (_tmp52_, (glong) 0);
					_tmp54_ = g_ascii_isalnum (_tmp53_);
					if (_tmp54_) {
						_tmp51_ = TRUE;
					} else {
						const gchar* _tmp55_;
						gchar _tmp56_;
						_tmp55_ = _iter;
						_tmp56_ = string_get (_tmp55_, (glong) 0);
						_tmp51_ = _tmp56_ == '_';
					}
					if (_tmp51_) {
						_tmp50_ = TRUE;
					} else {
						gboolean _tmp57_ = FALSE;
						const gchar* _tmp58_;
						gchar _tmp59_;
						_tmp58_ = _iter;
						_tmp59_ = string_get (_tmp58_, (glong) 0);
						if (_tmp59_ == '-') {
							const gchar* _tmp60_;
							gchar _tmp61_;
							gboolean _tmp62_;
							_tmp60_ = _iter;
							_tmp61_ = string_get (_tmp60_, (glong) 1);
							_tmp62_ = g_ascii_isalnum (_tmp61_);
							_tmp57_ = _tmp62_;
						} else {
							_tmp57_ = FALSE;
						}
						_tmp50_ = _tmp57_;
					}
					if (!_tmp50_) {
						break;
					}
					_tmp63_ = _iter;
					_tmp64_ = string_offset (_tmp63_, (glong) 1);
					_iter = _tmp64_;
					_tmp65_ = self->priv->_skip;
					self->priv->_skip = _tmp65_ + 1;
				}
				_tmp66_ = valadoc_token_type_MARKDOWN_LOCAL_GMEMBER;
				_tmp67_ = self->priv->_index;
				_tmp68_ = self->priv->_skip;
				_tmp69_ = string_substring (_tmp67_, (glong) 0, (glong) (_tmp68_ + 1));
				_tmp70_ = _tmp69_;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp66_, _tmp70_, &_inner_error_);
				_g_free0 (_tmp70_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			_tmp71_ = c;
			valadoc_gtkdoc_markdown_scanner_append_char (self, _tmp71_);
			break;
		}
		case '%':
		{
			gboolean _tmp72_ = FALSE;
			gboolean _tmp73_ = FALSE;
			GString* _tmp74_;
			gssize _tmp75_;
			gboolean _tmp100_ = FALSE;
			gboolean _tmp101_ = FALSE;
			GString* _tmp102_;
			gssize _tmp103_;
			gunichar _tmp180_;
			_tmp74_ = self->priv->_current_string;
			_tmp75_ = _tmp74_->len;
			if (_tmp75_ == ((gssize) 0)) {
				_tmp73_ = TRUE;
			} else {
				GString* _tmp76_;
				const gchar* _tmp77_;
				GString* _tmp78_;
				gssize _tmp79_;
				gchar _tmp80_;
				gboolean _tmp81_;
				_tmp76_ = self->priv->_current_string;
				_tmp77_ = _tmp76_->str;
				_tmp78_ = self->priv->_current_string;
				_tmp79_ = _tmp78_->len;
				_tmp80_ = string_get (_tmp77_, (glong) (_tmp79_ - 1));
				_tmp81_ = g_ascii_isalpha (_tmp80_);
				_tmp73_ = !_tmp81_;
			}
			if (_tmp73_) {
				gunichar _tmp82_;
				gboolean _tmp83_;
				_tmp82_ = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1);
				_tmp83_ = g_unichar_isalpha (_tmp82_);
				_tmp72_ = _tmp83_;
			} else {
				_tmp72_ = FALSE;
			}
			if (_tmp72_) {
				const gchar* _iter = NULL;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				ValadocTokenType* _tmp95_;
				const gchar* _tmp96_;
				gint _tmp97_;
				gchar* _tmp98_;
				gchar* _tmp99_;
				_tmp84_ = self->priv->_index;
				_tmp85_ = string_offset (_tmp84_, (glong) 1);
				_iter = _tmp85_;
				while (TRUE) {
					gboolean _tmp86_ = FALSE;
					const gchar* _tmp87_;
					gchar _tmp88_;
					gboolean _tmp89_;
					const gchar* _tmp92_;
					const gchar* _tmp93_;
					gint _tmp94_;
					_tmp87_ = _iter;
					_tmp88_ = string_get (_tmp87_, (glong) 0);
					_tmp89_ = g_ascii_isalnum (_tmp88_);
					if (_tmp89_) {
						_tmp86_ = TRUE;
					} else {
						const gchar* _tmp90_;
						gchar _tmp91_;
						_tmp90_ = _iter;
						_tmp91_ = string_get (_tmp90_, (glong) 0);
						_tmp86_ = _tmp91_ == '_';
					}
					if (!_tmp86_) {
						break;
					}
					_tmp92_ = _iter;
					_tmp93_ = string_offset (_tmp92_, (glong) 1);
					_iter = _tmp93_;
					_tmp94_ = self->priv->_skip;
					self->priv->_skip = _tmp94_ + 1;
				}
				_tmp95_ = valadoc_token_type_MARKDOWN_CONSTANT;
				_tmp96_ = self->priv->_index;
				_tmp97_ = self->priv->_skip;
				_tmp98_ = string_substring (_tmp96_, (glong) 1, (glong) _tmp97_);
				_tmp99_ = _tmp98_;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp95_, _tmp99_, &_inner_error_);
				_g_free0 (_tmp99_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			_tmp102_ = self->priv->_current_string;
			_tmp103_ = _tmp102_->len;
			if (_tmp103_ == ((gssize) 0)) {
				_tmp101_ = TRUE;
			} else {
				GString* _tmp104_;
				const gchar* _tmp105_;
				GString* _tmp106_;
				gssize _tmp107_;
				gchar _tmp108_;
				gboolean _tmp109_;
				_tmp104_ = self->priv->_current_string;
				_tmp105_ = _tmp104_->str;
				_tmp106_ = self->priv->_current_string;
				_tmp107_ = _tmp106_->len;
				_tmp108_ = string_get (_tmp105_, (glong) (_tmp107_ - 1));
				_tmp109_ = g_ascii_isalpha (_tmp108_);
				_tmp101_ = !_tmp109_;
			}
			if (_tmp101_) {
				gunichar _tmp110_;
				gboolean _tmp111_;
				_tmp110_ = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1);
				_tmp111_ = g_unichar_isdigit (_tmp110_);
				_tmp100_ = _tmp111_;
			} else {
				_tmp100_ = FALSE;
			}
			if (_tmp100_) {
				const gchar* _iter = NULL;
				const gchar* _tmp112_;
				const gchar* _tmp113_;
				gboolean _tmp120_ = FALSE;
				const gchar* _tmp121_;
				gchar _tmp122_;
				gchar _tmp123_;
				gboolean _tmp150_ = FALSE;
				const gchar* _tmp151_;
				gchar _tmp152_;
				gboolean _tmp165_ = FALSE;
				const gchar* _tmp166_;
				gchar _tmp167_;
				gchar _tmp168_;
				ValadocTokenType* _tmp175_;
				const gchar* _tmp176_;
				gint _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				_tmp112_ = self->priv->_index;
				_tmp113_ = string_offset (_tmp112_, (glong) 1);
				_iter = _tmp113_;
				while (TRUE) {
					const gchar* _tmp114_;
					gchar _tmp115_;
					gboolean _tmp116_;
					const gchar* _tmp117_;
					const gchar* _tmp118_;
					gint _tmp119_;
					_tmp114_ = _iter;
					_tmp115_ = string_get (_tmp114_, (glong) 0);
					_tmp116_ = g_ascii_isdigit (_tmp115_);
					if (!_tmp116_) {
						break;
					}
					_tmp117_ = _iter;
					_tmp118_ = string_offset (_tmp117_, (glong) 1);
					_iter = _tmp118_;
					_tmp119_ = self->priv->_skip;
					self->priv->_skip = _tmp119_ + 1;
				}
				_tmp121_ = _iter;
				_tmp122_ = string_get (_tmp121_, (glong) 0);
				_tmp123_ = g_ascii_tolower (_tmp122_);
				if (_tmp123_ == 'u') {
					const gchar* _tmp124_;
					gchar _tmp125_;
					gchar _tmp126_;
					_tmp124_ = _iter;
					_tmp125_ = string_get (_tmp124_, (glong) 0);
					_tmp126_ = g_ascii_tolower (_tmp125_);
					_tmp120_ = _tmp126_ == 'l';
				} else {
					_tmp120_ = FALSE;
				}
				if (_tmp120_) {
					const gchar* _tmp127_;
					const gchar* _tmp128_;
					gint _tmp129_;
					ValadocTokenType* _tmp130_;
					const gchar* _tmp131_;
					gint _tmp132_;
					gchar* _tmp133_;
					gchar* _tmp134_;
					_tmp127_ = _iter;
					_tmp128_ = string_offset (_tmp127_, (glong) 1);
					_iter = _tmp128_;
					_tmp129_ = self->priv->_skip;
					self->priv->_skip = _tmp129_ + 2;
					_tmp130_ = valadoc_token_type_MARKDOWN_CONSTANT;
					_tmp131_ = self->priv->_index;
					_tmp132_ = self->priv->_skip;
					_tmp133_ = string_substring (_tmp131_, (glong) 1, (glong) _tmp132_);
					_tmp134_ = _tmp133_;
					valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp130_, _tmp134_, &_inner_error_);
					_g_free0 (_tmp134_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (hash);
							return;
						} else {
							_g_free0 (hash);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					break;
				} else {
					gboolean _tmp135_ = FALSE;
					const gchar* _tmp136_;
					gchar _tmp137_;
					gchar _tmp138_;
					_tmp136_ = _iter;
					_tmp137_ = string_get (_tmp136_, (glong) 0);
					_tmp138_ = g_ascii_tolower (_tmp137_);
					if (_tmp138_ == 'u') {
						_tmp135_ = TRUE;
					} else {
						const gchar* _tmp139_;
						gchar _tmp140_;
						gchar _tmp141_;
						_tmp139_ = _iter;
						_tmp140_ = string_get (_tmp139_, (glong) 0);
						_tmp141_ = g_ascii_tolower (_tmp140_);
						_tmp135_ = _tmp141_ == 'l';
					}
					if (_tmp135_) {
						const gchar* _tmp142_;
						const gchar* _tmp143_;
						gint _tmp144_;
						ValadocTokenType* _tmp145_;
						const gchar* _tmp146_;
						gint _tmp147_;
						gchar* _tmp148_;
						gchar* _tmp149_;
						_tmp142_ = _iter;
						_tmp143_ = string_offset (_tmp142_, (glong) 1);
						_iter = _tmp143_;
						_tmp144_ = self->priv->_skip;
						self->priv->_skip = _tmp144_ + 1;
						_tmp145_ = valadoc_token_type_MARKDOWN_CONSTANT;
						_tmp146_ = self->priv->_index;
						_tmp147_ = self->priv->_skip;
						_tmp148_ = string_substring (_tmp146_, (glong) 1, (glong) _tmp147_);
						_tmp149_ = _tmp148_;
						valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp145_, _tmp149_, &_inner_error_);
						_g_free0 (_tmp149_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (hash);
								return;
							} else {
								_g_free0 (hash);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
				}
				_tmp151_ = _iter;
				_tmp152_ = string_get (_tmp151_, (glong) 0);
				if (_tmp152_ == '.') {
					const gchar* _tmp153_;
					gchar _tmp154_;
					gboolean _tmp155_;
					_tmp153_ = _iter;
					_tmp154_ = string_get (_tmp153_, (glong) 1);
					_tmp155_ = g_ascii_isdigit (_tmp154_);
					_tmp150_ = _tmp155_;
				} else {
					_tmp150_ = FALSE;
				}
				if (_tmp150_) {
					const gchar* _tmp156_;
					const gchar* _tmp157_;
					gint _tmp158_;
					_tmp156_ = _iter;
					_tmp157_ = string_offset (_tmp156_, (glong) 2);
					_iter = _tmp157_;
					_tmp158_ = self->priv->_skip;
					self->priv->_skip = _tmp158_ + 2;
				}
				while (TRUE) {
					const gchar* _tmp159_;
					gchar _tmp160_;
					gboolean _tmp161_;
					const gchar* _tmp162_;
					const gchar* _tmp163_;
					gint _tmp164_;
					_tmp159_ = _iter;
					_tmp160_ = string_get (_tmp159_, (glong) 0);
					_tmp161_ = g_ascii_isdigit (_tmp160_);
					if (!_tmp161_) {
						break;
					}
					_tmp162_ = _iter;
					_tmp163_ = string_offset (_tmp162_, (glong) 1);
					_iter = _tmp163_;
					_tmp164_ = self->priv->_skip;
					self->priv->_skip = _tmp164_ + 1;
				}
				_tmp166_ = _iter;
				_tmp167_ = string_get (_tmp166_, (glong) 0);
				_tmp168_ = g_ascii_tolower (_tmp167_);
				if (_tmp168_ == 'f') {
					_tmp165_ = TRUE;
				} else {
					const gchar* _tmp169_;
					gchar _tmp170_;
					gchar _tmp171_;
					_tmp169_ = _iter;
					_tmp170_ = string_get (_tmp169_, (glong) 0);
					_tmp171_ = g_ascii_tolower (_tmp170_);
					_tmp165_ = _tmp171_ == 'l';
				}
				if (_tmp165_) {
					const gchar* _tmp172_;
					const gchar* _tmp173_;
					gint _tmp174_;
					_tmp172_ = _iter;
					_tmp173_ = string_offset (_tmp172_, (glong) 1);
					_iter = _tmp173_;
					_tmp174_ = self->priv->_skip;
					self->priv->_skip = _tmp174_ + 1;
				}
				_tmp175_ = valadoc_token_type_MARKDOWN_CONSTANT;
				_tmp176_ = self->priv->_index;
				_tmp177_ = self->priv->_skip;
				_tmp178_ = string_substring (_tmp176_, (glong) 1, (glong) _tmp177_);
				_tmp179_ = _tmp178_;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp175_, _tmp179_, &_inner_error_);
				_g_free0 (_tmp179_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			_tmp180_ = c;
			valadoc_gtkdoc_markdown_scanner_append_char (self, _tmp180_);
			break;
		}
		case '#':
		{
			gboolean _tmp181_ = FALSE;
			gboolean _tmp182_ = FALSE;
			GString* _tmp183_;
			gssize _tmp184_;
			gunichar _tmp254_;
			_tmp183_ = self->priv->_current_string;
			_tmp184_ = _tmp183_->len;
			if (_tmp184_ == ((gssize) 0)) {
				_tmp182_ = TRUE;
			} else {
				GString* _tmp185_;
				const gchar* _tmp186_;
				GString* _tmp187_;
				gssize _tmp188_;
				gchar _tmp189_;
				gboolean _tmp190_;
				_tmp185_ = self->priv->_current_string;
				_tmp186_ = _tmp185_->str;
				_tmp187_ = self->priv->_current_string;
				_tmp188_ = _tmp187_->len;
				_tmp189_ = string_get (_tmp186_, (glong) (_tmp188_ - 1));
				_tmp190_ = g_ascii_isalpha (_tmp189_);
				_tmp182_ = !_tmp190_;
			}
			if (_tmp182_) {
				gunichar _tmp191_;
				gboolean _tmp192_;
				_tmp191_ = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1);
				_tmp192_ = g_unichar_isalpha (_tmp191_);
				_tmp181_ = _tmp192_;
			} else {
				_tmp181_ = FALSE;
			}
			if (_tmp181_) {
				const gchar* _iter = NULL;
				const gchar* _tmp193_;
				const gchar* _tmp194_;
				gboolean is_field = FALSE;
				gboolean _tmp204_ = FALSE;
				gboolean _tmp205_ = FALSE;
				gboolean _tmp206_ = FALSE;
				const gchar* _tmp207_;
				gchar _tmp208_;
				gboolean _tmp239_ = FALSE;
				gboolean _tmp240_;
				_tmp193_ = self->priv->_index;
				_tmp194_ = string_offset (_tmp193_, (glong) 1);
				_iter = _tmp194_;
				while (TRUE) {
					gboolean _tmp195_ = FALSE;
					const gchar* _tmp196_;
					gchar _tmp197_;
					gboolean _tmp198_;
					const gchar* _tmp201_;
					const gchar* _tmp202_;
					gint _tmp203_;
					_tmp196_ = _iter;
					_tmp197_ = string_get (_tmp196_, (glong) 0);
					_tmp198_ = g_ascii_isalnum (_tmp197_);
					if (_tmp198_) {
						_tmp195_ = TRUE;
					} else {
						const gchar* _tmp199_;
						gchar _tmp200_;
						_tmp199_ = _iter;
						_tmp200_ = string_get (_tmp199_, (glong) 0);
						_tmp195_ = _tmp200_ == '_';
					}
					if (!_tmp195_) {
						break;
					}
					_tmp201_ = _iter;
					_tmp202_ = string_offset (_tmp201_, (glong) 1);
					_iter = _tmp202_;
					_tmp203_ = self->priv->_skip;
					self->priv->_skip = _tmp203_ + 1;
				}
				is_field = FALSE;
				_tmp207_ = _iter;
				_tmp208_ = string_get (_tmp207_, (glong) 0);
				if (_tmp208_ == ':') {
					_tmp206_ = TRUE;
				} else {
					const gchar* _tmp209_;
					gchar _tmp210_;
					_tmp209_ = _iter;
					_tmp210_ = string_get (_tmp209_, (glong) 0);
					_tmp206_ = _tmp210_ == '.';
				}
				if (_tmp206_) {
					const gchar* _tmp211_;
					gchar _tmp212_;
					gboolean _tmp213_;
					_tmp211_ = _iter;
					_tmp212_ = string_get (_tmp211_, (glong) 1);
					_tmp213_ = g_ascii_isalpha (_tmp212_);
					_tmp205_ = _tmp213_;
				} else {
					_tmp205_ = FALSE;
				}
				if (_tmp205_) {
					_tmp204_ = TRUE;
				} else {
					gboolean _tmp214_ = FALSE;
					const gchar* _tmp215_;
					gboolean _tmp216_;
					_tmp215_ = _iter;
					_tmp216_ = g_str_has_prefix (_tmp215_, "::");
					if (_tmp216_) {
						const gchar* _tmp217_;
						gchar _tmp218_;
						gboolean _tmp219_;
						_tmp217_ = _iter;
						_tmp218_ = string_get (_tmp217_, (glong) 2);
						_tmp219_ = g_ascii_isalpha (_tmp218_);
						_tmp214_ = _tmp219_;
					} else {
						_tmp214_ = FALSE;
					}
					_tmp204_ = _tmp214_;
				}
				if (_tmp204_) {
					const gchar* _tmp220_;
					gchar _tmp221_;
					const gchar* _tmp222_;
					const gchar* _tmp223_;
					gint _tmp224_;
					_tmp220_ = _iter;
					_tmp221_ = string_get (_tmp220_, (glong) 0);
					is_field = _tmp221_ == '.';
					_tmp222_ = _iter;
					_tmp223_ = string_offset (_tmp222_, (glong) 2);
					_iter = _tmp223_;
					_tmp224_ = self->priv->_skip;
					self->priv->_skip = _tmp224_ + 2;
					while (TRUE) {
						gboolean _tmp225_ = FALSE;
						gboolean _tmp226_ = FALSE;
						const gchar* _tmp227_;
						gchar _tmp228_;
						gboolean _tmp229_;
						const gchar* _tmp236_;
						const gchar* _tmp237_;
						gint _tmp238_;
						_tmp227_ = _iter;
						_tmp228_ = string_get (_tmp227_, (glong) 0);
						_tmp229_ = g_ascii_isalnum (_tmp228_);
						if (_tmp229_) {
							_tmp226_ = TRUE;
						} else {
							const gchar* _tmp230_;
							gchar _tmp231_;
							_tmp230_ = _iter;
							_tmp231_ = string_get (_tmp230_, (glong) 0);
							_tmp226_ = _tmp231_ == '_';
						}
						if (_tmp226_) {
							_tmp225_ = TRUE;
						} else {
							gboolean _tmp232_ = FALSE;
							gboolean _tmp233_;
							_tmp233_ = is_field;
							if (!_tmp233_) {
								const gchar* _tmp234_;
								gchar _tmp235_;
								_tmp234_ = _iter;
								_tmp235_ = string_get (_tmp234_, (glong) 0);
								_tmp232_ = _tmp235_ == '-';
							} else {
								_tmp232_ = FALSE;
							}
							_tmp225_ = _tmp232_;
						}
						if (!_tmp225_) {
							break;
						}
						_tmp236_ = _iter;
						_tmp237_ = string_offset (_tmp236_, (glong) 1);
						_iter = _tmp237_;
						_tmp238_ = self->priv->_skip;
						self->priv->_skip = _tmp238_ + 1;
					}
				}
				_tmp240_ = is_field;
				if (_tmp240_) {
					const gchar* _tmp241_;
					gboolean _tmp242_;
					_tmp241_ = _iter;
					_tmp242_ = g_str_has_prefix (_tmp241_, "()");
					_tmp239_ = _tmp242_;
				} else {
					_tmp239_ = FALSE;
				}
				if (_tmp239_) {
					gint _tmp243_;
					ValadocTokenType* _tmp244_;
					const gchar* _tmp245_;
					gint _tmp246_;
					gchar* _tmp247_;
					gchar* _tmp248_;
					_tmp243_ = self->priv->_skip;
					self->priv->_skip = _tmp243_ + 2;
					_tmp244_ = valadoc_token_type_MARKDOWN_SYMBOL;
					_tmp245_ = self->priv->_index;
					_tmp246_ = self->priv->_skip;
					_tmp247_ = string_substring (_tmp245_, (glong) 1, (glong) (_tmp246_ - 2));
					_tmp248_ = _tmp247_;
					valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp244_, _tmp248_, &_inner_error_);
					_g_free0 (_tmp248_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (hash);
							return;
						} else {
							_g_free0 (hash);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				} else {
					ValadocTokenType* _tmp249_;
					const gchar* _tmp250_;
					gint _tmp251_;
					gchar* _tmp252_;
					gchar* _tmp253_;
					_tmp249_ = valadoc_token_type_MARKDOWN_SYMBOL;
					_tmp250_ = self->priv->_index;
					_tmp251_ = self->priv->_skip;
					_tmp252_ = string_substring (_tmp250_, (glong) 1, (glong) _tmp251_);
					_tmp253_ = _tmp252_;
					valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp249_, _tmp253_, &_inner_error_);
					_g_free0 (_tmp253_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (hash);
							return;
						} else {
							_g_free0 (hash);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				break;
			}
			_tmp254_ = c;
			valadoc_gtkdoc_markdown_scanner_append_char (self, _tmp254_);
			break;
		}
		case '@':
		{
			gboolean _tmp255_ = FALSE;
			GString* _tmp256_;
			gssize _tmp257_;
			gunichar _tmp286_;
			_tmp256_ = self->priv->_current_string;
			_tmp257_ = _tmp256_->len;
			if (_tmp257_ == ((gssize) 0)) {
				_tmp255_ = TRUE;
			} else {
				GString* _tmp258_;
				const gchar* _tmp259_;
				GString* _tmp260_;
				gssize _tmp261_;
				gchar _tmp262_;
				gboolean _tmp263_;
				_tmp258_ = self->priv->_current_string;
				_tmp259_ = _tmp258_->str;
				_tmp260_ = self->priv->_current_string;
				_tmp261_ = _tmp260_->len;
				_tmp262_ = string_get (_tmp259_, (glong) (_tmp261_ - 1));
				_tmp263_ = g_ascii_isalpha (_tmp262_);
				_tmp255_ = !_tmp263_;
			}
			if (_tmp255_) {
				gunichar _tmp264_;
				gboolean _tmp265_;
				_tmp264_ = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1);
				_tmp265_ = g_unichar_isalpha (_tmp264_);
				if (_tmp265_) {
					const gchar* _iter = NULL;
					const gchar* _tmp266_;
					const gchar* _tmp267_;
					ValadocTokenType* _tmp277_;
					const gchar* _tmp278_;
					gint _tmp279_;
					gchar* _tmp280_;
					gchar* _tmp281_;
					_tmp266_ = self->priv->_index;
					_tmp267_ = string_offset (_tmp266_, (glong) 1);
					_iter = _tmp267_;
					while (TRUE) {
						gboolean _tmp268_ = FALSE;
						const gchar* _tmp269_;
						gchar _tmp270_;
						gboolean _tmp271_;
						const gchar* _tmp274_;
						const gchar* _tmp275_;
						gint _tmp276_;
						_tmp269_ = _iter;
						_tmp270_ = string_get (_tmp269_, (glong) 0);
						_tmp271_ = g_ascii_isalnum (_tmp270_);
						if (_tmp271_) {
							_tmp268_ = TRUE;
						} else {
							const gchar* _tmp272_;
							gchar _tmp273_;
							_tmp272_ = _iter;
							_tmp273_ = string_get (_tmp272_, (glong) 0);
							_tmp268_ = _tmp273_ == '_';
						}
						if (!_tmp268_) {
							break;
						}
						_tmp274_ = _iter;
						_tmp275_ = string_offset (_tmp274_, (glong) 1);
						_iter = _tmp275_;
						_tmp276_ = self->priv->_skip;
						self->priv->_skip = _tmp276_ + 1;
					}
					_tmp277_ = valadoc_token_type_MARKDOWN_PARAMETER;
					_tmp278_ = self->priv->_index;
					_tmp279_ = self->priv->_skip;
					_tmp280_ = string_substring (_tmp278_, (glong) 1, (glong) _tmp279_);
					_tmp281_ = _tmp280_;
					valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp277_, _tmp281_, &_inner_error_);
					_g_free0 (_tmp281_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (hash);
							return;
						} else {
							_g_free0 (hash);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					break;
				} else {
					const gchar* _tmp282_;
					gboolean _tmp283_;
					_tmp282_ = self->priv->_index;
					_tmp283_ = g_str_has_prefix (_tmp282_, "@...");
					if (_tmp283_) {
						gint _tmp284_;
						ValadocTokenType* _tmp285_;
						_tmp284_ = self->priv->_skip;
						self->priv->_skip = _tmp284_ + 3;
						_tmp285_ = valadoc_token_type_MARKDOWN_PARAMETER;
						valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp285_, "...", &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (hash);
								return;
							} else {
								_g_free0 (hash);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
				}
			}
			_tmp286_ = c;
			valadoc_gtkdoc_markdown_scanner_append_char (self, _tmp286_);
			self->priv->contains_at = TRUE;
			break;
		}
		case '(':
		{
			gboolean _tmp287_ = FALSE;
			gunichar _tmp288_;
			ValadocTokenType* _tmp297_;
			_tmp288_ = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1);
			if (_tmp288_ == ((gunichar) ')')) {
				gboolean _tmp289_;
				_tmp289_ = valadoc_gtkdoc_markdown_scanner_is_id (self);
				_tmp287_ = _tmp289_;
			} else {
				_tmp287_ = FALSE;
			}
			if (_tmp287_) {
				gchar* id = NULL;
				GString* _tmp290_;
				const gchar* _tmp291_;
				gchar* _tmp292_;
				GString* _tmp293_;
				ValadocTokenType* _tmp294_;
				const gchar* _tmp295_;
				gint _tmp296_;
				_tmp290_ = self->priv->_current_string;
				_tmp291_ = _tmp290_->str;
				_tmp292_ = g_strdup (_tmp291_);
				id = _tmp292_;
				_tmp293_ = self->priv->_current_string;
				g_string_erase (_tmp293_, (gssize) 0, (gssize) -1);
				self->priv->contains_at = FALSE;
				_tmp294_ = valadoc_token_type_MARKDOWN_FUNCTION;
				_tmp295_ = id;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp294_, _tmp295_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (id);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (id);
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp296_ = self->priv->_skip;
				self->priv->_skip = _tmp296_ + 1;
				_g_free0 (id);
				break;
			}
			_tmp297_ = valadoc_token_type_MARKDOWN_OPEN_PARENS;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp297_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		case ')':
		{
			ValadocTokenType* _tmp298_;
			_tmp298_ = valadoc_token_type_MARKDOWN_CLOSE_PARENS;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp298_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		case '[':
		{
			const gchar* iter = NULL;
			const gchar* _tmp299_;
			gint count = 0;
			const gchar* _tmp313_;
			gchar _tmp314_;
			_tmp299_ = self->priv->_index;
			iter = _tmp299_;
			count = 1;
			while (TRUE) {
				gboolean _tmp300_ = FALSE;
				gboolean _tmp301_ = FALSE;
				const gchar* _tmp302_;
				gchar _tmp303_;
				const gchar* _tmp307_;
				const gchar* _tmp308_;
				const gchar* _tmp309_;
				gchar _tmp310_;
				_tmp302_ = iter;
				_tmp303_ = string_get (_tmp302_, (glong) 0);
				if (_tmp303_ != '\n') {
					const gchar* _tmp304_;
					gchar _tmp305_;
					_tmp304_ = iter;
					_tmp305_ = string_get (_tmp304_, (glong) 0);
					_tmp301_ = _tmp305_ != '\0';
				} else {
					_tmp301_ = FALSE;
				}
				if (_tmp301_) {
					gint _tmp306_;
					_tmp306_ = count;
					_tmp300_ = _tmp306_ > 0;
				} else {
					_tmp300_ = FALSE;
				}
				if (!_tmp300_) {
					break;
				}
				_tmp307_ = iter;
				_tmp308_ = string_offset (_tmp307_, (glong) 1);
				iter = _tmp308_;
				_tmp309_ = iter;
				_tmp310_ = string_get (_tmp309_, (glong) 0);
				switch (_tmp310_) {
					case '[':
					{
						gint _tmp311_;
						_tmp311_ = count;
						count = _tmp311_ + 1;
						break;
					}
					case ']':
					{
						gint _tmp312_;
						_tmp312_ = count;
						count = _tmp312_ - 1;
						break;
					}
					default:
					break;
				}
			}
			_tmp313_ = iter;
			_tmp314_ = string_get (_tmp313_, (glong) 0);
			if (_tmp314_ == ']') {
				ValadocTokenType* _tmp315_;
				_tmp315_ = valadoc_token_type_MARKDOWN_OPEN_BRACKET;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp315_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			} else {
				valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '[');
			}
			break;
		}
		case ']':
		{
			ValadocTokenType* _tmp316_;
			_tmp316_ = valadoc_token_type_MARKDOWN_CLOSE_BRACKET;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp316_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		case '<':
		{
			ValadocTokenType* _tmp317_;
			_tmp317_ = valadoc_token_type_MARKDOWN_LESS_THAN;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp317_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		case '>':
		{
			ValadocTokenType* _tmp318_;
			_tmp318_ = valadoc_token_type_MARKDOWN_GREATER_THAN;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp318_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		case '!':
		{
			ValadocTokenType* _tmp319_;
			_tmp319_ = valadoc_token_type_MARKDOWN_EXCLAMATION_MARK;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp319_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		case '|':
		{
			gunichar _tmp320_;
			gunichar _tmp332_;
			_tmp320_ = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1);
			if (_tmp320_ == ((gunichar) '[')) {
				const gchar* _iter = NULL;
				const gchar* _tmp321_;
				const gchar* _tmp322_;
				gint end = 0;
				const gchar* _tmp323_;
				gint _tmp324_;
				gint _tmp325_;
				_tmp321_ = self->priv->_index;
				_tmp322_ = string_offset (_tmp321_, (glong) 2);
				_iter = _tmp322_;
				_tmp323_ = _iter;
				_tmp324_ = string_index_of (_tmp323_, "]|", 0);
				end = _tmp324_;
				_tmp325_ = end;
				if (_tmp325_ < 0) {
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '|');
				} else {
					ValadocTokenType* _tmp326_;
					const gchar* _tmp327_;
					gint _tmp328_;
					gchar* _tmp329_;
					gchar* _tmp330_;
					gint _tmp331_;
					_tmp326_ = valadoc_token_type_MARKDOWN_SOURCE;
					_tmp327_ = self->priv->_index;
					_tmp328_ = end;
					_tmp329_ = string_substring (_tmp327_, (glong) 2, (glong) _tmp328_);
					_tmp330_ = _tmp329_;
					valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp326_, _tmp330_, &_inner_error_);
					_g_free0 (_tmp330_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (hash);
							return;
						} else {
							_g_free0 (hash);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp331_ = end;
					self->priv->_skip = _tmp331_ + 3;
				}
				break;
			}
			_tmp332_ = c;
			valadoc_gtkdoc_markdown_scanner_append_char (self, _tmp332_);
			break;
		}
		case '\t':
		case ' ':
		{
			const gchar* _iter = NULL;
			const gchar* _tmp333_;
			const gchar* _tmp334_;
			gint _tmp335_;
			gint _tmp336_;
			gboolean _tmp337_ = FALSE;
			const gchar* _tmp338_;
			gchar _tmp339_;
			_tmp333_ = self->priv->_index;
			_tmp334_ = string_offset (_tmp333_, (glong) 1);
			_iter = _tmp334_;
			_tmp335_ = self->priv->_skip;
			_tmp336_ = valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
			self->priv->_skip = _tmp335_ + _tmp336_;
			_tmp338_ = _iter;
			_tmp339_ = string_get (_tmp338_, (glong) 0);
			if (_tmp339_ != '\n') {
				const gchar* _tmp340_;
				gchar _tmp341_;
				_tmp340_ = _iter;
				_tmp341_ = string_get (_tmp340_, (glong) 0);
				_tmp337_ = _tmp341_ != '\0';
			} else {
				_tmp337_ = FALSE;
			}
			if (_tmp337_) {
				ValadocTokenType* _tmp342_;
				_tmp342_ = valadoc_token_type_MARKDOWN_SPACE;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp342_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			break;
		}
		case '\r':
		{
			break;
		}
		case '\n':
		{
			const gchar* _iter = NULL;
			const gchar* _tmp343_;
			const gchar* _tmp344_;
			gint _tmp345_;
			const gchar* _tmp346_;
			_tmp343_ = self->priv->_index;
			_tmp344_ = string_offset (_tmp343_, (glong) 1);
			_iter = _tmp344_;
			_tmp345_ = self->priv->_line;
			self->priv->_line = _tmp345_ + 1;
			self->priv->_column = 0;
			self->priv->_last_column = 0;
			_tmp346_ = _iter;
			valadoc_gtkdoc_markdown_scanner_handle_newline (self, _tmp346_, FALSE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		default:
		{
			gunichar _tmp347_;
			_tmp347_ = c;
			valadoc_gtkdoc_markdown_scanner_append_char (self, _tmp347_);
			break;
		}
	}
	_g_free0 (hash);
}


static gboolean valadoc_gtkdoc_markdown_scanner_handle_newline (ValadocGtkdocMarkdownScanner* self, const gchar* _iter, gboolean is_paragraph, GError** error) {
	gboolean result = FALSE;
	gint leading_spaces = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar _tmp2_;
	gboolean _tmp3_;
	gboolean in_block = FALSE;
	ValaList* _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	gchar _tmp13_;
	gint list_token_len = 0;
	gboolean _tmp45_ = FALSE;
	const gchar* _tmp46_;
	gchar _tmp47_;
	gboolean is_unsorted_list = FALSE;
	gboolean is_sorted_list = FALSE;
	const gchar* _tmp51_;
	gint _tmp52_ = 0;
	gboolean _tmp53_;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_ = FALSE;
	const gchar* _tmp89_;
	gchar _tmp90_;
	gboolean _tmp126_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_iter != NULL, FALSE);
	_tmp0_ = valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
	leading_spaces = _tmp0_;
	_tmp1_ = _iter;
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '\0') {
		result = FALSE;
		return result;
	}
	_tmp3_ = is_paragraph;
	if (_tmp3_) {
		while (TRUE) {
			const gchar* _tmp4_;
			gchar _tmp5_;
			gint _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gint _tmp9_;
			_tmp4_ = _iter;
			_tmp5_ = string_get (_tmp4_, (glong) 0);
			if (!(_tmp5_ == '\n')) {
				break;
			}
			_tmp6_ = self->priv->_line;
			self->priv->_line = _tmp6_ + 1;
			_tmp7_ = _iter;
			_tmp8_ = string_offset (_tmp7_, (glong) 1);
			_iter = _tmp8_;
			_tmp9_ = valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
			leading_spaces = _tmp9_;
		}
	}
	_tmp10_ = self->priv->states;
	_tmp11_ = vala_collection_contains ((ValaCollection*) _tmp10_, (gpointer) ((gintptr) VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK));
	in_block = _tmp11_;
	_tmp12_ = _iter;
	_tmp13_ = string_get (_tmp12_, (glong) 0);
	if (_tmp13_ == '>') {
		gboolean _tmp14_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_;
		_tmp14_ = in_block;
		if (!_tmp14_) {
			gboolean _tmp17_;
			valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp15_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp15_;
				} else {
					gboolean _tmp16_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp16_;
				}
			}
			_tmp17_ = is_paragraph;
			if (_tmp17_) {
				gint _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				ValadocTokenType* _tmp23_;
				_tmp18_ = self->priv->_column;
				_tmp19_ = _iter;
				_tmp20_ = self->priv->_index;
				self->priv->_column = _tmp18_ + ((gint) (((gchar*) _tmp19_) - ((gchar*) _tmp20_)));
				_tmp21_ = _iter;
				_tmp22_ = string_offset (_tmp21_, (glong) 1);
				self->priv->_index = _tmp22_;
				_tmp23_ = valadoc_token_type_MARKDOWN_BLOCK_START;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp23_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						gboolean _tmp24_ = FALSE;
						g_propagate_error (error, _inner_error_);
						return _tmp24_;
					} else {
						gboolean _tmp25_ = FALSE;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp25_;
					}
				}
				valadoc_gtkdoc_markdown_scanner_push_state (self, VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK);
			}
		}
		_tmp27_ = in_block;
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp28_;
			_tmp28_ = is_paragraph;
			_tmp26_ = _tmp28_;
		}
		if (_tmp26_) {
			gint _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			_tmp29_ = self->priv->_column;
			self->priv->_column = _tmp29_ + 1;
			_tmp30_ = _iter;
			self->priv->_index = _tmp30_;
			_tmp31_ = _iter;
			_tmp32_ = string_offset (_tmp31_, (glong) 1);
			_iter = _tmp32_;
			valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
		}
	} else {
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_;
		_tmp34_ = in_block;
		if (_tmp34_) {
			gboolean _tmp35_;
			_tmp35_ = is_paragraph;
			_tmp33_ = _tmp35_;
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			gint _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			ValadocTokenType* _tmp42_;
			_tmp36_ = self->priv->_column;
			_tmp37_ = _iter;
			_tmp38_ = self->priv->_index;
			self->priv->_column = _tmp36_ + ((gint) (((gchar*) _tmp37_) - ((gchar*) _tmp38_)));
			_tmp39_ = _iter;
			self->priv->_index = _tmp39_;
			valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp40_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp40_;
				} else {
					gboolean _tmp41_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp41_;
				}
			}
			_tmp42_ = valadoc_token_type_MARKDOWN_BLOCK_END;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp42_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp43_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp43_;
				} else {
					gboolean _tmp44_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp44_;
				}
			}
			valadoc_gtkdoc_markdown_scanner_pop_state (self);
		}
	}
	list_token_len = 0;
	_tmp46_ = _iter;
	_tmp47_ = string_get (_tmp46_, (glong) 0);
	if (_tmp47_ == '-') {
		const gchar* _tmp48_;
		gchar _tmp49_;
		gboolean _tmp50_;
		_tmp48_ = _iter;
		_tmp49_ = string_get (_tmp48_, (glong) 1);
		_tmp50_ = g_ascii_isspace (_tmp49_);
		_tmp45_ = _tmp50_;
	} else {
		_tmp45_ = FALSE;
	}
	is_unsorted_list = _tmp45_;
	_tmp51_ = _iter;
	_tmp53_ = valadoc_gtkdoc_markdown_scanner_is_ordered_list (self, _tmp51_, &_tmp52_);
	list_token_len = _tmp52_;
	is_sorted_list = _tmp53_;
	_tmp56_ = is_unsorted_list;
	if (_tmp56_) {
		_tmp55_ = TRUE;
	} else {
		gboolean _tmp57_;
		_tmp57_ = is_sorted_list;
		_tmp55_ = _tmp57_;
	}
	if (_tmp55_) {
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
		gboolean _tmp60_;
		_tmp60_ = is_paragraph;
		if (_tmp60_) {
			_tmp59_ = TRUE;
		} else {
			ValaList* _tmp61_;
			gboolean _tmp62_;
			_tmp61_ = self->priv->states;
			_tmp62_ = vala_collection_contains ((ValaCollection*) _tmp61_, (gpointer) ((gintptr) VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST));
			_tmp59_ = _tmp62_;
		}
		if (_tmp59_) {
			_tmp58_ = TRUE;
		} else {
			ValaList* _tmp63_;
			gboolean _tmp64_;
			_tmp63_ = self->priv->states;
			_tmp64_ = vala_collection_contains ((ValaCollection*) _tmp63_, (gpointer) ((gintptr) VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST));
			_tmp58_ = _tmp64_;
		}
		_tmp54_ = _tmp58_;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		ValadocTokenType* start_token = NULL;
		ValadocTokenType* _tmp65_;
		ValadocTokenType* _tmp66_;
		ValadocGtkdocMarkdownScannerState new_state = 0;
		gboolean _tmp67_;
		const gchar* _tmp70_;
		gint _tmp71_;
		const gchar* _tmp72_;
		gint _tmp75_;
		const gchar* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		const gchar* _tmp79_;
		ValadocTokenType* _tmp80_;
		ValadocGtkdocMarkdownScannerState _tmp83_;
		ValadocTokenType* _tmp84_;
		_tmp65_ = valadoc_token_type_MARKDOWN_ORDERED_LIST_ITEM_START;
		_tmp66_ = _g_object_ref0 (_tmp65_);
		start_token = _tmp66_;
		new_state = VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST;
		_tmp67_ = is_unsorted_list;
		if (_tmp67_) {
			ValadocTokenType* _tmp68_;
			ValadocTokenType* _tmp69_;
			_tmp68_ = valadoc_token_type_MARKDOWN_UNORDERED_LIST_ITEM_START;
			_tmp69_ = _g_object_ref0 (_tmp68_);
			_g_object_unref0 (start_token);
			start_token = _tmp69_;
			new_state = VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST;
			list_token_len = 2;
		}
		_tmp70_ = _iter;
		_tmp71_ = list_token_len;
		_tmp72_ = string_offset (_tmp70_, (glong) _tmp71_);
		_iter = _tmp72_;
		valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp73_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (start_token);
				return _tmp73_;
			} else {
				gboolean _tmp74_ = FALSE;
				_g_object_unref0 (start_token);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp74_;
			}
		}
		valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
		_tmp75_ = self->priv->_column;
		_tmp76_ = _iter;
		_tmp77_ = self->priv->_index;
		self->priv->_column = _tmp75_ + ((gint) (((gchar*) _tmp76_) - ((gchar*) _tmp77_)));
		_tmp78_ = _iter;
		_tmp79_ = string_offset (_tmp78_, (glong) -1);
		self->priv->_index = _tmp79_;
		_tmp80_ = start_token;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp80_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp81_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (start_token);
				return _tmp81_;
			} else {
				gboolean _tmp82_ = FALSE;
				_g_object_unref0 (start_token);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp82_;
			}
		}
		_tmp83_ = new_state;
		valadoc_gtkdoc_markdown_scanner_push_state (self, _tmp83_);
		_tmp84_ = valadoc_token_type_MARKDOWN_PARAGRAPH;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp84_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp85_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (start_token);
				return _tmp85_;
			} else {
				gboolean _tmp86_ = FALSE;
				_g_object_unref0 (start_token);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp86_;
			}
		}
		result = TRUE;
		_g_object_unref0 (start_token);
		return result;
	}
	_tmp89_ = _iter;
	_tmp90_ = string_get (_tmp89_, (glong) 0);
	if (_tmp90_ == '#') {
		const gchar* _tmp91_;
		gchar _tmp92_;
		gboolean _tmp93_;
		_tmp91_ = _iter;
		_tmp92_ = string_get (_tmp91_, (glong) 1);
		_tmp93_ = g_ascii_isspace (_tmp92_);
		_tmp88_ = _tmp93_;
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		_tmp87_ = TRUE;
	} else {
		gboolean _tmp94_ = FALSE;
		gboolean _tmp95_ = FALSE;
		gboolean _tmp96_ = FALSE;
		const gchar* _tmp97_;
		gchar _tmp98_;
		_tmp97_ = _iter;
		_tmp98_ = string_get (_tmp97_, (glong) 0);
		if (_tmp98_ == '#') {
			const gchar* _tmp99_;
			gchar _tmp100_;
			_tmp99_ = _iter;
			_tmp100_ = string_get (_tmp99_, (glong) 1);
			_tmp96_ = _tmp100_ == '#';
		} else {
			_tmp96_ = FALSE;
		}
		if (_tmp96_) {
			const gchar* _tmp101_;
			gchar _tmp102_;
			gboolean _tmp103_;
			_tmp101_ = _iter;
			_tmp102_ = string_get (_tmp101_, (glong) 2);
			_tmp103_ = g_ascii_isspace (_tmp102_);
			_tmp95_ = _tmp103_;
		} else {
			_tmp95_ = FALSE;
		}
		if (_tmp95_) {
			gboolean _tmp104_;
			_tmp104_ = is_paragraph;
			_tmp94_ = _tmp104_;
		} else {
			_tmp94_ = FALSE;
		}
		_tmp87_ = _tmp94_;
	}
	if (_tmp87_) {
		const gchar* _tmp107_;
		gchar _tmp108_;
		gint _tmp121_;
		const gchar* _tmp122_;
		const gchar* _tmp123_;
		const gchar* _tmp124_;
		const gchar* _tmp125_;
		valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp105_ = FALSE;
				g_propagate_error (error, _inner_error_);
				return _tmp105_;
			} else {
				gboolean _tmp106_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp106_;
			}
		}
		_tmp107_ = _iter;
		_tmp108_ = string_get (_tmp107_, (glong) 1);
		if (_tmp108_ != '#') {
			const gchar* _tmp109_;
			const gchar* _tmp110_;
			ValadocTokenType* _tmp111_;
			gchar* _tmp114_;
			_tmp109_ = _iter;
			_tmp110_ = string_offset (_tmp109_, (glong) 1);
			_iter = _tmp110_;
			_tmp111_ = valadoc_token_type_MARKDOWN_HEADLINE_1;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp111_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp112_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp112_;
				} else {
					gboolean _tmp113_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp113_;
				}
			}
			_tmp114_ = g_strdup ("#");
			_g_free0 (self->priv->headline_end);
			self->priv->headline_end = _tmp114_;
		} else {
			ValadocTokenType* _tmp115_;
			const gchar* _tmp118_;
			const gchar* _tmp119_;
			gchar* _tmp120_;
			_tmp115_ = valadoc_token_type_MARKDOWN_HEADLINE_2;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp115_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp116_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp116_;
				} else {
					gboolean _tmp117_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp117_;
				}
			}
			_tmp118_ = _iter;
			_tmp119_ = string_offset (_tmp118_, (glong) 2);
			_iter = _tmp119_;
			_tmp120_ = g_strdup ("##");
			_g_free0 (self->priv->headline_end);
			self->priv->headline_end = _tmp120_;
		}
		_tmp121_ = self->priv->_column;
		_tmp122_ = _iter;
		_tmp123_ = self->priv->_index;
		self->priv->_column = _tmp121_ + ((gint) (((gchar*) _tmp122_) - ((gchar*) _tmp123_)));
		_tmp124_ = _iter;
		_tmp125_ = string_offset (_tmp124_, (glong) -1);
		self->priv->_index = _tmp125_;
		result = TRUE;
		return result;
	}
	_tmp126_ = is_paragraph;
	if (_tmp126_) {
		gint _tmp127_;
		gint _tmp130_;
		const gchar* _tmp131_;
		const gchar* _tmp132_;
		const gchar* _tmp133_;
		const gchar* _tmp134_;
		ValadocTokenType* _tmp135_;
		_tmp127_ = leading_spaces;
		if (_tmp127_ == 0) {
			valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp128_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp128_;
				} else {
					gboolean _tmp129_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp129_;
				}
			}
		}
		_tmp130_ = self->priv->_column;
		_tmp131_ = _iter;
		_tmp132_ = self->priv->_index;
		self->priv->_column = _tmp130_ + ((gint) (((gchar*) _tmp131_) - ((gchar*) _tmp132_)));
		_tmp133_ = _iter;
		_tmp134_ = string_offset (_tmp133_, (glong) -1);
		self->priv->_index = _tmp134_;
		_tmp135_ = valadoc_token_type_MARKDOWN_PARAGRAPH;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp135_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp136_ = FALSE;
				g_propagate_error (error, _inner_error_);
				return _tmp136_;
			} else {
				gboolean _tmp137_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp137_;
			}
		}
	} else {
		const gchar* _tmp138_;
		gchar _tmp139_;
		_tmp138_ = _iter;
		_tmp139_ = string_get (_tmp138_, (glong) 0);
		if (_tmp139_ == '\n') {
			gint _tmp140_;
			const gchar* _tmp141_;
			const gchar* _tmp142_;
			_tmp140_ = self->priv->_line;
			self->priv->_line = _tmp140_ + 1;
			self->priv->_column = 0;
			self->priv->_last_column = 0;
			_tmp141_ = _iter;
			_tmp142_ = string_offset (_tmp141_, (glong) 1);
			valadoc_gtkdoc_markdown_scanner_handle_newline (self, _tmp142_, TRUE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp143_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp143_;
				} else {
					gboolean _tmp144_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp144_;
				}
			}
		} else {
			ValadocTokenType* _tmp145_;
			_tmp145_ = valadoc_token_type_MARKDOWN_SPACE;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp145_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp146_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp146_;
				} else {
					gboolean _tmp147_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp147_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean valadoc_gtkdoc_markdown_scanner_is_headline_end (ValadocGtkdocMarkdownScanner* self, const gchar* * iter, const gchar* separator, gchar* * hash) {
	gchar* _vala_hash = NULL;
	gboolean result = FALSE;
	const gchar* _iter = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar _tmp3_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	gchar _tmp17_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* id_start = NULL;
	const gchar* _tmp26_;
	gint hash_len = 0;
	const gchar* _tmp38_;
	gchar _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gboolean _tmp42_ = FALSE;
	const gchar* _tmp43_;
	gchar _tmp44_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (*iter != NULL, FALSE);
	g_return_val_if_fail (separator != NULL, FALSE);
	_tmp0_ = *iter;
	_iter = _tmp0_;
	_g_free0 (_vala_hash);
	_vala_hash = NULL;
	_tmp2_ = _iter;
	_tmp3_ = string_get (_tmp2_, (glong) 0);
	if (_tmp3_ == '\n') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = _iter;
		_tmp5_ = string_get (_tmp4_, (glong) 0);
		_tmp1_ = _tmp5_ == '\0';
	}
	if (_tmp1_) {
		gint _tmp6_;
		_tmp6_ = self->priv->_line;
		self->priv->_line = _tmp6_ + 1;
		result = TRUE;
		if (hash) {
			*hash = _vala_hash;
		} else {
			_g_free0 (_vala_hash);
		}
		return result;
	}
	_tmp7_ = _iter;
	_tmp8_ = separator;
	_tmp9_ = g_str_has_prefix (_tmp7_, _tmp8_);
	if (!_tmp9_) {
		result = FALSE;
		if (hash) {
			*hash = _vala_hash;
		} else {
			_g_free0 (_vala_hash);
		}
		return result;
	}
	_tmp10_ = _iter;
	_tmp11_ = separator;
	_tmp12_ = strlen (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = string_offset (_tmp10_, (glong) _tmp13_);
	_iter = _tmp14_;
	valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
	_tmp16_ = _iter;
	_tmp17_ = string_get (_tmp16_, (glong) 0);
	if (_tmp17_ == '\n') {
		_tmp15_ = TRUE;
	} else {
		const gchar* _tmp18_;
		gchar _tmp19_;
		_tmp18_ = _iter;
		_tmp19_ = string_get (_tmp18_, (glong) 0);
		_tmp15_ = _tmp19_ == '\0';
	}
	if (_tmp15_) {
		const gchar* _tmp20_;
		gint _tmp21_;
		_tmp20_ = _iter;
		*iter = _tmp20_;
		_tmp21_ = self->priv->_line;
		self->priv->_line = _tmp21_ + 1;
		result = TRUE;
		if (hash) {
			*hash = _vala_hash;
		} else {
			_g_free0 (_vala_hash);
		}
		return result;
	} else {
		const gchar* _tmp22_;
		gboolean _tmp23_;
		_tmp22_ = _iter;
		_tmp23_ = g_str_has_prefix (_tmp22_, "{#");
		if (!_tmp23_) {
			result = FALSE;
			if (hash) {
				*hash = _vala_hash;
			} else {
				_g_free0 (_vala_hash);
			}
			return result;
		}
	}
	_tmp24_ = _iter;
	_tmp25_ = string_offset (_tmp24_, (glong) 2);
	_iter = _tmp25_;
	_tmp26_ = _iter;
	id_start = _tmp26_;
	hash_len = 0;
	while (TRUE) {
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		gchar _tmp30_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		_tmp29_ = _iter;
		_tmp30_ = string_get (_tmp29_, (glong) 0);
		if (_tmp30_ != '}') {
			const gchar* _tmp31_;
			gchar _tmp32_;
			_tmp31_ = _iter;
			_tmp32_ = string_get (_tmp31_, (glong) 0);
			_tmp28_ = _tmp32_ != '\n';
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			const gchar* _tmp33_;
			gchar _tmp34_;
			_tmp33_ = _iter;
			_tmp34_ = string_get (_tmp33_, (glong) 0);
			_tmp27_ = _tmp34_ != '\0';
		} else {
			_tmp27_ = FALSE;
		}
		if (!_tmp27_) {
			break;
		}
		_tmp35_ = _iter;
		_tmp36_ = string_offset (_tmp35_, (glong) 1);
		_iter = _tmp36_;
		_tmp37_ = hash_len;
		hash_len = _tmp37_ + 1;
	}
	_tmp38_ = _iter;
	_tmp39_ = string_get (_tmp38_, (glong) 0);
	if (_tmp39_ != '}') {
		result = FALSE;
		if (hash) {
			*hash = _vala_hash;
		} else {
			_g_free0 (_vala_hash);
		}
		return result;
	}
	_tmp40_ = _iter;
	_tmp41_ = string_offset (_tmp40_, (glong) 1);
	_iter = _tmp41_;
	valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
	_tmp43_ = _iter;
	_tmp44_ = string_get (_tmp43_, (glong) 0);
	if (_tmp44_ == '\n') {
		_tmp42_ = TRUE;
	} else {
		const gchar* _tmp45_;
		gchar _tmp46_;
		_tmp45_ = _iter;
		_tmp46_ = string_get (_tmp45_, (glong) 0);
		_tmp42_ = _tmp46_ == '\0';
	}
	if (_tmp42_) {
		const gchar* _tmp47_;
		gint _tmp48_;
		gchar* _tmp49_;
		const gchar* _tmp50_;
		gint _tmp51_;
		_tmp47_ = id_start;
		_tmp48_ = hash_len;
		_tmp49_ = string_substring (_tmp47_, (glong) 0, (glong) _tmp48_);
		_g_free0 (_vala_hash);
		_vala_hash = _tmp49_;
		_tmp50_ = _iter;
		*iter = _tmp50_;
		_tmp51_ = self->priv->_line;
		self->priv->_line = _tmp51_ + 1;
		result = TRUE;
		if (hash) {
			*hash = _vala_hash;
		} else {
			_g_free0 (_vala_hash);
		}
		return result;
	}
	result = FALSE;
	if (hash) {
		*hash = _vala_hash;
	} else {
		_g_free0 (_vala_hash);
	}
	return result;
}


static gboolean valadoc_gtkdoc_markdown_scanner_is_ordered_list (ValadocGtkdocMarkdownScanner* self, const gchar* iter, gint* numeric_prefix_count) {
	gint _vala_numeric_prefix_count = 0;
	gboolean result = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_vala_numeric_prefix_count = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		gchar _tmp2_;
		gint _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp1_ = iter;
		_tmp2_ = string_get (_tmp1_, (glong) 0);
		if (_tmp2_ >= '0') {
			const gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = iter;
			_tmp4_ = string_get (_tmp3_, (glong) 0);
			_tmp0_ = _tmp4_ <= '9';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = _vala_numeric_prefix_count;
		_vala_numeric_prefix_count = _tmp5_ + 1;
		_tmp6_ = iter;
		_tmp7_ = string_offset (_tmp6_, (glong) 1);
		iter = _tmp7_;
	}
	_tmp10_ = _vala_numeric_prefix_count;
	if (_tmp10_ > 0) {
		const gchar* _tmp11_;
		gchar _tmp12_;
		_tmp11_ = iter;
		_tmp12_ = string_get (_tmp11_, (glong) 0);
		_tmp9_ = _tmp12_ == '.';
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp13_;
		gchar _tmp14_;
		gboolean _tmp15_;
		_tmp13_ = iter;
		_tmp14_ = string_get (_tmp13_, (glong) 1);
		_tmp15_ = g_ascii_isspace (_tmp14_);
		_tmp8_ = _tmp15_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gint _tmp16_;
		_tmp16_ = _vala_numeric_prefix_count;
		_vala_numeric_prefix_count = _tmp16_ + 1;
		result = TRUE;
		if (numeric_prefix_count) {
			*numeric_prefix_count = _vala_numeric_prefix_count;
		}
		return result;
	}
	result = FALSE;
	if (numeric_prefix_count) {
		*numeric_prefix_count = _vala_numeric_prefix_count;
	}
	return result;
}


static inline gint valadoc_gtkdoc_markdown_scanner_skip_spaces (ValadocGtkdocMarkdownScanner* self, const gchar* * _iter) {
	gint result = 0;
	gint count = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (*_iter != NULL, 0);
	count = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		gchar _tmp3_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		_tmp2_ = *_iter;
		_tmp3_ = string_get (_tmp2_, (glong) 0);
		if (_tmp3_ == ' ') {
			_tmp1_ = TRUE;
		} else {
			const gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = *_iter;
			_tmp5_ = string_get (_tmp4_, (glong) 0);
			_tmp1_ = _tmp5_ == '\t';
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			const gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = *_iter;
			_tmp7_ = string_get (_tmp6_, (glong) 0);
			_tmp0_ = _tmp7_ == '\r';
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = *_iter;
		_tmp9_ = string_offset (_tmp8_, (glong) 1);
		*_iter = _tmp9_;
		_tmp10_ = count;
		count = _tmp10_ + 1;
	}
	result = count;
	return result;
}


static gboolean valadoc_gtkdoc_markdown_scanner_close_block (ValadocGtkdocMarkdownScanner* self, GError** error) {
	gboolean result = FALSE;
	ValaList* _tmp0_;
	gpointer _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->states;
	_tmp1_ = vala_list_get (_tmp0_, 0);
	if (((ValadocGtkdocMarkdownScannerState) ((gintptr) _tmp1_)) == VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST) {
		ValadocTokenType* _tmp2_;
		_tmp2_ = valadoc_token_type_MARKDOWN_UNORDERED_LIST_ITEM_END;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp2_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp3_ = FALSE;
				g_propagate_error (error, _inner_error_);
				return _tmp3_;
			} else {
				gboolean _tmp4_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp4_;
			}
		}
		valadoc_gtkdoc_markdown_scanner_pop_state (self);
		result = TRUE;
		return result;
	} else {
		ValaList* _tmp5_;
		gpointer _tmp6_;
		_tmp5_ = self->priv->states;
		_tmp6_ = vala_list_get (_tmp5_, 0);
		if (((ValadocGtkdocMarkdownScannerState) ((gintptr) _tmp6_)) == VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST) {
			ValadocTokenType* _tmp7_;
			_tmp7_ = valadoc_token_type_MARKDOWN_ORDERED_LIST_ITEM_END;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp7_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp8_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp8_;
				} else {
					gboolean _tmp9_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp9_;
				}
			}
			valadoc_gtkdoc_markdown_scanner_pop_state (self);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static void valadoc_gtkdoc_markdown_scanner_real_end (ValadocScanner* base, GError** error) {
	ValadocGtkdocMarkdownScanner * self;
	ValadocTokenType* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (ValadocGtkdocMarkdownScanner*) base;
	_tmp0_ = valadoc_token_type_EOF;
	valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp0_, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void valadoc_gtkdoc_markdown_scanner_real_stop (ValadocScanner* base) {
	ValadocGtkdocMarkdownScanner * self;
	self = (ValadocGtkdocMarkdownScanner*) base;
	self->priv->_stop = TRUE;
}


static gchar* valadoc_gtkdoc_markdown_scanner_real_get_line_content (ValadocScanner* base) {
	ValadocGtkdocMarkdownScanner * self;
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* line_start = NULL;
	const gchar* _tmp1_;
	gunichar c = 0U;
	GString* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	self = (ValadocGtkdocMarkdownScanner*) base;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->priv->_index;
	line_start = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp3_ = line_start;
		_tmp4_ = self->priv->_content;
		if (((gchar*) _tmp3_) > ((gchar*) _tmp4_)) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gunichar _tmp7_;
			_tmp5_ = line_start;
			_tmp6_ = g_utf8_prev_char (_tmp5_);
			_tmp7_ = string_get_char (_tmp6_, (glong) 0);
			_tmp2_ = _tmp7_ != ((gunichar) '\n');
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp8_ = line_start;
		_tmp9_ = g_utf8_prev_char (_tmp8_);
		line_start = _tmp9_;
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		gunichar _tmp12_;
		gunichar _tmp13_;
		gunichar _tmp15_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp11_ = line_start;
		_tmp12_ = string_get_char (_tmp11_, (glong) 0);
		c = _tmp12_;
		_tmp13_ = c;
		if (_tmp13_ != ((gunichar) '\n')) {
			gunichar _tmp14_;
			_tmp14_ = c;
			_tmp10_ = _tmp14_ != ((gunichar) '\0');
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		_tmp15_ = c;
		if (_tmp15_ == ((gunichar) '\t')) {
			GString* _tmp16_;
			_tmp16_ = builder;
			g_string_append_c (_tmp16_, ' ');
		} else {
			GString* _tmp17_;
			gunichar _tmp18_;
			_tmp17_ = builder;
			_tmp18_ = c;
			g_string_append_unichar (_tmp17_, _tmp18_);
		}
		_tmp19_ = line_start;
		_tmp20_ = g_utf8_next_char (_tmp19_);
		line_start = _tmp20_;
	}
	_tmp21_ = builder;
	_tmp22_ = _tmp21_->str;
	_tmp23_ = g_strdup (_tmp22_);
	result = _tmp23_;
	_g_string_free0 (builder);
	return result;
}


static void valadoc_gtkdoc_markdown_scanner_emit_token (ValadocGtkdocMarkdownScanner* self, ValadocTokenType* type, const gchar* value, GError** error) {
	ValadocParser* _tmp0_;
	ValadocTokenType* _tmp1_;
	ValadocSourceLocation _tmp2_ = {0};
	gint _tmp3_;
	ValadocSourceLocation _tmp4_ = {0};
	const gchar* _tmp5_;
	ValadocToken* _tmp6_;
	ValadocToken* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	valadoc_gtkdoc_markdown_scanner_emit_current_word (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = self->priv->parser;
	_tmp1_ = type;
	valadoc_gtkdoc_markdown_scanner_get_begin (self, &_tmp2_);
	_tmp3_ = self->priv->_skip;
	valadoc_gtkdoc_markdown_scanner_get_end (self, _tmp3_, &_tmp4_);
	_tmp5_ = value;
	_tmp6_ = valadoc_token_new_from_type (_tmp1_, &_tmp2_, &_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	valadoc_parser_accept_token (_tmp0_, _tmp7_, &_inner_error_);
	_g_object_unref0 (_tmp7_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void valadoc_gtkdoc_markdown_scanner_emit_current_word (ValadocGtkdocMarkdownScanner* self, GError** error) {
	GString* _tmp0_;
	gssize _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_string;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((gssize) 0)) {
		gboolean _tmp2_;
		GString* _tmp35_;
		_tmp2_ = valadoc_gtkdoc_markdown_scanner_is_mail (self);
		if (_tmp2_) {
			ValadocParser* _tmp3_;
			ValadocTokenType* _tmp4_;
			ValadocSourceLocation _tmp5_ = {0};
			gint _tmp6_;
			ValadocSourceLocation _tmp7_ = {0};
			GString* _tmp8_;
			const gchar* _tmp9_;
			ValadocToken* _tmp10_;
			ValadocToken* _tmp11_;
			_tmp3_ = self->priv->parser;
			_tmp4_ = valadoc_token_type_MARKDOWN_MAIL;
			valadoc_gtkdoc_markdown_scanner_get_begin (self, &_tmp5_);
			_tmp6_ = self->priv->_skip;
			valadoc_gtkdoc_markdown_scanner_get_end (self, _tmp6_, &_tmp7_);
			_tmp8_ = self->priv->_current_string;
			_tmp9_ = _tmp8_->str;
			_tmp10_ = valadoc_token_new_from_type (_tmp4_, &_tmp5_, &_tmp7_, _tmp9_);
			_tmp11_ = _tmp10_;
			valadoc_parser_accept_token (_tmp3_, _tmp11_, &_inner_error_);
			_g_object_unref0 (_tmp11_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			gboolean _tmp12_ = FALSE;
			GString* _tmp13_;
			const gchar* _tmp14_;
			gboolean _tmp15_;
			_tmp13_ = self->priv->_current_string;
			_tmp14_ = _tmp13_->str;
			_tmp15_ = g_str_has_prefix (_tmp14_, "http://");
			if (_tmp15_) {
				_tmp12_ = TRUE;
			} else {
				GString* _tmp16_;
				const gchar* _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = self->priv->_current_string;
				_tmp17_ = _tmp16_->str;
				_tmp18_ = g_str_has_prefix (_tmp17_, "https://");
				_tmp12_ = _tmp18_;
			}
			if (_tmp12_) {
				ValadocParser* _tmp19_;
				ValadocTokenType* _tmp20_;
				ValadocSourceLocation _tmp21_ = {0};
				gint _tmp22_;
				ValadocSourceLocation _tmp23_ = {0};
				GString* _tmp24_;
				const gchar* _tmp25_;
				ValadocToken* _tmp26_;
				ValadocToken* _tmp27_;
				_tmp19_ = self->priv->parser;
				_tmp20_ = valadoc_token_type_MARKDOWN_LINK;
				valadoc_gtkdoc_markdown_scanner_get_begin (self, &_tmp21_);
				_tmp22_ = self->priv->_skip;
				valadoc_gtkdoc_markdown_scanner_get_end (self, _tmp22_, &_tmp23_);
				_tmp24_ = self->priv->_current_string;
				_tmp25_ = _tmp24_->str;
				_tmp26_ = valadoc_token_new_from_type (_tmp20_, &_tmp21_, &_tmp23_, _tmp25_);
				_tmp27_ = _tmp26_;
				valadoc_parser_accept_token (_tmp19_, _tmp27_, &_inner_error_);
				_g_object_unref0 (_tmp27_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			} else {
				ValadocParser* _tmp28_;
				GString* _tmp29_;
				const gchar* _tmp30_;
				ValadocSourceLocation _tmp31_ = {0};
				ValadocSourceLocation _tmp32_ = {0};
				ValadocToken* _tmp33_;
				ValadocToken* _tmp34_;
				_tmp28_ = self->priv->parser;
				_tmp29_ = self->priv->_current_string;
				_tmp30_ = _tmp29_->str;
				valadoc_gtkdoc_markdown_scanner_get_begin (self, &_tmp31_);
				valadoc_gtkdoc_markdown_scanner_get_end (self, -1, &_tmp32_);
				_tmp33_ = valadoc_token_new_from_word (_tmp30_, &_tmp31_, &_tmp32_);
				_tmp34_ = _tmp33_;
				valadoc_parser_accept_token (_tmp28_, _tmp34_, &_inner_error_);
				_g_object_unref0 (_tmp34_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		_tmp35_ = self->priv->_current_string;
		g_string_erase (_tmp35_, (gssize) 0, (gssize) -1);
		self->priv->contains_at = FALSE;
	}
}


static void valadoc_gtkdoc_markdown_scanner_get_begin (ValadocGtkdocMarkdownScanner* self, ValadocSourceLocation* result) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValadocSourceLocation _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_last_line;
	_tmp1_ = valadoc_gtkdoc_markdown_scanner_get_line_start_column (self);
	_tmp2_ = self->priv->_last_column;
	valadoc_source_location_init (&_tmp3_, _tmp0_, _tmp1_ + _tmp2_);
	*result = _tmp3_;
	return;
}


static void valadoc_gtkdoc_markdown_scanner_get_end (ValadocGtkdocMarkdownScanner* self, gint offset, ValadocSourceLocation* result) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValadocSourceLocation _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_line;
	_tmp1_ = valadoc_gtkdoc_markdown_scanner_get_line_start_column (self);
	_tmp2_ = self->priv->_column;
	_tmp3_ = offset;
	valadoc_source_location_init (&_tmp4_, _tmp0_, (_tmp1_ + _tmp2_) + _tmp3_);
	*result = _tmp4_;
	return;
}


gint valadoc_gtkdoc_markdown_scanner_get_line_start_column (ValadocGtkdocMarkdownScanner* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = 0;
	return result;
}


static void valadoc_gtkdoc_markdown_scanner_append_char (ValadocGtkdocMarkdownScanner* self, gunichar c) {
	GString* _tmp0_;
	gunichar _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_string;
	_tmp1_ = c;
	g_string_append_unichar (_tmp0_, _tmp1_);
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static gunichar valadoc_gtkdoc_markdown_scanner_get_next_char (ValadocGtkdocMarkdownScanner* self, gint offset) {
	gunichar result = 0U;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gunichar _tmp4_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_index;
	_tmp1_ = self->priv->_index;
	_tmp2_ = offset;
	_tmp3_ = string_index_of_nth_char (_tmp1_, (glong) _tmp2_);
	_tmp4_ = string_get_char (_tmp0_, (glong) _tmp3_);
	result = _tmp4_;
	return result;
}


static inline gboolean valadoc_gtkdoc_markdown_scanner_is_mail (ValadocGtkdocMarkdownScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->contains_at;
	if (_tmp1_) {
		GRegex* _tmp2_;
		GString* _tmp3_;
		const gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->regex_mail;
		_tmp3_ = self->priv->_current_string;
		_tmp4_ = _tmp3_->str;
		_tmp5_ = g_regex_match (_tmp2_, _tmp4_, 0, NULL);
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean valadoc_gtkdoc_markdown_scanner_is_id (ValadocGtkdocMarkdownScanner* self) {
	gboolean result = FALSE;
	GString* _tmp0_;
	gssize _tmp1_;
	gboolean _tmp2_ = FALSE;
	GString* _tmp3_;
	const gchar* _tmp4_;
	gchar _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_string;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ == ((gssize) 0)) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->_current_string;
	_tmp4_ = _tmp3_->str;
	_tmp5_ = string_get (_tmp4_, (glong) 0);
	_tmp6_ = g_ascii_isalpha (_tmp5_);
	if (_tmp6_ == FALSE) {
		GString* _tmp7_;
		const gchar* _tmp8_;
		gchar _tmp9_;
		_tmp7_ = self->priv->_current_string;
		_tmp8_ = _tmp7_->str;
		_tmp9_ = string_get (_tmp8_, (glong) 0);
		_tmp2_ = _tmp9_ != '_';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint _tmp12_;
				GString* _tmp13_;
				gssize _tmp14_;
				gboolean _tmp15_ = FALSE;
				GString* _tmp16_;
				const gchar* _tmp17_;
				gint _tmp18_;
				gchar _tmp19_;
				gboolean _tmp20_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = self->priv->_current_string;
				_tmp14_ = _tmp13_->len;
				if (!(((gssize) _tmp12_) < _tmp14_)) {
					break;
				}
				_tmp16_ = self->priv->_current_string;
				_tmp17_ = _tmp16_->str;
				_tmp18_ = i;
				_tmp19_ = string_get (_tmp17_, (glong) _tmp18_);
				_tmp20_ = g_ascii_isalnum (_tmp19_);
				if (_tmp20_ == FALSE) {
					GString* _tmp21_;
					const gchar* _tmp22_;
					gint _tmp23_;
					gchar _tmp24_;
					_tmp21_ = self->priv->_current_string;
					_tmp22_ = _tmp21_->str;
					_tmp23_ = i;
					_tmp24_ = string_get (_tmp22_, (glong) _tmp23_);
					_tmp15_ = _tmp24_ != '_';
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void valadoc_gtkdoc_markdown_scanner_class_init (ValadocGtkdocMarkdownScannerClass * klass) {
	valadoc_gtkdoc_markdown_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocGtkdocMarkdownScannerPrivate));
	G_OBJECT_CLASS (klass)->finalize = valadoc_gtkdoc_markdown_scanner_finalize;
}


static void valadoc_gtkdoc_markdown_scanner_valadoc_scanner_interface_init (ValadocScannerIface * iface) {
	valadoc_gtkdoc_markdown_scanner_valadoc_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_parser = (void (*) (ValadocScanner *, ValadocParser*)) valadoc_gtkdoc_markdown_scanner_real_set_parser;
	iface->reset = (void (*) (ValadocScanner *)) valadoc_gtkdoc_markdown_scanner_real_reset;
	iface->scan = (void (*) (ValadocScanner *, const gchar*, GError**)) valadoc_gtkdoc_markdown_scanner_real_scan;
	iface->end = (void (*) (ValadocScanner *, GError**)) valadoc_gtkdoc_markdown_scanner_real_end;
	iface->stop = (void (*) (ValadocScanner *)) valadoc_gtkdoc_markdown_scanner_real_stop;
	iface->get_line_content = (gchar* (*) (ValadocScanner *)) valadoc_gtkdoc_markdown_scanner_real_get_line_content;
}


static void valadoc_gtkdoc_markdown_scanner_instance_init (ValadocGtkdocMarkdownScanner * self) {
	GString* _tmp0_;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	self->priv = VALADOC_GTKDOC_MARKDOWN_SCANNER_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->_current_string = _tmp0_;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALADOC_GTKDOC_MARKDOWN_SCANNER_TYPE_STATE, NULL, NULL, _tmp1_);
	self->priv->states = (ValaList*) _tmp2_;
}


static void valadoc_gtkdoc_markdown_scanner_finalize (GObject * obj) {
	ValadocGtkdocMarkdownScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_MARKDOWN_SCANNER, ValadocGtkdocMarkdownScanner);
	_g_object_unref0 (self->priv->_settings);
	_valadoc_parser_unref0 (self->priv->parser);
	_g_string_free0 (self->priv->_current_string);
	_g_free0 (self->priv->headline_end);
	_g_regex_unref0 (self->priv->regex_mail);
	_vala_iterable_unref0 (self->priv->states);
	G_OBJECT_CLASS (valadoc_gtkdoc_markdown_scanner_parent_class)->finalize (obj);
}


GType valadoc_gtkdoc_markdown_scanner_get_type (void) {
	static volatile gsize valadoc_gtkdoc_markdown_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_markdown_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocMarkdownScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_markdown_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocMarkdownScanner), 0, (GInstanceInitFunc) valadoc_gtkdoc_markdown_scanner_instance_init, NULL };
		static const GInterfaceInfo valadoc_scanner_info = { (GInterfaceInitFunc) valadoc_gtkdoc_markdown_scanner_valadoc_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_gtkdoc_markdown_scanner_type_id;
		valadoc_gtkdoc_markdown_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocGtkdocMarkdownScanner", &g_define_type_info, 0);
		g_type_add_interface_static (valadoc_gtkdoc_markdown_scanner_type_id, VALADOC_TYPE_SCANNER, &valadoc_scanner_info);
		g_once_init_leave (&valadoc_gtkdoc_markdown_scanner_type_id__volatile, valadoc_gtkdoc_markdown_scanner_type_id);
	}
	return valadoc_gtkdoc_markdown_scanner_type_id__volatile;
}



