/* tracker-backend.c generated by valac 0.36.4, the Vala compiler
 * generated from tracker-backend.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-common/tracker-domain-ontology.h"
#include "libtracker-sparql/tracker-sparql.h"
#include <gio/gio.h>
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-bus/tracker-bus.h"
#include "libtracker-remote/tracker-remote.h"


#define TRACKER_SPARQL_TYPE_BACKEND (tracker_sparql_backend_get_type ())
#define TRACKER_SPARQL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend))
#define TRACKER_SPARQL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))
#define TRACKER_SPARQL_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))

typedef struct _TrackerSparqlBackend TrackerSparqlBackend;
typedef struct _TrackerSparqlBackendClass TrackerSparqlBackendClass;
typedef struct _TrackerSparqlBackendPrivate TrackerSparqlBackendPrivate;

#define TRACKER_SPARQL_BACKEND_TYPE_BACKEND (tracker_sparql_backend_backend_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlBackendQueryAsyncData TrackerSparqlBackendQueryAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateAsyncData TrackerSparqlBackendUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateArrayAsyncData TrackerSparqlBackendUpdateArrayAsyncData;
typedef struct _TrackerSparqlBackendUpdateBlankAsyncData TrackerSparqlBackendUpdateBlankAsyncData;
typedef struct _TrackerSparqlBackendLoadAsyncData TrackerSparqlBackendLoadAsyncData;
typedef struct _TrackerSparqlBackendStatisticsAsyncData TrackerSparqlBackendStatisticsAsyncData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _TrackerSparqlBackendGetInternalAsyncData TrackerSparqlBackendGetInternalAsyncData;
typedef struct _TrackerSparqlConnectionGetAsyncData TrackerSparqlConnectionGetAsyncData;
typedef struct _TrackerSparqlConnectionLocalNewAsyncData TrackerSparqlConnectionLocalNewAsyncData;

struct _TrackerSparqlBackend {
	TrackerSparqlConnection parent_instance;
	TrackerSparqlBackendPrivate * priv;
};

struct _TrackerSparqlBackendClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerSparqlBackendPrivate {
	gboolean initialized;
	TrackerSparqlConnection* direct;
	TrackerSparqlConnection* bus;
};

typedef enum  {
	TRACKER_SPARQL_BACKEND_BACKEND_AUTO,
	TRACKER_SPARQL_BACKEND_BACKEND_DIRECT,
	TRACKER_SPARQL_BACKEND_BACKEND_BUS
} TrackerSparqlBackendBackend;

struct _TrackerSparqlBackendQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	const gchar* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	const gchar* _tmp4_;
	GCancellable* _tmp5_;
	TrackerSparqlCursor* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	TrackerSparqlCursor* _tmp8_;
	TrackerSparqlConnection* _tmp9_;
	const gchar* _tmp10_;
	GCancellable* _tmp11_;
	TrackerSparqlCursor* _tmp12_;
	TrackerSparqlCursor* _tmp13_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	gint _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	GCancellable* _tmp7_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	GPtrArray* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	GCancellable* _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* _tmp8_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	gint _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _tmp3_;
	GVariant* _tmp4_;
	TrackerSparqlConnection* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	GCancellable* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	GFile* file;
	GCancellable* cancellable;
	gchar* uri;
	GFile* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GError* _tmp4_;
	TrackerSparqlConnection* _tmp5_;
	GFile* _tmp6_;
	GCancellable* _tmp7_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GCancellable* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	TrackerSparqlCursor* _tmp6_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* async_result;
};

struct _Block2Data {
	int _ref_count_;
	GError* sparql_error;
	GError* io_error;
	GError* dbus_error;
	GError* spawn_error;
	TrackerSparqlConnection* _result_;
	GMainContext* context;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _TrackerSparqlBackendGetInternalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	Block2Data* _data2_;
	GCancellable* _tmp0_;
	gboolean _tmp1_;
	TrackerSparqlConnection* _result_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	GMainContext* _tmp5_;
	GMainContext* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	TrackerSparqlConnection* _tmp19_;
	TrackerSparqlConnection* _tmp20_;
	GError * _inner_error_;
};

struct _TrackerSparqlConnectionGetAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
	GCancellable* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GError * _inner_error_;
};

struct _TrackerSparqlConnectionLocalNewAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnectionFlags flags;
	GFile* store;
	GFile* journal;
	GFile* ontology;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerDirectConnection* conn;
	TrackerSparqlConnectionFlags _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	TrackerDirectConnection* _tmp4_;
	GCancellable* _tmp5_;
	GError * _inner_error_;
};


extern gchar* domain_name;
gchar* domain_name = NULL;
extern TrackerDomainOntology* domain_ontology;
TrackerDomainOntology* domain_ontology = NULL;
static gpointer tracker_sparql_backend_parent_class = NULL;
static TrackerSparqlConnection* tracker_sparql_backend_singleton;
static TrackerSparqlConnection* tracker_sparql_backend_singleton = NULL;
static GMutex tracker_sparql_backend_door;
static GMutex tracker_sparql_backend_door = {0};

GType tracker_sparql_backend_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendPrivate))
enum  {
	TRACKER_SPARQL_BACKEND_DUMMY_PROPERTY
};
static GType tracker_sparql_backend_backend_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
TrackerSparqlBackend* tracker_sparql_backend_new (GError** error);
TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, GError** error);
static void tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, GError** error);
static void tracker_sparql_backend_real_dispose (GObject* base);
static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_query_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* _data_);
static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_update_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* _data_);
static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* _data_);
static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* _data_);
static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_load_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* _data_);
static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* _data_);
static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerNamespaceManager* tracker_sparql_backend_real_get_namespace_manager (TrackerSparqlConnection* base);
static TrackerSparqlConnection* tracker_sparql_backend_create_readonly_direct (TrackerSparqlBackend* self, GError** error);
static TrackerSparqlConnection* tracker_sparql_backend_get (GCancellable* cancellable, GError** error);
TrackerSparqlConnection* tracker_sparql_backend_get_internal (GCancellable* cancellable, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void tracker_sparql_backend_get_internal_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_, GError** error);
static void __lambda6_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tracker_sparql_backend_get_internal_async_data_free (gpointer _data);
static gboolean tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block2Data* _data2_, GIOSchedulerJob* job);
static gboolean __lambda5_ (Block2Data* _data2_);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean ___lambda4__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self);
static void tracker_sparql_backend_finalize (GObject * obj);
static void tracker_sparql_connection_get_async_data_free (gpointer _data);
void tracker_sparql_connection_get_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* _data_);
static void tracker_sparql_connection_get_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable, GError** error);
TrackerSparqlConnection* tracker_sparql_connection_remote_new (const gchar* url_base);
TrackerSparqlConnection* tracker_sparql_connection_local_new (TrackerSparqlConnectionFlags flags, GFile* store, GFile* journal, GFile* ontology, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_local_new_async_data_free (gpointer _data);
void tracker_sparql_connection_local_new_async (TrackerSparqlConnectionFlags flags, GFile* store, GFile* journal, GFile* ontology, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_local_new_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_local_new_async_co (TrackerSparqlConnectionLocalNewAsyncData* _data_);
void tracker_sparql_connection_set_domain (const gchar* domain);
gchar* tracker_sparql_connection_get_domain (void);


static GType tracker_sparql_backend_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_backend_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BACKEND_BACKEND_AUTO, "TRACKER_SPARQL_BACKEND_BACKEND_AUTO", "auto"}, {TRACKER_SPARQL_BACKEND_BACKEND_DIRECT, "TRACKER_SPARQL_BACKEND_BACKEND_DIRECT", "direct"}, {TRACKER_SPARQL_BACKEND_BACKEND_BUS, "TRACKER_SPARQL_BACKEND_BACKEND_BUS", "bus"}, {0, NULL, NULL}};
		GType tracker_sparql_backend_backend_type_id;
		tracker_sparql_backend_backend_type_id = g_enum_register_static ("TrackerSparqlBackendBackend", values);
		g_once_init_leave (&tracker_sparql_backend_backend_type_id__volatile, tracker_sparql_backend_backend_type_id);
	}
	return tracker_sparql_backend_backend_type_id__volatile;
}


TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, GError** error) {
	TrackerSparqlBackend * self = NULL;
	GError * _inner_error_ = NULL;
#line 33 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) tracker_sparql_connection_construct (object_type);
#line 409 "tracker-backend.c"
	{
		TrackerDomainOntology* _tmp0_ = NULL;
		const gchar* _tmp1_;
		TrackerDomainOntology* _tmp2_;
		TrackerDomainOntology* _tmp3_;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = domain_name;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = tracker_domain_ontology_new (_tmp1_, NULL, &_inner_error_);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = _tmp2_;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 423 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = _tmp0_;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = NULL;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (domain_ontology);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		domain_ontology = _tmp3_;
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		tracker_sparql_backend_load_plugins (self, &_inner_error_);
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp0_);
#line 440 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp0_);
#line 445 "tracker-backend.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e = _inner_error_;
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = e;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = _tmp4_->message;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp6_ = g_strconcat ("Failed to load SPARQL backend: ", _tmp5_, NULL);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp7_ = _tmp6_;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp7_);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = _tmp8_;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_free0 (_tmp7_);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp9_;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e);
#line 479 "tracker-backend.c"
		goto __finally0;
	}
	__finally0:
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 493 "tracker-backend.c"
		} else {
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 501 "tracker-backend.c"
		}
	}
#line 41 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv->initialized = TRUE;
#line 33 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self;
#line 508 "tracker-backend.c"
}


TrackerSparqlBackend* tracker_sparql_backend_new (GError** error) {
#line 33 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return tracker_sparql_backend_construct (TRACKER_SPARQL_TYPE_BACKEND, error);
#line 515 "tracker-backend.c"
}


static void tracker_sparql_backend_real_dispose (GObject* base) {
	TrackerSparqlBackend * self;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = self->priv->initialized;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_) {
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_mutex_lock (&tracker_sparql_backend_door);
#line 531 "tracker-backend.c"
		{
			TrackerSparqlConnection* _tmp1_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp1_ = tracker_sparql_backend_singleton;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection)) {
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				tracker_sparql_backend_singleton = NULL;
#line 540 "tracker-backend.c"
			}
		}
		__finally1:
		{
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_mutex_unlock (&tracker_sparql_backend_door);
#line 547 "tracker-backend.c"
		}
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 557 "tracker-backend.c"
		}
	}
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection));
#line 562 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	const gchar* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	GError * _inner_error_ = NULL;
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = sparql;
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.query", _tmp0_);
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = self->priv->direct;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp1_ != NULL) {
#line 584 "tracker-backend.c"
		TrackerSparqlCursor* _tmp2_ = NULL;
		TrackerSparqlConnection* _tmp3_;
		const gchar* _tmp4_;
		GCancellable* _tmp5_;
		TrackerSparqlCursor* _tmp6_;
		TrackerSparqlCursor* _tmp7_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = self->priv->direct;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = sparql;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = cancellable;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp6_ = tracker_sparql_connection_query (_tmp3_, _tmp4_, _tmp5_, &_inner_error_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = _tmp6_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 607 "tracker-backend.c"
		}
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp7_ = _tmp2_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = NULL;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp7_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp2_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 619 "tracker-backend.c"
	} else {
		TrackerSparqlCursor* _tmp8_ = NULL;
		TrackerSparqlConnection* _tmp9_;
		const gchar* _tmp10_;
		GCancellable* _tmp11_;
		TrackerSparqlCursor* _tmp12_;
		TrackerSparqlCursor* _tmp13_;
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = self->priv->bus;
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp10_ = sparql;
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp11_ = cancellable;
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp12_ = tracker_sparql_connection_query (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = _tmp12_;
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 643 "tracker-backend.c"
		}
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp13_ = _tmp8_;
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = NULL;
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp13_;
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp8_);
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 655 "tracker-backend.c"
	}
}


static void tracker_sparql_backend_real_query_async_data_free (gpointer _data) {
	TrackerSparqlBackendQueryAsyncData* _data_;
	_data_ = _data;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendQueryAsyncData, _data_);
#line 673 "tracker-backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 680 "tracker-backend.c"
}


static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendQueryAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendQueryAsyncData);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_query_async_data_free);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp2_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = cancellable;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp4_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_query_async_co (_data_);
#line 722 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendQueryAsyncData* _data_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 735 "tracker-backend.c"
	}
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 743 "tracker-backend.c"
}


static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendQueryAsyncData* _data_;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_query_async_co (_data_);
#line 757 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* _data_) {
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 766 "tracker-backend.c"
		goto _state_0;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 770 "tracker-backend.c"
		goto _state_1;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 2:
#line 774 "tracker-backend.c"
		goto _state_2;
		default:
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 779 "tracker-backend.c"
	}
	_state_0:
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->sparql;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.query_async", _data_->_tmp0_);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->self->priv->direct;
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp1_ != NULL) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = _data_->self->priv->direct;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = _data_->sparql;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp5_ = _data_->cancellable;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_state_ = 1;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		tracker_sparql_connection_query_async (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, tracker_sparql_backend_query_async_ready, _data_);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 802 "tracker-backend.c"
		_state_1:
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp6_ = tracker_sparql_connection_query_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp2_ = _data_->_tmp6_;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 816 "tracker-backend.c"
		}
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp7_ = _data_->_tmp2_;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp2_ = NULL;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->result = _data_->_tmp7_;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data_->_tmp2_);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_state_ != 0) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 834 "tracker-backend.c"
			}
		}
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 841 "tracker-backend.c"
	} else {
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp9_ = _data_->self->priv->bus;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp10_ = _data_->sparql;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp11_ = _data_->cancellable;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_state_ = 2;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		tracker_sparql_connection_query_async (_data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, tracker_sparql_backend_query_async_ready, _data_);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 855 "tracker-backend.c"
		_state_2:
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp12_ = tracker_sparql_connection_query_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = _data_->_tmp12_;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 869 "tracker-backend.c"
		}
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp13_ = _data_->_tmp8_;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = NULL;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->result = _data_->_tmp13_;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data_->_tmp8_);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_state_ != 0) {
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 887 "tracker-backend.c"
			}
		}
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 894 "tracker-backend.c"
	}
}


static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	gint _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	GCancellable* _tmp7_;
	GError * _inner_error_ = NULL;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (sparql != NULL);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = priority;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update", _tmp0_, _tmp1_);
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = self->priv->bus;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp2_ == NULL) {
#line 923 "tracker-backend.c"
		GError* _tmp3_;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp3_;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return;
#line 933 "tracker-backend.c"
	}
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = self->priv->bus;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = sparql;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = priority;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = cancellable;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update (_tmp4_, _tmp5_, _tmp6_, _tmp7_, &_inner_error_);
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return;
#line 951 "tracker-backend.c"
	}
}


static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	GVariant* result = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GVariant* _tmp4_ = NULL;
	TrackerSparqlConnection* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	GCancellable* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GError * _inner_error_ = NULL;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = priority;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank", _tmp0_, _tmp1_);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = self->priv->bus;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp2_ == NULL) {
#line 984 "tracker-backend.c"
		GError* _tmp3_;
#line 94 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 94 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp3_;
#line 94 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 94 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 994 "tracker-backend.c"
	}
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = self->priv->bus;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = sparql;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = priority;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = cancellable;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp9_ = tracker_sparql_connection_update_blank (_tmp5_, _tmp6_, _tmp7_, _tmp8_, &_inner_error_);
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _tmp9_;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 1014 "tracker-backend.c"
	}
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp10_ = _tmp4_;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = NULL;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp10_;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_variant_unref0 (_tmp4_);
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 1026 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
	_data_ = _data;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateAsyncData, _data_);
#line 1041 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateAsyncData);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_update_async_data_free);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp2_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = priority;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->priority = _tmp3_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = cancellable;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp5_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_async_co (_data_);
#line 1088 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return;
#line 1100 "tracker-backend.c"
	}
}


static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_async_co (_data_);
#line 1115 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* _data_) {
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 1124 "tracker-backend.c"
		goto _state_0;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 1128 "tracker-backend.c"
		goto _state_1;
		default:
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 1133 "tracker-backend.c"
	}
	_state_0:
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->priority;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->sparql;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_async", _data_->_tmp0_, _data_->_tmp1_);
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp2_ == NULL) {
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 1156 "tracker-backend.c"
	}
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->self->priv->bus;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->sparql;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->priority;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->cancellable;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_async (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, tracker_sparql_backend_update_async_ready, _data_);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1172 "tracker-backend.c"
	_state_1:
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 1184 "tracker-backend.c"
	}
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1194 "tracker-backend.c"
		}
	}
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1201 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	_data_ = _data;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_ptr_array_unref0 (_data_->result);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateArrayAsyncData, _data_);
#line 1216 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateArrayAsyncData);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_update_array_async_data_free);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1__length1 = sparql_length1;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp1_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql_length1 = _tmp1__length1;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = priority;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->priority = _tmp2_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = cancellable;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp4_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_array_async_co (_data_);
#line 1263 "tracker-backend.c"
}


static GPtrArray* tracker_sparql_backend_real_update_array_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GPtrArray* result;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 1276 "tracker-backend.c"
	}
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 1284 "tracker-backend.c"
}


static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_array_async_co (_data_);
#line 1298 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* _data_) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 1307 "tracker-backend.c"
		goto _state_0;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 1311 "tracker-backend.c"
		goto _state_1;
		default:
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 1316 "tracker-backend.c"
	}
	_state_0:
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->bus;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp0_ == NULL) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp1_;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 1333 "tracker-backend.c"
	}
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->sparql;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4__length1 = _data_->sparql_length1;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->priority;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->cancellable;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_array_async (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp4__length1, _data_->_tmp5_, _data_->_tmp6_, tracker_sparql_backend_update_array_async_ready, _data_);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1351 "tracker-backend.c"
	_state_1:
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = tracker_sparql_connection_update_array_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->_tmp7_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 1365 "tracker-backend.c"
	}
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp8_ = _data_->_tmp2_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp8_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_ptr_array_unref0 (_data_->_tmp2_);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1383 "tracker-backend.c"
		}
	}
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1390 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	_data_ = _data;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_variant_unref0 (_data_->result);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateBlankAsyncData, _data_);
#line 1407 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateBlankAsyncData);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_update_blank_async_data_free);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp2_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = priority;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->priority = _tmp3_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = cancellable;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp5_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_blank_async_co (_data_);
#line 1454 "tracker-backend.c"
}


static GVariant* tracker_sparql_backend_real_update_blank_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 1467 "tracker-backend.c"
	}
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 1475 "tracker-backend.c"
}


static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_blank_async_co (_data_);
#line 1489 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* _data_) {
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 1498 "tracker-backend.c"
		goto _state_0;
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 1502 "tracker-backend.c"
		goto _state_1;
		default:
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 1507 "tracker-backend.c"
	}
	_state_0:
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->priority;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->sparql;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank_async", _data_->_tmp0_, _data_->_tmp1_);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp2_ == NULL) {
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 1530 "tracker-backend.c"
	}
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->self->priv->bus;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->sparql;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->priority;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp8_ = _data_->cancellable;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_blank_async (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, tracker_sparql_backend_update_blank_async_ready, _data_);
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1546 "tracker-backend.c"
	_state_1:
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp9_ = tracker_sparql_connection_update_blank_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->_tmp9_;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 1560 "tracker-backend.c"
	}
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp10_ = _data_->_tmp4_;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = NULL;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp10_;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_variant_unref0 (_data_->_tmp4_);
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1578 "tracker-backend.c"
		}
	}
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1585 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	gchar* uri = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	TrackerSparqlConnection* _tmp5_;
	GFile* _tmp6_;
	GCancellable* _tmp7_;
	GError * _inner_error_ = NULL;
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (file != NULL);
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = file;
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	uri = _tmp1_;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = uri;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.load", _tmp2_);
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = self->priv->bus;
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp3_ == NULL) {
#line 1618 "tracker-backend.c"
		GError* _tmp4_;
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp4_;
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1632 "tracker-backend.c"
		} else {
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1642 "tracker-backend.c"
		}
	}
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = self->priv->bus;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = file;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = cancellable;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_load (_tmp5_, _tmp6_, _tmp7_, &_inner_error_);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1663 "tracker-backend.c"
		} else {
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1673 "tracker-backend.c"
		}
	}
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (uri);
#line 1678 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load_async_data_free (gpointer _data) {
	TrackerSparqlBackendLoadAsyncData* _data_;
	_data_ = _data;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->file);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendLoadAsyncData, _data_);
#line 1693 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendLoadAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendLoadAsyncData);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_load_async_data_free);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = file;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->file);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->file = _tmp2_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = cancellable;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp4_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_load_async_co (_data_);
#line 1735 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendLoadAsyncData* _data_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return;
#line 1747 "tracker-backend.c"
	}
}


static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendLoadAsyncData* _data_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_load_async_co (_data_);
#line 1762 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* _data_) {
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 1771 "tracker-backend.c"
		goto _state_0;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 1775 "tracker-backend.c"
		goto _state_1;
		default:
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 1780 "tracker-backend.c"
	}
	_state_0:
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->file;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = g_file_get_uri (_data_->_tmp0_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->uri = _data_->_tmp1_;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->uri;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.load_async", _data_->_tmp2_);
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp3_ == NULL) {
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp4_;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1811 "tracker-backend.c"
		} else {
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1823 "tracker-backend.c"
		}
	}
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->self->priv->bus;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->file;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->cancellable;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_load_async (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, tracker_sparql_backend_load_async_ready, _data_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1838 "tracker-backend.c"
	_state_1:
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_load_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1854 "tracker-backend.c"
		} else {
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1866 "tracker-backend.c"
		}
	}
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->uri);
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1879 "tracker-backend.c"
		}
	}
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1886 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlCursor* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_;
	GCancellable* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	TrackerSparqlCursor* _tmp6_;
	GError * _inner_error_ = NULL;
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("%s()", "Tracker.Sparql.Backend.statistics");
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = self->priv->bus;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 1908 "tracker-backend.c"
		GError* _tmp1_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Statistics support not available for direct-only connection");
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp1_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1920 "tracker-backend.c"
		} else {
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1928 "tracker-backend.c"
		}
	}
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = self->priv->bus;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = cancellable;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = tracker_sparql_connection_statistics (_tmp3_, _tmp4_, &_inner_error_);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _tmp5_;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1947 "tracker-backend.c"
		} else {
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1955 "tracker-backend.c"
		}
	}
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = _tmp2_;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = NULL;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp6_;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 1968 "tracker-backend.c"
}


static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data) {
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	_data_ = _data;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendStatisticsAsyncData, _data_);
#line 1983 "tracker-backend.c"
}


static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendStatisticsAsyncData);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_statistics_async_data_free);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = cancellable;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp2_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_statistics_async_co (_data_);
#line 2015 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 2028 "tracker-backend.c"
	}
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 2036 "tracker-backend.c"
}


static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendStatisticsAsyncData* _data_;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_statistics_async_co (_data_);
#line 2050 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* _data_) {
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 2059 "tracker-backend.c"
		goto _state_0;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 2063 "tracker-backend.c"
		goto _state_1;
		default:
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 2068 "tracker-backend.c"
	}
	_state_0:
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("%s()", "Tracker.Sparql.Backend.statistics_async");
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->bus;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp0_ == NULL) {
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Statistics support not available for direct-only connection");
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp1_;
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2089 "tracker-backend.c"
		} else {
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2099 "tracker-backend.c"
		}
	}
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->cancellable;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_statistics_async (_data_->_tmp3_, _data_->_tmp4_, tracker_sparql_backend_statistics_async_ready, _data_);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2112 "tracker-backend.c"
	_state_1:
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = tracker_sparql_connection_statistics_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->_tmp5_;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2128 "tracker-backend.c"
		} else {
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2138 "tracker-backend.c"
		}
	}
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->_tmp2_;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp6_;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2157 "tracker-backend.c"
		}
	}
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2164 "tracker-backend.c"
}


static TrackerNamespaceManager* tracker_sparql_backend_real_get_namespace_manager (TrackerSparqlConnection* base) {
	TrackerSparqlBackend * self;
	TrackerNamespaceManager* result = NULL;
	TrackerSparqlConnection* _tmp0_;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = self->priv->direct;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_ != NULL) {
#line 2178 "tracker-backend.c"
		TrackerSparqlConnection* _tmp1_;
		TrackerNamespaceManager* _tmp2_;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = self->priv->direct;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = tracker_sparql_connection_get_namespace_manager (_tmp1_);
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp2_;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 2189 "tracker-backend.c"
	} else {
		TrackerNamespaceManager* _tmp3_;
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = tracker_namespace_manager_get_default ();
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp3_;
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 2198 "tracker-backend.c"
	}
}


static TrackerSparqlConnection* tracker_sparql_backend_create_readonly_direct (TrackerSparqlBackend* self, GError** error) {
	TrackerSparqlConnection* result = NULL;
	TrackerDirectConnection* conn = NULL;
	TrackerDomainOntology* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	TrackerDomainOntology* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	TrackerDomainOntology* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	TrackerDirectConnection* _tmp9_;
	TrackerDirectConnection* _tmp10_;
	TrackerDirectConnection* _tmp11_;
	GError * _inner_error_ = NULL;
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = domain_ontology;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = tracker_domain_ontology_get_cache (_tmp0_);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _tmp1_;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = domain_ontology;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = tracker_domain_ontology_get_journal (_tmp3_);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = _tmp4_;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = domain_ontology;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = tracker_domain_ontology_get_ontology (_tmp6_);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = _tmp7_;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp9_ = tracker_direct_connection_new (TRACKER_SPARQL_CONNECTION_FLAGS_READONLY, _tmp2_, _tmp5_, _tmp8_, &_inner_error_);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp10_ = _tmp9_;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_tmp8_);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_tmp5_);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	conn = _tmp10_;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 2257 "tracker-backend.c"
	}
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp11_ = conn;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_initable_init ((GInitable*) _tmp11_, NULL, &_inner_error_);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (conn);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 2271 "tracker-backend.c"
	}
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = (TrackerSparqlConnection*) conn;
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 2277 "tracker-backend.c"
}


static void tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, GError** error) {
	gchar* env_backend = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	TrackerSparqlBackendBackend backend = 0;
	const gchar* _tmp2_;
	TrackerSparqlBackendBackend _tmp8_;
	TrackerSparqlBackendBackend _tmp9_;
	GError * _inner_error_ = NULL;
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (self != NULL);
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = g_getenv ("TRACKER_SPARQL_BACKEND");
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	env_backend = _tmp1_;
#line 175 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	backend = TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = env_backend;
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp2_ != NULL) {
#line 2304 "tracker-backend.c"
		const gchar* _tmp3_;
		gint _tmp4_;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = env_backend;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = g_ascii_strcasecmp (_tmp3_, "direct");
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_tmp4_ == 0) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_debug ("Using backend = 'DIRECT'");
#line 2317 "tracker-backend.c"
		} else {
			const gchar* _tmp5_;
			gint _tmp6_;
#line 181 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp5_ = env_backend;
#line 181 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp6_ = g_ascii_strcasecmp (_tmp5_, "bus");
#line 181 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp6_ == 0) {
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				backend = TRACKER_SPARQL_BACKEND_BACKEND_BUS;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_debug ("Using backend = 'BUS'");
#line 2331 "tracker-backend.c"
			} else {
				const gchar* _tmp7_;
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp7_ = env_backend;
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_warning ("Environment variable TRACKER_SPARQL_BACKEND set to unknown value '%s'", _tmp7_);
#line 2338 "tracker-backend.c"
			}
		}
	}
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = backend;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp8_ == TRACKER_SPARQL_BACKEND_BACKEND_AUTO) {
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("Using backend = 'AUTO'");
#line 2348 "tracker-backend.c"
	}
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp9_ = backend;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_tmp9_) {
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_AUTO:
#line 2356 "tracker-backend.c"
		{
			TrackerBusConnection* _tmp10_ = NULL;
			TrackerDomainOntology* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			TrackerBusConnection* _tmp14_;
			TrackerBusConnection* _tmp15_;
			TrackerBusConnection* _tmp16_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp11_ = domain_ontology;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp12_ = tracker_domain_ontology_get_domain (_tmp11_, NULL);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp13_ = _tmp12_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp14_ = tracker_bus_connection_new (_tmp13_, &_inner_error_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp15_ = _tmp14_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_tmp13_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp10_ = _tmp15_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2387 "tracker-backend.c"
			}
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp16_ = _tmp10_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp10_ = NULL;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self->priv->bus);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			self->priv->bus = (TrackerSparqlConnection*) _tmp16_;
#line 2397 "tracker-backend.c"
			{
				TrackerSparqlConnection* _tmp17_ = NULL;
				TrackerSparqlConnection* _tmp18_;
				TrackerSparqlConnection* _tmp19_;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp18_ = tracker_sparql_backend_create_readonly_direct (self, &_inner_error_);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp17_ = _tmp18_;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2410 "tracker-backend.c"
						goto __catch2_tracker_sparql_error;
					}
					goto __finally2;
				}
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp19_ = _tmp17_;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp17_ = NULL;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (self->priv->direct);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				self->priv->direct = _tmp19_;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_tmp17_);
#line 2425 "tracker-backend.c"
			}
			goto __finally2;
			__catch2_tracker_sparql_error:
			{
				GError* e = NULL;
				GError* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				e = _inner_error_;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_inner_error_ = NULL;
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp20_ = e;
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp21_ = _tmp20_->message;
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp22_ = g_strconcat ("Falling back to bus backend, the direct backend failed to initialize: ", _tmp21_, NULL);
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp23_ = _tmp22_;
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_warning ("%s", _tmp23_);
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (_tmp23_);
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_error_free0 (e);
#line 2453 "tracker-backend.c"
			}
			__finally2:
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_tmp10_);
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2466 "tracker-backend.c"
			}
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp10_);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 2472 "tracker-backend.c"
		}
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_DIRECT:
#line 2476 "tracker-backend.c"
		{
			TrackerSparqlConnection* _tmp24_ = NULL;
			TrackerSparqlConnection* _tmp25_;
			TrackerSparqlConnection* _tmp26_;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp25_ = tracker_sparql_backend_create_readonly_direct (self, &_inner_error_);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp24_ = _tmp25_;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2493 "tracker-backend.c"
			}
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp26_ = _tmp24_;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp24_ = NULL;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self->priv->direct);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			self->priv->direct = _tmp26_;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp24_);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 2507 "tracker-backend.c"
		}
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_BUS:
#line 2511 "tracker-backend.c"
		{
			TrackerBusConnection* _tmp27_ = NULL;
			TrackerDomainOntology* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			TrackerBusConnection* _tmp31_;
			TrackerBusConnection* _tmp32_;
			TrackerBusConnection* _tmp33_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp28_ = domain_ontology;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp29_ = tracker_domain_ontology_get_domain (_tmp28_, NULL);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp30_ = _tmp29_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp31_ = tracker_bus_connection_new (_tmp30_, &_inner_error_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp32_ = _tmp31_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_tmp30_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp27_ = _tmp32_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2542 "tracker-backend.c"
			}
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp33_ = _tmp27_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp27_ = NULL;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self->priv->bus);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			self->priv->bus = (TrackerSparqlConnection*) _tmp33_;
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp27_);
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 2556 "tracker-backend.c"
		}
		default:
		{
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_assert_not_reached ();
#line 2562 "tracker-backend.c"
		}
	}
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (env_backend);
#line 2567 "tracker-backend.c"
}


static TrackerSparqlConnection* tracker_sparql_backend_get (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	GError * _inner_error_ = NULL;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_mutex_lock (&tracker_sparql_backend_door);
#line 2576 "tracker-backend.c"
	{
		TrackerSparqlConnection* _result_ = NULL;
		TrackerSparqlConnection* _tmp0_;
		TrackerSparqlConnection* _tmp1_;
		TrackerSparqlConnection* _tmp2_;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = tracker_sparql_backend_singleton;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_result_ = _tmp1_;
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = _result_;
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_tmp2_ == NULL) {
#line 2592 "tracker-backend.c"
			TrackerSparqlBackend* _tmp3_ = NULL;
			TrackerSparqlBackend* _tmp4_;
			TrackerSparqlBackend* _tmp5_;
			gboolean _tmp6_ = FALSE;
			GCancellable* _tmp7_;
			TrackerSparqlConnection* _tmp11_;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp4_ = tracker_sparql_backend_new (&_inner_error_);
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp3_ = _tmp4_;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_result_);
#line 2607 "tracker-backend.c"
				goto __finally3;
			}
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp5_ = _tmp3_;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp3_ = NULL;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_result_);
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_result_ = (TrackerSparqlConnection*) _tmp5_;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp7_ = cancellable;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp7_ != NULL) {
#line 2622 "tracker-backend.c"
				GCancellable* _tmp8_;
				gboolean _tmp9_;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp8_ = cancellable;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp9_ = g_cancellable_is_cancelled (_tmp8_);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp6_ = _tmp9_;
#line 2631 "tracker-backend.c"
			} else {
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp6_ = FALSE;
#line 2635 "tracker-backend.c"
			}
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp6_) {
#line 2639 "tracker-backend.c"
				GError* _tmp10_;
#line 232 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp10_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 232 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_inner_error_ = _tmp10_;
#line 232 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_tmp3_);
#line 232 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_result_);
#line 2649 "tracker-backend.c"
				goto __finally3;
			}
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp11_ = _result_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			tracker_sparql_backend_singleton = _tmp11_;
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_tmp3_);
#line 2658 "tracker-backend.c"
		}
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _result_;
#line 2662 "tracker-backend.c"
		{
#line 240 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_mutex_unlock (&tracker_sparql_backend_door);
#line 2666 "tracker-backend.c"
		}
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 2670 "tracker-backend.c"
	}
	__finally3:
	{
#line 240 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_mutex_unlock (&tracker_sparql_backend_door);
#line 2676 "tracker-backend.c"
	}
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 2684 "tracker-backend.c"
	} else {
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_clear_error (&_inner_error_);
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 2692 "tracker-backend.c"
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return _data1_;
#line 2702 "tracker-backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data1_->async_result);
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 2717 "tracker-backend.c"
	}
}


static void __lambda6_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_;
	GAsyncResult* _tmp1_;
	GMainLoop* _tmp2_;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (res != NULL);
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = res;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data1_->async_result);
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->async_result = _tmp1_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _data1_->loop;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_loop_quit (_tmp2_);
#line 2740 "tracker-backend.c"
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	__lambda6_ (self, source_object, res);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	block1_data_unref (self);
#line 2749 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_backend_get_internal (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	Block1Data* _data1_;
	GMainContext* _tmp0_;
	GMainContext* context = NULL;
	GMainContext* _tmp5_;
	GMainContext* _tmp6_;
	GMainLoop* _tmp7_;
	GMainContext* _tmp8_;
	GCancellable* _tmp9_;
	GMainLoop* _tmp10_;
	GMainContext* _tmp11_;
	TrackerSparqlConnection* _tmp12_ = NULL;
	GAsyncResult* _tmp13_;
	TrackerSparqlConnection* _tmp14_;
	TrackerSparqlConnection* _tmp15_;
	GError * _inner_error_ = NULL;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->_ref_count_ = 1;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = g_main_context_get_thread_default ();
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 2778 "tracker-backend.c"
		TrackerSparqlConnection* _tmp1_ = NULL;
		GCancellable* _tmp2_;
		TrackerSparqlConnection* _tmp3_;
		TrackerSparqlConnection* _tmp4_;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = cancellable;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = tracker_sparql_backend_get (_tmp2_, &_inner_error_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = _tmp3_;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block1_data_unref (_data1_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data1_ = NULL;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 2801 "tracker-backend.c"
			} else {
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block1_data_unref (_data1_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data1_ = NULL;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_inner_error_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 2813 "tracker-backend.c"
			}
		}
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = _tmp1_;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = NULL;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp4_;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp1_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		block1_data_unref (_data1_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data1_ = NULL;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 2830 "tracker-backend.c"
	}
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = g_main_context_new ();
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	context = _tmp5_;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = context;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = g_main_loop_new (_tmp6_, FALSE);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->loop = _tmp7_;
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->async_result = NULL;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = context;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_context_push_thread_default (_tmp8_);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp9_ = cancellable;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async (_tmp9_, ___lambda6__gasync_ready_callback, block1_data_ref (_data1_));
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp10_ = _data1_->loop;
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_loop_run (_tmp10_);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp11_ = context;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_context_pop_thread_default (_tmp11_);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp13_ = _data1_->async_result;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp14_ = tracker_sparql_backend_get_internal_finish (_tmp13_, &_inner_error_);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp12_ = _tmp14_;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_main_context_unref0 (context);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block1_data_unref (_data1_);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data1_ = NULL;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 2880 "tracker-backend.c"
		} else {
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_main_context_unref0 (context);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block1_data_unref (_data1_);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data1_ = NULL;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 2894 "tracker-backend.c"
		}
	}
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp15_ = _tmp12_;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp12_ = NULL;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp15_;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_tmp12_);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_main_context_unref0 (context);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	block1_data_unref (_data1_);
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_ = NULL;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 2913 "tracker-backend.c"
}


static void tracker_sparql_backend_get_internal_async_data_free (gpointer _data) {
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	_data_ = _data;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendGetInternalAsyncData, _data_);
#line 2924 "tracker-backend.c"
}


void tracker_sparql_backend_get_internal_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendGetInternalAsyncData);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_get_internal_async_data_free);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = cancellable;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp1_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async_co (_data_);
#line 2948 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlBackendGetInternalAsyncData* _data_;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 2961 "tracker-backend.c"
	}
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 2969 "tracker-backend.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return _data2_;
#line 2978 "tracker-backend.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_main_context_unref0 (_data2_->context);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data2_->_result_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->spawn_error);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->io_error);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data2_->cancellable);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_slice_free (Block2Data, _data2_);
#line 3003 "tracker-backend.c"
	}
}


static gpointer _g_main_context_ref0 (gpointer self) {
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self ? g_main_context_ref (self) : NULL;
#line 3011 "tracker-backend.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self ? g_error_copy (self) : NULL;
#line 3018 "tracker-backend.c"
}


static gboolean __lambda5_ (Block2Data* _data2_) {
	gboolean result = FALSE;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async_co (_data2_->_async_data_);
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = FALSE;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3030 "tracker-backend.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3039 "tracker-backend.c"
}


static gboolean __lambda4_ (Block2Data* _data2_, GIOSchedulerJob* job) {
	gboolean result = FALSE;
	GSource* source = NULL;
	GSource* _tmp14_;
	GMainContext* _tmp15_;
	GError * _inner_error_ = NULL;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (job != NULL, FALSE);
#line 3051 "tracker-backend.c"
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		GCancellable* _tmp1_;
		TrackerSparqlConnection* _tmp2_;
		TrackerSparqlConnection* _tmp4_;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = _data2_->cancellable;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = tracker_sparql_backend_get (_tmp1_, &_inner_error_);
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = _tmp2_;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3065 "tracker-backend.c"
			gboolean _tmp3_ = FALSE;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 3069 "tracker-backend.c"
				goto __catch4_g_io_error;
			}
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3074 "tracker-backend.c"
				goto __catch4_tracker_sparql_error;
			}
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 3079 "tracker-backend.c"
				goto __catch4_g_dbus_error;
			}
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 3084 "tracker-backend.c"
				goto __catch4_g_spawn_error;
			}
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return _tmp3_;
#line 3093 "tracker-backend.c"
		}
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = _tmp0_;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = NULL;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data2_->_result_);
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->_result_ = _tmp4_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp0_);
#line 3105 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp5_;
		GError* _tmp6_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_io = _inner_error_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = e_io;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp6_ = _g_error_copy0 (_tmp5_);
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->io_error);
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->io_error = _tmp6_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_io);
#line 3127 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_tracker_sparql_error:
	{
		GError* e_spql = NULL;
		GError* _tmp7_;
		GError* _tmp8_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_spql = _inner_error_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp7_ = e_spql;
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = _g_error_copy0 (_tmp7_);
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->sparql_error = _tmp8_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_spql);
#line 3149 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp9_;
		GError* _tmp10_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_dbus = _inner_error_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = e_dbus;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp10_ = _g_error_copy0 (_tmp9_);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->dbus_error = _tmp10_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_dbus);
#line 3171 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e_spawn = NULL;
		GError* _tmp11_;
		GError* _tmp12_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_spawn = _inner_error_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp11_ = e_spawn;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp12_ = _g_error_copy0 (_tmp11_);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->spawn_error);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->spawn_error = _tmp12_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_spawn);
#line 3193 "tracker-backend.c"
	}
	__finally4:
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3198 "tracker-backend.c"
		gboolean _tmp13_ = FALSE;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_clear_error (&_inner_error_);
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return _tmp13_;
#line 3206 "tracker-backend.c"
	}
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp14_ = g_idle_source_new ();
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	source = _tmp14_;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_source_set_callback (source, ___lambda5__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp15_ = _data2_->context;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_source_attach (source, _tmp15_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = FALSE;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_source_unref0 (source);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3224 "tracker-backend.c"
}


static gboolean ___lambda4__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self) {
	gboolean result;
	result = __lambda4_ (self, job);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3233 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* _data_) {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 3242 "tracker-backend.c"
		goto _state_0;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 3246 "tracker-backend.c"
		goto _state_1;
		default:
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 3251 "tracker-backend.c"
	}
	_state_0:
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->cancellable;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_data2_->cancellable);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->cancellable = _data_->_tmp0_;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = g_mutex_trylock (&tracker_sparql_backend_door);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp1_) {
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp2_ = tracker_sparql_backend_singleton;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_result_ = _data_->_tmp3_;
#line 275 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_mutex_unlock (&tracker_sparql_backend_door);
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = _data_->_result_;
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_tmp4_ != NULL) {
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->result = _data_->_result_;
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ != 0) {
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3296 "tracker-backend.c"
				}
			}
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3303 "tracker-backend.c"
		}
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data_->_result_);
#line 3307 "tracker-backend.c"
	}
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->sparql_error = NULL;
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->io_error = NULL;
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->dbus_error = NULL;
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->spawn_error = NULL;
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->_result_ = NULL;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = g_main_context_get_thread_default ();
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _g_main_context_ref0 (_data_->_tmp5_);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->context = _data_->_tmp6_;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_io_scheduler_push_job (___lambda4__gio_scheduler_job_func, block2_data_ref (_data_->_data2_), block2_data_unref, G_PRIORITY_DEFAULT, NULL);
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 3331 "tracker-backend.c"
	_state_1:
	;
#line 314 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->_data2_->sparql_error;
#line 314 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp7_ != NULL) {
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = _data_->_data2_->sparql_error;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp9_;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3356 "tracker-backend.c"
		} else {
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3370 "tracker-backend.c"
		}
	} else {
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp10_ = _data_->_data2_->io_error;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_tmp10_ != NULL) {
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp11_ = _data_->_data2_->io_error;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_inner_error_ = _data_->_tmp12_;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block2_data_unref (_data_->_data2_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_data2_ = NULL;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_object_unref (_data_->_async_result);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 3395 "tracker-backend.c"
			} else {
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block2_data_unref (_data_->_data2_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_data2_ = NULL;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_data_->_inner_error_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_object_unref (_data_->_async_result);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 3409 "tracker-backend.c"
			}
		} else {
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp13_ = _data_->_data2_->dbus_error;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_tmp13_ != NULL) {
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp14_ = _data_->_data2_->dbus_error;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp15_ = _g_error_copy0 (_data_->_tmp14_);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_inner_error_ = _data_->_tmp15_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_object_unref (_data_->_async_result);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					return FALSE;
#line 3434 "tracker-backend.c"
				} else {
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_clear_error (&_data_->_inner_error_);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_object_unref (_data_->_async_result);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					return FALSE;
#line 3448 "tracker-backend.c"
				}
			} else {
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp16_ = _data_->_data2_->spawn_error;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (_data_->_tmp16_ != NULL) {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp17_ = _data_->_data2_->spawn_error;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp18_ = _g_error_copy0 (_data_->_tmp17_);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_inner_error_ = _data_->_tmp18_;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						block2_data_unref (_data_->_data2_);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						_data_->_data2_ = NULL;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_object_unref (_data_->_async_result);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						return FALSE;
#line 3473 "tracker-backend.c"
					} else {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						block2_data_unref (_data_->_data2_);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						_data_->_data2_ = NULL;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_clear_error (&_data_->_inner_error_);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_object_unref (_data_->_async_result);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						return FALSE;
#line 3487 "tracker-backend.c"
					}
				} else {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp19_ = _data_->_data2_->_result_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->result = _data_->_tmp20_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if (_data_->_state_ != 0) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3508 "tracker-backend.c"
						}
					}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_object_unref (_data_->_async_result);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					return FALSE;
#line 3515 "tracker-backend.c"
				}
			}
		}
	}
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	block2_data_unref (_data_->_data2_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_ = NULL;
#line 3524 "tracker-backend.c"
}


static void tracker_sparql_backend_class_init (TrackerSparqlBackendClass * klass) {
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlBackendPrivate));
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((GObjectClass *) klass)->dispose = (void (*) (GObject *)) tracker_sparql_backend_real_dispose;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GError**)) tracker_sparql_backend_real_query;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_query_async;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_query_finish;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GError**)) tracker_sparql_backend_real_update;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank = (GVariant* (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GError**)) tracker_sparql_backend_real_update_blank;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_async = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_update_async;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_finish = (void (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_update_finish;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_async = (void (*) (TrackerSparqlConnection *, gchar**, int, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_update_array_async;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_finish = (GPtrArray* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_update_array_finish;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_async = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_update_blank_async;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_finish = (GVariant* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_update_blank_finish;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->load = (void (*) (TrackerSparqlConnection *, GFile*, GCancellable*, GError**)) tracker_sparql_backend_real_load;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->load_async = (void (*) (TrackerSparqlConnection *, GFile*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_load_async;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->load_finish = (void (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_load_finish;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GCancellable*, GError**)) tracker_sparql_backend_real_statistics;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_async = (void (*) (TrackerSparqlConnection *, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_statistics_async;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_statistics_finish;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->get_namespace_manager = (TrackerNamespaceManager* (*) (TrackerSparqlConnection *)) tracker_sparql_backend_real_get_namespace_manager;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_backend_finalize;
#line 3573 "tracker-backend.c"
}


static void tracker_sparql_backend_instance_init (TrackerSparqlBackend * self) {
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv = TRACKER_SPARQL_BACKEND_GET_PRIVATE (self);
#line 25 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv->direct = NULL;
#line 26 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv->bus = NULL;
#line 3584 "tracker-backend.c"
}


static void tracker_sparql_backend_finalize (GObject * obj) {
	TrackerSparqlBackend * self;
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend);
#line 25 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (self->priv->direct);
#line 26 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (self->priv->bus);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->finalize (obj);
#line 3598 "tracker-backend.c"
}


GType tracker_sparql_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBackend), 0, (GInstanceInitFunc) tracker_sparql_backend_instance_init, NULL };
		GType tracker_sparql_backend_type_id;
		tracker_sparql_backend_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerSparqlBackend", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_backend_type_id__volatile, tracker_sparql_backend_type_id);
	}
	return tracker_sparql_backend_type_id__volatile;
}


static void tracker_sparql_connection_get_async_data_free (gpointer _data) {
	TrackerSparqlConnectionGetAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionGetAsyncData, _data_);
}


void tracker_sparql_connection_get_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionGetAsyncData* _data_;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionGetAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_get_async_data_free);
	_tmp0_ = cancellable;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	tracker_sparql_connection_get_async_co (_data_);
}


TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionGetAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_connection_get_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionGetAsyncData* _data_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_get_async_co (_data_);
#line 3661 "tracker-backend.c"
}


static gboolean tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* _data_) {
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 3670 "tracker-backend.c"
		goto _state_0;
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 3674 "tracker-backend.c"
		goto _state_1;
		default:
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 3679 "tracker-backend.c"
	}
	_state_0:
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async (_data_->_tmp1_, tracker_sparql_connection_get_async_ready, _data_);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 3690 "tracker-backend.c"
	_state_1:
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = tracker_sparql_backend_get_internal_finish (_data_->_res_, &_data_->_inner_error_);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->_tmp2_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3706 "tracker-backend.c"
		} else {
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3716 "tracker-backend.c"
		}
	}
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->_tmp0_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp3_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3735 "tracker-backend.c"
		}
	}
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 3742 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	GCancellable* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GError * _inner_error_ = NULL;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = cancellable;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = tracker_sparql_backend_get_internal (_tmp1_, &_inner_error_);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _tmp2_;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 3767 "tracker-backend.c"
		} else {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 3775 "tracker-backend.c"
		}
	}
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = _tmp0_;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = NULL;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp3_;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_tmp0_);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3788 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_connection_remote_new (const gchar* url_base) {
	TrackerSparqlConnection* result = NULL;
	const gchar* _tmp0_;
	TrackerRemoteConnection* _tmp1_;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (url_base != NULL, NULL);
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = url_base;
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = tracker_remote_connection_new (_tmp0_);
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = (TrackerSparqlConnection*) _tmp1_;
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3806 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_connection_local_new (TrackerSparqlConnectionFlags flags, GFile* store, GFile* journal, GFile* ontology, GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	TrackerDirectConnection* conn = NULL;
	TrackerSparqlConnectionFlags _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	TrackerDirectConnection* _tmp4_;
	TrackerDirectConnection* _tmp5_;
	GCancellable* _tmp6_;
	GError * _inner_error_ = NULL;
#line 340 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (store != NULL, NULL);
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = flags;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = store;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = journal;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = ontology;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = tracker_direct_connection_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	conn = _tmp4_;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 3841 "tracker-backend.c"
	}
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = conn;
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = cancellable;
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_initable_init ((GInitable*) _tmp5_, _tmp6_, &_inner_error_);
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (conn);
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 3857 "tracker-backend.c"
	}
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = (TrackerSparqlConnection*) conn;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3863 "tracker-backend.c"
}


static void tracker_sparql_connection_local_new_async_data_free (gpointer _data) {
	TrackerSparqlConnectionLocalNewAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->store);
	_g_object_unref0 (_data_->journal);
	_g_object_unref0 (_data_->ontology);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionLocalNewAsyncData, _data_);
}


void tracker_sparql_connection_local_new_async (TrackerSparqlConnectionFlags flags, GFile* store, GFile* journal, GFile* ontology, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionLocalNewAsyncData* _data_;
	TrackerSparqlConnectionFlags _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionLocalNewAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_local_new_async_data_free);
	_tmp0_ = flags;
	_data_->flags = _tmp0_;
	_tmp1_ = store;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->store);
	_data_->store = _tmp2_;
	_tmp3_ = journal;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->journal);
	_data_->journal = _tmp4_;
	_tmp5_ = ontology;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->ontology);
	_data_->ontology = _tmp6_;
	_tmp7_ = cancellable;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp8_;
	tracker_sparql_connection_local_new_async_co (_data_);
}


TrackerSparqlConnection* tracker_sparql_connection_local_new_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionLocalNewAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean tracker_sparql_connection_local_new_async_co (TrackerSparqlConnectionLocalNewAsyncData* _data_) {
#line 346 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 346 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 3933 "tracker-backend.c"
		goto _state_0;
#line 346 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 3937 "tracker-backend.c"
		goto _state_1;
		default:
#line 346 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 3942 "tracker-backend.c"
	}
	_state_0:
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->flags;
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->store;
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->journal;
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->ontology;
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = tracker_direct_connection_new (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, &_data_->_inner_error_);
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->conn = _data_->_tmp4_;
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 3965 "tracker-backend.c"
	}
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->cancellable;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_async_initable_init_async ((GAsyncInitable*) _data_->conn, G_PRIORITY_DEFAULT, _data_->_tmp5_, NULL, NULL);
#line 349 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 349 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 3975 "tracker-backend.c"
	_state_1:
	;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = (TrackerSparqlConnection*) _data_->conn;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3988 "tracker-backend.c"
		}
	}
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 3995 "tracker-backend.c"
}


void tracker_sparql_connection_set_domain (const gchar* domain) {
	const gchar* _tmp0_;
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = domain_name;
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 4005 "tracker-backend.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = domain;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_free0 (domain_name);
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		domain_name = _tmp2_;
#line 4016 "tracker-backend.c"
	}
}


gchar* tracker_sparql_connection_get_domain (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = domain_name;
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp1_;
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 4033 "tracker-backend.c"
}



