// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_CELLAREA_H
#define _GTKMM_CELLAREA_H


#include <glibmm.h>

/* Copyright (C) 2010 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/buildable.h>
#include <gtkmm/cellareacontext.h>
#include <gtkmm/celllayout.h>
#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkCellArea GtkCellArea;
typedef struct _GtkCellAreaClass GtkCellAreaClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class CellArea_Class; } // namespace Gtk
namespace Gtk
{

//TODO: This documentation omits the examples from the C documentation. We should translate them to C++.
//TODO: Find a way to markup the section titles in this doxygen comment.
/** An abstract base class for laying out CellRenderers.
 *
 * This is an abstract base class for CellLayout widgets
 * (also referred to as "layouting widgets") to interface with an
 * arbitrary number of CellRenderers and interact with the user
 * for a given TreeModel row.
 *
 * The cell area handles events, focus navigation, drawing and
 * size requests and allocations for a given row of data.
 *
 * Usually users dont have to interact with the CellArea directly
 * unless they are implementing a cell layouting widget themselves.
 *
 * Requesting area sizes
 * 
 * As outlined in Gtk::Widget's
 * geometry management description, GTK+ uses a height-for-width
 * geometry management system to compute the sizes of widgets and user
 * interfaces. CellArea uses the same semantics to calculate the
 * size of an area for an arbitrary number of TreeModel rows.
 *
 * When requesting the size of a cell area one needs to calculate
 * the size for a handful of rows, and this will be done differently by
 * different layouting widgets. For instance a TreeViewColumn
 * always lines up the areas from top to bottom while an IconView,
 * on the other hand, might enforce that all areas received the same
 * width and wrap the areas around, requesting height for more cell
 * areas when allocated less width.
 *
 * It's also important for areas to maintain some cell
 * alignments with areas rendered for adjacent rows (cells can
 * appear "columnized" inside an area even when the size of
 * cells are different in each row). For this reason the CellArea
 * uses a CellAreaContext object to store the alignments
 * and sizes along the way (as well as the overall largest minimum
 * and natural size for all the rows which have been calculated
 * with the said context).
 *
 * The CellAreaContext is an opaque object specific to the
 * CellArea which created it (see CellArea::create_context()).
 * The owning cell-layouting widget can create as many contexts as
 * it wishes to calculate sizes of rows which should receive the
 * same size in at least one orientation (horizontally or vertically).
 * However, it's important that the same CellAreaContext which
 * was used to request the sizes for a given TreeModel row be
 * used when rendering or processing events for that row.
 *
 * Cell Properties
 * 
 * The CellArea introduces cell propertie
 * for CellRenderers in very much the same way that Gtk::Container
 * introduces child properties
 * for Widgets. This provides some general interfaces for defining
 * the relationship cell areas have with their cells. For instance in a
 * CellAreaBox a cell might "expand" and receive extra space when
 * the area is allocated more than its full natural request, or a cell
 * might be configured to "align" with adjacent rows which were requested
 * and rendered with the same CellAreaContext.
 *
 * To set the value of a cell property, use cell_set_property(). To obtain
 * the value of a cell property, use cell_get_property().
 *
 * @newin{3,0}
 */

class CellArea
  : public Glib::Object,
    public Buildable,
    public CellLayout
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef CellArea CppObjectType;
  typedef CellArea_Class CppClassType;
  typedef GtkCellArea BaseObjectType;
  typedef GtkCellAreaClass BaseClassType;

private:  friend class CellArea_Class;
  static CppClassType cellarea_class_;

private:
  // noncopyable
  CellArea(const CellArea&);
  CellArea& operator=(const CellArea&);

protected:
  explicit CellArea(const Glib::ConstructParams& construct_params);
  explicit CellArea(GtkCellArea* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~CellArea();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkCellArea*       gobj()       { return reinterpret_cast<GtkCellArea*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkCellArea* gobj() const { return reinterpret_cast<GtkCellArea*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkCellArea* gobj_copy();

private:

  
protected:
  CellArea();
public:

  
  void add(CellRenderer& renderer);
  
  void remove(CellRenderer& renderer);
  
  bool has_renderer(CellRenderer& renderer);
  //TODO: _WRAP_METHOD(void foreach(GtkCellCallback callback, gpointer callback_data), gtk_cell_area_foreach)
  //TODO: _WRAP_METHOD(void foreach_alloc(const Glib::RefPtr<CellAreaContext>& context,  Widget& widget, const Gdk::Rectangle& cell_area, const Gdk::Rectangle& background_area,  GtkCellAllocCallback  callback,  gpointer  callback_data), gtk_cell_area_foreach_alloc
  
  int event(const Glib::RefPtr<CellAreaContext>& context, Widget& widget, GdkEvent* event, const Gdk::Rectangle& cell_area,  GtkCellRendererState  flags);
  
  void render(const Glib::RefPtr<CellAreaContext>& context, Widget& widget, const Cairo::RefPtr<Cairo::Context>& cr, const Gdk::Rectangle& background_area, const Gdk::Rectangle& cell_area, CellRendererState flags,  bool paint_focus);

  
  void get_cell_allocation(const Glib::RefPtr<CellAreaContext>& context, Widget& widget, CellRenderer& renderer,  const Gdk::Rectangle& cell_area, Gdk::Rectangle& allocation);
  
  
  CellRenderer* get_cell_at_position(const Glib::RefPtr<CellAreaContext>& context, Widget& widget, const Gdk::Rectangle& cell_area, int x, int y, Gdk::Rectangle& alloc_area);
  
  const CellRenderer* get_cell_at_position(const Glib::RefPtr<CellAreaContext>& context, Widget& widget, const Gdk::Rectangle& cell_area, int x, int y, Gdk::Rectangle& alloc_area) const;

  
  Glib::RefPtr<CellAreaContext> create_context() const;
  
  
  Glib::RefPtr<CellAreaContext> copy_context(const Glib::RefPtr<const CellAreaContext>& context);

  
  SizeRequestMode get_request_mode() const;
  
  void get_preferred_width(const Glib::RefPtr<CellAreaContext>& context,  Widget& widget,  int& minimum_width, int& natural_width);
  
  void get_preferred_height_for_width (const Glib::RefPtr<CellAreaContext>& context,  Widget& widget,  int width,  int& minimum_height, int& natural_height);
  
  void get_preferred_height( const Glib::RefPtr<CellAreaContext>& context, Widget& widget,  int& minimum_height, int& natural_height);
  
  void get_preferred_width_for_height(const Glib::RefPtr<CellAreaContext>& context, Widget& widget,  int height,  int& minimum_width, int& natural_width);
  
  Glib::ustring get_current_path_string () const;


  void apply_attributes(const Glib::RefPtr<TreeModel>& tree_model, const TreeModel::iterator& iter,  bool is_expander, bool is_expanded);
  
  void attribute_connect(CellRenderer& renderer, const Glib::ustring& attribute, int column);
  
  void attribute_disconnect(CellRenderer& renderer, const Glib::ustring& attribute);


  void cell_set_property(CellRenderer& renderer, const Glib::ustring& property_name, const Glib::ValueBase& value);
  
  void cell_get_property(CellRenderer& renderer, const Glib::ustring& property_name, Glib::ValueBase& value);

  
  bool is_activatable() const;
  
  bool activate(const Glib::RefPtr<CellAreaContext>& context, Widget& widget, const Gdk::Rectangle& cell_area, CellRendererState flags, bool edit_only);
  
  bool focus(DirectionType direction);
  
  void set_focus_cell(CellRenderer& renderer);
  
  
  CellRenderer* get_focus_cell();
  
  const CellRenderer* get_focus_cell() const;

  
  void add_focus_sibling(CellRenderer& renderer, CellRenderer& sibling);
  
  void remove_focus_sibling( CellRenderer& renderer, CellRenderer& sibling);
  
  bool is_focus_sibling(CellRenderer& renderer,  CellRenderer& sibling);
  //TODO: _WRAP_METHOD(GList* get_focus_siblings(CellRenderer& renderer), gtk_cell_area_get_focus_siblings)
  
  
  CellRenderer* get_focus_from_sibling(CellRenderer& renderer);
  
  const CellRenderer* get_focus_from_sibling(CellRenderer& renderer) const;
  
  
  CellRenderer* get_edited_cell();
  
  const CellRenderer* get_edited_cell() const;
  
  
  CellEditable* get_edit_widget(); 
  
  const CellEditable* get_edit_widget() const;
  
  
  bool activate_cell(Widget& widget, CellRenderer& renderer, GdkEvent* event, const Gdk::Rectangle& cell_area, CellRendererState flags);
  
  void stop_editing(bool canceled);

  
  void inner_cell_area(Widget& widget, const Gdk::Rectangle& cell_area, Gdk::Rectangle& inner_area);

  
  void request_renderer(CellRenderer& renderer, Orientation orientation, Widget& widget, int for_size, int& minimum_size, int& natural_size);

protected:
   

    virtual SizeRequestMode get_request_mode_vfunc() const;

    virtual void get_preferred_width_vfunc(const Glib::RefPtr<CellAreaContext>& context, Widget& widget, int& minimum_width, int& natural_width);

    virtual void get_preferred_height_for_width_vfunc(const Glib::RefPtr<CellAreaContext>& context, Widget& widget, int width, int& minimum_height, int& natural_height);

    virtual void get_preferred_height_vfunc(const Glib::RefPtr<CellAreaContext>& context, Widget& widget, int& minimum_height, int& natural_height);

    virtual void get_preferred_width_for_height_vfunc(const Glib::RefPtr<CellAreaContext>& context, Widget& widget, int height, int& minimum_width, int& natural_width);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::CellArea
   */
  Glib::RefPtr<Gtk::CellArea> wrap(GtkCellArea* object, bool take_copy = false);
}


#endif /* _GTKMM_CELLAREA_H */

