/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <pango/pango.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


PangoRectangle * PangoAttrShape_get_inkRect (PangoAttrShape * cptr) 
{
    return (PangoRectangle *)&cptr->ink_rect;
}

/*
 * Class:     org.gnu.pango.AttrShape
 * Method:    getInkRect
 */
JNIEXPORT jobject JNICALL Java_org_gnu_pango_AttrShape_getInkRect (JNIEnv *env, jclass cls, jobject obj) 
{
    PangoAttrShape *obj_g = (PangoAttrShape *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, PangoAttrShape_get_inkRect (obj_g));
}

PangoRectangle * PangoAttrShape_get_logicalRect (PangoAttrShape * cptr) 
{
    return (PangoRectangle *)&cptr->logical_rect;
}

/*
 * Class:     org.gnu.pango.AttrShape
 * Method:    getLogicalRect
 */
JNIEXPORT jobject JNICALL Java_org_gnu_pango_AttrShape_getLogicalRect (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    PangoAttrShape *obj_g = (PangoAttrShape *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, PangoAttrShape_get_logicalRect (obj_g));
}

#ifdef __cplusplus
}

#endif
