/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gdk.RgbCmap
 * Method:    gdk_rgb_cmap_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_RgbCmap_gdk_1rgb_1cmap_1new (JNIEnv *env, jclass cls, 
    jintArray colors, jint numColors) 
{
    gint *colors_g = (gint *) (*env)->GetIntArrayElements (env, colors, NULL);
    gint32 numColors_g = (gint32) numColors;
    return getHandleFromPointer(env, gdk_rgb_cmap_new (colors_g, numColors_g));
}

/*
 * Class:     org.gnu.gdk.RgbCmap
 * Method:    gdk_rgb_cmap_free
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_RgbCmap_gdk_1rgb_1cmap_1free (JNIEnv *env, jclass cls, 
    jobject cmap) 
{
    GdkRgbCmap *cmap_g = (GdkRgbCmap *)getPointerFromHandle(env, cmap);
    gdk_rgb_cmap_free (cmap_g);
}


#ifdef __cplusplus
}

#endif
