/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_ActionEntry
#define _Included_org_gnu_gtk_ActionEntry
#ifdef __cplusplus
extern "C" {
#endif


void handleCallback(GtkAction* action, gpointer userData);

/*
 * Class:     org_gnu_gtk_ActionEntry
 * Method:    allocate
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ActionEntry_allocate
  (JNIEnv *env, jclass cls)
{
	GtkActionEntry* entry = (GtkActionEntry*)g_malloc(sizeof(GtkActionEntry));
	entry->callback = G_CALLBACK(handleCallback);
	return (jint)entry;
}

/*
 * Class:     org_gnu_gtk_ActionEntry
 * Method:    free
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionEntry_free
  (JNIEnv *env, jclass cls, jint entry)
{
	GtkActionEntry* e = (GtkActionEntry*)entry;
	g_free(e);
}

/*
 * Class:     org_gnu_gtk_ActionEntry
 * Method:    setName
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionEntry_setName
  (JNIEnv *env, jclass cls, jint entry, jstring name)
{
	if (NULL == name) {
		((GtkActionEntry*)entry)->name = NULL;
	} else {
		gchar* n = (gchar*)(*env)->GetStringUTFChars(env, name, NULL);
		((GtkActionEntry*)entry)->name = n;
	}
}

/*
 * Class:     org_gnu_gtk_ActionEntry
 * Method:    setStockId
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionEntry_setStockId
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkActionEntry*)entry)->stock_id = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkActionEntry*)entry)->stock_id = v;
	}
}

/*
 * Class:     org_gnu_gtk_ActionEntry
 * Method:    setLabel
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionEntry_setLabel
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkActionEntry*)entry)->label = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkActionEntry*)entry)->label = v;
	}
}

/*
 * Class:     org_gnu_gtk_ActionEntry
 * Method:    setAccelerator
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionEntry_setAccelerator
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkActionEntry*)entry)->accelerator = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkActionEntry*)entry)->accelerator = v;
	}
}

/*
 * Class:     org_gnu_gtk_ActionEntry
 * Method:    setTooltip
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionEntry_setTooltip
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkActionEntry*)entry)->tooltip = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkActionEntry*)entry)->tooltip = v;
	}
}


#ifdef __cplusplus
}
#endif
#endif
