/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_input_set_extension_events
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1input_1set_1extension_1events (JNIEnv *env, 
    jclass cls, jint window, jint mask, jint mode) 
{
    GdkWindow *window_g = (GdkWindow *)window;
    gint32 mask_g = (gint32) mask;
    GdkExtensionMode mode_g = (GdkExtensionMode) mode;
    {
        gdk_input_set_extension_events (window_g, mask_g, mode_g);
    }
}


/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_flush
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1flush (JNIEnv *env, jclass cls) 
{
    {
        gdk_flush ();
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_set_locale
 * Signature: ()java.lang.String
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Gdk_gdk_1set_1locale (JNIEnv *env, jclass cls) 
{
    {
        gchar *result_g = gdk_set_locale ();
        return (*env)->NewStringUTF(env, result_g);
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_screen_width
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1screen_1width (JNIEnv *env, jclass cls) 
{
    {
        jint result_j = (jint) (gdk_screen_width ());
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_screen_height
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1screen_1height (JNIEnv *env, jclass cls) 
{
    {
        jint result_j = (jint) (gdk_screen_height ());
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_screen_width_mm
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1screen_1width_1mm (JNIEnv *env, jclass cls) 
{
    {
        jint result_j = (jint) (gdk_screen_width_mm ());
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_screen_height_mm
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1screen_1height_1mm (JNIEnv *env, jclass cls) 
{
    {
        jint result_j = (jint) (gdk_screen_height_mm ());
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_beep
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1beep (JNIEnv *env, jclass cls) 
{
    {
        gdk_beep ();
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_set_show_events
 * Signature: (Z)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1set_1show_1events (JNIEnv *env, jclass cls, 
    jboolean showEvents) 
{
    gboolean showEvents_g = (gboolean) showEvents;
    {
        gdk_set_show_events (showEvents_g);
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_get_show_events
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1get_1show_1events (JNIEnv *env, jclass cls)
{
    {
        jboolean result_j = (jboolean) (gdk_get_show_events ());
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_name
 * Signature: (I)java.lang.String
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1name (JNIEnv *env, jclass cls, 
    jint keyval) 
{
    gchar *result_g = gdk_keyval_name ((gint32)keyval);
    return (*env)->NewStringUTF(env, result_g);
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_from_name
 * Signature: (java.lang.String)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1from_1name (JNIEnv *env, jclass cls, 
    jstring keyvalName) 
{
    const gchar* keyvalName_g = (*env)->GetStringUTFChars(env, keyvalName, 0);
    jint result_j = (jint) (gdk_keyval_from_name (keyvalName_g));
    (*env)->ReleaseStringUTFChars(env, keyvalName, keyvalName_g);
    return result_j;
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_to_upper
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1to_1upper (JNIEnv *env, jclass cls, 
    jint keyval) 
{
    gint32 keyval_g = (gint32) keyval;
    {
        jint result_j = (jint) (gdk_keyval_to_upper (keyval_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_to_lower
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1to_1lower (JNIEnv *env, jclass cls, 
    jint keyval) 
{
    gint32 keyval_g = (gint32) keyval;
    {
        jint result_j = (jint) (gdk_keyval_to_lower (keyval_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_is_upper
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1is_1upper (JNIEnv *env, jclass 
    cls, jint keyval) 
{
    gint32 keyval_g = (gint32) keyval;
    {
        jboolean result_j = (jboolean) (gdk_keyval_is_upper (keyval_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_is_lower
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1is_1lower (JNIEnv *env, jclass 
    cls, jint keyval) 
{
    gint32 keyval_g = (gint32) keyval;
    {
        jboolean result_j = (jboolean) (gdk_keyval_is_lower (keyval_g));
        return result_j;
    }
}

#ifdef __cplusplus
}

#endif
