// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEVFSMM_ASYNC_HANDLE_H
#define _LIBGNOMEVFSMM_ASYNC_HANDLE_H

#include <glibmm.h>

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfs/gnome-vfs-async-ops.h>
#include <libgnomevfs/gnome-vfs-file-info.h>

#include <libgnomevfsmm/enums.h>
#include <libgnomevfsmm/file-info.h>
#include <libgnomevfsmm/uri.h>
#include <libgnomevfsmm/transfer.h>


namespace Gnome
{

namespace Vfs
{

//TODO: Does this have ownership of the underlying C instance? murrayc.
//TODO: What can I do with an instance of this? It has no interesting methods. murrayc.
class FileInfoResult
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FileInfoResult CppObjectType;
  typedef GnomeVFSGetFileInfoResult BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  FileInfoResult();

  //TODO: Why is this void? murrayc.
  explicit FileInfoResult(void* src) { assign_gobj((GnomeVFSGetFileInfoResult*)(src)); }
  ~FileInfoResult();

  GnomeVFSGetFileInfoResult*       gobj()       { return gobject_; }
  const GnomeVFSGetFileInfoResult* gobj() const { return gobject_; }

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  void assign_gobj(GnomeVFSGetFileInfoResult* src);
#endif

protected:
  GnomeVFSGetFileInfoResult* gobject_;
  
private:
  FileInfoResult(const FileInfoResult&);
  FileInfoResult& operator=(const FileInfoResult&);


};

class FindDirectoryResult
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FindDirectoryResult CppObjectType;
  typedef GnomeVFSFindDirectoryResult BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  FindDirectoryResult();
  explicit FindDirectoryResult(void* src) { assign_gobj((GnomeVFSFindDirectoryResult*)(src)); }
  ~FindDirectoryResult();

  GnomeVFSFindDirectoryResult*       gobj()       { return gobject_; }
  const GnomeVFSFindDirectoryResult* gobj() const { return gobject_; }

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  void assign_gobj(GnomeVFSFindDirectoryResult* src);
#endif

protected:
  GnomeVFSFindDirectoryResult* gobject_;
  
private:
  FindDirectoryResult(const FindDirectoryResult&);
  FindDirectoryResult& operator=(const FindDirectoryResult&);


};


/** @addtogroup libgnomevfsmmEnums Enums and Flags */

/**
 * @ingroup libgnomevfsmmEnums
 */
enum FindDirectoryKind
{
  DIRECTORY_KIND_DESKTOP = 1000,
  DIRECTORY_KIND_TRASH
};


namespace Async
{

typedef Glib::ListHandle< Glib::RefPtr<const Uri> > ListHandleUris;

class Handle
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Handle CppObjectType;
  typedef GnomeVFSAsyncHandle BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  Handle();
  ~Handle();

  typedef sigc::slot2<void, const Async::Handle&, Result> SlotOpen;
  typedef SlotOpen SlotClose;
  typedef sigc::slot3<void, const Async::Handle&, const Glib::RefPtr<Glib::IOChannel>&, Result> SlotOpenAsChannel;
  typedef SlotOpenAsChannel SlotCreateAsChannel;
  typedef sigc::slot5<void, const Async::Handle&, Result, gpointer, FileSize, FileSize> SlotRead;
  typedef sigc::slot5<void, const Async::Handle&, Result, gconstpointer, FileSize, FileSize> SlotWrite;
  typedef sigc::slot2<void, const Async::Handle&, Glib::ListHandle<FileInfoResult> > SlotGetFileInfo;
  typedef sigc::slot3<void, const Async::Handle&, Result, const Glib::RefPtr<FileInfo>& > SlotSetFileInfo;
  typedef sigc::slot4<void, const Async::Handle&, Result, Glib::ListHandle<Glib::RefPtr<FileInfo> >, int> SlotLoadDirectory;
  typedef sigc::slot2<int, const Async::Handle&, Transfer::ProgressInfo&> SlotTransferProgress;
  typedef sigc::slot2<void, const Async::Handle&, Glib::ListHandle<FindDirectoryResult> > SlotFindDirectory;
  typedef sigc::slot3<void, const Async::Handle&, Result, gpointer> SlotFileControl;
  typedef void (*DestroyNotify) (gpointer data);

  GnomeVFSAsyncHandle*       gobj()       { return gobject_; }
  const GnomeVFSAsyncHandle* gobj() const { return gobject_; }
  GnomeVFSAsyncHandle**      gobj_addr()  { return &gobject_; }

  void open(const Glib::ustring& text_uri, OpenMode open_mode, int priority, const SlotOpen& slot);
  void open(const Glib::RefPtr<Uri>& uri, OpenMode open_mode, int priority, const SlotOpen& slot);
  
  void open_as_channel(const Glib::ustring& text_uri, OpenMode open_mode, unsigned int advised_block_size, int priority, const SlotOpenAsChannel& slot);
  void open_as_channel(const Glib::RefPtr<Uri>& uri, OpenMode open_mode, unsigned int advised_block_size, int priority, const SlotOpenAsChannel& slot);

  void create(const Glib::ustring& text_uri, OpenMode open_mode, bool exclusive, unsigned int perm, int priority, const SlotOpen& slot);
  void create(const Glib::RefPtr<Uri>& uri, OpenMode open_mode, bool exclusive, unsigned int perm, int priority, const SlotOpen& slot);

  void create_symbolic_link(const Glib::RefPtr<Uri>& uri, const Glib::ustring& uri_reference, int priority, const SlotOpen& slot);

  void create_as_channel(const Glib::ustring& text_uri, OpenMode open_mode, bool exclusive, unsigned int perm, int priority, const SlotCreateAsChannel& slot);
  //TODO: I think this is deprecated or undefined in gnome-vfs -Bryan
  //void create_as_channel(const Glib::RefPtr<Uri> uri, OpenMode open_mode, bool exclusive, unsigned int perm, int priority, const SlotCreateAsChannel& slot);

  void close(const SlotClose& slot);

  void read(gpointer buffer, unsigned int bytes, const SlotRead& slot);
  void write(gconstpointer buffer, unsigned int bytes, const SlotWrite& slot);

  void get_file_info(const ListHandleUris& uri_list, FileInfoOptions options, int priority, const SlotGetFileInfo& slot) const;
  void set_file_info(const Glib::RefPtr<Uri>& uri, const Glib::RefPtr<FileInfo>& info, SetFileInfoMask mask, FileInfoOptions options, int priority, const SlotSetFileInfo& slot);
  
  void load_directory(const Glib::ustring& text_uri, FileInfoOptions options, unsigned int items_per_notification, int priority, const SlotLoadDirectory& slot);
  void load_directory(const Glib::RefPtr<Uri>& uri, FileInfoOptions options, unsigned int items_per_notification, int priority, const SlotLoadDirectory& slot);

  void transfer(const ListHandleUris& source_uri_list, const ListHandleUris& target_uri_list, TransferOptions xfer_options, ErrorMode error_mode, OverwriteMode overwrite_mode, int priority, const SlotTransferProgress& progress_update_callback, const Transfer::SlotProgress& progress_sync_callback);

  //TODO: Maybe this should be const?
  void find_directory(const ListHandleUris& near_uri_list, FindDirectoryKind kind, bool create_if_needed, bool find_if_needed, unsigned int permissions, int priority, const SlotFindDirectory& slot);

  void file_control(const Glib::ustring& operation, gpointer operation_data, DestroyNotify operation_data_destroy_func, const SlotFileControl& slot);

  
  /** Cancel an asynchronous operation and close all its callbacks.
   * Its possible to still receive another call or two on the callback.
   * @param handle Handle of the async operation to be cancelled.
   */
  void cancel();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  void assign_gobj(GnomeVFSAsyncHandle* src);
#endif

protected:
  GnomeVFSAsyncHandle* gobject_;
  
private:
  Handle(const Handle&);
  Handle& operator=(const Handle&);


};

} // namespace Async
} // namespace Vfs
} // namespace Gnome

#endif /* _LIBGNOMEVFSMM_ASYNC_HANDLE_H */

