/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 16:40:20 EDT
 */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
public class Cursor extends Boxed {

	/**
	*	Creates a new cursor from the set of builtin cursors.
	*/
	public Cursor(CursorType ctype) {
		handle = gdk_cursor_new(ctype.getValue());
	}

	/**
	 * Create a new cursor from a pixmap.
	 */
	public Cursor(Pixmap source, Pixmap mask, Color fg, Color bg, int x, int y) {
		handle = gdk_cursor_new_from_pixmap(source.getHandle(), mask.getHandle(),
				fg.getHandle(), bg.getHandle(), x, y);
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int getType(int obj);
	native static final protected int gdk_cursor_new(int cursorType);
	native static final protected int gdk_cursor_new_from_pixmap(int source,
		int mask, int fg, int bg, int x, int y);
	native static final protected int gdk_cursor_ref(int cursor);
	native static final protected void gdk_cursor_unref(int cursor);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
