/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 13:44:44 EDT
 */

package org.gnu.pango;
import org.gnu.glib.GObject;
/**
 * The PangoContext structure stores global information used to control the itemization process. It contains the following fields: 
 */
public class Context extends GObject 
{
	
	/**
	 * Create a new Context passing a handle that was created in the
	 * native layer.
	 * 
	 * @param The handle to a native resource.
	 */
	public Context(int handle) {
		this.handle = handle;
	}

	/**
	 * Retrieve the default font description for the context.
	 * @return default font description.
	 */
	public FontDescription getFontDescription(){
		return new FontDescription( pango_context_get_font_description(handle) );
	}

	/**
	 * Sets the font description
	 */
	public void setFontDescription(FontDescription desc){
		pango_context_set_font_description(handle, desc.getHandle());
	}

	/**
	 * Retrieves the global language tag for the context.
	 */
	public Language getLanguage(){
		return new Language(pango_context_get_language(handle));
	}

	/**
	 * Sets the language
	 */
	public void setLanguage(Language lang){
		pango_context_set_language(handle, lang.getHandle());
	}

	/**
	 * Retrieves the base direction for the context.
	 */
	public Direction getBaseDir(){
		return Direction.intern( pango_context_get_base_dir(handle) );
	}

	/**
	 * Sets the base direction for the context.
	 */
	public void setBaseDir(Direction dir){
		pango_context_set_base_dir(handle, dir.getValue());
	}

	/**
	 * Loads the font in one of the fontmaps in the context that is the closest
	 * match for desc.
	 * @param desc A FontDescription describing the font to load
	 * @return The font loaded, or <code>null</code> if no font matched.
	 */
	public FontDescription loadFont(FontDescription desc){
		if( pango_context_load_fontNULL(handle, desc.getHandle())){
			return null;
		}else{
			return new FontDescription( pango_context_load_font(handle, desc.getHandle()));
		}
	}
	native static final protected boolean 	pango_context_load_fontNULL(int handle, int desc);

	/**
	 * Get overall metric information for a font particular font description.
	 * Since the metrics may be substantially different for different scripts, a
	 * language tag can be provided to indicate that the metrics should be
	 * retrieved that correspond to the script(s) used by that language.  <p>The
	 * PangoFontDescription is interpreted in the same way as by
	 * pango_itemize(), and the family name may be a comma separated list of
	 * figures. If characters from multiple of these families would be used to
	 * render the string, then the returned fonts would be a composite of the
	 * metrics for the fonts loaded for the individual families.
	 */
	public FontMetrics getMetrics(FontDescription desc, Language language){
		return new FontMetrics( pango_context_get_metrics (handle, desc.getHandle(), language.getHandle()));
	}

	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int pango_context_get_type ();
    native static final protected void pango_context_list_families (int context, int [] families, 
        int [] numFamilies);
    native static final protected int pango_context_load_font (int context, int desc);
    native static final protected int pango_context_get_metrics (int context, int desc, int 
        language);
    native static final protected void pango_context_set_font_description (int context, int desc);
    native static final protected int pango_context_get_font_description (int context);
    native static final protected int pango_context_get_language (int context);
    native static final protected void pango_context_set_language (int context, int language);
    native static final protected void pango_context_set_base_dir (int context, int direction);
    native static final protected int pango_context_get_base_dir (int context);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

