/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:40 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;



/**
 * The ToolBar is used to construct a toolbar. It is the container
 * that controls the position of a set of icons that are mouse
 * sensitive.
 */
public class ToolBar extends Container {
	
	/**
	 * Create a new ToolBar
	 */
	public ToolBar() {
		noopInit();
	}
	
	protected void noopInit() {
		if (-1 == handle) {
			handle = ToolBar.gtk_toolbar_new();
			initializeEventHandlers();
		}
	}
	
	/**
	 * Add a widget to the end of the toolbar.
	 * 
	 * @param widget The widget to add to the end of the ToolBar.
	 * @param tooltip The text for the tooltip for this item.
	 * @param helpText Context sensitive help about this item.
	 */
	public void appendWidget(Widget widget, String tooltip, String helpText) {
		ToolBar.gtk_toolbar_append_widget(handle, widget.getHandle(), tooltip, helpText);
	}
	
	/**
	 * Add a widget to the beginning of the toolbar.
	 * 
	 * @param widget The widget to add to the beginning of the ToolBar.
	 * @param tooltip The text for the tooltip for this item.
	 * @param helpText Context sensitive help about this item.
	 */
	public void prependWidget(Widget widget, String tooltip, String helpText) {
		ToolBar.gtk_toolbar_prepend_widget(handle, widget.getHandle(), tooltip, helpText);
	}
	
	/**
	 * Insert a Widget in the ToolBar at the given position
	 * 
	 * @param widget The widget to add to the ToolBar.
	 * @param tooltip The text for the tooltip for this item.
	 * @param helpText Context sensitive help about this item.
	 * @param index The location in the ToolBar to insert this Widget.
	 */
	public void insertWidget(Widget widget, String tooltip, String helpText, int index) {
		ToolBar.gtk_toolbar_insert_widget(handle, widget.getHandle(), tooltip, helpText, index);
	}
	
	/**
	 * Add a space to the end of the ToolBar.
	 */
	public void appendSpace() {
		ToolBar.gtk_toolbar_append_space(handle);
	}
	
	/**
	 * Add a space to the beginning of the ToolBar.
	 */
	public void prependSpace() {
		ToolBar.gtk_toolbar_prepend_space(handle);
	}
	
	/**
	 * Insert a space in the ToolBar at the specified location.
	 * 
	 * @param position The location to insert the space.
	 */
	public void insertSpace(int position) {
		ToolBar.gtk_toolbar_insert_space(handle, position);
	}
	
	/**
	 * Remove a space from the ToolBar.
	 * 
	 * @param position The position of the space to remove.
	 */
	public void removeSpace(int position) {
		ToolBar.gtk_toolbar_remove_space(handle, position);
	}
	
	/**
	 * Set whether the ToolBar should appear horizontally or vertically.
	 * 
	 * @param orientation Specifies the direction of the ToolBar.
	 */
	public void setOrientation(Orientation orientation) {
		ToolBar.gtk_toolbar_set_orientation(handle, orientation.getValue());
	}
	
	/**
	 * Alter the view of the ToolBar to display either icons only, text only,
	 * or both.
	 * 
	 * @param style Determines how to display the items.
	 */
	public void setStyle(ToolBarStyle style) {
		ToolBar.gtk_toolbar_set_style(handle, style.getValue());
	}
	
	/**
	 * Sets if the tooltips of the ToolBar should be active or not.
	 * 
	 * @param enable Should the tooltips be enabled.
	 */
	public void setToolTips(boolean enable) {
		ToolBar.gtk_toolbar_set_tooltips(handle, enable);
	}
	
	/**
	 * Sets the size of the stock icons in the ToolBar.
	 * 
	 * @param iconSize The size of the icons.
	 */
	public void setIconSize(IconSize iconSize) {
		ToolBar.gtk_toolbar_set_icon_size(handle, iconSize.getValue());
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_toolbar_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_toolbar_get_type();
	native static final protected int gtk_toolbar_new();
	native static final protected void gtk_toolbar_append_space(int toolbar);
	native static final protected void gtk_toolbar_prepend_space(int toolbar);
	native static final protected void gtk_toolbar_insert_space(int toolbar, int position);
	native static final protected void gtk_toolbar_remove_space(int toolbar, int position);
	native static final protected void gtk_toolbar_append_widget(int Toolbar, int Widget, String tooltipText, String tooltipPrivateText);
	native static final protected void gtk_toolbar_prepend_widget(int Toolbar, int Widget, String tooltipText, String tooltipPrivateText);
	native static final protected void gtk_toolbar_insert_widget(int toolbar, int widget, String tooltipText, String tooltipPrivateText, int position);
	native static final protected void gtk_toolbar_set_orientation(int toolbar, int orientation);
	native static final protected void gtk_toolbar_set_style(int toolbar, int style);
	native static final protected void gtk_toolbar_set_icon_size(int toolbar, int iconSize);
	native static final protected void gtk_toolbar_set_tooltips(int toolbar, boolean enable);
	native static final protected void gtk_toolbar_unset_style(int toolbar);
	native static final protected void gtk_toolbar_unset_icon_size(int toolbar);
	native static final protected int gtk_toolbar_get_orientation(int toolbar);
	native static final protected int gtk_toolbar_get_style(int toolbar);
	native static final protected int gtk_toolbar_get_icon_size(int toolbar);
	native static final protected boolean gtk_toolbar_get_tooltips(int toolbar);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
