// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREESELECTION_H
#define _GTKMM_TREESELECTION_H

#include <glibmm.h>

/* $Id: treeselection.hg,v 1.1.1.1 2003/01/21 13:40:50 murrayc Exp $ */

/* Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/enums.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treeiter.h>
#include <gtkmm/treepath.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeSelection GtkTreeSelection;
typedef struct _GtkTreeSelectionClass GtkTreeSelectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeSelection_Class; } // namespace Gtk
namespace Gtk
{

class TreeView;
class TreeModel;
class TreePath;

/** Typedefed as Gtk::TreeView::Selection.
 * This is a helper object to manage the selection for a Gtk::TreeView widget.
 *
 * It is automatically created when a new Gtk::TreeView widget is created, and
 * cannot exist independently of this widget.  The primary reason this class
 * exists is for cleanliness of code and API. That is, there is no conceptual
 * reason all these methods could not be methods on the Gtk::TreeView widget
 * instead of a separate class.
 *
 * The Gtk::TreeSelection object can be obtained from a Gtk::TreeView by
 * calling Gtk::TreeView::get_selection().  It can be manipulated to check the
 * selection status of the tree, as well as to select and deselect individual
 * rows.  Selection is done completely view-side. As a result, multiple views
 * of the same model can have completely different selections.  Additionally,
 * you cannot change the selection of a row on the model that is not currently
 * displayed by the view without expanding its parents first.
 *
 * When monitoring the selection of a view, it's important to remember that the
 * "changed" signal is mostly a hint. That is, it may only emit one signal when
 * a range of rows is selected. Additionally, it may on occasion emit a
 * "changed" signal when nothing has happened.
 *
 * @ingroup TreeView
 */

class TreeSelection : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TreeSelection CppObjectType;
  typedef TreeSelection_Class CppClassType;
  typedef GtkTreeSelection BaseObjectType;
  typedef GtkTreeSelectionClass BaseClassType;

private:  friend class TreeSelection_Class;
  static CppClassType treeselection_class_;

private:
  // noncopyable
  TreeSelection(const TreeSelection&);
  TreeSelection& operator=(const TreeSelection&);

protected:
  explicit TreeSelection(const Glib::ConstructParams& construct_params);
  explicit TreeSelection(GtkTreeSelection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TreeSelection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkTreeSelection*       gobj()       { return reinterpret_cast<GtkTreeSelection*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkTreeSelection* gobj() const { return reinterpret_cast<GtkTreeSelection*>(gobject_); }

  GtkTreeSelection* gobj_copy();

private:

   
protected:
  

public:
  
  void set_mode(SelectionMode type);
  
  SelectionMode get_mode() const;

  /// e.g. on_select_function(const Glib::RefPtr<TreeModel>& model, const TreeModel::Path& path, bool path_currently_selected)
  typedef SigC::Slot3<bool, const Glib::RefPtr<TreeModel>&, const TreeModel::Path&, bool> SlotSelect;
  void set_select_function(const SlotSelect& slot);

   // This would be our SignalProxy_Select* data.

  
  TreeView* get_tree_view();
  
  const TreeView* get_tree_view() const;

  /** Shortcut for get_tree_view()->get_model().
   * @return The TreeModel associated with this TreeSelection.
   */
  Glib::RefPtr<TreeModel> get_model(); // convenience function, not in GTK+
  Glib::RefPtr<const TreeModel> get_model() const; // convenience function, not in GTK+

  /** Get the currently selected row.
   * @return The currently selected row.
   * @note
   * This method won't work if the selection mode is <tt>Gtk::SELECTION_MULTIPLE</tt>.
   * Use selected_foreach() for multiple selections.
   */
  TreeModel::iterator get_selected();

  /** Get the currently selected row.
   * @return The currently selected row. Or NULL if no rows were selected.
   * @retval model The current TreeModel.
   * @note
   * This method won't work if the selection mode is <tt>Gtk::SELECTION_MULTIPLE</tt>.
   * Use selected_foreach() for multiple selections.
   */
  TreeModel::iterator get_selected(Glib::RefPtr<TreeModel>& model);

  
  typedef SigC::Slot1<void, const TreeModel::iterator&> SlotForeachIter;
  void selected_foreach(const SlotForeachIter& slot);

  typedef SigC::Slot1<void, const TreeModel::Path&> SlotForeachPath;
  void selected_foreach(const SlotForeachPath& slot);

  typedef SigC::Slot2<void, const TreeModel::Path&, const TreeModel::iterator&> SlotForeachPathAndIter;
  void selected_foreach(const SlotForeachPathAndIter& slot);

  
  void select(const TreeModel::Path& path);
  
  void select(const TreeModel::iterator& iter);
  
  void select(const TreeModel::Row& row);
  
  void select(const TreeModel::Path& start_path, const TreeModel::Path& end_path);

  
  void unselect(const TreeModel::Path& path);
  
  void unselect(const TreeModel::Path& start_path, const TreeModel::Path& end_path);
  
  void unselect(const TreeModel::iterator& iter);

  
  bool is_selected(const TreeModel::Path& path) const;
  
  bool is_selected(const TreeModel::iterator& iter) const;
  
  
  void select_all();
  
  void unselect_all();

  typedef Glib::ListHandle<TreeModel::Path, TreePath_Traits> ListHandle_Path;
  ListHandle_Path get_selected_rows() const;
  ListHandle_Path get_selected_rows(Glib::RefPtr<TreeModel>& model);
    
  
  int count_selected_rows() const;                                                
  
  
  /**
   * @par Prototype:
   * <tt>void %changed()</tt>
   */
  Glib::SignalProxy0< void > signal_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_changed();


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::TreeSelection */
  Glib::RefPtr<Gtk::TreeSelection> wrap(GtkTreeSelection* object, bool take_copy = false);
}


#endif /* _GTKMM_TREESELECTION_H */

