// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_PRINTJOB_H
#define _GTKMM_PRINTJOB_H


#include <glibmm.h>

/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gtkmm/pagesetup.h>
#include <gtkmm/printer.h>
#include <gtkmm/printoperation.h>
#include <gtkmm/printsettings.h>
#include <cairomm/surface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkPrintJob GtkPrintJob;
typedef struct _GtkPrintJobClass GtkPrintJobClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class PrintJob_Class; } // namespace Gtk
namespace Gtk
{

/** A PrintJob object represents a job that is sent to a printer. You only need to deal 
 * directly with print jobs if you  use the non-portable PrintUnixDialog API.
 * 
 * Use get_surface() to obtain the cairo surface onto which the pages must be drawn. 
 * Use send() to send the finished job to the printer.If you don't use cairo then 
 * PrintJob also supports printing of manually generated postscript, via set_source_file().
 * 
 * @newin{2,10}
 *
 * @ingroup Printing
 */

class PrintJob : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef PrintJob CppObjectType;
  typedef PrintJob_Class CppClassType;
  typedef GtkPrintJob BaseObjectType;
  typedef GtkPrintJobClass BaseClassType;

private:  friend class PrintJob_Class;
  static CppClassType printjob_class_;

private:
  // noncopyable
  PrintJob(const PrintJob&);
  PrintJob& operator=(const PrintJob&);

protected:
  explicit PrintJob(const Glib::ConstructParams& construct_params);
  explicit PrintJob(GtkPrintJob* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~PrintJob();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkPrintJob*       gobj()       { return reinterpret_cast<GtkPrintJob*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkPrintJob* gobj() const { return reinterpret_cast<GtkPrintJob*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkPrintJob* gobj_copy();

private:

  //This is not available in on Win32.
//This source file will not be compiled,
//and the class will not be registered in wrap_init.h or wrap_init.cc


protected:
  explicit PrintJob(const Glib::ustring& title, const Glib::RefPtr<Printer>& printer, const Glib::RefPtr<PrintSettings>& settings, const Glib::RefPtr<PageSetup>& page_setup);

public:
  
  static Glib::RefPtr<PrintJob> create(const Glib::ustring& title, const Glib::RefPtr<Printer>& printer, const Glib::RefPtr<PrintSettings>& settings, const Glib::RefPtr<PageSetup>& page_setup);


  /** Gets the Gtk::PrintSettings of the print job.
   * @return The settings of @a job
   * 
   * @newin{2,10}.
   */
  Glib::RefPtr<PrintSettings> get_settings();
  
  /** Gets the Gtk::PrintSettings of the print job.
   * @return The settings of @a job
   * 
   * @newin{2,10}.
   */
  Glib::RefPtr<const PrintSettings> get_settings() const;

  
  /** Gets the Gtk::Printer of the print job.
   * @return The printer of @a job
   * 
   * @newin{2,10}.
   */
  Glib::RefPtr<Printer> get_printer();
  
  /** Gets the Gtk::Printer of the print job.
   * @return The printer of @a job
   * 
   * @newin{2,10}.
   */
  Glib::RefPtr<const Printer> get_printer() const;

  
  /** Gets the job title.
   * @return The title of @a job
   * 
   * @newin{2,10}.
   */
  Glib::ustring get_title() const;
  
  /** Gets the status of the print job.
   * @return The status of @a job
   * 
   * @newin{2,10}.
   */
  PrintStatus get_status() const;
   // this appears in gtkprinter-private.h
  
  /** Make the Gtk::PrintJob send an existing document to the 
   * printing system. The file can be in any format understood
   * by the platforms printing system (typically PostScript,
   * but on many platforms PDF may work too). See 
   * Gtk::Printer::accepts_pdf() and Gtk::Printer::accepts_ps().
   * @param filename The file to be printed.
   * @return <tt>false</tt> if an error occurred
   * 
   * @newin{2,10}.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void set_source_file(const std::string& filename);
#else
  void set_source_file(const std::string& filename, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Gets a cairo surface onto which the pages of
   * the print job should be rendered.
   * @return The cairo surface of @a job
   * 
   * @newin{2,10}.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Cairo::RefPtr<Cairo::Surface> get_surface();
#else
  Cairo::RefPtr<Cairo::Surface> get_surface(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Gets a cairo surface onto which the pages of
   * the print job should be rendered.
   * @return The cairo surface of @a job
   * 
   * @newin{2,10}.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Cairo::RefPtr<const Cairo::Surface> get_surface() const;
#else
  Cairo::RefPtr<const Cairo::Surface> get_surface(std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** If track_status is <tt>true</tt>, the print job will try to continue report
   * on the status of the print job in the printer queues and printer. This
   * can allow your application to show things like "out of paper" issues,
   * and when the print job actually reaches the printer.
   * 
   * This function is often implemented using some form of polling, so it should
   * not be enabled unless needed.
   * 
   * @newin{2,10}
   * @param track_status <tt>true</tt> to track status after printing.
   */
  void set_track_print_status(bool track_status = true);
  
  /** Return value: <tt>true</tt> if print job status will be reported after printing
   * @return <tt>true</tt> if print job status will be reported after printing
   * 
   * @newin{2,10}.
   */
  bool get_track_print_status() const;

  
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  /** For example, 
   * void on_print_job_complete(const Glib::RefPtr<PrintJob>& job);
   *
   * @throws exception
   */
  typedef sigc::slot< void, const Glib::RefPtr<PrintJob>& > SlotPrintJobComplete;
  #else
  /** For example, 
   * void on_print_job_complete(const Glib::RefPtr<PrintJob>& job, std::auto_ptr<Glib::Error>& error);
   */
  typedef sigc::slot< void, const Glib::RefPtr<PrintJob>&, std::auto_ptr<Glib::Error>& > SlotPrintJobComplete;
  #endif

  /** Sends the print job off to the printer.
   * @param slot A function to call when the job completes or an error occurs.
   */
  void send(const SlotPrintJobComplete& slot);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%status_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_status_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Title of the print job.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Printer to print the job to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Printer> > property_printer() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Printer settings.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PrintSettings> > property_settings() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Page Setup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PageSetup> > property_page_setup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_status_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::PrintJob
   */
  Glib::RefPtr<Gtk::PrintJob> wrap(GtkPrintJob* object, bool take_copy = false);
}


#endif /* _GTKMM_PRINTJOB_H */

