/*
 * Copyright (c) 2003 by the gtk2-perl team (see the file AUTHORS)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 * Boston, MA  02111-1307  USA.
 *
 * $Id: GtkMenuItem.xs 2067 2008-10-18 22:24:19Z tsch $
 */

#include "gtk2perl.h"
#include <gperl_marshal.h>

/*

  void (* toggle_size_request)  (GtkMenuItem *menu_item,
                                 gint        *requisition);

*/

static void
gtk2perl_menu_item_toggle_size_request_marshal (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data)
{
	gint * requisition;
	dGPERL_CLOSURE_MARSHAL_ARGS;

	GPERL_CLOSURE_MARSHAL_INIT (closure, marshal_data);

	PERL_UNUSED_VAR (return_value);
	PERL_UNUSED_VAR (n_param_values);
	PERL_UNUSED_VAR (invocation_hint);

	ENTER;
	SAVETMPS;

	PUSHMARK (SP);

	GPERL_CLOSURE_MARSHAL_PUSH_INSTANCE (param_values);

	requisition = g_value_get_pointer (param_values+1);

	GPERL_CLOSURE_MARSHAL_PUSH_DATA;

	PUTBACK;

	GPERL_CLOSURE_MARSHAL_CALL (G_SCALAR);

	if (count == 1) {
		*requisition = POPi;
	} else {
		/* NOTE: croaking here can cause bad things to happen to the
		 * app, because croaking in signal handlers is bad juju. */
		croak ("an toggle-size-request signal handler must return one "
		       "item (the requisition), but the callback returned %d "
		       "items", count);
	}

	PUTBACK;
	FREETMPS;
	LEAVE;
}

MODULE = Gtk2::MenuItem	PACKAGE = Gtk2::MenuItem	PREFIX = gtk_menu_item_

BOOT:
	gperl_signal_set_marshaller_for (GTK_TYPE_MENU_ITEM, "toggle_size_request",
	                                 gtk2perl_menu_item_toggle_size_request_marshal);

GtkWidget*
gtk_menu_item_new (class, label=NULL)
	const gchar * label
    ALIAS:
	Gtk2::MenuItem::new_with_mnemonic = 1
	Gtk2::MenuItem::new_with_label = 2
    CODE:
	if (label) {
		if (ix == 2)
			RETVAL = gtk_menu_item_new_with_label (label);
		else
			RETVAL = gtk_menu_item_new_with_mnemonic (label);
	} else
		RETVAL = gtk_menu_item_new ();
    OUTPUT:
	RETVAL

void
gtk_menu_item_set_submenu (menu_item, submenu)
	GtkMenuItem *menu_item
	GtkWidget_ornull *submenu

GtkWidget_ornull*
gtk_menu_item_get_submenu (menu_item)
	GtkMenuItem *menu_item

void
gtk_menu_item_remove_submenu (menu_item)
	GtkMenuItem *menu_item

void
gtk_menu_item_select (menu_item)
	GtkMenuItem *menu_item

void
gtk_menu_item_deselect (menu_item)
	GtkMenuItem *menu_item

void
gtk_menu_item_activate (menu_item)
	GtkMenuItem *menu_item

void gtk_menu_item_toggle_size_request (GtkMenuItem *menu_item, OUTLIST gint requisition)

void
gtk_menu_item_toggle_size_allocate (menu_item, allocation)
	GtkMenuItem *menu_item
	gint allocation

void
gtk_menu_item_set_right_justified (menu_item, right_justified)
	GtkMenuItem *menu_item
	gboolean right_justified

gboolean
gtk_menu_item_get_right_justified (menu_item)
	GtkMenuItem *menu_item

void
gtk_menu_item_set_accel_path (menu_item, accel_path)
	GtkMenuItem *menu_item
	const gchar *accel_path

 ##void _gtk_menu_item_refresh_accel_path (GtkMenuItem *menu_item, const gchar *prefix, GtkAccelGroup *accel_group, gboolean group_changed)

#if GTK_CHECK_VERSION (2, 14, 0)

const gchar* gtk_menu_item_get_accel_path (GtkMenuItem *menu_item);

#endif /* 2.14 */
