// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _PANGOMM_FONTFAMILY_H
#define _PANGOMM_FONTFAMILY_H


#include <glibmm.h>

/* $Id: fontfamily.hg,v 1.2 2004/03/03 01:07:40 murrayc Exp $ */

/* fontfamily.h
 * 
 * Copyright 2001      The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>
#include <glibmm/arrayhandle.h>
#include <pangomm/fontface.h>
#include <pango/pango-font.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _PangoFontFamily PangoFontFamily;
typedef struct _PangoFontFamilyClass PangoFontFamilyClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{ class FontFamily_Class; } // namespace Pango
namespace Pango
{

/** A Pango::FontFamily is used to represent a family of related font faces.
 * The faces in a family share a common design, but differ in slant, weight, width and other aspects.
 */

class FontFamily : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef FontFamily CppObjectType;
  typedef FontFamily_Class CppClassType;
  typedef PangoFontFamily BaseObjectType;
  typedef PangoFontFamilyClass BaseClassType;

private:  friend class FontFamily_Class;
  static CppClassType fontfamily_class_;

private:
  // noncopyable
  FontFamily(const FontFamily&);
  FontFamily& operator=(const FontFamily&);

protected:
  explicit FontFamily(const Glib::ConstructParams& construct_params);
  explicit FontFamily(PangoFontFamily* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~FontFamily();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  PangoFontFamily*       gobj()       { return reinterpret_cast<PangoFontFamily*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const PangoFontFamily* gobj() const { return reinterpret_cast<PangoFontFamily*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  PangoFontFamily* gobj_copy();

private:

   
public:
  /** Lists the different font faces that make up family.
   * The faces in a family share a common design, but differ in slant, weight, width and other aspects.
   * @return an array of pointers to Pango::FontFace objects.
   */
  Glib::ArrayHandle< Glib::RefPtr<FontFace> > list_faces() const;

  
  /** Gets the name of the family. The name is unique among all
   * fonts for the font backend and can be used in a Pango::FontDescription
   * to specify that a face from this family is desired.
   * @return The name of the family. This string is owned
   * by the family object and must not be modified or freed.
   */
  Glib::ustring get_name() const;
  
  /** A monospace font is a font designed for text display where the the
   * characters form a regular grid. For Western languages this would
   * mean that the advance width of all characters are the same, but
   * this categorization also includes Asian fonts which include
   * double-width characters: characters that occupy two grid cells.
   * Glib::unichar_iswide() returns a result that indicates whether a
   * character is typically double-width in a monospace font.
   * 
   * The best way to find out the grid-cell size is to call
   * pango_font_metrics_get_approximate_digit_width(), since the results
   * of pango_font_metrics_get_approximate_char_width() may be affected
   * by double-width characters.
   * @return <tt>true</tt> if the family is monospace.
   */
  bool is_monospace() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

/*
struct FontFamilyRefPtrTraits
{
  typedef Glib::RefPtr<FontFamily> CppType;
  typedef PangoFontFamily *        CType;
  typedef PangoFontFamily *        CTypeNonConst;

  static CType   to_c_type      (const CppType& ptr) { return Glib::unwrap (ptr);                   }
  static CType   to_c_type      (CType          ptr) { return ptr;                                  }
  static CppType to_cpp_type    (CType          ptr) { return FontFamily::wrap_specific_type (ptr); }
  static void    release_c_type (CType          ptr) { g_object_unref (ptr);                        }
};
*/

} // namespace Pango


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Pango::FontFamily
   */
  Glib::RefPtr<Pango::FontFamily> wrap(PangoFontFamily* object, bool take_copy = false);
}


#endif /* _PANGOMM_FONTFAMILY_H */

